/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc;

import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_ipservice.QAsnEthXCInfo;
import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TECreateEthXCEVPL;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEDelEthXCHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCNESlotKey;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ECreateError;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ELog;
import com.huawei.nglct.nemgr.ip.ngwdm.service_v2r6c01.TECreateEVPLBean;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherEVPLContainer;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherEVPLMOPO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class TEActiveEthXCEVPL {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    private TEActiveEthXCEVPL() {
    }

    public static int activeEVPL(QAsnEthXCInfo ethXCInfo, QAsnErrInfoList rspErrInfoList, List<QAsnEthXCInfo> activeSuccAsnEVPLList, Map<TEEthXCNESlotKey, TEEtherEVPLContainer> evplContainerMap) {
        ArrayList<QAsnEthXCInfo> unDirAsnEVPLList;
        List<TEEtherEVPLMOPO> evplMOList;
        String FUNC_NAME = "TEActiveEthXCHandler.activeEVPL";
        TEEthE2ELog.logFuncBegin("TEActiveEthXCHandler.activeEVPL");
        if (null == ethXCInfo) {
            TELogFactory.getE2ELogger().error("ethXCInfo is null!");
            return 1090646019;
        }
        if (null == rspErrInfoList) {
            TELogFactory.getE2ELogger().error("rspErrInfoList is null!");
            return 1090646019;
        }
        if (null == activeSuccAsnEVPLList) {
            TELogFactory.getE2ELogger().error("activeSuccAsnEVPLList is null!");
            return 1090646019;
        }
        if (null == evplContainerMap) {
            TELogFactory.getE2ELogger().error("evplContainerMap is null!");
            return 1090646019;
        }
        int retCode = 0;
        int neID = ethXCInfo.xcIndex.neID;
        int slotID = ethXCInfo.xcIndex.slotID;
        TEEtherEVPLContainer container = evplContainerMap.get(new TEEthXCNESlotKey(neID, slotID));
        if (null == container) {
            container = TEEthXCUtil.getContainer(neID, slotID);
            evplContainerMap.put(new TEEthXCNESlotKey(neID, slotID), container);
        }
        if ((evplMOList = TEEthXCUtil.getEVPLMOFromDB(ethXCInfo, unDirAsnEVPLList = new ArrayList<QAsnEthXCInfo>(), container)).isEmpty()) {
            retCode = 1090598186;
            rspErrInfoList.addAll(TEEthE2ECreateError.createQAsnErrInfo(retCode, ethXCInfo));
            TEEthE2ELog.logFuncEnd("TEActiveEthXCHandler.activeEVPL");
            return retCode;
        }
        int linkID = -1;
        QAsnEthXCInfo asnEVPL = null;
        int len = unDirAsnEVPLList.size();
        for (int i = 0; i < len; ++i) {
            retCode = 0;
            TEEtherEVPLMOPO evplMO = evplMOList.get(i);
            linkID = evplMO.getIDNE();
            asnEVPL = (QAsnEthXCInfo)unDirAsnEVPLList.get(i);
            asnEVPL.xcIndex.xcID = linkID;
            if (1 == evplMO.getActivateState()) {
                TEActiveEthXCEVPL.logLinkAlreadyActiveError(neID, slotID, linkID);
                TEEthE2ELog.logFuncEnd("TEActiveEthXCHandler.activeEVPL");
                return 0;
            }
            retCode = TEActiveEthXCEVPL.activeEVPLToNE(asnEVPL, rspErrInfoList);
            if (0 != retCode) {
                TEActiveEthXCEVPL.logCreateEVPLToNEError(retCode, neID, slotID);
                TEEthE2ELog.logFuncEnd("TEActiveEthXCHandler.activeEVPL");
                return retCode;
            }
            retCode = TEEthXCUtil.activeEVPLFromDB(asnEVPL, (short)1, container);
            if (0 != retCode) {
                TEActiveEthXCEVPL.logActiveEVPLFromDBError(retCode, neID, slotID);
                rspErrInfoList.addAll(TEEthE2ECreateError.createQAsnErrInfo(retCode, asnEVPL));
                TEEthE2ELog.logFuncEnd("TEActiveEthXCHandler.activeEVPL");
                return retCode;
            }
            activeSuccAsnEVPLList.add(asnEVPL);
        }
        TEEthE2ELog.logFuncEnd("TEActiveEthXCHandler.activeEVPL");
        return retCode;
    }

    private static int activeEVPLToNE(QAsnEthXCInfo asnEVPL, QAsnErrInfoList asnRsnErrList) {
        String FUNC_NAME = "TEActiveEthXCHandler.createEVPLToNE";
        TEEthE2ELog.logFuncBegin("TEActiveEthXCHandler.createEVPLToNE");
        int neID = asnEVPL.xcIndex.neID;
        int slotID = asnEVPL.xcIndex.slotID;
        int serviceType = asnEVPL.xcIndex.xcType;
        int linkType = asnEVPL.xcIndex.linkType;
        int direction = asnEVPL.xcAttr.direction;
        int sfid = TECreateEthXCEVPL.getSfid(serviceType, linkType, direction);
        TENEMgrInterface bean = TEActiveEthXCEVPL.getCreateEVPLBean(neID, sfid);
        SubFunc subFunc = TEEthXCUtil.createSubFunc(neID, sfid);
        Datainterface inputData = TECreateEthXCEVPL.createCreateInputData(asnEVPL);
        Datainterface outputData = bean.performBussinessProcess(neID, subFunc, inputData, null, null, null);
        if (null == outputData) {
            TEActiveEthXCEVPL.logOutputDataNullError(neID, slotID, inputData);
            TEEthE2ELog.logFuncEnd("TEActiveEthXCHandler.createEVPLToNE");
            return 1090646019;
        }
        int retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != retCode) {
            TEActiveEthXCEVPL.logCreateEvplBeanOperError(neID, slotID, inputData, retCode);
            TEEthXCUtil.fillErrorToRsp(neID, slotID, outputData, asnRsnErrList);
        }
        TEEthE2ELog.logFuncEnd("TEActiveEthXCHandler.createEVPLToNE");
        return retCode;
    }

    public static int unActiveEVPL(QAsnEthXCInfo asnEVPL, QAsnErrInfoList rspAsnErrList, Map<TEEthXCNESlotKey, TEEtherEVPLContainer> evplContainerMap) {
        String FUNC_NAME = "TEActiveEthXCHandler.unActiveEVPL";
        TEEthE2ELog.logFuncBegin("TEActiveEthXCHandler.unActiveEVPL");
        int neID = asnEVPL.xcIndex.neID;
        int slotID = asnEVPL.xcIndex.slotID;
        TEEtherEVPLContainer container = evplContainerMap.get(new TEEthXCNESlotKey(neID, slotID));
        if (null == container) {
            container = TEEthXCUtil.getContainer(neID, slotID);
            evplContainerMap.put(new TEEthXCNESlotKey(neID, slotID), container);
        }
        boolean isAllUnActive = true;
        ArrayList<QAsnEthXCInfo> unDirXCInfoList = new ArrayList<QAsnEthXCInfo>();
        List<TEEtherEVPLMOPO> evplMOList = TEEthXCUtil.getEVPLMOFromDB(asnEVPL, unDirXCInfoList, container);
        for (TEEtherEVPLMOPO tempEvplMO : evplMOList) {
            if (1 != tempEvplMO.getActivateState()) continue;
            isAllUnActive = false;
            break;
        }
        if (isAllUnActive) {
            TEActiveEthXCEVPL.logAlreadyUnActiveError(neID, slotID);
            TEEthE2ELog.logFuncEnd("TEActiveEthXCHandler.unActiveEVPL");
            return 0;
        }
        ArrayList<Integer> delLinkIDList = new ArrayList<Integer>();
        int retCode = TEDelEthXCHandler.delEvplFromNENoDB(neID, asnEVPL, rspAsnErrList, delLinkIDList, container);
        if (0 == retCode) {
            if (null == container) {
                TEActiveEthXCEVPL.logContainerNullError();
                TEEthE2ELog.logFuncEnd("TEActiveEthXCHandler.unActiveEVPL");
                return 1092743443;
            }
            for (Integer linkID : delLinkIDList) {
                TEEthXCUtil.unActiveEvplInContainer(container, linkID);
                TEEthServiceOAMUtil.deleteElineOAM(neID, slotID, linkID);
            }
        }
        TEEthE2ELog.logFuncEnd("TEActiveEthXCHandler.unActiveEVPL");
        return retCode;
    }

    public static TENEMgrInterface getCreateEVPLBean(int neID, int sfid) {
        int codeVersion = TEEthXCUtil.getEVPLCodeVersion(neID, sfid);
        TECommonWriteLogBean bean = 1 == codeVersion ? new TECreateEVPLBean(){

            public boolean isNeedOperationlog() {
                return false;
            }

            @Override
            protected boolean isNeedSendCreateNtf() {
                return false;
            }

            @Override
            protected boolean isNeedSaveDBOnCreate() {
                return false;
            }

            @Override
            protected boolean isNeedSaveDBOnActive() {
                return false;
            }
        } : new com.huawei.nglct.nemgr.ip.ngwdm.service.TECreateEVPLBean(){

            public boolean isNeedOperationlog() {
                return false;
            }

            @Override
            protected boolean isNeedSendCreateNtf() {
                return false;
            }

            @Override
            protected boolean isNeedSaveDBOnCreate() {
                return false;
            }

            @Override
            protected boolean isNeedSaveDBOnActive() {
                return false;
            }
        };
        return bean;
    }

    private static void logActiveEVPLFromDBError(int retCode, int neID, int slotID) {
        String tipStr = "activeEVPL: save active evpl result to db fail! ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d, retCode:%d]", neID, slotID, retCode);
        e2eLogger.error(tipStr);
    }

    private static void logCreateEVPLToNEError(int retCode, int neID, int slotID) {
        String tipStr = "activeEVPL: active evpl to ne fail! ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d, retCode:%d]", neID, slotID, retCode);
        e2eLogger.error(tipStr);
    }

    private static void logLinkAlreadyActiveError(int neID, int slotID, int linkID) {
        String tipStr = "activeEVPL: not execute because the link is active! ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d, linkID:%d]", neID, slotID, linkID);
        e2eLogger.error(tipStr);
    }

    private static void logCreateEvplBeanOperError(int neID, int slotID, Datainterface inputData, int retCode) {
        String tipStr = "createEVPLToNE: create evpl to ne fail! ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d, retCode:%d]", neID, slotID, retCode);
        e2eLogger.error(tipStr + '\n' + inputData.toString());
    }

    private static void logOutputDataNullError(int neID, int slotID, Datainterface inputData) {
        String tipStr = "createEVPLToNE: create evpl to ne fail! outputData is null!";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
        e2eLogger.error(tipStr + '\n' + inputData.toString());
    }

    private static void logContainerNullError() {
        e2eLogger.info("Del evpl fail! get Contianer fail!");
    }

    private static void logAlreadyUnActiveError(int neID, int slotID) {
        String tipStr = "unActive: not execute because the link is unactive! ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
        e2eLogger.error(tipStr);
    }
}

