/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.erps;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.TENGWDMIPUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;

public class TEERPSGetPortListBean
extends TENEExplorerBean {
    private static final int VB_AVAILPORT_NOT_ENOUGH = 140107;
    private static final int VCTRUNKFLG = 32768;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.outputData = new Datainterface();
        BussinessParams bussinessParams = new BussinessParams();
        RowParams rowParams = null;
        int slotid = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
        String portid = null;
        String portname = null;
        TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
        TEBoard board = configurDataMgr.getBoard(neid, slotid);
        if (null == board) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)140107));
            return this.outputData;
        }
        int boardType = board.getBoardType();
        ArrayList ethportList = new ArrayList();
        if (TENGWDMIPUtil.isLEM18Board(boardType)) {
            ethportList = TENGWDMIPUtil.getEthPortList(neid, slotid, boardType);
        } else {
            ethportList.addAll(configurDataMgr.getETHMACPort(neid, boardType));
            ethportList.addAll(configurDataMgr.getETHVCTrunkPort(neid, slotid, boardType));
        }
        if (0 == ethportList.size()) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)140107));
        } else {
            int listlen = ethportList.size();
            for (int i = 0; i < listlen; ++i) {
                portid = String.valueOf(ethportList.get(i));
                rowParams = new RowParams();
                rowParams.addParam("portid", portid);
                rowParams.addParam("slotid", String.valueOf(slotid));
                portname = Integer.parseInt(portid) - 32768 > 0 ? TEConfigurationDataMgr.getVCTrunkName((int)(Integer.parseInt(portid) - 32768)) : TEConfigurationDataMgr.getMACName((int)Integer.parseInt(portid));
                rowParams.addParam("portname", portname);
                bussinessParams.addRowParams(rowParams);
            }
            this.outputData.setBussinessParams(bussinessParams);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        }
        return this.outputData;
    }
}

