/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.elps;

import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.ip.ngwdm.ethserviceoam.TEOAMUtils;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class TEELPSQueryOAMResBean
extends TENEExplorerBean {
    private static final String MP_TYPE_MEP = "1";
    private static final String MP_DIRECTION_EGRESS = "2";
    private static final int VCTRUNK = 32768;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        this.outputData = this.filterOutputData();
        Map<String, String> mdmaNameMap = TEOAMUtils.queryMDMAId2NameMap(neid, this.getQueryMDMANameOperation(neid, this.outputData));
        BussinessParams bussiness = this.outputData.getBussinessParams();
        RowParams row = null;
        Param param = null;
        int len = bussiness.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            row = bussiness.getRowParams(i);
            if (row.getRowErrorsCount() > 0) continue;
            String mdid = row.getParam("mdid").getValue();
            param = row.getParam("mdname");
            if (null == param) {
                param = new Param("mdname", "");
                row.addParam(param);
            }
            param.setValue(TEOAMUtils.getMdNameFromMap(mdmaNameMap, mdid));
            String maid = row.getParam("maid").getValue();
            param = row.getParam("maname");
            if (null == param) {
                param = new Param("maname", "");
                row.addParam(param);
            }
            param.setValue(TEOAMUtils.getMaNameFromMap(mdmaNameMap, maid));
        }
    }

    private Datainterface filterOutputData() {
        BussinessParams bussiness = this.outputData.getBussinessParams();
        RowParams inputRow = this.inputData.getBussinessParams().getRowParams(0);
        int wportid = Integer.parseInt(inputRow.getParam("wportid").getValue());
        int wvlanid = Integer.parseInt(inputRow.getParam("wvlanid").getValue());
        int pportid = Integer.parseInt(inputRow.getParam("pportid").getValue());
        int pvlanid = Integer.parseInt(inputRow.getParam("pvlanid").getValue());
        RowParams row = null;
        for (int i = bussiness.getRowParamsCount() - 1; i >= 0; --i) {
            row = bussiness.getRowParams(i);
            if (row.getRowErrorsCount() > 0 || MP_TYPE_MEP.equals(row.getParam("type").getValue()) && MP_DIRECTION_EGRESS.equals(row.getParam("direction").getValue()) && (wportid == Integer.parseInt(row.getParam("port").getValue()) && wvlanid == Integer.parseInt(row.getParam("vlanid").getValue()) || pportid == Integer.parseInt(row.getParam("port").getValue()) && pvlanid == Integer.parseInt(row.getParam("vlanid").getValue()))) continue;
            bussiness.removeRowParams(i);
        }
        return this.outputData;
    }

    private List<Operation> getQueryMDMANameOperation(int neid, Datainterface outputData) {
        HashSet<Integer> mdIdList = new HashSet<Integer>();
        HashSet<Integer> maIdList = new HashSet<Integer>();
        BussinessParams bussiness = outputData.getBussinessParams();
        RowParams row = null;
        int slotid = 0;
        int len = bussiness.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            row = bussiness.getRowParams(i);
            if (row.getRowErrorsCount() > 0) continue;
            slotid = Integer.parseInt(row.getParam("slotid").getValue());
            if (!"".equals(row.getParam("mdid").getValue())) {
                mdIdList.add(Integer.parseInt(row.getParam("mdid").getValue()));
            }
            if ("".equals(row.getParam("maid").getValue())) continue;
            maIdList.add(Integer.parseInt(row.getParam("maid").getValue()));
        }
        List<Operation> queryMdMaList = TEOAMUtils.getQuryMDNameOperation(neid, slotid, mdIdList);
        queryMdMaList.addAll(TEOAMUtils.getQuryMANameOperation(neid, slotid, maIdList));
        return queryMdMaList;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorList = new ArrayList<Integer>();
        errorList.add(38662);
        return errorList;
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

