/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.elps;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.ip.ngwdm.TENGWDMIPUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TEELPSQueryBean
extends TECommonWriteLogBean {
    private static final String NSCMD_ETHN_ELPS_PG_GET_STATUS = "NSCMD_ETHN_ELPS_PG_GET_STATUS";
    private static final String NSCMD_ETHN_ELPS_GET_PGINFO = "NSCMD_ETHN_ELPS_GET_PGINFO";
    private static final String SPLIT_CODE = "-";
    private static final int NSERR_ELPS_PG_NOT_EXIST = 57442;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        Map<Integer, String> groupStatusMap = this.queryGroupStatus(operationList);
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        BussinessParams bussiness = this.outputData.getBussinessParams();
        RowParams row = null;
        int len = bussiness.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            String[] statusArray;
            row = bussiness.getRowParams(i);
            if (row.getRowErrorsCount() > 0) continue;
            String groupstatus = groupStatusMap.get(Integer.valueOf(row.getParam("groupid").getValue()));
            if (null != groupstatus && !"".equals(groupstatus) && (statusArray = groupstatus.split(SPLIT_CODE)).length >= 4) {
                row.getParam("groupstatus").setValue(statusArray[0]);
                row.getParam("switchstatus").setValue(statusArray[1]);
                row.getParam("wstatus").setValue(statusArray[2]);
                row.getParam("pstatus").setValue(statusArray[3]);
            }
            int slotid = Integer.parseInt(row.getParam("slotid").getValue());
            int wportid = Integer.parseInt(row.getParam("wportid").getValue());
            int pportid = Integer.parseInt(row.getParam("pportid").getValue());
            String wportname = TENGWDMIPUtil.getPortName(neid, slotid, wportid);
            String pportname = TENGWDMIPUtil.getPortName(neid, slotid, pportid);
            row.addParam(new Param("wportname", wportname));
            row.addParam(new Param("pportname", pportname));
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorList = new ArrayList<Integer>();
        errorList.add(38662);
        errorList.add(57442);
        return errorList;
    }

    private List<Operation> getQueryStatusOperationList(List<Operation> operationList) {
        Operation operStatus = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_ETHN_ELPS_PG_GET_STATUS);
        ArrayList<Operation> statusOperationList = new ArrayList<Operation>();
        Output output = null;
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            if (!operationList.get(i).getName().equals(NSCMD_ETHN_ELPS_GET_PGINFO)) continue;
            int lenj = operationList.get(i).getOutputCount();
            for (int j = 0; j < lenj; ++j) {
                output = operationList.get(i).getOutput(j);
                if (!String.valueOf(0).equals(output.getFault(0).getCode())) continue;
                operStatus.getInput().setPartValue("slotid", output.getPartValue("slotid"));
                operStatus.getInput().setPartValue("groupid", output.getPartValue("groupid"));
                statusOperationList.add((Operation)operStatus.clone());
            }
        }
        return statusOperationList;
    }

    private Map<Integer, String> queryGroupStatus(List<Operation> groupOperationList) {
        List<Operation> operationList = this.getQueryStatusOperationList(groupOperationList);
        HashMap<Integer, String> groupStatusMap = new HashMap<Integer, String>();
        if (operationList.isEmpty()) {
            return groupStatusMap;
        }
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, operationList, this.TIME_OUT);
        if (result.retCode == 0) {
            Output output = null;
            int groupid = 0;
            String groupstatus = "";
            for (int i = 0; i < operationList.size(); ++i) {
                Operation opersec = operationList.get(i);
                if (!opersec.getOutput(0).getFault(0).getCode().equals(String.valueOf(0))) continue;
                output = opersec.getOutput(0);
                groupid = Integer.parseInt(output.getPartValue("groupid"));
                groupstatus = output.getPartValue("groupstatus") + SPLIT_CODE + output.getPartValue("switchstatus") + SPLIT_CODE + output.getPartValue("wstatus") + SPLIT_CODE + output.getPartValue("pstatus");
                groupStatusMap.put(groupid, groupstatus);
            }
        }
        return groupStatusMap;
    }
}

