/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.elps;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.po.embeddednemgrmo.eth.TEWebLCTElpsMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public final class TEELPSDBMgr {
    private static final Logger logger = TELogFactory.getNormalLogger();

    private TEELPSDBMgr() {
    }

    private static void logRetCodeErr(int neID, int retCode) {
        String tipStr = String.format("delete  fail! neID:%d, retCode:%d", neID, retCode);
        logger.error(tipStr);
    }

    public static List<TEWebLCTElpsMOPO> getAllElpsFromDB(int neID, int slotid, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEELPSDBMgr.getAllElpsFromDB";
        logger.info("TEELPSDBMgr.getAllElpsFromDB: begin.");
        ArrayList<TEWebLCTElpsMOPO> elpsList = new ArrayList<TEWebLCTElpsMOPO>();
        TEDaoOperationResult dbRet = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                TEELPSDBMgr.logNullNEError(neID);
                errRet.setResult(1090596385);
                TEELPSDBMgr.logFunEnd("TEELPSDBMgr.getAllElpsFromDB");
                return elpsList;
            }
            dbRet = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll((int[])new int[]{neID, slotid}, TEWebLCTElpsMOPO.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID, slotid}, TEWebLCTElpsMOPO.class);
        }
        catch (Exception e) {
            logger.error("get elps from db fail! neID->" + neID + "slotid->" + slotid, (Throwable)e);
            errRet.setResult(1092743443);
            TEELPSDBMgr.logFunEnd("TEELPSDBMgr.getAllElpsFromDB");
            return elpsList;
        }
        if (null == dbRet) {
            logger.error("get elps from db fail! dbRet is null! neID->" + neID + "slotid->" + slotid);
            errRet.setResult(1092743443);
            TEELPSDBMgr.logFunEnd("TEELPSDBMgr.getAllElpsFromDB");
            return elpsList;
        }
        int retCode = dbRet.getResult();
        if (0 == retCode) {
            List data = dbRet.getData();
            if (null != data && !data.isEmpty()) {
                for (Object obj : data) {
                    elpsList.add((TEWebLCTElpsMOPO)obj);
                }
            }
        } else {
            TEELPSDBMgr.logRetCodeErrorOnGet(neID, retCode);
            errRet.setResult(retCode);
        }
        TEELPSDBMgr.logFunEnd("TEELPSDBMgr.getAllElpsFromDB");
        return elpsList;
    }

    public static TEWebLCTElpsMOPO getElpsById(int neID, int slotid, int elpsid, TEErrInfoReturn errRet) {
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair aPair = new TEDaoNameValuePair("Elpsid", String.valueOf(elpsid));
        criteria.add(aPair);
        TEWebLCTElpsMOPO mopo = null;
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findByID((int[])new int[]{neID, slotid}, TEWebLCTElpsMOPO.class, criteria) : TECommonDaoService.findByID_NonLock((int[])new int[]{neID, slotid}, TEWebLCTElpsMOPO.class, criteria);
            if (null == dbResult) {
                String tipStr = "Get TEWebLCTElpsMOPO fail! The dbResult is null!! ";
                tipStr = tipStr + String.format("[neID:%d]", neID);
                logger.error(tipStr);
                return mopo;
            }
        }
        catch (Exception e) {
            String tipStr = "Get TEWebLCTElpsMOPO fail! DB oper error! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            logger.error(tipStr, (Throwable)e);
            return mopo;
        }
        if (0 == dbResult.getResult() && dbResult.getData().size() > 0) {
            mopo = (TEWebLCTElpsMOPO)dbResult.getData().get(0);
        }
        return mopo;
    }

    public static void updateElpsToDB(int neID, int slotid, TEWebLCTElpsMOPO mo, TEErrInfoReturn errRet) {
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.update((int[])new int[]{neID, slotid}, (Object)mo) : TECommonDaoService.update_NonLock((int[])new int[]{neID, slotid}, (Object)mo);
        }
        catch (Exception e) {
            String tipStr = "Get TEWebLCTElpsMOPO fail! ";
            logger.error(tipStr, (Throwable)e);
            errRet.setResult(1092743443);
            return;
        }
        if (null == dbResult) {
            TEELPSDBMgr.logNullError(neID, slotid);
            errRet.setResult(1092743443);
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            errRet.setResult(retCode);
        }
    }

    public static void delAllElpsFromDB(int neID, int slotid, TEErrInfoReturn errRet) {
        List<TEWebLCTElpsMOPO> elpsList = TEELPSDBMgr.getAllElpsFromDB(neID, slotid, errRet);
        for (TEWebLCTElpsMOPO elps : elpsList) {
            TEELPSDBMgr.delElpsFromDB(neID, slotid, elps, errRet);
        }
    }

    public static void delElpsFromDB(int neID, int slotid, TEWebLCTElpsMOPO elpsMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEELPSDBMgr.delElpsFromDB";
        logger.info("TEELPSDBMgr.delElpsFromDB: begin.");
        TEDaoOperationResult dbRet = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbRet = ne.isDataCfgStausNeedLock() ? TECommonDaoService.delete((int[])new int[]{neID, slotid}, (Object)elpsMO) : TECommonDaoService.delete_NonLock((int[])new int[]{neID, slotid}, (Object)elpsMO);
        }
        catch (Exception e) {
            logger.error("delete arp from db fail! neID->" + neID, (Throwable)e);
            errRet.setResult(1092743443);
            TEELPSDBMgr.logFunEnd("TEELPSDBMgr.delElpsFromDB");
            return;
        }
        if (null == dbRet) {
            TEELPSDBMgr.logNullError(neID, slotid);
            errRet.setResult(1092743443);
            TEELPSDBMgr.logFunEnd("TEELPSDBMgr.delElpsFromDB");
            return;
        }
        int retCode = dbRet.getResult();
        if (0 != retCode) {
            TEELPSDBMgr.logRetCodeErr(neID, retCode);
            errRet.setResult(retCode);
        }
        TEELPSDBMgr.logFunEnd("TEELPSDBMgr.delElpsFromDB");
    }

    private static void logNullError(int neID, int slotid) {
        logger.error("delete clock to db device fail! neID->" + neID + "slotid->" + slotid);
    }

    private static void logFunEnd(String funcName) {
        logger.info(funcName + ": end.");
    }

    public static void createElpsToDB(int neID, int slotid, TEWebLCTElpsMOPO elpsMO, TEErrInfoReturn errRet) {
        String FUNCNAME = "TEELPSDBMgr.createElpsToDB";
        logger.info("TEELPSDBMgr.createElpsToDB: begin.");
        TEDaoOperationResult dbRet = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbRet = ne.isDataCfgStausNeedLock() ? TECommonDaoService.create((int[])new int[]{neID, slotid}, (Object)elpsMO) : TECommonDaoService.create_NonLock((int[])new int[]{neID, slotid}, (Object)elpsMO);
        }
        catch (Exception e) {
            logger.error("create  fail! neID->" + neID, (Throwable)e);
            errRet.setResult(1092743443);
            TEELPSDBMgr.logFunEnd("TEELPSDBMgr.createElpsToDB");
            return;
        }
        if (null == dbRet) {
            TEELPSDBMgr.logNullError(neID, slotid);
            errRet.setResult(1092743443);
            TEELPSDBMgr.logFunEnd("TEELPSDBMgr.createElpsToDB");
            return;
        }
        int retCode = dbRet.getResult();
        if (0 != retCode) {
            TEELPSDBMgr.logRetCodeErr(neID, retCode);
            errRet.setResult(retCode);
        }
        TEELPSDBMgr.logFunEnd("TEELPSDBMgr.createElpsToDB");
    }

    private static void logNullNEError(int neID) {
        logger.error("ne is null! neID->" + neID);
    }

    public static void setElpsAttr(RowParams row, TEWebLCTElpsMOPO elps) {
        int slotid = Integer.parseInt(row.getParam("slotid").getValue());
        int groupid = Integer.parseInt(row.getParam("groupid").getValue());
        int wportid = Integer.parseInt(row.getParam("wportid").getValue());
        String wvlanid = row.getParam("wvlanid").getValue();
        int pportid = Integer.parseInt(row.getParam("pportid").getValue());
        int pvlanid = Integer.parseInt(row.getParam("pvlanid").getValue());
        int apschannel = Integer.parseInt(row.getParam("apschannel").getValue());
        int grouptype = Integer.parseInt(row.getParam("grouptype").getValue());
        int switchdirection = Integer.parseInt(row.getParam("switchdirection").getValue());
        int revmode = Integer.parseInt(row.getParam("revmode").getValue());
        int revtime = Integer.parseInt(row.getParam("revtime").getValue());
        int delaytime = Integer.parseInt(row.getParam("delaytime").getValue());
        int status = Integer.parseInt(row.getParam("status").getValue());
        elps.setBoard(slotid);
        elps.setElpsid(groupid);
        elps.setWorkpid(wportid);
        elps.setWorkvlan(wvlanid);
        elps.setProtpid(pportid);
        elps.setProtvlan(pvlanid);
        elps.setAps(apschannel);
        elps.setType(grouptype);
        elps.setDirection(switchdirection);
        elps.setMode(revmode);
        elps.setWtr(revtime);
        elps.setHoldoff(delaytime);
        elps.setEnablestate(status);
    }

    private static void logRetCodeErrorOnGet(int neID, int retCode) {
        String tipStr = String.format("get clock to db device fail! neID:%d, retCode:%d", neID, retCode);
        logger.error(tipStr);
    }
}

