/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.arptable;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TEWriteLogCommonImpl;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;

public class TEQueryArpItemBean
extends TENEExplorerBean {
    private static final String CFGGETISNULL = "38662";
    int slotID = -1;
    private String operObj = "";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            RowParams[] rowParams = inputData.getBussinessParams().getRowParams();
            Param[] paramArr = rowParams[0].getParam();
            int len = paramArr.length;
            for (int i = 1; i < len; ++i) {
                String name = paramArr[i].getName();
                String value = paramArr[i].getValue();
                if (!name.equalsIgnoreCase("slotID")) continue;
                this.slotID = Integer.parseInt(value);
            }
            this.outputData = new Datainterface();
            this.operationList = TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData, (int)neid);
            int result = this.sendMessage(neid);
            if (result == 0) {
                ArrayList filterErrorCodeList = this.getFilterErrorCodeList();
                this.handleMessage(neid, this.operationList, subFunc, filterErrorCodeList);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        Param param = null;
        RowParams rowparams = null;
        int m = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < m; ++i) {
            rowparams = this.outputData.getBussinessParams().getRowParams(i);
            param = rowparams.getParam("arpip");
            if (null != param && null != param.getValue()) {
                param.setValue(this.convertLongIpToAddr(param.getValue()));
            }
            if (null == (param = rowparams.getParam("arpmac")) || null == param.getValue()) continue;
            param.setValue(this.convertMacAddr(param.getValue()));
        }
    }

    private String convertLongIpToAddr(String ipStr) {
        if (ipStr == null || ipStr.equals("")) {
            return null;
        }
        long longIp = Long.parseLong(ipStr);
        long ip1 = longIp >> 24 & 0xFFL;
        long ip2 = longIp >> 16 & 0xFFL;
        long ip3 = longIp >> 8 & 0xFFL;
        long ip4 = longIp & 0xFFL;
        return ip1 + "." + ip2 + "." + ip3 + "." + ip4;
    }

    private String convertMacAddr(String macAddrStr) {
        StringBuffer showMACStr = new StringBuffer("");
        for (int i = 0; i < 12; i += 2) {
            if (!"".equals(showMACStr.toString())) {
                showMACStr.append("-");
            }
            showMACStr.append(macAddrStr.substring(i, i + 2));
        }
        return showMACStr.toString();
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> codeList = new ArrayList<Integer>();
        codeList.add(Integer.valueOf(CFGGETISNULL));
        codeList.add(41874);
        codeList.add(39170);
        codeList.add(41284);
        return codeList;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        new TEWriteLogCommonImpl(){

            public String getOperationDescribtion() {
                return TEQueryArpItemBean.this.operationDescribtion();
            }
        }.writeLog(neid, subfunc, inputData, user, ipAddress, outputData);
    }

    private String operationDescribtion() {
        StringBuffer operDesc = new StringBuffer();
        operDesc.append(this.operObj).append("-");
        TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
        int boardType = configurDataMgr.getBoard(this.neid, this.slotID).getBoardType();
        String boardName = configurDataMgr.getBoardTypeName(this.neid, boardType);
        String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)this.slotID);
        if (!"".equals(subrackName)) {
            operDesc.append(subrackName).append("-");
        }
        operDesc.append(TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)this.slotID)).append("-").append(boardName);
        return operDesc.toString();
    }
}

