/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.arptable;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.convertor.IPAddressUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TEDeleteArpItemBean
extends TENEExplorerBean {
    private static final int ARPITEM_NOT_EXIST_ERRORCODE = 38751;
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String STRING_SOURCE = "ip" + File.separator + "ngwdm" + File.separator + "res" + File.separator + "arpitem" + File.separator + "arpitemres_" + LANGUAGE + ".ini";
    private TEResourceUtil resourceUtil = null;
    private List logInfoList = new ArrayList();
    private TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();

    public int sendMessage(int neid) {
        this.operationList = new ArrayList();
        int retCode = 0;
        try {
            RowParams[] rowParams = this.inputData.getBussinessParams().getRowParams();
            int len = rowParams.length;
            for (int i = 0; i < len; ++i) {
                Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_CFG_DEL_STATIC_ARP");
                RowParams rowParam = rowParams[i];
                String slotid = rowParam.getParam("slotid").getValue();
                String ip = rowParam.getParam("arpip").getValue();
                oper.getInput().setPartValue("slotid", slotid);
                oper.getInput().setPartValue("arpip", IPAddressUtil.convertIPStrToInt((String)ip) + "");
                this.operationList.add(oper);
            }
            OperationResult result = TECommuNEMgr.getInstance().sendCommand(neid, this.operationList, this.getTimeOut(), this.subfunc);
            if (null != result) {
                retCode = result.retCode;
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
        }
        return retCode;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> filterErrorCodeList = new ArrayList<Integer>();
        filterErrorCodeList.add(38751);
        return filterErrorCodeList;
    }

    public boolean isNeedOperationlog() {
        return true;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        this.resourceUtil = TEGetFilePath.getResource((int)neid, (String)STRING_SOURCE);
        try {
            if (outputData.getErrorMessage().getErrorcode().equals(String.valueOf(1090646019))) {
                return;
            }
            TENE neObj = this.cfgDataMgr.getNE(neid);
            String operateObject = "";
            operateObject = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            String operateName = subfunc.getSubFuncDes(neid);
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            switch (errorCode) {
                case 1090646019: {
                    break;
                }
                case 0: {
                    this.logSuccess(user, ipAddress, operateObject, operateName, errorCode);
                    break;
                }
                case 1: {
                    this.logSuccess(user, ipAddress, operateObject, operateName, errorCode);
                    this.logFail(user, ipAddress, operateObject, operateName);
                    break;
                }
                case 2: {
                    this.logFail(user, ipAddress, operateObject, operateName);
                    break;
                }
                default: {
                    this.logOther(user, ipAddress, operateObject, operateName, errorCode);
                }
            }
            int size = this.logInfoList.size();
            for (int i = 0; i < size; ++i) {
                TELogMgr.writeLog((TELogInfo)((TELogInfo)this.logInfoList.get(i)));
            }
        }
        catch (Exception e) {
            return;
        }
    }

    private void logSuccess(String user, String ipAddress, String operateObject, String operateName, int errorCode) {
        String strArpip = this.resourceUtil.getString("arpip") + ":";
        int userID = 0;
        if (TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            try {
                userID = Integer.parseInt(user);
            }
            catch (Exception e) {
                userID = 0;
            }
        }
        RowParams rowParams = null;
        int rowCount = this.inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < rowCount; ++i) {
            String desc = "";
            TELogInfo loginfo = new TELogInfo();
            loginfo.setCmdID(this.subfunc.getCode());
            loginfo.setLocation(ipAddress);
            loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
            loginfo.setUserID(userID);
            loginfo.setOperateObject(operateObject);
            loginfo.setOperateName(operateName);
            rowParams = this.inputData.getBussinessParams().getRowParams(i);
            int slotid = Integer.parseInt(rowParams.getParam("slotid").getValue());
            int bdType = this.cfgDataMgr.getBoardType(this.neid, slotid);
            String boardName = this.cfgDataMgr.getBoardTypeName(this.neid, bdType);
            desc = operateObject + "-" + slotid + "-" + boardName + ";";
            desc = desc + strArpip;
            desc = desc + rowParams.getParam("arpip").getValue();
            loginfo.setOperateDesc(desc);
            loginfo.setResult(0);
            loginfo.setErrCode(0);
            loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
            this.logInfoList.add(loginfo);
        }
    }

    private void logFail(String user, String ipAddress, String operateObject, String operateName) {
        String strArpip = this.resourceUtil.getString("arpip") + ":";
        int len = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            RowErrors[] rowErrors = this.outputData.getBussinessParams().getRowParams(i).getRowErrors();
            int size = rowErrors.length;
            for (int j = 0; j < size; ++j) {
                int slotid = Integer.parseInt(rowErrors[j].getParam("slotid").getValue());
                int bdType = this.cfgDataMgr.getBoardType(this.neid, slotid);
                String boardName = this.cfgDataMgr.getBoardTypeName(this.neid, bdType);
                String convertedIp = this.translateLongToIp(rowErrors[j].getParam("arpip").getValue());
                String desString = strArpip + convertedIp;
                String desc = operateObject + "-" + slotid + "-" + boardName + ";" + desString;
                for (int k = this.logInfoList.size() - 1; k >= 0; --k) {
                    TELogInfo loginfo = (TELogInfo)this.logInfoList.get(k);
                    if (!loginfo.getOperateDesc().equalsIgnoreCase(desc)) continue;
                    this.logInfoList.remove(k);
                }
                TELogInfo loginfo = new TELogInfo();
                loginfo.setCmdID(this.subfunc.getCode());
                loginfo.setLocation(ipAddress);
                loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
                loginfo.setOperateObject(operateObject);
                loginfo.setOperateName(operateName);
                loginfo.setOperateDesc(desc);
                loginfo.setResult(2);
                loginfo.setErrCode(Integer.parseInt(rowErrors[j].getErrorMessage().getErrorcode()));
                loginfo.setErrInfo(rowErrors[i].getErrorMessage().getErrorinfo());
                this.logInfoList.add(loginfo);
            }
        }
    }

    private void logOther(String user, String ipAddress, String operateObject, String operateName, int errorCode) {
        TELogInfo loginfo = new TELogInfo();
        loginfo.setCmdID(this.subfunc.getCode());
        loginfo.setLocation(ipAddress);
        loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
        loginfo.setOperateObject(operateObject);
        loginfo.setOperateName(operateName);
        loginfo.setOperateDesc(operateName);
        loginfo.setResult(2);
        loginfo.setErrCode(errorCode);
        loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
        this.logInfoList.add(loginfo);
    }

    private String translateLongToIp(String lValue) {
        if (lValue == null || lValue.length() == 0) {
            return "";
        }
        long lNum = Long.parseLong(lValue);
        String hexValue = Long.toHexString(lNum);
        while (hexValue.length() < 8) {
            hexValue = "0" + hexValue;
        }
        String[] subStrArray = new String[4];
        String finalString = "";
        StringBuffer fsb = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            subStrArray[i] = hexValue.substring(i * 2, i * 2 + 2);
            subStrArray[i] = "" + Long.valueOf(subStrArray[i], 16);
            fsb.append(subStrArray[i]).append(".");
        }
        finalString = fsb.toString();
        finalString = finalString.substring(0, finalString.length() - 1);
        return finalString;
    }
}

