/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm;

import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEGetBoardMode;
import java.util.ArrayList;
import java.util.Collections;

public class TENGWDMIPUtil {
    private static TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
    private static final int VCTRUNK_FLAG = 32768;
    private static int VCTRUNK3 = 32771;
    private static int XGETHBOARDMODE = 13;

    public static ArrayList getMACPortList(int neid, int slotId, int boardType, int boardMode) {
        ArrayList macPortList = new ArrayList();
        ArrayList tempMacPortList = mgr.getLogicPortList(neid, slotId);
        int portID = -1;
        if (TENGWDMIPUtil.isLEM18Board(boardType)) {
            int m = tempMacPortList.size();
            for (int i = 0; i < m; ++i) {
                portID = (Integer)tempMacPortList.get(i);
                if (macPortList.contains(portID) || 1025 != mgr.getPortType(neid, boardType, portID, boardMode)) continue;
                macPortList.add(tempMacPortList.get(i));
            }
        } else {
            int m = tempMacPortList.size();
            for (int i = 0; i < m; ++i) {
                portID = (Integer)tempMacPortList.get(i);
                if (macPortList.contains(portID) || 1025 != mgr.getPortType(neid, boardType, portID) && !mgr.getPortListFromPortType(neid, boardType, 1025).contains(portID)) continue;
                macPortList.add(tempMacPortList.get(i));
            }
        }
        Collections.sort(macPortList);
        return macPortList;
    }

    public static ArrayList getVCTrunkPortList(int neid, int slotId, int boardType, int boardMode) {
        ArrayList<Integer> vcTrunkPortList = new ArrayList<Integer>();
        ArrayList tempVcTrunkPortList = mgr.getETHVCTrunkPort(neid, slotId, boardType);
        if (TENGWDMIPUtil.isLEM18Board(boardType)) {
            int size = tempVcTrunkPortList.size();
            for (int i = 0; i < size; ++i) {
                int tempPort = (Integer)tempVcTrunkPortList.get(i);
                if (boardMode == XGETHBOARDMODE && tempPort != VCTRUNK3) continue;
                vcTrunkPortList.add(tempPort);
            }
        } else {
            vcTrunkPortList.addAll(tempVcTrunkPortList);
        }
        return vcTrunkPortList;
    }

    public static ArrayList getEthPortList(int neid, int slotId, int boardType) {
        int boardMode = -1;
        if (TENGWDMIPUtil.isLEM18Board(boardType)) {
            boardMode = TEGetBoardMode.queryBoardMode((int)neid, (int)slotId);
        }
        ArrayList macPortList = TENGWDMIPUtil.getMACPortList(neid, slotId, boardType, boardMode);
        ArrayList vcTrunkPortList = TENGWDMIPUtil.getVCTrunkPortList(neid, slotId, boardType, boardMode);
        if (TENGWDMIPUtil.isLEM18Board(boardType)) {
            TENGWDMIPUtil.filterVCTRUNKPort(macPortList, vcTrunkPortList);
        }
        ArrayList ethAllPortList = new ArrayList();
        ethAllPortList.addAll(macPortList);
        ethAllPortList.addAll(vcTrunkPortList);
        return ethAllPortList;
    }

    public static void filterVCTRUNKPort(ArrayList macPortList, ArrayList vcTrunkPortList) {
        int size = macPortList.size();
        for (int i = 0; i < size; ++i) {
            int macPort = (Integer)macPortList.get(i);
            if (macPort != 5 || !vcTrunkPortList.contains(VCTRUNK3)) continue;
            vcTrunkPortList.remove((Object)VCTRUNK3);
            break;
        }
    }

    public static String getPortName(int neid, int slotid, int portid) {
        String portname = portid > 32768 ? TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, portid) : TEConfigurationDataMgr.getMACName((int)portid);
        return portname;
    }

    public static boolean isLEM18Board(int boardType) {
        return boardType == 2272;
    }
}

