var TOTAL_CELL_COUNT = 360;
var VALUE_PER_CELL = 12.5;
var CELLS_PER_ROW = 40;
var CELL_WIDTH = 17;
var CELL_HEIGHT = 44.5;
var BACKGROUND_HIGHLIGHT_COLOR = "#00ff00";
var BACKGROUND_LOWLIGHT_COLOR = "#AFAFAF";
var BACKGROUND_DEFAULT_COLOR = "#afafff";
var FREQ_UNIT = 12.5;
var STEP_TYPE1 = 4;
var STEP_TYPE2 = 3;
var STEP_TYPE3 = 1;
var STEP_TYPE4 = 8;
var START_FREQUENCE = 196075;
var TYPE_CFG = 0;
var TYPE_REC = 1;

var TOOLTIP_WIDTH = 115;
var TOOLTIP_HEIGHT = 20;

var MARGIN_TOP = 20;
var MARGIN_LEFT = 80;

var lastHightlightCellIndexs = [];

var totalHightlightCellIndexs = [];

var selectedWaveLength = new Array();

var winUrl = getNeProperty(self);
var type = winUrl["type"];
var selectMode = winUrl["selectMode"];
var invoker = winUrl["invoker"];
var availableWaveLen = winUrl["availableWaveLen"];
var selectedWaveLen = winUrl["selectedWaveLen"];
var widthMin = winUrl["widthMin"];
var widthMax = winUrl["widthMax"];

var win = getParentWindow();
var isIE = (navigator.userAgent.indexOf("MSIE") > -1);
var isIE5 = (navigator.userAgent.indexOf("MSIE 5") > -1);
var isIE6 = (navigator.userAgent.indexOf('MSIE 6.0') != -1);
var isIE7 = (navigator.userAgent.indexOf('MSIE 7.0') != -1);
var isIE8 = (navigator.userAgent.indexOf('MSIE 8.0') != -1);
var isIE9 = (navigator.userAgent.indexOf("MSIE 9.0") > -1);
var isFF = (navigator.userAgent.indexOf("Firefox") > -1);
var isOldVersionIE = (isIE && (isIE5 || isIE6 || isIE7 || isIE8));

var availableWaveIndex = [];

var tablesvg;
var circlesvgList = [];
var currentMoveCell;

function parseAvailableWavelen() {
    if (availableWaveLen && null != availableWaveLen && "" != availableWaveLen) {
        var list = availableWaveLen.split(",");
        var waveinfoStr;
        for (var i = 0, len = list.length; i < len; i++) {
            waveinfoStr = list[i];
            if ("" != waveinfoStr) {
                recordAvailableWaveInfo(pInt(waveinfoStr));
            }
        }
        availableWaveIndex.sort();
    }
}

function dealSelectedWavelen() {
    if (selectedWaveLen && selectedWaveLen != "") {
        var list = selectedWaveLen.split(";");
        var waveinfoStr;
        var tmpList;
        var selectIndexList;
        for (var i = 0, len = list.length; i < len; i++) {
            waveinfoStr = list[i];
            if ("" != waveinfoStr) {
                tmpList = waveinfoStr.split("|");
                if (tmpList.length == 2) {
                    selectWaveLen(pInt(tmpList[0]), pInt(tmpList[1]));
                }
            }
        }
    }
}


function selectWaveLen(waveMidf, waveFWidth) {
    var indexList = [];
    var cellCount = waveFWidth / 1000 / VALUE_PER_CELL;
    var halfCellCount = (START_FREQUENCE - waveMidf / 1000) * 2 / VALUE_PER_CELL;
    var beginIndex = (halfCellCount - cellCount) / 2;
    var type;
    switch (cellCount) {
    case 1:
        type = "2";
        break;
    case 3:
        type = "1";
        break;
    case 4:
        type = "0";
        break;
    case 8:
        type = "4";
        break;
    default:
        type = "3";
        $("freqnum").value = cellCount;
        calDefineWidth();
        break;
    }
    doSelect(type, beginIndex);
}

function recordAvailableWaveInfo(index) {
    if(index % 2 == 0)
    {
        availableWaveIndex.push(index/2 - 1);
    }
    else
    {
        availableWaveIndex.push((index - 1)/2);
    }
}

function enableAvailableCell() {
    if(availableWaveIndex.length == 0)
    {
        for (var i = 322, len = TOTAL_CELL_COUNT; i < len; i++) {
            setCellBgColor(i, BACKGROUND_LOWLIGHT_COLOR);
        }
        return;
    }
    for (var i = 0, len = TOTAL_CELL_COUNT; i < len; i++) {
        setCellBgColor(i, BACKGROUND_LOWLIGHT_COLOR);
    }

    for (var i = 0, len = availableWaveIndex.length; i < len; i++) {
        setCellBgColor(availableWaveIndex[i], BACKGROUND_DEFAULT_COLOR);
    }
}

function init() {
    initResource();
    initDefineWidth();
    if(isOldVersionIE)
    {
        drawGridTableForIE(TOTAL_CELL_COUNT);
        parseAvailableWavelen();
        enableAvailableCell();
        dealSelectedWavelen();
        var value = getRadioValue();
        changeTableStyle(getStep(value));
    }
    if ("U2000" == invoker) {
        var child = document.getElementById("applybtn");
        child.parentNode.removeChild(child);
        document.location = "wrui://filterAvailiableWavelen";
    } 
}

/**
 *                
 *@param totalCells
 */
function drawGridTableForIE(totalCells)
{
    var rowCount = Math.floor(totalCells / CELLS_PER_ROW);
    var index = 0;
    tablesvg = table;
    var y = MARGIN_TOP;
    for(var i = 0, size = rowCount; i < size; i++)
    {
        var x = MARGIN_LEFT;
        var title = ((START_FREQUENCE - VALUE_PER_CELL * CELLS_PER_ROW * i) / 1000).toFixed(3) + "THz";
        var strElement="<v:shape style='position:relative;top:" + (y+17) + ";left:0;width:80px;height:20px'></v:shape>";
        rect = document.createElement(strElement);
        rect.innerHTML = title;
        table.appendChild(rect);
        
        var line;
        
        for(var j = 0, count = CELLS_PER_ROW; j < count; j++)
        {
            
            index = i * CELLS_PER_ROW + j;
            strElement="<v:rect id=" + index + " style='position:relative;top:"+y+";left:"+x+";width:"+CELL_WIDTH+";height:" + CELL_HEIGHT + "'></v:rect>";
            rect = document.createElement(strElement);
            title = (START_FREQUENCE - (index * 2 + 1) * (FREQ_UNIT / 2)) / 1000 + "THz";
            rect.setAttribute("onclick", cellOnClick);
            rect.setAttribute("fillcolor", BACKGROUND_DEFAULT_COLOR);
            rect.title = title;
            table.appendChild(rect);
            
            if(j == 0)
            {
                strElement="<v:line strokecolor = 'black' strokeweight = '1px' from ='" + x + "," + y + "' to='" + x + "," + (y + CELL_HEIGHT -1) + "' style='position:relative;filter:alpha(opacity=0,style=0);'></v:line>";
                line = document.createElement(strElement);
                line.setAttribute("id", "leftline" + i);
                table.appendChild(line);
            }

            if (((j % 4) == 2) && (i < 8)) {
                var noStr = i * 10 + (j + 2) / 4;
                var paddingLeft = 1;
                if(noStr < 10)
                {
                    paddingLeft = 0;
                }
                
                strElement="<v:oval title='" + noStr + "' id=" + (index-2) + " style='padding-top:3px;padding-left:" + paddingLeft + "px;font-size:10px;position:relative;top:" + (y+14) + ";left:" + (x-8) + ";width:16;height:16'></v:oval>";
                var circle = document.createElement(strElement);
                circle.setAttribute("onclick", cellOnClick);
                circle.innerHTML = noStr;
                circle.title = noStr;
                table.appendChild(circle);
                circlesvgList.push(circle);
            }
            
            x = x + CELL_WIDTH - 1;
        }
        
        strElement="<v:line strokecolor = 'black' strokeweight = '1px' from ='" + (x+1) + "," + y + "' to='" + (x+1) + "," + (y + CELL_HEIGHT - 1) + "' style='position:relative;filter:alpha(opacity=0,style=0);'></v:line>";
        line = document.createElement(strElement);
        line.setAttribute("id", "rightline" + i);
        table.appendChild(line);
        
        y = y + CELL_HEIGHT - 1;
    }
}

function initDefineWidth()
{
    if(!widthMin || widthMin == "")
    {
        widthMin = 1;
    }
    if(!widthMax || widthMax == "")
    {
        widthMax = 32;
    }
    textCheck($("freqnum"),widthMin,widthMax,0,1)
    if(isIE) {
        $("freqnum").onpropertychange = calDefineWidth;
    }else{
        $("freqnum").addEventListener("input",calDefineWidth,false);
        $("freqnum").onchange = calDefineWidth;
    }
}

function calDefineWidth() {
    $("defineFreq").innerHTML = " = " + $("freqnum").value * 12.5 + "GHz";
    changeTableStyle(pInt($("freqnum").value));
}

/**
 * SVG onload      
 * @param evt
 */

function svgLoad(evt) {
    svgDoc = evt.target.ownerDocument;
    drawGridTable(TOTAL_CELL_COUNT);
    parseAvailableWavelen();
    enableAvailableCell();
    dealSelectedWavelen();
    var value = getRadioValue();
    changeTableStyle(getStep(value));
}

function setAvailiableWaveLen(avaiWaveLen,selWaveLen)
{
    availableWaveLen = avaiWaveLen;
    selectedWaveLen = selWaveLen;
    parseAvailableWavelen();
    enableAvailableCell();
    dealSelectedWavelen();
    var value = getRadioValue();
    changeTableStyle(getStep(value));
}

function initResource() {
    $("applybtn").value = RESOURCE["applybutton"];
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["close"];
    $("resetbtn").value = RESOURCE["reset"];
}

/**
 * radio      
 */

function radioOnclick() {
    lastHightlightCellIndexs.length = 0;
    var value = getRadioValue();

    $("freqnum").disabled = (value != "3");
    if(value == "3" && $("freqnum").value == ""){
        $("freqnum").value = "1";
        calDefineWidth();
    }

    changeTableStyle(getStep(value));
    
    if (selectMode != 1) {
        removeHightlithCells();
        $("freqtip_0").innerHTML = "";
        $("freqtip_1").innerHTML = "";
        $("freqtip_2").innerHTML = "";
    }
    if(isOldVersionIE)
    {
        if (value == "0") {
            for (var i = 0, len = circlesvgList.length; i < len; i++) {
                circlesvgList[i].style.visibility = '';
            }
        } else {
            for (var i = 0, len = circlesvgList.length; i < len; i++) {
                circlesvgList[i].style.visibility = 'hidden';
            }
        }
    }
    else
    {
        if (value == "0") {
            for (var i = 0, len = circlesvgList.length; i < len; i++) {
                tablesvg.appendChild(circlesvgList[i]);
            }
        } else {
            for (var i = 0, len = circlesvgList.length; i < len; i++) {
                tablesvg.removeChild(circlesvgList[i]);
            }
        }
    }
}

function changeTableStyle(value)
{
    var arr1 = new Array(0,1);
    var arr2 = new Array(320,321);
    switch (value) {
    case 8:
        fillCellColor(arr1,BACKGROUND_LOWLIGHT_COLOR);
        fillCellColor(arr2,BACKGROUND_DEFAULT_COLOR);
        break;
    case 4: //50
    case 3: // 37.5
        fillCellColor(arr1,BACKGROUND_DEFAULT_COLOR);
        fillCellColor(arr2,BACKGROUND_LOWLIGHT_COLOR);
        break;
    default:
        fillCellColor(arr1,BACKGROUND_DEFAULT_COLOR);
        fillCellColor(arr2,BACKGROUND_DEFAULT_COLOR);
        break;
    }
}

function fillCellColor(arr,color)
{
    var tmp = 0;
    for (var i = 0; i < arr.length; i++) {
        tmp = arr[i];
        if(!hasSelecedIndes(tmp))
        {
            if(isAvaiable(tmp))
            {
                setCellBgColor(tmp, color);
            }
        }
    }
    return false;
}

function hasSelecedIndes(tmp)
{
    for (var j = 0; j < totalHightlightCellIndexs.length; j++) {
        if (tmp == totalHightlightCellIndexs[j]) {
            return true;
        }
    }
    return  false;
}

function isAvaiable(tmp)
{
    if (availableWaveLen && null != availableWaveLen && "" != availableWaveLen) {
        for (var j = 0; j < availableWaveIndex.length; j++) {
            if (tmp == availableWaveIndex[j]) {
                return true;
            }
        }
        return  false;
    }
    else
    {
        return  true;
    }
}

/**
 *        
 */

function getRadioValue() {
    var value = "0";
    var childs = document.getElementsByName("tabsli");
    for (var i = 0, len = childs.length; i < len; i++) {
        if (childs.item(i).checked) {
            value = childs.item(i).value;
        }
    }
    return value;
}

/**
 *                
 *@param totalCells
 */

function drawGridTable(totalCells) {
    var rowCount = Math.floor(totalCells / CELLS_PER_ROW);
    var index = 0;
    var g = createSVGElement("svg");
    tablesvg = g;
    attr(g, extendObj({
        x: 0,
        y: 0
    }, {
        width: 800,
        height: 420,
        id: "grid"
    }));
    
    var defaultbgColor = BACKGROUND_DEFAULT_COLOR;
    var defaultflag = "0";

    var y = MARGIN_TOP;
    for (var i = 0, size = rowCount; i < size; i++) {
        var x = MARGIN_LEFT;
        var text = createSVGElement("text");
        attr(text, {
            x: 0,
            y: y + CELL_HEIGHT / 2
        });
        setFontSize(text, 10);
        var title = ((START_FREQUENCE - VALUE_PER_CELL * CELLS_PER_ROW * i) / 1000).toFixed(3) + "THz";
        text.appendChild(createSVGText(title));
        g.appendChild(text);
        
        var line; 

        for (var j = 0, count = CELLS_PER_ROW; j < count; j++) {
            index = i * CELLS_PER_ROW + j;
            var rect = createSVGElement("rect");
            rect.setAttribute("id", index);
            rect.setAttribute("width", CELL_WIDTH);
            rect.setAttribute("height", CELL_HEIGHT);
            rect.setAttribute("used", defaultflag);
            rect.setAttribute("x", x);
            rect.setAttribute("y", y);
            rect.setAttribute("style", "stroke:black;stroke-width:1;cursor:pointer");
            rect.setAttribute("fill", defaultbgColor);
            rect.setAttribute("tooltip", (START_FREQUENCE - (index * 2 + 1) * (FREQ_UNIT / 2)) / 1000);
            attachSVGEvent(rect, "click", cellOnClick);
            attachSVGEvent(rect, "mouseover", cell_onmouseover);
            attachSVGEvent(rect, "mouseout", cell_onmouseout);
            g.appendChild(rect);
            
            if(j==0)
            {
                line= createSVGElement("line");
                attr(line, {
                    x1: x,
                    y1: y,
                    x2: x,
                    y2: y + CELL_HEIGHT
                });
                line.setAttribute("id", "leftline" + i);
                line.setAttribute("stroke", "black");
                line.setAttribute("stroke-width",2);
                line.setAttribute("visibility", "hidden");
                g.appendChild(line);
            }

            if (((j % 4) == 2) && (i < 8)) {
                var g_no = createSVGElement("g");
                g_no.setAttribute("id", index - 2);
                g_no.setAttribute("style", "cursor:pointer");
                var circle = createSVGElement("circle");
                circle.setAttribute("id", index - 2);
                attr(circle, {
                    cx: x,
                    cy: y + CELL_HEIGHT / 2,
                    r: 8
                });
                circle.setAttribute("style", "fill:#EFEFEF;stroke:blue");

                var text = createSVGElement("text");
                text.setAttribute("id", index - 2);
                var noStr = i * 10 + (j + 2) / 4;
                var posx = x - 6;
                if (pInt(noStr) < 10) {
                    posx = posx + 2;
                }
                attr(text, {
                    x: posx,
                    y: y + CELL_HEIGHT / 2 + 4
                });
                setFontSize(text, 8);
                text.appendChild(createSVGText(noStr));

                g_no.appendChild(circle);
                g_no.appendChild(text);
                attachSVGEvent(g_no, "click", cellOnClick);
                circlesvgList.push(g_no);

                g.appendChild(g_no);
            }

            x = x + CELL_WIDTH - 1;
        }
        
        line = createSVGElement("line");
        attr(line, {
            x1: x+1,
            y1: y,
            x2: x+1,
            y2: y + CELL_HEIGHT
        });
        g.appendChild(line);
        line.setAttribute("id", "rightline" + i);
        line.setAttribute("stroke", "black");
        line.setAttribute("stroke-width", 2);
        line.setAttribute("visibility", "hidden");
        y = y + CELL_HEIGHT - 1;
    }

    getSVGElement("svgview").appendChild(g);
}

/**
 *          
 * @param target
 * @returns
 */

function getTargetCell(target) {
    if (target) {
        if (target.nodeName == "#document") {
            return null;
        }
        if (target.nodeName == "rect") {
            return target;
        } else {
            return getTargetCell(target.parentNode);
        }
    } else {
        return target;
    }
}

/**
 *   tip    
 */

function destroyTooltip() {
    if(isOldVersionIE)
    {
        return;
    }
    var tooltip = getSVGElement("tooltip1");
    var tooltip2 = getSVGElement("tooltip2");
    if (tooltip) {
        tooltip.parentNode.removeChild(tooltip);
        tooltip2.parentNode.removeChild(tooltip2);
    }
}

/**
 *          tip           
 * @param evt
 */

function cell_onmouseover(evt) {
    var evt = EventUtil.getEvent();
    var target = evt.target;
    var cell = getTargetCell(target);
    drawTip(cell)
}

function drawTip(cell)
{
    if (cell) {
        var index = cell.getAttribute("id");
        if (currentMoveCell && currentMoveCell.getAttribute("id") == index) {
            return;
        }

        destroyTooltip();
        var tooltip = createSVGElement("polygon");
        currentMoveCell = cell;

        var pPos = {
            x: pInt(cell.getAttribute("x")),
            y: cell.getAttribute("y"),
            width: cell.getAttribute("width"),
            height: cell.getAttribute("height")
        };

        var tx = pPos.x - (TOOLTIP_WIDTH - pPos.width) / 2;
        tx = tx < 0 ? 0 : tx;
        var ty = pPos.y - (TOOLTIP_HEIGHT + 10) + CELL_HEIGHT / 4;
        if (ty < 0) {
            ty = pPos.y + pPos.height + 10;
        }

        var points = getTooltipPoints(tx, ty, TOOLTIP_WIDTH, TOOLTIP_HEIGHT, pPos);
        attr(tooltip, {
            points: points,
            id: "tooltip1"
        });
        tooltip.setAttribute("class", "CellTooltip");
        cell.parentNode.parentNode.appendChild(tooltip);

        var text = createSVGElement("text");
        text.appendChild(createSVGText(cell.getAttribute("tooltip") + "THz"));
        attr(text, {
            x: tx + 5,
            y: ty + 13,
            id: "tooltip2"
        });
        cell.parentNode.parentNode.appendChild(text);
    }
}

/**
 *          tips    
 * @param x
 * @param y
 * @param width
 * @param height
 * @param bPos
 * @returns {String}
 */

function getTooltipPoints(x, y, width, height, bPos) {
    var pointstr = "";
    var x1 = x,
        y1 = y,
        x2 = (x + width),
        y2 = y,
        x3 = x2,
        y3 = y + height,
        x4 = x + width / 2 + 5,
        y4 = y3;
    var x5 = bPos.x + bPos.width / 2,
        y5 = y3 + 10,
        x6 = x + width / 2 - 5,
        y6 = y3,
        x7 = x,
        y7 = y3;
    if (y > bPos.y) {
        y5 = y3 - 10;
        return x1 + "," + y1 + " " + x6 + "," + y + " " + x5 + "," + (y - 10) + " " + x4 + "," + y + " " + x2 + "," + y2 + " " + x3 + "," + y3 + " " + x7 + "," + y7;
    } else {
        return x1 + "," + y1 + " " + x2 + "," + y2 + " " + x3 + "," + y3 + " " + x4 + "," + y4 + " " + x5 + "," + y5 + " " + x6 + "," + y6 + " " + x7 + "," + y7;
    }
}

/**
 *                     
 * @param evt
 */
function cell_onmouseout(evt) {
    var target = evt.target;
    if (currentMoveCell) {
        var cPos = getCurrentMoveCellPoint(currentMoveCell);
        if(!(evt.clientX >= cPos.x && evt.clientX <= (cPos.x + cPos.width)
            && evt.clientY >= cPos.y && evt.clientY <=(cPos.y + cPos.height)))
        {
            destroyTooltip();
            currentMoveCell = null;
        }
    }
}

/**
 *             
 * @param cell
 * @returns
 */
function getCurrentMoveCellPoint(cell)
{
    var cPos = {x:0,y:0,width:CELL_WIDTH,height:CELL_HEIGHT};
    while(cell.parentNode && cell.parentNode != "#document")
    {
        if(cell.getAttribute("x") && cell.getAttribute("x") != "")
        {
            cPos.x += pInt(cell.getAttribute("x"));
        }
        if(cell.getAttribute("y") && cell.getAttribute("y") != "")
        {
            cPos.y += pInt(cell.getAttribute("y"));
        }
        cell = cell.parentNode;
    }
    return cPos;
}


/**
 *      
 */

function doApply(quitAfterOperation) {
    destroyTooltip();
    if (0 == totalHightlightCellIndexs.length) {
        confirm("no cells selected");
        return;
    }

    if ("U2000" == invoker) {
        if (quitAfterOperation) {
            document.location = "wrui://SelectWaveLengthAndQuit&" + getSelectedWaveInfo();
        } else {
            document.location = "wrui://SelectWaveLength&" + getSelectedWaveInfo();
        }
    } else {
        var radioType = getRadioValue();
        var index = lastHightlightCellIndexs[0];
        var midFreq = getMidFrequnce(index, radioType) * 1e3;
        var freqWidth = getFreqWidth(radioType) * 1e3;
        var showValue = getFreqTip(radioType, index);
        var rowIndexs = win.st.getSelectedRows();
        if (type == TYPE_CFG) {
            for (var i = 0, len = rowIndexs.length; i < len; i++) {
                var cellEdit = win.st.getCellEdit(rowIndexs[i], "W32PORT_ATTR_MIDFREQ");
                var combo = cellEdit.element.parent.getComboElement();
                if ("1" == radioType) {
                    combo.options.length = 0;
                    combo.options[0] = new Option(showValue, 0);
                } else if ("0" == radioType) {
                    combo.options.length = 0;
                    combo.options[0] = new Option(showValue, 0);
                }
                var cell1 = win.st.getCell(rowIndexs[i], "W32PORT_ATTR_MIDFREQ");
                win.st.setCellValue(cell1, "W32PORT_ATTR_MIDFREQ", midFreq);
                cell1.element.modify = true;
                cell1.element.parentNode.modify = true;

                var cell2 = win.st.getCell(rowIndexs[i], "W32PORT_ATTR_FREQWIDTH");
                win.st.setCellValue(cell2, "W32PORT_ATTR_FREQWIDTH", freqWidth);
                cell2.element.modify = true;
                cell2.element.parentNode.modify = true;
            }
        } else if (type == TYPE_REC) {
            for (var i = 0, len = rowIndexs.length; i < len; i++) {
                var cellEdit = win.st.getCellEdit(rowIndexs[i], "W32PORT_ATTR_RECMIDFREQ");
                var combo = cellEdit.element.parent.getComboElement();
                if ("1" == radioType) {
                    combo.options.length = 0;
                    combo.options[0] = new Option(showValue, 0);
                } else if ("0" == radioType) {
                    combo.options.length = 0;
                    combo.options[0] = new Option(showValue, 0);
                }
                var cell1 = win.st.getCell(rowIndexs[i], "W32PORT_ATTR_RECMIDFREQ");
                win.st.setCellValue(cell1, "W32PORT_ATTR_RECMIDFREQ", midFreq);
                cell1.element.modify = true;
                cell1.element.parentNode.modify = true;

                cell2 = win.st.getCell(rowIndexs[i], "W32PORT_ATTR_RECFREQWIDTH");
                win.st.setCellValue(cell2, "W32PORT_ATTR_RECFREQWIDTH", freqWidth);
                cell2.element.modify = true;
                cell2.element.parentNode.modify = true;
            }
        }
    }
    if (win.hasRight["applybtn"] == "1") {
        win.$("applybtn").disabled = false;
    }
}

/**
 *ok    
 */

function doOK() {
    doApply(true);
    xcloseDialog();
}

function doReset() {
    destroyTooltip();
    removeHightlithCells();
    $("freqtip_0").innerHTML = "";
    $("freqtip_1").innerHTML = "";
    $("freqtip_2").innerHTML = "";
}

/**
 *        
 */

function doCloseDialog() {
    if ("U2000" == invoker) {
        document.location = "wrui://CloseWindow";
    } else {
        xcloseDialog();
    }
}

/**
 *           
 */

function cellOnClick(event) {
    var evt = event || window.event;
    var el = evt.srcElement ? evt.srcElement : evt.target;
    var index = el.getAttribute("id");
    var value = getRadioValue();
    index = parseInt(index);
    doSelect(value, index);
}


function doSelect(value, index) {
    getSelectedIndexs(value, index);

    if (selectMode == 1) {
        if (hasHighlight()) {
            if (hasSelected(index)) {
                removeSelected();
            }

            lastHightlightCellIndexs.length = 0;
            return;
        }
    }
    
    if (isUnselectable()) {
        return;
    }
    
    index = lastHightlightCellIndexs[0];
    hilightCells(value, index);
    drawFreqTips(value, index);
}


function isUnselectable() {
    for (var i = 0; i < lastHightlightCellIndexs.length; i++) {
        if (isWaveLenUnavailable(lastHightlightCellIndexs[i])) {
            return true;
        }
    }
    return false;
}


function removeSelectedAt(index) {
    if (hasSelected(index)) {
        removeSelected();
    }
}


function removeSelected() {
    var tmp = 0;
    for (var i = 0; i < lastHightlightCellIndexs.length; i++) {
        tmp = lastHightlightCellIndexs[i]
        removeFromTotalHightlithCells(tmp);
    }
    setCellSelectedStyle(false);
    var index = lastHightlightCellIndexs[0];
    var child = document.getElementById("SPAN_" + index);
    child.parentNode.removeChild(child.nextSibling);
    child.parentNode.removeChild(child);
}


function hasSelected(index) {
    var waveinfo;
    var selbegin;
    var selend;
    for (var i = 0; i < selectedWaveLength.length; i++) {
        waveinfo = selectedWaveLength[i]
        selbegin = waveinfo.index;
        selend = waveinfo.index + waveinfo.width;
        if ((selbegin <= index) && (selend > index)) {
            selectedWaveLength.splice(i, 1);
            lastHightlightCellIndexs.length = 0;
            for (var j = selbegin; j < selend; j++) {
                lastHightlightCellIndexs.push(j);
            }

            return true;
        }
    }

    return false;
}

/**
 *           
 */

function hilightCells(type, index) {
    if (selectMode != 1) {
        removeHightlithCells();
    }
    addTototalHightlightCellIndexs(type);
}

/**
 *                   
 */

function getSelectedIndexs(type, index) {
    lastHightlightCellIndexs.length = 0;
    var step = getStep(type);
    var endIndex = index + step;
    var beginindex = index;
    if(endIndex >= TOTAL_CELL_COUNT)
    {
        beginindex = TOTAL_CELL_COUNT -step;
        endIndex = TOTAL_CELL_COUNT;
    }
    
    for (var i = beginindex; i < endIndex; i++) {
        lastHightlightCellIndexs.push(i);
    }
}

/**
 *      
 */

function removeHightlithCells() {
    var waveinfo;
    var selbegin;
    for (var i = selectedWaveLength.length-1; i >= 0 ; i--) {
        waveinfo = selectedWaveLength[i]
        selbegin = waveinfo.index;
        removeSelectedAt(selbegin);
    }
}

/**
 *   
 */

function removeFromTotalHightlithCells(index) {
    var tmp = 0;
    var bspecial = false;
    for (var i = 0; i < totalHightlightCellIndexs.length; i++) {
        tmp = totalHightlightCellIndexs[i];
        if (tmp == index) {
            setCellBgColor(index + "", BACKGROUND_DEFAULT_COLOR);
            totalHightlightCellIndexs.splice(i, 1);
            if((index <= 2) || (index >= 320))
            {
                bspecial = true;
            }
            break;
        }
    }

    if(bspecial)
    {
        var value = getRadioValue();
        changeTableStyle(getStep(value));
    }
}

/**
 *             
 */

function hasHighlight() {
    var tmp = 0;
    var index = 0;
    for (var i = 0; i < totalHightlightCellIndexs.length; i++) {
        tmp = totalHightlightCellIndexs[i];
        for (var j = 0; j < lastHightlightCellIndexs.length; j++) {
            index = lastHightlightCellIndexs[j];
            if (tmp == index) {
                return true;
            }
        }
    }
    return false;
}

function setCellSelectedStyle(bselected)
{
    var index = lastHightlightCellIndexs[0];
    var width = lastHightlightCellIndexs.length;
    var splitIndex = width;
    var color = bselected?BACKGROUND_HIGHLIGHT_COLOR:"black";
    var opactiy = bselected?"1":"0";
    var opactiy2 = bselected?"0":"1";
    var visiblity = bselected?"visible":"hidden";
    var visiblity2 = bselected?"hidden":"visible";
    var ele;
    var line;
    var pos;
    var tooltip;
    if(bselected)
    {
        tooltip = (START_FREQUENCE - (2*index + width) * (FREQ_UNIT / 2)) / 1000;
    }
    else
    {
        tooltip = (START_FREQUENCE - (index * 2 + 1) * (FREQ_UNIT / 2)) / 1000;
    }
    
    if(isOldVersionIE)
    {
        for (var i = 1; i < width; i++) {
            ele = document.getElementById(lastHightlightCellIndexs[i]);
            if(lastHightlightCellIndexs[i] % CELLS_PER_ROW == 0)
            {
                splitIndex = i;
                if(ele)
                {
                    if(bselected)
                    {
                        ele.title = tooltip + "THz";
                        ele.style.width = (CELL_WIDTH * (width - splitIndex) - (width - splitIndex - 1))+"px";
                    }
                    else
                    {
                        ele.title = ((START_FREQUENCE - (lastHightlightCellIndexs[i] * 2 + 1) * (FREQ_UNIT / 2)) / 1000) + "THz";
                        ele.style.width = CELL_WIDTH +"px";
                    }
                    pos = pInt(lastHightlightCellIndexs[i]/40);
                    line = document.getElementById("leftline" + pos)
                    if(line)
                    {
                        line.setAttribute("strokecolor", color);
                        line.style.filter = "alpha(opacity=" + (opactiy*100) + ",style=0)";
                    }
                }
            }
            else
            {
                if(ele)
                {
                    ele.style.filter = "alpha(opacity=" + (opactiy2*100) + ",style=0)";
                    if(bselected)
                    {
                        ele.title = tooltip + "THz";
                    }
                    else
                    {
                        ele.title = ((START_FREQUENCE - (lastHightlightCellIndexs[i] * 2 + 1) * (FREQ_UNIT / 2)) / 1000) + "THz";
                    }
                }
            }
            
        }
        
        ele = document.getElementById(index);
        if (ele) {
            if(bselected)
            {
                ele.style.width = (CELL_WIDTH * splitIndex - (splitIndex - 1))+"px";
            }
            else
            {
                ele.style.width = CELL_WIDTH +"px";
            }
            ele.title = tooltip + "THz";
            if(splitIndex != width) 
            {    
                pos = pos - 1;
                line = document.getElementById("rightline" + pos)
                if(line)
                {
                    line.setAttribute("strokecolor", color);
                    line.style.filter = "alpha(opacity=" + (opactiy*100) + ",style=0)";
                }
            }
        }
    }
    else
    {
        destroyTooltip();
        for (var i = 1; i < width; i++) {
            ele = getSVGElement(lastHightlightCellIndexs[i]);
            if(lastHightlightCellIndexs[i] % CELLS_PER_ROW == 0)
            {
                splitIndex = i;
                if(ele)
                {
                    if(bselected)
                    {
                        ele.setAttribute("tooltip",tooltip);
                        ele.setAttribute("width", CELL_WIDTH * (width - splitIndex) - (width - splitIndex - 1));
                    }
                    else
                    {
                        ele.setAttribute("tooltip",(START_FREQUENCE - (lastHightlightCellIndexs[i] * 2 + 1) * (FREQ_UNIT / 2)) / 1000);
                        ele.setAttribute("width", CELL_WIDTH);
                    }
                    pos = pInt(lastHightlightCellIndexs[i]/40);
                    line = getSVGElement("leftline" + pos)
                    if(line)
                    {
                        line.setAttribute("stroke", color);
                        line.setAttribute("visibility", visiblity);
                    }
                }
            }
            else
            {
                if(ele)
                {
                    ele.setAttribute("visibility", visiblity2);
                    if(bselected)
                    {
                        ele.setAttribute("tooltip",tooltip);
                    }
                    else
                    {
                        ele.setAttribute("tooltip",(START_FREQUENCE - (lastHightlightCellIndexs[i] * 2 + 1) * (FREQ_UNIT / 2)) / 1000);
                    }
                }
            }
            
        }
        
        ele = getSVGElement(index);
        if (ele) {
            if(bselected)
            {
                ele.setAttribute("width", CELL_WIDTH * splitIndex - (splitIndex - 1));
            }
            else
            {
                ele.setAttribute("width", CELL_WIDTH);
            }
            ele.setAttribute("tooltip",tooltip)
            if(splitIndex != width) 
            {    
                pos = pos - 1;
                line = getSVGElement("rightline" + pos)
                if(line)
                {
                    line.setAttribute("stroke", color);
                    line.setAttribute("visibility", visiblity);
                }
            }
        }
        currentMoveCell = false;
        drawTip(getSVGElement(index+""))
    }
}

/**
 *              
 */
function addTototalHightlightCellIndexs(type) {
    var index = 0;
    setCellSelectedStyle(true);
    for (var i = 0; i < lastHightlightCellIndexs.length; i++) {
        index = lastHightlightCellIndexs[i];
        setCellBgColor(index + "", BACKGROUND_HIGHLIGHT_COLOR);
        totalHightlightCellIndexs.push(index);
    }
    
    var waveinfo = new Object();
    waveinfo.type = type;
    index = lastHightlightCellIndexs[0];
    waveinfo.index = index;
    waveinfo.midFrequnce = getMidFrequnce(index, type);
    waveinfo.groupIndex = -1;
    waveinfo.des = getFreqTip(type,index);
    waveinfo.width = getStep(type)
    if (type == "0") {
        waveinfo.groupIndex = Math.floor(lastHightlightCellIndexs[0] / STEP_TYPE1) + 1;
    }
    selectedWaveLength[selectedWaveLength.length] = waveinfo;
}

/**
 *         
 */

function getSelectedWaveInfo() {
    var len = selectedWaveLength.length;
    if (len == 0) {
        return "";
    }

    var waveInfo = selectedWaveLength[0];
    var s = getWaveInfoStr(waveInfo);
    for (var i = 1; i < len; i++) {
        waveInfo = selectedWaveLength[i];
        s = s + "," + getWaveInfoStr(waveInfo);
    }

    return s;

}

/**
 *         
 */

function getWaveInfoStr(waveInfo) {
    return waveInfo.midFrequnce * 1e3 + "|" + (waveInfo.width * FREQ_UNIT * 1e3) + ";|" + waveInfo.des;
}

/**
 *        
 */

function setCellBgColor(id, color) {
    if(isOldVersionIE)
    {
        var ele = document.getElementById(id);
        if(ele)
        {
            ele.setAttribute("fillcolor", color);
            if (color == BACKGROUND_DEFAULT_COLOR) {
                ele.setAttribute("used", "0")
            }
            else
            {
                 ele.setAttribute("used", "1")
            }
        }
    }
    else
    {
        var ele = getSVGElement(id);
        if (ele) {
            ele.setAttribute("fill", color);
            if (color == BACKGROUND_DEFAULT_COLOR) {
                ele.setAttribute("used", "0")
            }
            else
            {
                 ele.setAttribute("used", "1")
            }
        }
    }
}

/**
 *        
 */

function isWaveLenUnavailable(id) {
    var ele;
    if(isOldVersionIE)
    {
        ele = document.getElementById(id);
    }
    else
    {
        ele = getSVGElement(id);
    }
    if (ele) {
        return ele.getAttribute("used") == "1";
    }
    return false;
}

/**
 *       
 */

function getMidFrequnce(index, type) {
    var step = getStep(type);
    midFreq = START_FREQUENCE - (index + step / 2) * FREQ_UNIT;
    return midFreq;
}

/**
 *    
 */

function getFreqWidth(type) {
    return getStep(type) * FREQ_UNIT;
}

/**
 *            
 */

function getStep(type) {
    var step = 1;
    if ("0" == type) {
        step = STEP_TYPE1;
    } else if ("1" == type) {
        step = STEP_TYPE2;
    } else if ("2" == type) {
        step = STEP_TYPE3;
    } else if ("4" == type){
        step = STEP_TYPE4;
    }else{
        step = pInt($("freqnum").value);
    }
    return step;
}

/**
 *        
 */

function drawFreqTips(type, index) {
    var tip = getFreqTip(type, index);
    if (selectMode == 1) {
        var pos = (selectedWaveLength.length - 1) % 3;
        tip = '<span width = "140px" style="font-size:12px;" id="SPAN_' + index + '"><input onclick="removeSelectedAt(' + index + ')" type="checkbox" style="margin-right:10px;margin-left:10px;" value="1" checked/>' + tip + '</span><br>';
        $("freqtip_" + pos).innerHTML = $("freqtip_" + pos).innerHTML + tip;
    } else {
        $("freqtip_0").innerHTML = tip;
    }
}

/**
 *    tip
 */

function getFreqTip(type,index) {
    var tip = "";
    var step = getStep(type);
    var midFreq = getMidFrequnce(index, type);
    if ("0" == type) {
        var groupIndex = "-";
        if ((index % step) == 0) {
            groupIndex = Math.floor(index / step) + 1;
            tip = "C/" + groupIndex + "/" + (midFreq / 1000).toFixed(3) + "THz";
        } else {
            tip = "C/" + (midFreq / 1000).toFixed(5) + "THz+-" + FREQ_UNIT * step / 2 + "GHz";
        }
    } else if ("1" == type) {
        tip = "C/" + (midFreq / 1000).toFixed(5) + "THz+-" + FREQ_UNIT * step / 2 + "GHz";
    } else {
        tip = "C/" + midFreq / 1000 + "THz+-" + FREQ_UNIT * step / 2 + "GHz";
    }

    return tip;
}
