var parentWin = getParentWindow()
var obj = parentWin.winurlobj;
var pSt = parentWin.st;

var ct;

var resList = [];

var isModify = (getNeProperty(self)['isNew'] == 'true') ? false : true;

document.title = (isModify ? RESOURCE['modifyVPortMapping'] : RESOURCE['newVPortMapping']);

var pSelectedRow;
if(isModify)
{
    pSelectedRow = pSt.getSelectedRows()[0];
}
    
function initBody()
{
    getValidRes();
    initCTable();
    initBtn();
	
    initData();
}

function initCTable()
{
    ct = new CTable(); 

    ct.addHead(RESOURCE["attributeName"], RESOURCE["attributeValue"]);
    
    var atom = new Atom("select");
    atom.element.onchange = portTypeChanged;
    if(isModify)
    {
        atom.element.disabled = true;
    }
    ct.addAttrRow("vportType", RESOURCE["vportType"], atom);
    
    atom = new Atom("select");
    atom.element.onchange = vPortChanged;
    if(isModify)
    {
        atom.element.disabled = true;
    }
    ct.addAttrRow("vport", RESOURCE["vport"], atom);
    
    atom = new Atom("select");
    atom.element.onchange = pathLevelChanged;
    ct.addAttrRow("pathLevel", RESOURCE["pathLevel"], atom);
    
    atom = new Atom("select");
    atom.element.onchange = mappingPathChanged;
    ct.addAttrRow("mappingPath", RESOURCE["mappingPath"], atom);
    
    atom = new Atom("select");
    atom.element.onchange = bandWidthChanged;
    if(isModify)
    {
        atom.element.disabled = true;
    }
    ct.addAttrRow("bandWidth", RESOURCE["bandWidth"], atom);
    
    atom = new Atom("text");
    textCheck(atom.element, '1', '8');
    atom.element.onkeyup = timeSlotsChanged;
    ct.addAttrRow("timeSlots", RESOURCE["timeSlots"], atom);

    document.body.insertBefore(ct.getTable(), $("AddPortTable"));
    
    ct.changeColWidth('180px', '320px');
}

function initBtn()
{
    $("okBtn").value = RESOURCE["okbutton"];
    $("cancelBtn").value =  RESOURCE["cancelbutton"];   
    $("applyBtn").value = RESOURCE["applybutton"];  
    
    $("applyBtn").disabled = true;
    $("okBtn").disabled = true 
}

function initData()
{ 
    var vPortTypes = getSupoortPortType();
    
    if(vPortTypes.length <= 0)
    {
        setBtnStatus(['okBtn', 'applyBtn'], true);
        return;
    } else {
        /**
         **                    
         **/
        var tempOptions = ct.getAtom('vportType').element.options;
        tempOptions.length = 0;
        
        for(var i = 0, len = vPortTypes.length; i < len; i++)
        {
           tempOptions[tempOptions.length] = new Option(vPortTypes[i], vPortTypes[i]);
        }
    }

    portTypeChanged();
}

function clearData(attrs)
{
    for(var i = 0, len = attrs.length; i < len; i++)
    {
        var tmpAtom = ct.getAtom(attrs[i]);
        
        if(tmpAtom.type == 'input')
        {
            tmpAtom.setValue('');
        } else if(tmpAtom.type == 'select')
        {
            tmpAtom.clearOptions();
        }
    }
}

function getValidRes() 
{
    var requestXml = creatGetValidResXml();
    loadXMLdoc("../../../../neExlorerServlet?sfid="+TECMDCODE_GET_VALID_MAPPINGODUK, "POST", false, getValidResCallback, null,"inputdata="+requestXml);
}

function creatGetValidResXml() 
{ 
    var root = new inputxml("datainterface"); 
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
     
    var param = new tagElement("param"); 
    param.setAttribute("name", "neid");
    param.setAttribute("value", obj['neid']);
    row.appendChild(param);
	
    param = new tagElement("param"); 
    param.setAttribute("name", "slotid");
    param.setAttribute("value", obj['slotid']);
    row.appendChild(param);
    
    bussiness.appendChild(row); 
	
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

function getSupoortPortType()
{
    var arr = [];
    
    if(isModify)
    {
        arr[arr.length] = pSt.getCellStoreValue(pSelectedRow, "portType", "portType");
        return arr;
    }
    
    for(var i = 0, len = resList.length; i < len; i++)
    {
        var resObj = resList[i];
        
        if(!arr.contains(resObj.portType))
        {
            arr[arr.length] = resObj.portType;
        }
    }
    
    return arr;
}

function getValidResCallback(doc)
{
    var data = EncapsulateData(doc);
	
    resList.length = 0;
	
    for(var i = 0, len = data.getDataRowLength(); i < len; i++)
    {
	var resObj = new Object();
	resObj.portType = data.getDataRowParam(i,"portType");
	resObj.vPort = data.getDataRowParam(i,"vPort");
	resObj.vPortName = data.getDataRowParam(i,"vPortName");
	resObj.phyPort = data.getDataRowParam(i,"phyPort");
	resObj.phyPortName = data.getDataRowParam(i,"phyPortName");
	resObj.mappingPaths = data.getDataRowParam(i,"mappingPaths").split(',');
	
	var pathLevelArr = [];
	for(var j = 0, jLen = resObj.mappingPaths.length; j < jLen; j++)
	{
	    var level = getPathLevel(resObj.mappingPaths[j]);
	    if(!pathLevelArr.contains(level))
	    {
	        pathLevelArr[pathLevelArr.length] = level;
	    }
	}
	resObj.supportPathLevel = pathLevelArr;
	    
	resList[resList.length] = resObj;
    }
}

function portTypeChanged()
{    
    clearData(['vport', 'pathLevel', 'mappingPath', 'bandWidth', 'timeSlots']);
    
    var portType = ct.getAttrValue('vportType');
    
    /**
     **                  
     **/
    var vPortElement = ct.getAtom('vport').element;
    if(isModify)
    {
        vPortElement.options[vPortElement.options.length] = new Option(pSt.getCellStoreValue(pSelectedRow, "vPort", 'vPortName'), pSt.getCellStoreValue(pSelectedRow, "paramsValue", "vPort"));
    } else {
        
        for(var i = 0, len = resList.length; i < len; i++)
        {
            var resObj= resList[i];
        
            if(resObj.portType == portType && !checkUsedVPort(resObj))
            {
                if(!isRepeat(resObj.vPort))
                {
                    vPortElement.options[vPortElement.options.length] = new Option(resObj.vPortName, resObj.vPort);
                }
            }
        }
    }
    
    if(vPortElement.options.length <= 0)
    {
        setBtnStatus(['okBtn', 'applyBtn'], true);
        return;
    }
    
    vPortChanged();
}

function vPortChanged()
{
    clearData(['pathLevel', 'mappingPath', 'bandWidth', 'timeSlots']);
    
    var vPortType = ct.getAttrValue('vportType');
    var vPort = ct.getAttrValue('vport');
    var levels = getSupoortPathLevel(vPortType, vPort);
    
    if(levels.length <= 0)
    {
        setBtnStatus(['okBtn', 'applyBtn'], true);
        return;
    } else {
        var tempOptions = ct.getAtom('pathLevel').element.options;
        
        for(var i = 0, len = levels.length; i < len; i++)
        {
           tempOptions[tempOptions.length] = new Option(levels[i], levels[i]);
        }
    }
    
    if(isModify)
    {
        ct.getAtom('pathLevel').setValue(getPathLevel(pSt.getCellStoreValue(pSelectedRow, "paramsValue", "path")));
    }
    
    pathLevelChanged();
}


function getSupoortPathLevel(vPortType, vPort)
{    
    for(var i = 0, len = resList.length; i < len; i++)
    {
        var resObj = resList[i];
        
        if(vPortType == resObj.portType && vPort == resObj.vPort)
        {
            return resObj.supportPathLevel;
        }
    }
    
    return [];
}

function pathLevelChanged()
{
    clearData(['mappingPath', 'bandWidth', 'timeSlots']);
    
    var portType = ct.getAttrValue('vportType');
    var vPort = ct.getAttrValue('vport');
    var pathLevel = ct.getAttrValue('pathLevel');
    
    var mappingPathElement = ct.getAtom('mappingPath').element;
    for(var i = 0, len = resList.length; i < len; i++)
    {
        var resObj = resList[i];
        
        if(resObj.portType == portType && vPort == resObj.vPort)
        {
            var mappingPaths = resObj.mappingPaths;
      
            for(var j = 0, jLen = mappingPaths.length; j < jLen; j++)
            {
                if(judgeLevel(parseInt(mappingPaths[j]), pathLevel) && !checkUsedODK(resObj.phyPort, mappingPaths[j]))
                {
                    mappingPathElement.options[mappingPathElement.options.length] = new Option(resObj.phyPortName + '-' + wdmSimplePath[mappingPaths[j]], resObj.phyPort + '-' + mappingPaths[j]);
                }
            }
        }
    }
    
    if(isModify)
    {
        var optionKey = pSt.getCellStoreValue(pSelectedRow, "paramsValue", "phyPort") + "-" + pSt.getCellStoreValue(pSelectedRow, "paramsValue", "path");
        ct.getAtom('mappingPath').setValue(optionKey);
    }
    
    if(mappingPathElement.options.length <= 0)
    {
        setBtnStatus(['okBtn', 'applyBtn'], true);
        return;
    }
    
    mappingPathChanged();
}

function mappingPathChanged()
{    
    clearData(['bandWidth', 'timeSlots']);
    
    var timeSlotsElement = ct.getAtom('timeSlots').element;
    var pathLevel = ct.getAttrValue('pathLevel');
    var portType = ct.getAttrValue('vportType');

    if(pathLevel == 'ODUflex')
    {
        timeSlotsElement.disabled = false;
        if(timeSlotsElement.value.trim() == '' || timeSlotsElement.value.trim() == '-')
        {
            timeSlotsElement.value = '1';
        }
        
        if(isModify)
        {
            timeSlotsElement.value = pSt.getCellStoreValue(pSelectedRow, "timeSlots", "timeSlots");
        }
    } 
    else 
    {
        timeSlotsElement.disabled = true;
        timeSlotsElement.value = '-';
    }
    
    timeSlotsChanged();
}

function timeSlotsChanged()
{
    clearData(['bandWidth']);
    
    var pathLevel = ct.getAttrValue('pathLevel');
    var portType = ct.getAttrValue('vportType');
    var timeSlot = ct.getAttrValue('timeSlots');
        
    var bandWidthElement = ct.getAtom('bandWidth').element;
    if(pathLevel == 'ODUflex')
    {
        bandWidthElement.options[bandWidthElement.options.length] = new Option(CAPACITY[pathLevel + timeSlot], '3');
    } else if(portType == PORTTYPE_ETH)
    {
        bandWidthElement.options[bandWidthElement.options.length] = new Option(CAPACITY[pathLevel], '3');
    } else if(portType == PORTTYPE_SDH)
    {
        if(pathLevel == 'ODU1')
        {
            bandWidthElement.options[bandWidthElement.options.length] = new Option('STM-16', '1');
        } else if(pathLevel == 'ODU2'){
            bandWidthElement.options[bandWidthElement.options.length] = new Option('STM-64', '2');
        } else {
            bandWidthElement.options[bandWidthElement.options.length] = new Option('STM-16', '1');
            bandWidthElement.options[bandWidthElement.options.length] = new Option('STM-64', '2');
        }
        
        if(isModify)
        {
            ct.getAtom('bandWidth').setValue(pSt.getCellStoreValue(pSelectedRow, "paramsValue", "vPortType"));
        }
    }
    
    if(bandWidthElement.options.length <= 0)
    {
        setBtnStatus(['okBtn', 'applyBtn'], true);
        return;
    }
    
    bandWidthChanged();
}

function bandWidthChanged()
{
    $("applyBtn").disabled = false;
    $("okBtn").disabled = false 
}


function onCancel()
{
    xcloseDialog();
}

function checkUsedVPort(resObj)
{
    for(var i = 0, len = parentWin.usedList.length; i < len; i++)
    {
        var usedObj = parentWin.usedList[i];
        
        if(usedObj.vPort == resObj.vPort)
        {
            return true;
        }
    }
    
    return false;
}

function checkUsedODK(phyPort, path)
{
    if(isModify && pSt.getCellStoreValue(pSelectedRow, "paramsValue", "phyPort") == phyPort 
       && pSt.getCellStoreValue(pSelectedRow, "paramsValue", "path") == path)  //                      ODUK  
    {
        return false;
    }   
    
    for(var i = 0, len = parentWin.usedList.length; i < len; i++)
    {
        var usedObj = parentWin.usedList[i];
        
        if(usedObj.phyPort == phyPort && usedObj.path == path)
        {
            return true;
        }
    }
    
    return false;
}

function addMapping(closeFlg)
{
    setBtnStatus(['okBtn', 'cancelBtn', 'applyBtn'], true);
    
    var addMappingXML;
    var sfidStr;
    if(isModify)
    {
        sfidStr = TECMDCODE_MODIFY_VPORT_MAPPING;
        addMappingXML = creatModifyMappingXml();
    } else {
        sfidStr = TECMDCODE_ADD_VPORT_MAPPING;
        addMappingXML = creatAddMappingXml();
    }

    loadXMLdoc("../../../../neExlorerServlet?sfid=" + sfidStr, "POST", true, addMappingCallBack, closeFlg,"inputdata="+addMappingXML);
}


function creatModifyMappingXml()
{    
    var root = new inputxml("datainterface"); 
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
     
    var param = new tagElement("param"); 
    param.setAttribute("name", "neid");
    param.setAttribute("value", obj['neid']);
    row.appendChild(param);
	
    param = new tagElement("param"); 
    param.setAttribute("name", "slotid");
    param.setAttribute("value", obj['slotid']);
    row.appendChild(param);
    
    var opDesc = RESOURCE['board'] + ":" + obj['slotid'] + '-' + obj['boardname'] + ';';
    
    opDesc += RESOURCE['vportType'] + ":" + ct.getAttrValue('vportType') + ';';
    
    param = new tagElement("param"); 
    param.setAttribute("name", "vPort");
    param.setAttribute("value", ct.getAttrValue('vport'));
    row.appendChild(param);
    
    var tempElm = ct.getAtom('vport').element;
    opDesc += RESOURCE['vport'] + ":" + tempElm.options[tempElm.selectedIndex].text + ';';
    
    param = new tagElement("param"); 
    param.setAttribute("name", "vPortType");
    param.setAttribute("value", ct.getAttrValue('bandWidth'));
    row.appendChild(param);
    
    tempElm = ct.getAtom('bandWidth').element;
    opDesc += RESOURCE['bandWidth'] + ":" + tempElm.options[tempElm.selectedIndex].text + ';';
    
    param = new tagElement("param"); 
    param.setAttribute("name", "srcPhyPort");
    param.setAttribute("value", pSt.getCellStoreValue(pSelectedRow, "paramsValue", "phyPort"));
    row.appendChild(param);
    
    param = new tagElement("param"); 
    param.setAttribute("name", "srcPath");
    param.setAttribute("value", pSt.getCellStoreValue(pSelectedRow, "paramsValue", "path"));
    row.appendChild(param);
    
    opDesc += RESOURCE['src'] + RESOURCE['mappingPath'] + ":" + pSt.getCellShow(pSelectedRow, "mappingPath").element.innerText + ';';
    
    param = new tagElement("param"); 
    param.setAttribute("name", "srcTimeSlots");
    param.setAttribute("value", pSt.getCellStoreValue(pSelectedRow, "timeSlots", "timeSlots"));
    row.appendChild(param);
    
    opDesc += RESOURCE['src'] + RESOURCE['timeSlots'] + ":" + pSt.getCellStoreValue(pSelectedRow, "timeSlots", "timeSlots") + ';';
    
    var mappingPathArr = ct.getAttrValue('mappingPath').split('-');
    
    var phyPort = mappingPathArr[0];
    var path = mappingPathArr[1]
    
    param = new tagElement("param"); 
    param.setAttribute("name", "destPhyPort");
    param.setAttribute("value", phyPort);
    row.appendChild(param);
    
    param = new tagElement("param"); 
    param.setAttribute("name", "destPath");
    param.setAttribute("value", path);
    row.appendChild(param);
    
    tempElm = ct.getAtom('mappingPath').element;
    opDesc += RESOURCE['sink'] + RESOURCE['mappingPath'] + ":" + tempElm.options[tempElm.selectedIndex].text + ';';
    
    var timeSlots = ct.getAttrValue('timeSlots');
    timeSlots = (timeSlots == '-' || timeSlots == '') ? 0 : timeSlots;
    
    param = new tagElement("param"); 
    param.setAttribute("name", "destTimeSlots");
    param.setAttribute("value", timeSlots);
    row.appendChild(param);
    
    opDesc += RESOURCE['sink'] + RESOURCE['timeSlots'] + ":" + timeSlots + ';';
    
    param = new tagElement("param"); 
    param.setAttribute("name", "opDesc");
    param.setAttribute("value", opDesc);
    row.appendChild(param);
    
    bussiness.appendChild(row); 
	
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

function creatAddMappingXml()
{    
    var root = new inputxml("datainterface"); 
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
     
    var param = new tagElement("param"); 
    param.setAttribute("name", "neid");
    param.setAttribute("value", obj['neid']);
    row.appendChild(param);
	
    param = new tagElement("param"); 
    param.setAttribute("name", "slotid");
    param.setAttribute("value", obj['slotid']);
    row.appendChild(param);
    
    var opDesc = RESOURCE['board'] + ":" + obj['slotid'] + '-' + obj['boardname'] + ';';
    
    opDesc += RESOURCE['vportType'] + ":" + ct.getAttrValue('vportType') + ';';
    
    param = new tagElement("param"); 
    param.setAttribute("name", "vPort");
    param.setAttribute("value", ct.getAttrValue('vport'));
    row.appendChild(param);
    
    var tempElm = ct.getAtom('vport').element;
    opDesc += RESOURCE['vport'] + ":" + tempElm.options[tempElm.selectedIndex].text + ';';
    
    param = new tagElement("param"); 
    param.setAttribute("name", "vPortType");
    param.setAttribute("value", ct.getAttrValue('bandWidth'));
    row.appendChild(param);
    
    tempElm = ct.getAtom('bandWidth').element;
    opDesc += RESOURCE['bandWidth'] + ":" + tempElm.options[tempElm.selectedIndex].text + ';';
    
    var mappingPathArr = ct.getAttrValue('mappingPath').split('-');
    
    var phyPort = mappingPathArr[0];
    var path = mappingPathArr[1]
    
    param = new tagElement("param"); 
    param.setAttribute("name", "phyPort");
    param.setAttribute("value", phyPort);
    row.appendChild(param);
    
    param = new tagElement("param"); 
    param.setAttribute("name", "path");
    param.setAttribute("value", path);
    row.appendChild(param);
    
    tempElm = ct.getAtom('mappingPath').element;
    opDesc += RESOURCE['mappingPath'] + ":" + tempElm.options[tempElm.selectedIndex].text + ';';
    
    var timeSlots = ct.getAttrValue('timeSlots');
    timeSlots = (timeSlots == '-' || timeSlots == '') ? 0 : timeSlots;
    
    param = new tagElement("param"); 
    param.setAttribute("name", "timeSlots");
    param.setAttribute("value", timeSlots);
    row.appendChild(param);
    
    opDesc += RESOURCE['timeSlots'] + ":" + timeSlots + ';';
    
    param = new tagElement("param"); 
    param.setAttribute("name", "opDesc");
    param.setAttribute("value", opDesc);
    row.appendChild(param);
    
    bussiness.appendChild(row); 
	
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

function addMappingCallBack(doc, closeFlg)
{
    setBtnStatus(['cancelBtn'], false);
	
    var dinterface = EncapsulateData(doc);
	
    var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "slotid";
    errArr[2] = "boardname";
    errArr[3] = "vPort";
    openErrPage("../../../../page/", dinterface.getError(), errArr);
	
    if(dinterface.getSErrorCode() == 0)
    {
        parentWin.sendQueryInfo();
        
        if(closeFlg)
	{
	    xcloseDialog();
	} else {
	    initData();
	}
    } else {
        setBtnStatus(['okBtn', 'applyBtn'], false);
    }
}

function isRepeat(vPort)
{

    var result = false;
    var vPortElement = ct.getAtom('vport').element;
    
    for(var i = 0, len = vPortElement.options.length; i < len; i++)
    {
        var opObj = vPortElement.options[i];
        if(opObj.value == vPort)
        {
            result = true;
            break;
        }
    }
    
    return result;
}
