var isIE = (navigator.userAgent.indexOf("MSIE") > -1);
var isIE9 = (navigator.userAgent.indexOf("MSIE 9.0") > -1);
var isChrome = (navigator.userAgent.indexOf("Chrome") > -1);
var isFF = (navigator.userAgent.indexOf("Firefox") > -1);
var MIN_INDEX = 0;
var MIDDLE_INDEX = 5;
var MAX_INDEX = 9;
var boardList = new Array();
var SUBRACK_9800U32 = 112;
var SUBRACK_9800U64 = 111;
var SUBRACK_9600U32 = 117;
var SUBRACK_9600U64 = 118;
var winobj = getNeProperty(self);
var subrackType = winobj["shelfType"];
var subrackID = winobj["shelfID"];
var neid = winobj["neid"];
var nmUser = winobj["nmUser"];
var btnRightArr = new Object();

var BOARD_OFFSET = 65536;

function init()
{
	if(isIE9)
	{
		svgDoc = powergraph.object.getSVGDocument();
	}

	if(!isIE)
	{
		svgDoc.oncontextmenu = function()
		{
			return false;
		}
	}
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_GET_POWER_CONIFG);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_SET_POWER_CONFIG);
    
	document.location="wrui://graphPaintBegin";
}

/**
 *                             PIU 
 * @param param
 * @return
 */
function paintPowerGrapFromNavigator(param)
{

	if(null != param && typeof(param) != undefined && '' != param)
	{
		var gs = param.split('|');

		if(null != gs)
		{
				
			var piuBdIndexList = getPiuIndexs(gs[0]);
			boardList = piuBdIndexList;

			var objList = [];

			if(null != gs[1])
			{
				objList = getConfigInfo(gs[1]);
			}			

			objList = rebuildConfigObj(piuBdIndexList, objList);

			drawGraph(objList);
		}
	}
}

/**
 *        PIU   
 *                ','  
 * @param param
 */

function getPiuIndexs(param)
{
	var piuBdIndexList = [];
	if(null != param && typeof(param) != undefined && '' != param)
	{
		var piubds = param.split(',');
		var index;
		if(null != piubds && '' != piubds)
		{
			for(var i = 0, len = piubds.length; i < len; i++)
			{
				index = covertSlotIdToIndex(piubds[i]);
				if(-1 != index)
				{
					piuBdIndexList.push(index);
				}
			}
		}			
	}
	
	return piuBdIndexList;
}

/**
 *                
 * @param param
 */
function getConfigInfo(param)
{
	var configList = [];
	if(null != param && typeof(param) != undefined && '' != param)
	{
		var clist = param.split(',');
		var cinfo;
		var attrs;
		var obj = new ConfigInfoObj();
		if(null != clist && '' != clist)
		{
			for(var i = 0, len = clist.length; i < len; i++)
			{
				 var nobj = parseConfigObj(clist[i]);

				 configList.push(nobj);
			}
		}	
	}

	return configList;
}

/**
 *           
 * @param indexList PIU                 PIU   
 * @param objList            
 */
function rebuildConfigObj(indexList, objList)
{
	var outList = [];
	var cobj;
	var srcIndex = -1;
	var snkIndex = -1;
	var nIlist = [];
	
	for(var i = objList.length - 1; i >= 0; i--)
	{
		cobj = objList[i];
		srcIndex = covertSlotIdToIndex(cobj.srcSlotId);
		snkIndex = covertSlotIdToIndex(cobj.snkSlotId);
		var hasSrc = false;
		var hasSnk = false;
		for(var j = 0, jLen = indexList.length; j < jLen; j++)
		{
			if(-1 == snkIndex)
			{
				if(indexList[j] == srcIndex)
				{
					nIlist.push(srcIndex);
					break;
				}
				if((j + 1) == jLen)
				{
					objList.remove(cobj);
				}
			}
			else
			{
				if(indexList[j] == srcIndex)
				{
					hasSrc = true;
				}
				if(indexList[j] == snkIndex)
				{
					hasSnk = true;
				}
				if(hasSrc && hasSnk)
				{
					nIlist.push(srcIndex);
					nIlist.push(snkIndex);
					break;
				}
				if((j + 1) == jLen)
				{
					if(!hasSrc && !hasSnk)
					{
						objList.remove(cobj);
					}
					else if(!hasSnk)
					{
						cobj.snkSlotId = 0;
						cobj.currentValue = 63;
						objList[i] = cobj;
						nIlist.push(srcIndex);
					}
					else
					{
						cobj.srcSlotId = cobj.snkSlotId;
						cobj.snkSlotId = 0;
						cobj.currentValue = 63;
						objList[i] = cobj;
						nIlist.push(snkIndex);
					}
				}
			}			
		}		
	}

	for(var i = 0, len = objList.length; i < len; i++)
	{
		cobj = objList[i];
		snkIndex = covertSlotIdToIndex(cobj.snkSlotId);
		if(-1 == snkIndex)
		{
			cobj.hasConnect = false;
		}
		else
		{
			cobj.hasConnect = true;
		}

		outList.push(convertConfigObj(cobj));
	}

	var aList = getSubList(indexList, nIlist);
	for(var i = 0, len = aList.length; i < len; i++)
	{
		var obj = new ConfigInfoObj();
		obj.currentValue = 63;
		obj.srcSlotId = convertIndexToSlotId(aList[i]);
		obj.snkSlotId = 0;
		outList.push(convertConfigObj(obj));
	}
	return outList;
}

/**
 *         
 */
window.onbeforeunload = function()
{
	var outStr= subrackID+ "&" + postDataToNavigator();
	document.location="wrui://powerGrahConf&"+outStr;
}

/**
 *                             
 * @return
 */
function postDataToNavigator()
{
	var outStr = "";
	var lineArray = getConnectLineList();
	var num = getNum(lineArray);

	if(null != boardList)
	{

		var bds = boardList;
		var len = lineArray.length;
		var rowStr = "";
		if(0 == len)
		{
			for(var i = 0, ilen = bds.length; i < ilen; i++)
			{
				var index = bds[i];
				var current = getCurrentValue(index);
				var slotId = convertIndexToSlotId(index);
				rowStr = current + "-" + slotId + "-0";
                outStr += rowStr;
                if((i + 1) != ilen)
                {
                	outStr += ',';
                }
			}
		}
		else
		{
			for(var j = 0; j < len; j++)
			{
				var cline = lineArray[j];
				var indexs = cline.split("_");
				var srcIndex = indexs[0];
				var snkIndex = indexs[1];
				if(srcIndex > snkIndex)
				{
					var temp = snkIndex;
					snkIndex = srcIndex;
					srcIndex = temp;
				}
				var current = getCurrentValue(srcIndex);
				var srcSlotId = convertIndexToSlotId(srcIndex);
				var snkSlotId = convertIndexToSlotId(snkIndex);
				
				rowStr = current + "-" + srcSlotId + "-" + snkSlotId;
                outStr += rowStr;
                if((j + 1) != len)
                {
                	outStr += ',';
                }
			}
			var list = getNoConnectLine(lineArray);
			if(list.length > 0)
			{
				outStr += ',';
			}
			for(var k = 0, kLen = list.length; k < kLen; k++)
			{
				var index = list[k];
				var current = getCurrentValue(index);
				var slotId = convertIndexToSlotId(index);
				
				rowStr = current + "-" + slotId + "-0";
                outStr += rowStr;
                if((k + 1) != kLen)
                {
                	outStr += ',';
                }
			}
		}
	    
		return outStr;
	}
}

function createTagElement(tag, value)
{
	var ele = new tagElement("param");
	ele.setAttribute("name", tag);
	ele.setAttribute("value", value);
	
	return ele;
}

/**
 *       
 */
function hideAllBatteries()
{
	var maxIndex = 0;
	if(SUBRACK_9800U32 == subrackType || SUBRACK_9600U32 == subrackType )
	{
		maxIndex = 4;
	}
	else if(SUBRACK_9800U64 == subrackType || SUBRACK_9600U64 == subrackType)
	{
		maxIndex = 9;
	}
	for(var i = 0; i <= maxIndex; i++)
	{
		setBatteryDisplay(i, false);
	}
}

/**
 *   PIU                
 * @param data
 */
function showExsitBatteris(data)
{
	var indexArray = boardList;
	if(null != indexArray && "" != indexArray)
	{
		var len = indexArray.length;
		var index = 0;
		for(var i = 0; i < len; i++)
		{
		
			index = indexArray[i];

			if("-1" != index)
			{
				setBatteryDisplay(index, true);
			}
		}
	}

}

/**
 *              
 */
function getConnectLineList()
{
	var lineArray = [];
	var connectroot = getSVGElement("connectrelation");
	var childs = connectroot.childNodes;
	for(var i = childs.length - 1; i >= 0; i--)
	{
		var child = childs.item(i);
		var id = child.getAttribute("id");
		if(id.indexOf(CONNECT_LINE_PREFIX) > -1)
		{
			var index = CONNECT_LINE_PREFIX.length;
			var indexs = id.substring(index);
			lineArray.push(indexs);
		}
	}
	
	return lineArray;
}

/**
 *          
 * @param index
 * @returns
 */
function getCurrentValue(index)
{
	var id = CURRENT_TEXT_PREFIX + index;
	var ele = getSVGElement(id);
	if(null != ele)
	{
		var current = ele.getAttribute("current");
		if(null != current && "" != current)
		{
			return current;
		}
	}
	
	return 0;
}

/**
 *               
 * @param slotId
 * @return
 */
function covertSlotIdToIndex(slotId)
{
	var index = -1;
	slotId = parseInt(slotId);
	if(SUBRACK_9800U32 == subrackType || SUBRACK_9600U32 == subrackType )
	{
		if(slotId < 100 || slotId > 105)
		{
			index = -1;
		}
		else
		{
			index = slotId - 100;
		}
	}
	else if(SUBRACK_9800U64 == subrackType || SUBRACK_9600U64 == subrackType)
	{
		if(slotId < 100 || slotId > 110)
		{
			index  = -1;
		}
		else
		{
			if(slotId < 105)
			{
				index = slotId - 100;
			}
			else
			{
				index = slotId - 101;
			}
		}
	}
	
	return index;
}
/**
 *               
 * @param index
 * @returns
 */
function convertIndexToSlotId(index)
{
	var slotId = 0;
	index = pInt(index);
	if(index >= MIN_INDEX && index <= MAX_INDEX)
	{
		if(index < MIDDLE_INDEX)
		{
			slotId = 100 + index;
		}
		else if(index >= MIDDLE_INDEX)
		{
			slotId = 101 + index;
		}
	}
	
	return slotId;
}

/**
 *             
 * @param slotId
 * @returns
 */
function convertSlotToBigSlot(slotId)
{
	if(null == subrackID || '' == subrackID)
	{
		subrackID = 0;
	}
	else
	{
		subrackID = parseInt(subrackID);
	}
	if(null == subrackID)
	{
		subrackID = 0;
	}
	return pInt(slotId) + subrackID * BOARD_OFFSET;
}

/**
 *             
 * @param slotId
 * @returns {Number}
 */
function convertBigSlotToSlot(slotId)
{
	if(null == subrackID || '' == subrackID)
	{
		subrackID = 0;
	}
	else
	{
		subrackID = parseInt(subrackID);
	}
	if(null == subrackID)
	{
		subrackID = 0;
	}
	
	return pInt(slotId) - subrackID * BOARD_OFFSET;
}

/**
 *           
 * @param lineArray
 * @returns
 */
function getNoConnectLine(lineArray)
{
	if(null != boardList)
	{
		var bds = boardList;
		var len = lineArray.length;
		for(var i = 0; i < len; i++)
		{
			var cline = lineArray[i];
			var indexs = cline.split("_");
			var srcIndex = indexs[0];
			var snkIndex = indexs[1];
			bds.remove(srcIndex);
			bds.remove(snkIndex);
		}
		
		return bds;
	}
	
	return null;
}

/**
 *           
 * @param lineArray
 * @returns
 */
function getNum(lineArray)
{
	var cLen = lineArray.length;
	var nocLines = getNoConnectLine(lineArray);
	var ncLen = 0;
	if(null != nocLines)
	{
		ncLen = nocLines.length;
	}
	
	return cLen + ncLen;
}

/**
 *              
 * @param srcIndex
 * @param snkIndex
 * @returns {Boolean}
 */
function isConnectBoardExist(srcIndex, snkIndex)
{
	var isExist = false;

	if(null != boardList)
	{
		var bds = boardList;
		var lineArray = getConnectLineList();
		var id;
		for(var i = 0, len = bds.length; i < len; i++)
		{
			id = bds[i];
			if(id == snkIndex)
			{
				isExist = true;
			}
		}
		if(isExist)
		{
			for(var j = 0, jLen = lineArray.length; j < jLen; j++)
			{
				var cline = lineArray[j];
				var indexs = cline.split("_");
				var srcIx = indexs[0];
				var snkIx = indexs[1];
				if((srcIndex == srcIx || srcIndex == snkIx) && (snkIndex == srcIx || snkIndex == snkIx))
				{
					isExist = false;
				}
			}
		}
	}
    return isExist;
}

/***
 *         Y             
 * @param index
 */
function getConnectPosY(srcIndex, snkIndex)
{
	srcIndex = pInt(srcIndex);
	snkIndex = pInt(snkIndex);
	var len1 = Math.abs(srcIndex - snkIndex);
	var isNeedChange = false;
	var y = getMinConnecteY();
	var lineArray = getConnectLineList();
	var len = lineArray.length;
	var cline;
	var indexs;
	var srcIx;
	var snkIx;
	var len2;
	var maxLen;
	for(var i = 0; i < len; i++)
	{
		cline = lineArray[i];
		indexs = cline.split("_");
		srcIx = pInt(indexs[0]);
		snkIx = pInt(indexs[1]);
		len2 = Math.abs(srcIx - snkIx);
		maxLen = getMaxDiff([srcIndex, snkIndex, srcIx, snkIx]);
		if((len1 + len2) >= maxLen)
		{
			isNeedChange = true;
		}
	}
	if(isNeedChange)
	{
		y += CONNECT_LINE_Y_DELTA;
	}
	else
	{
		y = CONNECT_LINE_Y;
	}
	return y;
}

/**
 *      Y                Y              
 * @returns
 */
function getMinConnecteY()
{
    var minY = CONNECT_LINE_Y;
	var connectroot = getSVGElement("connectrelation");
	var childs = connectroot.childNodes;
	var y = 0;
	var id;
	for(var i = childs.length - 1; i >= 0; i--)
	{
		var child = childs.item(i);
		id = child.getAttribute("id");
		if(id.indexOf(CONNECT_LINE_PREFIX) > -1)
		{
            y =  pInt(child.getAttribute("y"));          
            if(y < minY)
            {
            	minY = y;
            }
		}
	}
	
	return minY;
}

/**
 *           PIU        
 * @param data
 * @returns
 */
function getNotConfigList(data)
{
    var len = data.getDataRowLength();
    var indexListStr = data.getDataRowParam(0,"boardIndexList");
    indexs = convertArrayStrToArray(indexListStr);
    for(var i = 1; i < len; i++)
    {
    	var index = data.getDataRowParam(i,"srcIndex");
    	if(-1 != index)
    	{
        	indexs.remove(index);
    	}
    	var index = data.getDataRowParam(i,"snkIndex");
    	if(-1 != index)
    	{
        	indexs.remove(index);
    	}
    }
    return indexs;
}

/**
 *            PIU                    
 * @param data
 * @returns {Array}
 */
function convertConfigObj(/*object*/obj)
{
	var curtag = new ParamTag("currentValue");
	if(0 == obj.currentValue && 0 == obj.hasConnect)
	{
		obj.currentValue = 63;
	}
	curtag.value = obj.currentValue + '';
	var hctag = new ParamTag("hasConnect");
	hctag.value = obj.hasConnect;
	var srcitag = new ParamTag("srcIndex");
	srcitag.value = covertSlotIdToIndex(obj.srcSlotId) + '';
	var srcstag = new ParamTag("srcSlotID");
	srcstag.value = obj.srcSlotId + '';

	var snkitag = new ParamTag("snkIndex");
	snkitag.value = covertSlotIdToIndex(obj.snkSlotId) + '';
	var snkstag = new ParamTag("snkSlotID");	
	snkstag.value = obj.snkSlotId + '';
	var srcptag = new ParamTag("srcUsedPower");
	srcptag.value = "0";
	var snkptag = new ParamTag("snkUsedPower");
	snkptag.value = "0";
	var ptag = new ParamTag("usedPower");
	ptag.value = "0";

	var rowparam = new Object();
	rowparam.currentValue = curtag;
	rowparam.srcSlotID = srcstag;
	rowparam.srcIndex = srcitag;
	rowparam.snkSlotID = snkstag;
	rowparam.snkIndex = snkitag;
	rowparam.hasConnect = hctag;
	rowparam.srcUsedPower = srcptag;
	rowparam.snkUsedPower = snkptag;
	rowparam.usedPower = ptag;

	return rowparam;
}

/**
 *       
 * @returns {Boolean}
 */
function hidePopupMenu()
{
    return false;	
}

/**
 *                0A           
 * @param index
 */
function needHiddenZeroCurrent(index)
{
	var lineArray = getConnectLineList();
	for(var i = 0, len = lineArray.length; i < len; i++)
	{
		var cline = lineArray[i];
		var indexs = cline.split("_");
		var srcIx = indexs[0];
		var snkIx = indexs[1];
		if(index == srcIx)
		{
			return true;
		}
	}
	
	return false;
}

/**
 *                    
 * @param arrayStr
 * @returns {Array}
 */
function convertArrayStrToArray(arrayStr)
{
	var array = [];
	if(null != arrayStr && "" != arrayStr)
	{
		var index1 = arrayStr.indexOf("[");
		var index2 = arrayStr.indexOf("]");
		if(-1 != index1 && -1 != index2)
		{
			var indexs = arrayStr.substring(index1 + 1, index2);
			var indexarry = indexs.split(",");
			for(var i = 0, len = indexarry.length; i < len; i++)
			{
				array[array.length] = indexarry[i].trim();
			}
		}
	}
	
	return array;
}

/**
 *                  
 * @param array
 * @returns
 */
function getMaxDiff(array)
{
	  var min =  Math.min.apply(Math, array);
	  var max = Math.max.apply(Math, array);
	  
	  return Math.abs(max - min);
}

function getSubList(/*list*/list1, /*list*/list2)
{
	var subList = [];
	for(var i = 0, len = list1.length; i < len; i++)
	{
	    var flag = 0;
		for(var j = 0, jLen = list2.length; j < jLen; j++)
		{
			if(list1[i] == list2[j])
			{
				flag = 1;
				break;
			}
		
		}
		if(flag == 0 )
		{
			subList.push(list1[i]);
		}		
	}

	return subList;
}

/**
 *       
 * @param e
 * @returns {Boolean}
 */
function noRightClick(e)
{ 
	window.event.returnValue = false;
	if (window.Event)
	{ 
		 if (e.which == 2 || e.which == 3)
		 {
		      return false; 
		 }
	} 
	else
	{
		 if (event.button == 2 || event.button == 3)
		 { 
		     event.cancelBubble = true 
			 event.returnValue = false; 
			 return false; 
		 } 
	}
} 

/**
 *            
 */
function drawGraph(data)
{
	hideAllBatteries();
    showExsitBatteris(data);
    destroyConnectionArea();
    destroyCurrentListArea();
    
	for(var i = 0, len = data.length; i < len; i++)
	{
		var piuinfo = data[i];
		drawGraphUnit(piuinfo);
	}
	
	var rect = getSVGElement("wholearea");
	if(null != rect)
	{
		attachSVGEvent(rect, "click", clearAllShowLabel);
		attachSVGEvent(rect, "mousedown", noRightClick);
	}
}

/**
 *                          PIU        
 * @param info
 * @returns
 */
function drawBatteryUnit(info)
{
	var index = info.srcIndex.value;
	drawBatterPowerText(info);
}

/**
 *           boolean 
 * @param isfalse
 * @returns
 */
function parseStrToBool(isfalse)
{
	return ("true" == isfalse || true == isfalse) ? true : false;
}

/**
 *         
 *                                          
 */
function ConfigInfoObj()
{
	this.currentValue = 0;
	this.srcSlotId = 0;
	this.snkSlotId = 0;
}
	
ConfigInfoObj.prototype.toString = function()
{
		return this.currentValue + "-" + this.srcSlotId + "-" + this.snkSlotId;
}
	
ConfigInfoObj.prototype.parse = function(/*String*/param)
{
	if(null != param && typeof(param) != undefined && '' != param)
	{
		attrs = param.split('-');
		if(null != attrs && typeof(attrs) != undefined && '' != attrs)
		{
			this.currentValue = attrs[0];
			this.srcSlotId = pInt(attrs[1]);
			this.snkSlotId = pInt(attrs[2]);
			if(this.srcSlotId > this.snkSlotId)
			{
				var temp = this.snkSlotId;
				this.snkSlotId = this.srcSlotId;
				this.srcSlotId = temp;
			}
		}
	}		
}

function parseConfigObj(/*String*/param)
{
	if(null != param && typeof(param) != undefined && '' != param)
	{
		attrs = param.split('-');

		if(null != attrs && typeof(attrs) != undefined && '' != attrs)
		{
		    var obj = new ConfigInfoObj();
			obj.currentValue = attrs[0];
			obj.srcSlotId = pInt(attrs[1]);
			obj.snkSlotId = pInt(attrs[2]);
				
			return obj;
		}
	}
		
	return null;
}
