var PIU_NUM_EACHSIDE = 5;
var BATTERY_WIDTH = 30;
var BATTERY_HEIGHT = 35;
var X_RADIUS = 15;
var Y_RADIUS = 5;
var X_ORIGIN_R = 20;
var X_ORIGIN_A = X_ORIGIN_R;
var Y_POWER_BOTTOM = 64;
var Y_CURRENT_ORIGIN = 100;
var Y_PIU_ORIGIN = 170;
var UNITE_WIDTH = 50;
var CONNECT_LINE_Y = 160;
var CONNECT_LINE_Y_DELTA = - 10;
var SEMI_CIRCLE_CY = 20;

var BATTERY_GROUP_PREFIX = "battery_";
var BATTERY_POWERTEXT_PREFIX = "battery_power_";
var BATTERY_USAGE_PREFIX = "battery_usage_";
var CURRENT_GROUP_PREFIX = "g_current_";
var CURRENT_TEXT_PREFIX = "current_text_";
var PAYLOAD_TEXT_PREFIX = "payload_text_";
var CONNECT_LINE_PREFIX = "connectline_";
var EXTEND_BATTERY_PREFIX = "extend_battery_";
var LINE_BATTERY_PREFIX = "g_line_battery_";
var DELETE_LABEL_PREFIX = "delete_label_";
var PIU_BOARD_PREFIX = "piu_board_";
var SHOW_LABEL_PREFIX = "g_showlable_";
var BOARD_LINE_PREFIX = "board_line_";
var CURRENT_LIST_PREFIX = "current_list_";
var CURRENT_ARROW_PREFIX = "current_arrow_";

var svgDoc;

function initSVGDoc(evt)
{
	svgDoc = getSVGDocument(evt);
}

/**
 *            
 */
function drawGraph(data)
{
	if(isIE)
	{
		BATTERY_HEIGHT = 37;
	}
	hideAllBatteries();
    showExsitBatteris(data);
    destroyConnectionArea();
    destroyCurrentListArea();
    
	for(var i = 1, len = data.length; i < len; i++)
	{
		var piuinfo = data[i];
		drawGraphUnit(piuinfo);
	}
	
	var rect = getSVGElement("wholearea");
	if(null != rect)
	{
		attachSVGEvent(rect, "click", clearAllShowLabel);
		attachSVGEvent(rect, "mousedown", noRightClick);
	}
}

/**
 *   PIU         
 * 
 * @param index
 */
function drawGraphUnit(info)
{	
	if(!isDefined(info))
	{
		return ;
	}
	destroyGraphUnit(info);
	
	changeLineStyle(info);
			
	drawBatteryUnit(info);
	drawCurrentShowLable(info);
	drawPIUShowLabel(info);	
	
	var hasConnect = info.hasConnect.value;
	hasConnect = parseStrToBool(hasConnect);
	if(hasConnect)
	{
		var srcIndex = info.srcIndex.value;
		var snkIndex = info.snkIndex.value;
		if(srcIndex > snkIndex)
		{
			var tmp = snkIndex;
			snkIndex = srcIndex;
			srcIndex = tmp;
		}
		var y = getConnectPosY(srcIndex,snkIndex);
		drawConnectLine(srcIndex,snkIndex,y);
	}
}

/**
 *                          PIU        
 * @param info
 * @returns
 */
function drawBatteryUnit(info)
{
	var index = info.srcIndex.value;

	drawBatterPowerText(info);
	var powerEle = drawBatteryUsageElement(info);
	var ptxt = drawPayloadText(info);
	var id = EXTEND_BATTERY_PREFIX + index;
	var extendnode = getSVGElement(id);
	if(extendnode)
	{
		if(powerEle)
		{
			extendnode.appendChild(powerEle);			
		}
		extendnode.appendChild(ptxt);
	}	
}

/**
 *                 
 * @returns
 */
function drawBatteryUsageElement(info)
{
	var index = info.srcIndex.value;
	var currentValue = info.currentValue.value;
	var maxPower = getMAXPower(currentValue);
	var usedPower = info.usedPower.value;
	usedPower = pInt(usedPower);
	var startX = getRelativeStartXPos(index);
	var startY = Y_POWER_BOTTOM;
	if(0 == maxPower)
	{
		return;
	}
	var freeRatio = 1 - usedPower / maxPower;
	var style = getPowerMonitorColor(freeRatio);
    var height = freeRatio * BATTERY_HEIGHT;
	var xr = startX + BATTERY_WIDTH;
	var yt = startY - height;
	var data = "M" + startX + "," + startY + " A" + X_RADIUS + "," + Y_RADIUS + " 0 0,0 "
	      + xr + "," + startY + " L" + xr + "," + yt + " A" + X_RADIUS + "," + Y_RADIUS
	      + " 0 0,1 " + startX + "," + yt + "Z";
	var id = BATTERY_USAGE_PREFIX + index;
	var g = createSVGElement("g");
	g.setAttribute("id", id);
	
	var path = createSVGElement("path");
	attr(path,{d:data, fill:style, opacity:0.7});
	g.appendChild(path);

	var usedstr = setDemicalDigitLength(freeRatio * 100 + '', 1) + "%";
	var pos = calcTextStartPos(usedstr, 8, startX + 15, startY);
	pos.y = startY - 10;
	var txt = createSVGElement("text");
	attr(txt, pos);
	txt.setAttribute("class", "textstyle");
	var txtnode = createSVGText(usedstr);
	txt.appendChild(txtnode);
	g.appendChild(txt);
	
	return g;	
}

/**
 *          
 * 
 * @param index      PIU        
 * @param text          
 */
function drawCurrentShowLable(info)
{
	var hasConnect = info.hasConnect.value;
	hasConnect = parseStrToBool(hasConnect);
	var srcIndex = info.srcIndex.value;
	var snkIndex = info.snkIndex.value;
	if(hasConnect && (srcIndex > snkIndex))
	{
		var tmp = snkIndex;
		snkIndex = srcIndex;
		srcIndex = snkIndex;
	}
	var currentValue = info.currentValue.value;
	drawCurrentUnit(srcIndex, currentValue);
}

/**
 *                      
 * @param index
 * @param text
 */
function drawCurrentUnit(index, currentValue)
{
	var id = CURRENT_GROUP_PREFIX + index;
	var g = createSVGElement("g");
	g.setAttribute("id", id);
	var x = getRelativeStartXPos(index);
	var path = createSVGElement("path");
	var lableWidth = 40;
	x = x - (lableWidth - BATTERY_WIDTH) / 2;
	var cx = 5;
	var cy = 3;
	var lx = x + cx;
	var rx = x + 40 - cx;
	var ty = Y_CURRENT_ORIGIN + cy;
	var by = Y_CURRENT_ORIGIN + 20 - cy;
	var data = "M" + x + "," + ty + " A" + cx + "," + cy + " 0 0,1 " + lx + "," + Y_CURRENT_ORIGIN
	         + " L" + rx + "," + Y_CURRENT_ORIGIN + " A" + cx + "," + cy + " 0 0,1 " + (x + lableWidth) + "," + ty
	         + " L" + (x + lableWidth) + "," + by + " A" + cx + "," + cy + " 0 0,1 " + rx + "," + (Y_CURRENT_ORIGIN + 20)
	         + " L" + lx + "," + (Y_CURRENT_ORIGIN + 20) + " A" + cx + "," + cy + " 0 0,1 " + x + "," + by + "Z";

	attr(path, {d:data});
	path.setAttribute("class", "currentlabelstyle");
	g.appendChild(path);
	
	var text = currentValue + "A";
	var pos = calcTextStartPos(text, 8, x + 20, Y_CURRENT_ORIGIN + 20);
	var txtid = CURRENT_TEXT_PREFIX + index;
	var txt = createSVGElement("text");
	attr(txt, extendObj(pos, {id:txtid, current:currentValue, isModified:false}));
	txt.setAttribute("class","textstyle");
	var txtnode = createSVGText(text);
	txt.appendChild(txtnode);
	g.appendChild(txt);
	
	lx = x + lableWidth - 5;
	rx = x + lableWidth;
	ty = Y_CURRENT_ORIGIN + 7;
	by = Y_CURRENT_ORIGIN + 13;
	var my = Y_CURRENT_ORIGIN + 10;
	data = "M" + lx + "," + ty + " L" + lx + "," + by + " L" + rx + "," + my;
	var horizonStr = "M" + lx + "," + ty + " L" + rx + "," + ty + " L" + (lx + rx) / 2 + "," + by;
	var arrowEle = createSVGElement("path");
	var arrowId = CURRENT_ARROW_PREFIX + index;
	attr(arrowEle, {id:arrowId, d:data, horizon:horizonStr, vertical:data});
	arrowEle.setAttribute("class", "traianglestyle");	
	g.appendChild(arrowEle);

	attachSVGEvent(g, "click", popuCurrentMenu);
	
	id = EXTEND_BATTERY_PREFIX + index;
	var extendnode = getSVGElement(id);
	if(extendnode)
	{
		extendnode.appendChild(g);
	}		
}
/**
 *   PIU       
 * @param index
 * @param text
 * @returns
 */
function drawPIUShowLabel(info)
{
	var hasConnect = info.hasConnect.value;
	hasConnect = parseStrToBool(hasConnect);
	var index = info.srcIndex.value;
    var text = info.srcSlotID.value;
    drawPiuUnit(index, text);
    if(hasConnect)
    {
    	index = info.snkIndex.value;
    	text = info.snkSlotID.value;
        drawPiuUnit(index, text);
    }   
}

/**
 *   PIU   
 * @param index
 * @param text
 */
function drawPiuUnit(index, text)
{
	var id = PIU_BOARD_PREFIX + index;
	var g = createSVGElement("g");
	g.setAttribute("id", id);
	var x = getRelativeStartXPos(index);
	var rect = createSVGElement("rect");
	var rectattr = {x:x, y:Y_PIU_ORIGIN, width:30, height:50};
	var boardstyle = getPIUBoardStyle(index);
	attr(rect, rectattr);
	rect.setAttribute("class", boardstyle);
	g.appendChild(rect);

	var txtid = "PIU_text_" + index;
	var txtEle = draw2LayerText("PIU", text, 6, x + 15, Y_PIU_ORIGIN + 30, txtid);
	g.appendChild(txtEle);
	
	attachSVGEvent(g, "click",  drawConnectTip);
	attachSVGEvent(g, "mouseover", hightlightBoard);
	attachSVGEvent(g, "mouseout", removeBoradHighlight);
	
	id = EXTEND_BATTERY_PREFIX + index;
	var extendnode = getSVGElement(id);
	if(extendnode)
	{
		extendnode.appendChild(g);
	}
}

/**
 *            
 * @param info
 */
function drawBatterPowerText(info)
{
	var hasConnect = info.hasConnect.value;
	hasConnect = parseStrToBool(hasConnect);
	var index = info.srcIndex.value;
	var current = info.currentValue.value;
	var power = getMAXPower(current);
	var text = power + "W";
	drawBatterPowerTextUnit(index, text);
	if(hasConnect)
	{
		index = info.snkIndex.value;
		text = "0W";
		drawBatterPowerTextUnit(index, text);
	}
}

/**
 *                    
 * @param index
 * @param text
 */
function drawBatterPowerTextUnit(index, text)
{
	var fontsize = 7;
	var len = text.length * fontsize;
	var centerX = getRelativeStartXPos(index) + 15;
	var startX = centerX - len / 2 - 1;
	
	var id = BATTERY_POWERTEXT_PREFIX + index;
	var ele = getSVGElement(id);
	if(null != ele)
	{
		ele.setAttribute("x", startX);
		var childs = ele.childNodes;
		var length = childs.length;
		if(length > 0)
		{
			for(var i = 0; i < length; i++)
			{
				var child = childs.item(i);
				if("#text" == child.nodeName)
				{
					child.nodeValue = text;
				}
			}
		}
		else
		{
			var txt = createSVGText(text);
			ele.appendChild(txt);
		}
		setFontSize(ele, 10);
		if(isFF)
		{
			setFontSize(ele, 9);
		}
	}
}

/**
 *                  PIU       
 * @param index
 * @param flag
 */
function setBatteryDisplay(index, flag)
{
	var id = BATTERY_GROUP_PREFIX + index;
	var ele = getSVGElement(id);
	if(null != ele)
	{
		if(flag)
		{
			ele.setAttribute("display", "");
		}
		else
		{
			ele.setAttribute("display", "none");
		}
	}
}

/**
 *                               green               1.        gray
 * 2.                 gray     green
 * @param info
 */
function changeLineStyle(info)
{
	var srcIndex = info.srcIndex.value;
	var snkIndex = info.snkIndex.value;
	var hasConnect = info.hasConnect.value;
	hasConnect = parseStrToBool(hasConnect);
	if(hasConnect && (srcIndex > snkIndex))
	{
		var tmp = snkIndex;
		snkIndex = srcIndex;
		srcIndex = tmp;
	}
	var currentValue = info.currentValue.value;
	var power = getMAXPower(currentValue);
	var hasPower = (0 != power);
	var id = LINE_BATTERY_PREFIX + srcIndex;
	var ele = getSVGElement(id);
	redrawSrcLine(ele, hasPower);	
	if(hasConnect)
	{
		var y = getConnectPosY(srcIndex,snkIndex);
		id = LINE_BATTERY_PREFIX + snkIndex;
		ele = getSVGElement(id);
		redrawSnkLine(ele, hasPower, y);
	}
}

/**
 *       
 * @param ele
 * @param hasPower
 */
function redrawSrcLine(ele,hasPower)
{
	if(null != ele)
	{
		var linestyle = "linedefault";
		var circlestyle = "circledefault";
		if(hasPower)
		{
			linestyle = "linenew";
			circlestyle = "circlenew";
		}		
		var childs = ele.childNodes;
		for(var i = 0, len = childs.length; i < len; i++)
		{
			var child = childs.item(i);
			if(child.nodeName == "line")
			{
				child.setAttribute("class", linestyle);
			}
			if(child.nodeName == "circle")
			{
				child.setAttribute("class", circlestyle);
			}
		}
	}	
}

/**
 *       PIU                         
 * @param ele
 */
function redrawSnkLine(ele, hasPower, y)
{
	if(null != ele)
	{
        var childs = ele.childNodes;
		for(var i = 0, len = childs.length; i < len; i++)
		{
			var child = childs.item(i);
			var place = 0;
			if(child.nodeName == "line")
			{
				if(hasPower)
				{
					place = child.getAttribute("place");
					if("0" == place)
					{
						child.setAttribute("class", "linedefault");
						child.setAttribute("y2", y);
					}
					else
					{
						child.setAttribute("class", "linenew");
						child.setAttribute("y1", y);
					}
				}
				else
				{
					child.setAttribute("class", "linedefault");
				}
			}
			if(child.nodeName == "circle")
			{
				if(hasPower)
				{
					child.setAttribute("class", "circlenew");
				}
				else
				{
					child.setAttribute("class", "circledefault");
				}
			}
		}
	}
}

/**
 *          startX, startY
 * 
 * @param text     
 * @param fontsize     
 * @param centerX    X  
 * @param centerY      Y  
 */
function calcTextStartPos(text, fontsize, centerX, centerY)
{
	var len = text.length * fontsize;
	var startX = centerX - len / 2;
	var startY = centerY - 5;
	var pos = {x:startX, y:startY};
	
	return pos;
}

/**
 *                 X  
 * @param index
 * @returns {Number}
 */
function getRelativeStartXPos(index)
{
	if(index >= PIU_NUM_EACHSIDE)
	{
		index -= PIU_NUM_EACHSIDE;
	}
	var startX = X_ORIGIN_R + index * UNITE_WIDTH;
	
	return startX;
}

/**
 *                    X  
 * @param index
 * @returns {Number}
 */
function getAbsoluteCenterXPos(index)
{  
	if(subrackType == SUBRACK_9800U32 || subrackType == SUBRACK_9600U32)
	{
		X_ORIGIN_A = 190;
	}
	var x = X_ORIGIN_A + index * UNITE_WIDTH + 15;
	if(index > 4)
	{
		x = 290 + (index - 4) * UNITE_WIDTH + 15;
	}
	
	return x;
}

/**
 *        PIU      PIU          
 * @param index
 */
function showPossibleConnecteBoard(index)
{
	var indexList = getPossibleConnectBoard(subrackType, index);
	var id = SHOW_LABEL_PREFIX + index;
	var g = createSVGElement("g");
	g.setAttribute("id", id);
	for(var i = 0, len = indexList.length; i < len; i++)
	{
		var idx = indexList[i];
		var isExist = isConnectBoardExist(index, idx);
		if(!isExist)
		{
			continue;
		}
		var x0 = getAbsoluteCenterXPos(index);
		var y0 = getConnectPosY(index, idx);
		var path = createSVGElement("path");
		var data;
		if(idx < index)
		{
			data = "M" + x0 + "," + y0 + " L" + (x0 - 20) + "," + y0
	         + " M" + (x0 - 15) + "," + (y0 - 5) + " L" + (x0 - 20) + "," + y0
	         + " L" + (x0 - 15) + "," + (y0 + 5);
		}
		else
		{
			data = "M" + x0 + "," + y0 + " L" + (x0 + 20) + "," + y0
	         + " M" + (x0 + 15) + "," + (y0 - 5) + " L" + (x0 + 20) + "," + y0
	         + " L" + (x0 + 15) + "," + (y0 + 5);
		}

		path.setAttribute("d", data);
		path.setAttribute("class","arrowstyle");
		g.appendChild(path);

		var x = getAbsoluteCenterXPos(idx);
		var cx = 0;
		var cy = SEMI_CIRCLE_CY;
		if(x > x0)
		{
			cx = (x - x0) / 2;
			data = "M" + x0 + "," + y0 + " A" + cx + "," + cy + " 0 0,1 " + x + "," + y0;
		}
		else
		{
			cx = (x0 - x) / 2;
			data = "M" + x0 + "," + y0 + " A" + cx + "," + cy + " 0 0,0 " + x + "," + y0;
		}
		var arcEle = createSVGElement("path");
        attr(arcEle, {d:data});
        arcEle.setAttribute("class", "semiarcstyle");
        g.appendChild(arcEle);
        
		var circleEle = createSVGElement("circle");
		attr(circleEle, {cx:x, cy:y0, r:10});
		var style = getCircleStyle(idx);
		circleEle.setAttribute("class", style);
		var tmpIndex = index;
        if(tmpIndex > idx)
        {
        	var tmp = idx;
        	idx = tmpIndex;
        	tmpIndex = tmp;
        }
		var idc = BOARD_LINE_PREFIX + tmpIndex + "_" + idx;
		circleEle.setAttribute("id", idc);
		g.appendChild(circleEle);
        
		attachSVGEvent(circleEle, "click", drawConnectLineHandler);
	}
	var root = getSVGElement("connectrelation");
	if(root)
	{
		root.appendChild(g);
	}
}


/**
 *                PIU           
 * @param index
 * @param text
 * @returns
 */
function drawPayloadText(info)
{
	var g = createSVGElement("g");
	var index = info.srcIndex.value;
	var hasConnect = info.hasConnect.value;
	hasConnect = parseStrToBool(hasConnect);
	var txtid = PAYLOAD_TEXT_PREFIX + index;
	var centerX = getRelativeStartXPos(index) + 15;
	var centerY = getBottomYPos(index);
	var text = info.srcUsedPower.value + "W";
	var txt = draw2LayerText("Payload", text, 6, centerX, centerY + 10, txtid);
	g.appendChild(txt);
	if(hasConnect)
	{
		index = info.snkIndex.value;
		txtid = PAYLOAD_TEXT_PREFIX + index;
		centerX = getRelativeStartXPos(index) + 15;
		centerY = getBottomYPos(index);
		text = info.snkUsedPower.value + "W";
		var snktxt = draw2LayerText("Payload", text, 6, centerX, centerY + 10, txtid);
		g.appendChild(snktxt);
	}
	return g;
}

/**
 *       y      
 * 
 * @param srcIndex
 * @param snkIndex
 * @param posY y  
 */
function drawConnectLine(srcIndex,snkIndex,posY)
{
    if(srcIndex > snkIndex)
    {
    	tmp = snkIndex;
    	snkIndex = srcIndex;
    	srcIndex = tmp;
    }
	var x1 = getAbsoluteCenterXPos(srcIndex);
	var x2 = getAbsoluteCenterXPos(snkIndex);
	var id = CONNECT_LINE_PREFIX + srcIndex + "_" + snkIndex;
	var child = getSVGElement(id);
	if((srcIndex == snkIndex) || null != child)
	{
		return;
	}
	var g = createSVGElement("g");
	attr(g, {id:id, y:posY});
	var line = createSVGElement("line");
	var lineattr = {x1:x1, y1:posY, x2:x2, y2:posY};
	attr(line, lineattr);
	line.setAttribute("class", "connectline");
	g.appendChild(line);
	
	var srccircle = createSVGElement("circle");
	lineattr = {cx:x1, cy:posY, r:5};
	attr(srccircle, lineattr);
	srccircle.setAttribute("class", "connectcircle");
	g.appendChild(srccircle);
	
	var snkcircle = createSVGElement("circle");
	lineattr = {cx:x2, cy:posY, r:5};
	attr(snkcircle, lineattr);
	snkcircle.setAttribute("class", "connectcircle");
	g.appendChild(snkcircle);
	
	attachSVGEvent(g, "click", drawDeleteShowLable);
	attachSVGEvent(g, "mouseover", highlightConnectLine);
	attachSVGEvent(g, "mouseout", removeConnectLineHightlight);
	
	var connectroot = getSVGElement("connectrelation");
	if(connectroot)
	{
		connectroot.appendChild(g);
	}
	
	id = CURRENT_GROUP_PREFIX + snkIndex;
	var ele = getSVGElement(id);
	if(null != ele)
	{
		ele.setAttribute("display", "none");
	}
	id = LINE_BATTERY_PREFIX + snkIndex;
	ele = getSVGElement(id);
	if(null != ele)
	{
		redrawSnkLine(ele, true, posY);
	}
}

/**
 *        ,          
 * @param evt
 */
function highlightConnectLine(evt)
{
	evt = evt ? evt : window.event;
	var target = evt.target;
	if(target && target.parentNode)
	{
		var pnode = target.parentNode;
		var childs = pnode.childNodes;
		var idstr = pnode.getAttribute("id");
		if(!idstr || "" == idstr)
		{
			return ;
		}
		var index = idstr.indexOf(CONNECT_LINE_PREFIX);
		if(index > -1)
		{
            var ids = idstr.split("_");
            var srcIndex = ids[1];
            var snkIndex = ids[2];
            if(srcIndex > snkIndex)
            {
            	tmp = snkIndex;
            	snkIndex = srcIndex;
            	srcIndex = tmp;
            }
            var id = DELETE_LABEL_PREFIX + srcIndex + "_" + snkIndex;
            var gele = getSVGElement(id);
        	for(var i = 0, len = childs.length; i < len; i++)
        	{
        		var child = childs.item(i);
        		if(child.nodeName == "circle")
        		{
        			if(null == gele)
        			{
            			child.setAttribute("class", "connectcircle1");
        			}
        			else
        			{
            			child.setAttribute("class", "connectcircle");
        			}
        		}
        		else if(child.nodeName == "line")
        		{
        			if(null == gele)
        			{
            			child.setAttribute("class", "connectline1");
        			}
        			else
        			{
            			child.setAttribute("class", "connectline2");
        			}
        		}
        	}
		}
	}
}

/**
 *       
 * @param evt
 */
function removeConnectLineHightlight(evt)
{
	evt = evt ? evt : window.event;
	var target = evt.target;
	if(target && target.parentNode)
	{
		var pnode = target.parentNode;
		var childs = pnode.childNodes;
		var idstr = pnode.getAttribute("id");
		if(!idstr || "" == idstr)
		{
			return ;
		}
		var index = idstr.indexOf(CONNECT_LINE_PREFIX);
		if(index > -1)
		{
            var ids = idstr.split("_");
            var srcIndex = ids[1];
            var snkIndex = ids[2];
            if(srcIndex > snkIndex)
            {
            	var tmp = snkIndex;
            	snkIndex = srcIndex;
            	srcIndex = snkIndex;
            }
            var id = DELETE_LABEL_PREFIX + srcIndex + "_" + snkIndex;
            var gele = getSVGElement(id);
        	for(var i = 0, len = childs.length; i < len; i++)
        	{
        		var child = childs.item(i);
        		if(child.nodeName == "circle")
        		{
        			child.setAttribute("class", "connectcircle");
        		}
        		else if(child.nodeName == "line")
        		{
        			if(null == gele)
        			{
            			child.setAttribute("class", "connectline");
        			}
        			else
        			{
            			child.setAttribute("class", "connectline2");
        			}
        		}
        	}
		}
	}
}

/**
 *           
 * @param evt
 */
function drawConnectLineHandler(evt)
{
	evt = evt ? evt : window.event;
	var target = evt.target;
	var id = target.getAttribute("id");
	var y = target.getAttribute("cy");
	if(id.indexOf(BOARD_LINE_PREFIX) > -1)
	{
		var ids = id.substring(BOARD_LINE_PREFIX.length).split("_");
		var srcIndex = ids[0];
		var snkIndex = ids[1];
        if(srcIndex > snkIndex)
        {
        	var tmp = srcIndex;
        	srcIndex = snkIndex;
        	snkIndex = tmp;
        }
		drawConnectLine(srcIndex, snkIndex, y);
	    $("powersettingbtn").disabled = !btnRightArr.applybtn.right;
		/**
		 *                                   
		 *                             
		 */
		id = SHOW_LABEL_PREFIX + srcIndex;
		destroyShowLabel(id);
		id = SHOW_LABEL_PREFIX + snkIndex;
		destroyShowLabel(id);
	}
}

/**
 *         ,        PIU    
 * 
 * @param idstr
 */
function destroyConnectLine(idstr)
{
	if(!idstr || "" == idstr)
	{
		return ;
	}
	var index = idstr.indexOf(CONNECT_LINE_PREFIX);
	if(index > -1)
	{
		var connectroot = getSVGElement("connectrelation");
		var child = getSVGElement(idstr);
		if(connectroot && child)
		{
			connectroot.removeChild(child);
		}
	}
}

/**
 *   PIU      
 *                 PIU        
 * @param index     PIU 
 */
function destroyGraphUnit(info)
{
	var index = info.srcIndex.value;
	var hasConnect = info.hasConnect.value;
	hasConnect = parseStrToBool(hasConnect);
	var id = EXTEND_BATTERY_PREFIX + index;
	var ele = getSVGElement(id);
	if(ele)
	{
		var nodes = ele.childNodes;
		for(var i = nodes.length - 1; i >= 0; i--)
		{
			ele.removeChild(nodes.item(i)); //         ,IE         nodes[i]   nodes.item(i)
		}
	}
	if(hasConnect)
	{
		index = info.snkIndex.value;
		id = EXTEND_BATTERY_PREFIX + index;
		ele = getSVGElement(id);
		if(ele)
		{
			var nodes = ele.childNodes;
			for(var i = nodes.length - 1; i >= 0; i--)
			{
				ele.removeChild(nodes.item(i)); //         ,IE         nodes[i]   nodes.item(i)
			}
		}
		
		id = CONNECT_LINE_PREFIX + info.srcIndex.value + "_" + info.snkIndex.value;
		destroyConnectLine(id);
	}
}

/**
 *         
 */
function destroyConnectionArea()
{
	var ele = getSVGElement("connectrelation");
	if(ele)
	{
		var childs = ele.childNodes;
		var len = childs.length;
		for(var i = len - 1; i >= 0; i--)
		{
			ele.removeChild(childs.item(i));
		}
	}
}

/**
 *            
 */
function destroyCurrentListArea()
{
	var ele = getSVGElement("svg_current_list");
	if(ele)
	{
		var childs = ele.childNodes;
		var len = childs.length;
		for(var i = len - 1; i >= 0; i--)
		{
			ele.removeChild(childs.item(i));
		}
	}
}

/**
 *        
 * @param evt
 */
function deleteConnectLine(evt)
{
	evt = evt ? evt : window.event;
	var target = evt.target;
	var pnode = target.parentNode;
	var id = pnode.getAttribute("id");
	if(id.indexOf(DELETE_LABEL_PREFIX) > -1)
	{
		var idstr = id.substring(DELETE_LABEL_PREFIX.length);
        var ids = idstr.split("_");
        var srcIndex = ids[0];
        var snkIndex = ids[1];
        if(srcIndex > snkIndex)
        {
        	var tmp = snkIndex;
        	snkIndex = srcIndex;
        	srcIndex = tmp;
        }
		var idn = CONNECT_LINE_PREFIX + srcIndex + "_" + snkIndex;
		destroyConnectLine(idn);
		destroyShowLabel(id);
        $("powersettingbtn").disabled = !btnRightArr.applybtn.right;
		id = CURRENT_GROUP_PREFIX + snkIndex;
		var ele = getSVGElement(id);
		if(null != ele)
		{
			ele.setAttribute("display", "");
		}
		else
		{
			drawCurrentUnit(snkIndex, '0');
		}
		id = LINE_BATTERY_PREFIX + snkIndex;
		ele = getSVGElement(id);
		if(null != ele)
		{
			redrawSnkLine(ele, false);
		}		
	}
}

/**
 *          
 */
function destroyAllShowLabel()
{
	var connectroot = getSVGElement("connectrelation");
	var childs = connectroot.childNodes;
	for(var i = childs.length - 1; i >= 0; i--)
	{
		var child = childs.item(i);
		var id = child.getAttribute("id");
		if(id.indexOf(DELETE_LABEL_PREFIX) > -1)
		{
			connectroot.removeChild(child);
		}
		if(id.indexOf(SHOW_LABEL_PREFIX) > -1)
		{
			connectroot.removeChild(child);
		}
	}
	var currentroot = getSVGElement("svg_current_list");
	var childs = currentroot.childNodes;
	for(var i = childs.length - 1; i >=0; i--)
	{
		var child = childs.item(i);
		var id = child.getAttribute("id");
		if(id.indexOf(CURRENT_LIST_PREFIX) > -1)
		{
			currentroot.removeChild(child);
			var index = id.substring(CURRENT_LIST_PREFIX.length);
			var arrowEle = getSVGElement(CURRENT_ARROW_PREFIX + index);
			if(null != arrowEle)
			{
				var vData = arrowEle.getAttribute("vertical");
				if(null != vData)
				{
					arrowEle.setAttribute("d", vData);
				}
			}
		}
	}
}

/**
 *                  
 * @param evt
 */
function clearAllShowLabel(evt)
{
	evt = evt ? evt : window.event;
	var target = evt.target;
	var isblank = target.getAttribute("blank");
	if(isblank)
	{
		destroyAllShowLabel();
	}
}

/**
 *       
 * 
 * @param txt1
 * @param txt2
 * @param fontsize
 * @param centerX
 * @param centerY
 * @returns
 */
function draw2LayerText(txt1, txt2, fontsize, centerX, centerY, id)
{
	var pos_1 = calcTextStartPos(txt1, fontsize, centerX, centerY);
	var pos_2 = calcTextStartPos(txt2, fontsize, centerX, centerY + 15);

	var g = createSVGElement("g");
	g.setAttribute("id", id);
	g.setAttribute("class","textstyle");
	var txt_1 = createSVGElement("text");
	attr(txt_1, pos_1);
	var txtnode_1 = createSVGText(txt1);
	txt_1.appendChild(txtnode_1);
	g.appendChild(txt_1);
	
	var txt_2 = createSVGElement("text");
	attr(txt_2, pos_2);
	var txtnode_2 = createSVGText(txt2);
	txt_2.appendChild(txtnode_2);
	g.appendChild(txt_2);
	
	return g;
}

/**
 *                  
 * @param index
 * @param payload
 * @param hasconnect
 */
function redrawBatteryUsageElement(index, payload, hasconnect)
{
	var id = BATTERY_USAGE_PREFIX + index;
	var oldEle = getSVGElement(id);
	if(!oldEle)
	{
		return ;
	}
	var newNode = drawBatteryUsageElement(index, payload, hasconnect);
	if(oldEle.parentNode && newNode)
	{
		var pnode = oldEle.parentNode;
		pnode.replaceChild(newNode, oldEle);
	}
}

/**
 *            
 * @param index
 * @param current
 */
function redrawCurrentText(index, current)
{
	var x = getRelativeStartXPos(index);
	var text = current + "A";
	var pos = calcTextStartPos(text, 8, x + 15, Y_CURRENT_ORIGIN + 20);
	var txtid = CURRENT_TEXT_PREFIX + index;
	var txt = createSVGElement("text");
	attr(txt, extendObj(pos, {id:txtid, current:current}));
	txt.setAttribute("class","textstyle");
	var txtnode = createSVGText(text);
	txt.appendChild(txtnode);
	
	var ele = getSVGElement(txtid);
	if(!ele)
	{
		var id = CURRENT_GROUP_PREFIX + index;
		var pele = getSVGElement(id);
		if(pele)
		{
			pele.appendChild(txt);
		}
	}
	if(ele.parentNode)
	{
		var pnode = ele.parentNode;
		pnode.replaceChild(txt, ele);
	}
}

/**
 *          
 * @param index
 * @param payload
 * @returns
 */
function redrawPayloadText(index, payload)
{
	var txtid = PAYLOAD_TEXT_PREFIX + index;
	var ele = getSVGElement(txtid);
	if(!ele)
	{
		return ;
	}
	var centerX = getRelativeStartXPos(index) + 15;
	var centerY = getBottomYPos(index);
	var text = payload + "W";
	var txtnode = draw2LayerText("Payload", text, 6, centerX, centerY + 10, txtid);
	
	if(ele.parentNode)
	{
		var pnode = ele.parentNode;
		pnode.replaceChild(txtnode, ele);
	}
}

/**
 *             X
 * @param evt
 */
function drawDeleteShowLable(evt)
{
	evt = evt ? evt : window.event;
	var target = evt.target;
	if(target && target.parentNode)
	{
		var pnode = target.parentNode;
		var idstr = pnode.getAttribute("id");
		if(!idstr || "" == idstr)
		{
			return ;
		}
		var index = idstr.indexOf(CONNECT_LINE_PREFIX);
		if(index > -1)
		{
            var ids = idstr.split("_");
            var srcIndex = ids[1];
            var snkIndex = ids[2];
            if(srcIndex > snkIndex)
            {
            	var tmp = snkIndex;
            	snkIndex = srcIndex;
            	srcIndex = tmp;
            }
            var startX = getAbsoluteCenterXPos(srcIndex);
            var endX = getAbsoluteCenterXPos(snkIndex);
            var x = (startX + endX) / 2 - 10;
            var y = CONNECT_LINE_Y;
        	var cid = CONNECT_LINE_PREFIX + srcIndex + "_" + snkIndex;
        	var child = getSVGElement(cid);
        	if(null == child)
        	{
            	cid = CONNECT_LINE_PREFIX + snkIndex + "_" + srcIndex;
            	child = getSVGElement(cid);
        	}
        	if(null != child)
        	{
        		y = pInt(child.getAttribute("y"));
        		var ch = child.childNodes;
        		for(var i = 0, len = ch.length; i < len; i++)
        		{
        			var item = ch.item(i);
        			if("line" == item.nodeName)
        			{
        				item.setAttribute("class", "connectline2");
        			}
        		}
        		
        	}
            
            var id = DELETE_LABEL_PREFIX + srcIndex + "_" + snkIndex;
            var gele = getSVGElement(id);
            if(gele)
            {
            	return ;
            }
            var g = createSVGElement("g");
            g.setAttribute("id", id);
            g.setAttribute("class", "crossstyle");
            var rect = createSVGElement("rect");
            attr(rect,{x:x - 5,y:y - 5,width:10,height:10});
            rect.setAttribute("style", "fill:gray;stroke:none");
            g.appendChild(rect);
            var line_1 = createSVGElement("line");
            var lineattr = {x1:(x-5), y1:y-5, x2:(x+5), y2:y+5};
            attr(line_1, lineattr);
            g.appendChild(line_1);
            var line_2 = createSVGElement("line");
            var lineattr = {x1:(x-5), y1: y+5, x2:(x+5), y2:y-5};
            attr(line_2, lineattr);
            g.appendChild(line_2);
                       
            attachSVGEvent(g, "click", deleteConnectLine);
            
            var connectroot = getSVGElement("connectrelation");
            connectroot.appendChild(g);
		}
	}
}

/**
 *         
 * @param evt
 */
function drawConnectTip(evt)
{
	evt = evt ? evt : window.event;
	var target = evt.target;
	var pnode = target.parentNode;
	var id = pnode.getAttribute("id");
	destroyAllShowLabel();
	if(id.indexOf("PIU_text_") > -1)
	{
		id = pnode.parentNode.getAttribute("id");
	}
	if(id.indexOf(PIU_BOARD_PREFIX) > -1)
	{
		var index = id.substring((PIU_BOARD_PREFIX).length);

		showPossibleConnecteBoard(index);
	}
}

/**
 *                    
 * @param evt
 */
function drawDirectionArrow(index)
{
	var isLeft = false;
	var isBoth = false;
	var isRight = false;
	var boardList = getPossibleConnectBoard(subrackType, index);
	if(null == boardList || boardList.length == 0)
	{
		return ;
	}
	for(var i = 0, len = boardList.length; i < len; i++)
	{
		var ix = boardList[i];
		if(ix > index)
		{
			isRight = true;
		}
		if(ix < index)
		{
			isLeft = true;
		}
	}
	if(isRight && isLeft)
	{
		isBoth = true;
	}
	else
	{
		isBoth = false;
	}
	var x = getAbsoluteCenterXPos(index);
	var y = CONNECT_LINE_Y;
	var x1 = x + 10;
	id = SHOW_LABEL_PREFIX + index;
	var g = createSVGElement("g");
	g.setAttribute("id", id);
	var path = createSVGElement("path");
	var data;
	if(isBoth)
	{
		data = "M" + (x - 20) + "," + y + " L" + (x + 20) + "," + y
        + " M" + (x - 15) + "," + (y - 5) + " L" + (x - 20) + "," + y
        + " L" + (x - 15) + "," + (y + 5) +  " M" + (x + 15) + "," + (y - 5)
        + " L" + (x + 20) + "," + y + " L" + (x + 15) + "," + (y + 5);
	}
	else
	{
		if(isLeft)
		{
			data = "M" + x + "," + y + " L" + (x - 20) + "," + y
	         + " M" + (x - 15) + "," + (y - 5) + " L" + (x - 20) + "," + y
	         + " L" + (x - 15) + "," + (y + 5);
		}
		else
		{
			data = "M" + x + "," + y + " L" + (x + 20) + "," + y
	         + " M" + (x + 15) + "," + (y - 5) + " L" + (x + 20) + "," + y
	         + " L" + (x + 15) + "," + (y + 5);
		}
	}

	path.setAttribute("d", data);
	path.setAttribute("class","arrowstyle");
	g.appendChild(path);
	
	var root = getSVGElement("connectrelation");
	if(root)
	{
		root.appendChild(g);
	}
}

function drawTriangleTip(ele, attr)
{
	data = "M" + lx + "," + ty + " L" + lx + "," + by + " L" + rx + "," + my;
	var arrowEle = createSVGElement("path");
	attr(arrowEle, {d:data});
	arrowEle.setAttribute("class", "traianglestyle");
	g.appendChild(arrowEle);
}

/**
 *            X
 * @param evt
 */
function destroyShowLabel(id)
{
	ele = getSVGElement(id);
	if(ele && ele.parentNode)
	{
		var pnode = ele.parentNode;
		pnode.removeChild(ele);
	}
}

/**
 *                         
 * @param evt
 */
function popuCurrentMenu(evt)
{
	evt = evt ? evt : window.event;
	var target = evt.target;
	var pnode = target.parentNode;
	var id = pnode.getAttribute("id");
	if(id.indexOf(CURRENT_GROUP_PREFIX) > -1)
	{
		var index = id.substring(CURRENT_GROUP_PREFIX.length);
		drawCurrentMenu(index);
		var arrowEle = getSVGElement(CURRENT_ARROW_PREFIX + index);
		if(null != arrowEle)
		{
			var hData = arrowEle.getAttribute("horizon");
			if(null != hData)
			{
				arrowEle.setAttribute("d", hData);
			}
		}
	}
}

/**
 *                
 */
function rotateCurrentTraiangle()
{
	
}

/**
 *               
 * @param evt
 */
function cmenu_mousemove(evt)
{
	evt = evt ? evt : window.event;
	var target = evt.target;
	var pnode = target.parentNode;
	var childs = pnode.childNodes;
	for(var i = 0, len = childs.length; i < len; i++)
	{
		var child = childs.item(i);
		if("rect" == child.nodeName)
		{
			child.setAttribute("class", "currentmenumove");
		}
	}
}

/**
 *             
 * @param evt
 */
function cmenu_mouseout(evt)
{
	evt = evt ? evt : window.event;
	var target = evt.target;
	var pnode = target.parentNode;
	var childs = pnode.childNodes;
	for(var i = 0, len = childs.length; i < len; i++)
	{
		var child = childs.item(i);
		if("rect" == child.nodeName)
		{
			child.setAttribute("class", "currentmenustatic");
		}
	}
}

/**
 *             
 * @param evt
 */
function cmenu_click(evt)
{
	evt = evt ? evt : window.event;
	var target = evt.target;
	var pnode = target.parentNode;
	var childs = pnode.childNodes;
	var id = pnode.getAttribute("id");
	if(id.indexOf(CURRENT_LIST_PREFIX) > -1)
	{
		var idstr = id.substring(CURRENT_LIST_PREFIX.length);
		var index = idstr.split("_")[0];
		for(var i = 0, len = childs.length; i < len; i++)
		{
			var child = childs.item(i);
			if("text" == child.nodeName)
			{
	            var current = child.getAttribute("current");
	            redrawCurrentText(index, current);
	            
	        	var hasPower = (0 != current);
	        	var id = LINE_BATTERY_PREFIX + index;
	        	var ele = getSVGElement(id);
	        	redrawSrcLine(ele, hasPower);
	        	
	            child.setAttribute("isModified", true);
	            $("powersettingbtn").disabled = !btnRightArr.applybtn.right;
	            break;
			}
		}
		id = CURRENT_LIST_PREFIX + index;
        var ele = getSVGElement(id);
        if(ele && ele.parentNode)
        {
            var pnode = ele.parentNode;
            pnode.removeChild(ele);
        }
        
		var arrowEle = getSVGElement(CURRENT_ARROW_PREFIX + index);
		if(null != arrowEle)
		{
			var hData = arrowEle.getAttribute("vertical");
			if(null != hData)
			{
				arrowEle.setAttribute("d", hData);
			}
		}
	}
}

/**
 *   PIU         
 * @param index
 */
function drawCurrentMenu(index)
{
	destroyAllShowLabel();
	
	var currentList = getAvaliableCurrent(index);
	var defaultOption = getDefaultOption(index);
	
	var g = createSVGElement("g");
	var id = CURRENT_LIST_PREFIX + index;
	g.setAttribute("id", id);
	
	var x = getAbsoluteCenterXPos(index);
	var y = Y_CURRENT_ORIGIN + 20;
	var height = currentList.length * 15;
	var x1 = x + 5;
	var x2 = x - 10;
	var x3 = x + 40;
	var x4 = x + 15;
	var y1 = y + 10;
	var y2 = y + 10 + height;
	var data = "M" + x + "," + y + " L" + x1 + "," + y1 + " L" + x2 + "," + y1
	         + " L" + x2 + "," + y2 + " L" + x3 + "," + y2 + " L" + x3 + "," + y1
	         + " L" + x4 + "," + y1 + "Z";
	var path = createSVGElement("path");
	path.setAttribute("d", data);
	path.setAttribute("class", "currentmenustyle");
	g.appendChild(path);
    var needAdjustYPos = false;
	for(var i = 0, len = currentList.length; i < len; i++)
	{
		var current = currentList[i];
		if(0 == current && needHiddenZeroCurrent(index))
		{
			needAdjustYPos = true;
			continue;
		}
		var gele = createSVGElement("g");
		id =  CURRENT_LIST_PREFIX + index + "_" + i;
		attr(gele, {id:id});
		
		x1 = x - 10;
		y1 = y + 15 * i + 10;
		if(needAdjustYPos)
		{
			y1 = y + 15 * i - 5;
		}
		var rect = createSVGElement("rect");
		attr(rect, {x:x1, y:y1, width:50, height:15});
		rect.setAttribute("class","currentmenustatic");
		gele.appendChild(rect);
				
		var text = createSVGElement("text");
		attr(text, {x:x1+5,y:y1+13,current:current});
		text.setAttribute("class", "textstyle");
		var txt = current + "A";
		var txtnode = createSVGText(txt);
		text.appendChild(txtnode);
		gele.appendChild(text);
		
		attachSVGEvent(gele, "mousemove", cmenu_mousemove);
		attachSVGEvent(gele, "mouseout", cmenu_mouseout);
		attachSVGEvent(gele, "click", cmenu_click);
				
		g.appendChild(gele);		
	}
	
	var root = getSVGElement("svg_current_list");
	if(root)
	{
		root.appendChild(g);
	}
}

/**
 *     PIU    
 * @param evt
 */
function hightlightBoard(evt)
{
	evt = evt ? evt : window.event;
	var target = evt.target;
	var pnode = target.parentNode;
	var childs = pnode.childNodes;
	for(var i = 0, len = childs.length; i < len; i++)
	{
		var child = childs.item(i);
		if("rect" == child.nodeName)
		{
			child.style.opacity = 0.7;
	        break;
		}
	}
}

/**
 *             
 * @param evt
 */
function removeBoradHighlight(evt)
{
	evt = evt ? evt : window.event;
	var target = evt.target;
	var pnode = target.parentNode;
	var childs = pnode.childNodes;
	var len = childs.length;
	for(var i = len - 1; i >= 0; i--)
	{
		var child = childs.item(i);
		if("rect" == child.nodeName)
		{
			child.style.opacity = 1.0;
		}
		if("path" == child.nodeName)
		{
			pnode.removeChild(child);
		}
	}
}

function showCreateConnectTriangle(index)
{
	var x = getRelativeStartXPos(index);
	var lx = x + 20;
	var rx = x + 30;
	var my = Y_PIU_ORIGIN + 10;
	var ty = Y_PIU_ORIGIN + 5;
	var by = Y_PIU_ORIGIN + 15;
	var data = "M" + lx + "," + ty + " L" + lx + "," + by + " L" + rx + "," + my;
	var arrowEle = createSVGElement("path");
	attr(arrowEle, {d:data});
	arrowEle.setAttribute("class", "traianglestyle");	
	attachSVGEvent(arrowEle, "click", popuCurrentMenu);
	
	return arrowEle;
}
