window.thresholdconf = [];

/**
 *     PIU           
 *                 
 *    -          (           )
 * @param currentValue
 * @returns {Number}
 */
function getMAXPower(currentValue)
{
	var maxPower = 0;
	switch(currentValue)
	{
	case "0":
		maxPower = 0;
		break;
	case "63":
		maxPower = 2400;
		break;
	case "100":
		maxPower = 4000;
		break;
	case "120":
		maxPower = 4800;
		break;
	default:
	    break;
	}
	
	return maxPower;
}

/**
 *   PIU       (             )
 * @param index 0-9
 * index 0 -4     100-104
 * 5-9     106-110
 * 0,5                       63A
 *                63A               0A
 *          0,63,100,120
 * @returns
 */
function getAvaliableCurrent(index)
{
	var currentList = [];
	switch(index)
	{
	case "0":
	case "5":
		currentList = [63];
		break;
	case "1":
	case "2":
	case "3":
	case "4":
	case "6":
	case "7":
	case "8":
	case "9":
		currentList = [0, 63, 100, 120];
		break;
	default:
		break;
	}
	return currentList;
}

/**
 *           
 * @param index
 */
function getDefaultOption(index)
{
	return 120;
}

/**
 *      index PIU        PIU (          )
 * index 0 -4     100-104
 * 5-9     106-110
 * @param shelfType      
 * @param index     
 */
function getPossibleConnectBoard(subrackType, index)
{
	var boardList = new Array();
	switch(index)
	{
		case "1":
			boardList = [2];
			break;
		case "2":
			boardList = [1];
			break;
		case "3":
			boardList = [4];
			break;
		case "4":
		    boardList = [3];
		    break;
		case "6":
			boardList = [7];
			break;
		case "7":
			boardList = [6];
			break;
		case "8":
			boardList = [9];
			break;
		case "9":
			boardList = [8];
		default:
			break;
	}
	
	return boardList;
}

/**
 *        
 *   PIU      (         )
 * index 0 -4     100-104
 * 5-9     106-110
 * @param index
 */
function getPIUBoardStyle(index)
{
	var style = "";
	switch(index)
	{
	case "0":
		style = "piuboardstyle1";
		break;
	case "1":
	case "3":
		style = "piuboardstyle2";
		break;
	case "2":
	case "4":
		style = "piuboardstyle3";
		break;
	case "5":
		style = "piuboardstyle4";
		break;
	case "7":
	case "9":
		style = "piuboardstyle5";
		break;
	case "6":
	case "8":
		style = "piuboardstyle6";
		break;
	default:
		style = "piuboardstyle1";
	}
	
	return style;
}

/**
 *                                  
 * @param index
 * index 0 -4     100-104
 * 5-9     106-110
 * @returns {String}
 */
function getCircleStyle(index)
{
	var style = "";
	switch(index)
	{
	case 0:
		style = "circlestyle1";
		break;
	case 1:
	case 3:
		style = "circlestyle2";
		break;
	case 2:
	case 4:
		style = "circlestyle3";
		break;
	case 5:
		style = "circlestyle4";
		break;
	case 7:
	case 9:
		style = "circlestyle5";
		break;
	case 6:
	case 8:
		style = "circlestyle6";
		break;
	default:
		style = "highlightshow";
	}
	
	return style;
}

/**
 *                    
 *             selfdefinethresholdsetting.xml(      )
 * defaultthresholdsetting.xml(      )              
 *       ,                               
 *     
 * @param usage         0.0-1.0
 */
function getPowerMonitorColor(free)
{ 
	var tc = window.thresholdconf[0];
	if(null == tc)
	{
		tc = window.thresholdconf[1];
	}
	var state = tc.thswitch
	if(!state)
	{
		return "none";
	}
	var cols = tc.colArray;
	var len = cols.length;
	free = free * 100;
	var fullColor = "";
	for(var i = 0; i < len; i++)
	{
		var col = cols[i];
		var id = col.id;
		if("normal" == id)
		{
			fullColor = col.color;
		}
		var min = parseInt(col.min);
		var max = parseInt(col.max);
		if(free >= min && free < max)
		{
			return col.color;
		}
	}
	if(100 == free)
	{
		return fullColor;
	}
}


/**
 *                 Y  
 * @param index
 * @returns {Number}
 */
function getBottomYPos(index)
{
    var bottomY = 0;
	switch(index)
	{
	case "0":
	case "5":
		bottomY = 420;
		break;
	case "1":
	case "3":
	case "7":
	case "9":
		bottomY = 340;
		break;
	case "2":
	case "4":
	case "6":
	case "8":
		bottomY = 500;
		break;
	default:
		bottomY = 420;
	}
	
	return bottomY;
}


/**
 *           boolean 
 * @param isfalse
 * @returns
 */
function parseStrToBool(isfalse)
{
	return "true" == isfalse ? true : false;
}

/**
 *                 
 * @param doc
 */
function EncapsulateThresholdConf(doc)
{
	var tc = new ThresholdConf();
	var th = doc.getElementsByTagName("thswitch")[0];
	var state = th.getAttribute("value");
	state = parseStrToBool(state);
	tc.thswitch = state;
	
	var cols = doc.getElementsByTagName("col");
	for(var i = 0, len = cols.length; i < len; i++)
	{
		var obj = new ThresholdObj();
		var col = cols[i];
		var id = col.getAttribute("id");
		obj.id = id;
		var childmin = col.getElementsByTagName("min")[0];
		var minth = childmin.getAttribute("value");
		obj.min = minth;
		var childmax = col.getElementsByTagName("max")[0];
		var maxth = childmax.getAttribute("value");
		obj.max = maxth;
		var childcolor = col.getElementsByTagName("color")[0];
		var color = childcolor.getAttribute("value");
		obj.color = color;
		tc.colArray[tc.colArray.length] = obj;
	}
}

function ThresholdConf()
{
	this.id = window.thresholdconf.length;
	window.thresholdconf[this.id] = this;
	this.thswitch = true;
	this.colArray = new Array();
}

function ThresholdObj()
{
	this.id = "";
	this.min = "";
	this.max = "";
	this.color = "";
}
