 loadXMLdoc("../../../../conf/system.xml", "GET", false, EncapsulateSConf);
language = SYSTEMCONF.getLanguage();
getResourse("../../../../res/commonres_" + language + ".xml");
var neverflg = getNeProperty(self)["neversion"].split(".")[2];

var isSupportSDFlg = isSupportSDFlg();

/**
 * 04.40         
 */
function isSupportSDFlg()
{
    var fourflg = getNeProperty(self)["neversion"].split(".")[3];
    if (neverflg > 4) 
    {
        return false;
    }
    if (neverflg == 4 && fourflg >= 40) 
    {
        return false;
    }
    return true;
}

getResourse("../../res/portprotection_v2r5c01/portprotectionres_" + language + ".xml");
loadXMLdoc("../../conf/portprotection_v2r5c01/portprotectiongrouptable_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable);

loadXMLdoc("../../conf/portprotection/portprotectionpathstatustable_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable);

document.title = RESOURCE["portprotectiongroupmgr"];

var winobj = getNeProperty(self);
var ALLGROUP = 0;//       
var UNSUPPORTED = "---";//        
var UNKNOWN = 255;//        
var newdoc = null;
var protection = new Object();//    
protection.BOARDPROTECTION = 1;//  1+1  
protection.CLIENTPROTECTION = 3;//   1+1  
protection.LINEPROTECTION = 4;//     
var switchCmd = new Object();//    
switchCmd.PROTECTIONLOCK = 0x0f;//    
switchCmd.FORCESWITCH = 0x0e;//    
switchCmd.MANULSWITCH = 0x07;//    
switchCmd.CLSSWITCHCMD = 0x10;//    
var switchDirection = new Object();//    
switchDirection.SWITCHWORKING = 1;//     
switchDirection.SWITCHPROTECTION = 0;//     
var REVERTIVEMODE = 1;//   
var NONREVERTIVEMODE = 0;//    
var switchRequest = new Object();//    
switchRequest.NR = 0x00;//   
switchRequest.AUTO = 0X04;//    
switchRequest.WTR = 0x05;//    
switchRequest.MS = 0x07;//    
switchRequest.SD = 0x09;//SD  
switchRequest.SF = 0x0c;//SF  
switchRequest.FS = 0x0e;//    
switchRequest.SFP = 0x0f;//  
var pathState = new Object();
pathState.NR = 0;//  
pathState.SD = 1;//SD
pathState.SF = 2;//SF
var WORKING = 0x01;//    
var PROTECTION = 0x00;//    
var DLSU = 0xff;//     
var BOARD_OLP = "0";//  1+1  OLP  
var isMenu = false; //        
var flag = false;//         
var neIdValue = "";//  ID
var resource = [];//              
var btnRightArr = new Object();


var pathStatusSTable = null;
var protectionGroupSTable = null;
var isCreateErr = false;
window.onunload = function()
{
    clearTable();
}

/**
 *          
 */
function clearTable()
{
    if (pathStatusSTable) 
    {
        pathStatusSTable.clearTableData();
        pathStatusSTable.deleteHeadRow();
    }
    if (protectionGroupSTable) 
    {
        protectionGroupSTable.clearTableData();
        protectionGroupSTable.deleteHeadRow();
    }
}

/**
 *     
 */
function myRightClickHandler(e)
{

    var menuarea = $("menuarea");
    if (!e) 
    {
        e = window.event;
    }
    var targetElm = (e.target) ? e.target : e.srcElement;
    if (null == menuarea) 
    {
        return false;
    }
    if (menuarea.contains(targetElm)) 
    {
        rightClickHandler(e);
    }
    return false;
}

document.oncontextmenu = myRightClickHandler;

/**
 *          
 */
function protectionGroupRowSelecteHandler(rows)
{
    for (var i = 0; i < pathStatusSTable.getDataRowLength(); i++) 
    {
        pathStatusSTable.setRowNoneSelect(i);
    }
    
    for (var j = 0, len1 = rows.length; j < len1; j++) 
    {
        for (var z = 0, len2 = pathStatusSTable.getDataRowLength(); z < len2; z++) 
        {
            if (pathStatusSTable.getCellStoreValue(z, "protectiongroupname", "groupId") ==
            protectionGroupSTable.getCellStoreValue(rows[j], "protectiongroupname", "groupId")) 
            {
                pathStatusSTable.setRowSelect(z);
                break;
            }
        }
        
    }
    
    if (rows.length > 0) 
    {
        if (1 == rows.length) 
        {
            $("modifybtn").disabled = !btnRightArr.querybtn.right;
            $("deletebtn").disabled = !btnRightArr.querybtn.right;
        }
        else 
        {
            $("modifybtn").disabled = true;
            $("deletebtn").disabled = true;
        }
        $("function").disabled = !btnRightArr.querybtn.right;
    }
    else 
    {
        $("function").disabled = true;
        $("modifybtn").disabled = true;
        $("deletebtn").disabled = true;
    }
    
    refreshNum(pathStatusSTable.getDataRowLength(), rows.length);
}

/**
 *           
 */
function pathStatusRowSelecteHandler(rows)
{
    for (var i = 0; i < protectionGroupSTable.getDataRowLength(); i++) 
    {
        protectionGroupSTable.setRowNoneSelect(i);
    }
    
    for (var j = 0, len1 = rows.length; j < len1; j++) 
    {
        for (var z = 0, len2 = protectionGroupSTable.getDataRowLength(); z < len2; z++) 
        {
            if (protectionGroupSTable.getCellStoreValue(z, "protectiongroupname", "groupId") ==
            pathStatusSTable.getCellStoreValue(rows[j], "protectiongroupname", "groupId")) 
            {
                protectionGroupSTable.setRowSelect(z);
                break;
            }
        }
        
    }
    
    if (rows.length > 0) 
    {
        $("function").disabled = !btnRightArr.querybtn.right;
        if (1 == rows.length) 
        {
            $("modifybtn").disabled = !btnRightArr.querybtn.right;
            $("deletebtn").disabled = !btnRightArr.querybtn.right;
        }
        else 
        {
            $("modifybtn").disabled = true;
            $("deletebtn").disabled = true;
        }
    }
    else 
    {
        $("function").disabled = true;
        $("modifybtn").disabled = true;
        $("deletebtn").disabled = true;
    }
    
    refreshNum(protectionGroupSTable.getDataRowLength(), rows.length);
}

/**
 *           
 */
function refreshNum(totalNum, selectNum)
{
    if (null == totalNum) 
    {
        totalNum = 0;
    }
    if (null == selectNum) 
    {
        selectNum = 0;
    }
    $("totalNum").innerHTML = totalNum;
    $("selectNum").innerHTML = selectNum;
}


/**
 *                    
 */
function queryByPortProtectionLink()
{

    sendQueryInfo();
}

/**
 *          
 */
function sendQueryInfo()
{
    if (btnRightArr.querybtn.right == false) 
    {
        return;
    }
    isMenu = false;
    setButtonState(true);
    $("function").disabled = true;
    
    var xmlstr = createQueryPortProtectionXML();
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_WDM_OPPG_QUERY + "&flag=1";
    loadXMLdoc(urlreq, "POST", true, refreshTable, null, "inputdata=" + xmlstr);
}

/**
 *              XML   
 */
function createQueryPortProtectionXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    
    var obj = getNeProperty(self);
    neIdValue = obj["neid"];
    param.setAttribute("name", "neId");
    
    param.setAttribute("value", neIdValue);//        ID    ID
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "groupId");
    var groupIdValue = ALLGROUP;
    
    param.setAttribute("value", groupIdValue);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    
    return di.toString();
}

/**
 *     
 */
function refreshTable(doc)
{
    isMenu = true;
    
    protectionGroupSTable.clearTableData();
    
    pathStatusSTable.clearTableData();
    
    var dinterface = EncapsulateData(doc);
    showErrorDialog(dinterface);
    
    if (0 == dinterface.getSErrorCode() || 1 == dinterface.getSErrorCode()) 
    {
        if (dinterface.getDataRowLength == 0) 
        {
            return;
        }
        
        var obj = constructtbXML(dinterface);
        
        createTableBody(protectionGroupSTable, window.tableconf[0], obj, RESOURCE);
        createTableBody(pathStatusSTable, window.tableconf[1], obj, RESOURCE);
        
        for (var i = 0, length = protectionGroupSTable.getDataRowLength(); i < length; i++) 
        {
            if (protection.BOARDPROTECTION != protectionGroupSTable.getCellStoreValue(i, "protectiontype", "protectionType")) 
            {
                protectionGroupSTable.getCellShow(i, "serviceOrigin").setValue("-");
            }
			if (protection.LINEPROTECTION == protectionGroupSTable.getCellStoreValue(i, "protectiontype", "protectionType")) 
            {
				if(!isSupportSDFlg)
				{
					protectionGroupSTable.getCellShow(i, "sdtriggerflag").setValue("-");
				}           

            }
        }
        showSwitchStatus(doc);
    }
    initBtnState();
}


/**
 *                
 *   CCB       SD/SF            
 */
function constructtbXML(dinterface)
{//debugger;
    for (var t = 0; t < dinterface.getDataRowLength(); t++) 
    {
        var obj = dinterface.rows[t];
        if (obj["currentWorkingPath"].value == "") 
            obj["currentWorkingPath"].value = UNKNOWN;
        obj["workingPathStatus"] = new Object();
        obj["workingPathStatus"].value = UNKNOWN;
        obj["protectionPathStatus"] = new Object();
        obj["protectionPathStatus"].value = UNKNOWN;
        obj["switchingStatus"] = new Object();
        obj["switchingStatus"].value = RESOURCE["unknown"];
        
        var protectionType = dinterface.getDataRowParam(t, "protectionType");
        
        if (protection.BOARDPROTECTION == protectionType)//  1+1       OLP
        {
            if ("" == dinterface.getDataRowParam(t, "wneId")) 
            {
                obj["flag"].value = BOARD_OLP;
            }
        }
        else if (protection.CLIENTPROTECTION == protectionType)//   1+1  
        {
            var ctrUnit = dinterface.getDataRowParam(t, "cwreturnNeId");
            if (ctrUnit == 4294967295) 
            {
                obj["revertiveMode"].value = "255";
                obj["wtrTime"].value = "-";
            }
        }
    }
    
    refreshNum(dinterface.getDataRowLength());
    return dinterface;
    
}

/**
 *               
 */
function refresh()
{
    sendQueryInfo();
}

/**
 *          
 */
function createPortProtectionGroup()
{
    sendGetAvailableResourceInfo();
}

/**
 *          
 */
function deletePortProtectionGroup()
{
    var nums = protectionGroupSTable.getDataRowLength();//     
    var selectedLines = protectionGroupSTable.getSelectedRows();
    if (0 == nums)//     
    {
    
        alert(RESOURCE["norow"]);
        return;
    }
    if (selectedLines.length > 0)//      
    {
        if (confirm(RESOURCE["deleteconfirm"])) 
        {
            sendDeleteInfo(selectedLines);
        }
        
    }
    else//       
     {
        alert(RESOURCE["norowselected"]);
        return;
    }
}

/**
 *              
 */
function sendDeleteInfo(selectedLines)
{
    setButtonState(true, null);
    
    var xmlstr = createDeletePortProtectionXML(selectedLines);
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_WDM_OPPG_DELETE + "&flag=1";
    loadXMLdoc(urlreq, "POST", false, openDeleteErrDialog, null, "inputdata=" + xmlstr);
}

/**
 *              XML   
 */
function createDeletePortProtectionXML(selectedLines)
{
    var obj = getNeProperty(self);
    neIdValue = obj["neid"];
    var rowCount = pathStatusSTable.getSelectedRows();
    
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0; i < selectedLines.length; i++) 
    {
        var row = new tagElement("row-params");
        var param = new tagElement("param");
        
        param.setAttribute("name", "neId");
        param.setAttribute("value", neIdValue);//        ID    ID
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "groupId");
        var protectionGroupID = protectionGroupSTable.getCellStoreValue(selectedLines[i], "protectiongroupname", "groupId");
        param.setAttribute("value", protectionGroupID);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "protype");
        var protype = protectionGroupSTable.getCellStoreValue(selectedLines[i], "protectiontype", "protectionType");
        param.setAttribute("value", protype);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "protectiontype");
        var protectiontype = protectionGroupSTable.getCellShow(selectedLines[i], "protectiontype").element.innerText;
        param.setAttribute("value", protectiontype);
        row.appendChild(param);
        
        var revMode = protectionGroupSTable.getCellStoreValue(selectedLines[i], "revertivemode", "revertiveMode");
        if (protection.CLIENTPROTECTION != protype || revMode != 255) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "revertivemode");
            var revertivemode = protectionGroupSTable.getCellShow(selectedLines[i], "revertivemode").element.innerText;
            param.setAttribute("value", revertivemode);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "wtrtime");
            var wtrtime = protectionGroupSTable.getCellShow(selectedLines[i], "wtrtime").element.innerText;
            param.setAttribute("value", wtrtime);
            row.appendChild(param);
        }

		param = new tagElement("param");
	        param.setAttribute("name", "sdtriggerflag");
	        var sdtriggerflag = protectionGroupSTable.getCellShow(selectedLines[i], "sdtriggerflag").element.innerText;
	        param.setAttribute("value", sdtriggerflag);
	        row.appendChild(param);


        
        param = new tagElement("param");
        param.setAttribute("name", "switchingstatus");
        var switchingstatus = protectionGroupSTable.getCellShow(selectedLines[i], "switchingstatus").element.innerText;
        param.setAttribute("value", switchingstatus);
        row.appendChild(param);
        
        for (var j = 0, m = rowCount.length; j < m; j++) 
        {
            var groupid = pathStatusSTable.getCellStoreValue(rowCount[j], "protectiongroupname", "groupId");
            if (parseInt(protectionGroupID) == parseInt(groupid)) 
            {
                param = new tagElement("param");
                param.setAttribute("name", "workingunit");
                var workingunit = pathStatusSTable.getCellShow(rowCount[j], "workingunit").element.innerText;
                param.setAttribute("value", workingunit);
                row.appendChild(param);
                
                param = new tagElement("param");
                param.setAttribute("name", "controlunitworkingpath");
                var controlunitworkingpath = pathStatusSTable.getCellShow(rowCount[j], "controlunitworkingpath").element.innerText;
                param.setAttribute("value", controlunitworkingpath);
                row.appendChild(param);
                
                param = new tagElement("param");
                param.setAttribute("name", "workingpathstatus");
                var workingpathstatus = pathStatusSTable.getCellShow(rowCount[j], "workingpathstatus").element.innerText;
                param.setAttribute("value", workingpathstatus);
                row.appendChild(param);
                
                param = new tagElement("param");
                param.setAttribute("name", "workingunitdelaytime");
                var workingunitdelaytime = pathStatusSTable.getCellShow(rowCount[j], "workingunitdelaytime").element.innerText;
                param.setAttribute("value", workingunitdelaytime);
                row.appendChild(param);
                
                param = new tagElement("param");
                param.setAttribute("name", "protectionunit");
                var protectionunit = pathStatusSTable.getCellShow(rowCount[j], "protectionunit").element.innerText;
                param.setAttribute("value", protectionunit);
                row.appendChild(param);
                
                param = new tagElement("param");
                param.setAttribute("name", "protectionpathstatus");
                var protectionpathstatus = pathStatusSTable.getCellShow(rowCount[j], "protectionpathstatus").element.innerText;
                param.setAttribute("value", protectionpathstatus);
                row.appendChild(param);
                
                param = new tagElement("param");
                param.setAttribute("name", "protectionunitdelaytime");
                var protectionunitdelaytime = pathStatusSTable.getCellShow(rowCount[j], "protectionunitdelaytime").element.innerText;
                param.setAttribute("value", protectionunitdelaytime);
                row.appendChild(param);
                break;
            }
        }
        
        bussiness.appendChild(row);
        
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *         
 */
function openDeleteErrDialog(doc)
{
    var dinterface = EncapsulateData(doc);
    showErrorDialog(dinterface);
    if (0 == dinterface.getSErrorCode())//      
    {
        var rowIndex = pathStatusSTable.getSelectedRows();
        
        for (var i = 0; i < rowIndex.length; i++) 
        {
            pathStatusSTable.deleteRow(rowIndex[i]);
        }
        pathStatusSTable.adjustDataRows();
        
        rowIndex = protectionGroupSTable.getSelectedRows();
        
        for (var j = 0; j < rowIndex.length; j++) 
        {
            protectionGroupSTable.deleteRow(rowIndex[j]);
        }
        protectionGroupSTable.adjustDataRows();
        
        initBtnState();
    }
    else if (1 == dinterface.getSErrorCode())//    
    {
        var tempGroupID = null;//          ID
        var errObj = dinterface.getError();//AllError          
        var rowErrorArray = errObj.rowErrors;//    RowError  
        var selectedRows = protectionGroupSTable.getSelectedRows();
        for (var k = selectedRows.length - 1; k >= 0; k--) 
        {
            var flag = false;
            tempGroupID = protectionGroupSTable.getCellStoreValue(selectedRows[k], "protectiongroupname", "groupId");
            for (var m = 0, len = rowErrorArray.length; m < len; m++) 
            {
                var errorObj = rowErrorArray[m].errorObj;//    RowError       
                if (tempGroupID == errorObj.groupId) 
                {
                    flag = true;
                }
            }
            if (!flag) 
            {
                protectionGroupSTable.deleteRow(selectedRows[k]);
                var rows = pathStatusSTable.getSelectedRows();
                for (var n = rows.length - 1; n >= 0; n--) 
                {
                    if (tempGroupID == pathStatusSTable.getCellStoreValue(rows[n], "protectiongroupname", "groupId")) 
                    {
                        pathStatusSTable.deleteRow(rows[n]);
                    }
                }
            }
        }
        protectionGroupSTable.adjustDataRows();
        pathStatusSTable.adjustDataRows();
        $("querybtn").disabled = !btnRightArr.querybtn.right;
        $("newbtn").disabled = !btnRightArr.newbtn.right;
        
        
        $("deletebtn").disabled = false;
        var selectedRows = protectionGroupSTable.getSelectedRows();
        if (selectedRows.length == 1) 
        {
            $("modifybtn").disabled = false;
        }
    }
    else 
    {
        $("querybtn").disabled = !btnRightArr.querybtn.right;
        $("newbtn").disabled = !btnRightArr.newbtn.right;
        
        
        $("deletebtn").disabled = false;
        var selectedRows = protectionGroupSTable.getSelectedRows();
        if (selectedRows.length == 1) 
        {
            $("modifybtn").disabled = false;
        }
    }
    if (0 == pathStatusSTable.getDataRowLength()) 
    {
        adjustTableLayout(protectionGroupSTable, window.tableconf[0], 0);
        adjustTableLayout(pathStatusSTable, window.tableconf[1], 0);
    }
    refreshNum(pathStatusSTable.getDataRowLength(), pathStatusSTable.getSelectedRows.length);
    ;//              
}

/**
 *          
 */
function modifyPortProtectionGroup()
{
    var nums = protectionGroupSTable.getDataRowLength();//     
    var selectedLines = protectionGroupSTable.getSelectedRows();//     
    if (0 == nums)//     
    {
    
        alert(RESOURCE["norow"]);
        return;
    }
    if (selectedLines.length > 1)//        
    {
        alert(RESOURCE["chooseoneline"]);
        return;
    }
    else if (0 == selectedLines.length)//       
    {
        alert(RESOURCE["norowselected"]);
        return;
    }
    else//    
     {
        var selectLine = selectedLines[0];
        var protectionTypeValue = protectionGroupSTable.getCellStoreValue(selectLine, "protectiontype", "protectionType");
        
        showModalDialog("../portprotection_v2r5c01/modifyprotection.html", window, "dialogHeight:550px;dialogWidth:500px;center:yes;help:no;resizable:YES;status:No;");
    }
    
}

/**
 *          
 */
function portProtectionSwitch(command)
{
    var selectedLines = protectionGroupSTable.getSelectedRows();
    
    if (0 == command)//      
    {
        querySwitchState(selectedLines);
        return;
    }
    
    if (selectedLines.length > 1)//    >0
    {
        alert(RESOURCE["chooseoneline"]);
        return;
    }
    else if (0 == selectedLines.length)//     0
    {
        alert(RESOURCE["norowselected"]);
        return;
    }
    sendSwitchInfo(command, selectedLines);
}


/**
 *              
 */
function sendSwitchInfo(command, selectedLines)
{
    var switchCommand, direction, xmlstr;
    var selectLine = selectedLines[0];
    switch (command)
    {
        case 1:
            xmlstr = createProtectionSwitchXML(selectLine, switchCmd.PROTECTIONLOCK, switchDirection.SWITCHWORKING);//    
            break;
        case 2:
            if (REVERTIVEMODE == protectionGroupSTable.getCellStoreValue(selectLine, "revertivemode", "revertiveMode")) 
            {
                alert(RESOURCE["noswitch"]);//          
                return;
            }
            else 
            {
                var isSwitch = confirm(RESOURCE["isSwitch_" + command]);
                if (!isSwitch) 
                {
                    return;
                }
                xmlstr = createProtectionSwitchXML(selectLine, switchCmd.FORCESWITCH, switchDirection.SWITCHWORKING);//      
            }
            break;
        case 3:
            var isSwitch = confirm(RESOURCE["isSwitch_" + command]);
            if (!isSwitch) 
            {
                return;
            }
            xmlstr = createProtectionSwitchXML(selectLine, switchCmd.FORCESWITCH, switchDirection.SWITCHPROTECTION);//      
            break;
        case 4:
            if (REVERTIVEMODE == protectionGroupSTable.getCellStoreValue(selectLine, "revertivemode", "revertiveMode")) 
            {
                alert(RESOURCE["noswitch"]);//          
                return;
            }
            else 
            {
                xmlstr = createProtectionSwitchXML(selectLine, switchCmd.MANULSWITCH, switchDirection.SWITCHWORKING);//      
            }
            break;
        case 5:
            xmlstr = createProtectionSwitchXML(selectLine, switchCmd.MANULSWITCH, switchDirection.SWITCHPROTECTION);//      
            break;
        default:
            xmlstr = createProtectionSwitchXML(selectLine, switchCmd.CLSSWITCHCMD, switchDirection.SWITCHWORKING);//    
            break;
    }
    
    if (null != xmlstr) 
    {
        if (command == 1) 
        {
            if (!confirm(RESOURCE["LockAlarm"])) 
                return;
        }
        
        var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_WDM_OPPG_SWITCH + "&flag=1";
        loadXMLdoc(urlreq, "POST", true, openSwitchErrDialog, null, "inputdata=" + xmlstr);
    }
    
}

/**
 *              XML   
 */
function createProtectionSwitchXML(selectLine, switchCommand, direction)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var obj = getNeProperty(self);
    neIdValue = obj["neid"];
    var param = new tagElement("param");//  id  
    param.setAttribute("name", "neId");
    param.setAttribute("value", neIdValue);//        ID    ID
    row.appendChild(param);
    
    var groupIdValue = protectionGroupSTable.getCellStoreValue(selectLine, "protectiongroupname", "groupId");
    param = new tagElement("param");//   id  
    param.setAttribute("name", "groupId");
    param.setAttribute("value", groupIdValue);
    row.appendChild(param);
    
    param = new tagElement("param");//      
    param.setAttribute("name", "switchCommand");
    param.setAttribute("value", switchCommand);
    row.appendChild(param);
    
    param = new tagElement("param");//      
    param.setAttribute("name", "direction");
    param.setAttribute("value", direction);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    
    return di.toString();
    
}

/**
 *         
 */
function openSwitchErrDialog(doc)
{
    var dinterface = EncapsulateData(doc);
    showErrorDialog(dinterface);
    if (0 == dinterface.getSErrorCode()) 
    {
        querySwitchState(protectionGroupSTable.getSelectedRows());//      
    }
}

/**
 *       
 */
function querySwitchState(selectedLines)
{
    sendQueryStateInfo(selectedLines);
}

/**
 *         
 */
function sendQueryStateInfo(selectedLines)
{
    if (selectedLines.length > 0) 
    {
        var xmlstr = createQuerySwitchStateXML(selectedLines);
        var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_DM_DOWNLOAD + "&flag=1";
        loadXMLdoc(urlreq, "POST", true, openQuerySwitchStateErrDialog, null, "inputdata=" + xmlstr);
    }
}

/**
 *             
 */
function createQuerySwitchStateXML(selectedLines)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var obj = getNeProperty(self);
    var neIdValue = obj["neid"];
    var param = null;
    
    for (var i = 0, len = selectedLines.length; i < len; i++) 
    {
        var row = new tagElement("row-params");
        
        param = new tagElement("param");//  id  
        param.setAttribute("name", "neId");
        param.setAttribute("value", neIdValue);//        ID    ID
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "groupId");
        var groupIdValue = protectionGroupSTable.getCellStoreValue(selectedLines[i], "protectiongroupname", "groupId");
        param.setAttribute("value", groupIdValue);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "serviceOrigin");
        var groupIdValue = protectionGroupSTable.getCellStoreValue(selectedLines[i], "serviceOrigin", "serviceOrigin");
        param.setAttribute("value", groupIdValue);
        row.appendChild(param);
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    
    return di.toString();
}

/**
 *           
 */
function openQuerySwitchStateErrDialog(doc)
{//debugger;
    var dinterface = EncapsulateData(doc);
    showErrorDialog(dinterface);
    showSwitchStatus(doc);
}

function showSwitchStatus(doc)
{
    var dinterface = EncapsulateData(doc);
    if (0 == dinterface.getSErrorCode() || 1 == dinterface.getSErrorCode())//      
    {
        for (var t = 0, len = dinterface.getDataRowLength(); t < len; t++) 
        {
            var switchingResquest = dinterface.getDataRowParam(t, "switchingRequest");
            var groupId = dinterface.getDataRowParam(t, "groupId");
            var i = 0;
            for (var length = protectionGroupSTable.getDataRowLength(); i < length; i++)//            
             {
                if (groupId == protectionGroupSTable.getCellStoreValue(i, "protectiongroupname", "groupId")) 
                {
                    break;
                }
            }
            
            var cell = protectionGroupSTable.getCell(i, "switchingstatus");
            var currentWorkingPath = dinterface.getDataRowParam(t, "currentWorkingPath");
            var atom = protectionGroupSTable.getCellShow(i, "switchingstatus");
            
            switch (parseInt(switchingResquest))
            {
                case switchRequest.NR:
                    protectionGroupSTable.setCellValue(cell, "switchingStatus", switchRequest.NR);
                    protectionGroupSTable.setAtomValue(atom, RESOURCE["nr"]);
                    break;
                    
                case switchRequest.AUTO:
                    protectionGroupSTable.setCellValue(cell, "switchingStatus", switchRequest.AUTO);
                    protectionGroupSTable.setAtomValue(atom, RESOURCE["auto"]);
                    break;
                    
                case switchRequest.WTR:
                    protectionGroupSTable.setCellValue(cell, "switchingStatus", switchRequest.WTR);
                    protectionGroupSTable.setAtomValue(atom, RESOURCE["wtr"]);
                    break;
                    
                case switchRequest.SD:
                    protectionGroupSTable.setCellValue(cell, "switchingStatus", switchRequest.SD);
                    protectionGroupSTable.setAtomValue(atom, RESOURCE["sd"]);
                    break;
                    
                case switchRequest.SF:
                    protectionGroupSTable.setCellValue(cell, "switchingStatus", switchRequest.SF);
                    protectionGroupSTable.setAtomValue(atom, RESOURCE["sf"]);
                    break;
                    
                case switchRequest.SFP:
                    protectionGroupSTable.setCellValue(cell, "switchingStatus", switchRequest.SFP);
                    protectionGroupSTable.setAtomValue(atom, RESOURCE["sfp"]);
                    break;
                    
                case switchRequest.MS:
                    
                    if (WORKING == currentWorkingPath)//         
                    {
                        protectionGroupSTable.setCellValue(cell, "switchingStatus", switchRequest.MS);
                        protectionGroupSTable.setAtomValue(atom, RESOURCE["msworking"]);
                    }
                    else//         
                     {
                        protectionGroupSTable.setCellValue(cell, "switchingStatus", switchRequest.MS);
                        protectionGroupSTable.setAtomValue(atom, RESOURCE["msprotection"]);
                    }
                    break;
                    
                case switchRequest.FS:
                    if (WORKING == currentWorkingPath)//         
                    {
                        protectionGroupSTable.setCellValue(cell, "switchingStatus", switchRequest.FS);
                        protectionGroupSTable.setAtomValue(atom, RESOURCE["fsworking"]);
                    }
                    else if (PROTECTION == currentWorkingPath)//         
                    {
                        protectionGroupSTable.setCellValue(cell, "switchingStatus", switchRequest.FS);
                        protectionGroupSTable.setAtomValue(atom, RESOURCE["fsprotection"]);
                    }
                    break;
                default:
                    break;
            }
            
            if (DLSU == currentWorkingPath) 
            {
                protectionGroupSTable.setCellValue(cell, "switchingStatus", switchingResquest);
                protectionGroupSTable.setAtomValue(atom, RESOURCE["delaystartup"]);
            }
            
            var workingPathStatus = dinterface.getDataRowParam(t, "workingPathStatus");
            cell = pathStatusSTable.getCell(i, "workingpathstatus");
            atom = pathStatusSTable.getCellShow(i, "workingpathstatus");
            
            switch (parseInt(workingPathStatus))
            {
                case pathState.NR:
                    pathStatusSTable.setCellValue(cell, "workingPathStatus", pathState.NR);
                    pathStatusSTable.setAtomValue(atom, RESOURCE["normal"]);
                    break;
                case pathState.SD:
                    pathStatusSTable.setCellValue(cell, "workingPathStatus", pathState.SD);
                    pathStatusSTable.setAtomValue(atom, RESOURCE["sdstatus"]);
                    break;
                case pathState.SF:
                    pathStatusSTable.setCellValue(cell, "workingPathStatus", pathState.SF);
                    pathStatusSTable.setAtomValue(atom, RESOURCE["sfstatus"]);
                    break;
                default:
                    break;
            }
            
            var protectionPathStatus = dinterface.getDataRowParam(t, "protectionPathStatus");
            cell = pathStatusSTable.getCell(i, "protectionpathstatus");
            atom = pathStatusSTable.getCellShow(i, "protectionpathstatus");
            
            switch (parseInt(protectionPathStatus))
            {
                case pathState.NR:
                    pathStatusSTable.setCellValue(cell, "protectionPathStatus", pathState.NR);
                    pathStatusSTable.setAtomValue(atom, RESOURCE["normal"]);
                    break;
                case pathState.SD:
                    pathStatusSTable.setCellValue(cell, "protectionPathStatus", pathState.SD);
                    pathStatusSTable.setAtomValue(atom, RESOURCE["sdstatus"]);
                    break;
                case pathState.SF:
                    pathStatusSTable.setCellValue(cell, "protectionPathStatus", pathState.SF);
                    pathStatusSTable.setAtomValue(atom, RESOURCE["sfstatus"]);
                    break;
                default:
                    break;
            }
            
            cell = pathStatusSTable.getCell(i, "curpath");
            atom = pathStatusSTable.getCellShow(i, "curpath");
            switch (parseInt(currentWorkingPath))
            {
                case 1:
                    pathStatusSTable.setCellValue(cell, "curpath", currentWorkingPath);
                    pathStatusSTable.setAtomValue(atom, RESOURCE["work"]);
                    break;
                    
                case 0:
                    pathStatusSTable.setCellValue(cell, "curpath", currentWorkingPath);
                    pathStatusSTable.setAtomValue(atom, RESOURCE["back"]);
                    break;
            }
        }
        
        refreshTableState(protectionGroupSTable, window.tableconf[0], dinterface);
        refreshTableState(pathStatusSTable, window.tableconf[1], dinterface);
    }
}

/**
 *        
 */
function showErrorDialog(dinterface)
{
    var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "groupId";
    openErrPage("../../../../page/", dinterface.getError(), errArr);
}

/**
 *         
 */
function initProtectionGroup()
{
    protectionGroupSTable = new SortTable();
    protectionGroupSTable.setImage("../../../../images/");
    createTableHead(protectionGroupSTable, window.tableconf[0]);
    protectionGroupSTable.setSingleChoiceFlg(true);
    protectionGroupSTable.setBodyWidth(600, "140%");
    document.getElementById("protectiongrouptable").appendChild(protectionGroupSTable.getTable());
}

/**
 *          
 */
function initPathStatus()
{

    pathStatusSTable = new SortTable();
    pathStatusSTable.setImage("../../../../images/");
    createTableHead(pathStatusSTable, window.tableconf[1]);
    pathStatusSTable.setSingleChoiceFlg(true);
    pathStatusSTable.setBodyWidth(600, "160%");
    document.getElementById("pathstatustable").appendChild(pathStatusSTable.getTable());
    
    var tableHeight = getComponetHeight($("ttbody"), 170) * 0.4;
    tableHeight = tableHeight < 100 ? 100 : tableHeight;
    pathStatusSTable.setBodyHeight(tableHeight + "px");
    protectionGroupSTable.setBodyHeight(tableHeight + "px");
    
    $("protectiongrouptable").oncontextmenu = rightClickEvent;
}

/*
 *              
 */
function rightClickEvent()
{
    if (isMenu) 
    {
        createjsDOMenu();
        rightClickHandler();
    }
}

/**
 *       
 */
function initSelectHandler()
{
    protectionGroupSTable.setOnRowSelectHandler(protectionGroupRowSelecteHandler);
    pathStatusSTable.setOnRowSelectHandler(pathStatusRowSelecteHandler);
}

/**
 *      
 */
function initBtn()
{
    $("querybtn").value = RESOURCE["querybutton"];
    $("newbtn").value = RESOURCE["newbutton"];
    $("deleteabtn").value = RESOURCE["deletebutton"];
    $("modifybtn").value = RESOURCE["modifybutton"];
    $("function").value = RESOURCE["functionbutton"];
    if (language == "zh") 
    {
        $("function").className = "buttonstyle4";
    }
    else 
    {
        $("function").className = "buttonstyle5";
    }
    
    btnRightArr.querybtn = new BtnRightObj("querybtn", "8639");
    btnRightArr.newbtn = new BtnRightObj("newbtn", "8635");
    btnRightArr.deleteabtn = new BtnRightObj("deleteabtn", "8636");
    btnRightArr.modifybtn = new BtnRightObj("modifybtn", "8637");
    btnRightArr.queryswitchstate = new BtnRightObj("queryswitchstate", "8717");
    btnRightArr.switchright = new BtnRightObj("switchright", "8640");
    
    
    
    sendRightInfo(btnRightArr);
}

/**
 *       
 * @param  
 * @return  
 */
function sendRightInfo()
{
    var url = "../../../../securityServlet?neID=" + winobj["neid"] + "&nmUser=" + winobj["nmUser"];
    loadXMLdoc(url, "POST", false, rightHandleBack, null, "inputdata=" + createRightXML());
}

/**
 *           
 * @param  
 * @return  
 */
function rightHandleBack(doc)
{
    var data = EncapsulateData(doc);
    for (var i = 0; i < data.getDataRowLength(); i++) //       
     {
        var right = data.getDataRowParam(i, "right");
        
        if (0 == right) 
        {
            btnRightArr[data.getDataRowParam(i, "btnID")].right = false;
        }
        else 
        {
            btnRightArr[data.getDataRowParam(i, "btnID")].right = true;
        }
    }
    initBtnState();
}

/**
 *           XML
 * @param  
 * @return  
 */
function createRightXML()
{
    var root = new inputxml("datainterface");//Create the root of a xml file
    var firstlevel = new tagElement("bussiness-params");
    
    var secondlevel = null;
    ;
    var thirdlevel = null;
    
    for (var btnrightobj in btnRightArr) 
    {
        secondlevel = new tagElement("row-params"); //bean         	
        thirdlevel = new tagElement("param");
        thirdlevel.setAttribute("name", "btnID");
        thirdlevel.setAttribute("value", btnRightArr[btnrightobj].btnId);
        secondlevel.appendChild(thirdlevel);
        
        thirdlevel = new tagElement("param");
        thirdlevel.setAttribute("name", "sfid");
        thirdlevel.setAttribute("value", btnRightArr[btnrightobj].sfid);
        secondlevel.appendChild(thirdlevel);
        
        firstlevel.appendChild(secondlevel);
    }
    root.getRoot().appendChild(firstlevel);
    return root.toString();
}



/**
 *        
 */
function initBtnState()
{

    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("newbtn").disabled = !btnRightArr.newbtn.right;
    
    
    $("deletebtn").disabled = true;
    $("modifybtn").disabled = true;
    $("function").disabled = true;
}

/**
 *        
 * @param btnId       ID  sfid             ID
 * @return  
 */
function BtnRightObj(btnId, sfid)
{
    if (null != btnId) 
    {
        this.btnId = btnId;
    }
    else 
    {
        this.btnId = "";
    }
    
    if (isNaN(parseInt(sfid))) 
    {
        this.sfid = -1;
    }
    else 
    {
        this.sfid = sfid;
    }
    this.right = true;
}

/**
 * BtnRightObj   toString  
 * @param  
 * @return String :IPA     String  
 */
BtnRightObj.prototype.toString = function()
{
    var str = "The button's Id = " + this.btnId + " sfid = " + this.sfid + " right = " + this.right;
    return str;
}

/**
 *       
 */

function setButtonState(disabledState, btnIDArr)
{
    if (null == btnIDArr || btnIDArr.length == 0) 
    {
        btnIDArr = [];
        btnIDArr.push("querybtn");
        btnIDArr.push("newbtn");
        btnIDArr.push("deleteabtn");
        btnIDArr.push("modifybtn");
    }
    
    for (var i = 0; i < btnIDArr.length; i++) 
    {
        if (btnRightArr[btnIDArr[i]].right == true) 
        {
            $(btnIDArr[i]).disabled = disabledState;
        }
    }
}

/**
 *         
 */

/**
 *         
 */
function sendGetAvailableResourceInfo()
{
    var xmlstr = createGetAvailableResourceXML();
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_WDM_OPPG_GETSOURCE + "&flag=1";
    loadXMLdoc(urlreq, "POST", false, refreshGetAvailableResource, null, "inputdata=" + xmlstr);
}

/**
 *             
 */
function createGetAvailableResourceXML()
{
    var obj = getNeProperty(self);
    neIdValue = obj["neid"];
    
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    
    param.setAttribute("name", "neId");
    param.setAttribute("value", neIdValue);//        ID    ID
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "groupId");
    param.setAttribute("value", ALLGROUP);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    
    return di.toString();
}


/**
 *           
 */
function refreshGetAvailableResource(doc)
{
    newdoc = doc;
    var dinterface = EncapsulateData(doc);
    showErrorDialog(dinterface);
    
    isCreateErr = false;
    if (0 != dinterface.getSErrorCode() && 1 != dinterface.getSErrorCode())//0   1                          	  
    {
        isCreateErr = true;//      
        showModalDialog("../portprotection_v2r5c01/creatportprotectiongroup.html", window, "dialogHeight:530px;dialogWidth:500px;center:yes;help:no;resizable:YES;status:No;");
    }
    else 
    {
        if (0 == dinterface.getDataRowLength())//                  	  
        {
            alert(RESOURCE["notenoughport"]);
        }
        else 
        {
            showModalDialog("../portprotection_v2r5c01/creatportprotectiongroup.html", window, "dialogHeight:530px;dialogWidth:500px;center:yes;help:no;resizable:YES;status:No;");
        }
        
    }
}

window.onresize = function()
{
    var tableHeight = getComponetHeight($("ttbody"), 170) * 0.4;
    tableHeight = tableHeight < 100 ? 100 : tableHeight;
    pathStatusSTable.setBodyHeight(tableHeight + "px");
    protectionGroupSTable.setBodyHeight(tableHeight + "px");

}
