 loadXMLdoc("../../../../conf/system.xml", "GET", false, EncapsulateSConf);
language = SYSTEMCONF.getLanguage();
getResourse("../../../../res/commonres_" + language + ".xml");

getResourse("../../res/portprotection_v2r5c01/portprotectionres_" + language + ".xml");

document.title = RESOURCE["portprotectiongroupmgr"];

var MAXPROTECTIONGROUPCOUNT = 512;

var PROTECTGROUPUNIT = 1;

var WROTECTGROUPUNIT = 2;

var CROTECTGROUPUNIT = 3;

var DROTECTGROUPUNIT = 4;

var CURRENTNE = 1;

var OTHERDEVICE = 4294967295;

var NONE = 0;

var PATHID = 1;//  Id   1;
var isSuccess = false;

var flag = 0;

var win = getParentWindow();

var groupIdValue;

var neverflg = getNeProperty(win)["neversion"].split(".")[2];
var isSupportSDFlg = isSupportSDFlg();

var isSupportSwitchDectFlag = isSupportSwitchDect();
var isSupportSwitchTypeAndAPSFlag = isSupportSwitchTypeAndAPS();

var boardResArr = [];

var boardOLPResArr = [];

var clientResArr = [];

var lineResArr = [];

var boardDetectResArr = [];

var conditionArr = [];
conditionArr[0] = boardResArr;
conditionArr[1] = boardResArr;
conditionArr[2] = clientResArr;
conditionArr[3] = lineResArr;
conditionArr[4] = boardOLPResArr;
conditionArr[5] = boardDetectResArr;

var selectParams = [];
var selectParam = new Object();
selectParams[0] = selectParam;

var usableBoardArr = [];

var ct = null;

var neName = "";

var sdOptions = [];
var applyFlag = false;

var workingBoardTypeValue = 0;
var protectionBoardTypeValue = 0;

/**
 * 04.40         
 */
function isSupportSDFlg()
{
    return true;
}

/**
 * 5.51.08.14             
 * @return
 */
function isSupportSwitchDect()
{
    var fourflg = getNeProperty(win)["neversion"].split(".")[3];
    if (parseInt(neverflg, 10) < 8) 
    {
        return false;
    }
    if (parseInt(neverflg, 10) == 8 && parseInt(fourflg, 10) < 14) 
    {
        return false;
    }
    return true;
}

/**
 * 5.51.09.10                APS    
 * @return
 */
function isSupportSwitchTypeAndAPS()
{
	return SpecialAttrMgr.isNESupport(win.neIdValue, "TE_FUNC_CFG_PORT_PROTCTION", "OTN_ATTR_SUPPORT_PORT_PROTCTION_SWITCHTYPE_APS");
}

/**
 *        ID
 */
function createProtectionGroupID()
{
    var hasGroupID = true;
    while (hasGroupID) 
    {
        hasGroupID = false;
        var groupID = 1 + Math.floor(65535 * Math.random());
        for (var i = 0, len = win.protectionGroupSTable.getDataRowLength(); i < len; i++) 
        {
            var gpId = win.protectionGroupSTable.getCellStoreValue(i, "protectiongroupname", "groupId");
            if (gpId == groupID) 
            {
                hasGroupID = true;
                break;
            }
        }
    }
    return groupID;
}

/**
 *      ID
 */
function getProtectionGroupID(protectionGroupName)
{

    var stri = "-";
    var str = protectionGroupName.indexOf(stri);
    var protectionGroupId = protectionGroupName.substring(str + 1);
    return protectionGroupId;
}


/**
 *     ID
 */
function getPortID(pathInfo)
{
    var stri = "(";
    var str = pathInfo.indexOf(stri);
    var portId = pathInfo.substring(0, str);
    return portId;
}

/**
 *              
 */
function TEUsableBoard()
{
    this.key = null;
    this.neId = null;
    this.neName = null;
    this.protectionType = null;
    this.shelfName = null;
    this.slotId = null;
    this.boardType = null;
    this.boardName = null;
    this.linkSlot = null;
    this.linkPort = null;
    this.portName = null;//     
    this.portArr = null;//           
}

TEUsableBoard.prototype.toString = function()
{
    var resultStr = this.slotId + "-" + this.boardName;
    if (this.shelfName != null && this.shelfName != "") 
    {
        resultStr = this.shelfName + "-" + getSlotIDFromSlot(this.slotId) + "-" + this.boardName;
    }
    return resultStr;
}

/**
 *        key           
 */
function getUsableBoard(key)
{
    var bdRes = null;
    for (var i = 0, len = usableBoardArr.length; i < len; i++) 
    {
        if (usableBoardArr[i].key == key) 
        {
            bdRes = usableBoardArr[i];
            break;
        }
    }
    return bdRes;
}

/**
 *           ID
 */
function getPortID(portName)
{
    var portID = 0;
    var index = portName.indexOf("(");
    return portName.substring(0, index);
}

/**
 *      
 */
function init()
{
    loadXMLdoc("../../conf/portprotection_v2r5c01/portprotectiontype.xml", "GET", false, loadPortProtectionXMLParse, conditionArr);//            	
    ct = new CTable();
    ct.addHead(RESOURCE["attr"], RESOURCE["value"]);
    
    var protectionTypeAtom = new Atom("select");
    selectParam.selectType = "protectiontype";
    selectParam.selectAtom = protectionTypeAtom;
    loadXMLdoc("../../conf/portprotection/select_" + language + ".xml", "GET", false, selectXMLParse, selectParams); //          
    var supportTypes = SpecialAttrMgr.getNEAttrListValue(win.neIdValue,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_PORTPROTECTIONTYPE");
    if(supportTypes != null && supportTypes.length > 0)
    {
	    for(var i = protectionTypeAtom.element.options.length - 1;i >= 0;i--)
	    {
	    	var value = protectionTypeAtom.element.options[i].value;
	    	if(!supportTypes.contains(value))
	    	{
	    		protectionTypeAtom.element.remove(i);
	    	}
	    }
    }
    protectionTypeAtom.element.style.width = "100%";
    ct.addAttrRow("protectionType", RESOURCE["protectiontype"], selectParam.selectAtom);
    
    var neWithWorkingUnitAtom = new Atom("select");
    neWithWorkingUnitAtom.element.style.width = "100%";
    neWithWorkingUnitAtom.element.options[neWithWorkingUnitAtom.element.options.length] = new Option(neName, 0);
    neWithWorkingUnitAtom.element.disabled = true;
    ct.addAttrRow("neWithWorkingUnit", RESOURCE["newithworkingunit"], neWithWorkingUnitAtom);
    
    var boardWithWorkingUnitAtom = new Atom("select");
    boardWithWorkingUnitAtom.element.style.width = "100%";
    boardWithWorkingUnitAtom.element.options[boardWithWorkingUnitAtom.element.options.length] = new Option("", 0);
    boardWithWorkingUnitAtom.element.disabled = false;
    ct.addAttrRow("boardWithWorkingUnit", RESOURCE["boardwithworkingunit"], boardWithWorkingUnitAtom);
    
    var workingUnitAtom = new Atom("select");
    workingUnitAtom.element.style.width = "100%";
    workingUnitAtom.element.options[workingUnitAtom.element.options.length] = new Option("", 0);
    workingUnitAtom.element.disabled = false;
    ct.addAttrRow("workingUnit", RESOURCE["workingunit"], workingUnitAtom);
    
    var neWithProtectionUnitAtom = new Atom("select");
    neWithProtectionUnitAtom.element.style.width = "100%";
    neWithProtectionUnitAtom.element.options[neWithProtectionUnitAtom.element.options.length] = new Option(neName, 0);
    neWithProtectionUnitAtom.element.disabled = true;
    ct.addAttrRow("neWithProtectionUnit", RESOURCE["newithprotectionunit"], neWithProtectionUnitAtom);
    
    var boardWithProtectionUnitAtom = new Atom("select");
    boardWithProtectionUnitAtom.element.style.width = "100%";
    boardWithProtectionUnitAtom.element.options[boardWithProtectionUnitAtom.element.options.length] = new Option("", 0);
    boardWithProtectionUnitAtom.element.disabled = false;
    ct.addAttrRow("boardWithProtectionUnit", RESOURCE["boardwithprotectionunit"], boardWithProtectionUnitAtom);
    
    var protectionUnitAtom = new Atom("select");
    protectionUnitAtom.element.style.width = "100%";
    protectionUnitAtom.element.options[protectionUnitAtom.element.options.length] = new Option("", 0);
    protectionUnitAtom.element.disabled = false;
    ct.addAttrRow("protectionUnit", RESOURCE["protectionunit"], protectionUnitAtom);
    
    var neWithControlUnitAtom = new Atom("select");
    neWithControlUnitAtom.element.style.width = "100%";
    neIdValue = win.neIdValue;
    neIdStr = getNeid(neIdValue);
    var neid = getProtectionGroupID(neIdStr);
    neWithControlUnitAtom.element.options[neWithControlUnitAtom.element.options.length] = new Option(UNSUPPORTED, 0);
    neWithControlUnitAtom.element.disabled = true;
    ct.addAttrRow("neWithControlUnit", RESOURCE["newithcontrolunit"], neWithControlUnitAtom);
    
    var boradWithControlUnitAtom = new Atom("select");
    boradWithControlUnitAtom.element.style.width = "100%";
    boradWithControlUnitAtom.element.options[boradWithControlUnitAtom.element.options.length] = new Option(UNSUPPORTED, 0);
    boradWithControlUnitAtom.element.disabled = true;
    ct.addAttrRow("boardWithControlUnit", RESOURCE["boradwithcontrolunit"], boradWithControlUnitAtom);
    
    var controlUnitWorkingPathAtom = new Atom("select");
    controlUnitWorkingPathAtom.element.style.width = "100%";
    controlUnitWorkingPathAtom.element.options[controlUnitWorkingPathAtom.element.options.length] = new Option(UNSUPPORTED, 0);
    controlUnitWorkingPathAtom.element.disabled = true;
    ct.addAttrRow("controlUnitWorkingPath", RESOURCE["controlunitworkingpath"], controlUnitWorkingPathAtom);
    
    var workingUnitDelayTimeAtom = new Atom("text");
    workingUnitDelayTimeAtom.setValue(DELAYTIME);
    workingUnitDelayTimeAtom.element.style.width = "100%";
    workingUnitDelayTimeAtom.element.style.imeMode = "disabled";
    ct.addAttrRow("workingUnitDelayTime", RESOURCE["workingunitdelaytime"], workingUnitDelayTimeAtom)
    
    var protecionUnitDelayTimeAtom = new Atom("text");
    protecionUnitDelayTimeAtom.setValue(DELAYTIME);
    protecionUnitDelayTimeAtom.element.style.width = "100%";
    protecionUnitDelayTimeAtom.element.style.imeMode = "disabled";
    ct.addAttrRow("protectionUnitDelayTime", RESOURCE["protectionunitdelaytime"], protecionUnitDelayTimeAtom)
    
    var revertiveModeAtom = new Atom("select");
    selectParam.selectType = "revertivemode";
    selectParam.selectAtom = revertiveModeAtom;
    loadXMLdoc("../../conf/portprotection/select_" + language + ".xml", "GET", false, selectXMLParse, selectParams); //    
    revertiveModeAtom.element.style.width = "100%";
    ct.addAttrRow("revertiveMode", RESOURCE["revertivemode"], selectParam.selectAtom);
    
    var wtrTimeAtom = new Atom("text");
    wtrTimeAtom.setValue(NONREVERTIVWTRTIME);
    wtrTimeAtom.element.disabled = true;
    wtrTimeAtom.element.style.width = "100%";
    ct.addAttrRow("wtrTime", RESOURCE["wtrtime"], wtrTimeAtom);
    
    var sdTriggerFlagAtom = new Atom("select");
    selectParam.selectType = "sdtriggerflag";
    selectParam.selectAtom = sdTriggerFlagAtom;
    loadXMLdoc("../../conf/portprotection/select_" + language + ".xml", "GET", false, selectXMLParse, selectParams); // sd    
	for(var i=0;i<selectParam.selectAtom.element.options.length;i++)
	{
		var temopt=selectParam.selectAtom.element.options[i];
		sdOptions[i]=new Option(temopt.text,temopt.value);
	}
	if(!isSupportSDFlg)
	{
		sdTriggerFlagAtom.addOptionObj(new Option("-", 255));
		sdTriggerFlagAtom.element.options.selectedIndex = sdTriggerFlagAtom.element.options.length-1;
	}

	sdTriggerFlagAtom.element.disabled = !isSupportSDFlg;
    sdTriggerFlagAtom.element.style.width = "100%";
    ct.addAttrRow("sdTriggerFlag", RESOURCE["sdtriggerflag"], selectParam.selectAtom);
    
    var switchDectTimeAtom = new Atom("text");
    switchDectTimeAtom.setValue("-");
    switchDectTimeAtom.element.disabled = true;
    switchDectTimeAtom.element.style.width = "100%";
    ct.addAttrRow("switchDectTime", RESOURCE["switchDectTime"], switchDectTimeAtom);
    
    if(isSupportSwitchTypeAndAPSFlag)
    {
        var switchTypeAtom = new Atom("select");
        switchTypeAtom.element.options[switchTypeAtom.element.options.length] = new Option(RESOURCE["APS_MODE_0"], 0);
        switchTypeAtom.element.options[switchTypeAtom.element.options.length] = new Option(RESOURCE["APS_MODE_1"], 1);
        switchTypeAtom.element.disabled = false;
        switchTypeAtom.element.style.width = "100%";
        ct.addAttrRow("switchType", RESOURCE["switchType"], switchTypeAtom);
		
        var apsChannelAtom = new Atom("text");
        apsChannelAtom.setValue("-");
        apsChannelAtom.element.disabled = true;
        apsChannelAtom.element.style.width = "100%";
        ct.addAttrRow("apsChannel", RESOURCE["apsChannel"], apsChannelAtom);
    }
	
    
    document.body.appendChild(ct.getTable());
    
    if (!win.isCreateErr)//            
    {
        refreshGetAvailableResource(win.newdoc);
    }
    changeProtectionType(win.protection.LINEPROTECTION);
    
    addInitListener();
}


function clientProtectionLinkage()
{
    var ctr = ct.getAtom("neWithControlUnit").element;
    var wUnit = ct.getAtom("boardWithWorkingUnit").element.value;
    var pUnit = ct.getAtom("boardWithProtectionUnit").element.value;
    var wSlot = wUnit.substring(0, wUnit.indexOf("-"));
    var pSlot = pUnit.substring(0, pUnit.indexOf("-"));
    var wSubTrack = Math.floor(parseInt(wSlot) / 100);
    var pSubTrack = Math.floor(parseInt(pSlot) / 100);
    if (wSubTrack != pSubTrack) 
    {
        ctr.selectedIndex = 0;
        ctr.options[2] = null;
        changeNeWithControlUnit(CURRENTNE);
    }
    else 
    {
        if (ctr.options.length < 3) 
        {
            ctr.options[2] = new Option("---", 0);
        }
    }
}

function initData()
{
    sendGetAvailableResourceInfo();
    var protectionType = parseInt(ct.getAttrValue("protectionType"));
    changeProtectionType(protectionType);
    
    ct.getAtom("workingUnitDelayTime").setValue(DELAYTIME);
    ct.getAtom("protectionUnitDelayTime").setValue(DELAYTIME);
    
    ct.getAtom("revertiveMode").element.options.selectedIndex = 0;
    
    var wtrTimeAtom = ct.getAtom("wtrTime");
    wtrTimeAtom.setValue(NONREVERTIVWTRTIME);
    wtrTimeAtom.element.disabled = true;
    if (!ct.getAtom("sdTriggerFlag").element.disabled) 
    {
        ct.getAtom("sdTriggerFlag").element.options.selectedIndex = 0;
    }      
}

/**
 *         
 */
function sendGetAvailableResourceInfo()
{
    var xmlstr = createGetAvailableResourceXML();
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_WDM_OPPG_GETSOURCE + "&flag=1";
    loadXMLdoc(urlreq, "POST", false, refreshGetAvailableResource, null, "inputdata=" + xmlstr);
}

/**
 *             
 */
function createGetAvailableResourceXML()
{
    var obj = getNeProperty(win.self);
    neIdValue = obj["neid"];
    
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    
    param.setAttribute("name", "neId");
    param.setAttribute("value", neIdValue);//        ID    ID
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "groupId");
    param.setAttribute("value", win.ALLGROUP);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    
    return di.toString();
}

/**
 *           
 */
function refreshGetAvailableResource(doc)
{
    if (usableBoardArr.length > 0) 
    {
        usableBoardArr.clear();
    }
    
    var dinterface = EncapsulateData(doc);
    showErrorDialog(dinterface);
    
    if (0 == dinterface.getSErrorCode()) 
    {
        for (var i = 0, len1 = dinterface.getDataRowLength(); i < len1; i++) 
        {
            var usableBd = null;//        
            var obj = dinterface.rows[i];
            
            if (neName == "") 
            {
                neName = obj.neName.value;
            }
            
            var portName = obj.portName.value;
            var portNameOptions = obj.portName.options;
            
            createRes(boardResArr, "board1plus1", obj, portName, portNameOptions);
            
            createRes(boardDetectResArr, "boarddetect", obj, portName, portNameOptions);
            
            createRes(boardOLPResArr, "boardolp", obj, portName, portNameOptions);
            
            createRes(lineResArr, "line", obj, portName, portNameOptions);
            
            createRes(clientResArr, "client", obj, portName, portNameOptions);
            
        }
        sortResource();
    }
    
}

/*       */
function sortResource()
{
    var temp;
    for (var i = 0, len1 = usableBoardArr.length - 1; i < len1; i++) 
    {
        for (var j = i + 1, len2 = usableBoardArr.length; j < len2; j++) 
        {
            if (parseInt(usableBoardArr[i].slotId) > parseInt(usableBoardArr[j].slotId)) 
            {
                temp = usableBoardArr[j];
                usableBoardArr[j] = usableBoardArr[i];
                usableBoardArr[i] = temp;
            }
        }
    }
}

/**
 *               
 */
function createRes(resArr, protectionType, obj, portName, portNameOptions)
{
    var portList = filterPortList(resArr, obj.boardName.value, portName, portNameOptions);
    
    if (portList.length > 0) 
    {
        usableBd = new TEUsableBoard();
        usableBd.neId = obj.neId.value;
        usableBd.neName = obj.neName.value;
        usableBd.shelfName = obj.shelfName.value;
        usableBd.slotId = obj.slotId.value;
        usableBd.protectionType = protectionType;
        usableBd.key = obj.slotId.value + "-" + protectionType;
        usableBd.boardType = obj.boardType.value;
        usableBd.boardName = obj.boardName.value;
        usableBd.linkSlot = obj.linkSlot.value;
        usableBd.linkPort = obj.linkPort.value;
        usableBd.portName = portList[0];
        portList.removeAt(0);
        usableBd.portArr = portList;
        
        usableBoardArr.push(usableBd);
    }
}

/**
 *                             
 */
function filterPortList(resArr, boardName, portName, portArr)
{
    var portList = [];
    if (null == portName)//      ,        0   
    {
        return portList;
    }
    
    for (var i = 0, len1 = resArr.length; i < len1; i++) 
    {
        if (boardName == resArr[i].boardTypeName) 
        {
            var portId = getPortID(portName);
            if (resArr[i].ports.contains(portId))//                  
            {
                portList.push(portName);
            }
            if (null == portArr)//        
            {
                break;
            }
            for (var j = 0, len2 = portArr.length; j < len2; j++)//        
             {
                portId = getPortID(portArr[j]);
                if (resArr[i].ports.contains(portId))//                  
                {
                    portList.push(portArr[j]);
                }
            }
            break;
        }
    }
    return portList;
}

/**
 *               
 */
function addInitListener()
{
    var atom = null;
    
    atom = ct.getAtom("protectionType");
    atom.element["onchange"] = function()
    {
        isSuccess = false;
        return changeProtectionType(this.value);
    }
    
    atom = ct.getAtom("workingUnitDelayTime");
    checkText(atom.element, MINDELAYTIME, MAXDELAYTIME);
    
    atom = ct.getAtom("protectionUnitDelayTime");
    checkText(atom.element, MINDELAYTIME, MAXDELAYTIME);
    
    atom = ct.getAtom("revertiveMode");
    atom.element["onchange"] = function()
    {
        changeRevertiveMode(this, ct.getAtom("wtrTime"));
        isSuccess = false;
    }
    
    atom = ct.getAtom("wtrTime");
    var textelement = atom.element;
    tenCellEvent(textelement, ":");
    textelement.maxLength = 5;
    checkWTRTime(textelement, MINWTRTIME, MAXWTRTIME);
    
    atom = ct.getAtom("switchDectTime");
    checkText(atom.element, "0", "1000");
	
    if(isSupportSwitchTypeAndAPSFlag)
    {
        atom = ct.getAtom("switchType");
        atom.element["onchange"] = function()
        {
            return changeswitchType(this.value);
        }
	
        atom = ct.getAtom("apsChannel");
        checkText(atom.element, "0", "7");
    }
    
}

/**
 *             APS          
 */
function changeswitchType(selectValue)
{
    var atom = ct.getAtom("apsChannel");
    if(selectValue == win.apsSwitchType.unidirectional)
    {
        atom.element.disabled = true;
        atom.setValue("-");
    }
    else if(selectValue == win.apsSwitchType.bidirectional)
    {
        atom.element.disabled = false;
        atom.setValue("7")
    }
}

/**
 *          
 */
function changeProtectionType(selectValue)
{
    if (selectValue == win.protection.LINEPROTECTION)//     
    {
        var atom = ct.getAtom("neWithWorkingUnit");
        atom.clearOptions();
        atom.element.options[atom.element.options.length] = new Option(neName, 0);
        atom.element.disabled = false;
        atom = ct.getAtom("sdTriggerFlag");
		if(!isSupportSDFlg)
		{
			atom.element.options[atom.element.options.length] = new Option("-", 255);
			atom.element.options.selectedIndex = atom.element.options.length-1;
		}
		atom.element.disabled = !isSupportSDFlg;
        boardNoSpecializationProtection(win.protection.LINEPROTECTION);
		ct.getAtom("workingUnitDelayTime").element.disabled = false;
		ct.getAtom("protectionUnitDelayTime").element.disabled = false;
		
    
    }
    else if (selectValue == win.protection.BOARDPROTECTION)//  1+1
    {
        var atom = ct.getAtom("neWithWorkingUnit");
        atom.clearOptions();
        atom.element.options[atom.element.options.length] = new Option(neName, 0);
        atom.element.disabled = false;
        atom.element["onchange"] = function()
        {
            changeNeWithWorkingUnit(this.value);
            isSuccess = false;
        }
        
        atom = ct.getAtom("neWithControlUnit");
        var neidstr = getNeid(win.neIdValue);
        atom.element.disabled = false;
        atom.element["onchange"] = function()
        {
            changeNeWithControlUnit(this.value);
            isSuccess = false;
        }
        
        changeNeWithControlUnit(atom.element.value);
        changeNeWithWorkingUnit(CURRENTNE);
        
        var workingUnit = ct.getAtom("boardWithWorkingUnit").element.value;
        var tempRes = getUsableBoard(workingUnit);
        if (null != workingUnit && "" != workingUnit && Number(neverflg) >= 3 && ("OLP" == tempRes.boardName || "DCP" == tempRes.boardName || "12OLP" == tempRes.boardName || "12DCP" == tempRes.boardName
        ||SpecialAttrMgr.isCPSupportByType(win.neIdValue,tempRes.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_DCP_SPECIALOP")
        ||SpecialAttrMgr.isCPSupportByType(win.neIdValue,tempRes.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_OLP_SPECIALOP"))) 
        {
            atom.clearOptions();
            if (hasDetectRes()) 
            {
                atom.element.options[atom.element.options.length] = new Option(neName, 1);
            }
            atom.element.options[atom.element.options.length] = new Option("---", 0);
            atom.element.disabled = false;
            atom.element["onchange"] = function()
            {
                changeNeWithControlUnit(this.value);
                isSuccess = false;
            }
            changeNeWithControlUnit(atom.element.value);
        }
        else 
        {
            atom.clearOptions();
            atom.element.options[atom.element.options.length] = new Option(UNSUPPORTED, 0);
            atom.element.disabled = true;
            
            atom = ct.getAtom("boardWithControlUnit");
            atom.clearOptions();
            atom.element.options[atom.element.options.length] = new Option(UNSUPPORTED, 0);
            atom.element.disabled = true;
            
            atom = ct.getAtom("controlUnitWorkingPath");
            atom.clearOptions();
            atom.element.options[atom.element.options.length] = new Option(UNSUPPORTED, 0);
            atom.element.disabled = true;
        }
		atom = ct.getAtom("sdTriggerFlag");

		if(atom.element.disabled)
		{
			atom.clearOptions();
			for(var i=0;i<sdOptions.length;i++)
			{
				atom.addOptionObj(sdOptions[i]);
			}
		}
		atom.element.disabled =false;
		
		ct.getAtom("workingUnitDelayTime").element.disabled = false;
		ct.getAtom("protectionUnitDelayTime").element.disabled = false;
		
		
    }
    else//   1+1
     {
        var atom = null;
        
        atom = ct.getAtom("neWithWorkingUnit");
        atom.clearOptions();
        atom.element.options[atom.element.options.length] = new Option(neName, 0);
		atom.element.options[atom.element.options.length] = new Option(RESOURCE["otherdevice"], OTHERDEVICE); //           
        atom.element.disabled = false;
		atom.element["onchange"] = function()
        {
            changeClient1Plus1NeWithWorkingUnit(this.value);
            isSuccess = false;
        }
        
        atom = ct.getAtom("boardWithWorkingUnit");
        atom.clearOptions();
        for (var i = 0, len1 = usableBoardArr.length; i < len1; i++) 
        {
            if ("client" == usableBoardArr[i].protectionType) 
            {
                if (!hasPortForWorkingUnitClient(usableBoardArr[i])) 
                {
                    continue;
                }
                atom.addOption(usableBoardArr[i].toString(), usableBoardArr[i].key);
                atom.element.onchange = function()
                {
                    changeBoardWithWorkingUnitClient(this.value);
                    clientProtectionLinkage();
                    isSuccess = false;
                }
            }
        }
        atom.element.disabled = false;
        
        atom = ct.getAtom("workingUnit");
        atom.clearOptions();
        atom.element.options[atom.element.options.length] = new Option("", 0);
        atom.element.disabled = false;
        
        atom = ct.getAtom("neWithProtectionUnit");
        atom.clearOptions();
        atom.element.options[atom.element.options.length] = new Option(neName, 0);
		atom.element.options[atom.element.options.length] = new Option(RESOURCE["otherdevice"], OTHERDEVICE); //           
        atom.element.disabled = false;
		atom.element["onchange"] = function()
        {
            changeClient1Plus1NeWithProtectionUnit(this.value);
            isSuccess = false;
        }
        
        atom = ct.getAtom("boardWithProtectionUnit");
        atom.clearOptions();
        for (var j = 0, len2 = usableBoardArr.length; j < len2; j++) 
        {
            if ("client" == usableBoardArr[j].protectionType) 
            {
                if (!hasPortForProtectionUnitClient(usableBoardArr[j])) 
                {
                    continue;
                }
                atom.addOption(usableBoardArr[j].toString(), usableBoardArr[j].key);
                atom.element.onchange = function()
                {
                    changeBoardWithProtectionUnitClient(this.value);
                    clientProtectionLinkage();
                    isSuccess = false;
                }
            }
        }
        atom.element.disabled = false;
        
        atom = ct.getAtom("protectionUnit");
        atom.clearOptions();
        atom.element.options[atom.element.options.length] = new Option("", 0);
        atom.element.disabled = false;
        
        atom = ct.getAtom("neWithControlUnit");
        var neidstr = getNeid(win.neIdValue);
        atom.clearOptions();
        atom.element.options[atom.element.options.length] = new Option(neName, 1);
        atom.element.options[atom.element.options.length] = new Option(RESOURCE["otherdevice"], OTHERDEVICE);
        atom.element.options[atom.element.options.length] = new Option("---", 0);
        atom.element.disabled = false;
        atom.element["onchange"] = function()
        {
            changeNeWithControlUnit(this.value);
            isSuccess = false;
        }
        
        changeNeWithControlUnit(CURRENTNE);
        
                                  		
		atom = ct.getAtom("sdTriggerFlag");
		if(atom.element.disabled)
		{
			atom.clearOptions();
			for(var i=0;i<sdOptions.length;i++)
			{
				atom.addOptionObj(sdOptions[i]);
			}
		}
		atom.element.disabled =false;
		
		if (isSupportSwitchDectFlag)
		{
		}
		
        changeBoardWithWorkingUnitClient(ct.getAtom("boardWithWorkingUnit").getValue());
        changeBoardWithProtectionUnitClient(ct.getAtom("boardWithProtectionUnit").getValue());
             

    }
	
    if(isSupportSwitchTypeAndAPSFlag)
    {
        showSwitchTypeAndAPS(selectValue);
    }
    if (isSupportSwitchDectFlag && selectValue != win.protection.BOARDPROTECTION)
	{
        atom = ct.getAtom("switchDectTime");
        atom.element.disabled = false;
        atom.setValue(0);
	}
}

/**
 *                   APS    
 * @param {Object} selectValue
 */
function showSwitchTypeAndAPS(selectValue)
{
    if(selectValue == win.protection.BOARDPROTECTION)
    {
        var atom = null;
        atom = ct.getAtom("switchType").element.parentNode.parentNode;
        atom.style.display = "";
        atom = ct.getAtom("apsChannel").element.parentNode.parentNode;
        atom.style.display = "";
    }
    else
    {
        var atom = null;
        atom = ct.getAtom("switchType").element.parentNode.parentNode;
        atom.style.display = "none";
        atom = ct.getAtom("apsChannel").element.parentNode.parentNode;
        atom.style.display = "none";
    }
}

/**
 *         1+1             
 */
function boardNoSpecializationProtection(type)
{
    var atom = null;
    
    atom = ct.getAtom("boardWithWorkingUnit");
    atom.clearOptions();
    if (type == win.protection.LINEPROTECTION)//     
    {
        for (var i = 0, len = usableBoardArr.length; i < len; i++) 
        {
            if (usableBoardArr[i].protectionType == "line") 
            {
                if (!hasPortForWorkingUnit(usableBoardArr[i])) 
                {
                    continue;
                }
                atom.element.options[atom.element.options.length] = new Option(usableBoardArr[i].toString(), usableBoardArr[i].key);
                
                atom.element.onchange = function()
                {
                    changeBoardWithWorkingUnit(this.value);
                    var theAtom = ct.getAtom("boardWithProtectionUnit");
                    theAtom.setValue(this.value);
                    changeBoardWithProtectionUnit(this.value);
                    isSuccess = false;
                }
            }
        }
    }
    else//  1+1  OLP
     {
        for (var i = 0, len = usableBoardArr.length; i < len; i++) 
        {
            if (usableBoardArr[i].protectionType == "boardolp") 
            {
                if (!hasPortForWorkingUnit(usableBoardArr[i])) 
                {
                    continue;
                }
                atom.element.options[atom.element.options.length] = new Option(usableBoardArr[i].toString(), usableBoardArr[i].key);
                atom.element.onchange = function()
                {
                    changeBoardWithWorkingUnit(this.value);
                    var theAtom = ct.getAtom("boardWithProtectionUnit");
                    theAtom.setValue(this.value);
                    changeBoardWithProtectionUnit(this.value);
                    isSuccess = false;
                }
            }
        }
    }
    atom.element.disabled = false;
    
    atom = ct.getAtom("workingUnit");
    atom.clearOptions();
    atom.addOption("", 0);
    atom.element.disabled = false;
    
    atom = ct.getAtom("neWithProtectionUnit");
    atom.clearOptions();
    atom.element.options[atom.element.options.length] = new Option(neName, 0);
    atom.element.disabled = true;
    
    atom = ct.getAtom("boardWithProtectionUnit");
    atom.clearOptions();
    if (type == win.protection.LINEPROTECTION)//     
    {
        for (var i = 0, len = usableBoardArr.length; i < len; i++) 
        {
            if (usableBoardArr[i].protectionType == "line") 
            {
                if (!hasPortForProtectionUnit(usableBoardArr[i]) || !hasPortForWorkingUnit(usableBoardArr[i])) 
                {
                    continue;
                }
                atom.element.options[atom.element.options.length] = new Option(usableBoardArr[i].toString(), usableBoardArr[i].key);
                atom.element.onchange = function()
                {
                    changeBoardWithProtectionUnit(this.value);
                    var theAtom = ct.getAtom("boardWithWorkingUnit");
                    theAtom.setValue(this.value);
                    changeBoardWithWorkingUnit(this.value);
                    isSuccess = false;
                }
            }
        }
    }
    else//  1+1  OLP
     {
        for (var i = 0, len = usableBoardArr.length; i < len; i++) 
        {
            if (usableBoardArr[i].protectionType == "boardolp") 
            {
                if (!hasPortForProtectionUnit(usableBoardArr[i]) || !hasPortForWorkingUnit(usableBoardArr[i])) 
                {
                    continue;
                }
                atom.element.options[atom.element.options.length] = new Option(usableBoardArr[i].toString(), usableBoardArr[i].key);
                atom.element.onchange = function()
                {
                    changeBoardWithProtectionUnit(this.value);
                    var theAtom = ct.getAtom("boardWithWorkingUnit");
                    theAtom.setValue(this.value);
                    changeBoardWithWorkingUnit(this.value);
                    isSuccess = false;
                }
            }
        }
    }
    atom.element.disabled = true;
    
    atom = ct.getAtom("protectionUnit");
    atom.clearOptions();
    atom.addOption("", 0);
    atom.element.disabled = false;
    
    atom = ct.getAtom("neWithControlUnit");
    atom.clearOptions();
    atom.element.options[atom.element.options.length] = new Option(UNSUPPORTED, 0);
    atom.element.disabled = true;
    
    atom = ct.getAtom("boardWithControlUnit");
    atom.clearOptions();
    atom.element.options[atom.element.options.length] = new Option(UNSUPPORTED, 0);
    atom.element.disabled = true;
    
    atom = ct.getAtom("controlUnitWorkingPath");
    atom.clearOptions();
    atom.element.options[atom.element.options.length] = new Option(UNSUPPORTED, 0);
    atom.element.disabled = true;
    
    /*atom = ct.getAtom("controlUnitProtectionPath");
     atom.clearOptions();
     atom.element.options[atom.element.options.length] = new Option(UNSUPPORTED,0);
     atom.element.disabled = true;*/
    /**        
     atom = ct.getAtom("sdCondition");
     atom.element.disabled = true;
     atom.setValue("");
     
     atom = ct.getAtom("sfCondition");
     atom.element.disabled = true;
     atom.setValue("");
     **/
    
    changeBoardWithWorkingUnit(ct.getAtom("boardWithWorkingUnit").element.value);
    changeBoardWithProtectionUnit(ct.getAtom("boardWithProtectionUnit").element.value);
}

/**
 *                              
 */
function changeBoardWithControlUnit(key)
{
    if ("" == key || null == key) 
    {
        return;
    }
    var atom = null;
    var usableBoard = null;
    
    atom = ct.getAtom("controlUnitWorkingPath");
    atom.clearOptions();
    
    usableBoard = getUsableBoard(key);         
    if ("DCP" == usableBoard.boardName || "12DCP" == usableBoard.boardName 
       || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_DCP_SPECIALOP")) 
    {
        if (("1" == getPortID(usableBoard.portName)) || ("3" == getPortID(usableBoard.portName))) 
        {
            atom.addOption(usableBoard.portName, getPortID(usableBoard.portName));
        }
        for (var i = 0, len1 = usableBoard.portArr.length; i < len1; i++) 
        {
            if (("1" == getPortID(usableBoard.portArr[i])) || ("3" == getPortID(usableBoard.portArr[i]))) 
            {
                atom.addOption(usableBoard.portArr[i], getPortID(usableBoard.portArr[i]));
            }
        }
    }
    else if ("OLP" == usableBoard.boardName || "12OLP" == usableBoard.boardName 
            || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_OLP_SPECIALOP")) 
    {
        if ("1" == getPortID(usableBoard.portName)) 
        {
            atom.addOption(usableBoard.portName, getPortID(usableBoard.portName));
        }
        for (var i = 0, len1 = usableBoard.portArr.length; i < len1; i++) 
        {
            if ("1" == getPortID(usableBoard.portArr[i])) 
            {
                atom.addOption(usableBoard.portArr[i], getPortID(usableBoard.portArr[i]));
            }
        }
    }
    else 
    {
        atom.addOption(usableBoard.portName, getPortID(usableBoard.portName));
        for (var i = 0, len1 = usableBoard.portArr.length; i < len1; i++) 
        {
            atom.addOption(usableBoard.portArr[i], getPortID(usableBoard.portArr[i]));
        }
    }
    
}

/**
 *   1+1                 
 */
function changeNeWithWorkingUnit(selectUnit)
{
    if (selectUnit == CURRENTNE)//      
    {
        var atom = null;
        
        atom = ct.getAtom("boardWithWorkingUnit");
        atom.clearOptions();
        for (var i = 0, len1 = usableBoardArr.length; i < len1; i++) 
        {
            if (usableBoardArr[i].protectionType == "board1plus1") 
            {
                if (!hasPortForWorkingUnit(usableBoardArr[i])) 
                {
                    continue;
                }
                atom.element.options[atom.element.options.length] = new Option(usableBoardArr[i].toString(), usableBoardArr[i].key);
            }
        }
        atom.element.disabled = false;
        atom.element.onchange = function()
        {
            changeBoardWithWorkingUnit(this.value);
            var theAtom = ct.getAtom("boardWithProtectionUnit");
            theAtom.setValue(this.value);
            changeBoardWithProtectionUnit(this.value);
            isSuccess = false;
            var workUnitRes = getUsableBoard(ct.getAtom("boardWithWorkingUnit").element.value);
         
            if (Number(neverflg) >= 3 && ("OLP" == workUnitRes.boardName || "DCP" == workUnitRes.boardName || "12OLP" == workUnitRes.boardName || "12DCP" == workUnitRes.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,workUnitRes.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_OLP_SPECIALOP") || SpecialAttrMgr.isCPSupportByType(win.neIdValue,workUnitRes.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_DCP_SPECIALOP") ) ) 
            {
                var boardWithWorkingUnitvalue = ct.getAtom("boardWithWorkingUnit").element.value
                var slotid = boardWithWorkingUnitvalue.substring(0, boardWithWorkingUnitvalue.indexOf("-"));
                islot = slotid;
                atom = ct.getAtom("neWithControlUnit");
                var neidstr = getNeid(win.neIdValue);
                atom.clearOptions();
                
                if (hasDetectRes()) 
                {
                    atom.element.options[atom.element.options.length] = new Option(neName, 1);
                }
                atom.element.options[atom.element.options.length] = new Option("---", 0);
                atom.element.disabled = false;
                changeNeWithControlUnit(atom.element.value);
                atom.element["onchange"] = function()
                {
                    changeNeWithControlUnit(this.value);
                    isSuccess = false;
                }
            }
            else 
            {
                atom = ct.getAtom("neWithControlUnit");
                atom.clearOptions();
                atom.element.options[atom.element.options.length] = new Option(UNSUPPORTED, 0);
                atom.element.disabled = true;
                
                atom = ct.getAtom("boardWithControlUnit");
                atom.clearOptions();
                atom.element.options[atom.element.options.length] = new Option(UNSUPPORTED, 0);
                atom.element.disabled = true;
                
                atom = ct.getAtom("controlUnitWorkingPath");
                atom.clearOptions();
                atom.element.options[atom.element.options.length] = new Option(UNSUPPORTED, 0);
                atom.element.disabled = true;
            }
            
        }
        
        atom = ct.getAtom("workingUnit");
        atom.clearOptions();
        atom.element.options[atom.element.options.length] = new Option("", 0);
        atom.element.disabled = false;
        atom.element["onchange"] = function()
        {
            var workUnitRes = getUsableBoard(ct.getAtom("boardWithWorkingUnit").element.value);

            if ("DCP" == workUnitRes.boardName || "12DCP" == workUnitRes.boardName
                 || SpecialAttrMgr.isCPSupportByType(win.neIdValue,workUnitRes.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_DCP_SPECIALOP") ) 
            {
                isSuccess = false;
                linkageDCP("workingUnit", "protectionUnit");
            }
        }
        
        atom = ct.getAtom("neWithProtectionUnit");
        atom.clearOptions();
        atom.element.options[atom.element.options.length] = new Option(neName, 0);
        atom.element.disabled = true;
        
        atom = ct.getAtom("boardWithProtectionUnit");
        atom.clearOptions();
        for (var j = 0, len2 = usableBoardArr.length; j < len2; j++) 
        {
            if (usableBoardArr[j].protectionType == "board1plus1") 
            {
                if (!hasPortForProtectionUnit(usableBoardArr[j]) || !hasPortForWorkingUnit(usableBoardArr[j])) 
                {
                    continue;
                }
                atom.element.options[atom.element.options.length] = new Option(usableBoardArr[j].toString(), usableBoardArr[j].key);
            }
        }
        atom.element.disabled = true;
        atom.element.onchange = function()
        {
            changeBoardWithProtectionUnit(this.value);
            var theAtom = ct.getAtom("boardWithWorkingUnit");
            theAtom.setValue(this.value);
            changeBoardWithWorkingUnit(this.value);
            isSuccess = false;
        }
        
        atom = ct.getAtom("protectionUnit");
        atom.clearOptions();
        atom.element.options[atom.element.options.length] = new Option("", 0);
        atom.element.disabled = false;
        atom.element["onchange"] = function()
        {
            var workUnitRes = getUsableBoard(ct.getAtom("boardWithWorkingUnit").element.value);
            if ("DCP" == workUnitRes.boardName || "12DCP" == workUnitRes.boardName
               || SpecialAttrMgr.isCPSupportByType(win.neIdValue,workUnitRes.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_DCP_SPECIALOP") ) 
            {
                isSuccess = false;
                linkageDCP("protectionUnit", "workingUnit");
            }
        }
        
        changeBoardWithWorkingUnit(ct.getAtom("boardWithWorkingUnit").getValue());
        changeBoardWithProtectionUnit(ct.getAtom("boardWithProtectionUnit").getValue());
        
    }
}

/**
 *              
 */
function changeBoardWithWorkingUnit(key)
{
    if ("" == key || null == key) 
    {
        return;
    }
    
    var atom = null;
    var usableBoard = null;
    
    atom = ct.getAtom("workingUnit");
    atom.clearOptions();
    
    usableBoard = getUsableBoard(key);
         
    if ("OLP" == usableBoard.boardName || "12OLP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_OLP_SPECIALOP") ) 
    {
        if ("1" == getPortID(usableBoard.portName)) 
        {
            atom.addOption(usableBoard.portName, getPortID(usableBoard.portName));
        }
    }
    else 
    {
        if ("DCP" == usableBoard.boardName || "12DCP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_DCP_SPECIALOP") ) 
        {
            if ("1" == getPortID(usableBoard.portName) || "3" == getPortID(usableBoard.portName)) 
            {
                atom.addOption(usableBoard.portName, getPortID(usableBoard.portName));
            }
        }
        else 
        {
            if ("1" == getPortID(usableBoard.portName)) 
            {
                atom.addOption(usableBoard.portName, getPortID(usableBoard.portName));
            }
            else 
            {
                atom.addOption(usableBoard.portName, getPortID(usableBoard.portName));
            }
        }
    }
    for (var i = 0, len1 = usableBoard.portArr.length; i < len1; i++) 
    {
        if ("OLP" == usableBoard.boardName || "12OLP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_OLP_SPECIALOP") ) 
        {
            if ("1" == getPortID(usableBoard.portArr[i])) 
            {
                atom.addOption(usableBoard.portArr[i], getPortID(usableBoard.portArr[i]));
            }
        }
        else 
        {
            if ("DCP" == usableBoard.boardName || "12DCP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_DCP_SPECIALOP") ) 
            {
                if ("1" == getPortID(usableBoard.portArr[i]) || "3" == getPortID(usableBoard.portArr[i])) 
                {
                    atom.addOption(usableBoard.portArr[i], getPortID(usableBoard.portArr[i]));
                }
            }
            else 
            {
                if ("1" == getPortID(usableBoard.portArr[i])) 
                {
                    atom.addOption(usableBoard.portArr[i], getPortID(usableBoard.portArr[i]));
                }
                else 
                {
                    atom.addOption(usableBoard.portArr[i], getPortID(usableBoard.portArr[i]));
                }
            }
        }
        
    }
    var proType = parseInt(ct.getAtom("protectionType").getValue());
    var res = getUsableBoard(ct.getAttrValue("boardWithWorkingUnit"));
    if (proType == 1 && res != null && (res.boardName == "OLP" || res.boardName == "DCP" || res.boardName == "12OLP" || res.boardName == "12DCP"
     || SpecialAttrMgr.isCPSupportByType(win.neIdValue,res.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_OLP_SPECIALOP") 
     || SpecialAttrMgr.isCPSupportByType(win.neIdValue,res.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_DCP_SPECIALOP") )) 
    {
        atom = ct.getAtom("revertiveMode");
        atom.clearOptions();
        atom.element.options[atom.element.options.length] = new Option(UNSUPPORTED, 0);
        atom.element.disabled = true;
        
        atom = ct.getAtom("wtrTime");
        atom.setValue(UNSUPPORTED);
        atom.element.disabled = true;
    }
    else 
    {
        atom = ct.getAtom("revertiveMode");
        atom.clearOptions();
        atom.element.options[atom.element.options.length] = new Option(RESOURCE["nonrevertive"], 0);
        atom.element.options[atom.element.options.length] = new Option(RESOURCE["revertive"], 1);
        atom.element.disabled = false;
        
        atom = ct.getAtom("wtrTime");
        atom.setValue(NONREVERTIVWTRTIME);
        atom.element.disabled = true;
    }
}

/**
 *              (   1+1   
 */
function changeBoardWithWorkingUnitClient(key)
{
    if ("" == key || null == key) 
    {
        return;
    }
    
    var atom = null;
    var usableBoard = null;
    
    atom = ct.getAtom("workingUnit");
    atom.clearOptions();
    
    usableBoard = getUsableBoard(key);
         
    if ("OLP" == usableBoard.boardName || "12OLP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_OLP_SPECIALOP") ) 
    {
        if ("1" == getPortID(usableBoard.portName)) 
        {
            atom.addOption(usableBoard.portName, getPortID(usableBoard.portName));
        }
    }
    else 
    {
        if ("DCP" == usableBoard.boardName || "12DCP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_DCP_SPECIALOP") ) 
        {
            if ("1" == getPortID(usableBoard.portName) || "3" == getPortID(usableBoard.portName)) 
            {
                atom.addOption(usableBoard.portName, getPortID(usableBoard.portName));
            }
        }
        else 
        {
            atom.addOption(usableBoard.portName, getPortID(usableBoard.portName));
        }
    }
    for (var i = 0, len1 = usableBoard.portArr.length; i < len1; i++) 
    {
        if ("OLP" == usableBoard.boardName || "12OLP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_OLP_SPECIALOP") ) 
        {
            if ("1" == getPortID(usableBoard.portArr[i])) 
            {
                atom.addOption(usableBoard.portArr[i], getPortID(usableBoard.portArr[i]));
            }
        }
        else 
        {
            if ("DCP" == usableBoard.boardName || "12DCP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_DCP_SPECIALOP") ) 
            {
                if ("1" == getPortID(usableBoard.portArr[i]) || "3" == getPortID(usableBoard.portArr[i])) 
                {
                    atom.addOption(usableBoard.portArr[i], getPortID(usableBoard.portArr[i]));
                }
            }
            else 
            {
                atom.addOption(usableBoard.portArr[i], getPortID(usableBoard.portArr[i]));
            }
        }
        
    }
}

/**
 *              
 */
function changeBoardWithProtectionUnit(key)
{
    if ("" == key || null == key) 
    {
        return;
    }
    
    var atom = null;
    var usableBoard = null;
    
    atom = ct.getAtom("protectionUnit");
    atom.clearOptions();
    
    usableBoard = getUsableBoard(key);
    if ("OLP" == usableBoard.boardName || "12OLP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_OLP_SPECIALOP") ) 
    {
        if ("2" == getPortID(usableBoard.portName)) 
        {
            atom.addOption(usableBoard.portName, getPortID(usableBoard.portName));
        }
    }
    else 
    {
        if ("DCP" == usableBoard.boardName || "12DCP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_DCP_SPECIALOP") ) 
        {
            if ("2" == getPortID(usableBoard.portName) || "4" == getPortID(usableBoard.portName)) 
            {
                atom.addOption(usableBoard.portName, getPortID(usableBoard.portName));
            }
        }
        else 
        {
            if ("2" == getPortID(usableBoard.portName)) 
            {
                atom.addOption(usableBoard.portName, getPortID(usableBoard.portName));
            }
            else 
            {
                atom.addOption(usableBoard.portName, getPortID(usableBoard.portName));
            }
        }
    }
    for (var i = 0, len1 = usableBoard.portArr.length; i < len1; i++) 
    {
        if ("OLP" == usableBoard.boardName || "12OLP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_OLP_SPECIALOP") ) 
        {
            if ("2" == getPortID(usableBoard.portArr[i])) 
            {
                atom.addOption(usableBoard.portArr[i], getPortID(usableBoard.portArr[i]));
            }
        }
        else 
        {
            if ("DCP" == usableBoard.boardName || "12DCP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_DCP_SPECIALOP") ) 
            {
                if ("2" == getPortID(usableBoard.portArr[i]) || "4" == getPortID(usableBoard.portArr[i])) 
                {
                    atom.addOption(usableBoard.portArr[i], getPortID(usableBoard.portArr[i]));
                }
            }
            else 
            {
                if ("2" == getPortID(usableBoard.portArr[i])) 
                {
                    atom.addOption(usableBoard.portArr[i], getPortID(usableBoard.portArr[i]));
                }
                else 
                {
                    atom.addOption(usableBoard.portArr[i], getPortID(usableBoard.portArr[i]));
                }
            }
        }
    }
    if ("DCP" == usableBoard.boardName || "12DCP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_DCP_SPECIALOP") ) 
    {
        linkageDCP("workingUnit", "protectionUnit");
    }
    
}

/**
 *              (   1+1   
 */
function changeBoardWithProtectionUnitClient(key)
{
    if ("" == key || null == key) 
    {
        return;
    }
    
    var atom = null;
    var usableBoard = null;
    
    atom = ct.getAtom("protectionUnit");
    atom.clearOptions();
    
    usableBoard = getUsableBoard(key);
    if ("OLP" == usableBoard.boardName || "12OLP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_OLP_SPECIALOP") ) 
    {
        if ("2" == getPortID(usableBoard.portName)) 
        {
            atom.addOption(usableBoard.portName, getPortID(usableBoard.portName));
        }
    }
    else 
    {
        if ("DCP" == usableBoard.boardName || "12DCP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_DCP_SPECIALOP") ) 
        {
            if ("2" == getPortID(usableBoard.portName) || "4" == getPortID(usableBoard.portName)) 
            {
                atom.addOption(usableBoard.portName, getPortID(usableBoard.portName));
            }
        }
        else 
        {
            atom.addOption(usableBoard.portName, getPortID(usableBoard.portName));
        }
    }
    for (var i = 0, len1 = usableBoard.portArr.length; i < len1; i++) 
    {
        if ("OLP" == usableBoard.boardName || "12OLP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_OLP_SPECIALOP") ) 
        {
            if ("2" == getPortID(usableBoard.portArr[i])) 
            {
                atom.addOption(usableBoard.portArr[i], getPortID(usableBoard.portArr[i]));
            }
        }
        else 
        {
            if ("DCP" == usableBoard.boardName || "12DCP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_DCP_SPECIALOP") ) 
            {
                if ("2" == getPortID(usableBoard.portArr[i]) || "4" == getPortID(usableBoard.portArr[i])) 
                {
                    atom.addOption(usableBoard.portArr[i], getPortID(usableBoard.portArr[i]));
                }
            }
            else 
            {
                atom.addOption(usableBoard.portArr[i], getPortID(usableBoard.portArr[i]));
            }
        }
    }
    if ("DCP" == usableBoard.boardName || "12DCP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_DCP_SPECIALOP") ) 
    {
        linkageDCP("workingUnit", "protectionUnit");
    }
    
}

/**
 *    1+1        
 * @param {Object} selectValue
 */
function changeClient1Plus1NeWithWorkingUnit(selectValue)
{
	var atom = null;
	if (selectValue == 0) //     
	{
        atom = ct.getAtom("boardWithWorkingUnit");
        atom.clearOptions();
        for (var i = 0, len1 = usableBoardArr.length; i < len1; i++) 
        {
            if ("client" == usableBoardArr[i].protectionType) 
            {
                if (!hasPortForWorkingUnitClient(usableBoardArr[i])) 
                {
                    continue;
                }
                atom.addOption(usableBoardArr[i].toString(), usableBoardArr[i].key);
                atom.element.onchange = function()
                {
                    changeBoardWithWorkingUnitClient(this.value);
                    clientProtectionLinkage();
                    isSuccess = false;
                }
            }
        }
        atom.element.disabled = false;
		
        atom = ct.getAtom("workingUnit");
        atom.clearOptions();
        atom.element.options[atom.element.options.length] = new Option("", 0);
        atom.element.disabled = false;
		
		atom = ct.getAtom("workingUnitDelayTime");
        atom.element.disabled = false;
		
        changeBoardWithWorkingUnitClient(ct.getAtom("boardWithWorkingUnit").getValue());
        
        atom = ct.getAtom("neWithProtectionUnit");
        var controlAtom = ct.getAtom("neWithControlUnit");
        var switchDectTimeAtom = ct.getAtom("switchDectTime");
        if (atom.element.value != OTHERDEVICE && controlAtom.element.value != OTHERDEVICE && isSupportSwitchDectFlag)
        {
        	switchDectTimeAtom.element.disabled = false;
        	switchDectTimeAtom.setValue("0");
        }
        else
        {
        	switchDectTimeAtom.element.disabled = true;
        	switchDectTimeAtom.setValue("-");
        }
	}
	
	if (selectValue == OTHERDEVICE) //     
	{
        atom = ct.getAtom("boardWithWorkingUnit");
        atom.clearOptions();
        atom.element.options[atom.element.options.length] = new Option(UNSUPPORTED, 0);
        atom.element.disabled = true;
        
        atom = ct.getAtom("workingUnit");
        atom.clearOptions();
        atom.element.options[atom.element.options.length] = new Option(UNSUPPORTED, 0);
        atom.element.disabled = true;
		
        atom = ct.getAtom("workingUnitDelayTime");
		atom.setValue("0");
        atom.element.disabled = true;
        
        atom = ct.getAtom("switchDectTime");
        atom.element.disabled = true;
        atom.setValue("-");
	}
}

/**
 *    1+1        
 * @param {Object} selectValue
 */
function changeClient1Plus1NeWithProtectionUnit(selectValue)
{
	var atom = null;
	if (selectValue == 0) //     
	{
		atom = ct.getAtom("boardWithProtectionUnit");
        atom.clearOptions();
        for (var j = 0, len2 = usableBoardArr.length; j < len2; j++) 
        {
            if ("client" == usableBoardArr[j].protectionType) 
            {
                if (!hasPortForProtectionUnitClient(usableBoardArr[j])) 
                {
                    continue;
                }
                atom.addOption(usableBoardArr[j].toString(), usableBoardArr[j].key);
                atom.element.onchange = function()
                {
                    changeBoardWithProtectionUnitClient(this.value);
                    clientProtectionLinkage();
                    isSuccess = false;
                }
            }
        }
        atom.element.disabled = false;
		
        atom = ct.getAtom("protectionUnitDelayTime");
        atom.element.disabled = false;
        
        atom = ct.getAtom("protectionUnit");
        atom.clearOptions();
        atom.element.options[atom.element.options.length] = new Option("", 0);
        atom.element.disabled = false;
		changeBoardWithProtectionUnitClient(ct.getAtom("boardWithProtectionUnit").getValue());
		
        atom = ct.getAtom("neWithWorkingUnit");
        var controlAtom = ct.getAtom("neWithControlUnit");
        var switchDectTimeAtom = ct.getAtom("switchDectTime");
        if (atom.element.value != OTHERDEVICE && controlAtom.element.value != OTHERDEVICE && isSupportSwitchDectFlag)
        {
        	switchDectTimeAtom.element.disabled = false;
        	switchDectTimeAtom.setValue("0");
        }
        else
        {
        	switchDectTimeAtom.element.disabled = true;
        	switchDectTimeAtom.setValue("-");
        }
	}
	if (selectValue == OTHERDEVICE) //     
	{
        atom = ct.getAtom("boardWithProtectionUnit");
        atom.clearOptions();
        atom.element.options[atom.element.options.length] = new Option(UNSUPPORTED, 0);
        atom.element.disabled = true;
        
        atom = ct.getAtom("protectionUnit");
        atom.clearOptions();
        atom.element.options[atom.element.options.length] = new Option(UNSUPPORTED, 0);
        atom.element.disabled = true;
		
        atom = ct.getAtom("protectionUnitDelayTime");
		atom.setValue("0");
        atom.element.disabled = true;
        
        var switchDectTimeAtom = ct.getAtom("switchDectTime");
        switchDectTimeAtom.element.disabled = true;
    	switchDectTimeAtom.setValue("-");
	}
}

function changeSwitchTypeAndAPSDisable(selectValue)
{
    var proType = parseInt(ct.getAtom("protectionType").getValue());
    if(isSupportSwitchTypeAndAPSFlag && proType == win.protection.BOARDPROTECTION)
    {
        var tempAtom = null
        if(parseInt(selectValue) == NONE)
        {
            tempAtom = ct.getAtom("switchType");
            tempAtom.setValue(win.apsSwitchType.unidirectional);
            tempAtom.element.disabled = true;
        
            tempAtom = ct.getAtom("apsChannel");
            tempAtom.element.disabled = true;
            tempAtom.setValue("-");
        }
        else
        {
            tempAtom = ct.getAtom("switchType");
            tempAtom.setValue(win.apsSwitchType.unidirectional);
            tempAtom.element.disabled = false;

            tempAtom = ct.getAtom("apsChannel");
            tempAtom.element.disabled = true;
            tempAtom.setValue("-");
        }
    }	
}

/**
 *    1+1                 
 */
function changeNeWithControlUnit(selectValue)
{
    var atom = null;
    switch (parseInt(selectValue))
    {
        case CURRENTNE://      
            atom = ct.getAtom("controlUnitWorkingPath");
            atom.clearOptions();
            atom.element.options[atom.element.options.length] = new Option("", 1);
            atom.element.disabled = false;
            
            var proType = parseInt(ct.getAtom("protectionType").getValue());
            
            atom = ct.getAtom("boardWithControlUnit");
            atom.clearOptions();
            var res;
            if (proType == 1) 
            {
                res = getUsableBoard(ct.getAttrValue("boardWithWorkingUnit"));
  
                if (res != null) 
                {
                    var selIndex = 0;
                    var isSetIndex = false;
                    for (var i = 0, len = usableBoardArr.length; i < len; i++) 
                    {
                        if ("boarddetect" == usableBoardArr[i].protectionType) 
                        {
                            if (!hasPortForControlUnit(usableBoardArr[i])) 
                            {
                                continue;
                            }
         
                            if (res.boardName == "OLP" || res.boardName == "DCP" || res.boardName == "12OLP" || SpecialAttrMgr.isCPSupportByType(win.neIdValue,res.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_DCP_SPECIALOP") || SpecialAttrMgr.isCPSupportByType(win.neIdValue,res.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_OLP_SPECIALOP") ) 
                            {
                                if (res.slotId == usableBoardArr[i].linkSlot) 
                                {
                                    atom.addOption(usableBoardArr[i].toString() + "*", usableBoardArr[i].key);
                                    if (!isSetIndex) 
                                    {
                                        selIndex = atom.element.options.length - 1;
                                        isSetIndex = true;
                                    }
                                    continue;
                                }
                            }
                            atom.addOption(usableBoardArr[i].toString(), usableBoardArr[i].key);
                        }
                    }
                    atom.element.options.selectedIndex = selIndex;
                }
            }
            else if (proType == 3) 
            {
                for (var i = 0, len = usableBoardArr.length; i < len; i++) 
                {
                    if ("boardolp" == usableBoardArr[i].protectionType) 
                    {
                        if (!hasPortForControlUnit(usableBoardArr[i])) 
                        {
                            continue;
                        }
                        atom.addOption(usableBoardArr[i].toString(), usableBoardArr[i].key);
                    }
                }
            }
            atom.element.disabled = false;
            changeBoardWithControlUnit(atom.getValue());
            atom.element.onchange = function()
            {
                changeBoardWithControlUnit(this.value);
                isSuccess = false;
            }
            
            if (proType == 1 && res != null && (res.boardName == "OLP" || res.boardName == "DCP" || res.boardName == "12OLP" || res.boardName == "12DCP"
             || SpecialAttrMgr.isCPSupportByType(win.neIdValue,res.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_DCP_SPECIALOP") || SpecialAttrMgr.isCPSupportByType(win.neIdValue,res.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_OLP_SPECIALOP") )) 
            {
                atom = ct.getAtom("revertiveMode");
                atom.clearOptions();
                atom.element.options[atom.element.options.length] = new Option(UNSUPPORTED, 0);
                atom.element.disabled = true;
                
                atom = ct.getAtom("wtrTime");
                atom.setValue(UNSUPPORTED);
                atom.element.disabled = true;
            }
            else 
            {
                atom = ct.getAtom("revertiveMode");
                atom.clearOptions();
                atom.element.options[atom.element.options.length] = new Option(RESOURCE["nonrevertive"], 0);
                atom.element.options[atom.element.options.length] = new Option(RESOURCE["revertive"], 1);
                atom.element.disabled = false;
                
                atom = ct.getAtom("wtrTime");
                atom.setValue(NONREVERTIVWTRTIME);
                atom.element.disabled = true;
            }
            
            atom = ct.getAtom("neWithWorkingUnit");
            var protectionAtom = ct.getAtom("neWithProtectionUnit");
            var switchDectTimeAtom = ct.getAtom("switchDectTime");
            if (proType == win.protection.CLIENTPROTECTION && atom.element.value != OTHERDEVICE 
            		&& protectionAtom.element.value != OTHERDEVICE && isSupportSwitchDectFlag)
            {
            	switchDectTimeAtom.element.disabled = false;
            	switchDectTimeAtom.setValue("0");
            }
            else
            {
            	switchDectTimeAtom.element.disabled = true;
            	switchDectTimeAtom.setValue("-");
            }
            break;
        case OTHERDEVICE://                   
            atom = ct.getAtom("boardWithControlUnit");
            atom.clearOptions();
            atom.element.options[atom.element.options.length] = new Option(UNSUPPORTED, 0);
            atom.element.disabled = true;
            
            atom = ct.getAtom("controlUnitWorkingPath");
            atom.clearOptions();
            atom.element.options[atom.element.options.length] = new Option(UNSUPPORTED, 0);
            atom.element.disabled = true;
            
            atom = ct.getAtom("revertiveMode");
            atom.clearOptions();
            atom.element.options[atom.element.options.length] = new Option(UNSUPPORTED, 0);
            atom.element.disabled = true;
            
            atom = ct.getAtom("wtrTime");
            atom.setValue(UNSUPPORTED);
            atom.element.disabled = true;
            
            var switchDectTimeAtom = ct.getAtom("switchDectTime");
            switchDectTimeAtom.element.disabled = true;
        	switchDectTimeAtom.setValue("-");
            break;
        case NONE://   
            atom = ct.getAtom("boardWithControlUnit");
            atom.clearOptions();
            atom.element.options[atom.element.options.length] = new Option(UNSUPPORTED, 0);
            atom.element.disabled = true;
            
            atom = ct.getAtom("controlUnitWorkingPath");
            atom.clearOptions();
            atom.element.options[atom.element.options.length] = new Option(UNSUPPORTED, 0);
            atom.element.disabled = true;
            
            atom = ct.getAtom("revertiveMode");
            atom.clearOptions();
            atom.element.options[atom.element.options.length] = new Option(RESOURCE["nonrevertive"], 0);
            atom.element.options[atom.element.options.length] = new Option(RESOURCE["revertive"], 1);
            atom.element.disabled = false;
            
            atom = ct.getAtom("wtrTime");
            atom.setValue(NONREVERTIVWTRTIME);
            atom.element.disabled = true;
            
            var switchDectTimeAtom = ct.getAtom("switchDectTime");
            switchDectTimeAtom.element.disabled = true;
        	switchDectTimeAtom.setValue("-");
            break;
    }
	
    changeSwitchTypeAndAPSDisable(selectValue);
}

/**
 *      
 */
function initBtn()
{
    $("okBtn").value = RESOURCE["okbutton"];
    $("cancelBtn").value = RESOURCE["cancelbutton"];
    $("applyBtn").value = RESOURCE["applybutton"];
}

/**
 *         
 */
function sendConfirmInfo()
{
    applyFlag = false;
    if (isSuccess) 
    {
        window.close();
    }
    else 
    {
        sendApplyInfo();
        if (isSuccess) 
        {
            window.close();
        }
    }
    
}

/**
 *         
 */
function sendApplyInfo()
{
    if (win.protectionGroupSTable.getDataRowLength() >= MAXPROTECTIONGROUPCOUNT)//         
    {
        alert(RESOURCE["maxcount"]);
        return;
    }
    
    if (win.protection.LINEPROTECTION == ct.getAttrValue("protectionType"))//     
    {
        if (true == checkWorkingUnit()) 
        {
            return;
        }
    }
    else if (win.protection.BOARDPROTECTION == ct.getAttrValue("protectionType")) 
    {
        if (ct.getAttrValue("neWithWorkingUnit") == 0)//  1+1  
        {
            if (true == checkWorkingUnit()) 
            {
                return;
            }
        }
        else//  1+1  OLP  
         {
            if ((true == checkControlUnit()) || (true == checkWorkingUnit())) 
            {
                return;
            }
        }
    }
    else 
    {
        if (ct.getAttrValue("neWithControlUnit") == 1)//   1+1  
        {
            if (true == (checkControlUnit() || checkWorkingUnit())) 
            {
                return;
            }
            
        }
        else//   1+1  -         SCS 
         {
            if (true == checkWorkingUnit()) 
            {
                return;
            }
        }
    }
    /**
     *      AU9D89593
     *     q00119080
     *            
     */
    var xmlstr = createCreatePortProtectionXML(); //       
    if (xmlstr == null) 
    {
        return;
    }
    applyFlag = true;
    $("okBtn").disabled = true;
    $("applyBtn").disabled = true;
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_WDM_OPPG_CREATE + "&flag=1";
    loadXMLdoc(urlreq, "POST", false, openCreateErrDialog, null, "inputdata=" + xmlstr);
}

/**
 *            
 */
function checkControlUnit()
{
    if ("-1" == ct.getAtom("boardWithControlUnit").element.options.selectedIndex)//        
    {
        alert(RESOURCE["boradwithcontrolunitisnotnull"]);
        return true;
    }
    else if ("-1" == ct.getAtom("controlUnitWorkingPath").element.options.selectedIndex)//        
    {
        alert(RESOURCE["controlunitworkingpathisnotnull"]);
        return true;
    }
    /*if("-1" == ct.getAtom("controlUnitProtectionPath").element.options.selectedIndex)//        
     {
     alert(RESOURCE["controlunitprotectionpathisnotnull"]);
     return true;
     }*/
    return false;
}

/**
 *            
 */
function checkWorkingUnit()
{
    if ("-1" == ct.getAtom("boardWithWorkingUnit").element.options.selectedIndex)//        
    {
        alert(RESOURCE["boardwithworkingunitisnotnull"]);
        return true;
    }
    else if ("-1" == ct.getAtom("workingUnit").element.options.selectedIndex)//    
    {
        alert(RESOURCE["workingunitisnotnull"]);
        return true;
    }
    else if ("-1" == ct.getAtom("boardWithProtectionUnit").element.options.selectedIndex)//        
    {
        alert(RESOURCE["boardwithprotectionunitisnotnull"]);
        return true;
    }
    if ("-1" == ct.getAtom("protectionUnit").element.options.selectedIndex)//    
    {
        alert(RESOURCE["protectionunitisnotnull"]);
        return true;
    }
    
    return false;
}

/**
 *             
 */
function createCreatePortProtectionXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neId");
    var neIdValue = win.neIdValue;
    param.setAttribute("value", neIdValue);//        ID    ID
    row.appendChild(param);
    
    param = new tagElement("param");
    
    param = new tagElement("param");
    param.setAttribute("name", "protectionType");
    var protectionTypeValue = ct.getAttrValue("protectionType");//      
    param.setAttribute("value", protectionTypeValue);
    row.appendChild(param);
    
    
    
    if (protectionTypeValue == win.protection.LINEPROTECTION)//     
    {
        lineProtectionXML(row);
    }
    else if (protectionTypeValue == win.protection.CLIENTPROTECTION)//   1+1  
    {
        clientProectionXML(row);
      
    }
    else//  1+1  
     {
        if (ct.getAttrValue("neWithWorkingUnit") == 0) 
        {
            boardProtectionXML(row);
        }
        else 
        {
            lineProtectionXML(row);
        }
    }
    param = new tagElement("param");
    param.setAttribute("name", "sdEnable");
    if (!ct.getAtom("sdTriggerFlag").element.disabled) 
    {
        var sdTriggerFlagValue = ct.getAttrValue("sdTriggerFlag");//      
        param.setAttribute("value", sdTriggerFlagValue);
        row.appendChild(param);
    }
    
    var ctrUnit = parseInt(ct.getAtom("neWithControlUnit").getValue());
    if (protectionTypeValue != win.protection.CLIENTPROTECTION || ctrUnit != OTHERDEVICE) 
    {
        param = new tagElement("param");
        param.setAttribute("name", "revertiveMode");
        var revertiveModeValue = ct.getAttrValue("revertiveMode");//      
        param.setAttribute("value", revertiveModeValue);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "wtrTime");
        var wtrTimeValue = ct.getAttrValue("wtrTime");//      
        wtrTimeValue = convertMMSStoS(wtrTimeValue == "-" ? "-" : wtrTimeValue);
        if (!ct.getAtom("wtrTime").element.disabled && isNaN(Number(wtrTimeValue))) 
        {
            ct.getAtom("wtrTime").element.select();
            alert(RESOURCE["wrong5"] + MINWTRTIME + RESOURCE["wrong2"] + MAXWTRTIME + RESOURCE["wrong4"]);
            return null;
        }
        param.setAttribute("value", revertiveModeValue == "0" ? "0" : wtrTimeValue);
        row.appendChild(param);
    }
    
 	var workingUnit = parseInt(ct.getAtom("neWithWorkingUnit").getValue());
	if (workingUnit != OTHERDEVICE)
	{
		 param = new tagElement("param");
	    param.setAttribute("name", "wdelaytime");
	    var workingUnitDelayTimeValue = ct.getAttrValue("workingUnitDelayTime");//          
	    if (isNaN(Number(workingUnitDelayTimeValue))) 
	    {
	        ct.getAtom("workingUnitDelayTime").element.select();
	        alert(RESOURCE["wrong1"] + MINDELAYTIME + RESOURCE["wrong2"] + MAXDELAYTIME + RESOURCE["wrong3"]);
	        return null;
	    }
	    param.setAttribute("value", workingUnitDelayTimeValue);
	    row.appendChild(param);
	}
   
    var protectionUnit = parseInt(ct.getAtom("neWithProtectionUnit").getValue());
	if (protectionUnit != OTHERDEVICE)
	{
		param = new tagElement("param");
	    param.setAttribute("name", "pdelaytime");
	    var protecionUnitDelayTimeValue = ct.getAttrValue("protectionUnitDelayTime");//          
	    if (isNaN(Number(protecionUnitDelayTimeValue))) 
	    {
	        ct.getAtom("protectionUnitDelayTime").element.select();
	        alert(RESOURCE["wrong1"] + MINDELAYTIME + RESOURCE["wrong2"] + MAXDELAYTIME + RESOURCE["wrong3"]);
	        return null;
	    }
	    param.setAttribute("value", protecionUnitDelayTimeValue);
	    row.appendChild(param);
	}
	
	var switchDectTime = ct.getAtom("switchDectTime").getValue();
    if (switchDectTime != "-")
    {
    	param = new tagElement("param");
        param.setAttribute("name", "switchDectTime");
        param.setAttribute("value", switchDectTime);
        row.appendChild(param);
    }
	
    if(isSupportSwitchTypeAndAPSFlag && protectionTypeValue == win.protection.BOARDPROTECTION)
    {
        var atom = ct.getAtom("switchType");
        if (!atom.element.disabled) 
        {
            var switchType = ct.getAtom("switchType").getValue();
    	    param = new tagElement("param");
            param.setAttribute("name", "switchType");
            param.setAttribute("value", switchType);
            row.appendChild(param);
			
            var apsChannel = ct.getAtom("apsChannel").getValue();
            if (apsChannel != "-") 
            {
                param = new tagElement("param");
                param.setAttribute("name", "apsChannel");
                param.setAttribute("value", apsChannel);
                row.appendChild(param);
            }
        }
    }
   
    if (workingUnit == OTHERDEVICE && protectionUnit == OTHERDEVICE && ctrUnit == OTHERDEVICE)
	{
		alert(RESOURCE["unitlimit"]);
		return null;
	}
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *        XML  
 */
function lineProtectionXML(row)
{
    var param = new tagElement("param");
    param.setAttribute("name", "wprotectionGroupUnit");
    var protectionGroupUnitValue = WROTECTGROUPUNIT;//    
    param.setAttribute("value", protectionGroupUnitValue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "pprotectionGroupUnit");//    
    protectionGroupUnitValue = PROTECTGROUPUNIT;
    param.setAttribute("value", protectionGroupUnitValue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "wneId");
    var neWithWorkingUnitValue = win.neIdValue;//        
    param.setAttribute("value", neWithWorkingUnitValue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "pneId");
    neWithProtectionUnitValue = win.neIdValue;//        
    param.setAttribute("value", neWithProtectionUnitValue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "wslotId");
    var key = ct.getAttrValue("boardWithWorkingUnit");
    var res = getUsableBoard(key);//      
    var slotIdValue = res.slotId;//  ID
    param.setAttribute("value", slotIdValue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "pslotId");
    key = ct.getAttrValue("boardWithProtectionUnit");
    res = getUsableBoard(key);//      
    slotIdValue = res.slotId;//  ID
    param.setAttribute("value", slotIdValue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "wboardType");
    var boardTypeValue = res.boardType;//  Id
    param.setAttribute("value", boardTypeValue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "pboardType");
    boardTypeValue = res.boardType;//  Id
    param.setAttribute("value", boardTypeValue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "wportId");
    var portIdValue = ct.getAttrValue("workingUnit");//  ID
    param.setAttribute("value", portIdValue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "pportId");
    portIdValue = ct.getAttrValue("protectionUnit");//  ID
    param.setAttribute("value", portIdValue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "wpathId");//  ID
    param.setAttribute("value", PATHID);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "ppathId");//  ID
    param.setAttribute("value", PATHID);
    row.appendChild(param);
}

/**
 *     1+1  XML  
 */
function boardProtectionXML(row)
{
    var param = new tagElement("param");
    param.setAttribute("name", "wprotectionGroupUnit");
    var protectGroupUnitValue = WROTECTGROUPUNIT;//           
    param.setAttribute("value", protectGroupUnitValue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "wneId");
    var neWithWorkingUnitValue = win.neIdValue;//        
    param.setAttribute("value", neWithWorkingUnitValue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "wslotId");
    var key = ct.getAttrValue("boardWithWorkingUnit");
    var res = getUsableBoard(key);//      
    var slotIdValue = res.slotId;//  ID
    param.setAttribute("value", slotIdValue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "wboardType");
    var boardTypeValue = res.boardType;//  Id
    param.setAttribute("value", boardTypeValue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "wportId");
    var portIdValue = ct.getAttrValue("workingUnit");//  ID
    param.setAttribute("value", portIdValue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "wpathId");
    param.setAttribute("value", PATHID);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "pprotectionGroupUnit");
    var protectGroupUnitValue = PROTECTGROUPUNIT;//           
    param.setAttribute("value", protectGroupUnitValue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "pneId");
    var neWithProtectionUnitValue = win.neIdValue;//          
    param.setAttribute("value", neWithProtectionUnitValue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "pslotId");
    slotIdValue = res.slotId;//  ID
    param.setAttribute("value", slotIdValue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "pboardType");
    var boardTypeValue = res.boardType;//    
    param.setAttribute("value", boardTypeValue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "pportId");
    portIdValue = ct.getAttrValue("protectionUnit");//  ID
    param.setAttribute("value", portIdValue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "ppathId");
    param.setAttribute("value", PATHID);
    row.appendChild(param);
    
    if (ct.getAttrValue("neWithControlUnit") == 1) 
    {
        var param = new tagElement("param");
        param.setAttribute("name", "dwprotectionGroupUnit");
        var protectGroupUnitValue = DROTECTGROUPUNIT;//           
        param.setAttribute("value", protectGroupUnitValue);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "dwneId");
        var neWithControlUnitValue = win.neIdValue;//        
        param.setAttribute("value", neWithControlUnitValue);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "dwslotId");
        var key = ct.getAttrValue("boardWithControlUnit");
        var res = getUsableBoard(key);//      
        var slotIdValue = res.slotId;//  ID
        param.setAttribute("value", slotIdValue);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "dwboardType");
        var boardTypeValue = res.boardType;//  Id
        param.setAttribute("value", boardTypeValue);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "dwportId");
        var portIdValue = ct.getAttrValue("controlUnitWorkingPath");//  ID
        param.setAttribute("value", portIdValue);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "dwpathId");
        param.setAttribute("value", PATHID);
        row.appendChild(param);
    }
}

function clientProectionXML(row)
{
	if (ct.getAttrValue("neWithWorkingUnit") == 0) 
	{
		var param = new tagElement("param");
	    param.setAttribute("name", "wprotectionGroupUnit");
	    var protectGroupUnitValue = WROTECTGROUPUNIT;//           
	    param.setAttribute("value", protectGroupUnitValue);
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name", "wneId");
	    var neWithWorkingUnitValue = win.neIdValue;//        
	    param.setAttribute("value", neWithWorkingUnitValue);
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name", "wslotId");
	    var key = ct.getAttrValue("boardWithWorkingUnit");
	    var res = getUsableBoard(key);//      
	    var slotIdValue = res.slotId;//  ID
	    param.setAttribute("value", slotIdValue);
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name", "wboardType");
	    var boardTypeValue = res.boardType;//  Id
	    param.setAttribute("value", boardTypeValue);
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name", "wportId");
	    var portIdValue = ct.getAttrValue("workingUnit");//  ID
	    param.setAttribute("value", portIdValue);
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name", "wpathId");
	    param.setAttribute("value", PATHID);
	    row.appendChild(param);
	}
	else
	{
		createWorkingUnitOTHERDEVICEXml(row, WROTECTGROUPUNIT);
	}
   
	if (ct.getAttrValue("neWithProtectionUnit") == 0)
    {
		param = new tagElement("param");
	    param.setAttribute("name", "pprotectionGroupUnit");
	    var protectGroupUnitValue = PROTECTGROUPUNIT;//           
	    param.setAttribute("value", protectGroupUnitValue);
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name", "pneId");
	    var neWithProtectionUnitValue = win.neIdValue;//          
	    param.setAttribute("value", neWithProtectionUnitValue);
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name", "pslotId");
	    var key = ct.getAttrValue("boardWithProtectionUnit");
	    var res = getUsableBoard(key);//      
	    slotIdValue = res.slotId;//  ID
	    param.setAttribute("value", slotIdValue);
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name", "pboardType");
	    var boardTypeValue = res.boardType;//    
	    param.setAttribute("value", boardTypeValue);
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name", "pportId");
	    portIdValue = ct.getAttrValue("protectionUnit");//  ID
	    param.setAttribute("value", portIdValue);
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name", "ppathId");
	    param.setAttribute("value", PATHID);
	    row.appendChild(param);
	}
	else
	{
		createProtectionUnitOTHERDEVICEXml(row, PROTECTGROUPUNIT);
	}
    
    if (ct.getAttrValue("neWithControlUnit") == 1) 
    {
        var param = new tagElement("param");
        param.setAttribute("name", "cwprotectionGroupUnit");
        var protectGroupUnitValue = CROTECTGROUPUNIT;//           
        param.setAttribute("value", protectGroupUnitValue);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "cwneId");
        var neWithControlUnitValue = win.neIdValue;//        
        param.setAttribute("value", neWithControlUnitValue);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "cwslotId");
        var key = ct.getAttrValue("boardWithControlUnit");
        var res = getUsableBoard(key);//      
        var slotIdValue = res.slotId;//  ID
        param.setAttribute("value", slotIdValue);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "cwboardType");
        var boardTypeValue = res.boardType;//  Id
        param.setAttribute("value", boardTypeValue);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "cwportId");
        var portIdValue = ct.getAttrValue("controlUnitWorkingPath");//  ID
        param.setAttribute("value", portIdValue);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "cwpathId");
        param.setAttribute("value", PATHID);
        row.appendChild(param);
    }
    else if (ct.getAttrValue("neWithControlUnit") == OTHERDEVICE) 
    {
        var param = new tagElement("param");
        param.setAttribute("name", "cwprotectionGroupUnit");
        var protectGroupUnitValue = CROTECTGROUPUNIT;//           
        param.setAttribute("value", protectGroupUnitValue);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "cwneId");
        param.setAttribute("value", OTHERDEVICE);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "cwslotId");
        param.setAttribute("value", "1");
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "cwboardType");
        param.setAttribute("value", "944");
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "cwportId");
        param.setAttribute("value", "1");
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "cwpathId");
        param.setAttribute("value", PATHID);
        row.appendChild(param);
    }
}

/**
 *           
 * @param {Object} row
 * @param {Object} unitType
 */
function createProtectionUnitOTHERDEVICEXml(row, unitType)
{
	var param = new tagElement("param");
    param.setAttribute("name",  "pprotectionGroupUnit");
    param.setAttribute("value", unitType);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "pneId");
    param.setAttribute("value", OTHERDEVICE);
    row.appendChild(param);
    
	var pslotIdParam = new tagElement("param");
    pslotIdParam.setAttribute("name", "pslotId");
    
	var pboardTypeParam = new tagElement("param");
    pboardTypeParam.setAttribute("name", "pboardType");
	
	var pportIdParam = new tagElement("param");
    pportIdParam.setAttribute("name", "pportId");
	if (ct.getAttrValue("neWithWorkingUnit") == 0)
	{
		var key = ct.getAttrValue("boardWithWorkingUnit");
        var res = getUsableBoard(key);//      
        var slotIdValue = res.slotId;//  ID
        var boardTypeValue = res.boardType;//  Id 
        var portIdValue = ct.getAttrValue("workingUnit");//  ID
		pslotIdParam.setAttribute("value", slotIdValue);
		pboardTypeParam.setAttribute("value", boardTypeValue);
		pportIdParam.setAttribute("value", portIdValue);
	}
	else
	{
		pslotIdParam.setAttribute("value", "201");
		pboardTypeParam.setAttribute("value", "922");
		pportIdParam.setAttribute("value", "3");
	}
    
    row.appendChild(pslotIdParam);
    row.appendChild(pboardTypeParam);
	row.appendChild(pportIdParam);
    
    param = new tagElement("param");
    param.setAttribute("name", "ppathId");
    param.setAttribute("value", "1");
    row.appendChild(param);
}

function createWorkingUnitOTHERDEVICEXml(row, unitType)
{
	var param = new tagElement("param");
    param.setAttribute("name",  "wprotectionGroupUnit");
    param.setAttribute("value", unitType);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "wneId");
    param.setAttribute("value", OTHERDEVICE);
    row.appendChild(param);
    
    var wslotIdParam = new tagElement("param");
    wslotIdParam.setAttribute("name", "wslotId");
    
	var wboardTypeParam = new tagElement("param");
    wboardTypeParam.setAttribute("name", "wboardType");
	
	var wportIdParam = new tagElement("param");
    wportIdParam.setAttribute("name", "wportId");
	if (ct.getAttrValue("neWithProtectionUnit") == 0)
	{
		var key = ct.getAttrValue("boardWithProtectionUnit");
        var res = getUsableBoard(key);//      
        var slotIdValue = res.slotId;//  ID
        var boardTypeValue = res.boardType;//  Id 
        var portIdValue = ct.getAttrValue("protectionUnit");//  ID
		wslotIdParam.setAttribute("value", slotIdValue);
		wboardTypeParam.setAttribute("value", boardTypeValue);
		wportIdParam.setAttribute("value", portIdValue);
	}
	else
	{
		wslotIdParam.setAttribute("value", "1");
		wboardTypeParam.setAttribute("value", "922");
		wportIdParam.setAttribute("value", "3");
	}
	row.appendChild(wslotIdParam);
    row.appendChild(wboardTypeParam);
	row.appendChild(wportIdParam);
    
    param = new tagElement("param");
    param.setAttribute("name", "wpathId");
    param.setAttribute("value", "1");
    row.appendChild(param);
}

/**
 *          
 */
function openCreateErrDialog(doc)
{
    var dinterface = EncapsulateData(doc);
    showErrorDialog(dinterface);
    
    $("okBtn").disabled = false;
    $("cancelBtn").disabled = false;
    $("applyBtn").disabled = false;
    if (0 == dinterface.getSErrorCode() || 1 == dinterface.getSErrorCode()) 
    {
        isSuccess = true;
        win.refresh();
        if (applyFlag) 
        {
            initData();
        }
    }
    else 
    {
        isSuccess = false;
    }
}

/**
 *        
 */
function showErrorDialog(dinterface)
{
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../page/", dinterface.getError(), errArr);
}

function linkageControl(l1, l2)
{
    var flag = false; //       	    
    var t1 = ct.getAtom(l1); //  l1  
    var t2 = ct.getAtom(l2); //  l2  			
    if (t1.element.options.selectedIndex == -1) 
    {
        linkageControl(l2, l1); //    linkageControl  
    }
    else 
    {
        var port1 = t1.element.options[t1.element.options.selectedIndex].value;
        for (var i = 0; i < t2.element.options.length; i++) 
        {
            var port2 = t2.element.options[i].value;
            if (port2 != port1) 
            {
                if ((parseInt(port2) % 2) == (parseInt(port1) % 2)) 
                {
                    t2.element.options.selectedIndex = i;
                    flag = true;
                    break;
                }
            }
        }
    }
    if (!flag) 
    {
        t2.element.options.selectedIndex = -1;
    }
}


function linkageDCP(l1, l2)
{
    var flag = false; //       	    
    var t1 = ct.getAtom(l1); //  l1  
    var t2 = ct.getAtom(l2); //  l2  			
    if (t1.element.options.selectedIndex == -1) 
    {
        linkageDCP(l2, l1); //    linkageDCP  
    }
    else 
    {
        var port1 = t1.element.options[t1.element.options.selectedIndex].value;
        for (var i = 0; i < t2.element.options.length; i++) 
        {
            var port2 = t2.element.options[i].value;
            if ((3 == parseInt(port1) + parseInt(port2)) || (7 == parseInt(port1) + parseInt(port2))) 
            {
                t2.element.options.selectedIndex = i;
                flag = true;
                break;
            }
        }
    }
    if (!flag) 
    {
        t2.element.options.selectedIndex = -1;
    }
}


/*
 *         
 */
function hasDetectRes()
{
    for (var i = 0, len = usableBoardArr.length; i < len; i++) 
    {
        if ("boarddetect" == usableBoardArr[i].protectionType) 
        {
            return true;
        }
    }
    return false;
}

function hasPortForControlUnit(usableBoard)
{
    var count = 0;
    if ("DCP" == usableBoard.boardName || "12DCP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_DCP_SPECIALOP") ) 
    {
        if (("1" == getPortID(usableBoard.portName)) || ("3" == getPortID(usableBoard.portName))) 
        {
            count++;
        }
        for (var i = 0, len1 = usableBoard.portArr.length; i < len1; i++) 
        {
            if (("1" == getPortID(usableBoard.portArr[i])) || ("3" == getPortID(usableBoard.portArr[i]))) 
            {
                count++;
            }
        }
    }
    else if ("OLP" == usableBoard.boardName || "12OLP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_OLP_SPECIALOP")) 
    {
        if ("1" == getPortID(usableBoard.portName)) 
        {
            count++;
        }
        for (var i = 0, len1 = usableBoard.portArr.length; i < len1; i++) 
        {
            if ("1" == getPortID(usableBoard.portArr[i])) 
            {
                count++;
            }
        }
    }
    else 
    {
        count = usableBoard.portArr.length;
        if (null != usableBoard.portName) 
        {
            ++count;
        }
    }
    if (count == 0) 
    {
        return false;
    }
    return true;
}


function hasPortForWorkingUnit(usableBoard)
{
    var count = 0;
    if ("OLP" == usableBoard.boardName || "12OLP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_OLP_SPECIALOP")) 
    {
        if ("1" == getPortID(usableBoard.portName)) 
        {
            count++;
        }
    }
    else 
    {
        if ("DCP" == usableBoard.boardName || "12DCP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_DCP_SPECIALOP")) 
        {
            if ("1" == getPortID(usableBoard.portName) || "3" == getPortID(usableBoard.portName)) 
            {
                count++;
            }
        }
        else 
        {
            if ("1" == getPortID(usableBoard.portName)) 
            {
                count++;
            }
            else 
            {
                count++;
            }
        }
    }
    
    for (var i = 0, len1 = usableBoard.portArr.length; i < len1; i++) 
    {
        if ("OLP" == usableBoard.boardName || "12OLP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_OLP_SPECIALOP")) 
        {
            if ("1" == getPortID(usableBoard.portArr[i])) 
            {
                count++;
            }
        }
        else 
        {
            if ("DCP" == usableBoard.boardName || "12DCP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_DCP_SPECIALOP")) 
            {
                if ("1" == getPortID(usableBoard.portArr[i]) || "3" == getPortID(usableBoard.portArr[i])) 
                {
                    count++;
                }
            }
            else 
            {
                if ("1" == getPortID(usableBoard.portArr[i])) 
                {
                    count++;
                }
                else 
                {
                    count++;
                }
            }
        }
    }
    if (count == 0) 
    {
        return false;
    }
    return true;
}

function hasPortForWorkingUnitClient(usableBoard)
{
    var count = 0;
    if ("OLP" == usableBoard.boardName || "12OLP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_OLP_SPECIALOP")) 
    {
        if ("1" == getPortID(usableBoard.portName)) 
        {
            count++;
        }
    }
    else 
    {
        if ("DCP" == usableBoard.boardName || "12DCP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_DCP_SPECIALOP")) 
        {
            if ("1" == getPortID(usableBoard.portName) || "3" == getPortID(usableBoard.portName)) 
            {
                count++;
            }
        }
        else 
        {
            count++;
        }
    }
    
    for (var i = 0, len1 = usableBoard.portArr.length; i < len1; i++) 
    {
        if ("OLP" == usableBoard.boardName || "12OLP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_OLP_SPECIALOP")) 
        {
            if ("1" == getPortID(usableBoard.portArr[i])) 
            {
                count++;
            }
        }
        else 
        {
            if ("DCP" == usableBoard.boardName || "12DCP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_DCP_SPECIALOP")) 
            {
                if ("1" == getPortID(usableBoard.portArr[i]) || "3" == getPortID(usableBoard.portArr[i])) 
                {
                    count++;
                }
            }
            else 
            {
                count++;
            }
        }
    }
    if (count == 0) 
    {
        return false;
    }
    return true;
}

function hasPortForProtectionUnit(usableBoard)
{
    var count = 0;
    if ("OLP" == usableBoard.boardName || "12OLP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_OLP_SPECIALOP")) 
    {
        if ("2" == getPortID(usableBoard.portName)) 
        {
            count++;
        }
    }
    else 
    {
        if ("DCP" == usableBoard.boardName || "12DCP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_DCP_SPECIALOP")) 
        {
            if ("2" == getPortID(usableBoard.portName) || "4" == getPortID(usableBoard.portName)) 
            {
                count++;
            }
        }
        else 
        {
            if ("2" == getPortID(usableBoard.portName)) 
            {
                count++;
            }
            else 
            {
                count++;
            }
        }
    }
    for (var i = 0, len1 = usableBoard.portArr.length; i < len1; i++) 
    {
        if ("OLP" == usableBoard.boardName || "12OLP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_OLP_SPECIALOP")) 
        {
            if ("2" == getPortID(usableBoard.portArr[i])) 
            {
                count++;
            }
        }
        else 
        {
            if ("DCP" == usableBoard.boardName || "12DCP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_DCP_SPECIALOP")) 
            {
                if ("2" == getPortID(usableBoard.portArr[i]) || "4" == getPortID(usableBoard.portArr[i])) 
                {
                    count++;
                }
            }
            else 
            {
                if ("2" == getPortID(usableBoard.portArr[i])) 
                {
                    count++;
                }
                else 
                {
                    count++;
                }
            }
        }
    }
    if (count == 0) 
    {
        return false;
    }
    return true;
}


function hasPortForProtectionUnitClient(usableBoard)
{
    var count = 0;
    if ("OLP" == usableBoard.boardName || "12OLP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_OLP_SPECIALOP")) 
    {
        if ("2" == getPortID(usableBoard.portName)) 
        {
            count++;
        }
    }
    else 
    {
        if ("DCP" == usableBoard.boardName || "12DCP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_DCP_SPECIALOP")) 
        {
            if ("2" == getPortID(usableBoard.portName) || "4" == getPortID(usableBoard.portName)) 
            {
                count++;
            }
        }
        else 
        {
            count++;
        }
    }
    for (var i = 0, len1 = usableBoard.portArr.length; i < len1; i++) 
    {
        if ("OLP" == usableBoard.boardName || "12OLP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_OLP_SPECIALOP")) 
        {
            if ("2" == getPortID(usableBoard.portArr[i])) 
            {
                count++;
            }
        }
        else 
        {
            if ("DCP" == usableBoard.boardName || "12DCP" == usableBoard.boardName || SpecialAttrMgr.isCPSupportByType(win.neIdValue,usableBoard.boardType,"TE_FUNC_CFG_WDM_OPPG","OTN_ATTR_SUPPORT_DCP_SPECIALOP")) 
            {
                if ("2" == getPortID(usableBoard.portArr[i]) || "4" == getPortID(usableBoard.portArr[i])) 
                {
                    count++;
                }
            }
            else 
            {
                count++;
            }
        }
    }
    if (count == 0) 
    {
        return false;
    }
    return true;
}
