var submitflag = false;
var win = getParentWindow();
var obj=parseURLStr(self);
function getNEID()
{
    return obj["neid"];
}
var ct;
var srcFreq = [];
var srcWidth = [];
var snkFreq = [];
var snkWidth = [];
var CWidth = 50000;

var waveCenterFreq = [];
function init()
{
	ct = new CTable();
	ct.addHead(RESOURCE["attribute"],RESOURCE["attrValue"]);

	var atom = new Atom("select");
	atom.element.onchange = function()
	{
		refreshBoard(this);
	};
	atom.element.style.width="100%";
	ct.addAttrRow("srcboard", RESOURCE["srcboard"], atom);
	

	atom = new Atom("select");
	atom.element.style.width="100%";
	atom.element.onchange = cleareWaveLengthNo;
	ct.addAttrRow("srcport", RESOURCE["srcport"], atom);

	atom = new Atom("select");
	atom.element.onchange = function()
	{
		refreshSrcBand();
	};
	atom.element.style.width="100%";
	ct.addAttrRow("srcband", RESOURCE["srcband"], atom);

	atom = new Atom("text");
	atom.setValue("");
	atom.element.disabled = "disabled";
	atom.element.style.width="87%";
	ct.addAttrRow("srcwavelengthno", RESOURCE["srcwavelengthno"], atom);
	var btn = document.createElement("input");
	btn.setAttribute("type", "button");
	btn.setAttribute("id", "srcwavelength");
	btn.setAttribute("width", "13%");
	btn.onclick = function()
	{
	   setWaveLengthNo(0);
	};
	ct.getAtom("srcwavelengthno").element.parentNode.appendChild(btn);
	
	atom = new Atom("text");
	atom.setValue("");
	atom.element.disabled = "disabled";
	atom.element.style.width="87%";
	ct.addAttrRow("srcwavelengthgrid", RESOURCE["srcwavelengthgrid"], atom);
	var btn = document.createElement("input");
	btn.setAttribute("type", "button");
	btn.setAttribute("id", "srcwavelength");
	btn.setAttribute("width", "13%");
	btn.onclick = function()
	{
	   var tmpstr = getSelectedFreqWidth(0);
	   xshowModalDialog("wavelengthselectdialog.html?type=0&selectMode=1&selectedWaveLen="+tmpstr, RESOURCE["selectwavelength"], 820,600,"../../../../../images");
	};
	ct.getAtom("srcwavelengthgrid").element.parentNode.appendChild(btn);
	

	atom = new Atom("select");
	atom.element.onchange = function()
	{
		refreshBoard(this);
	};
	atom.element.style.width="100%";
	ct.addAttrRow("snkboard", RESOURCE["snkboard"], atom);
	

	atom = new Atom("select");
	atom.element.style.width="100%";
	atom.element.onchange = cleareWaveLengthNo;
	ct.addAttrRow("snkport", RESOURCE["snkport"], atom);

	atom = new Atom("select");
	atom.element.onchange = function()
	{
		refreshSnkBand();
	};
	atom.element.style.width="100%";
	ct.addAttrRow("snkband", RESOURCE["snkband"], atom);

	atom = new Atom("text");
	atom.setValue("");
	atom.element.disabled = "disabled";
	atom.element.style.width="87%";
	ct.addAttrRow("snkwavelengthno", RESOURCE["snkwavelengthno"], atom);
	btn = document.createElement("input");
	btn.setAttribute("type", "button");
	btn.setAttribute("id", "snkwavelength");
	btn.setAttribute("width", "13%");
	btn.onclick = function()
	{
	   setWaveLengthNo(1);
	};
	ct.getAtom("snkwavelengthno").element.parentNode.appendChild(btn);
	
	atom = new Atom("text");
	atom.setValue("");
	atom.element.disabled = "disabled";
	atom.element.style.width="87%";
	ct.addAttrRow("snkwavelengthgrid", RESOURCE["snkwavelengthgrid"], atom);
	btn = document.createElement("input");
	btn.setAttribute("type", "button");
	btn.setAttribute("id", "snkwavelength");
	btn.setAttribute("width", "13%");
	btn.onclick = function()
	{
	   var tmpstr = getSelectedFreqWidth(1);
	   xshowModalDialog("wavelengthselectdialog.html?type=1&selectMode=1&selectedWaveLen="+tmpstr, RESOURCE["selectwavelength"], 800,600,"../../../../../images");
	};
	ct.getAtom("snkwavelengthgrid").element.parentNode.appendChild(btn);
	
	document.body.insertBefore(ct.getTable(), document.body.firstChild);
    getwaveLength();
}

function getSelectedFreqWidth(flag)
{
	var tmpStr = "";
	if (flag == 0)
	{
		for (var i=0,len = srcFreq.length;i<len;i++)
		{
			tmpStr += srcFreq[i] + "|" + srcWidth[i];
			if (i != len -1)
			{
				tmpStr += ";";
			}
		}		
	}
	else
	{
		for (var i=0,len = snkFreq.length;i<len;i++)
		{
			tmpStr += snkFreq[i] + "|" + snkWidth[i];
			if (i != len -1)
			{
				tmpStr += ";";
			}
		}
	}
	return tmpStr;
}

function setWaveLengthNo(flag)
{
   var board = -1;
   var port = -1;
   var band = -1;
   var wave = -1;
   var boardNo;
   if (flag == 0)
   {
   	  var srcBoardSelect = ct.getAtom("srcboard").element;
      board = srcBoardSelect.options[srcBoardSelect.selectedIndex].value;
      boardNo = srcBoardSelect.outerText;
      var srcPortSelect = ct.getAtom("srcport").element;
      port = srcPortSelect.options[srcPortSelect.selectedIndex].value;
      var srcBandSelect = ct.getAtom("srcband").element;
      band = srcBandSelect.options[srcBandSelect.selectedIndex].value;
      wave = ct.getAtom("srcwavelengthno").element.value;
   }
   else if (flag == 1)
   {
      var snkBoardSelect = ct.getAtom("snkboard").element;
      board = snkBoardSelect.options[snkBoardSelect.selectedIndex].value;
      boardNo = snkBoardSelect.options[snkBoardSelect.selectedIndex].innerText;
      var snkPortSelect = ct.getAtom("snkport").element;
      port = snkPortSelect.options[snkPortSelect.selectedIndex].value;
      var snkBandSelect = ct.getAtom("snkband").element;
      band = snkBandSelect.options[snkBandSelect.selectedIndex].value;
      wave = ct.getAtom("snkwavelengthno").element.value;
   }

   var windowFeature = "dialogHeight:340px;dialogWidth:440px;center:yes;help:no;resizable:Yes;status:No;";
   var url = "../oxc/getwaveLenInfo.html?oxcflag=0&flag=" + flag + "&neid=" + obj["neid"] + "&board=" + board + "&boardNo=" + "" + "&port=" + port + "&band=" + band + "&wave=" + wave;
   if(port != "" && band != ""){
   	showModalDialog(url, window, windowFeature);
   }
}

function getwaveLength()
{
	var root = new inputxml("datainterface");  // Create the root of a xml file
    var firstlevel = new tagElement("bussiness-params");
    var secondlevel = new tagElement("row-params");
      
    var thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","neid");
    thirdlevel.setAttribute("value",getNEID());
    secondlevel.appendChild(thirdlevel); 
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","band");
    thirdlevel.setAttribute("value","1");
    secondlevel.appendChild(thirdlevel); 
    
    firstlevel.appendChild(secondlevel);
    root.getRoot().appendChild(firstlevel);
    loadXMLdoc("../../../../neExlorerServlet?sfid="+TECMDCODE_GET_WAVECENTERFREQ+"&flag=0","POST",true,handlewaveLength,null,"inputdata="+root.toString());
}

function handlewaveLength(doc)
{
	waveCenterFreq.length = 0;
	 var data = EncapsulateData(doc);
	 for (var i=0,len = data.getDataRowLength();i<len;i++)
	 {
	 	var wave = new TEWaveLength();
	 	wave.waveNo = data.getDataRowParam(i,"waveNO");
	 	wave.centerfreq = data.getDataRowParam(i,"centerFreq");
	 	waveCenterFreq[waveCenterFreq.length] = wave;
	 }
}

function getWaveFreq(waveNo)
{
	for (var i=0,len =waveCenterFreq.length;i<len;i++)
	{
		if (waveCenterFreq[i].waveNo == waveNo)
		{
			return waveCenterFreq[i].centerfreq;
		}
	}
	return 0;
}

function refreshBoard(object)
{
    var root = new inputxml("datainterface");  // Create the root of a xml file
    var firstlevel = new tagElement("bussiness-params");
    var secondlevel = new tagElement("row-params");
      
    var thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","neid");
    thirdlevel.setAttribute("value",getNEID());
    secondlevel.appendChild(thirdlevel); 
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","slotid");
    thirdlevel.setAttribute("value",object.options[object.selectedIndex].value);
    secondlevel.appendChild(thirdlevel);
    
    firstlevel.appendChild(secondlevel);
    root.getRoot().appendChild(firstlevel);
    loadXMLdoc("../../../../neExlorerServlet?sfid="+TECMDCODE_NAWDM_EDGEPOINT_QUERY+"&flag=0","POST",true,handlelinkage,null,"inputdata="+root.toString());
}

function handlelinkage(doc)
{
    var data = EncapsulateData(doc);
    var slotId = data.getDataRowParam(0, "slotid");
    var srcBoardSelect = ct.getAtom("srcboard").element;
	var snkBoardSelect = ct.getAtom("snkboard").element;
	if (srcBoardSelect.options[srcBoardSelect.selectedIndex].value == slotId)
	{
		for (var nn = 0; nn < snkBoardSelect.length; nn++)
		{
			if (snkBoardSelect.options[nn].value == slotId)
			{
				snkBoardSelect.options[nn].selected = true;
			}
		}
	}
	else
	{
		for (var nn = 0; nn < srcBoardSelect.length; nn++)
		{
			if (srcBoardSelect.options[nn].value == slotId)
			{
				srcBoardSelect.options[nn].selected = true;
			}
		}
	}

    var srcPortSelect = ct.getAtom("srcport").element;
    for (var jj = srcPortSelect.options.length; jj >= 0; jj--)
    {
    	srcPortSelect.options.remove(jj);
    }
    var srcPort = data.getDataRowParam(0, "srcport");
    if (srcPort != null && srcPort != "")
    {
        var srcPortId = srcPort.substring(0, srcPort.indexOf("("));
        srcPortSelect.options[srcPortSelect.options.length] = new Option(srcPort, srcPortId);
        var srcPortOptions = data.getDataRowOptions(0, "srcport");
        if (srcPortOptions)
        {
        	for (var j = 0; j < srcPortOptions.length; j++)
        	{
        		srcPort = srcPortOptions[j];
        		srcPortId = srcPort.substring(0, srcPort.indexOf("("));
        		srcPortSelect.options[srcPortSelect.options.length] = new Option(srcPort, srcPortId);
        	}
        }
    }

    var srcBandSelect = ct.getAtom("srcband").element;
    for (var kk = srcBandSelect.options.length - 1; kk >= 0; kk--)
    {
        srcBandSelect.options.remove(kk);
    }
    var srcBandId = parseInt(data.getDataRowParam(0, "srcband"));
    if (srcBandId > 0)
    {       
       var srcBandName = getBandName(srcBandId);
       srcBandSelect.options[srcBandSelect.options.length] = new Option(srcBandName,srcBandId);
           
       var srcBandOptions = data.getDataRowOptions(0, "srcband");
       if (srcBandOptions)
       {
          for (var k = 0; k < srcBandOptions.length; k++)
          {
           	  srcBandId = parseInt(srcBandOptions[k]);
           	  srcBandName = getBandName(srcBandId);
           	  srcBandSelect.options[srcBandSelect.options.length] = new Option(srcBandName, srcBandId);
          }
       } 
    }

    var snkPortSelect = ct.getAtom("snkport").element;
    for (var mm = snkPortSelect.options.length; mm >= 0; mm--)
    {
    	snkPortSelect.options.remove(mm);
    }
    var snkPort = data.getDataRowParam(0, "snkport");
    if (snkPort != null && snkPort != "")
    {
        var snkPortId = snkPort.substring(0, snkPort.indexOf("("));
        snkPortSelect.options[snkPortSelect.options.length] = new Option(snkPort, snkPortId);
        var snkPortOptions = data.getDataRowOptions(0, "snkport");
        if (snkPortOptions)
        {
        	for (var m = 0; m < snkPortOptions.length; m++)
        	{
        	    snkPort = snkPortOptions[m];
        	    snkPortId = snkPort.substring(0, snkPort.indexOf("("));
        		snkPortSelect.options[snkPortSelect.options.length] = new Option(snkPort, snkPortId);
        	}
        }
    }

    var snkBandSelect = ct.getAtom("snkband").element;
    for (var nn = snkBandSelect.options.length - 1; nn >= 0; nn--)
    {
        snkBandSelect.options.remove(nn);
    }
    var snkBandId = parseInt(data.getDataRowParam(0, "snkband"));
    if (snkBandId > 0)
    {
       var snkBandName = getBandName(snkBandId);
       snkBandSelect.options[snkBandSelect.options.length] = new Option(snkBandName, snkBandId);
       var snkBandOptions = data.getDataRowOptions(0, "snkband");
       if (snkBandOptions)
       {
          for(var n = 0; n < snkBandOptions.length; n++)
          {
              snkBandId = parseInt(snkBandOptions[n]);
              snkBandName = getBandName(snkBandId);
              snkBandSelect.options[snkBandSelect.options.length] = new Option(snkBandName, snkBandId);
          }
       }
    }
    cleareWaveLengthNo();  
}

function setCenterFreqAndWidth(slt2value)
{
   srcFreq.length = 0;
   srcWidth.length = 0;
   snkFreq.length = 0;
   snkWidth.length = 0;
   var waveStr = "";
   if (slt2value.options.length > 0)
   {   
      for (var i = 0; i < slt2value.options.length; i++)
      {
      	  var tmp = parseInt(slt2value.options[i].value);
      	  var freq = getWaveFreq(tmp);
      	  srcFreq[srcFreq.length] = freq * 1000;
      	  srcWidth[srcWidth.length] = CWidth;
      	  snkFreq[snkFreq.length] = freq * 1000;
      	  snkWidth[snkWidth.length] = CWidth;
      	  waveStr += getWaveNOtips(tmp,freq);
      	  if (i != slt2value.options.length -1)
      	  {
      	  	waveStr += ";";
      	  }
      }
   } 
   ct.getAtom("srcwavelengthgrid").setValue(waveStr);
   ct.getAtom("snkwavelengthgrid").setValue(waveStr);
     
}

function getWaveNOtips(waveNo,freq)
{
	tip = "C/" + waveNo + "/" + (freq / 1000).toFixed(3) + "THz";
	return tip;
}

function checkSubmit()
{
	var srcBoardSelect = ct.getAtom("srcboard").element;
	var snkBoardSelect = ct.getAtom("snkboard").element;
	if (srcBoardSelect.selectedIndex != -1 && snkBoardSelect.selectedIndex != -1)
	{
	   var srcPortSelect = ct.getAtom("srcport").element;
	   var snkPortSelect = ct.getAtom("snkport").element;
	   if (srcPortSelect.selectedIndex != -1 && snkPortSelect.selectedIndex != -1)
	   {
	      var srcBandSelect = ct.getAtom("srcband").element;
	      var snkBandSelect = ct.getAtom("snkband").element;
	      if (srcBandSelect.options[srcBandSelect.selectedIndex].value 
	           == snkBandSelect.options[snkBandSelect.selectedIndex].value)
	      {
	         var srcWaveLengthNo = ct.getAtom("srcwavelengthno").element;
	         var snkWaveLengthNo = ct.getAtom("snkwavelengthno").element;
	         if (srcWaveLengthNo.value != "" && snkWaveLengthNo.value != "")
	         {
	         	var srcWavelengthes = srcWaveLengthNo.value.split(",");
	         	var snkWavelengthes = snkWaveLengthNo.value.split(",");
	         	var count = 0;
	         	if (srcWavelengthes.length == snkWavelengthes.length)
	         	{
	         		for (var ii = 0; ii < srcWavelengthes.length; ii++)
	         		{
	         			for (var jj = 0; jj < snkWavelengthes.length; jj++)
	         			{
	         			    if (srcWavelengthes[ii] == snkWavelengthes[jj])
	         			    {
	         			    	count ++;
	         			    	break;
	         			    }
	         			}
	         		}
	         		if (count == srcWavelengthes.length)
	         		{
	         			return true;
	         		}
	         		else
	         		{
	         		    alert(RESOURCE["wavenotconsistent"]);
	         			return false;

 		     }
	         	}
	         	else
	         	{
	         		alert(RESOURCE["wavenotconsistent"]);
	         		return false;
	         	}
	         }
	         else
	         {
	         	if (srcFreq.length == 0 || srcWidth.length == 0 || snkFreq.length == 0 || snkWidth.length == 0)
	         	{
	         		alert(RESOURCE["wavenotnull"]);
	         	    return false;
	         	}
	         	else
	         	{	         
	         		return true;
	         	}
	         }
	      }
	      else
	      {
	      	 alert(RESOURCE["bandnotconsistent"]);
	      	 return false;
	      }
	   }
	   else
	   {
	      alert(RESOURCE["bandnotnull"]);
	      return false;
	   }
	}
	else
	{
	   alert(RESOURCE["soltnotnull"]);
	   return false;
	}
}
function clearData(object){
	object.length = 0;
}


function createXML()
{
   if (checkSubmit())
   {
      var root = new inputxml("datainterface");  // Create the root of a xml file
      var firstlevel = new tagElement("bussiness-params");
      
      var waveLengthNo = ct.getAtom("srcwavelengthno").element;
      for (var i=0,len = srcFreq.length;i<len;i++)
      {
      	    var secondlevel = new tagElement("row-params");
	      
            var thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name","neid");
            thirdlevel.setAttribute("value",getNEID());
            secondlevel.appendChild(thirdlevel);

            var srcboard = ct.getAtom("srcboard").element;
            thirdlevel = new tagElement("param");
   			thirdlevel.setAttribute("name","srcslot");
   			thirdlevel.setAttribute("value",srcboard.options[srcboard.selectedIndex].value);
   			secondlevel.appendChild(thirdlevel);
            
  			var srcport = ct.getAtom("srcport").element;
   			thirdlevel = new tagElement("param");
   			thirdlevel.setAttribute("name","srcport");
   			thirdlevel.setAttribute("value",srcport.options[srcport.selectedIndex].value);
   			secondlevel.appendChild(thirdlevel);
            
			var srcband = ct.getAtom("srcband").element;
   			thirdlevel = new tagElement("param");
   			thirdlevel.setAttribute("name","srcband");
   			thirdlevel.setAttribute("value",srcband.options[srcband.selectedIndex].value);
   			secondlevel.appendChild(thirdlevel);
   			    
   			thirdlevel = new tagElement("param");
   			thirdlevel.setAttribute("name","srcCenterFreq");
   			thirdlevel.setAttribute("value",srcFreq[i]);
   			secondlevel.appendChild(thirdlevel);
   			
   			thirdlevel = new tagElement("param");
   			thirdlevel.setAttribute("name","srcBandWidth");
   			thirdlevel.setAttribute("value",srcWidth[i]);
   			secondlevel.appendChild(thirdlevel);

            var snkboard = ct.getAtom("snkboard").element;
            thirdlevel = new tagElement("param");
   			thirdlevel.setAttribute("name","snkslot");
   			thirdlevel.setAttribute("value",snkboard.options[snkboard.selectedIndex].value);
   			secondlevel.appendChild(thirdlevel);
            
  			var snkport = ct.getAtom("snkport").element;
   			thirdlevel = new tagElement("param");
   			thirdlevel.setAttribute("name","snkport");
   			thirdlevel.setAttribute("value",snkport.options[snkport.selectedIndex].value);
   			secondlevel.appendChild(thirdlevel);
            
			var snkband = ct.getAtom("snkband").element;
   			thirdlevel = new tagElement("param");
   			thirdlevel.setAttribute("name","snkband");
   			thirdlevel.setAttribute("value",snkband.options[snkband.selectedIndex].value);
   			secondlevel.appendChild(thirdlevel);
   			    
   			thirdlevel = new tagElement("param");
   			thirdlevel.setAttribute("name","sinkCenterFreq");
   			thirdlevel.setAttribute("value",snkFreq[i]);
   			secondlevel.appendChild(thirdlevel);
   			
   			thirdlevel = new tagElement("param");
   			thirdlevel.setAttribute("name","sinkBandWidth");
   			thirdlevel.setAttribute("value",snkWidth[i]);
   			secondlevel.appendChild(thirdlevel);
            
   			firstlevel.appendChild(secondlevel);
      }
      root.getRoot().appendChild(firstlevel);

      var xml = root.toString();
      return xml;
   }
   return null;
}

function submitAppendpage()
{
   var xml = createXML();
   if (xml != null)
   {   	  
      document.getElementById("submitbtn").disabled="disabled";
      document.getElementById("apply").disabled="disabled";
      loadXMLdoc("../../../../neExlorerServlet?sfid="+TECMDCODE_WDM_INTRA_OXC_CREATE+"&flag=1","POST",true,handleback,null,"inputdata="+xml.toString());
   }
}

function handleback(doc)
{
	document.getElementById("submitbtn").disabled=false;
    document.getElementById("apply").disabled=false;
     
    var objerr = new Object();
    objerr = EncapsulateData(doc);
    
    if (ifdemo == 0)
    {
       showErrorMessage(objerr);
       if (objerr.getSErrorCode() == 0 || objerr.getSErrorCode() == 1 )
       {
       	   win.refreshtable(win.st);
       	   if (submitflag)
       	   {
       	      window.close();
       	   }
       	   else
       	   {
       	   		cleareWaveLengthNo();
        	}
       }
    }   
}

function showErrorMessage(data)
{
	var errArr = [];
    errArr[0] = "errObjStr";
    var oError = data.getError();
    var errObjStr = "";
    if(data.getBErrLength() > 0)
    {
        for(var i = 0; i < data.getBErrLength(); i++)
        {
            tempErrObjStr = "";
            nename = "";
            if(null != oError.getRowKey(i, "nename") && "" != oError.getRowKey(i, "nename"))
            {
                nename = oError.getRowKey(i, "nename");
            }
            if(null != oError.getRowKey(i, "source") && "" != oError.getRowKey(i, "source"))
            {
                tempErrObjStr += RESOURCE["source"] + ":" + nename + "-" + oError.getRowKey(i, "source");
            }
            if(null != oError.getRowKey(i, "sink") && "" != oError.getRowKey(i, "sink"))
            {
                tempErrObjStr += "," + RESOURCE["sink"] + ":" + nename + "-" + oError.getRowKey(i, "sink");
            }
            oError.rowErrors[i].errorObj["errObjStr"] = tempErrObjStr;
        }
    }
    openErrPage("../../../../page/", oError, errArr); 
    errArr = null;
}

function preload()
{	
	refreshTable(win.newCreateData);
}


function refreshSrcBand()
{
   var srcBandSelect = ct.getAtom("srcband").element;
   var snkBandSelect = ct.getAtom("snkband").element;
   var srcBand = srcBandSelect.options[srcBandSelect.selectedIndex].value;
   for (var i = 0; i < snkBandSelect.options.length; i++)
   {
       if (snkBandSelect.options[i].value == srcBand)
       {
          snkBandSelect.options[i].selected = true;
          break;
       }
   }
   
}

function refreshSnkBand()
{
   var srcBandSelect = ct.getAtom("srcband").element;
   var snkBandSelect = ct.getAtom("snkband").element;
   var snkBand = snkBandSelect.options[snkBandSelect.selectedIndex].value;
   for (var i = 0; i < srcBandSelect.options.length; i++)
   {
       if (srcBandSelect.options[i].value == snkBand)
       {
          srcBandSelect.options[i].selected = true;
          break;
       }
   }
   
   cleareWaveLengthNo();
}

function cleareWaveLengthNo()
{
	ct.getAtom("srcwavelengthno").setValue("");
	ct.getAtom("snkwavelengthno").setValue("");
	ct.getAtom("srcwavelengthgrid").setValue("");
	ct.getAtom("snkwavelengthgrid").setValue("");
	srcFreq.length = 0;
    srcWidth.length = 0;
    snkFreq.length = 0;
    snkWidth.length = 0;
}
function clearband()
{
	ct.getAtom("srcband").setValue("");
	ct.getAtom("snkband").setValue("");
}

function refreshTable(data)
{
    var srcBoardSelect = ct.getAtom("srcboard").element;
    var snkBoardSelect = ct.getAtom("snkboard").element;
    var srcPortSelect = ct.getAtom("srcport").element;
    var srcBandSelect = ct.getAtom("srcband").element;
    var snkPortSelect = ct.getAtom("snkport").element;
    var snkBandSelect = ct.getAtom("snkband").element;
        
    if(data.getDataRowLength() > 0)
    {       
        var slot = data.getDataRowParam(0, "slot");
        if (slot != null && slot != "")
        {
           var slotId = data.getDataRowParam(0, "slotid");
           srcBoardSelect.options[srcBoardSelect.options.length] = new Option(slot, slotId);
           snkBoardSelect.options[snkBoardSelect.options.length] = new Option(slot, slotId);
           var boardOptions = data.getDataRowOptions(0, "slot");
		   var idOptions = data.getDataRowOptions(0, "slotid");
           if (boardOptions)
           {
        	   for (var i = 0; i < boardOptions.length; i++)
        	   {
        	       slot = boardOptions[i];
        	       slotId = idOptions[i]; 
        		     srcBoardSelect.options[srcBoardSelect.options.length] = new Option(slot, slotId);
                 snkBoardSelect.options[snkBoardSelect.options.length] = new Option(slot, slotId);
        	   }
           }
        }        

        var srcPort = data.getDataRowParam(0, "srcport");
        if (srcPort != null && srcPort != "")
        {
            var srcPortId = srcPort.substring(0, srcPort.indexOf("("));
        	srcPortSelect.options[srcPortSelect.options.length] = new Option(srcPort, srcPortId);
        	var srcPortOptions = data.getDataRowOptions(0, "srcport");
        	if (srcPortOptions)
        	{
        		for (var j = 0; j < srcPortOptions.length; j++)
        		{
        		    srcPort = srcPortOptions[j];
        		    srcPortId = srcPort.substring(0, srcPort.indexOf("("));
        			srcPortSelect.options[srcPortSelect.options.length] = new Option(srcPort, srcPortId);
        		}        

        	}
        }
        

        var srcBandId = parseInt(data.getDataRowParam(0, "srcband"));
        if (srcBandId > 0)
        {
           var srcBandName = getBandName(srcBandId);
           srcBandSelect.options[srcBandSelect.options.length] = new Option(srcBandName,srcBandId);
           
           var srcBandOptions = data.getDataRowOptions(0, "srcband");
           if (srcBandOptions)
           {
           	  for (var k = 0; k < srcBandOptions.length; k++)
           	  {
           	     srcBandId = parseInt(srcBandOptions[k]);
           	     srcBandName = getBandName(srcBandId);
           	     srcBandSelect.options[srcBandSelect.options.length] = new Option(srcBandName, srcBandId);
           	  }
           } 
        }

        
        var snkPort = data.getDataRowParam(0, "snkport");
        if (snkPort != null && snkPort != "")
        {
           var snkPortId = snkPort.substring(0, snkPort.indexOf("("));
           snkPortSelect.options[snkPortSelect.options.length] = new Option(snkPort, snkPortId);
           var snkPortOptions = data.getDataRowOptions(0, "snkport");
           if (snkPortOptions)
           {
        	   for (var m = 0; m < snkPortOptions.length; m++)
        	   {
        	       snkPort = snkPortOptions[m];
        	       snkPortId = snkPort.substring(0, snkPort.indexOf("("));
        		   snkPortSelect.options[snkPortSelect.options.length] = new Option(snkPort, snkPortId);
        	   }
           }
        }

       
        var snkBandId = parseInt(data.getDataRowParam(0, "snkband"));
        if (snkBandId > 0)
        {
           var snkBandName = getBandName(snkBandId);
           snkBandSelect.options[snkBandSelect.options.length] = new Option(snkBandName, snkBandId);
           var snkBandOptions = data.getDataRowOptions(0, "snkband");
           if (snkBandOptions)
           {
              for(var n = 0; n < snkBandOptions.length; n++)
              {
                  snkBandId = parseInt(snkBandOptions[n]);
                  snkBandName = getBandName(snkBandId);
                  snkBandSelect.options[snkBandSelect.options.length] = new Option(snkBandName, snkBandId);
              }
           }
        }
    }
}

function getBandName(bandid)
{
   var bandName = "";
   switch(bandid)
   {
      case 0:
         bandName = "C+L";
         break;
      case 1:
         bandName = "C";
         break;
      case 2:
         bandName = "L";
         break;
      case 3:
         bandName = "C32";
         break;
      case 4:
         bandName = "RAMAN_C";
         break;
      case 5:
         bandName = "RAMAN_L";
         break;
      case 6:
         bandName = "CWDM";
         break;
      case 7:
         bandName = "SMC";
         break;
      case 8:
         bandName = "C96A";
         break;
      case 9:
         bandName = "C96B";
         break;
      case 10:
         bandName = "C192";
         break;
      default:
         break;
   }
   return bandName;
}

function TEWaveLength()
{
	this.waveNo = -1;
	this.centerfreq = -1;
}
