 loadXMLdoc("../../../../conf/system.xml","GET",false,EncapsulateSConf);
var ifdemo = SYSTEMCONF.getDemo();
var language = SYSTEMCONF.getLanguage();
getResourse("../../../../res/commonres_"+ language +".xml"); 
getResourse("../../../../res/configres_"+ language +".xml"); 
getResourse("../../res/oxc/oxcres_"+ SYSTEMCONF.getLanguage() +".xml");

var submitflag = false;
var win = getParentWindow();
var obj = parseURLStr(self);
var linkflag;
function getNEID()
{
    return obj["neid"];
}

var ct;

function init()
{

	ct = new CTable();
	ct.addHead(RESOURCE["attribute"],RESOURCE["attrValue"]);

	var atom = new Atom("select");
	atom.element.onchange = function()
	{
		refreshBoard(0);
	};
	atom.element.style.width="100%";
	ct.addAttrRow("srcboard", RESOURCE["srcboard"], atom);
	
	atom = new Atom("select");
	atom.element.onchange = function()
	{
	   refreshPort(0);
	};
	atom.element.style.width="100%";
	ct.addAttrRow("srcport", RESOURCE["srcport"], atom);

	atom = new Atom("select");
	atom.element.onchange = function()
	{
		refreshSrcBand();
	};
	atom.element.style.width="100%";
	ct.addAttrRow("srcband", RESOURCE["srcband"], atom);

	atom = new Atom("text");
	atom.setValue("");
	atom.element.disabled = "disabled";
	atom.element.style.width="87%";
	ct.addAttrRow("srcwavelengthno", RESOURCE["srcwavelengthno"], atom);
	var btn = document.createElement("input");
	btn.setAttribute("type", "button");
	btn.setAttribute("id", "srcwavelength");
	btn.setAttribute("width", "13%");
	btn.onclick = function()
	{
	   setWaveLengthNo(0);
	};
	ct.getAtom("srcwavelengthno").element.parentNode.appendChild(btn);

	atom = new Atom("select");
	atom.element.onchange = function()
	{
		refreshBoard(1);
	};
	atom.element.style.width="100%";
	ct.addAttrRow("snkboard", RESOURCE["snkboard"], atom);
	

	atom = new Atom("select");
	atom.element.onchange = function()
	{
	   refreshPort(1);
	};
	atom.element.style.width="100%";
	ct.addAttrRow("snkport", RESOURCE["snkport"], atom);

	atom = new Atom("select");
	atom.element.onchange = function()
	{
		refreshSnkBand();
	};
	atom.element.style.width="100%";
	ct.addAttrRow("snkband", RESOURCE["snkband"], atom);
	
	atom = new Atom("text");
	atom.setValue("");
	atom.element.disabled = "disabled";
	atom.element.style.width="87%";
	ct.addAttrRow("snkwavelengthno", RESOURCE["snkwavelengthno"], atom);
	btn = document.createElement("input");
	btn.setAttribute("type", "button");
	btn.setAttribute("id", "snkwavelength");
	btn.setAttribute("width", "13%");
	btn.onclick = function()
	{
	   setWaveLengthNo(1);
	};
	ct.getAtom("snkwavelengthno").element.parentNode.appendChild(btn);
	
	atom = new Atom("select");
	ct.addAttrRow("model", RESOURCE["model_flag"], atom);
	atom = ct.getAtom("model");
	atom.element.style.width="100%";
	
	atom.clearOptions();
    atom.addOption(modelFlag[0], "2");
    atom.addOption(modelFlag[1], "1");
	
	document.body.insertBefore(ct.getTable(), document.body.firstChild);
}

function setWaveLengthNo(flag)
{
   var board = -1;
   var port = -1;
   var band = -1;
   var srcBoardSelect = ct.getAtom("srcboard").element;
   var srcslotid = srcBoardSelect.options[srcBoardSelect.selectedIndex].value;
   var srcPortSelect = ct.getAtom("srcport").element;
   var srcport = srcPortSelect.options[srcPortSelect.selectedIndex].value;
   
   var snkBoardSelect = ct.getAtom("snkboard").element;
   var sinkslotid = snkBoardSelect.options[snkBoardSelect.selectedIndex].value;
   var snkPortSelect = ct.getAtom("snkport").element;
   var sinkport = snkPortSelect.options[snkPortSelect.selectedIndex].value;
   if (flag == 0)
   {
      board = srcBoardSelect.options[srcBoardSelect.selectedIndex].value;
      boardName = srcBoardSelect.options[srcBoardSelect.selectedIndex].text;
      port = srcPortSelect.options[srcPortSelect.selectedIndex].value;
      var srcBandSelect = ct.getAtom("srcband").element;
      band = srcBandSelect.options[srcBandSelect.selectedIndex].value;
      wave = ct.getAtom("srcwavelengthno").element.value;
   }
   else if (flag == 1)
   {
      board = snkBoardSelect.options[snkBoardSelect.selectedIndex].value;
      boardName = snkBoardSelect.options[snkBoardSelect.selectedIndex].text;
      port = snkPortSelect.options[snkPortSelect.selectedIndex].value;
      var snkBandSelect = ct.getAtom("snkband").element;
      band = snkBandSelect.options[snkBandSelect.selectedIndex].value;
      wave = ct.getAtom("snkwavelengthno").element.value;
   }
   var windowFeature = "dialogHeight:340px;dialogWidth:440px;center:yes;help:no;resizable:Yes;status:No;";
   var url = "getwaveLenInfo.html?oxcflag=1&flag=" + flag + "&linkflag=1&neid=" + obj["neid"] + "&board=" + board + "&boardName=" + boardName + "&port=" + port + "&srcslotid=" +srcslotid + "&sinkslotid=" +sinkslotid + "&srcport=" + srcport + "&sinkport=" + sinkport + "&band=" + band + "&wave=" + wave;
   showModalDialog(url, window, windowFeature);
}

function refreshBoard(flag)
{
    var root = new inputxml("datainterface");  // Create the root of a xml file
    var firstlevel = new tagElement("bussiness-params");
    var secondlevel = new tagElement("row-params");
      
    var thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","neid");
    thirdlevel.setAttribute("value",getNEID());
    secondlevel.appendChild(thirdlevel); 
    
    var slot = "";
    var slotBoardName = "";
    if (flag == 0)
    {
       var srcSlot = ct.getAtom("srcboard").element;
       slot = srcSlot.options[srcSlot.selectedIndex].value;
       slotBoardName = srcSlot.options[srcSlot.selectedIndex].text;
    }
    else
    {
       var snkSlot = ct.getAtom("snkboard").element;
       slot = snkSlot.options[snkSlot.selectedIndex].value;
       slotBoardName = snkSlot.options[snkSlot.selectedIndex].text;
    }
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","slot");
    thirdlevel.setAttribute("value",slot);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","slotBoardName");
    thirdlevel.setAttribute("value",slotBoardName);
    secondlevel.appendChild(thirdlevel);
    
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","flag");
    thirdlevel.setAttribute("value",flag);
    secondlevel.appendChild(thirdlevel);
    
    firstlevel.appendChild(secondlevel);
    root.getRoot().appendChild(firstlevel);

    loadXMLdoc("../../../../neExlorerServlet?sfid="+TECMDCODE_WDM_EDGEPOINTC_QUERY+"&flag=0","POST",true,handlelinkage,null,"inputdata="+root.toString());
}

function handlelinkage(doc)
{
	var portSelect = null;
	var bandSelect = null;
	
    var data = EncapsulateData(doc);	
    if(data.getDataRowLength()==0)
    {
    	return;
    }
    var flag = data.getDataRowParam(0, "flag");
	if (flag == 0)
	{
    	portSelect = ct.getAtom("srcport").element;		
		bandSelect = ct.getAtom("srcband").element;
	}
	else
	{
		portSelect = ct.getAtom("snkport").element;
		bandSelect = ct.getAtom("snkband").element;
	}
	
    for (var i = portSelect.options.length - 1; i >= 0; i--)
    {
    	portSelect.remove(i);
    }
       
    var port = data.getDataRowParam(0, "port");
    if (port != null && port != "")
    {       
    	var portId = port.substring(0, port.indexOf("("));
    	portSelect.options[portSelect.options.length] = new Option(port, portId);
    	var portOptions = data.getDataRowOptions(0, "port");
    	if (portOptions != null)
    	{
    		for (var i = 0; i < portOptions.length; i++)
    		{
    			port = portOptions[i];
    			portId = port.substring(0, port.indexOf("("));
    			portSelect.options[portSelect.options.length] = new Option(port, portId);
    		}
    	}
    }
    
    for (var i = bandSelect.options.length - 1; i >= 0; i--)
    {
    	bandSelect.remove(i);
    }
       
    var band = data.getDataRowParam(0, "band");
    if (band != null && band != "")
    {       
    	var bandName = getBandName(parseInt(band));
    	bandSelect.options[bandSelect.options.length] = new Option(bandName, band);
    	var bandOptions = data.getDataRowOptions(0, "band");
    	if (bandOptions != null)
    	{
    		for (var i = 0; i < bandOptions.length; i++)
    		{
    			band = bandOptions[i];
    			bandName = getBandName(parseInt(band));
    			bandSelect.options[bandSelect.options.length] = new Option(bandName, band);
    		}
    	}
    }
    
    refreshPort(flag);   
}

function checkSubmit()
{
	var srcBoardSelect = ct.getAtom("srcboard").element;
	var snkBoardSelect = ct.getAtom("snkboard").element;
	if (srcBoardSelect.selectedIndex != -1 && snkBoardSelect.selectedIndex != -1)
	{
	   var srcPortSelect = ct.getAtom("srcport").element;
	   var snkPortSelect = ct.getAtom("snkport").element;
	   if (srcPortSelect.selectedIndex != -1 && snkPortSelect.selectedIndex != -1)
	   {
	      var srcBandSelect = ct.getAtom("srcband").element;
	      var snkBandSelect = ct.getAtom("snkband").element;
	      if (srcBandSelect.options[srcBandSelect.selectedIndex].value 
	           == snkBandSelect.options[snkBandSelect.selectedIndex].value)
	      {
	         var srcWaveLengthNo = ct.getAtom("srcwavelengthno").element;
	         var snkWaveLengthNo = ct.getAtom("snkwavelengthno").element;
	         if (srcWaveLengthNo.value != "" && snkWaveLengthNo.value != "")
	         {
	         	var srcWavelengthes = srcWaveLengthNo.value.split(",");
	         	var snkWavelengthes = snkWaveLengthNo.value.split(",");
	         	var count = 0;
	         	if (srcWavelengthes.length == snkWavelengthes.length)
	         	{
	         		for (var ii = 0; ii < srcWavelengthes.length; ii++)
	         		{
	         			for (var jj = 0; jj < snkWavelengthes.length; jj++)
	         			{
	         			    if (srcWavelengthes[ii] == snkWavelengthes[jj])
	         			    {
	         			    	count ++;
	         			    	break;
	         			    }
	         			}
	         		}
	         		if (count == srcWavelengthes.length)
	         		{
	         			return true;
	         		}
	         		else
	         		{
	         		    alert(RESOURCE["wavenotconsistent"]);
	         			return false;
	         		}
	         	}
	         	else
	         	{
	         		alert(RESOURCE["wavenotconsistent"]);
	         		return false;
	         	}
	         }
	         else
	         {
	         	alert(RESOURCE["wavenotnull"]);
	         	return false;
	         }
	      }
	      else
	      {
	      	 alert(RESOURCE["bandnotconsistent"]);
	      	 return false;
	      }
	   }
	   else
	   {
	      alert(RESOURCE["bandnotnull"]);
	      return false;
	   }
	}
	else
	{
	   alert(RESOURCE["soltnotnull"]);
	   return false;
	}
}


function getStringArray(str)
{
    var resultArray = new Array();
    
    if ("" == str || "-" == str)
    {
    	  return resultArray;
    }
    var str = str.split(",");
    for(var i = 0, len = str.length ; i < len; i++)
    {
        var b=str[i].indexOf("-")!=-1;
        if(b)
        {
            var range=str[i].split("-");
            var rangeStart=parseInt(range[0]);
            var rangeEnd=parseInt(range[1]);
            for(var j=rangeStart; j<=rangeEnd;j++)
            {
                resultArray.push(""+j);
            }
        }
        else
        {
            resultArray.push(str[i]);
        }
    }
    return resultArray;
}


function createXML()
{
   if (checkSubmit())
   {
      var root = new inputxml("datainterface");  // Create the root of a xml file
      var firstlevel = new tagElement("bussiness-params");
      
      var waveLengthNo = ct.getAtom("srcwavelengthno").element;
      var waveLengthNoes = getStringArray(waveLengthNo.value);
      
      var idIndex = 0;
      for (var kk = 0; kk < waveLengthNoes.length; kk++)
      {
         var wavelength = waveLengthNoes[kk];
         var wavelengthes = wavelength.split("-");
         var min = -1;
         var max = -1;
         if (wavelengthes.length == 2)
         {
            min = wavelengthes[0];
            max = wavelengthes[1];
         }
         else
         {
            min = wavelengthes[0];
            max = min;
         }
         
         var xcIDList = getRangeNumber(win.usedXCID,1,65535,2*(waveLengthNoes.length));
         
         var isChecked = $("bothway").checked;

         for (var mm = min; mm <= max; mm++)
         {
            var secondlevel = new tagElement("row-params");
      
            var thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name","neid");
            thirdlevel.setAttribute("value",getNEID());
            secondlevel.appendChild(thirdlevel);

            thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name","oxcid");
            thirdlevel.setAttribute("value",xcIDList[idIndex++]);
            secondlevel.appendChild(thirdlevel);

            var srcboard = ct.getAtom("srcboard").element;
            thirdlevel = new tagElement("param");
		   			thirdlevel.setAttribute("name","srcslot");
		   			thirdlevel.setAttribute("value",srcboard.options[srcboard.selectedIndex].value);
		   			secondlevel.appendChild(thirdlevel);

            thirdlevel = new tagElement("param");
		   			thirdlevel.setAttribute("name","source");
		   			thirdlevel.setAttribute("value",srcboard.options[srcboard.selectedIndex].text);
		   			secondlevel.appendChild(thirdlevel);

		  			var srcport = ct.getAtom("srcport").element;
		   			thirdlevel = new tagElement("param");
		   			thirdlevel.setAttribute("name","srcport");
		   			thirdlevel.setAttribute("value",srcport.options[srcport.selectedIndex].value);
		   			secondlevel.appendChild(thirdlevel);

						var srcband = ct.getAtom("srcband").element;
		   			thirdlevel = new tagElement("param");
		   			thirdlevel.setAttribute("name","srcband");
		   			thirdlevel.setAttribute("value",srcband.options[srcband.selectedIndex].value);
		   			secondlevel.appendChild(thirdlevel);
		   			
		   			thirdlevel = new tagElement("param");
		   			thirdlevel.setAttribute("name","srcwave");
		   			thirdlevel.setAttribute("value",mm);
		   			secondlevel.appendChild(thirdlevel);

            var snkboard = ct.getAtom("snkboard").element;
            thirdlevel = new tagElement("param");
		   			thirdlevel.setAttribute("name","snkslot");
		   			thirdlevel.setAttribute("value",snkboard.options[snkboard.selectedIndex].value);
		   			secondlevel.appendChild(thirdlevel);

            thirdlevel = new tagElement("param");
		   			thirdlevel.setAttribute("name","sink");
		   			thirdlevel.setAttribute("value",snkboard.options[snkboard.selectedIndex].text);
		   			secondlevel.appendChild(thirdlevel);
		
		  			var snkport = ct.getAtom("snkport").element;
		   			thirdlevel = new tagElement("param");
		   			thirdlevel.setAttribute("name","snkport");
		   			thirdlevel.setAttribute("value",snkport.options[snkport.selectedIndex].value);
		   			secondlevel.appendChild(thirdlevel);

						var snkband = ct.getAtom("snkband").element;
		   			thirdlevel = new tagElement("param");
		   			thirdlevel.setAttribute("name","snkband");
		   			thirdlevel.setAttribute("value",snkband.options[snkband.selectedIndex].value);
		   			secondlevel.appendChild(thirdlevel);
		   			
		   			thirdlevel = new tagElement("param");
		   			thirdlevel.setAttribute("name","snkwave");
		   			thirdlevel.setAttribute("value",mm);
		   			secondlevel.appendChild(thirdlevel);
		
		   			thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name","belongoxcid");
            thirdlevel.setAttribute("value","0");
            secondlevel.appendChild(thirdlevel);
            var model = ct.getAtom("model").element;
            thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name","manual");
            
            thirdlevel.setAttribute("value",model.options[model.selectedIndex].value);
            secondlevel.appendChild(thirdlevel);
   
   					firstlevel.appendChild(secondlevel);
   					
   					if(isChecked)
   					{
   					var secondlevel = new tagElement("row-params");
      
            var thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name","neid");
            thirdlevel.setAttribute("value",getNEID());
            secondlevel.appendChild(thirdlevel);

            thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name","oxcid");
            thirdlevel.setAttribute("value",xcIDList[idIndex++]);
            secondlevel.appendChild(thirdlevel);

            var srcboard = ct.getAtom("srcboard").element;
            thirdlevel = new tagElement("param");
		   			thirdlevel.setAttribute("name","snkslot");
		   			thirdlevel.setAttribute("value",srcboard.options[srcboard.selectedIndex].value);
		   			secondlevel.appendChild(thirdlevel);

            thirdlevel = new tagElement("param");
		   			thirdlevel.setAttribute("name","sink");
		   			thirdlevel.setAttribute("value",srcboard.options[srcboard.selectedIndex].text);
		   			secondlevel.appendChild(thirdlevel);

		  			var srcport = ct.getAtom("srcport").element;
		   			thirdlevel = new tagElement("param");
		   			thirdlevel.setAttribute("name","snkport");
		   			thirdlevel.setAttribute("value",srcport.options[srcport.selectedIndex].value);
		   			secondlevel.appendChild(thirdlevel);

						var srcband = ct.getAtom("srcband").element;
		   			thirdlevel = new tagElement("param");
		   			thirdlevel.setAttribute("name","snkband");
		   			thirdlevel.setAttribute("value",srcband.options[srcband.selectedIndex].value);
		   			secondlevel.appendChild(thirdlevel);
		   			
		   			thirdlevel = new tagElement("param");
		   			thirdlevel.setAttribute("name","snkwave");
		   			thirdlevel.setAttribute("value",mm);
		   			secondlevel.appendChild(thirdlevel);

            var snkboard = ct.getAtom("snkboard").element;
            thirdlevel = new tagElement("param");
		   			thirdlevel.setAttribute("name","srcslot");
		   			thirdlevel.setAttribute("value",snkboard.options[snkboard.selectedIndex].value);
		   			secondlevel.appendChild(thirdlevel);

            thirdlevel = new tagElement("param");
		   			thirdlevel.setAttribute("name","source");
		   			thirdlevel.setAttribute("value",snkboard.options[snkboard.selectedIndex].text);
		   			secondlevel.appendChild(thirdlevel);
		
		  			var snkport = ct.getAtom("snkport").element;
		   			thirdlevel = new tagElement("param");
		   			thirdlevel.setAttribute("name","srcport");
		   			thirdlevel.setAttribute("value",snkport.options[snkport.selectedIndex].value);
		   			secondlevel.appendChild(thirdlevel);

						var snkband = ct.getAtom("snkband").element;
		   			thirdlevel = new tagElement("param");
		   			thirdlevel.setAttribute("name","srcband");
		   			thirdlevel.setAttribute("value",snkband.options[snkband.selectedIndex].value);
		   			secondlevel.appendChild(thirdlevel);
		   			
		   			thirdlevel = new tagElement("param");
		   			thirdlevel.setAttribute("name","srcwave");
		   			thirdlevel.setAttribute("value",mm);
		   			secondlevel.appendChild(thirdlevel);
		
		   			thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name","belongoxcid");
            thirdlevel.setAttribute("value","0");
            secondlevel.appendChild(thirdlevel);
            var model = ct.getAtom("model").element;
            thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name","manual");
            
            thirdlevel.setAttribute("value",model.options[model.selectedIndex].value);
            secondlevel.appendChild(thirdlevel);
   
   					firstlevel.appendChild(secondlevel);
   					}
   		 }
   	  }
   	  
   	  var secondlevel = new tagElement("row-params");
   	  var bothwayParam = new tagElement("param");
   	  bothwayParam.setAttribute("name","bothway");
		  bothwayParam.setAttribute("value",$("bothway").checked);
		  secondlevel.appendChild(bothwayParam);
		  
		 
		  firstlevel.appendChild(secondlevel);
   	  
      root.getRoot().appendChild(firstlevel);

      var xml = root.toString();
      return xml;
   }
   return null;
}

function submitAppendpage()
{
   var xml = createXML();
   if (xml != null)
   {
      loadXMLdoc("../../../../neExlorerServlet?sfid="+TECMDCODE_WDM_INTER_OXC_CREATE+"&flag=1","POST",true,handleback,null,"inputdata="+xml.toString());
   }
}

function handleback(doc)
{
    var objerr = new Object();
    objerr = EncapsulateData(doc);
    
    if (ifdemo == 0)
    {
       showErrorMessage(objerr);
       if (objerr.getSErrorCode() == 0)
       {
       	   win.refreshtable(win.st);
       	   if (submitflag)
       	   {
       	      window.close();
       	   }
       	   else
       	   {
       	      var srcwaveLengthNo = ct.getAtom("srcwavelengthno").element;
       	      var snkwaveLengthNo = ct.getAtom("snkwavelengthno").element;
       	      srcwaveLengthNo.value = "";
       	      snkwaveLengthNo.value = "";  
       	   }
       }
       else if (objerr.getSErrorCode() == 1)
       {
       	  win.refreshtable(win.st); 
       }
    }   
}

function showErrorMessage(data)
{
		var errArr = [];
    errArr[0] = "errObjStr";
    var oError = data.getError();
    var errObjStr = "";
    if(data.getBErrLength() > 0)
    {
        for(var i = 0; i < data.getBErrLength(); i++)
        {
            tempErrObjStr = "";
            nename = "";
            if(null != oError.getRowKey(i, "nename") && "" != oError.getRowKey(i, "nename"))
            {
                nename = oError.getRowKey(i, "nename");
            }
            if(null != oError.getRowKey(i, "source") && "" != oError.getRowKey(i, "source"))
            {
                tempErrObjStr += RESOURCE["source"] + ":" + nename + "-" + oError.getRowKey(i, "source");
            }
            if(null != oError.getRowKey(i, "sink") && "" != oError.getRowKey(i, "sink"))
            {
                tempErrObjStr += "," + RESOURCE["sink"] + ":" + nename + "-" + oError.getRowKey(i, "sink");
            }
            oError.rowErrors[i].errorObj["errObjStr"] = tempErrObjStr;
        }
    }
    openErrPage("../../../../page/", oError, errArr); 
    errArr = null;
}

function preload()
{
	refreshTable(win.newCreateData);
}

function refreshPort(flag)
{
    cleareWaveLengthNo(flag);
    
    var root = new inputxml("datainterface");  // Create the root of a xml file
    var firstlevel = new tagElement("bussiness-params");
    var secondlevel = new tagElement("row-params");
      
    var thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","neid");
    thirdlevel.setAttribute("value",getNEID());
    secondlevel.appendChild(thirdlevel); 
    
    var slot = "";
    var portID = "";
    var bandSelect;
    if (flag == 0)
    {
       var srcSlot = ct.getAtom("srcboard").element;
       slot = srcSlot.options[srcSlot.selectedIndex].value;
       var srcPort = ct.getAtom("srcport").element;
       portID = srcPort.options[srcPort.selectedIndex].value;
       bandSelect = ct.getAtom("srcband").element;
    }
    else
    {
       var snkSlot = ct.getAtom("snkboard").element;
       slot = snkSlot.options[snkSlot.selectedIndex].value;
       var snkPort = ct.getAtom("snkport").element;
       portID = snkPort.options[snkPort.selectedIndex].value;
       bandSelect = ct.getAtom("snkband").element;
    }
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","slot");
    thirdlevel.setAttribute("value",slot);
    secondlevel.appendChild(thirdlevel);

    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","port");
    thirdlevel.setAttribute("value",portID);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","flag");
    thirdlevel.setAttribute("value",flag);
    secondlevel.appendChild(thirdlevel);
    
    firstlevel.appendChild(secondlevel);
    root.getRoot().appendChild(firstlevel);

    loadXMLdoc("../../../../neExlorerServlet?sfid="+TECMDCODE_NAWDM_OXC_GET_AVAILRES+"&flag=0","POST",true,handleBand,bandSelect,"inputdata="+root.toString());
}

function handleBand(doc,bandSelect)
{
	  var data = EncapsulateData(doc);
	  var band = data.getDataRowParam(0, "band");
	  bandSelect.options.length = 0;
    if (band != null && band != "")
    {       
    	var bandName = getBandName(parseInt(band));
    	bandSelect.options[bandSelect.options.length] = new Option(bandName, band);
    	var bandOptions = data.getDataRowOptions(0, "band");
    	if (bandOptions != null)
    	{
    		for (var i = 0; i < bandOptions.length; i++)
    		{
    			band = bandOptions[i];
    			bandName = getBandName(parseInt(band));
    			bandSelect.options[bandSelect.options.length] = new Option(bandName, band);
    		}
    	}
    }
}

function refreshSrcBand()
{
   var srcBandSelect = ct.getAtom("srcband").element;
   var snkBandSelect = ct.getAtom("snkband").element;
   var srcBand = srcBandSelect.options[srcBandSelect.selectedIndex].value;
   for (var i = 0; i < snkBandSelect.options.length; i++)
   {
       if (snkBandSelect.options[i].value == srcBand)
       {
          snkBandSelect.options[i].selected = true;
          break;
       }
   }
   cleareWaveLengthNo(0);
}

function refreshSnkBand()
{
   var srcBandSelect = ct.getAtom("srcband").element;
   var snkBandSelect = ct.getAtom("snkband").element;
   var snkBand = snkBandSelect.options[snkBandSelect.selectedIndex].value;
   for (var i = 0; i < srcBandSelect.options.length; i++)
   {
       if (srcBandSelect.options[i].value == snkBand)
       {
          srcBandSelect.options[i].selected = true;
          break;
       }
   }
   cleareWaveLengthNo(1);
}

function cleareWaveLengthNo(srcorsnk)
{
	if (srcorsnk == 0)
	{
	ct.getAtom("srcwavelengthno").setValue("");
	}
	else
	{
	ct.getAtom("snkwavelengthno").setValue("");
	}
}


function refreshTable(data)
{
    if(data.getDataRowLength() >= 0)
    {   
        var srcBoardSelect = ct.getAtom("srcboard").element;
        var srcslot = data.getDataRowParam(0, "srcslot");
        if (srcslot != null && srcslot != "")
        {
           var srcslotId = data.getDataRowParam(0, "srcslotid");
           srcBoardSelect.options[srcBoardSelect.options.length] = new Option(srcslot, srcslotId);
           var boardOptions = data.getDataRowOptions(0, "srcslot");
		   var idOptions = data.getDataRowOptions(0, "srcslotid");
           if (boardOptions)
           {
        	   for (var i = 0; i < boardOptions.length; i++)
        	   {
      	       		srcslot = boardOptions[i];
      	       		srcslotId = idOptions[i];
        		   	srcBoardSelect.options[srcBoardSelect.options.length] = new Option(srcslot, srcslotId);
        	   }
           }
        }

        var srcPortSelect = ct.getAtom("srcport").element;
        var srcPort = data.getDataRowParam(0, "srcport");
        if (srcPort != null && srcPort != "")
        {
          var srcPortId = srcPort.substring(0, srcPort.indexOf("("));
        	srcPortSelect.options[srcPortSelect.options.length] = new Option(srcPort, srcPortId);
        	var srcPortOptions = data.getDataRowOptions(0, "srcport");
        	if (srcPortOptions)
        	{
        		for (var j = 0; j < srcPortOptions.length; j++)
        		{
        		    srcPort = srcPortOptions[j];
        		    srcPortId = srcPort.substring(0, srcPort.indexOf("("));
        			srcPortSelect.options[srcPortSelect.options.length] = new Option(srcPort, srcPortId);
        		}
        	}
        }

        var srcBandSelect = ct.getAtom("srcband").element;
        var srcBandId = parseInt(data.getDataRowParam(0, "srcband"));
        if (srcBandId >= 0)
        {
           var srcBandName = getBandName(srcBandId);
           srcBandSelect.options[srcBandSelect.options.length] = new Option(srcBandName, srcBandId);
           var srcBandOptions = data.getDataRowOptions(0, "srcband");
           if (srcBandOptions)
           {
           	  for (var k = 0; k < srcBandOptions.length; k++)
           	  {
           	     srcBandId = parseInt(srcBandOptions[k]);
           	     srcBandName = getBandName(srcBandId);
           	     srcBandSelect.options[srcBandSelect.options.length] = new Option(srcBandName, srcBandId);
           	  }
           } 
        }
        
        var snkBoardSelect = ct.getAtom("snkboard").element;
        var snkslot = data.getDataRowParam(0, "snkslot");
        if (snkslot != null && snkslot != "")
        {
           var snkslotId = data.getDataRowParam(0, "snkslotid");
           snkBoardSelect.options[snkBoardSelect.options.length] = new Option(snkslot, snkslotId);
           var boardOptions = data.getDataRowOptions(0, "snkslot");
		   var idOptions = data.getDataRowOptions(0, "snkslotid");
           if (boardOptions)
           {
        	   for (var t = 0; t < boardOptions.length; t++)
        	   {
      	       		snkslot = boardOptions[t];
      	      		snkslotId = idOptions[t];
        		   	snkBoardSelect.options[snkBoardSelect.options.length] = new Option(snkslot, snkslotId);
        	   }
           }
        }

        var snkPortSelect = ct.getAtom("snkport").element;
        var snkPort = data.getDataRowParam(0, "snkport");
        if (snkPort != null && snkPort != "")
        {
           var snkPortId = snkPort.substring(0, snkPort.indexOf("("));
           snkPortSelect.options[snkPortSelect.options.length] = new Option(snkPort, snkPortId);
           var snkPortOptions = data.getDataRowOptions(0, "snkport");
           if (snkPortOptions)
           {
        	   for (var m = 0; m < snkPortOptions.length; m++)
        	   {
        	       snkPort = snkPortOptions[m];
        	       snkPortId = snkPort.substring(0, snkPort.indexOf("("));
        		   snkPortSelect.options[snkPortSelect.options.length] = new Option(snkPort, snkPortId);
        	   }
           }
        }

        var snkBandSelect = ct.getAtom("snkband").element;
        var snkBandId = parseInt(data.getDataRowParam(0, "snkband"));
        if (snkBandId >= 0)
        {
           var snkBandName = getBandName(snkBandId);
           snkBandSelect.options[snkBandSelect.options.length] = new Option(snkBandName, snkBandId);
           var snkBandOptions = data.getDataRowOptions(0, "snkband");
           if (snkBandOptions)
           {
              for (var n = 0; n < snkBandOptions.length; n++)
              {
                  snkBandId = parseInt(snkBandOptions[n]);
                  snkBandName = getBandName(snkBandId);
                  snkBandSelect.options[snkBandSelect.options.length] = new Option(snkBandName, snkBandId);
              }
           }
        }
    } 
}

function getBandName(bandid)
{
   var bandName = "";
   switch(bandid)
   {
      case 0:
         bandName = "C+L";
         break;
      case 1:
         bandName = "C";
         break;
      case 2:
         bandName = "L";
         break;
      case 3:
         bandName = "C32";
         break;
      case 4:
         bandName = "RAMAN_C";
         break;
      case 5:
         bandName = "RAMAN_L";
         break;
      case 6:
         bandName = "CWDM";
         break;
      case 7:
         bandName = "SMC";
         break;
      case 8:
         bandName = "C96A";
         break;
      case 9:
         bandName = "C96B";
         break;
      case 10:
         bandName = "C192";
         break;
      default:
         break;
   }
   return bandName;
}

var modelFlag = [];
modelFlag[0] = RESOURCE["manualmodel"];
modelFlag[1] = RESOURCE["automodel"];
