 var upTable; //      
var belowTable; //      
var deleteRows; //        
var applyBtnStatus; //              
var isNeedQuery = true;//tab            
var isBoundSuccess = false;//    ID    
var obj = parent.paramObj;
var sysLanguage = SYSTEMCONF.getLanguage();
var iswestout = 1;
var otuInfoDataArr = new Array();

var switchstatus = new Object();
switchstatus["0"] = "SWITCH_STATUS_0";
switchstatus["1"] = "SWITCH_STATUS_1";
switchstatus["2"] = "SWITCH_STATUS_2";
switchstatus["3"] = "SWITCH_STATUS_3";
switchstatus["4"] = "SWITCH_STATUS_4";
switchstatus["5"] = "SWITCH_STATUS_5";
switchstatus["6"] = "SWITCH_STATUS_6";

var switchreq = new Object();
switchreq["22"] = "SWITCH_REQ_22";
switchreq["21"] = "SWITCH_REQ_21";
switchreq["19"] = "SWITCH_REQ_19";
switchreq["18"] = "SWITCH_REQ_18";
switchreq["17"] = "SWITCH_REQ_17";
switchreq["16"] = "SWITCH_REQ_16";
switchreq["14"] = "SWITCH_REQ_14";
switchreq["13"] = "SWITCH_REQ_13";
switchreq["11"] = "SWITCH_REQ_11";
switchreq["10"] = "SWITCH_REQ_10";
switchreq["8"] = "SWITCH_REQ_8"; 
switchreq["6"] = "SWITCH_REQ_6"; 
switchreq["3"] = "SWITCH_REQ_3"; 
switchreq["0"] = "SWITCH_REQ_0"; 

var sdflag = new Object();
sdflag["0"] = "SD_FLAG_0";
sdflag["1"] = "SD_FLAG_1";

var switchindication = new Object();
switchindication["0"] = "SWITCH_INDICATION_0";
switchindication["1"] = "SWITCH_INDICATION_1";

var direct = new Object();
direct["1"] = "DIRECTION_1";
direct["2"] = "DIRECTION_2";
direct["3"] = "DIRECTION_3";
direct["4"] = "DIRECTION_4";

var channelstatus = new Object();
channelstatus["1"] = "UNIT_STATUS_1";
channelstatus["2"] = "UNIT_STATUS_2";                        
channelstatus["4"] = "UNIT_STATUS_4";                        
channelstatus["5"] = "UNIT_STATUS_5";                         
channelstatus["255"] = "UNIT_STATUS_255";

var REVERTIVWTRTIME = "05:00";

var MINWTRTIME = "05:00";  

var MAXWTRTIME = "12:00";

var MAXWTRVALUE = "720";

var MINWTRVALUE = "300";

function tabSelectHandler()
{
	if(isNeedQuery == true) //      
	{
		query(true);//    
		isNeedQuery = false;//     
	}
}

/**
 *      
 */
function init()      
{
	upTable = new SortTable();            
  upTable.setImage("../../../../images/");
  createTableHead(upTable, window.tableconf[0]);
  upTable.setOnRowSelectHandler(tableSelectHandler);
  $("upTableDiv").appendChild(upTable.getTable());
  upTable.setBodyHeight(getComponetHeight($("tableDiv"), 126)/2+"px");
  upTable.element.oncontextmenu = upPopupMenuHandler;//           
	upTable.setOnCellEditHandler(upTableCellEditHandler);

  belowTable = new SortTable();            
  belowTable.setImage("../../../../images/");
  createTableHead(belowTable, window.tableconf[1]);
  document.getElementById("belowTableDiv").appendChild(belowTable.getTable());
  belowTable.setBodyHeight(getComponetHeight($("tableDiv"), 126)/2+"px");
  belowTable.element.oncontextmenu = blowPopupMenuHandler;//           
	belowTable.setOnCellEditHandler(cellEditHandler);
  
  $("prochannel").appendChild(document.createTextNode(RESOURCE["protectiongroup"]));
  $("subprochannel").appendChild(document.createTextNode(RESOURCE["channel"]));
	$("startbtn").value = RESOURCE["start"];
  $("stopbtn").value = RESOURCE["stop"];
  $("querybtn").value = RESOURCE["query"];
  $("newbtn").value = RESOURCE["new"];
  $("deletebtn").value = RESOURCE["delete"];
  $("applybtn").value = RESOURCE["apply"];
  
  $("startbtn").disabled = true;
  $("stopbtn").disabled = true;
  $("deletebtn").disabled = true;
  $("applybtn").disabled = true;
}

/**
 *     upTable           
 * @param param    
 */  
function tableSelectHandler(param)
{
	if($("querybtn").disabled == true)//        
	{
		return;
	}
	belowTable.clearTableData();//       
	if(param.length == 0) //    
	{
		$("startbtn").disabled = true;
		$("stopbtn").disabled = true;
		$("deletebtn").disabled = true;
		$("applybtn").disabled = true;
	}
	else //       
	{
		$("startbtn").disabled = false;
		$("stopbtn").disabled = false;
		$("deletebtn").disabled = false;
		if(param.length == 1) //    
		{
			var owspID = upTable.getCellStoreValue(param[0],"owspid","owspid");//         ID  
			queryDetailInfo(owspID);//         
		}
	}
	
	var modifyFlag = false;
	for(var i = 0,size = upTable.getDataRowLength();i < size;i++)
	{
		if(upTable.getModify(i))
		{
			modifyFlag = true;
			break;
		}
	}
	if(!modifyFlag)
	{
		$("applybtn").disabled = true;
	}
}

/**
 *              xml  
 * @return    xml  
 */
function createQueryXML(isneedlog)
{
	var root = new inputxml("datainterface");
	var firstlevel = new tagElement("bussiness-params");
	var secondlevel = new tagElement("row-params");

	var thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","neid");
	thirdlevel.setAttribute("value",obj["neid"]);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","owspid");//   id   0      
	thirdlevel.setAttribute("value",0);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","svcdirection");//    ,  0     
	thirdlevel.setAttribute("value",0);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","isneedlog");//    ,  0     
	thirdlevel.setAttribute("value",isneedlog);
	secondlevel.appendChild(thirdlevel);		
	
	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);
	return root.toString();
}

/**
 *        
 */  
function query(isneedlog)
{
	$("startbtn").disabled = true;
  $("stopbtn").disabled = true;
	$("querybtn").disabled = true;
	$("applybtn").disabled = true;
	$("newbtn").disabled = true;
	$("deletebtn").disabled = true;
	
	var xml = createQueryXML(isneedlog);//       xml  
	var queryUrl = "../../../../neExlorerServlet?sfid="+TECMDCODE_QUERY_OWSPRING;
	loadXMLdoc(queryUrl,"POST",true,queryHandleBack,null,"inputdata="+xml);//    
}

/**
 *           
 * @param doc       
 */ 
function queryHandleBack(doc)
{
	var queryResult = EncapsulateData(doc);//       
	if(queryResult.getSErrorCode() != 0) //    
	{
		showQueryErrDlg(queryResult);
	}
	else //    
	{
		upTable.clearTableData();//       
		belowTable.clearTableData();//       
		for(var i = 0,size = queryResult.getDataRowLength();i < size;i++)
		{
			var wChannelInfo = queryResult.getDataRowParam(i,"wchannelinfo");//        
			var eChannelInfo = queryResult.getDataRowParam(i,"echannelinfo");//        
			var subChannelID = queryResult.getDataRowParam(i,"subchannelid");//     
			var subrack = queryResult.getDataRowParam(i,"subrack");//  
			var newParam = new ParamTag();
			newParam.value = RESOURCE["west"] + "(" + wChannelInfo + ")" + "->" + RESOURCE["east"] + "(" + eChannelInfo + ")" + ":" + subChannelID;
			queryResult.rows[i]["channelinfo"] = newParam; 
		}
		createTableBody(upTable, window.tableconf[0], queryResult, RESOURCE);//          
		addUpTableCellListener();//            
		registerWrtTimeEvent();
	}

	$("querybtn").disabled = false;
	$("newbtn").disabled = false;
}


/**
 *                xml  
 */  
function createQueryDetailXML(owspID)
{
	var root = new inputxml("datainterface");
	var firstlevel = new tagElement("bussiness-params");
	var secondlevel = new tagElement("row-params");

	var thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","neid");
	thirdlevel.setAttribute("value",obj["neid"]);
	secondlevel.appendChild(thirdlevel);

	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","owspid");//        id
	thirdlevel.setAttribute("value",owspID);
	secondlevel.appendChild(thirdlevel);
	
	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);
	return root.toString();
}

/**
 *             
 * @param owspID          id
 */  
function queryDetailInfo(owspID)
{
	var xml = createQueryDetailXML(owspID);//       xml  
	var queryDetailInfoUrl = "../../../../neExlorerServlet?sfid="+TECMDCODE_GET_OWSPRING;
	loadXMLdoc(queryDetailInfoUrl,"POST",false,queryDetailHandleBack,null,"inputdata="+xml);//         
}


/**
 *             
 * @param doc       
 */ 
function queryDetailHandleBack(doc)
{
	var queryResult = EncapsulateData(doc);//       
	belowTable.clearTableData();//       
	createTableBody(belowTable, window.tableconf[1], queryResult, RESOURCE);//          
	addBelowTableCellListener();
}


/**
 *       
 */ 
function newOWSP()
{
	xshowModalDialog("newowspdlg.html",RESOURCE["newowsp"],800,410,"../../../../images/");//            
}

/**
 *           xml  
 * @return    xml  
 */
function createDelXML()
{
	var root = new inputxml("datainterface");
	var firstlevel = new tagElement("bussiness-params");
	deleteRows = upTable.getSelectedRows();//           

	for(var i = 0,size = deleteRows.length;i < size;i++)
	{
		var secondlevel = new tagElement("row-params");
		var owspID = upTable.getCellStoreValue(deleteRows[i],"owspid","owspid");//          ID
		var channelInfo = upTable.getCellStoreValue(deleteRows[i],"channelinfo","channelinfo");
		
		var thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name","neid");
		thirdlevel.setAttribute("value",obj["neid"]);
		secondlevel.appendChild(thirdlevel);
		
		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name","owspid");
		thirdlevel.setAttribute("value",owspID);//    id
		secondlevel.appendChild(thirdlevel);
		
		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name","channel");
		thirdlevel.setAttribute("value",channelInfo);//    id
		secondlevel.appendChild(thirdlevel);	
			
		firstlevel.appendChild(secondlevel);
	}
	root.getRoot().appendChild(firstlevel);
	return root.toString();
}

/**
 *      
 */ 
function deleteOWSP()
{	
	var isDelete = confirm(RESOURCE["deleteowsptips"]);//     
	if(!isDelete)//      
	{
		return;
	}
	$("startbtn").disabled = true;
	$("stopbtn").disabled = true;
	$("querybtn").disabled = true;
	$("applybtn").disabled = true;
	$("newbtn").disabled = true;
	$("deletebtn").disabled = true;
	var xml = createDelXML();//       xml  
	var delUrl = "../../../../neExlorerServlet?sfid="+TECMDCODE_DEL_OWSPRING;
	loadXMLdoc(delUrl,"POST",false,delHandleBack,null,"inputdata="+xml);//       
}

/**
 *           
 * @param doc       
 */ 
function delHandleBack(doc)
{
	var delResult = EncapsulateData(doc);//       
	handleDelResult(delResult);//             
	if(delResult.getSErrorCode() != 0) //    
	{
		showModifyAndDelErrDlg(delResult);
		$("startbtn").disabled = false;
		$("stopbtn").disabled = false;
		$("deletebtn").disabled = false;
		var selectedRows = upTable.getSelectedRows();
		if(selectedRows.length == 1)
		{
			var owspID = upTable.getCellStoreValue(selectedRows[0],"owspid","owspid");//         ID
			queryDetailInfo(owspID);//         
		}
	}
	else
	{
		belowTable.clearTableData();
	}
	$("querybtn").disabled = false;
	$("newbtn").disabled = false;
}


/**
 *                
 * @param delResult            
 */
function handleDelResult(delResult)
{
	var rowErrorLength = delResult.getBErrLength();//          
	for(var i = deleteRows.length - 1;i >= 0;i--)
	{
		var isDeleteSuccess = true;//                
		var owspID = upTable.getCellStoreValue(deleteRows[i],"owspid","owspid");//         ID
		for(var j = 0;j < rowErrorLength - 1;j++)
		{
			var bErrCode = delResult.getBErrorCode();//           
			var failedID = delResult.getBErrParam(j, "owspid");//       owsp id      
			if(owspID == failedID) //         
			{
				isDeleteSuccess = false;//      
				break; //     
			}
		}
		if(isDeleteSuccess == true) //         
		{
			upTable.deleteRow(deleteRows[i]);//         
			otuInfoDataArr[owspID].clearOtu();;
		}
	}
	upTable.adjustDataRows();//      
}


/**
 *             xml  
 * @return    xml  
 */
function createModifyXML()
{
	var root = new inputxml("datainterface");
	var firstlevel = new tagElement("bussiness-params");
	
	var selectedRows = upTable.getSelectedRows();
	createUpTableXml(firstlevel);//        xml  
	if(selectedRows.length == 1)//     ,              
	{
		createBelowTableXml(firstlevel,selectedRows[0]);
	}
	root.getRoot().appendChild(firstlevel);
	return root.toString();
}


/**
 *               xml
 * @param firstlevel
 */
function createUpTableXml(firstlevel)
{
	for(var i = 0,size = upTable.getDataRowLength();i < size;i++)
	{
		if(!upTable.getModify(i)) //          
		{
			continue;
		}
		var secondlevel = new tagElement("row-params");
		createRowParam(i,secondlevel,"wrttime");
		createOtuInfoRowParam(i,secondlevel,"westotu");
		createOtuInfoRowParam(i,secondlevel,"eastotu");
		createRowParam(i,secondlevel,"sdflag");
		firstlevel.appendChild(secondlevel);	
	}
}

/**
 *        xml  
 * @param firstlevel
 * @param rowIndex   
 */
function createBelowTableXml(firstlevel,rowIndex)
{
	var owspID = upTable.getCellStoreValue(rowIndex,"owspid","owspid");
	for(var i = 0,size = belowTable.getDataRowLength();i < size;i++)
	{
		if(!belowTable.getCellModify(i,"delaytime")) //          
		{
			continue;
		}
		var secondlevel = new tagElement("row-params");
		var directValue = belowTable.getCellStoreValue(i,"svcdirection","svcdirection");
		
		var thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name","neid");
		thirdlevel.setAttribute("value",obj["neid"]);
		secondlevel.appendChild(thirdlevel);
							
		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name","owspid");
		thirdlevel.setAttribute("value",owspID);//   id
		secondlevel.appendChild(thirdlevel);
		
		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name","svcdirection");
		thirdlevel.setAttribute("value",directValue);
		secondlevel.appendChild(thirdlevel);
		
		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name","delaytime");
		thirdlevel.setAttribute("value",belowTable.getCellStoreValue(i,"delaytime","delaytime"));
		secondlevel.appendChild(thirdlevel);	
		firstlevel.appendChild(secondlevel);
	}	
}



/**
 *       
 * @param rowNum  
 * @param colID  id
 * @return     
 */
function createRowParam(rowNum,secondlevel,colID)
{
	var owspID = upTable.getCellStoreValue(rowNum,"owspid","owspid");
	if(upTable.getCellModify(rowNum,colID))
	{
		var thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name","neid");
		thirdlevel.setAttribute("value",obj["neid"]);
		secondlevel.appendChild(thirdlevel);
							
		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name","owspid");
		thirdlevel.setAttribute("value",owspID);//   id
		secondlevel.appendChild(thirdlevel);
		
		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name",colID);
		var value = upTable.getCellStoreValue(rowNum,colID,colID);
		if (colID == "wrttime")
		{
			value = convertMMSStoS(value);
		}
		thirdlevel.setAttribute("value",value);
		secondlevel.appendChild(thirdlevel);	
	}
}

/**
 *     otu     
 * @param rowNum  
 * @param colID  id
 * @return     
 */
function createOtuInfoRowParam(rowNum,secondlevel,colID)
{
	var owspID = upTable.getCellStoreValue(rowNum,"owspid","owspid");
	if(upTable.getCellModify(rowNum,colID))
	{
		var thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name","neid");
		thirdlevel.setAttribute("value",obj["neid"]);
		secondlevel.appendChild(thirdlevel);
			
		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name","owspid");
		thirdlevel.setAttribute("value",owspID);//   id
		secondlevel.appendChild(thirdlevel);
		
		var svcDirection = 1;//    :1-   2-  
		if(colID == "eastotu")//  
		{
			svcDirection = 2;
		}

		var outInfo = upTable.getCellStoreValue(rowNum,colID,colID);
		if(outInfo != RESOURCE["none"] && outInfo != "none")
		{
			thirdlevel = new tagElement("param");
			thirdlevel.setAttribute("name",colID);
			thirdlevel.setAttribute("value",svcDirection);
			secondlevel.appendChild(thirdlevel);		
				
			thirdlevel = new tagElement("param");
			thirdlevel.setAttribute("name",colID + "slotid");
			thirdlevel.setAttribute("value",getInfo(outInfo,true));
			secondlevel.appendChild(thirdlevel);	
		
			thirdlevel = new tagElement("param");
			thirdlevel.setAttribute("name",colID + "portid");
			thirdlevel.setAttribute("value",getInfo(outInfo,false));
			secondlevel.appendChild(thirdlevel);	
		}
		else
		{
			thirdlevel = new tagElement("param");
			thirdlevel.setAttribute("name","delbddirection_" + svcDirection);
			thirdlevel.setAttribute("value",svcDirection);
			secondlevel.appendChild(thirdlevel);
		}
		
		var otuAtom = upTable.getCellShow(rowNum,colID);
		var boardInfo = upTable.getAtomValue(otuAtom);
		thirdlevel = new tagElement("param");
		if(svcDirection == 1)
		{
			thirdlevel.setAttribute("name","wboardinfo");
		}
		else
		{
			thirdlevel.setAttribute("name","eboardinfo");
		}
		thirdlevel.setAttribute("value",boardInfo);
		secondlevel.appendChild(thirdlevel);
	}	
}


/**
 *            
 */
function modify()
{
	$("querybtn").disabled = true;
	$("applybtn").disabled = true;
	$("newbtn").disabled = true;
	$("deletebtn").disabled = true;
	$("startbtn").disabled = true;
	$("stopbtn").disabled = true;
	var xml = createModifyXML();//  xml  
	var modifyUrl = "../../../../neExlorerServlet?sfid="+TECMDCODE_SET_OWSPRING;
	loadXMLdoc(modifyUrl,"POST",false,modifyHandleBack,null,"inputdata="+xml);//             
}


/**
 *                
 * @param doc       
 */
function modifyHandleBack(doc)
{
	var modifyResult = EncapsulateData(doc);//       
	if(modifyResult.getSErrorCode() != 0) //    
	{
		showBoundAndSwitchErrDlg(modifyResult);
		$("applybtn").disabled = false;// "  "    
	}
	refreshTableState(upTable,window.tableconf[0],modifyResult);//        
	refreshTableState(belowTable,window.tableconf[1],modifyResult);//        
	$("querybtn").disabled = false;
	$("newbtn").disabled = false;
	var selectedRows = upTable.getSelectedRows();//           
	if(selectedRows.length != 0)
	{
		$("deletebtn").disabled = false;//          
		$("startbtn").disabled = false;
		$("stopbtn").disabled = false;
	}
}


/**
 *       otu   xml  
 * @param colid        otu
 * @return    xml  
 */
function createGetOTUListXML(colid)
{
	var selectOWSPID = upTable.getCellStoreValue(upTable.getSelectedRows()[0],"owspid","owspid");
	if(colid == "eastotu")
	{
		iswestout = 0;
	}
	else
	{
		iswestout = 1;
	}
	var root = new inputxml("datainterface"); //    datainterface    
	var firstlevel = new tagElement("bussiness-params"); //         
	
	var secondlevel = new tagElement("row-params"); //         
	var thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","neid");
	thirdlevel.setAttribute("value",obj["neid"]);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","owspid");
	thirdlevel.setAttribute("value",selectOWSPID);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","iswestout");
	thirdlevel.setAttribute("value",iswestout);
	secondlevel.appendChild(thirdlevel);	
	
	firstlevel.appendChild(secondlevel);//             
	
	root.getRoot().appendChild(firstlevel);//         
	return root.toString();
}

/**
 *     otu  
 */
function getOTUList(colid)
{
	var xml = createGetOTUListXML(colid);//     xml  
	var queryotuUrl = "../../../../neExlorerServlet?sfid="+TECMDCODE_GET_OWSP_OTU;
	loadXMLdoc(queryotuUrl,"POST",false,getOTUListHandleBack,null,"inputdata="+xml);//    OTU  (    )
}

/**
 *                
 * @param delResult            l
 */
function getOTUListHandleBack(doc)
{
	var rowIndex = upTable.getSelectedRows()[0];
	var cell;
	var cellShow;
	var colkey;
	var owspID = upTable.getCellStoreValue(rowIndex,"owspid","owspid");
	
	var getOTUResult = EncapsulateData(doc);//       
	if(getOTUResult.getSErrorCode() != 2)//       
	{
		otuInfoDataArr[owspID].clearOtu(iswestout);
		for(var i = 0,size = getOTUResult.getDataRowLength();i < size;i++)
		{
			var text = getOTUResult.getDataRowParam(i,"otuinfo");//3-SC2-1(RM1/TM1)   
			var value = getOTUResult.getDataRowParam(i,"otu");//3-1   
			if(iswestout == "1")//   otu
			{
				otuInfoDataArr[owspID].addWestOtu(text, value);
			}
			else
			{
				otuInfoDataArr[owspID].addEastOtu(text, value);
			}
		}
		
		var otuText = null;
		var otuValue = null;
		var otherColid = "westotu";
		if(iswestout == "1")//   otu
		{
			otuInfoDataArr[owspID].addWestOtu(RESOURCE["none"], RESOURCE["none"]);
			cell = upTable.getCell(rowIndex,"westotu");
			cellShow = upTable.getCellShow(rowIndex,"westotu");
			colkey = "westotu";
			otherColid = "eastotu";
			otuText = otuInfoDataArr[owspID].getWestOtuList()[0].text;
			otuValue = otuInfoDataArr[owspID].getWestOtuList()[0].value;
		}
		else
		{
			otuInfoDataArr[owspID].addEastOtu(RESOURCE["none"], RESOURCE["none"]);
			cell = upTable.getCell(rowIndex,"eastotu");
			cellShow = upTable.getCellShow(rowIndex,"eastotu");
			colkey = "eastotu";
			otuText = otuInfoDataArr[owspID].getEastOtuList()[0].text;
			otuValue = otuInfoDataArr[owspID].getEastOtuList()[0].value;
		}

		upTable.setAtomValue(cellShow,otuText);
		upTable.setCellValue(cell,colkey,otuValue);
		cell.element.style.backgroundColor = "#d0f946";
		cell.element.modify = true;
		upTable.element.datarows[rowIndex].element.modify = true;
		otuChanged(otuValue,colkey,otherColid);
		$("applybtn").disabled = false;
	}
 
}

/**
 *       /     xml  
 * @param isStart      
 * @return    xml  
 */
function createProtocolCtrlXML(isStart)
{
	var root = new inputxml("datainterface");
	var firstlevel = new tagElement("bussiness-params");
	var selectedRows = upTable.getSelectedRows();//           
	for(var i = 0; i < selectedRows.length;i++)
	{
		var secondlevel = new tagElement("row-params");
		var owspID = upTable.getCellStoreValue(selectedRows[i],"owspid","owspid");//         ID
		
		var thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name","neid");
		thirdlevel.setAttribute("value",obj["neid"]);
		secondlevel.appendChild(thirdlevel);
		
		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name","owspid");
		thirdlevel.setAttribute("value",owspID);
		secondlevel.appendChild(thirdlevel);

		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name","isstart");
		thirdlevel.setAttribute("value",isStart);
		secondlevel.appendChild(thirdlevel);
		
		firstlevel.appendChild(secondlevel);
	}
	root.getRoot().appendChild(firstlevel);
	return root.toString();//       
}

/**
 *     otu  
 * @param isStart        
 */
function protocolCtrl(isStart)
{
	if(isStart == 0)//    
	{
		var isStop = confirm(RESOURCE["stoptips"]);//       
		if(!isStop)
		{
			return;
		}
	}
	$("startbtn").disabled = true;
	$("stopbtn").disabled = true;
	var xml = createProtocolCtrlXML(isStart);//  xml  
	var protocolCtrlUrl = "../../../../neExlorerServlet?sfid="+TECMDCODE_SET_OWSP_PROTOCOL;
	loadXMLdoc(protocolCtrlUrl,"POST",true,protocolCtrlHandleBack,null,"inputdata="+xml);//    OTU  (    )
}

function protocolCtrlHandleBack(doc)
{
	var result = EncapsulateData(doc);//       
	if(result.getSErrorCode() != 0) //    
	{
		showModifyAndDelErrDlg(result);
	}
	var selectedRows = upTable.getSelectedRows();//           
	if(selectedRows.length != 0)
	{
		$("startbtn").disabled = false;
		$("stopbtn").disabled = false;
	}
}

/**
 *     ID        
 * @param isBound  /       
 */
function boundSpanID(isBound)
{
	if(isBound == false)//     ID
	{
		doBoundSpanID(0);//    0        ID
	}
	else //    ID
	{
		hideMenu();
		xshowModalDialog("boundspaniddlg.html",RESOURCE["bound"],215,125,"../../../../../../images/");//      ID    
	}
}

/**
 *       /     xml  
 * @param spanID   ID  
 * @return    xml  
 */
function createBoundXML(spanID)
{
	var selectedowspRows = upTable.getSelectedRows();//           
	var owspID = upTable.getCellStoreValue(selectedowspRows[0],"owspid","owspid");//       ID
	var selectedDirRows = belowTable.getSelectedRows();//           
	var direction = belowTable.getCellStoreValue(selectedDirRows[0],"svcdirection","svcdirection");//      
	if(direction > 2)//          
	{
		direction = 2;//2    
	}
	
	var root = new inputxml("datainterface");
	var firstlevel = new tagElement("bussiness-params");
	
	var secondlevel = new tagElement("row-params");
	
	var thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","neid");
	thirdlevel.setAttribute("value",obj["neid"]);
	secondlevel.appendChild(thirdlevel);

	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","owspid");
	thirdlevel.setAttribute("value",owspID);
	secondlevel.appendChild(thirdlevel);

	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","svcdirection");
	thirdlevel.setAttribute("value",direction);
	secondlevel.appendChild(thirdlevel);

	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","spanid");
	thirdlevel.setAttribute("value",spanID);
	secondlevel.appendChild(thirdlevel);
		
	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);
	return root.toString();//       
}

/**
 *     /     ID
 * @param spanID   ID
 */
function doBoundSpanID(spanID)
{
	isBoundSuccess = false;//    
	var xml = createBoundXML(spanID);//     xml  
	var boundUrl = "../../../../neExlorerServlet?sfid="+TECMDCODE_BIND_SECTIONID;
	loadXMLdoc(boundUrl,"POST",false,boundHandleBack,spanID,"inputdata="+xml);//    
}

/**
 *     ID     
 * @param doc        
 */
function boundHandleBack(doc, spanID)
{
	var boundResult = EncapsulateData(doc);//       
	if(boundResult.getSErrorCode() != 0) //    
	{
		showBoundAndSwitchErrDlg(boundResult);
	}
	else //    
	{
		isBoundSuccess = true;//    
		var rowIndex = belowTable.getSelectedRows()[0];
		belowTable.setCellValue(belowTable.getCell(rowIndex, "spanid"), "spanid", spanID);
		belowTable.getCellShow(rowIndex, "spanid").element.innerHTML = convertNum(spanID);
	}
}

/**
 *            xml  
 * @param switchingType        
 * @return    xml  
 */
function createSwitchingXML(switchingType)
{
	var selectedowspRows = upTable.getSelectedRows();//           
	var owspID = upTable.getCellStoreValue(selectedowspRows[0],"owspid","owspid");//       ID
	var selectedDirRows = belowTable.getSelectedRows();//           
	var direction = belowTable.getCellStoreValue(selectedDirRows[0],"svcdirection","svcdirection");//      
	if(direction <= 2)//  
	{
		direction = 1;
	}
	else//  
	{
		direction = 2;
	}
	var root = new inputxml("datainterface");
	var firstlevel = new tagElement("bussiness-params");
	var secondlevel = new tagElement("row-params");
	
	var thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","neid");
	thirdlevel.setAttribute("value",obj["neid"]);
	secondlevel.appendChild(thirdlevel);

	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","owspid");
	thirdlevel.setAttribute("value",owspID);
	secondlevel.appendChild(thirdlevel);

	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","svcdirection");
	thirdlevel.setAttribute("value",direction);
	secondlevel.appendChild(thirdlevel);

	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","switchtype");
	thirdlevel.setAttribute("value",switchingType);
	secondlevel.appendChild(thirdlevel);	
	
	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);
	return root.toString();//       
}

/**
 *         
 * @param switchingType        
 */
function switching(switchingType)
{
	hideMenu();

	if(switchingType == "22")//R8,          
	{
		var isSwitch = confirm(RESOURCE["lockconfirm"]);
		if(!isSwitch)
		{
			return;
		}
	}

	if(switchingType == "14")
	{
		var isSwitch = confirm(RESOURCE["switchconfirm"]);
		if(!isSwitch)
		{
			return;
		}
	}
	var xml = createSwitchingXML(switchingType); //  xml  
	var switchUrl = "../../../../neExlorerServlet?sfid="+TECMDCODE_SET_OWSP_SWITCH;
	loadXMLdoc(switchUrl,"POST",false,switchingHandleBack,null,"inputdata="+xml);//    
}

/**
 *              
 * @param doc        
 */
function switchingHandleBack(doc)
{
	var boundResult = EncapsulateData(doc);//       
	if(boundResult.getSErrorCode() == 0) //    
	{
		alert(RESOURCE["switchsuccess"]);//                     
	}
	else //    
	{
		showBoundAndSwitchErrDlg(boundResult);
	}
}



/**
 *                 
 * @param selectObj      select  
 * @param isSlot          true  false 
 * @return      
 */
function getInfo(obj, isSlot)
{
	var infoArr = obj.split("-");
	if(isSlot)
	{
		return infoArr[0];//     
	}
	return infoArr[1];//     
}

/**
 *      
 */  
window.onresize=function()
{
	upTable.setBodyHeight(getComponetHeight($("tableDiv"), 126)/2+"px");
	belowTable.setBodyHeight(getComponetHeight($("tableDiv"), 126)/2+"px");
}

/**
 *          
 */
function cellEditHandler()
{
	$("applybtn").disabled = false;//         
}

/**
 *            
 */
function addUpTableCellListener()
{
	otuInfoDataArr.clear();
	var owspID = null;
	for(var i = 0,size = upTable.getDataRowLength();i < size;i++)
	{
		owspID = upTable.getCellStoreValue(i,"owspid","owspid");
		var westotuAtomValue = upTable.getAtomValue(upTable.getCellShow(i,"westotu"));		
		var eastotuAtomValue = upTable.getAtomValue(upTable.getCellShow(i,"eastotu"));
		otuInfoDataArr[owspID] = new OtuInfoData();
			
		if((westotuAtomValue != null && westotuAtomValue != RESOURCE["none"]) || (eastotuAtomValue != null && eastotuAtomValue != RESOURCE["none"]))
		{
			var sdFlagCell = upTable.getCellElement(i,"sdflag");
			sdFlagCell.style.backgroundColor = "#ffffff";
			sdFlagCell.ondblclick = cellondbclick;
			upTable.setCellIsEdit(upTable.getCell(i,"sdflag"),1);	
		}
		else
		{
			upTable.setCellIsEdit(upTable.getCell(i,"sdflag"),0);	
		}
		if(westotuAtomValue != RESOURCE["none"])
		{
			otuInfoDataArr[owspID].addWestOtu(westotuAtomValue, upTable.getCellStoreValue(i, "westotuid", "westotuid"));
		}
		if(eastotuAtomValue != RESOURCE["none"])
		{
			otuInfoDataArr[owspID].addEastOtu(eastotuAtomValue, upTable.getCellStoreValue(i, "eastotuid", "eastotuid"));
		}
		otuInfoDataArr[owspID].addWestOtu(RESOURCE["none"], RESOURCE["none"]);
		otuInfoDataArr[owspID].addEastOtu(RESOURCE["none"], RESOURCE["none"]);
	}
	var westotuAtom = upTable.getCellEdit(0,"westotu");
	var eastotuAtom = upTable.getCellEdit(0,"eastotu");	
	if(westotuAtom != null)
	{
		westotuAtom.element.onchange = westOtuChanged;
	}
	if(eastotuAtom != null)
	{
		eastotuAtom.element.onchange = eastOtuChanged;
	}
}


/**
	           
*/
function upTableCellEditHandler(param)
{
	if(param.colid != "westotu" && param.colid != "eastotu")
	{
		$("applybtn").disabled = false;
		return;
	}
	if(param.stage == TABLE_CONSTANT.BEFOREEDIT)
	{
		var owspID = upTable.getCellStoreValue(param.rowindex,"owspid","owspid");
		var otuData = otuInfoDataArr[owspID];
		if(otuData != null)
		{
			var otuArray = null;
			if(param.colid == "westotu")
			{
				otuArray = otuData.getWestOtuList();
			}
			if(param.colid == "eastotu")
			{
				otuArray = otuData.getEastOtuList();
			}
					
			var colAtom = upTable.getCellEdit(param.rowindex,param.colid);
			colAtom.clearOptions();
			for(var i = 0,len = otuArray.length;i < len;i++)
			{
				colAtom.addOption(otuArray[i].text,otuArray[i].value);
			}
		}
	}
	$("applybtn").disabled = false;
}


function westOtuChanged()
{
	var selectedValue = this.options[this.selectedIndex].value;
	otnChangedSecond(selectedValue,"eastotu");
}

function eastOtuChanged()
{
	var selectedValue = this.options[this.selectedIndex].value;
	otnChangedSecond(selectedValue,"westotu");	
}
function otnChangedSecond(selectedValue,colid)
{
	var selectedRow = upTable.getSelectedRows()[0];
	if(selectedValue == RESOURCE["none"])
	{
		var otuInfo = upTable.getAtomValue(upTable.getCellShow(selectedRow,colid));
		if(otuInfo == RESOURCE["none"])
		{
			setSDFlagCellIsEdite(selectedRow,0);
		}
	}
	else
	{
		setSDFlagCellIsEdite(selectedRow,1);
	}	
}

function otuChanged(selectedValue,colid,otherColid)
{
	var selectedRow = upTable.getSelectedRows()[0];
	if(selectedValue == RESOURCE["none"])
	{
		var otuInfo = upTable.getAtomValue(upTable.getCellShow(selectedRow,colid));
		var otherOtu = upTable.getAtomValue(upTable.getCellShow(selectedRow,otherColid));
		if(otuInfo == RESOURCE["none"] && otherOtu == RESOURCE["none"])
		{
			setSDFlagCellIsEdite(selectedRow,0);
		}
	}
	else
	{
		setSDFlagCellIsEdite(selectedRow,1);
	}	
}

function setSDFlagCellIsEdite(row,isEdite)
{
	var sdFlagCell = upTable.getCellElement(row,"sdflag");
	upTable.setCellIsEdit(upTable.getCell(row,"sdflag"),isEdite);
	if(isEdite == 1)
	{
		sdFlagCell.style.backgroundColor = "#ffffff";
		sdFlagCell.ondblclick = cellondbclick;
	}			
	else
	{
		sdFlagCell.style.backgroundColor = "";
		sdFlagCell.modify = false;
		sdFlagCell.ondblclick = null;
	}
}

/**
 *            
 */
function addBelowTableCellListener()
{
	for(var i = 0,size = belowTable.getDataRowLength();i < size;i++)
	{
		var delayTimeCellEdit = belowTable.getCellEdit(i,"delaytime");
		checkDataCellEvent(delayTimeCellEdit.element, 0, 100);
	}
}

/**
 *             
 */
function upPopupMenuHandler(evt)
{
	removejsDOMmenu();
	if(!evt)
	{
	  evt= window.event;	
	} 
	var elem = (evt.target) ? evt.target : evt.srcElement;   
	if(elem!= null&&elem.blur)
	{
		elem.blur();	  	
	}  
	while(elem!=null)
	{
		if(elem.tagName == 'TD')
		{
		    break;	
		}
		else
		{
		 elem =elem.parentNode;	  	
		}	
	} 
	if(elem == null || elem.tagName != 'TD' || null == elem.parent)
	{ 
		return;
	}  
	 
	var rowid = elem.parentNode.rowIndex;
	var rows = elem.parent.getSelectedRows();
	var colid = elem.colid;
	if(rows.contains(rowid))
	{
		if(colid != "westotu" && colid != "eastotu")
		{
			if(null != elem.editElement && elem.isEdit == 1)
			{
				createTablePopupMenu(elem,evt);
				return;
			}
			for(var i = 0; i < rows.length; i++)
			{
				var tmpElem = elem.parent.getCellElement(rows[i],colid);
				if(null != tmpElem.editElement && tmpElem.isEdit == 1)
				{
					createTablePopupMenu(tmpElem,evt);
					return;
				}
			}
		}
		else
		{
			createRefreshPopupMenu(rows,evt,colid);    	
		}
	}
}

/**
 *        otu     
 */
function createRefreshPopupMenu(rows,evt,colid)
{
	if(rows.length > 1)//           
	{
		return;
	}	
	var menuLength = 130;
	if(sysLanguage == "en")
	{
		menuLength = 145;
	}
	var cursorMenu1 = new jsDOMenu(menuLength); 
	cursorMenu1.addMenuItem(new menuItem(RESOURCE["refreshOTU"],"",getOTUList,colid));
	setPopUpMenu(cursorMenu1);
	showMenu(evt); 
}

/**
 *          
 * @param evt
 */
function blowPopupMenuHandler(evt)
{
	removejsDOMmenu();
	if(!evt)
	{
	  evt= window.event;	
	} 
	var elem = (evt.target) ? evt.target : evt.srcElement;   
	if(elem!= null&&elem.blur)
	{
		elem.blur();	  	
	}  
	while(elem!=null)
	{
		if(elem.tagName == 'TD')
		{
		    break;	
		}
		else
		{
		 elem =elem.parentNode;	  	
		}	
	} 
	if(elem == null || elem.tagName != 'TD' || null == elem.parent)
	{ 
		return;
	}  
	 
	var rowid = elem.parentNode.rowIndex;
	var rows = elem.parent.getSelectedRows();
	var colid = elem.colid;
	if(rows.contains(rowid))
	{
		if(null != elem.editElement && elem.isEdit == 1)
		{
			createTablePopupMenu(elem,evt);
			return;
		}
		for(var i = 0; i < rows.length; i++)
		{
			var tmpElem = elem.parent.getCellElement(rows[i],colid);
			if(null != tmpElem.editElement && tmpElem.isEdit == 1)
			{
				createTablePopupMenu(tmpElem,evt);
				return;
			}
		}
		createFuncPopupMenu(rows,evt);    	
	}
}

/**
 *            
 */
function createFuncPopupMenu(rows,evt)
{
	var boudMenuEnable = false;//    ID      
	var unBoudMenuEnable = false;//     ID      
	var lockAndClearMenuEanble = true;//           
	var switchMenuEanble = true;//          
	if(rows.length > 1)//           
	{
		lockAndClearMenuEanble = false;
		switchMenuEanble = false;		
	}	
	else
	{
		var direciton = belowTable.getCellStoreValue(rows[0],"svcdirection","svcdirection");
		if(direciton % 2 == 0)//     
		{
			switchMenuEanble = false;
		}
		var spanID = belowTable.getCellStoreValue(rows[0],"spanid","spanid");
		if( spanID > 0)
		{
			unBoudMenuEnable = true;
		}
		else if(spanID == 0)
		{
			boudMenuEnable = true;
		}
	}
	
	var menuLength = 130;
	if(sysLanguage == "en")
	{
		menuLength = 185;
	}
	var aCursorMenu = new jsDOMenu(menuLength); 
	aCursorMenu.addMenuItem(new menuItem(RESOURCE["bound"],"",boundSpanID,true,boudMenuEnable));
	aCursorMenu.addMenuItem(new menuItem(RESOURCE["unbound"],"",boundSpanID,false,unBoudMenuEnable));
	aCursorMenu.addMenuItem(new menuItem("-",""));
	aCursorMenu.addMenuItem(new menuItem(RESOURCE["lock"],"",switching,"22",lockAndClearMenuEanble));
	aCursorMenu.addMenuItem(new menuItem(RESOURCE["ForceToWorking"],"",switching,"14",switchMenuEanble));
	aCursorMenu.addMenuItem(new menuItem(RESOURCE["ForceToProtection"],"",switching,"8",switchMenuEanble));
	aCursorMenu.addMenuItem(new menuItem(RESOURCE["ManualToProtection"],"",switching,"3",switchMenuEanble));
	aCursorMenu.addMenuItem(new menuItem("-",""));
	aCursorMenu.addMenuItem(new menuItem(RESOURCE["clear"],"",switching,"23",lockAndClearMenuEanble));
	setPopUpMenu(aCursorMenu);
	showMenu(evt); 	
}


/**
 *            
 */
function convertMsg(res,obj,key)
{
	if("function" == (typeof obj))	
	{
		return obj(key);
	}
	else
	{
		if(null == obj)
		{
			return key;
		}
		var resValue = RESOURCE[obj[key]];
		if(null == resValue)
		{
			resValue = key;
		}		
		return resValue;
	}
}

/**
 *     
 * @param objValue        
 * @return        
 */
function convertNum(objValue)
{
	if(objValue == 0)
	{
		return RESOURCE["none"];
	}
	return objValue;
}

function convertOTU(objValue)
{
	if(objValue == null || objValue == "none")
	{
		return RESOURCE["none"];
	}
	return objValue;
}

/**
 *     s mm:ss  , 65(s)    01:05
 */
function convertWtrTime(wtrTime)
{
 if (isNaN(wtrTime) || wtrTime == "" || wtrTime == null || typeof(wtrTime) == "undefined" || parseInt(wtrTime) == 0)
 {
     return "-";
 }
 else
 {
 	var mm = parseInt(wtrTime/60,10);
 	var ss = wtrTime%60;
 	mm = mm.toString();
 	ss = ss.toString();
 	if(mm.length<2)
 	{
 		mm = "0" + mm;
 	}
 	if(ss.length<2)
 	{
 		ss = "0" + ss;
   }
   return mm+":"+ss;
 }
}

/**
 *     mm:ss s, 06:02    362(s)
 */
function convertMMSStoS(wrttime)
{
	if(wrttime == "-")
	{
		return 0;
	}
	var temparr = wrttime.split(":");
	var mm = parseInt(temparr[0],10);
	var ss = parseInt(temparr[1],10);
	
	return (mm * 60) + ss;
}

/**
 *       id
 * @return              id
 */
function getMinAvailableID()
{
	for(var i = 1;i < 65535;i++)
	{
		var isUsed = false;//           ID     
		for(var j = 0,size = upTable.getDataRowLength();j < size;j++)
		{
			var owspID = upTable.getCellStoreValue(j,"owspid","owspid");//          ID
			if(owspID == i) 
			{
				var isUsed = true; //  ID    
				break; //      
			}
		}
		if(isUsed == false) // ID    
		{
			return i; //         ID
		}
	}
}

function showQueryErrDlg(result)
{
	var errArr = [];
	errArr[0] = "nename";
	var tempArr = result.getError().rowErrors;
	var size = result.getBErrLength();
	for(var i = 0;i < size;i++)
	{
		var tempObj = tempArr[i].errorObj;
		tempObj["queryowsp"] = RESOURCE["queryowsp"];
		errArr[1] = "queryowsp";
	}
	openErrPage("../../../../page/", result.getError(), errArr);
}

function showModifyAndDelErrDlg(result)
{
	var errArr = [];
	errArr[0] = "nename";
	var tempArr = result.getError().rowErrors;
	var size = result.getBErrLength();
	for(var i = 0;i < size;i++)
	{
		var tempObj = tempArr[i].errorObj;
		if(tempObj["owspid"] != null)
		{
			tempObj["owspid"] = RESOURCE["owspid"] + tempObj["owspid"];
			errArr[1] = "owspid";
		}		
	}
	openErrPage("../../../../page/", result.getError(), errArr);
}

function showBoundAndSwitchErrDlg(result)
{
	var errArr = [];
	errArr[0] = "nename";
	var tempArr = result.getError().rowErrors;
	var size = result.getBErrLength();
	for(var i = 0;i < size;i++)
	{
		var tempObj = tempArr[i].errorObj;
		if(tempObj["owspid"] != null)
		{
			tempObj["owspid"] = RESOURCE["owspid"] + tempObj["owspid"];
			errArr[1] = "owspid";
		}
		if(tempObj["svcdirection"] != null)
		{
			tempObj["svcdirection"] = RESOURCE["direction"] + RESOURCE[direct[tempObj["svcdirection"]]];
			errArr[2] = "svcdirection";
		}
		if(tempObj["westotu"])
		{
			tempObj["westotu"] = RESOURCE["setbddirection_1"];
			errArr[errArr.length] = "westotu";			
		}
		if(tempObj["eastotu"])
		{
			tempObj["eastotu"] = RESOURCE["setbddirection_2"];
			errArr[errArr.length] = "eastotu";			
		}		
		if(tempObj["delbddirection_1"])
		{
			tempObj["delbddirection_1"] = RESOURCE["delbddirection_1"];
			errArr[errArr.length] = "delbddirection_1";			
		}	
		if(tempObj["delbddirection_2"])
		{
			tempObj["delbddirection_2"] = RESOURCE["delbddirection_2"];
			errArr[errArr.length] = "delbddirection_2";			
		}					
	}
	openErrPage("../../../../page/", result.getError(), errArr);
}

function OtuInfoData()
{
	this.westOtuList = new Array();
	this.eastOtuList = new Array();
	
	this.getWestOtuList = function()
	{
		return this.westOtuList;
	}
	
	this.getEastOtuList = function()
	{
		return this.eastOtuList;
	}
	
	this.addWestOtu = function(text, value)
	{
		var otuInfo = new Object();
		otuInfo.text = text;
		otuInfo.value = value;
		this.westOtuList.push(otuInfo);
	}
	
	this.addEastOtu = function(text, value)
	{
		var otuInfo = new Object();
		otuInfo.text = text;
		otuInfo.value = value;
		this.eastOtuList.push(otuInfo);
	}
	
	this.clearOtu = function(iswestout)
	{
		if(iswestout == "1")
		{
			this.westOtuList.clear();
		}
		else if(iswestout == "0")
		{
			this.eastOtuList.clear();
		}
		else
		{
			this.westOtuList.clear();
			this.eastOtuList.clear();
		}
	}
}

/*
 *            
 *
 */
function registerWrtTimeEvent()
{
    var atom;
    var textelement;
    for (var i = 0, len = upTable.getDataRowLength(); i < len; i++) 
    {
        atom = upTable.getCellEdit(i, "wrttime");
        textelement = atom.element;
        tenCellEvent(textelement, ":");
        textelement.maxLength = 5;
        
        atom.element.onblur = function()
        {
            var textvar = this.value;
            if (textvar == "" || textvar.length != 5 || textvar.indexOf(":") == -1) 
            {
                alert(RESOURCE["wrong5"] + MINWTRTIME + RESOURCE["wrong2"] + MAXWTRTIME + RESOURCE["wrong4"]);
                this.value = REVERTIVWTRTIME;
            }
            else 
            {
                var temparr = textvar.split(":");
                var mm = parseInt(temparr[0], 10);
                var ss = parseInt(temparr[1], 10);
                
                if (mm > 59 || ss > 59) 
                {
                    alert(RESOURCE["wrong5"] + MINWTRTIME + RESOURCE["wrong2"] + MAXWTRTIME + RESOURCE["wrong4"]);
                    this.value = REVERTIVWTRTIME;
                }
                else 
                {
                    var timevar = (mm * 60) + ss;
                    if (timevar < MINWTRVALUE) 
                    {
                        alert(RESOURCE["wrong5"] + MINWTRTIME + RESOURCE["wrong2"] + MAXWTRTIME + RESOURCE["wrong4"]);
                        this.value = MINWTRTIME;
                    }
                    if (timevar > MAXWTRVALUE) 
                    {
                        alert(RESOURCE["wrong5"] + MINWTRTIME + RESOURCE["wrong2"] + MAXWTRTIME + RESOURCE["wrong4"]);
                        this.value = MAXWTRTIME;
                    }
                }
            }
            
            cellonblur(this);
        }
    }
}
