
loadXMLdoc("../../../../conf/system.xml", "GET", false, EncapsulateSConf);
getResourse("../../../../res/commonres_" + SYSTEMCONF.getLanguage() + ".xml");
getResourse("../../res/opticalpower_bd05/opticalpower_"+SYSTEMCONF.getLanguage()+".xml");
loadXMLdoc("../../conf/opticalpower_bd05/opticalpowertable_" + SYSTEMCONF.getLanguage() + ".xml","GET", false, EncapsulateTable);
	
var winobj = getNeProperty(self);
var opTable = null;
var btnRightArr = new Object();

var MIN_INPUT = '-60.0';
var MAX_INPUT = '50.0';

var UN_SUPPORT_STR_VALUE = "-"; //   
var UNKNOWN_STR_VALUE = "/"; //   

function initBody()
{
	initButton();
	initTable();
	if (btnRightArr.querybtn.right)
	{
		sendQueryPowerReq(TECMDCODE_GET_POWER_FROM_NM);
	}
}

function initButton()
{
	$("querybtn").value = RESOURCE["querybutton"];
	$("applybtn").value = RESOURCE["applybutton"];
	
	btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_GET_W32PORTATTRIB);
	btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_SET_W32PORTATTRIB);
    getRightInfo(winobj, btnRightArr);      
    initrightbtn(btnRightArr);
    $("applybtn").disabled = true;
}

/**
 *         
 */
function initTable()
{
	$("label").innerText = RESOURCE["optitle"];
	opTable = new SortTable();
	opTable.setImage("../../../../images/");
    createTableHead(opTable, window.tableconf[0]); 
    opTable.setBodyWidth(window.tableconf[0].width,window.tableconf[0].percent,0);
    opTable.setBodyHeight("540px");
	opTable.setOnCellEditHandler(cellEditHandler);
	$("table").appendChild(opTable.getTable());
}


function cellEditHandler(param)
{
	$("applybtn").disabled = !btnRightArr.applybtn.right;
	
	var rowIndex = param.rowindex;
	if(param.stage == TABLE_CONSTANT.BEFOREEDIT)
	{
		checkCellValue(rowIndex);
	}
	if(param.stage == TABLE_CONSTANT.AFTEREDIT)
	{   
		handleRelation(rowIndex);
	}
}



function checkCellValue(rowIndex)
{
	if(rowIndex == ATTR_INPOW_REVALUE)
	{
		textCheck(opTable.getCellElement(rowIndex, "value").editElement.element, MIN_INPUT, MAX_INPUT);
	}
	if(rowIndex == ATTR_OUTPOW_REVALUE)
	{
	   textCheck(opTable.getCellElement(rowIndex, "value").editElement.element,  MIN_INPUT, MAX_INPUT);
	}
	
	if(rowIndex == ATTR_INPOW_LOWTHRESHOLD)
	{
		var minInputLow = opTable.getCellStoreValue(ATTR_INPOW_LOWTHRESHOLD_MIN, "value", "value"); //        
		var maxInputLow = opTable.getCellStoreValue(ATTR_INPOW_LOWTHRESHOLD_MAX, "value", "value"); //        
		if (null != minInputLow && UN_SUPPORT_STR_VALUE != minInputLow && UNKNOWN_STR_VALUE != minInputLow)
		{
			textCheck(opTable.getCellElement(rowIndex, "value").editElement.element, minInputLow, maxInputLow);
		}
		else
		{
			textCheck(opTable.getCellElement(rowIndex, "value").editElement.element,  MIN_INPUT, MAX_INPUT);
		}
	}
	if(rowIndex == ATTR_INPOW_HIGHTHRESHOLD)
	{
		var minInputHigh = opTable.getCellStoreValue(ATTR_INPOW_HIGHTHRESHOLD_MIN, "value", "value"); //        
		var maxInputHigh = opTable.getCellStoreValue(ATTR_INPOW_HIGHTHRESHOLD_MAX, "value", "value"); //        
		if (null != minInputHigh && UN_SUPPORT_STR_VALUE != minInputHigh && UNKNOWN_STR_VALUE != minInputHigh)
		{
			textCheck(opTable.getCellElement(rowIndex, "value").editElement.element, minInputHigh, maxInputHigh);
		}
		else
		{
			textCheck(opTable.getCellElement(rowIndex, "value").editElement.element,  MIN_INPUT, MAX_INPUT);
		}
	}
	if(rowIndex == ATTR_INPOW_REF_LOWTHRESHOLD)
	{
		textCheck(opTable.getCellElement(rowIndex, "value").editElement.element,  MIN_INPUT, MAX_INPUT);
	}
	if(rowIndex == ATTR_INPOW_REF_HIGHTHRESHOLD)
	{
		textCheck(opTable.getCellElement(rowIndex, "value").editElement.element,  MIN_INPUT, MAX_INPUT);
	}
	
	if(rowIndex == ATTR_OUTPOW_LOWTHRESHOLD)
	{
		textCheck(opTable.getCellElement(rowIndex, "value").editElement.element,  MIN_INPUT, MAX_INPUT);
	}
	
	if(rowIndex== ATTR_OUTPOW_HIGHTHRESHOLD)
	{
		textCheck(opTable.getCellElement(rowIndex, "value").editElement.element, MIN_INPUT, MAX_INPUT);
	}
	if(rowIndex == ATTR_OUTPOW_REF_LOWTHRESHOLD)
	{
		textCheck(opTable.getCellElement(rowIndex, "value").editElement.element,  MIN_INPUT, MAX_INPUT);
	}
	
	if(rowIndex== ATTR_OUTPOW_REF_HIGHTHRESHOLD)
	{
		textCheck(opTable.getCellElement(rowIndex, "value").editElement.element, MIN_INPUT, MAX_INPUT);
	}
	if(rowIndex == ATTR_INPOW_CFP_LOWTHRESHOLD)
	{
		var minInputLow = opTable.getCellStoreValue(ATTR_INPOW_CFP_LOWTHRESHOLD_MIN, "value", "value"); //CFP        
		var maxInputLow = opTable.getCellStoreValue(ATTR_INPOW_CFP_LOWTHRESHOLD_MAX, "value", "value"); //CFP        
		if (null != minInputLow && UN_SUPPORT_STR_VALUE != minInputLow && UNKNOWN_STR_VALUE != minInputLow)
		{
			textCheck(opTable.getCellElement(rowIndex, "value").editElement.element, minInputLow, maxInputLow);
		}
		else
		{
			textCheck(opTable.getCellElement(rowIndex, "value").editElement.element, MIN_INPUT, MAX_INPUT);
		}
	}
	if(rowIndex == ATTR_INPOW_CFP_HIGHTHRESHOLD)
	{
		var minInputLow = opTable.getCellStoreValue(ATTR_INPOW_CFP_HIGHTHRESHOLD_MIN, "value", "value"); //CFP        
		var maxInputLow = opTable.getCellStoreValue(ATTR_INPOW_CFP_HIGHTHRESHOLD_MAX, "value", "value"); //CFP        
		if (null != minInputLow && UN_SUPPORT_STR_VALUE != minInputLow && UNKNOWN_STR_VALUE != minInputLow)
		{
			textCheck(opTable.getCellElement(rowIndex, "value").editElement.element, minInputLow, maxInputLow);
		}
		else
		{
			textCheck(opTable.getCellElement(rowIndex, "value").editElement.element, MIN_INPUT, MAX_INPUT);
		}
	}
}

/**
 *                      
 */
function handleRelation(rowIndex)
{
	/**
	 *                                                         3 5 
     *                                                          
     */
	if(rowIndex == ATTR_INPOW_REVALUE)
	{
		var value = opTable.getCellStoreValue(rowIndex, "value", "value"); 
		setReferDefaultValue(ATTR_INPOW_REF_LOWTHRESHOLD,  (parseFloat(value)-5.0).toFixed(1));
		setReferDefaultValue(ATTR_INPOW_REF_HIGHTHRESHOLD, (parseFloat(value)+3.0).toFixed(1));
	}
	if(rowIndex == ATTR_OUTPOW_REVALUE)
	{
		var value = opTable.getCellStoreValue(rowIndex, "value", "value"); 
		setReferDefaultValue(ATTR_OUTPOW_REF_LOWTHRESHOLD,  (parseFloat(value)-5.0).toFixed(1));
		setReferDefaultValue(ATTR_OUTPOW_REF_HIGHTHRESHOLD, (parseFloat(value)+3.0).toFixed(1));
	}
}

/*
 *                 
 */
function  setReferDefaultValue(rowIndex, defaultvalue)
{
	var value = opTable.getCellStoreValue(rowIndex, "value", "value"); 
	if (value == UNKNOWN_STR_VALUE)
	{
		if (parseFloat(defaultvalue) < parseFloat(MIN_INPUT))
	    {
			opTable.setCellValue(opTable.getCell(rowIndex,"value"), "value", MIN_INPUT);
			opTable.setAtomValue(opTable.getCellShow(rowIndex,"value"), MIN_INPUT);
			opTable.setCellModify(rowIndex, "value", true);
	    }
		else if (parseFloat(defaultvalue) > parseFloat(MAX_INPUT))
	    {
			opTable.setCellValue(opTable.getCell(rowIndex,"value"), "value", MAX_INPUT);
			opTable.setAtomValue(opTable.getCellShow(rowIndex,"value"), MAX_INPUT);
			opTable.setCellModify(rowIndex, "value", true);
	    }
		else
	    {
			opTable.setCellValue(opTable.getCell(rowIndex,"value"), "value", defaultvalue);
			opTable.setAtomValue(opTable.getCellShow(rowIndex,"value"), defaultvalue);
			opTable.setCellModify(rowIndex, "value", true);
	    }
	}
}


function sendQueryPowerReq(sfid)
{
	var urlreq = "../../../../neExlorerServlet?sfid=" + sfid + "&nmUser=" + winobj["nmUser"];
	var inputData = createQueryXML();
	$("querybtn").disabled = true;
	loadXMLdoc(urlreq, "POST", true, handleQueryPowerRsp, null, "inputdata=" + inputData);
}

function createQueryXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", winobj["neid"]);
	row.appendChild(param);
    
	param = new tagElement("param");
	param.setAttribute("name", "slotid");
	param.setAttribute("value", winobj["slotid"]);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "portid");
	param.setAttribute("value", winobj["portid"]);
	row.appendChild(param);

	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}


function handleQueryPowerRsp(doc)
{
	$("querybtn").disabled = !btnRightArr.querybtn.right;
	$("portName").innerHTML = "";
	opTable.clearTableData();
	var data = EncapsulateData(doc);
	if (data.getDataRowLength() == 0)
	{
		return;
	}
	$("portName").appendChild(document.createTextNode(RESOURCE["port"]+ data.getDataRowParam(0,"portname")));
	var isEditInPowLow = data.getDataRowParam(0,"canminbeEdit");//             
	var isEditInPowHigh = data.getDataRowParam(0,"canmaxbeEdit"); //             
	var isEditOutPowLow = data.getDataRowParam(0,"canminOutbeEdit"); //             
	var isEditOutPowHigh = data.getDataRowParam(0,"canmaxOutbeEdit"); //             
	var isEditInPowRefLow = data.getDataRowParam(0,"canminWorkbeEdit"); //               
	var isEditInPowRefHigh = data.getDataRowParam(0,"canmaxWorkbeEdit"); //               
	var isEditOutPowRefLow = data.getDataRowParam(0,"canminRefOutbeEdit"); //               
	var isEditOutPowRefHigh = data.getDataRowParam(0,"canmaxRefOutbeEdit"); //                
	var isEditInPowCFPLow = data.getDataRowParam(0,"canCFPMinBeEdit"); 
	var isEditInPowCFPHigh = data.getDataRowParam(0,"canCFPMaxBeEdit"); 
	
	data.removeDataRowAt(0);
	createTableBody(opTable,window.tableconf[0],data, RESOURCE);

	var inPowStat= opTable.getCellStoreValue(ATTR_INPOW_REVALUE, "value", "value");
	if (null != inPowStat && "-" != inPowStat)
	{
		opTable.setCellIsEdit(opTable.getCell(ATTR_INPOW_REVALUE, "value"),  1);
	}
	else 
	{
	    opTable.setCellIsEdit(opTable.getCell(ATTR_INPOW_REVALUE, "value"), 0);
	}
	
	var outPowStat= opTable.getCellStoreValue(ATTR_OUTPOW_REVALUE, "value", "value");
	if (null != outPowStat && "-" != outPowStat)
	{
		opTable.setCellIsEdit(opTable.getCell(ATTR_OUTPOW_REVALUE, "value"),  1);
	}
	else 
	{
	    opTable.setCellIsEdit(opTable.getCell(ATTR_OUTPOW_REVALUE, "value"), 0);
	}
	
	var inPowLow= opTable.getCellStoreValue(ATTR_INPOW_LOWTHRESHOLD, "value", "value");
	if (null != inPowLow && "-" != inPowLow)
	{
		opTable.setCellIsEdit(opTable.getCell(ATTR_INPOW_LOWTHRESHOLD, "value"),  isEditInPowLow==1?0:1);
	}
	else 
	{
	    opTable.setCellIsEdit(opTable.getCell(ATTR_INPOW_LOWTHRESHOLD, "value"), 0);
	}
	var inPowHigh= opTable.getCellStoreValue(ATTR_INPOW_HIGHTHRESHOLD, "value", "value");
	if (null != inPowHigh && "-" != inPowHigh)
	{
		opTable.setCellIsEdit(opTable.getCell(ATTR_INPOW_HIGHTHRESHOLD, "value"), isEditInPowHigh==1?0:1);//
	}
	else
	{
		opTable.setCellIsEdit(opTable.getCell(ATTR_INPOW_HIGHTHRESHOLD, "value"), 0);
	}
		
	var outPowLow= opTable.getCellStoreValue(ATTR_OUTPOW_LOWTHRESHOLD, "value", "value");
	if (null != outPowLow && "-" != outPowLow)
	{
		opTable.setCellIsEdit(opTable.getCell(ATTR_OUTPOW_LOWTHRESHOLD, "value"), isEditOutPowLow==1?0:1);
	}
	else
	{
		opTable.setCellIsEdit(opTable.getCell(ATTR_OUTPOW_LOWTHRESHOLD, "value"), 0);
	}
		
	var outPowHigh= opTable.getCellStoreValue(ATTR_OUTPOW_HIGHTHRESHOLD, "value", "value");
	if (null != outPowHigh && "-" != outPowHigh)
	{
		opTable.setCellIsEdit(opTable.getCell(ATTR_OUTPOW_HIGHTHRESHOLD, "value"), isEditOutPowHigh==1?0:1);
	}
	else
	{
	    opTable.setCellIsEdit(opTable.getCell(ATTR_OUTPOW_HIGHTHRESHOLD, "value"), 0);
	}
		
	var inPowRefLow= opTable.getCellStoreValue(ATTR_INPOW_REF_LOWTHRESHOLD, "value", "value");
	if (null != inPowRefLow && "-" != inPowRefLow)
	{
		opTable.setCellIsEdit(opTable.getCell(ATTR_INPOW_REF_LOWTHRESHOLD, "value"), isEditInPowRefLow==1?0:1);
	}
	else
	{
	    opTable.setCellIsEdit(opTable.getCell(ATTR_INPOW_REF_LOWTHRESHOLD, "value"), 0);
	}
		
	var inPowRefHigh= opTable.getCellStoreValue(ATTR_INPOW_REF_HIGHTHRESHOLD, "value", "value");
	if (null != inPowRefHigh && "-" != inPowRefHigh)
	{
		opTable.setCellIsEdit(opTable.getCell(ATTR_INPOW_REF_HIGHTHRESHOLD, "value"), isEditInPowRefHigh==1?0:1);
	}
	else
	{
		opTable.setCellIsEdit(opTable.getCell(ATTR_INPOW_REF_HIGHTHRESHOLD, "value"), 0);
	}
		
	var outPowRefLow= opTable.getCellStoreValue(ATTR_OUTPOW_REF_LOWTHRESHOLD, "value", "value");
	if (null != outPowRefLow && "-" != outPowRefLow)
	{
		opTable.setCellIsEdit(opTable.getCell(ATTR_OUTPOW_REF_LOWTHRESHOLD, "value"), isEditOutPowRefLow==1?0:1);
	}
	else
    {
	    opTable.setCellIsEdit(opTable.getCell(ATTR_OUTPOW_REF_LOWTHRESHOLD, "value"), 0);
	}
		
	var outPowRefHigh= opTable.getCellStoreValue(ATTR_OUTPOW_REF_HIGHTHRESHOLD, "value", "value");
	if (null != outPowRefHigh && "-" != outPowRefHigh)
	{
		opTable.setCellIsEdit(opTable.getCell(ATTR_OUTPOW_REF_HIGHTHRESHOLD, "value"), isEditOutPowRefHigh==1?0:1);
	}
	else 
    {
		opTable.setCellIsEdit(opTable.getCell(ATTR_OUTPOW_REF_HIGHTHRESHOLD, "value"), 0);
	}
		
	opTable.setCellIsEdit(opTable.getCell(ATTR_INPOW, "value"), 0);
	opTable.setCellIsEdit(opTable.getCell(ATTR_INPOW_RETIME, "value"), 0);
	opTable.setCellIsEdit(opTable.getCell(ATTR_INPOW_STATE, "value"), 0);
	opTable.setCellIsEdit(opTable.getCell(ATTR_INPOW_LOWTHRESHOLD_MIN, "value"), 0);
	opTable.setCellIsEdit(opTable.getCell(ATTR_INPOW_LOWTHRESHOLD_MAX, "value"), 0);
	opTable.setCellIsEdit(opTable.getCell(ATTR_INPOW_HIGHTHRESHOLD_MIN, "value"), 0);
	opTable.setCellIsEdit(opTable.getCell(ATTR_INPOW_HIGHTHRESHOLD_MAX, "value"), 0);
	
	opTable.setCellIsEdit(opTable.getCell(ATTR_OUTPOW, "value"), 0);
	opTable.setCellIsEdit(opTable.getCell(ATTR_OUTPOW_RETIME, "value"), 0);
	opTable.setCellIsEdit(opTable.getCell(ATTR_OUTPOW_STATE, "value"), 0);
	
	var inPowCFPLow= opTable.getCellStoreValue(ATTR_INPOW_CFP_LOWTHRESHOLD, "value", "value");
	if (null != inPowCFPLow && "-" != inPowCFPLow)
	{
		opTable.setCellIsEdit(opTable.getCell(ATTR_INPOW_CFP_LOWTHRESHOLD, "value"),  isEditInPowCFPLow==1?0:1);
	}
	else 
	{
	    opTable.setCellIsEdit(opTable.getCell(ATTR_INPOW_CFP_LOWTHRESHOLD, "value"), 0);
	}
	opTable.setCellIsEdit(opTable.getCell(ATTR_INPOW_CFP_LOWTHRESHOLD_MIN, "value"), 0);
	opTable.setCellIsEdit(opTable.getCell(ATTR_INPOW_CFP_LOWTHRESHOLD_MAX, "value"), 0);
	
	var inPowCFPHigh= opTable.getCellStoreValue(ATTR_INPOW_CFP_HIGHTHRESHOLD, "value", "value");
	if (null != inPowCFPHigh && "-" != inPowCFPHigh)
	{
		opTable.setCellIsEdit(opTable.getCell(ATTR_INPOW_CFP_HIGHTHRESHOLD, "value"),  isEditInPowCFPHigh==1?0:1);
	}
	else 
	{
	    opTable.setCellIsEdit(opTable.getCell(ATTR_INPOW_CFP_HIGHTHRESHOLD, "value"), 0);
	}
	opTable.setCellIsEdit(opTable.getCell(ATTR_INPOW_CFP_HIGHTHRESHOLD_MIN, "value"), 0);
	opTable.setCellIsEdit(opTable.getCell(ATTR_INPOW_CFP_HIGHTHRESHOLD_MAX, "value"), 0);
	
	opTable.setCellIsEdit(opTable.getCell(ATTR_INPOW_CFP_CURRENT_VALLEY, "value"), 0);
	opTable.setCellIsEdit(opTable.getCell(ATTR_INPOW_CFP_CURRENT_PEAK, "value"), 0);
	
	refreshPowerState();
	showErrorDialog(data);
}

function refreshPowerState()
{
    var statevalue = opTable.getCellStoreValue(ATTR_INPOW_STATE,"value","value");
    if (statevalue != UN_SUPPORT_STR_VALUE && statevalue != UNKNOWN_STR_VALUE)
    {
       opTable.getCellElement(ATTR_INPOW_STATE,"value").style.backgroundColor = STATE_COLOR[statevalue];
       opTable.setAtomValue(opTable.getCellShow(ATTR_INPOW_STATE,"value"), RESOURCE[statevalue]);
    }
    statevalue = opTable.getCellStoreValue(ATTR_OUTPOW_STATE,"value","value");
    if (statevalue != UN_SUPPORT_STR_VALUE && statevalue != UNKNOWN_STR_VALUE)
    {
       opTable.getCellElement(ATTR_OUTPOW_STATE,"value").style.backgroundColor = STATE_COLOR[statevalue];
       opTable.setAtomValue(opTable.getCellShow(ATTR_OUTPOW_STATE,"value"), RESOURCE[statevalue]);
    }
}


function sendSetPowerReq()
{
	if (!checkValue())
    {
       return
    }
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SAVE_CURRENT_STDPOW + "&nmUser=" + winobj["nmUser"];
	var inputData = createSetPowerXML();
	if (null != inputData)
	{
		$("applybtn").disabled = true;
		loadXMLdoc(urlreq, "POST", true, handleSetPowerRsp, null, "inputdata=" + inputData);
	}
}

function checkValue()
{
	var inPowLow= opTable.getCellStoreValue(ATTR_INPOW_LOWTHRESHOLD, "value", "value");
	var inPowHigh= opTable.getCellStoreValue(ATTR_INPOW_HIGHTHRESHOLD, "value", "value");
    if (!checkLowHighValueRelation(inPowLow, inPowHigh))
    {
        return false;
    }
	var outPowLow= opTable.getCellStoreValue(ATTR_OUTPOW_LOWTHRESHOLD, "value", "value");
	var outPowHigh= opTable.getCellStoreValue(ATTR_OUTPOW_HIGHTHRESHOLD, "value", "value");
    if (!checkLowHighValueRelation(outPowLow, outPowHigh))
    {
        return false;
    }

	var inRefValue= opTable.getCellStoreValue(ATTR_INPOW_REVALUE, "value", "value");
	var inPowRefLow= opTable.getCellStoreValue(ATTR_INPOW_REF_LOWTHRESHOLD, "value", "value");
	var inPowRefHigh= opTable.getCellStoreValue(ATTR_INPOW_REF_HIGHTHRESHOLD, "value", "value");
	
    if (!checkReferValue(inRefValue, inPowRefLow, inPowRefHigh, true))
    {
        return false;
    }
    
	var outRefValue= opTable.getCellStoreValue(ATTR_OUTPOW_REVALUE, "value", "value");
	var outPowRefLow= opTable.getCellStoreValue(ATTR_OUTPOW_REF_LOWTHRESHOLD, "value", "value");
	var outPowRefHigh= opTable.getCellStoreValue(ATTR_OUTPOW_REF_HIGHTHRESHOLD, "value", "value");
	
    if (!checkReferValue(outRefValue, outPowRefLow, outPowRefHigh, false))
    {
        return false;
    }
    
	var inPowCFPLow= opTable.getCellStoreValue(ATTR_INPOW_CFP_LOWTHRESHOLD, "value", "value");

	var inPowCFPHigh= opTable.getCellStoreValue(ATTR_INPOW_CFP_HIGHTHRESHOLD, "value", "value");
    if (!checkLowHighValueRelation(inPowCFPLow, inPowCFPHigh))
    {
        return false;
    }
    return true;
}



function checkLowHighValueRelation(lowValue, highValue)
{
    if (UNKNOWN_STR_VALUE ==lowValue || UN_SUPPORT_STR_VALUE==lowValue
            || UNKNOWN_STR_VALUE==highValue || UN_SUPPORT_STR_VALUE==highValue)
    {
        return true;
    }

    if (parseFloat(lowValue) > parseFloat(highValue))
    {
    	alert(RESOURCE["INPUT_ERR_HILOW"]);
        return false;
    }

    return true;
}


/**
 *         (   )         
 * @param    
 * @param     
 * @param     
 * @param         true:  , false:  
 */
function checkReferValue(value, lowValue, highValue, isIn)
{
    if ((lowValue!=UNKNOWN_STR_VALUE) && (lowValue != UN_SUPPORT_STR_VALUE)
            && (highValue != UNKNOWN_STR_VALUE) && (highValue != UN_SUPPORT_STR_VALUE))
    {
        if (parseFloat(lowValue) >= parseFloat(highValue))
        {
        	alert(RESOURCE["INPUT_ERR_HILOW"]);
            return false;
        }
    }
    if ((((value != UNKNOWN_STR_VALUE) && (value!=UN_SUPPORT_STR_VALUE)
            && (lowValue!= UNKNOWN_STR_VALUE) && (lowValue != UN_SUPPORT_STR_VALUE)) && (parseFloat(value) < parseFloat(lowValue)))
      ||(((value != UNKNOWN_STR_VALUE) && (value!=UN_SUPPORT_STR_VALUE)
            && (highValue!= UNKNOWN_STR_VALUE) && (highValue!=UN_SUPPORT_STR_VALUE)) && (parseFloat(value) > parseFloat(highValue))))
    {
        var resKey = "ERR_REFVALUE_RANGE";
        if (isIn)
        {
            resKey += "_IN";
        }
        else
        {
            resKey += "_OUT";
        }
        alert(RESOURCE[resKey]);
        
        return false;
    }
    return true;
}


function createSetPowerXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", winobj["neid"]);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "slotid");
	param.setAttribute("value", winobj["slotid"]);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "portid");
	param.setAttribute("value", winobj["portid"]);
	row.appendChild(param);
    
	var isModify = false;
	var opDesc = "";
	for ( var rowindex = 0, rowlen = opTable.getDataRowLength(); rowindex < rowlen; rowindex++)
    {
		if ((rowindex ==ATTR_INPOW_RETIME)||(rowindex ==ATTR_INPOW_STATE)
				||(rowindex ==ATTR_OUTPOW_RETIME)||(rowindex ==ATTR_OUTPOW_STATE))
	    {
			continue;
	    }
		if (opTable.getModify(rowindex))
		{
			isModify = true;
		}
		var cellModifyFlag = opTable.getCellModify(rowindex, "value");
		
		param = new tagElement("param");
		param.setAttribute("name", attrId[rowindex]);
		
		var value = opTable.getCellStoreValue(rowindex, "value", "value");	
		if(value == "/" || value == "-")
		{
			param.setAttribute("value", value);
		}
		else
		{
			param.setAttribute("value", value*10);
		}
		param.setAttribute("modifyFlag", cellModifyFlag);
		row.appendChild(param);
		
		opDesc += RESOURCE[attrId[rowindex]]+ ":" + value + ";";
	}
    param = new tagElement("param");		
	param.setAttribute("name","opDesc");
    param.setAttribute("value",opDesc);   
    row.appendChild(param);	
	bussiness.appendChild(row);
	
	if (!isModify)
	{
		alert(RESOURCE["osinochange"]);
		return null;
	}
	else
	{
		if (!confirm(RESOURCE["POWER_THRESHOLD"]))
		{
			return null;
		}
	}
	
	di.getRoot().appendChild(bussiness);
	return di.toString();
}


function handleSetPowerRsp(doc)
{
	var data = EncapsulateData(doc);
	for(var i = 0, len = data.getDataRowLength(); i < len; i++)
	{
		var attribute = data.getDataRowParam(i,"attribute");
		var value = data.getDataRowParam(i,"value");
		var index = attrIndex[attribute];
		if(index != null && index >0)
	    {
			opTable.setCellValue(opTable.getCell(index,"value"), "value", value);
			opTable.setAtomValue(opTable.getCellShow(index,"value"), value);
	    }
	}
	refreshPowerState();
	refreshTableState(opTable, window.tableconf[0], data);
	showErrorDialog(data);
}

function showErrorDialog(dinterface)
{
	var errArr = [];
	errArr[0] = "nename";

	var nologin = false;
	var size = dinterface.getBErrLength();
	var sortErrArr = false;
	for ( var i = 0; i <size; i++)
	{
		var rowErrors = dinterface.getError().rowErrors[i];
		var tempObj = rowErrors.errorObj;

		tempObj["nename"] = tempObj["nename"] + "-" + tempObj["boardname"] + "-" + tempObj["portname"]
					+ "-" + RESOURCE[tempObj["attrId"]];
		
		if (nologin == true)
		{
			tempObj["nename"] = tempObj["nename"] + "-" + tempObj["boardname"]+ "-" + tempObj["portname"];
			errArr.length = 2;
			break;
		}

	}

	openErrPage("../../../../page/", dinterface.getError(), errArr);
}

