 //  URL  
var winurlobj;

var win = getParentWindow();

var TTI_TEXT_MODE = 0;
var TTI_HEX_MODE = 1;
var curmode = TTI_TEXT_MODE;

var SM_TTI_MODE_AUTO = 1;

document.title = RESOURCE["ophbyte"];

/**
 *      
 * @param  
 * @return  
 */	
function initBody()
{
	$("okbtn").value=RESOURCE["okbutton"];
	$("canclebtn").value=RESOURCE["cancelbutton"]; 
	$("textmodelText").innerHTML = RESOURCE["textmodel"];
	$("hexmodelText").innerHTML = RESOURCE["hexmodel"];
	$("srcflagText").innerHTML = RESOURCE["srcflag"];
	$("sinkflagText").innerHTML = RESOURCE["sinkflag"];
	$("userflagText").innerHTML = RESOURCE["userflag"];
	
	winurlobj = getNeProperty(self);
	var srcflag = winurlobj["srcflag"];
	var sinkflag = winurlobj["sinkflag"];
	var userflag = winurlobj["userflag"];	
	
	$("srcState").value = hex2Text(srcflag.substring(0,6),true);
	$("srcFlag").value = hex2Text(srcflag.substring(6),true);
	$("sinkState").value = hex2Text(sinkflag.substring(0,6),true);
	$("sinkFlag").value = hex2Text(sinkflag.substring(6),true);
	$("userFlag").value	= hex2Text(userflag,true);
	if(winurlobj["displaymode"] == TTI_HEX_MODE)
	{
		$("textmodel").checked = false;
		$("hexmodel").checked = true;
	}
	else
	{
		$("textmodel").checked = true;
		$("hexmodel").checked = false;
	}
	
	showModelChanged();
	handleTextEvent($("srcState"));
	handleTextEvent($("srcFlag"));
	handleTextEvent($("sinkState"));
	handleTextEvent($("sinkFlag"));
	handleTextEvent($("userFlag"));
	
	if (winurlobj["colid"] == "OTN_SM_ST_TTI" && SM_TTI_MODE_AUTO == winurlobj["smttimode"])
	{
		$("userFlag").disabled = true;
		alert(RESOURCE["tti_auto_alert"]);
	}
	else
	{
		$("userFlag").disabled = false;
	}
}

/**
 *       
 * @param  
 * @return  
 */			
function showModelChanged()
{
	if(TTI_TEXT_MODE != curmode && $("textmodel").checked)
	{		
		$("srcState").maxLength = "3";
		$("srcFlag").maxLength = "12";
		$("sinkState").maxLength = "3";
		$("sinkFlag").maxLength = "12";
		$("userFlag").maxLength = "32";
		$("srcState").value = hex2Text($("srcState").value);
		$("srcFlag").value = hex2Text($("srcFlag").value);
		$("sinkState").value = hex2Text($("sinkState").value);
		$("sinkFlag").value = hex2Text($("sinkFlag").value);
		$("userFlag").value	= hex2Text($("userFlag").value);
		curmode = TTI_TEXT_MODE;	
	}
	else if(TTI_HEX_MODE != curmode && $("hexmodel").checked)
	{		
		$("srcState").maxLength = "8";
		$("srcFlag").maxLength = "35";
		$("sinkState").maxLength = "8";
		$("sinkFlag").maxLength = "35";
		$("userFlag").maxLength = "95";	
		$("srcState").value = text2Hex($("srcState").value);
		$("srcFlag").value = text2Hex($("srcFlag").value);		
		$("sinkState").value = text2Hex($("sinkState").value);		
		$("sinkFlag").value = text2Hex($("sinkFlag").value);		
		$("userFlag").value	= text2Hex($("userFlag").value);	
		curmode = TTI_HEX_MODE;	
	}
}

/**
 *         
 * @param  
 * @return  
 */
function okBtnActionPerform()
{
	var ttiByte = "";
	var srcState = $("srcState").value;
	var srcFlag = $("srcFlag").value;
	var sinkState = $("sinkState").value;
	var sinkFlag = $("sinkFlag").value;	
	var userFlag = $("userFlag").value;
	if(TTI_HEX_MODE == curmode)
	{
		srcState = hex2Text($("srcState").value);		
		srcFlag = hex2Text($("srcFlag").value);
		sinkState = hex2Text($("sinkState").value);
		sinkFlag = hex2Text($("sinkFlag").value);	
		userFlag = hex2Text($("userFlag").value);
	}
	if("" != srcFlag)
	{
		for(var i = 0,len = 3-srcState.length; i < len; i++)	
		{
			srcState+=hex2Text("00");
		}
	}
	
	if("" != sinkFlag)
	{
		for(var i = 0,len = 3-sinkState.length; i < len; i++)	
		{
			sinkState+=hex2Text("00");
		}
	}
	srcFlag = srcState + srcFlag;
	sinkFlag = sinkState + sinkFlag;
	userFlag = userFlag;
	
	if (checkContainChinese(srcFlag) || checkContainChinese(sinkFlag) || checkContainChinese(userFlag))
	{
		win.hasChineseCharFlag = true;
	}
	else
	{
		win.hasChineseCharFlag = false;
	}
	win.refreshCellValue(srcFlag,sinkFlag,userFlag);
	xcloseDialog();
}

/**
 *         
 * @param  
 * @return  
 */
function cancleBtnActionPerform()
{
	xcloseDialog();
}

/**
 *        
 * @param obj     
 * @return  
 */
function handleTextEvent(obj)
{
	if(isIE)
	{
		obj.onkeydown = function()
		{
			var event=EventUtil.getEvent();
			var code = event.keyCode;
	    if(code>255)
	    {
	    	event.returnValue=false;
	    	return false;
	    }
			if(TTI_TEXT_MODE == curmode)
			{		
				return;	
			}
			hexTextKeyDownCheck(this);
		}
		obj.onkeypress = function()
		{
			var event=EventUtil.getEvent();
			var code = event.keyCode;
	    if(code>255)
	    {
	    	event.returnValue=false;
	    	return false;
	    }
		}
  }
  else
  {
		obj.onkeypress = function()
		{
			if(TTI_TEXT_MODE == curmode)
			{		
				return;	
			}
			hexTextKeyPressCheck(this);
	  }
  }
}

function checkContainChinese(str)
{
    for(i=0;i<str.length;i++)
    {
        if(str.charCodeAt(i) > 256)
        {
	        return true;
	    }        
    }
    return false;
}
