
var win = getDialogParentWindow();

document.title = RESOURCE["filtercondition"];

var FBSMTypeName = [];
FBSMTypeName["832"] = "ODU0";
FBSMTypeName["829"] = "OTU1";
FBSMTypeName["823"] = "OTU2";
FBSMTypeName["820"] = "OTU3";
FBSMTypeName["838"] = "OTU4";
FBSMTypeName["841"] = "ODUflex";
FBSMTypeName["807"] = "OTU5G";
FBSMTypeName["880"] = "OTU1";
FBSMTypeName["810"] = "OTU1";
FBSMTypeName["804"] = "OTU2";
FBSMTypeName["801"] = "OTU3";
FBSMTypeName["844"] = "OTUCn";

var FBPMTypeName = [];
FBPMTypeName["832"] = "ODU0";
FBPMTypeName["829"] = "ODU1";
FBPMTypeName["823"] = "ODU2";
FBPMTypeName["820"] = "ODU3";
FBPMTypeName["838"] = "ODU4";
FBPMTypeName["841"] = "ODUflex";
FBPMTypeName["880"] = "ODU1";
FBPMTypeName["807"] = "ODU5G";  

FBPMTypeName["810"] = "ODU1"; 
FBPMTypeName["804"] = "ODU2"; 
FBPMTypeName["801"] = "ODU3"; 
FBPMTypeName["844"] = "ODUCn";

var FBOPUTypeName = [];
FBOPUTypeName["832"] = "OPU0";
FBOPUTypeName["829"] = "OPU1";
FBOPUTypeName["823"] = "OPU2";
FBOPUTypeName["820"] = "OPU3";
FBOPUTypeName["838"] = "OPU4";
FBOPUTypeName["841"] = "OPUflex";
FBOPUTypeName["880"] = "OPU1";
FBOPUTypeName["807"] = "OPU5G";

FBOPUTypeName["810"] = "OPU1"; 
FBOPUTypeName["804"] = "OPU2"; 
FBOPUTypeName["801"] = "OPU3"; 
FBOPUTypeName["844"] = "OPUCn";

var GRADE_ODU0 = "5"; // ODU0   
var isSupportODUTsModeFlag = false; //        

var GradeList = null;

var CurrentFilterRes = [];

var ExcExistPath = null;

function getFBTypeName()
{
	if (win.queryOTNfid == TE_FUNC_CFG_SM_OVERHEAD)
	{
		return FBSMTypeName;
	}
	else if(win.queryOTNfid == TE_FUNC_CFG_OPU_OVERHEAD)
	{
		return FBOPUTypeName;
	}
	else
	{
		return FBPMTypeName;
	}
}

function isTCMOverHead()
{
	return (win.queryOTNfid == TE_FUNC_CFG_TCM_OVERHEAD);
}

/**
 *      
 * @param  
 * @return  
 */	
function initBody()
{
	$("okbtn").value=RESOURCE["okbutton"];
	$("canclebtn").value=RESOURCE["cancelbutton"];
	getAvailableRes();
	if(isTCMOverHead())
	{
		$("fdTcmGrade").style.display= "";
		$("spPathExc").style.display = "";
		initFilterCondition();
		queryExcExistPath();
	}
	else
	{
		$("fdTcmGrade").style.display= "none";
		$("spPathExc").style.display = "none";
		initFilterCondition();
		doPortSelected(true);
		doGradeSelected();
		doTcmSelected();
	}
}

function initFilterCondition()
{
    var portfbtypes = null;
    GradeList = [];
    var fbtypeList = [];
    
    for (var index = 0, len = CurrentFilterRes.length; index < len; index++) 
    {
        portfbtypes = CurrentFilterRes[index];
        for (var i = 0; i < portfbtypes.gradeList.length; i++) 
        {
            if (GradeList.indexOf(portfbtypes.gradeList[i]) == -1) 
            {
                GradeList[GradeList.length] = portfbtypes.gradeList[i];
                fbtypeList[fbtypeList.length] = portfbtypes.fbtypeList[i];
            }
        }
    }
    
    sortByGrade(GradeList, fbtypeList);
    
    initPort();
    initGrade(GradeList, fbtypeList);
    initTCMGrade();
    
    var height = document.body.clientHeight - ($("dvGrade").offsetHeight + 60) - 120;

    if ($("fdTcmGrade").style.display != "none") 
    {
        height = height - ($("dvTcmgrade").offsetHeight + 60)
    }
    if ($("dvPort").offsetHeight < height) 
    {
        height = document.body.clientHeight - (height - $("dvPort").offsetHeight);
        if (isIE) 
        {
            if (navigator.userAgent.indexOf("MSIE 6") >= 0) 
            {
                height = height + 40;
            }
            window.dialogHeight = height + "px";
        }
        else 
        {
			
            window.parent.resizeTo(height + 60);
        }
    }
    
    adjustLayout();
}


function adjustLayout()
{
	var height = document.body.clientHeight - ($("dvGrade").offsetHeight + 60) - 120;
	if (!isIE) 
	{
		height = height - 20;
	}
	if($("fdTcmGrade").style.display != "none")
	{
		height = height - ($("dvTcmgrade").offsetHeight + 60)
	}
	height = (height < 30)?30:height;
	$("dvPort").style.height = height;
	if(!isIE)
	{
		var width = document.body.clientWidth - 36;
		$("dvPort").parentNode.style.width = width;
		$("dvGrade").parentNode.style.width = width;
		$("dvTcmgrade").parentNode.style.width = width;
		$("dvBtn").style.width = width + 29;
	}
}

window.onresize = function()
{
	adjustLayout();
}

function sortByGrade(GradeList,fbtypeList)
{
	if(GradeList.length<=1)
	{
		return;
	}
	
	for(var i=0,iLength=GradeList.length;i<iLength;i++)
	{
		for(var j=i+1,jLength=GradeList.length;j<jLength;j++)
		{
			if(getFBTypeName()[fbtypeList[i]]>getFBTypeName()[fbtypeList[j]])
			{
				var t = GradeList[i];
				GradeList[i] = GradeList[j];
				GradeList[j] = t;
				t = fbtypeList[i];
				fbtypeList[i] = fbtypeList[j];
				fbtypeList[j] = t;
			}
		}
	}
}

function getPortType(port)
{
	var portfbtypes = null;
	for (var index = 0, len = CurrentFilterRes.length; index < len; index++) 
    {
    	portfbtypes = CurrentFilterRes[index];
    	if(portfbtypes.port == port)
    	{
    		break;
    	}
    }
    return portfbtypes;
}

function doFilter()
{
	var selectedGrades = getSelectedGrades();
	var selectedPorts = getSelectedPorts(selectedGrades);
	if(selectedPorts.length == 0)
	{
		alert(RESOURCE["filterselectport"]);
		return;
	}
	
	if(selectedGrades.length == 0)
	{
		alert(RESOURCE["filterselectgrade"]);
		return;
	}
	var selectedTcmGrades = getSelectedTCMGrades();
	if(selectedTcmGrades.length == 0)
	{
		alert(RESOURCE["filterselecttcm"]);
		return;
	}
	if(getSelectedPortPathNumber() > 600)
	{
		var titleres = (isTCMOverHead()?"filtererrortcmtitle":"filtererrortitle");
		alert(RESOURCE[titleres]);
		return
	}
	win.doFilter(selectedPorts,selectedGrades,selectedTcmGrades,$("cbPathExcSelect").checked);

	xcloseDialog();

}
function xcloseWindow()
{
	xcloseDialog();
}

/**
 *         
 */
function initPort()
{
	var tmpTable = document.createElement("table");
	tmpTable.width = "100%";
	var curRow =  null;
	var rowIndex = 0;
	var tdIndex = 0;
	var portfbtypes = null;

	for (var index = 0, len = CurrentFilterRes.length; index < len; index++) 
    {
    	if((index) % 3 == 0)
		{
			curRow = tmpTable.insertRow(rowIndex);
			tdIndex = 0;
			rowIndex++;
		}
    	portfbtypes = CurrentFilterRes[index];
    	var isCheck = "";
    	if((win.filterCondition.selectedPorts.length == 0 && index == 0)
    			|| isContainPortFilterCondition(portfbtypes.port))
    	{
    		isCheck = "checked='checked'";
    	}
    	var objectid = "cbPort" + portfbtypes.port;
    	var inner = "<input type='checkbox' name='cbPort' id='" + objectid + "' value='" + portfbtypes.port + "' onclick='doPortSelected(false)' " + isCheck + "/>"
					+ "<span title='" + portfbtypes.portName + "'>" + getPortName(portfbtypes.portName) + "</span>";
		inner += "[<span id='spPortPath" + portfbtypes.port + "'>0</span>]"
		var curCell	= curRow.insertCell(tdIndex);
		curCell.style.width = "33%";
		tdIndex++;
		curCell.innerHTML = inner;
    }
    $("dvPort").appendChild(tmpTable);
}

function isContainPortFilterCondition(port)
{
	for(var i = 0,len = win.filterCondition.selectedPorts.length;i < len;i++)
	{
		if(win.filterCondition.selectedPorts[i].port == port)
		{
			return true;
		}
	}
	return false;
}

function isParentFilterExc()
{
	return win.filterCondition.isFilterExc;
}

function getPortName(portname)
{
	var maxLen = 0;
	var index = 0;
	var profix = "";
	for (index = 0; index < portname.length; index++)
	{
		letterCode = portname.charCodeAt(index);
		if (letterCode >= 127)
		{
			maxLen += 2;
		}
		else
		{
			maxLen++;
		}
		if(maxLen > 26)
		{
			profix = "...";
			break;
		}
	}
	if(profix.length > 0)
	{
		portname = portname.substring(0,index-3) + profix;
	}
	return portname;
}

/**
 *         
 *                
 */
function doPortSelected(autoFlag)
{
	var availableGrade = [];
	var selectedCount = 0;
	for (var index = 0, len = CurrentFilterRes.length; index < len; index++) 
    {
    	var portfbtypes = CurrentFilterRes[index];
    	if( $("cbPort"+portfbtypes.port) != null && $("cbPort"+portfbtypes.port).checked)
		{
			availableGrade = availableGrade.concat(portfbtypes.gradeList);
			selectedCount++;
		}
    }
    if(selectedCount == 0)
    {
    	availableGrade = GradeList;
    }
    else
    {
    	if(selectedCount == CurrentFilterRes.length)
    	{
    		$("cbPortAllSelect").checked = true;
    	}
    	else
    	{
    		$("cbPortAllSelect").checked = false;
    	}
    }
	disableNoAvailableGrade(availableGrade, autoFlag);
}

/**
 *         
 */
function disableNoAvailableGrade(availableGrade, autoFlag)
{
	var flag = true;
	for (var index = 0, len = GradeList.length; index < len; index++) 
    {
    	var grade =  GradeList[index];
    	if( $("cbGrade" + grade) != null && !availableGrade.contains(grade))
		{
			$("cbGrade" + grade).checked = false;
			$("cbGrade" + grade).disabled = true;
			$("spGrade" + grade).disabled = true;
		}
		else
		{			
			if (null != $("cbGrade"+grade))
			{
				if (win.filterCondition.selectedPorts.length == 0 && flag && autoFlag) //                         grade  
				{
					$("cbGrade" + grade).checked = true;
					flag = false;
				}
				$("cbGrade"+grade).disabled = false;
			}
			if (null != $("spGrade" + grade))
			{
				$("spGrade" + grade).disabled = false;
			}
		}
    }
	refreshPortPathTitle();
}

/**
 *                
 *             
 */
function doPortAllSelect()
{
	var portfbtypes = null;
	for (var index = 0, len = CurrentFilterRes.length; index < len; index++) 
    {
    	portfbtypes = CurrentFilterRes[index];
    	if( $("cbPort"+portfbtypes.port) == null )
		{
			continue;
		}
		$("cbPort"+portfbtypes.port).checked = $("cbPortAllSelect").checked;
    }
    for (var index = 0, len = GradeList.length; index < len; index++) 
    {
    	var grade =  GradeList[index];
    	if (null != $("cbGrade"+grade))
		{	
			if (index == 0)
			{
			    $("cbGrade"+grade).check = true;	
			}
			$("cbGrade"+grade).disabled = false;
		}
		if (null != $("spGrade" + grade))
		{
			$("spGrade" + grade).disabled = false;
		}
    }
}

/**
 *            
 *        
 */
function getSelectedPorts(selectedGrades)
{
	var selectedPorts = [];
	for (var index = 0, len = CurrentFilterRes.length; index < len; index++) 
    {
    	var portfbtypes = CurrentFilterRes[index];
    	if( $("cbPort"+portfbtypes.port) != null && $("cbPort"+portfbtypes.port).checked)
		{
			var portObj = new Object();
			portObj.port = portfbtypes.port;
			if(isFilterEXC() && ExcExistPath != null)
			{
				var excpath = ExcExistPath[portObj.port];
				if (excpath) 
				{
					portObj.pathList = getPortPathList(excpath,selectedGrades);
				}
				else
				{
					portObj.pathList = [];
				}
			}
			selectedPorts[selectedPorts.length] = portObj;
		}
    }
    return selectedPorts;
}

/**
 *         
 */
function initGrade(/*Array*/gradeList,/*Array*/fbtypeList)
{
	var tmpTable = document.createElement("table");
	tmpTable.width = "100%";
	var curRow =  null;
	var rowIndex = 0;
	var tdIndex = 0;
	
	for (var index = 0, len = gradeList.length; index < len; index++) 
    {
    	if((index) % 3 == 0)
		{
			curRow = tmpTable.insertRow(rowIndex);
			tdIndex = 0;
			rowIndex++;
		}
		var grade =  gradeList[index];
		var isCheck = "";
		if((win.filterCondition.selectedGrades.length == 0 && index == 0)
				|| win.filterCondition.selectedGrades.contains(grade))
	    	{
	    		isCheck = "checked='checked'";
	    	}
	    var fbname =  getFBTypeName()[fbtypeList[index]];
		if(fbname == undefined)
		{
			continue;
		}
    	var objectid = "cbGrade" + grade;
    	var inner = "<input type='checkbox' name='cbGrade' id='" + objectid + "' onclick='doGradeSelected()' value='" + grade + "' " + isCheck + " />"
					+ "<span id='spGrade" + grade + "'>" + fbname + "</span>";
		var curCell	= curRow.insertCell(tdIndex);
		curCell.style.width = "33%";
		tdIndex++;
		curCell.innerHTML = inner;
    }
    $("dvGrade").appendChild(tmpTable);
}

function doGradeSelected()
{
	var selectedCount = 0;
	for (var index = 0, len = GradeList.length; index < len; index++) 
    {
    	var grade =  GradeList[index];
    	if( $("cbGrade"+grade) != null && $("cbGrade"+grade).checked)
		{
			selectedCount++;
		}
		
    }
    if(selectedCount == GradeList.length)
    {
    	$("cbGradeAllSelect").checked = true;
    }
    else
    {
    	$("cbGradeAllSelect").checked = false
    }
	refreshPortPathTitle();
}

/**
 *                
 *             
 */
function doGradeAllSelect()
{
	for (var index = 0, len = GradeList.length; index < len; index++) 
    {
    	var grade =  GradeList[index];
    	if( $("cbGrade"+grade) == null )
		{
			continue;
		}
		$("cbGrade"+grade).checked = $("cbGradeAllSelect").checked;
    }
	refreshPortPathTitle();
}

function getSelectedGrades()
{
	var selectedGrades = [];
	for (var index = 0, len = GradeList.length; index < len; index++) 
    {
    	var grade =  GradeList[index];
    	if( $("cbGrade"+grade) != null && $("cbGrade"+grade).checked)
		{
			selectedGrades[selectedGrades.length] = grade;
		}
    }
    return selectedGrades;
}

/**
 *    TCM     
 */
function initTCMGrade()
{
	var tmpTable = document.createElement("table");
	tmpTable.width = "100%";
	var curRow =  null;
	var rowIndex = 0;
	var tdIndex = 0;
	for (var index = 2, len = 7; index <= len; index++) 
    {
    	if((index - 2) % 3 == 0)
		{
			curRow = tmpTable.insertRow(rowIndex);
			tdIndex = 0;
			rowIndex++;
		}
		var isCheck = "";
		var objectid = "cbTcmGrade" + index;
		var tcmname = "TCM-" + (index - 1);
		if(win.filterCondition.selectedTcmLevels.length == 0)
		{
			if (index == 2) //      TCM1
			{
				isCheck = "checked='checked'";
			}
		}
		else if(win.filterCondition.selectedTcmLevels.contains(index))
		{
    		isCheck = "checked='checked'";
    	}
		var inner = "<input type='checkbox' name='cbTcmGrade' id='" + objectid + "' onclick='doTcmSelected()' value='" + index + "' " + isCheck + " />"
			+ "<span>" + tcmname + "</span>";
		var curCell	= curRow.insertCell(tdIndex);
		curCell.style.width = "33%";
		tdIndex++;
		curCell.innerHTML = inner;
    }
    $("dvTcmgrade").appendChild(tmpTable);
}

function doTcmSelected()
{
	var selectedCount = 0;
	for( var i = 2 ; i <= 7; i++ )
    {
    	if( $("cbTcmGrade"+i) != null && $("cbTcmGrade"+i).checked)
		{
			selectedCount++;
		}
    }
    if(selectedCount == 6)
    {
    	$("cbTcmGradeAllSelect").checked = true;
    }
    else
    {
    	$("cbTcmGradeAllSelect").checked = false
    }
}

/**
 * TCM               
 *             
 */
function doTcmGradeSelect()
{
	for( var i = 2 ; i <= 7; i++ )
	{
		if( $("cbTcmGrade"+i) == null )
		{
			continue;
		}
		$("cbTcmGrade"+i).checked = $("cbTcmGradeAllSelect").checked;
	}
}

function getSelectedTCMGrades()
{
	var selectedTCMGrades = [];
	for( var i = 2 ; i <= 7; i++ )
    {
    	if( $("cbTcmGrade"+i) != null && $("cbTcmGrade"+i).checked)
		{
			selectedTCMGrades[selectedTCMGrades.length] = i;
		}
    }
    return selectedTCMGrades;
}

function getPortPathList(portfbtype,selectedGrades)
{
	var pathList = [];
	for(var j = 0,lenj = selectedGrades.length;j < lenj;j++)
	{
		if(typeof(portfbtype.gradepathList[selectedGrades[j]]) != "undefined")
		{
			pathList = pathList.concat(portfbtype.gradepathList[selectedGrades[j]]);
		}
	}
	return pathList;
}

function getPortPathNumber(portfbtype,selectedGrades)
{
	var pathnumber = 0;
	for(var j = 0,lenj = selectedGrades.length;j < lenj;j++)
	{
		if(typeof(portfbtype.gradepathList[selectedGrades[j]]) != "undefined")
		{
			if (selectedGrades[j] == GRADE_ODU0 && isSupportODUTsModeFlag)
			{
				pathnumber += portfbtype.gradepathList[selectedGrades[j]].length/2;
			}
			else
			{
				pathnumber += portfbtype.gradepathList[selectedGrades[j]].length;
			}
		}
	}
	return pathnumber;
}

function refreshPortPathTitle()
{
	var selectedGrades = getSelectedGrades();
	for (var index = 0, len = CurrentFilterRes.length; index < len; index++) 
    {
    	var portfbtype = CurrentFilterRes[index];
		var newportfbtype = portfbtype;
		if(isFilterEXC() && ExcExistPath != null)
		{
			newportfbtype = ExcExistPath[portfbtype.port];
		}
		if (newportfbtype == null) 
		{
			$("spPortPath" + portfbtype.port).innerHTML = "0";
		}
		else 
		{
			$("spPortPath" + portfbtype.port).innerHTML = getPortPathNumber(newportfbtype, selectedGrades);
		}
    }
}

function getSelectedPortPathNumber()
{
	var selectedGrades = getSelectedGrades();
	var pathnumber = 0;
	for (var index = 0, len = CurrentFilterRes.length; index < len; index++) 
    {
    	var portfbtype = CurrentFilterRes[index];
    	if( $("cbPort"+portfbtype.port) != null && $("cbPort"+portfbtype.port).checked)
		{
			pathnumber += getPortPathNumber(portfbtype,selectedGrades);
		}
    }
	if (isTCMOverHead()) 
	{
		pathnumber = getSelectedTCMGrades().length * pathnumber;
	}
	return pathnumber;
}

function getAvailableRes()
{
	var urlreq = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_OTN_QUERY_AVALABLERES;
	
	var xml = createQueryAvailableXML();
	
	loadXMLdoc(urlreq, "POST", false, getAvailableResHandler, null, "inputdata=" + xml);
}

function getAvailableResHandler(doc)
{
    var data = EncapsulateData(doc);
    if(0 == data.getSErrorCode())
    {
    	CurrentFilterRes = [];
		for (var index = 0, len = data.getDataRowLength(); index < len; index++) 
	    {
	    	var port =  data.getDataRowParam(index, "port");
	    	var portname =  data.getDataRowParam(index, "portname");
	    	var grade = data.getDataRowParam(index, "grade");
	    	var fbtype = data.getDataRowParam(index, "fbtype");
	    	var gradepath = data.getDataRowParam(index, "gradepath");
	    	
	    	var availableres = new OTNAvailableRes(port,portname,grade.split(","),fbtype.split(","));
	    	availableres.parseGradePath(gradepath);
	    	
	        CurrentFilterRes[CurrentFilterRes.length] = availableres;
	        
	        if (index == 0 && null != data.getDataRowParam(index, "isSupportODUTsModeFlag"))
	        {
	        	isSupportODUTsModeFlag = true;
	        }
	    }
    }
}

function OTNAvailableRes(port,portName,gradeList,fbtypeList)
{
	this.port = port;
	this.portName = portName;
	if(typeof(gradeList) != "undefined")
	{
		this.gradeList = gradeList;
	}
	if(typeof(fbtypeList) != "undefined")
	{
		this.fbtypeList = fbtypeList;
	}
	this.gradepathList = [];
}
/**
 *          fbpath  ,grade[path,path];grade[path,path].....
 *        824[1,2,3,4];825[1,2,3,4]....
 */
OTNAvailableRes.prototype.parseGradePath = function(gradepath)
{
	if(typeof(gradepath) != "undefined" && gradepath != "")
	{
		var gradepaths = gradepath.split(";");
		for(var i = 0,len = gradepaths.length;i < len;i++)
		{
			var gradepathtmp = gradepaths[i];
			var firstIndex = gradepathtmp.indexOf("[");
			if(firstIndex > 0)
			{
				var grade = gradepathtmp.substring(0,firstIndex);
				var path = gradepathtmp.substring(firstIndex + 1,gradepathtmp.length - 1);
				this.gradepathList[grade] = path.split(",");
			}
			else
			{
				this.gradepathList[gradepathtmp] = [];
			}
		}
	}
}


function createQueryAvailableXML()
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
	param.setAttribute("value", win.neid);
	row.appendChild(param);
	
	param = new tagElement("param");
    param.setAttribute("name", "slotid");
	param.setAttribute("value", win.slotid);
	row.appendChild(param);
	
	var colids = "";
	var sp = "";
    for (var i = 1; i < win.tableconfObj.getColsLength(); i++) 
    {
        colid = win.tableconfObj.getColId(i);
        colids = colids + sp + colid;
        sp = ",";
    }
    param = new tagElement("param");
    param.setAttribute("name", "attrNames");
    param.setAttribute("value", colids);
    row.appendChild(param);
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
    return di.toString();
}

function queryExcExistPath()
{
	LoadingProcess.showWaitStatus("../../../../../images/");
	var urlreq = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_OTN_QUERY_EXCEXISTPATH;
	var xml = createQueryExcExistXML();
	loadXMLdoc(urlreq, "POST", true, getExcExistHandler, null, "inputdata=" + xml);
}

function createQueryExcExistXML()
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param","neid",win.neid);
	row.appendChild(param);
	param = new tagElement("param","sourceSlot",win.slotid);
	row.appendChild(param);
	param = new tagElement("param","sinkSlot","0");
	row.appendChild(param);
	bussiness.appendChild(row);
	row = new tagElement("row-params");
    param = new tagElement("param","neid",win.neid);
	row.appendChild(param);
	param = new tagElement("param","sourceSlot","0");
	row.appendChild(param);
	param = new tagElement("param","sinkSlot",win.slotid);
	row.appendChild(param);
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
    return di.toString();
}

function getExcExistHandler(doc)
{
	LoadingProcess.removeWaitStatus();
    var data = EncapsulateData(doc);
    if(0 == data.getSErrorCode())
    {
		if (isParentFilterExc()) 
		{
			$("cbPathExcSelect").checked = true;
		}
		ExcExistPath = [];
    	for (var index = 0, len = data.getDataRowLength(); index < len; index++) 
	    {
	    	var port =  data.getDataRowParam(index, "port");
	    	var gradepath = data.getDataRowParam(index, "gradepath");
	    	var availableres = new OTNAvailableRes(port,"",[],[]);
	    	availableres.parseGradePath(gradepath);
	        ExcExistPath[port] = availableres;
	    }
		doPortSelected(true);
		doGradeSelected();
		doTcmSelected();
    }
}

function isFilterEXC()
{
	return $("cbPathExcSelect").checked;
}

function doPathExcSelect()
{
	refreshPortPathTitle();
}
