var winurlobj = getNeProperty( self );
var tableconfObj;
var st;
var neid;
var slotid;
var curCellEle;
var curCellkeyArray;

var hasQueryRight = true;
var hasApplyRight = true;

var ERROR_NOT_LOGIN = "37926";

var ttiCols = [];
ttiCols.push( "OTN_TCM_ST_TTI" );
ttiCols.push( "OTN_TCM_SR_TTI" );
ttiCols.push( "OTN_PM_ST_TTI" );
ttiCols.push( "OTN_PM_SR_TTI" );
ttiCols.push( "OTN_SM_ST_TTI" );
ttiCols.push( "OTN_SM_SR_TTI" );

var ttiALLCols = [];
ttiALLCols.push( "OTN_TCM_ST_TTI" );
ttiALLCols.push( "OTN_TCM_SR_TTI" );
ttiALLCols.push( "OTN_TCM_R_TTI" );
ttiALLCols.push( "OTN_PM_ST_TTI" );
ttiALLCols.push( "OTN_PM_SR_TTI" );
ttiALLCols.push( "OTN_PM_R_TTI" );
ttiALLCols.push( "OTN_SM_ST_TTI" );
ttiALLCols.push( "OTN_SM_SR_TTI" );
ttiALLCols.push( "OTN_SM_R_TTI" );


var TTI_TEXT_MODE = 0;
var TTI_HEX_MODE = 1;
var curDisMode = TTI_TEXT_MODE;

var DEG_THCols = [];
DEG_THCols.push( "OTN_TCM_DEG_TH" );
DEG_THCols.push( "OTN_PM_DEG_TH" );
DEG_THCols.push( "OTN_SM_DEG_TH" );

var maxDegNumCols = [];
var degDefaultValue = [];

var minDegTh = 0;
var minDegTimes = 2;


var blRefreshPage = false;

var queryOTNfid = TE_FUNC_CFG_SM_OVERHEAD;


var bip8Modes = null;

var language = SYSTEMCONF.getLanguage();

var closeBarFlg = false;
var xmlHttp = null;
var changedRows = [];
var queryData = null;

/* *
 *       
 *
 * @param  
 * @return  
 */

function initMainPage()
{
   $( "selectBdText" ).innerHTML = RESOURCE["selectBdText"];
   var selectobj = document.getElementById( "selectObj" );

   selectobj["onchange"] = function ()
   {
      sendQueryOTNReq( TECMDCODE_QUERY_NE_SM_OVERHEAD, 0 );
   }


   var xmlstr = createGetBoardXML();
   urlreq = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_NE_SM_BOARD;

   loadXMLdoc( urlreq, "POST", true, fillBDInfo, null, "inputdata=" + xmlstr );
}


function createGetBoardXML()
{
   var di = new inputxml( "datainterface" );
   var bussiness = new tagElement( "bussiness-params" );
   var row = new tagElement( "row-params" );
   var param = new tagElement( "param" );

   var neidvalue = getNeProperty( self ).neid;
   param.setAttribute( "name", "neid" );
   param.setAttribute( "value", neidvalue );
   row.appendChild( param );

   bussiness.appendChild( row );
   di.getRoot().appendChild( bussiness );

   return di.toString();
}


function fillBDInfo( doc )
{
   var bdSelect = document.getElementById( "selectObj" );
   bdSelect.options.length = 0;
   bdSelect.options[0] = new Option( RESOURCE["allBoard"], 0 );
   var outputData = EncapsulateData( doc );
   if( outputData.getDataRowLength() <= 0 )
   {
      return;
   }


   for( var i = 0, iLength = outputData.getDataRowLength();
   i < iLength;
   i ++ )
   {
      var subrackname = outputData.getDataRowParam( i, "subrackname" );
      var showslotid = outputData.getDataRowParam( i, "showslotid" );
      var slotid = outputData.getDataRowParam( i, "slotid" );
      var boardName = outputData.getDataRowParam( i, "boardName" );

      bdSelect.options[bdSelect.options.length] = new Option( subrackname + "-" + showslotid + "-" + boardName, slotid );
   }

   sendQueryOTNReq( TECMDCODE_QUERY_NE_SM_OVERHEAD, 0 );


}

function getnewOTNModelXMLUrl()
{
   return "../../../conf/newotnmodel/";
}


function getSupportBoard()
{
   var xml = createGetSupportBoardAttributeXML();
   urlreq = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_NE_SM_BOARD;
   var params = new Array();
   params[0] = gencfgObj;
   params[1] = url;
   loadXMLdoc( urlreq, "POST", false, callbackGetSupportBoard, params, "inputdata=" + xml );
}

function callbackGetSupportBoard( doc )
{
   var bdSelect = document.getElementById( "selectObj" );
   bdSelect.options.length = 0;
   bdSelect.options[0] = new Option( RESOURCE["allBoard"], 0 );
   var allData = EncapsulateData( doc );
   if( allData.getDataRowLength() <= 0 )
   {
      return;
   }

   var bdInfo = allData.getDataRowParam( 0, "bdInfo" );
   var bdArr = bdInfo.split( "," );
   var tempinfo = [];
   for( var i = 0; i < bdArr.length; i ++ )
   {
      tempinfo = bdArr[i].split( "-" );
      bdSelect.options[bdSelect.options.length] = new Option( bdArr[i], tempinfo[0] );
   }
}



/* *
 *      
 *
 * @param sfid :    ID
 * @return  
 */
function init()
{
   initMainPage();
   loadXMLdoc( "../../../conf/ophbyte/neotn/smophbytetable_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable );

   $( "textdisplay" ).innerHTML = RESOURCE["textmodel"];
   $( "hexdisplay" ).innerHTML = RESOURCE["hexmodel"];


   $( "querybtn" ).value = RESOURCE["querybutton"];
   $( "applybtn" ).value = RESOURCE["applybutton"];
   winurlobj = getNeProperty( self );
   neid = winurlobj["neid"];

   slotid = winurlobj["slotid"];

   st = new SortTable();

   st.setImage( "../../../../../images/" );

   tableconfObj = window.tableconf[0];

   st.setOnCellEditHandler( cellEditHandler );


   createTableHead( st, tableconfObj );

   var hc = st.getHeadCell( "operaObj" );
   if( hc.element.compare == null )
   {
      st.setHCAttribute( hc, 1, 0, comparePortPath );
   }
   else
   {
      st.setHCAttribute( hc, 1, 1, hc.element.compare );
   }

   document.getElementById( "tablecomponent" ).appendChild( st.getTable() );

   st.setBodyHeight( getComponetHeight( $( "tablecomponent" ), 80 ) + "px" );

   window.onresize = function()
   {
      st.setBodyHeight( getComponetHeight( $( "tablecomponent" ), 80 ) + "px" );
      adjustTableLayout( st, tableconfObj );
   }

   $( "tablecomponent" ).oncontextmenu = popupMenuHandler;
   st.setBodyWidth( tableconfObj.width, tableconfObj.percent, 0 );


   sendQueryRightReq( TE_FUNC_CFG_SM_OVERHEAD, TE_FUNC_SFG_SM_OVERHEAD );

}

/*
 *           
 *
 */
function comparePortPath( str1, str2 )
{


   var index1 = str1.lastIndexOf( "-", str1.lastIndexOf( "(" ) );
   var port1 = str1.substring( index1 + 1, str1.lastIndexOf( "(" ) );

   var index2 = str2.lastIndexOf( "-", str2.lastIndexOf( "(" ) );
   var port2 = str2.substring( index2 + 1, str2.lastIndexOf( "(" ) );

   if ( parseInt( port1 ) > parseInt( port2 ) )
   {
      return 1;
   }
   else if ( parseInt( port1 ) < parseInt( port2 ) )
   {
      return - 1;
   }
   var path1 = Number( str1.substring( str1.lastIndexOf( "-" ) + 1, str1.length ) );
   var path2 = Number( str2.substring( str2.lastIndexOf( "-" ) + 1, str2.length ) );
   path1 = ( path1 == 65537 ? 1 : path1 );
   path2 = ( path2 == 65537 ? 1 : path2 );
   if ( path1 > path2 )
   {
      return 1;
   }
   else if ( path1 < path2 )
   {
      return - 1;
   }
   else
   {
      return 0;
   }
}

/* *
 * text hex    
 */
function dataConvert()
{

   if ( $( "text" ).checked && curDisMode == TTI_TEXT_MODE )
   {
      return;
   }
   if ( ( $( "hex" ).checked == true ) && curDisMode == TTI_HEX_MODE )
   {
      return;
   }
   var cellShow = null;
   for ( var i = 0, len = st.getDataRowLength();
   i < len;
   i ++ )
   {
      for ( var j = 0, collen = ttiALLCols.length;
      j < collen;
      j ++ )
      {
         if( st.element.colsArray.contains( ttiALLCols[j] ) )
         {
            cellShow = st.getCellShow( i, ttiALLCols[j] );
            if ( ( "-" != cellShow.getValue() ) && ( "/" != cellShow.getValue() ) )
            {
               convert( cellShow ) ;
            }
         }
      }
   }
   curDisMode = ( curDisMode == TTI_TEXT_MODE ) ? TTI_HEX_MODE : TTI_TEXT_MODE;
}



/* *
 *
 *      16       
 *
 * @param cellShow :
 *                      
 *
 */
function convert( cellShow )
{
   var previousValue = cellShow.getValue();
   var ttiValues = previousValue.split( "-" );
   var len = ttiValues.length
   if( curDisMode == TTI_TEXT_MODE )
   {
      for( var i = 0; i < len; i ++ )
      {
         ttiValues[i] = text2Hex( ttiValues[i] );
      }
   }
   else
   {
      for( var j = 0; j < len; j ++ )
      {
         ttiValues[j] = hex2Text( ttiValues[j] );
      }
   }

   var showvalue = ttiValues.join( '-' );
   cellShow.setValue( showvalue );
}



function addCellListener( i )
{

}


/* *
 *    TTI         
 *
 * @param  
 * @return  
 */
function addListerner()
{
   var cell = null;
   var rowindex = 0;
   var grade = 1;
   var cellEdit = null;
   for ( var i = 0, len = st.getDataRowLength();
   i < len;
   i ++ )
   {
      rowindex = i;
      grade = st.getCellStoreValue( i, "operaObj", "grade" );

      cell = st.getCell( i, "OTN_TCM_ST_TTI" );
      if ( null != cell && cell.element.isEdit == "1" )
      {
         cell.element["ondblclick"] = function()
         {
            hideMenu();
            showTTIMgrDialog( this, "OTN_TCM_ST_TTI", ["ST_SRC_FLAG", "ST_SINK_FLAG", "ST_USER_FLAG"] );
         }
      }
      cell = st.getCell( i, "OTN_TCM_SR_TTI" );
      if ( null != cell && cell.element.isEdit == "1" )
      {
         cell.element["ondblclick"] = function()
         {
            hideMenu();
            showTTIMgrDialog( this, "OTN_TCM_SR_TTI", ["SR_SRC_FLAG", "SR_SINK_FLAG", "SR_USER_FLAG"] );
         }
      }

      cell = st.getCell( i, "OTN_PM_ST_TTI" );
      if ( null != cell && cell.element.isEdit == "1" )
      {
         cell.element["ondblclick"] = function()
         {
            hideMenu();
            showTTIMgrDialog( this, "OTN_PM_ST_TTI", ["ST_SRC_FLAG", "ST_SINK_FLAG", "ST_USER_FLAG"] );
         }
      }
      cell = st.getCell( i, "OTN_PM_SR_TTI" );
      if ( null != cell && cell.element.isEdit == "1" )
      {
         cell.element["ondblclick"] = function()
         {
            hideMenu();
            showTTIMgrDialog( this, "OTN_PM_SR_TTI", ["SR_SRC_FLAG", "SR_SINK_FLAG", "SR_USER_FLAG"] );
         }
      }

      cell = st.getCell( i, "OTN_SM_ST_TTI" );
      if ( null != cell && cell.element.isEdit == "1" )
      {
         cell.element["ondblclick"] = function()
         {
            hideMenu();
            showTTIMgrDialog( this, "OTN_SM_ST_TTI", ["ST_SRC_FLAG", "ST_SINK_FLAG", "ST_USER_FLAG"] );
         }
      }
      cell = st.getCell( i, "OTN_SM_SR_TTI" );
      if ( null != cell && cell.element.isEdit == "1" )
      {
         cell.element["ondblclick"] = function()
         {
            hideMenu();
            showTTIMgrDialog( this, "OTN_SM_SR_TTI", ["SR_SRC_FLAG", "SR_SINK_FLAG", "SR_USER_FLAG"] );
         }
      }




   }
}



/* *
 *     OTN    
 *
 * @param sfid :    ID
 * @return  
 */
function sendQueryOTNReq( sfid, isQueryNE )
{
   if ( ! hasQueryRight )
   {
      return;
   }
   var urlreq = "../../../../../neExlorerServlet?sfid=" + sfid + "&nmUser=" + winurlobj["nmUser"];

   var inputData = createQueryXML( isQueryNE );

   $( "querybtn" ).disabled = true;
   $( "applybtn" ).disabled = true;
   LoadingProcess.showWaitStatus( "../../../../../images/" );

   xmlHttp = loadXMLdoc( urlreq, "POST", true, handleQueryOTNRsp, null, "inputdata=" + inputData );
}



function showOTNProgress()
{
   showProgressBarPage( RESOURCE["querybutton"], true, 1000, 200, "../../../../../" );
}



/* *
 *     OTN    
 *
 * @param sfid :    ID
 * @return  
 */
function sendSetOTNReq( sfid )
{
      $( "querybtn" ).disabled = true;
      $( "applybtn" ).disabled = true;
      batchSendSetOTNReq( sfid, 0, null );
}


var danger_alert = false;
function batchSendSetOTNReq( sfid, index, data )
{
   var di = new inputxml( "datainterface" );
   var bussiness = new tagElement( "bussiness-params" );
   var row = null;
   var param = null;
   var rowData = null;
   var colid = null;
   var key = null;
   var colkeyarray = null;
   var cellModifyFlag = false;
   var tc = tableconfObj;
   var changeRowCount = 0;
   var dangerCol = new Object();

   for ( var rowindex = index, rowlen = st.getDataRowLength(); rowindex < rowlen; rowindex ++ )
   {
      if ( ! st.getModify( rowindex ) )
      {
         continue;
      }
      changeRowCount ++;
      rowData = st.getRow();
      row = new tagElement( "row-params" );
      param = new tagElement( "param" );
      param.setAttribute( "name", "neid" );
      param.setAttribute( "value", neid );
      row.appendChild( param );

      for ( var colindex = 0, collen = tc.getColsLength(); colindex < collen; colindex ++ )
      {
         colid = tc.getColId( colindex );
         if( colid == "OTN_SM_R_TTI" )
         {
            continue;
         }
         cellModifyFlag = st.getCellModify( rowindex, colid );
         colkeyarray = tc.getColKeyArray( colindex );
         for ( var keyindex = 0, keylen = colkeyarray.length;
         keyindex < keylen;
         keyindex ++ )
         {
            param = new tagElement( "param" );
            key = colkeyarray[keyindex].name;

            if( key == "nename" || key == "boardname" || key == "portname" || key == "boardtype" )
            {
               continue;
            }
            param.setAttribute( "name", key );
            param.setAttribute( "value", st.getCellStoreValue( rowindex, colid, key ) );
            param.setAttribute( "modifyFlag", cellModifyFlag );
            
            dangerCol[key] = cellModifyFlag;

            row.appendChild( param );
         }
      }
      bussiness.appendChild( row );

      if( changeRowCount >= 30 )
      {   	 
    	 if(changeRowCount == 30)
    	 {
    	 	LoadingProcess.showWaitStatus( "../../../../../images/" );
    	 }
    	 
    	 if(!danger_alert && !dangerAlert(dangerCol))
	{
		return;
	}

    	 di.getRoot().appendChild( bussiness );
         var urlreq = "../../../../../neExlorerServlet?sfid=" + sfid + "&nmUser=" +winurlobj["nmUser"];
         loadXMLdoc( urlreq, "POST", true, handleBatchSetOTNRsp, [sfid, rowindex +
         1, data], "inputdata=" + di.toString() );
         return;
      }      

   }
   
   if ( bussiness.childNodes.length > 0 )
   {
      if(!danger_alert && !dangerAlert(dangerCol))
	{
		return;
	}

      di.getRoot().appendChild( bussiness );
      var urlreq = "../../../../../neExlorerServlet?sfid=" + sfid + "&nmUser=" + winurlobj["nmUser"];
      loadXMLdoc( urlreq, "POST", true, handleBatchSetOTNRsp, [sfid, rowindex + 1, data], "inputdata=" + di.toString() );
   }
   else
   {
      if( null == data )
      {
         closeBarFlg = true;
         alert( RESOURCE["osinochange"] );
         $( "querybtn" ).disabled = false;
      }
      else
      {
         dealBatchSet( data, sfid );
      }
   }
}

function dangerAlert(dangerCol)
{
	var attrStr = "";
	if(dangerCol['ST_SRC_FLAG']==1)
	{
		attrStr += RESOURCE["ST_TTI"] +",";
	}
				 
	if(dangerCol['SR_SRC_FLAG']==1)
	{
		attrStr += RESOURCE["SR_TTI"]+",";
	}
	
	if(dangerCol['OTN_TCM_LCKINSERT']==1 || dangerCol['OTN_PM_LCKINSERT']==1 )
	{
		attrStr += RESOURCE["LCKINSERT"]+",";
	}
	
				 
	if(attrStr!="")
	{
		var tips = RESOURCE["MODIFY_ATTRIBUTE_ALERT"] + attrStr.substring(0,attrStr.length-1) + "?";
                danger_alert = confirm(tips);
                if(!danger_alert)
                {
                    	$("querybtn").disabled = false;
                    	$("applybtn").disabled = false;
                    	return false;;
                 }
        }
        
        return true;
}

function dealBatchSet( data, sfid )
{
   danger_alert = false;
   $( "querybtn" ).disabled = false;
   if ( OPERATION_SUCCESS != data.getSErrorCode() )
   {
      $( "applybtn" ).disabled = false;
   }
   else
   {
      if ( blRefreshPage )
      {
         if( sfid == TE_FUNC_SFG_SM_OVERHEAD )
         {
            queryOTNfid = TE_FUNC_CFG_SM_OVERHEAD;
         }
         if( sfid == TE_FUNC_SFG_PM_OVERHEAD )
         {
            queryOTNfid = TE_FUNC_CFG_PM_OVERHEAD;
         }
         setQueryOTNReqNOProgress( [queryOTNfid, true] );
         blRefreshPage = false;
         return;
      }
   }
   closeBarFlg = true;
   LoadingProcess.removeWaitStatus();
   refreshTableState( st, tableconfObj, data );

   showErrorPage( data, "set", sfid );
}

function handleBatchSetOTNRsp( doc, params )
{
   var data = EncapsulateData( doc );
   var sfid = params[0];
   var index = params[1];
   if( index < st.getDataRowLength() && data.getSErrorCode() == OPERATION_SUCCESS )
   {
      batchSendSetOTNReq( sfid, index, data );
   }
   else
   {
      dealBatchSet( data, sfid );
   }
}



/* *
 *          XML  
 *
 * @param neid :   ID
 *            slotid :   ID tableconf :         
 * @return String :        XML  
 */
function createQueryXML( isQueryNE )
{
   var di = new inputxml( "datainterface" );
   var bussiness = new tagElement( "bussiness-params" );
   var row = new tagElement( "row-params" );

   var row = new tagElement( "row-params" );
   var param = new tagElement( "param" );
   param.setAttribute( "name", "neid" );
   param.setAttribute( "value", winurlobj["neid"] );
   row.appendChild( param );

   var param = new tagElement( "param" );
   param.setAttribute( "name", "slotid" );
   param.setAttribute( "value", $( "selectobj" ).value );
   row.appendChild( param );

   param = new tagElement( "param" );
   param.setAttribute( "name", "srcObjType" );
   param.setAttribute( "value", "ID_OBJECT_TYPE_NE_BOARD" );
   row.appendChild( param );

   param = new tagElement( "param" );
   param.setAttribute( "name", "queryflag" );
   param.setAttribute( "value", isQueryNE );
   row.appendChild( param )


   bussiness.appendChild( row );

   di.getRoot().appendChild( bussiness );
   return di.toString();
}




function progressBarCancel()
{
   if( xmlHttp != null )
   {
      xmlHttp.abort();
      $( "querybtn" ).disabled = false;
   }
}

function verifySetData()
{
   var colid = null;
   var key = null;
   var lckflag = false;
   var tc = tableconfObj;
   for ( var rowindex = 0, rowlen = st.getDataRowLength();
   rowindex < rowlen;
   rowindex ++ )
   {
      if ( ! st.getModify( rowindex ) )
      {
         continue;
      }
   }

   return true;
}






/* *
 *          
 *
 * @param doc :        
 * @return  
 */
function handleQueryOTNRsp( doc, params )
{
   var data = EncapsulateData( doc );
   closeBarFlg = true;


   if ( 0 == data.getSErrorCode() || 1 == data.getSErrorCode() || 2 == data.getSErrorCode() )
   {
      handleReturnData( data );

      createGenCfgTableBody( st, tableconfObj, data );

   }

   $( "querybtn" ).disabled = false;
   $( "applybtn" ).disabled = true;

   addListerner();
   LoadingProcess.removeWaitStatus();
   
   showErrorPage(data, "query", TECMDCODE_QUERY_NE_SM_OVERHEAD);
   
}

/* *
 *       ,  TTI      00    
 *
 * @param doc        
 * @return  
 */
function handleReturnData( data )
{


   for ( var index = 0, len = data.getDataRowLength();
   index < len;
   index ++ )
   {
      if ( null != data.getDataRowParam( index, "bip8mode" ) )
      {
         bip8Modes = data.getDataRowParam( index, "bip8mode" );

         break;
      }
   }
}

/* *
 *   TTI  
 *
 * @param cellEle :      
 *            colid  ID key : key
 * @return  
 */
function showTTIMgrDialog( cellEle, colid, keyArray )
{

   var value = [];
   for ( var i = 0, len = keyArray.length; i < len;
   i ++ )
   {
      value[i] = cellEle.storeValue[keyArray[i]];
   }
   curCellEle = cellEle;
   curCellkeyArray = keyArray;
   var dispalyMode = $( "text" ).checked ? TTI_TEXT_MODE : TTI_HEX_MODE;
   xshowModalDialog( "../otn/ttimgrdialog.html?srcflag=" + value[0] + "&sinkflag="
   + value[1] + "&userflag=" + value[2] + "&displaymode=" + dispalyMode,
   RESOURCE["title"], 450, 300, "../../../../../images/" );
}

/* *
 *        
 *
 * @param key : key
 *            value :  
 * @return  
 */
function refreshCellValue( srcFlag, sinkFlag, userFlag )
{
   var colid = curCellEle.colid;
   var rows = st.getSelectedRows();
   var tmpEle;
   var tempsrcFlag = srcFlag;

   var tempsinkFlag = sinkFlag;

   var tempuserFlag = userFlag;


   var hexSrcFlag = text2Hex( tempsrcFlag );
   var hexSinkFlag = text2Hex( tempsinkFlag );
   var hexUserFlag = text2Hex( tempuserFlag );

   var storeSrcFlag = removeSpace( hexSrcFlag );
   var storeSinkFlag = removeSpace( hexSinkFlag );
   var storeUserFlag = removeSpace( hexUserFlag );

   var showText = "";
   for ( var i = 0; i < rows.length; i ++ )
   {
      tmpEle = st.getCellElement( rows[i], colid );
      if ( tmpEle.isEdit != 1 )
      {
         continue;
      }

      if( $( "hex" ).checked )
      {
         srcFlag = hexSrcFlag;
         sinkFlag = hexSinkFlag;
         userFlag = hexUserFlag;
      }

      showText = srcFlag;
      if ( sinkFlag != "" )
      {
         showText += "-" + sinkFlag;
      }
      if ( userFlag != "" )
      {
         showText += "-" + userFlag;
      }

      st.setAtomValue( tmpEle.showElement, showText );

      tmpEle.currentValue[curCellkeyArray[0]] = storeSrcFlag;
      tmpEle.storeValue[curCellkeyArray[0]] = storeSrcFlag;
      tmpEle.currentValue[curCellkeyArray[1]] = storeSinkFlag;
      tmpEle.storeValue[curCellkeyArray[1]] = storeSinkFlag;
      tmpEle.currentValue[curCellkeyArray[2]] = storeUserFlag;
      tmpEle.storeValue[curCellkeyArray[2]] = storeUserFlag;
      tmpEle.modify = true;
      tmpEle.style.background = "#d0f946";
      tmpEle.parentNode.modify = true;
   }
   if ( hasApplyRight )
   {
      $( "applybtn" ).disabled = false;
   }
}

/* *
 *               
 *
 * @param  
 * @return  
 */
function cellEditHandler( param )
{
   if ( param.stage == TABLE_CONSTANT.BEFOREEDIT )
   {
      addCellListener( param.rowindex );
   }
   if ( param.colid == "OTN_PM_OCIINSERT" || param.colid == "OTN_PM_ASIINSERT" || param.colid == "OTN_PM_LCKINSERT"

   || param.colid == "OTN_PM_BIP8_MODE" || param.colid == "OTN_SM_BIP8_MODE"  || param.colid == "OTN_SM_DEG_INTERVAL"
   || param.colid == "OTN_PM_DEG_INTERVAL" || param.colid == "OTN_TCM_DEG_INTERVAL" )
   {
      blRefreshPage = true;
   }

   if ( hasApplyRight )
   {
      $( "applybtn" ).disabled = false;
   }
}

/* *
 *         
 *
 * @param doc
 *                   
 * @return  
 */
function showErrorPage( data, flag, sfid )
{
   var errArr = [];
   var temperrObj;
   for ( var i = data.getBErrLength() - 1; i >= 0;
   i -- )
   {
      var attrName = getAttrName( tableconfObj, data.getError().getRowKey( i, "attrId" ) );

      if ( ( attrName == null || attrName == "srcdesflag" || attrName == "odutype" || attrName == data.getError().getRowKey( i, "attrId" ) ) && data.getError().getRowCode( i ) != ERROR_NOT_LOGIN )
      {
         data.getError().rowErrors.splice( i, 1 );
         continue;
      }

      if ( sfid == TECMDCODE_QUERY_NE_SM_OVERHEAD || sfid == TECMDCODE_SET_NE_SM_OVERHEAD )
      {
         data.getError().rowErrors[i].errorObj["grade"] = otuGrade[data.getError().rowErrors[i].errorObj["grade"]];
      }
      else
      {
         data.getError().rowErrors[i].errorObj["grade"] = oduGrade[data.getError().rowErrors[i].errorObj["grade"]];
      }

      if ( data.getError().getRowCode( i ) == ERROR_NOT_LOGIN )
      {
         data.getError().rowErrors[i].errorObj["attrId"] = RESOURCE[flag];
         continue;
      }
      if ( language == "zh" )
      {
         data.getError().rowErrors[i].errorObj["attrId"] = RESOURCE[flag] + attrName;
      }
      else
      {
         data.getError().rowErrors[i].errorObj["attrId"] = RESOURCE[flag] + " " + attrName;
      }
      temperrObj = data.getError().rowErrors[i].errorObj;
      var nmPath = temperrObj["path"];
      var simplePath = handlePath( nmPath );
      temperrObj["path"] = simplePath;
   }

   errArr.push( "nename" );
   errArr.push( "slotid" );
   errArr.push( "boardname" );

   errArr.push( "attrId" );
   openErrPage( "../../../../../page/", data.getError(), errArr );
}

/* *
 *         
 *
 * @param  
 * @return  
 */
function sendQueryRightReq( querySfid, applySfid )
{
   var url = "../../../../../securityServlet?neID=" + winurlobj["neid"] + "&nmUser=" + winurlobj["nmUser"];
   loadXMLdoc( url, "POST", false, rightHandleBack, null, "inputdata=" + createRightXML( querySfid, applySfid ) );
}

/* *
 *           
 *
 * @param  
 * @return  
 */
function rightHandleBack( doc )
{
   var data = EncapsulateData( doc );

   for ( var i = 0; i < data.getDataRowLength();
   i ++ ) //        
   {
      if ( 0 == data.getDataRowParam( i, "right" ) )
      {
         if ( data.getDataRowParam( i, "type" ) == "query" )
         {
            hasQueryRight = false;
         }
         else
         {
            hasApplyRight = false;
         }
      }
   }
   $( "querybtn" ).disabled = ! hasQueryRight;
   $( "applybtn" ).disabled = true;
}

/* *
 *           XML
 *
 * @param  
 * @return  
 */
function createRightXML( querySfid, applySfid )
{
   var root = new inputxml( "datainterface" );
   var firstlevel = new tagElement( "bussiness-params" );

   var secondlevel = null;
   var thirdlevel = null;
   secondlevel = new tagElement( "row-params" );
   thirdlevel = new tagElement( "param" );
   thirdlevel.setAttribute( "name", "type" );
   thirdlevel.setAttribute( "value", "query" );
   secondlevel.appendChild( thirdlevel );

   thirdlevel = new tagElement( "param" );
   thirdlevel.setAttribute( "name", "sfid" );
   thirdlevel.setAttribute( "value", querySfid );
   secondlevel.appendChild( thirdlevel );
   firstlevel.appendChild( secondlevel );

   secondlevel = new tagElement( "row-params" );
   thirdlevel = new tagElement( "param" );
   thirdlevel.setAttribute( "name", "type" );
   thirdlevel.setAttribute( "value", "apply" );
   secondlevel.appendChild( thirdlevel );

   thirdlevel = new tagElement( "param" );
   thirdlevel.setAttribute( "name", "sfid" );
   thirdlevel.setAttribute( "value", applySfid );
   secondlevel.appendChild( thirdlevel );

   firstlevel.appendChild( secondlevel );

   root.getRoot().appendChild( firstlevel );
   return root.toString();
}

function popupMenuHandler( evt )
{
   if ( ! evt )
   {
      evt = window.event;
   }

   var elem = ( evt.target ) ? evt.target : evt.srcElement;

   if ( elem != null && elem.blur )
   {
      elem.blur();
   }

   while ( elem != null )
   {
      if ( elem.tagName == 'TD' )
      {
         break;
      }
      else
      {
         elem = elem.parentNode;
      }
   }

   if ( elem == null || elem.tagName != 'TD' || null == elem.parent || elem.editElement == null )
   {
      return;
   }

   var rowid = elem.parentNode.rowIndex;
   var rows = elem.parent.getSelectedRows();
   var colid = elem.colid;

   if ( rows.contains( rowid ) )
   {

      if ( null != elem.editElement && elem.isEdit == 1 )
      {
         if ( ttiCols.contains( colid ) )
         {
            createTTIColsPupupMenu( elem, evt );
         }
         else
         {
            createTablePopupMenu( elem, evt );
         }
         return;
      }

      for ( var i = 0; i < rows.length; i ++ )
      {
         var tmpElem = elem.parent.getCellElement( rows[i], colid );
         if ( null != tmpElem.editElement && tmpElem.isEdit == 1 )
         {
            if ( ttiCols.contains( colid ) )
            {
               createTTIColsPupupMenu( tmpElem, evt );
            }
            else
            {
               createTablePopupMenu( tmpElem, evt );
            }
            return;
         }
      }
   }
}


function createTTIColsPupupMenu( elem, evt )
{
   removejsDOMmenu();
   var cursorMenu1 = new jsDOMenu( 150 );
   cursorMenu1.addMenuItem( new menuItem( RESOURCE["copyactualvalue"], "", copyActualValue, elem ) );
   cursorMenu1.addMenuItem( new menuItem( RESOURCE["manualinput"], "", ttiManualInput, elem ) );
   setPopUpMenu( cursorMenu1 );
   showMenu( evt );
}

/* *
 * copy value from actual
 *
 * @param elem
 */
function copyActualValue( elem )
{
   var colid = elem.colid;

   var rtti = "OTN_PM_R_TTI";
   var sttiarray = ["ST_SRC_FLAG", "ST_SINK_FLAG", "ST_USER_FLAG"];
   if( colid == "OTN_SM_SR_TTI" || colid == "OTN_SM_ST_TTI" )
   {
      rtti = "OTN_SM_R_TTI";
   }
   else if( colid == "OTN_TCM_SR_TTI" || colid == "OTN_TCM_ST_TTI" )
   {
      rtti = "OTN_TCM_R_TTI";
   }
   if( colid == "OTN_SM_SR_TTI" || colid == "OTN_TCM_SR_TTI" || colid == "OTN_PM_SR_TTI" )
   {
      sttiarray = ["SR_SRC_FLAG", "SR_SINK_FLAG", "SR_USER_FLAG"];
   }

   var rttiarray = ["R_SRC_FLAG", "R_SINK_FLAG", "R_USER_FLAG"];
   var rows = st.getSelectedRows();
   var tmpElem = null;
   var rttiElem = null;
   var blError = false;
   var blSucc = false;
   for( var i = 0; i < rows.length; i ++ )
   {
      tmpElem = st.getCellElement( rows[i], colid );
      if( tmpElem.isEdit != 1 )
      {
         continue;
      }
      rttiElem = st.getCellElement( rows[i], rtti );
      var showText = st.getAtomValue( rttiElem.showElement );
      if( showText == "" || showText == "/" || showText == "-" )
      {
         blError = true;
         continue;
      }
      blSucc = true;
      for( var j = 0; j < rttiarray.length; j ++ )
      {
         tmpElem.currentValue[sttiarray[j]] = rttiElem.currentValue[rttiarray[j]];
         tmpElem.storeValue[sttiarray[j]] = rttiElem.storeValue[rttiarray[j]];
      }

      st.setAtomValue( tmpElem.showElement, showText );

      tmpElem.modify = true;

      tmpElem.style.background = "#d0f946";

      tmpElem.parentNode.modify = true;
   }
   if( blError )
   {
      hideMenu();
      alert( RESOURCE["copyerror"] );
   }
   if( hasApplyRight && blSucc )
   {
      $( "applybtn" ).disabled = false;
   }
}

/* *
 * manual input
 *
 * @param elem
 */
function ttiManualInput( elem )
{
   hideMenu();
   elem.ondblclick();
}

function convertTTIValue( value )
{
   if ( curDisMode == TTI_HEX_MODE )
   {
      return addSpace( value );
   }
   else
   {
      var ttivalue = hex2Text( value );
      while ( ttivalue.length >= 2 )
      {
         if ( "00" == ttivalue.substring( ttivalue.length - 2, ttivalue.length ) )
         {
            ttivalue = ttivalue.substring( 0, ttivalue.length - 2 );
         }
         else
         {
            break;
         }
      }
      return ttivalue;
   }
}

/* *
 *       16            16        
 */
function addSpace( value )
{
   var temp = "";
   for( var i = 0, len = value.length; i < len;
   i ++ )
   {
      temp += value.substring( i, i + 2 );

      if( i < value.length - 1 )
      {
         temp += " ";
      }
      i ++ ;
   }
   return temp;
}



function showErrorDialog( data )
{
   var errArr = [];
   errArr[0] = "nename";
   errArr[1] = "boardname";
   errArr[2] = "portid";
   openErrPage( "../../../../../page/", data.getError(), errArr );
}





function createQueryAvailableXML( neid, slotid, tableconf )
{
   var di = new inputxml( "datainterface" );
   var bussiness = new tagElement( "bussiness-params" );
   var row = new tagElement( "row-params" );
   var param = new tagElement( "param" );
   param.setAttribute( "name", "neid" );
   param.setAttribute( "value", neid );
   row.appendChild( param );

   param = new tagElement( "param" );
   param.setAttribute( "name", "slotid" );
   param.setAttribute( "value", slotid );
   row.appendChild( param );

   var colids = "";
   var sp = "";
   for ( var i = 1; i < tableconf.getColsLength();
   i ++ )
   {
      colid = tableconf.getColId( i );
      colids = colids + sp + colid;
      sp = ",";
   }
   param = new tagElement( "param" );
   param.setAttribute( "name", "attrNames" );
   param.setAttribute( "value", colids );
   row.appendChild( param );
   bussiness.appendChild( row );
   di.getRoot().appendChild( bussiness );
   return di.toString();
}

var filterCondition =
{
   selectedPorts : [], selectedGrades : [], selectedTcmLevels : []
};

function refreshFilterCondition( ports, grades, tcmlevels )
{
   filterCondition.selectedPorts.clear();
   filterCondition.selectedGrades.clear();
   filterCondition.selectedTcmLevels.clear();
   for( var i = 0, len = ports.length; i < len; i ++ )
   {
      filterCondition.selectedPorts[i] = ports[i];
   }
   for( var i = 0, len = grades.length; i < len; i ++ )
   {
      filterCondition.selectedGrades[i] = grades[i];
   }
   for( var i = 0, len = tcmlevels.length; i < len; i ++ )
   {
      filterCondition.selectedTcmLevels[i] = tcmlevels[i];
   }
}
