
var win = getParentWindow();

var winurlobj = getNeProperty(self);



var ct = null;

var rowindex = winurlobj["rowindex"];

var st = win.downTable;


function init()
{
	initTable();
    initData();
}

function initTable()
{
	ct = new CTable();
    ct.addHead(RESOURCE["attibutename"], RESOURCE["attrvalue"]);
    
    var atom = new Atom("text");
    atom.setValue("1");
    ct.addAttrRow("msinumber", RESOURCE["msinumber"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    ct.addAttrRow("msitimeslots", RESOURCE["msitimeslots"], atom);
    
    atom = new Atom("text");
    atom.setValue("");
    ct.addAttrRow("stmsi", RESOURCE["stmsi"], atom);
    
    atom.element.style.imeMode = "disabled";
    atom.element["onkeypress"] = function(evt)
    {
    	evt = evt?evt:window.event;
        return chkPath(this,evt);
    }
	atom.element.onpaste = function()
	{
		return false;
	}
	
    
    atom = new Atom("text");
    atom.setValue("");
    ct.addAttrRow("srmsi", RESOURCE["srmsi"], atom);
    
    atom.element.style.imeMode = "disabled";
    atom.element["onkeypress"] = function(evt)
    {
    	evt = evt?evt:window.event;
        return chkPath(this,evt);
    }
	atom.element.onpaste = function()
	{
		return false;
	}
  
    
    document.getElementById("bodytable").appendChild(ct.getTable());
}

function initData()
{
	 var msinumber = ct.getAtom("msinumber").element;
	 textCheck(msinumber,1,win.currentTimeslots);
	 
	 var timeslotsSelect = ct.getAtom("msitimeslots").element;
	 var curOduklevel =st.getCellStoreValue(rowindex,"oduklevel","oduklevel");
	 if (curOduklevel == "ODUflex")
	 {
		for (var i = 0; i <= win.currentTimeslots; i++)
		{
			timeslotsSelect.options[timeslotsSelect.options.length] = new Option(i,i);
		}
	 }
	 else
	 {
		var maxTimesslots = win.getMaxTimesSlots(curOduklevel);	
		timeslotsSelect.options[timeslotsSelect.options.length] = new Option(0,0);
		timeslotsSelect.options[timeslotsSelect.options.length] = new Option(maxTimesslots,maxTimesslots);	
	    timeslotsSelect.options.selectedIndex = 1;			
	 }
				 
}

function chkPath(obj,event)
{

    if(!restrict(obj, event, "-,0123456789"))
    {
        return false;
    }
    else
    {
    	return checkRange(obj, event);
    }
    return true;
}

function doOk()
{
    var rows = st.getSelectedRows();
    var numberValue = ct.getAtom("msinumber").getValue();	
    var timeslots = ct.getAtom("msitimeslots").getValue();
    var stmsi = ct.getAtom("stmsi").getValue();
    var srmsi = ct.getAtom("srmsi").getValue();
   
    if (stmsi == "" && srmsi == "")
    {
    	xcloseDialog();
    	return;
    }
   
    if (timeslots == 0)
    {
    	if (stmsi != "" && stmsi != 0)
    	{
    		alert(RESOURCE["msiinputzero"]);
    		return;
    	}
    	if (srmsi != "" && srmsi != 0)
    	{
    		alert(RESOURCE["msiinputzero"]);
    		return;
    	}
    }
   
    if (stmsi != "" && (timeslots != 0 && stmsi != "0") && validTimeslotsCount(stmsi) != parseInt(timeslots,10))
    {
    	alert(RESOURCE["stmsisame"]);
    	return;
    }
    if (srmsi != "" && (timeslots != 0 && srmsi != "0") && validTimeslotsCount(srmsi) !=  parseInt(timeslots,10))
    {
    	alert(RESOURCE["srmsisame"]);
    	return;
    }
	for(var i = 0,len = rows.length; i<len; i++)
	{
		var index = rows[i];
		setWinTableValue(index,"number",numberValue);
		setWinTableValue(index,"timeslots",timeslots);
		if (stmsi != null && stmsi !="" && stmsi != "undefined")
		{
			setWinTableValue(index,"OTN_MSI_ST",stmsi);
		} 
		if (srmsi != null && srmsi !="" && srmsi != "undefined")
		{
			setWinTableValue(index,"OTN_MSI_SR",srmsi);
		} 
	}
	xcloseDialog();
}

/**
 *               -,
 * - 189
 * , 188
 */ 
function restrict(field,event,strallow)
{
   var key,keychar;
   
   key = (event.keyCode!=0?event.keyCode:event.charCode);
   
   keychar = String.fromCharCode(key);
   
    if(key == 13){
   	
    event.srcElement.blur();
    return true;	
   }
   
   if((key == null) || (key == 0) || (key == 8) || (key == 9) ||(key == 27)||(key == 189)||(key == 188))
    { 
      return true;
    }
   else if((strallow.indexOf(keychar) != -1))
   {
      return true;
   }
   else
   {
      return false;
   }
}

function checkRange(obj, event)
{
	var key,keychar;   
	key = (event.keyCode!=0?event.keyCode:event.charCode);   
	keychar = String.fromCharCode(key);
	
	var value = obj.value;
	var pos=digitalTag_getPos(obj);
	if (keychar == "0")
	{
		var val = value.substring(0,pos);
		var vArray = val.split(",");
		var tmp = vArray[vArray.length-1].split("-");
		if (parseInt(tmp[tmp.length-1]) == 0)
		{
			return false;
		}
	}
	
	var newVal = value.substring(0,pos) + keychar + value.substring(pos+selectionLen(obj));
	var vArr = newVal.split(",");
	var minValue = 0;
	if (ct.getAtom("msitimeslots").getValue() != 0)
	{
		minValue = 1; 
	}
	for (var i = 0; i < vArr.length; i++)
	{
		var va = vArr[i].split("-");
		for (var j = 0; j < va.length; j++)
		{
    		if (parseInt(va[j]) < minValue || parseInt(va[j]) > win.currentTimeslots)
			{
    			alert(RESOURCE["numberLimit"] + win.currentTimeslots + RESOURCE["numberLimit2"]);
				return false;
			}
		}
	}
	return true;
}

function validTimeslotsCount(strValues)
{
	var tmpCount = 0;
	var items = strValues.split(",");
	for (var i = 0; i < items.length; i++)
    {
    	var str = items[i];
    	if (str == "")
    	{
    		continue;
    	}
    	var pos = str.indexOf("-");
    	if (pos == -1)
    	{
    		tmpCount++;
    	}
    	else
    	{
    		var strObj = str.split("-");
    		var start = strObj[0];
    		var end =strObj[1];
    		if (start == "" || end == "")
    		{
    			continue;
    		}
    		tmpCount = tmpCount + (parseInt(end,10) - parseInt(start,10) + 1);
    	}   	
    }
    return tmpCount;
}

function setWinTableValue(index,colid,value)
{
    cell = st.getCell(index,colid);	
	cell.element.modify = true;
	cell.element.parentNode.modify = true;
    st.getCellElement(index,colid).style.backgroundColor = "#d0f946";
	st.setCellValue(cell,colid,value);
	st.getCellShow(index,colid).setValue(value);
	win.cellEditHandlerPath();
}
