
var btnRightArr = new Object();  //      

var winobj = getNeProperty(self);
var neid = winobj.neid;  //  ID
var nmUser = winobj.nmUser;  //  
var slotid = winobj.slotid;

var upTable;

var downTable;

var OPRSUCC = 0;
var OPRFAIL = 2;

var levelPathList = [];

var ODUKObj = [];
ODUKObj[0] = "ODUflex";
ODUKObj[1] = "ODU4";
ODUKObj[2] = "ODU3";
ODUKObj[3] = "ODU2";
ODUKObj[4] = "ODU1";
ODUKObj[5] = "ODU0";

var currentTimeslots = 1;

var tc = window.tableconf[1];


function init()
{
	initTitle();
	initUpTable();
	initDownTable();
	initCheckBox(true);
	initBtnRight();
	if (btnRightArr.queryBtn.right)
	{
		doQuery();
	}
}


function initTitle()
{
	$("portenable").innerText = RESOURCE["portenableinfo"];
	$("msidetail").innerText = RESOURCE["msidetailinfo"];
	
	$("query").value = RESOURCE["querybutton"];
	$("apply").value = RESOURCE["applybutton"];
	$("querypath").value = RESOURCE["querybutton"];
	$("applypath").value = RESOURCE["applybutton"];	
}


function initUpTable()
{
    upTable = new SortTable();
    upTable.setImage("../../../../../images/");
    createTableHead(upTable, window.tableconf[0]);
    upTable.setBodyWidth(getComponetHeight($("uptablediv"), 120)/2+"px");
    upTable.setSingleChoiceFlg(true);
    upTable.setOnRowSelectHandler(portSelectHandler);
    upTable.setOnCellEditHandler(cellEditHandler);
    $("portenabletable").appendChild(upTable.getTable());  
    $("portenabletable").oncontextmenu = popupMenuHandler; 
}


function cellEditHandler()
{
	$("apply").disabled = !btnRightArr.applyBtn.right;
}


function initDownTable()
{
	downTable = new SortTable();
    downTable.setImage("../../../../../images/");
    createTableHead(downTable, window.tableconf[1]);
    downTable.setBodyWidth(getComponetHeight($("downtablediv"), 126)/2+"px");
    
    var tableHeight = getComponetHeight($("uptablediv"),170)*0.4;
    tableHeight = tableHeight + getComponetHeight($("downtablediv"),170)*0.4;
	tableHeight = tableHeight<100?100:tableHeight;
	downTable.setBodyHeight(tableHeight*1.35+"px");
	upTable.setBodyHeight(tableHeight*0.5+"px");
	
	downTable.setOnCellEditHandler(cellEditHandlerPath);
	
	var hc = downTable.getHeadCell("path");
	
    downTable.setHCAttribute(hc, 1, 0, comparePath);
	
  
    $("msidetailtable").appendChild(downTable.getTable());
}

function comparePath(str1, str2)
{
	
	var path1 = Number(str1.substring(str1.lastIndexOf("-") + 1, str1.length));
    var path2 = Number(str2.substring(str2.lastIndexOf("-") + 1, str2.length));

    if (path1 > path2) 
    {
        return 1;
    }
    else if (path1 < path2) 
    {
        return -1;
    }
    else 
    {
        return 0;
    }
}

function cellEditHandlerPath()
{
	$("applypath").disabled = !btnRightArr.applyBtn.right;
}

function initBtnRight()
{
	btnRightArr.queryBtn = new BtnRightObj("queryBtn", TE_FUNC_CFG_SM_OVERHEAD);  
    btnRightArr.applyBtn = new BtnRightObj("applyBtn", TE_FUNC_SFG_SM_OVERHEAD);      
     
    sendRightInfo(btnRightArr);
    
    $("query").disabled = !btnRightArr.queryBtn.right; 
    $("querypath").disabled = !btnRightArr.queryBtn.right;   
}


function createRightXML()
{
	var root = new inputxml("datainterface");//Create the root of a xml file
	var firstlevel = new tagElement("bussiness-params");
	
	var secondlevel=null;;
	var thirdlevel=null;
	
    for(var btnrightobj in btnRightArr)
	{
		secondlevel = new tagElement("row-params"); //bean         	
		
		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name","btnID");
		thirdlevel.setAttribute("value",btnRightArr[btnrightobj].btnId);
		secondlevel.appendChild(thirdlevel);
		
		thirdlevel = new tagElement("param");	
		thirdlevel.setAttribute("name","sfid");
		thirdlevel.setAttribute("value",btnRightArr[btnrightobj].sfid);
		secondlevel.appendChild(thirdlevel);
		
		firstlevel.appendChild(secondlevel);
	}
	root.getRoot().appendChild(firstlevel);
	return root.toString();
}

function sendRightInfo()
{
	var url = "../../../../../securityServlet?neID=" + neid + "&nmUser=" + nmUser;
	loadXMLdoc(url, "POST", false, rightHandleBack, null, "inputdata=" + createRightXML());
}

function rightHandleBack(doc)
{
	var data = EncapsulateData(doc);
	for(var i = 0; i < data.getDataRowLength(); i++)  //       
    {
		var right = data.getDataRowParam(i,"right");
    	
      	if(0 == right)
		{
			btnRightArr[data.getDataRowParam(i,"btnID")].right = false;
		} 
		else
		{
			btnRightArr[data.getDataRowParam(i,"btnID")].right = true;
		}        
    }   
}

function doQuery()
{
	$("query").disabled = true;
    $("apply").disabled = true;  
    
	var xml = createQueryPortEnableXML();
	var url = "../../../../../neExlorerServlet?sfid="+TECMDCODE_QUERY_AUTOMSI_ENABLE + "&nmUser=" + nmUser; 
	loadXMLdoc(url, "POST",false,queryPortCallBackHandler,null,"inputdata=" + xml);
}

function createQueryPortEnableXML()
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);
    
    var param = new tagElement("param");    
    param.setAttribute("name","slotid");
    param.setAttribute("value",slotid);
    row.appendChild(param);
    
    var param = new tagElement("param");    
    param.setAttribute("name","port");
    param.setAttribute("value",0);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}



function queryPortCallBackHandler(doc)
{
    $("query").disabled = false;
    
	var data = EncapsulateData(doc); 
	  
    if (OPRFAIL != data.getSErrorCode()) 
    {      
	    upTable.clearTableData();
        createTableBody(upTable, window.tableconf[0], data, RESOURCE);
    }
	for (var i = 0; i < data.getBErrLength(); i++) 
    {

        errorObj = data.getError().rowErrors[i].errorObj;
        errorObj["operateObj"] = errorObj["nename"] + "-" + errorObj["fullportname"];       
    } 
	
	var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../../page/", data.getError(), errArr);    
	    
   
}

var portQueryFlag = 0;
/**
 *              (MSI  )  
 */
function portSelectHandler()
{
	if (upTable.getSelectedRows().length != 1)
	{
		downTable.clearTableData();
		initCheckBox(true);
		$("apply").disabled = true;  
        $("applypath").disabled = true; 
		return;
	}
	var selectRow = upTable.getSelectedRows()[0];
	var msienable = upTable.getCellStoreValue(selectRow, "automsienable", "automsienable");
	if (msienable == 1)
	{
		downTable.clearTableData();
		initCheckBox(true);
		$("cbGradeAllSelect").disabled = true;
		$("querypath").disabled = true;
        $("applypath").disabled = true; 
		return;
	}
	else
	{
		$("cbGradeAllSelect").disabled = false;
		$("querypath").disabled = false;
	}
	var port = upTable.getCellStoreValue(selectRow,"port","port");
	if (portQueryFlag == 0)
	{
		portQueryFlag = 1;
		queryPortSupportLevel(port);		
	}
	
}

function doGradeAllSelect()
{
    var checkflag = $("cbGradeAllSelect").checked;
    setODUCheckBox("check_ODU0",checkflag);	
    setODUCheckBox("check_ODU1",checkflag);
    setODUCheckBox("check_ODU2",checkflag);
    setODUCheckBox("check_ODU3",checkflag);
    setODUCheckBox("check_ODU4",checkflag);
    setODUCheckBox("check_ODUflex",checkflag);
}

function setODUCheckBox(checkboxid,flag)
{
	if ($(checkboxid).disabled == false)
	{
		$(checkboxid).checked = flag;
	}
}

function doQueryPath()
{	
	if (upTable.getSelectedRows().length != 1)
	{
		alert(RESOURCE["selectport"]);
		return;
	}
	var pathlist = getCheckPathObj();
	if (pathlist.length == 0)
	{
		alert(RESOURCE["selectgrade"]);
		return;
	}
	var selectRow = upTable.getSelectedRows()[0];
	
	var port = upTable.getCellStoreValue(selectRow,"port","port");

	queryMSIOverhead(selectRow,port,pathlist);	
		

}

function getCheckPathObj()
{
	var list = [];
	for (var i=0,len = levelPathList.length;i<len;i++)
	{
		var data = levelPathList[i];
		var odu = data.level;
		if ($("check_"+odu).checked == true)
		{
			list[list.length] = odu;
		}		
	}
	return list;
}

function queryPortSupportLevel(port)
{
	var xml = createQueryLevelXML(port);
	var url = "../../../../../neExlorerServlet?sfid="+TECMDCODE_QUERY_MSI_SUPPORTGRADE + "&nmUser=" + nmUser; 
	loadXMLdoc(url, "POST",true, queryLevelCallBackHandler, null,"inputdata=" + xml);
}

function createQueryLevelXML(portid)
{
		var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);
    
    var param = new tagElement("param");    
    param.setAttribute("name","slotid");
    param.setAttribute("value",slotid);
    row.appendChild(param);
    
    var param = new tagElement("param");    
    param.setAttribute("name","port");
    param.setAttribute("value",portid);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function queryLevelCallBackHandler(doc)
{	
	levelPathList.length = 0;
	portQueryFlag = 0;
	var data = EncapsulateData(doc); 

	for (var i=0,len = data.getDataRowLength();i<len;i++)
	{
		var level = data.getDataRowParam(i,"level");
		var oduk = level.split("-")[0];
		var maxTimesSlots = level.split("-")[1];
		var pathlist = data.getDataRowParam(i,"pathList");
		var pathdata = new LevelPath();
		pathdata.level = oduk;
		pathdata.maxTimeslots = parseInt(maxTimesSlots,10);
		pathdata.pathlist = pathlist;
		levelPathList[i] = pathdata;
		setODUCheckBoxEnable(oduk);
	}
	currentTimeslots = getCurrentNumber();
}

function getMaxTimesSlots(level)
{
	for (var i=0,len = levelPathList.length;i<len;i++)
	{
		var data = levelPathList[i];
		var odu = data.level;
		if (odu == level)
		{
			return data.maxTimeslots;
		}		
	}
	return 0;
}

function getCurrentNumber()
{
	for (var i=0,len = ODUKObj.length;i<len;i++)
	{
		var value = getMaxTimesSlots(ODUKObj[i]);
		if (value != 0)
		{
			return value;
		}
	}
	return 80;
}

function setODUCheckBoxEnable(level)
{
	$("check_"+level).disabled = false;
	$("check_"+level).checked = true;
	$("cbGradeAllSelect").checked = true;
}

function initCheckBox(flag)
{
	$("check_ODU0").disabled = flag;
	$("check_ODU1").disabled = flag;
	$("check_ODU2").disabled = flag;
	$("check_ODU3").disabled = flag;
	$("check_ODU4").disabled = flag;
	$("check_ODUflex").disabled = flag;
	$("check_ODU0").checked = !flag;
	$("check_ODU1").checked = !flag;
	$("check_ODU2").checked = !flag;
	$("check_ODU3").checked = !flag;
	$("check_ODU4").checked = !flag;
	$("check_ODUflex").checked = !flag;
	$("cbGradeAllSelect").checked = !flag;
}

function queryMSIOverhead(row,port,pathlist)
{	
	$("query").disabled = true;
    $("apply").disabled = true;  
    $("querypath").disabled = true;
    $("applypath").disabled = true; 
    
    
	var xml = createQueryMSIXML(port,pathlist);
	var url = "../../../../../neExlorerServlet?sfid="+TECMDCODE_QUERY_MSI_OVERHEAD + "&nmUser=" + nmUser; 
	loadXMLdoc(url, "POST",true, queryMSICallBackHandler, null,"inputdata=" + xml);
}



function createQueryMSIXML(portid,pathlist)
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i=0,len = pathlist.length;i<len;i++)
    {
    	var odulevel = pathlist[i];
    	var pathstr = getPathfromLevel(odulevel);
    	var row = new tagElement("row-params");
    
	    var param = new tagElement("param");    
	    param.setAttribute("name","neid");
	    param.setAttribute("value",neid);
	    row.appendChild(param);
	    
	    var param = new tagElement("param");    
	    param.setAttribute("name","slotid");
	    param.setAttribute("value",slotid);
	    row.appendChild(param);
	    
	    var param = new tagElement("param");    
	    param.setAttribute("name","port");
	    param.setAttribute("value",portid);
	    row.appendChild(param);
	    	    
	    var param = new tagElement("param");    
	    param.setAttribute("name","path");
	    param.setAttribute("value",pathstr);
	    row.appendChild(param);
	    
	    bussiness.appendChild(row);    
    }
  
   
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function getPathfromLevel(level)
{
	for (var i=0,len = levelPathList.length;i<len;i++)
	{
		var data = levelPathList[i];
		var odu = data.level;
		if (odu == level)
		{
			return data.pathlist;
		}		
	}
	return "0";
}

function queryMSICallBackHandler(doc)
{
	$("query").disabled = false;
	$("querypath").disabled = false;
    
	var data = EncapsulateData(doc); 
	if (OPRFAIL != data.getSErrorCode()) 
    {      
	    downTable.clearTableData();
        createTableBody(downTable, window.tableconf[1], data, RESOURCE);
        addListener();
    }
	for (var i = 0; i < data.getBErrLength(); i++) 
    {
        errorObj = data.getError().rowErrors[i].errorObj;
        var nmPath = errorObj["path"];
	    var simplePath = handlePath(nmPath);
        if (simplePath == -1)
        {
        	simplePath = 1;
        }
        if (nmPath == 0)
        {
        	errorObj["operateObj"] = errorObj["portname"] + "-" + RESOURCE["rmsitimeslots"];
        }
        else
        {
        	errorObj["operateObj"] = errorObj["portname"] + "-" + simplePath;     
        }
          
    } 
	var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../../page/", data.getError(), errArr);    
	    
    
}


function doApply()
{
  	$("apply").disabled = true;
	var xmlData = createApplyPortEnableXML();
	var url = "../../../../../neExlorerServlet?sfid="+TECMDCODE_SET_AUTOMSI_ENABLE+"&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, callBackApply, null, "inputdata="+xmlData);	   
}

function createApplyPortEnableXML()
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
   
    
    for (var rowindex = 0, rowlen = upTable.getDataRowLength(); rowindex < rowlen; rowindex++) 
    {
        if (!upTable.getModify(rowindex)) 
        {
            continue;
        }
	    var row = new tagElement("row-params");
	    var param = new tagElement("param");    
	    param.setAttribute("name","neid");
	    param.setAttribute("value",neid);
	    row.appendChild(param);
	    
	    var param = new tagElement("param");    
	    param.setAttribute("name","slotid");
	    param.setAttribute("value",slotid);
	    row.appendChild(param);
	       
	    var portid = upTable.getCellStoreValue(rowindex, "port", "port");   
	    var param = new tagElement("param");    
	    param.setAttribute("name","port");
	    param.setAttribute("value",portid);
	    row.appendChild(param);
	    
	    var param = new tagElement("param");    
	    param.setAttribute("name","path");
	    param.setAttribute("value",1);
	    row.appendChild(param);
	    
	    var msienable = upTable.getCellStoreValue(rowindex, "automsienable", "automsienable");   
	    var param = new tagElement("param");    
	    param.setAttribute("name","automsienable");
	    param.setAttribute("value",msienable);
	    row.appendChild(param);
	    
	    
	    bussiness.appendChild(row);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function callBackApply(doc)
{
    var data = EncapsulateData(doc);
	var errArr = [];
    errArr[0] = "errObjStr";
    openErrPage("../../../../../page/", data.getError(), errArr);    
    
    refreshTableState(upTable, window.tableconf[0], data);
      
    if (0 == data.getSErrorCode())
    {
    	portSelectHandler();
    	$("apply").disabled = true;
	}
    else
    {
    	$("apply").disabled = false;
    }   
}


function doApplyPath()
{
  	$("applypath").disabled = true;
	var xmlData = createApplyPathXML();
	var url = "../../../../../neExlorerServlet?sfid="+TECMDCODE_SET_MSI_OVERHEAD+"&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, callBackApplyPath, null, "inputdata="+xmlData);	   
}


function createApplyPathXML()
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
   
    
    for (var rowindex = 0, rowlen = downTable.getDataRowLength(); rowindex < rowlen; rowindex++) 
    {
        if (!downTable.getModify(rowindex)) 
        {
            continue;
        }
	    var row = new tagElement("row-params");
	    var param = new tagElement("param");    
	    param.setAttribute("name","neid");
	    param.setAttribute("value",neid);
	    row.appendChild(param);
	    
	    var param = new tagElement("param");    
	    param.setAttribute("name","slotid");
	    param.setAttribute("value",slotid);
	    row.appendChild(param);
	       
	    var portid = downTable.getCellStoreValue(rowindex, "port", "port");  
	    var param = new tagElement("param");    
	    param.setAttribute("name","portid");
	    param.setAttribute("value",portid);
	    row.appendChild(param);
	    
	    var pathid = downTable.getCellStoreValue(rowindex, "path", "path");  
	    var param = new tagElement("param");    
	    param.setAttribute("name","pathid");
	    param.setAttribute("value",pathid);
	    row.appendChild(param);
	    
	    var path = downTable.getCellShow(rowindex, "path").getValue();
	    var param = new tagElement("param");    
	    param.setAttribute("name","path");
	    param.setAttribute("value",path);
	    row.appendChild(param);
	    
	    var number = downTable.getCellStoreValue(rowindex, "number", "number");   
	    var param = new tagElement("param");    
	    param.setAttribute("name","msivalue");
	    param.setAttribute("value",number);
	    row.appendChild(param);
	    
	    var timeslots = downTable.getCellStoreValue(rowindex, "timeslots", "timeslots");   
	    var param = new tagElement("param");    
	    param.setAttribute("name","msitimeslots");
	    param.setAttribute("value",timeslots);
	    row.appendChild(param);
	    
	    var stmsi = downTable.getCellStoreValue(rowindex, "OTN_MSI_ST", "OTN_MSI_ST"); 
	    if (stmsi == null) 
	    {
	    	stmsi = "";
	    } 
	    var param = new tagElement("param");    
	    param.setAttribute("name","stmsi");
	    param.setAttribute("value",stmsi);
	    row.appendChild(param);
	    
	    var srmsi = downTable.getCellStoreValue(rowindex, "OTN_MSI_SR", "OTN_MSI_SR"); 
	    if (srmsi == null) 
	    {
	    	srmsi = "";
	    }
	    var param = new tagElement("param");    
	    param.setAttribute("name","srmsi");
	    param.setAttribute("value",srmsi);
	    row.appendChild(param);
	    
	    
	    bussiness.appendChild(row);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}


function callBackApplyPath(doc)
{
    var data = EncapsulateData(doc);
    
    for (var i = 0; i < data.getBErrLength(); i++) 
    {
        errorObj = data.getError().rowErrors[i].errorObj;
        var nmPath = errorObj["path"];
	    var simplePath = handlePath(nmPath);
        if (simplePath == -1)
        {
        	simplePath = 1;
        }
        errorObj["errObjStr"] = errorObj["portname"] + "-" + simplePath;       
    } 
    
	var errArr = [];
    errArr[0] = "errObjStr";
    openErrPage("../../../../../page/", data.getError(), errArr);    
    
    refreshTableState(downTable, window.tableconf[1], data);
      
    if (0 == data.getSErrorCode())
    {
    	$("applypath").disabled = true;
	}
    else
    {
    	$("applypath").disabled = false;
    }   
}

function addListener()
{
	for(var i = 0,len = downTable.getDataRowLength();i<len;i++)
	{
		for (var colindex = 1; colindex < 5; colindex++) 
        {         
	        colid = tc.getColId(colindex);
		    cell = downTable.getCell(i,colid);
	        if(null != cell&&cell.element.isEdit)
	        {
				cell.element["ondblclick"] = function()
				{
					this.modify = true;  
	                this.parentNode.modify = true;			
					showInputDialog(this);	
				}		
	        }
        }
	}
}

function showInputDialog(cellElement)
{
	var row = cellElement.parentNode.rowIndex;
	xshowModalDialog("msioverheadinputdialog.html?rowindex="+row,"",490,180,"../../../../../images/");
}

function LevelPath()
{
	this.level = "";
	this.pathlist = "";
	this.maxTimeslots = 1;
}
