
var WEST_WORK_UNIT = 1;  //      
var WEST_PROTECTION_UNIT = 2;  //      
var EAST_WORK_UNIT = 3;  //      
var EAST_PROTECTION_UNIT = 4;  //      
var ITG_FLAG = 1; //    

var dataModify = new Array();
var dataModify_Unit = new Array();

var btnRightArr = new Object();  //      

var winobj = parseURLStr(self);
var neid = winobj.neid;  //  ID
var nmUser = winobj.nmUser;  //  

var currentPageStatus = new Object();
currentPageStatus.PROTOCOL_NOT_START = 0;  //     
currentPageStatus.PROTOCOL_STARTING = 1;  //      
currentPageStatus.IDLE = 2;  //  
currentPageStatus.EAST_SWITCH = 3;  //    
currentPageStatus.WEST_SWITCH = 4;  //    
currentPageStatus.THROUGH = 5;  //   
currentPageStatus.APS_THROUGH = 6;  //APS    

var switchRequest = new Object();  //    
switchRequest.NR = 0x00;  //   
switchRequest.EXER_R = 0x03;  //     
switchRequest.WTR_R = 0x06;  //        
switchRequest.MS_R = 0x08;  //     
switchRequest.SD_W = 0x0A;  //SD      SD  OK
switchRequest.SD_R = 0x0B;  //SD      SD  SD
switchRequest.SD_P = 0x0D;  //  SD
switchRequest.FS_R = 0x0E;  //     
switchRequest.SF_W = 0x10;  //SF      SF  OK
switchRequest.SF_RW = 0x11;  //SF      SF  SD
switchRequest.SF_RP = 0x12;  //SF      SD  SF
switchRequest.SF_R = 0x13;  //SF      SF  SF
switchRequest.SF_P = 0x15;  //  SF
switchRequest.LP = 0x16;  //  

var farOrNearIdentifier = new Object();
farOrNearIdentifier.FAR = 0;  //  
farOrNearIdentifier.NEAR = 1;  //  

var pathState = new Object();
pathState.SF = 1;//SF
pathState.SD = 2;//SD
pathState.NORMAL = 4;//  
pathState.UNMONITOR = 5;//   

var protectionGroupSTable = null;  //   Table
var bdmappedTable = null;  //    Table

var MINWTRTIME = "05:00";

var MAXWTRTIME = "12:00"


var MAXWTRVALUE = "720";

var MINWTRVALUE = "300";
   
var REVERTIVWTRTIME = "10:00";

function init()
{
	initTitle();
	initProtectionGroup();
	initMappedTable();
	initData();
	if (btnRightArr.queryBtn.right)
	{
		queryODUkSPRing();
	}
}

function initTitle()
{
	$("grouplabel").innerText = RESOURCE["protectiongroup"];
	$("mappedlabel").innerText = RESOURCE["bdmapprelation"];
	
	$("start").value = RESOURCE["startprotocol"];
	$("stop").value = RESOURCE["stopprotocol"];
	$("query").value = RESOURCE["querybutton"];
	$("new").value = RESOURCE["newbutton"];
	$("add").value = RESOURCE["addmappedbutton"];
	$("deletemapped").value = RESOURCE["deletemappedbutton"];
	$("delete").value = RESOURCE["deletebutton"];
	$("apply").value = RESOURCE["applybutton"];
}

window.onresize = function()
{
    protectionGroupSTable.setBodyWidth(getComponetHeight($("ttbody"), 120)/2+"px");
    bdmappedTable.setBodyWidth(getComponetHeight($("ttbody"), 126)/2+"px");
}
function initProtectionGroup()
{
    protectionGroupSTable = new SortTable();
    protectionGroupSTable.setImage("../../../../images/");
    createTableHead(protectionGroupSTable, window.tableconf[0]);
    protectionGroupSTable.setBodyWidth(getComponetHeight($("ttbody"), 120)/2+"px");
    protectionGroupSTable.setOnRowSelectHandler(rowSelectHandler_ProtectionGroupSTable);
    protectionGroupSTable.setOnCellEditHandler(cellEditHandler);
    
    $("protectiongrouptable").appendChild(protectionGroupSTable.getTable());
    $("protectiongrouptable").oncontextmenu = popupMenuHandler;    
}

function initMappedTable()
{
	bdmappedTable = new SortTable();
    bdmappedTable.setImage("../../../../images/");
    createTableHead(bdmappedTable, window.tableconf[1]);
    bdmappedTable.setBodyWidth(getComponetHeight($("ttbody"), 126)/2+"px");
    bdmappedTable.setOnRowSelectHandler(rowSelectHandler_BdmappedTable);
    bdmappedTable.setOnCellEditHandler(bdmappedTableCellEditHandler);
    
    $("bdmappedtable").appendChild(bdmappedTable.getTable());
    $("bdmappedtable").oncontextmenu = rightClickEventByPath;
        
    var tableHeight = getComponetHeight($("ttbody"),170)*0.4;
	tableHeight = tableHeight<100?100:tableHeight;
	bdmappedTable.setBodyHeight(tableHeight+"px");
	protectionGroupSTable.setBodyHeight(tableHeight+"px");
	$("protectiongrouptable").style.height = (tableHeight + 46)+"px" ;
	$("bdmappedtable").style.height = (tableHeight + 46)+"px" ;
}
function BtnRightObj(btnId,sfid)
{
	if(null != btnId)
	{
	   	this.btnId = btnId;
	}
	else
	{
	    this.btnId = "";
  	}
	
  	if(isNaN(parseInt(sfid)))
	{
	  	this.sfid = -1;
	}
	else
	{
		this.sfid = sfid;
	}
	this.right = true;
}

function initData()
{
	btnRightArr.queryBtn = new BtnRightObj("queryBtn", TECMDCODE_QUERY_ODUSPRING);  
	btnRightArr.queryPathBtn = new BtnRightObj("queryPathBtn", TECMDCODE_QUERY_ODUSPRING_PATH);  
    btnRightArr.createBtn = new BtnRightObj("createBtn", TECMDCODE_CREATE_ODUSPRING);    
    btnRightArr.deleteBtn = new BtnRightObj("deleteBtn", TECMDCODE_DELETE_ODUSPRING);    
    btnRightArr.addBtn = new BtnRightObj("addBtn", TECMDCODE_ADD_WORKUNIT); 
    btnRightArr.deletePathBtn = new BtnRightObj("deletePathBtn", TECMDCODE_DELETE_WORKUNIT);
    btnRightArr.applyBtn = new BtnRightObj("applyBtn", TECMDCODE_MODIFY_ODUSPRING);    
    btnRightArr.queryStateBtn = new BtnRightObj("queryStateBtn", TECMDCODE_QUERY_ODUSPRING_SWITCH);
    btnRightArr.switchStateBtn = new BtnRightObj("switchStateBtn", TECMDCODE_SET_ODUSPRING_SWITCH);
    btnRightArr.boundSectionIdBtn = new BtnRightObj("boundSectionIdBtn", TECMDCODE_BIND_ODUSPRING_SECTIONID);
    btnRightArr.clearSectionIdBtn = new BtnRightObj("clearSectionIdBtn", TECMDCODE_UNBOUND_ODUSPRING_SECTIONID);
    btnRightArr.setProtocolBtn = new BtnRightObj("setProtocolBtn", TECMDCODE_SET_ODUSPRING_PROTOCOL);
     
    sendRightInfo(btnRightArr);
    
    $("query").disabled = !btnRightArr.queryBtn.right;
    $("new").disabled = !btnRightArr.createBtn.right;  
}

function createRightXML()
{
	var root = new inputxml("datainterface");//Create the root of a xml file
	var firstlevel = new tagElement("bussiness-params");
	
	var secondlevel=null;;
	var thirdlevel=null;
	
    for(var btnrightobj in btnRightArr)
	{
		secondlevel = new tagElement("row-params"); //bean         	
		
		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name","btnID");
		thirdlevel.setAttribute("value",btnRightArr[btnrightobj].btnId);
		secondlevel.appendChild(thirdlevel);
		
		thirdlevel = new tagElement("param");	
		thirdlevel.setAttribute("name","sfid");
		thirdlevel.setAttribute("value",btnRightArr[btnrightobj].sfid);
		secondlevel.appendChild(thirdlevel);
		
		firstlevel.appendChild(secondlevel);
	}
	root.getRoot().appendChild(firstlevel);
	return root.toString();
}

function sendRightInfo()
{
	var url = "../../../../securityServlet?neID=" + neid + "&nmUser=" + nmUser;
	loadXMLdoc(url, "POST", false, rightHandleBack, null, "inputdata=" + createRightXML());
}

function rightHandleBack(doc)
{
	var data = EncapsulateData(doc);
	for(var i = 0; i < data.getDataRowLength(); i++)  //       
    {
		var right = data.getDataRowParam(i,"right");
    	
      	if(0 == right)
		{
			btnRightArr[data.getDataRowParam(i,"btnID")].right = false;
		} 
		else
		{
			btnRightArr[data.getDataRowParam(i,"btnID")].right = true;
		}        
    }   
}

function addCellEventByWrtTime()
{
	var cell = null;
	for(var i = 0,len = protectionGroupSTable.getDataRowLength();i<len;i++)
	{		
		cell = protectionGroupSTable.getCell(i,"wtrTime");
		cellEdit = protectionGroupSTable.getCellEdit(i,"wtrTime");
		if (btnRightArr.applyBtn.right)
		{
			if(null != cell)
			{
				tenCellEvent(cellEdit.element, ":");
        cellEdit.element.maxLength = 5;
				checkWTRTime(cellEdit.element, MINWTRTIME, MAXWTRTIME);
			}
			var itgflag = protectionGroupSTable.getCellStoreValue(i, "itgflag", "itgflag");
			if (ITG_FLAG == itgflag)
			{
				cell = protectionGroupSTable.getCell(i,"mainNode");
				setIsEdit(cell);
			}
		}
		else
		{
			setIsEdit(cell);
			cell = protectionGroupSTable.getCell(i,"sdEnable");
			setIsEdit(cell);
			cell = protectionGroupSTable.getCell(i,"mainNode");
			setIsEdit(cell);
		}	
	}    
}

function addCellEventByDelayTime(rowIndex)
{
	var cell = null;
		var unit = parseInt(bdmappedTable.getCellStoreValue(rowIndex, "protectionunit", "protectionUnit"));	
		cell = bdmappedTable.getCell(rowIndex,"delayTime");
		if (btnRightArr.applyBtn.right)
		{
			if(null != cell)
			{
				if (WEST_WORK_UNIT == unit || EAST_WORK_UNIT == unit)
				{
					textCheck(cell.element.editElement.element, "0.0", "10.0");
				}
				else
				{
					textCheck(cell.element.editElement.element, "0.5", "10.0");
				}
			}
		}
		else
		{
			setIsEdit(cell);
		}	
}

function setIsEdit(cell)
{
	cell.element.style.backgroundColor = "";
	
	protectionGroupSTable.setCellIsEdit(cell,0);
	cell.element.ondblclick = null;
	cell.element.style.cursor = "default";
}

function cellEditHandler()
{
	$("apply").disabled = !btnRightArr.applyBtn.right;
}

function bdmappedTableCellEditHandler(param)
{
	if(param.colid != "delayTime")
	{
		return;
	}
	if(param.stage == TABLE_CONSTANT.BEFOREEDIT)
	{
		addCellEventByDelayTime(param.rowindex);
	}
	$("apply").disabled = false;
}

function rowSelectHandler_ProtectionGroupSTable()
{	
	var selectedRowCount = protectionGroupSTable.getSelectedRowCount();		
	if (selectedRowCount == 1)
	{	
		var length = bdmappedTable.getDataRowLength();
		if (btnRightArr.queryPathBtn.right)
		{
			var rowIndex = protectionGroupSTable.getSelectedRows()[0];
			var groupId = parseInt(protectionGroupSTable.getCellStoreValue(rowIndex, "protectiongroupid", "groupId"));
			var flag = true;
			for (var i = 0; i < length; i++)
			{
				var id = parseInt(bdmappedTable.getCellStoreValue(i, "protectiongroupid", "groupId"));
				if (id == groupId)
				{
					flag = false;
					break;
				}
			}
			if (flag)
			{
				bdmappedTable.clearTableData();
				$("deletemapped").disabled = true;
				queryMappedPath();
			}
		}
		$("delete").disabled = !btnRightArr.deleteBtn.right;
		$("start").disabled = !btnRightArr.setProtocolBtn.right;
		$("stop").disabled = !btnRightArr.setProtocolBtn.right;
	}
	else if (selectedRowCount > 1)
	{
		bdmappedTable.clearTableData();
		$("deletemapped").disabled = true;
		$("add").disabled = true;
		$("delete").disabled = !btnRightArr.deleteBtn.right;
		$("start").disabled = !btnRightArr.setProtocolBtn.right;
		$("stop").disabled = !btnRightArr.setProtocolBtn.right;
	}
	else
	{
		bdmappedTable.clearTableData();
		$("deletemapped").disabled = true;
		$("add").disabled = true;
		$("delete").disabled = true;
		$("start").disabled = true;
		$("stop").disabled = true;
	}
}

function changeBtnStatusByCreateODUk()
{
	$("deletemapped").disabled = true;
	if (bdmappedTable.getDataRowLength() < 4)
	{
		$("add").disabled = !btnRightArr.addBtn.right;
	}
	else
	{
		$("add").disabled = true;
	}
	$("delete").disabled = !btnRightArr.deleteBtn.right;
	$("start").disabled = !btnRightArr.setProtocolBtn.right;
	$("stop").disabled = !btnRightArr.setProtocolBtn.right;
}

function rowSelectHandler_BdmappedTable()
{
	var deleteMappedBtn = $("deletemapped");
	
	var selectedRowCount = bdmappedTable.getSelectedRowCount();
	if (selectedRowCount > 0)
	{
		var isDeleteMapped = true;
		var rowIndexes = bdmappedTable.getSelectedRows();
		for (var i = 0, m = rowIndexes.length; i < m; i++)
		{
			var proUnit = bdmappedTable.getCellStoreValue(rowIndexes[i], "protectionunit", "protectionUnit");
			var sectionId = bdmappedTable.getCellStoreValue(rowIndexes[i], "sectionid", "sectionId");
			if (parseInt(proUnit) != 1 && parseInt(proUnit) != 3)
			{
				isDeleteMapped = false;
				break;
			}
			else if (parseInt(sectionId) != 0)
			{
				isDeleteMapped = false;
				break;
			}			
		}
		if (isDeleteMapped)
		{
			deleteMappedBtn.disabled = !btnRightArr.deletePathBtn.right;
		}
		else
		{
			deleteMappedBtn.disabled = true;
		}
	}
	else
	{
		deleteMappedBtn.disabled = true;
	}
}

function changeButtonStatus()
{
	$("start").disabled = true;
	$("stop").disabled = true;
	$("query").disabled = true;
	$("new").disabled = true;
	$("add").disabled = true;
	$("deletemapped").disabled = true;
	$("delete").disabled = true;
	$("apply").disabled = true;
}

function showCreateODUkSPRingPage()
{
	xshowModalDialog("createodukspring.html", RESOURCE["newodukspring"], 750, 480, "../../../../images/");
}

function showAddMappedPathPage()
{
	xshowModalDialog("addmappedpath.html", RESOURCE["addmappedbutton"], 750, 480, "../../../../images/");
}

function showSetSectionIDPage()
{
	hideMenu();
	xshowModalDialog("../../page/odukspring/setsectionid.html", RESOURCE["setsectionid"], 290, 180, "../../../../images/");
}

function createFuncDOMenu()
{
	removejsDOMmenu();
	var isSelected = false;
	
	if (bdmappedTable.getSelectedRowCount() == 1)
	{
    	var cursorMenu = new jsDOMenu(140); 
		var index = bdmappedTable.getSelectedRows()[0];
		var direction = parseInt(bdmappedTable.getCellStoreValue(index, "protectionunit", "protectionUnit"));
		var itgflag = parseInt(bdmappedTable.getCellStoreValue(index, "itgflag", "itgflag"));
		
		if (WEST_WORK_UNIT == direction || EAST_WORK_UNIT == direction || ITG_FLAG == itgflag)
		{
			var value = bdmappedTable.getCellStoreValue(index, "sectionid", "sectionId");
    		if (parseInt(value) == 0)
    		{
    			cursorMenu.addMenuItem(new menuItem(RESOURCE["setsectionid"], "", showSetSectionIDPage, "", btnRightArr.boundSectionIdBtn.right));
    			cursorMenu.addMenuItem(new menuItem(RESOURCE["deletesectionid"], "", "", "", false));
    		}
    		else
    		{
    			cursorMenu.addMenuItem(new menuItem(RESOURCE["setsectionid"], "", "", "", false));
    			cursorMenu.addMenuItem(new menuItem(RESOURCE["deletesectionid"], "", deleteSectionID, "", btnRightArr.clearSectionIdBtn.right));
    		}
		}
		else
		{
			cursorMenu.addMenuItem(new menuItem(RESOURCE["setsectionid"], "", "", "", false));
    		cursorMenu.addMenuItem(new menuItem(RESOURCE["deletesectionid"], "", "", "", false));
		}
    	cursorMenu.addMenuItem(new menuItem("-"));
    	
		isSelected = btnRightArr.switchStateBtn.right;
    	
    	var args = null;
    	if (WEST_PROTECTION_UNIT == direction || EAST_PROTECTION_UNIT == direction)
    	{
    		if (WEST_PROTECTION_UNIT == direction)
    		{
    			direction = 1;
    		}
    		else
    		{
    			direction = 2;
    		}
			args = new Array();
    		args[0] = direction;
    		args[1] = "23";
    		cursorMenu.addMenuItem(new menuItem(RESOURCE["clear"], "", switchSataus, args, isSelected)); 
			cursorMenu.addMenuItem(new menuItem("-"));
    		args = new Array();		
    		args[0] = direction;
    		args[1] = "22";
    		cursorMenu.addMenuItem(new menuItem(RESOURCE["lock"], "", switchSataus, args, isSelected));    		
    		cursorMenu.addMenuItem(new menuItem("-"));
    	
    		cursorMenu.addMenuItem(new menuItem(RESOURCE["springforceswitch"], "", "", "", false));
    	
    		cursorMenu.addMenuItem(new menuItem(RESOURCE["springmanualswitch"], "", "", "", false));
    	
    		cursorMenu.addMenuItem(new menuItem(RESOURCE["springexerswitch"], "", "", "", false));    		
    	}
    	else
    	{    		
    		if (WEST_WORK_UNIT == direction)
    		{
    			direction = 1;
    		}
    		else
    		{
    			direction = 2;
    		}
			args = new Array();
    		args[0] = direction;
    		args[1] = "23";
    		cursorMenu.addMenuItem(new menuItem(RESOURCE["clear"], "", switchSataus, args, isSelected));  
			cursorMenu.addMenuItem(new menuItem("-"));  	
    		args = new Array();    		
    		args[0] = direction;
    		args[1] = "22";
    		cursorMenu.addMenuItem(new menuItem(RESOURCE["lock"], "", switchSataus, args, isSelected));    
    		cursorMenu.addMenuItem(new menuItem("-"));
    	
    		args = new Array();
    		args[0] = direction;
    		args[1] = "14";
    		cursorMenu.addMenuItem(new menuItem(RESOURCE["springforceswitch"], "", switchSataus, args, isSelected));
    	
    		args = new Array();
    		args[0] = direction;
    		args[1] = "8";
    		cursorMenu.addMenuItem(new menuItem(RESOURCE["springmanualswitch"], "", switchSataus, args, isSelected));
    	
    		args = new Array();
    		args[0] = direction;
    		args[1] = "3";
    		cursorMenu.addMenuItem(new menuItem(RESOURCE["springexerswitch"], "", switchSataus, args, isSelected));    				
    	}
    	
    	setPopUpMenu(cursorMenu);
    }
}

function rightClickEventByPath(evt)
{
    if(!evt)
  	{
  	  evt= window.event;	
  	}
  	 
    var elem = (evt.target) ? evt.target : evt.srcElement;   

    if(elem!= null&&elem.blur)
    {
    	elem.blur();	  	
    }
   
    while(elem!=null)
	{
	    if(elem.tagName == 'TD')
	    {
	        break;	
	    }
	    else
	    {
		    elem =elem.parentNode;	  	
	    }	
   	} 
  
	if(elem == null || elem.tagName != 'TD' || null == elem.parent)
	{
		  return;
	}  
	
	var rowid= elem.parentNode.rowIndex;
    var rows =elem.parent.getSelectedRows();
    var colid = elem.colid;
    if(rows.contains(rowid))
    {
		if (colid == "delayTime")
		{
			if (btnRightArr.applyBtn.right)
			{
				var flag = false;
				if (rows.length == 1)
				{
					flag = true;    				
    			}
    			else if (rows.length == 2)
    			{
    				var t1 = parseInt(elem.parent.getCellStoreValue(rows[0],"protectionunit", "protectionUnit"));
    				var t2 = parseInt(elem.parent.getCellStoreValue(rows[1],"protectionunit", "protectionUnit"));
    				if ((t2 - t1) == 2 || (t2- t1) == -2)
    				{
    					flag = true;
    				}
    			}
    			else
    			{
    				flag = false;
    			}
    			if (flag)
    			{
    				for (var i = 0, m = rows.length; i < m; i++)
    				{
    					var tmpElem = elem.parent.getCellElement(rows[i],colid);
    					if(null != tmpElem.editElement && tmpElem.isEdit == 1)
    					{
    						createTablePopupMenu(tmpElem,evt);
    			 			return;
    					}
    				}
    			}
			}
			return;
		}
		else
		{
			createFuncDOMenu();
			showMenu(evt);
			return;
		}	
	}
}

function createQueryODUkSPRing()
{
	var root = new inputxml("datainterface");      
  	var firstlevel = new tagElement("bussiness-params");
  			
	var secondlevel = new tagElement("row-params");
    var thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name", "neid");
   	thirdlevel.setAttribute("value", neid);
   	secondlevel.appendChild(thirdlevel);   	
   	
    thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name", "groupId");
   	thirdlevel.setAttribute("value", "0");
   	secondlevel.appendChild(thirdlevel);
   		
	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);	
	return root.toString();
}

function queryODUkSPRing()
{
	var xml = createQueryODUkSPRing();
	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_QUERY_ODUSPRING+"&nmUser=" + nmUser; 
	loadXMLdoc(url, "POST",false,callBackHandlerByQueryODUkSPRing,null,"inputdata=" + xml);
}

function callBackHandlerByQueryODUkSPRing(doc)
{
	var data = EncapsulateData(doc);
	
   	var errArr = [];
	errArr[0] = "errObjStr";
    var oError = getOperationObj(data);
    showErrorDialog(oError, errArr);
    
    if (0 == data.getSErrorCode() || 1 == data.getSErrorCode())
    {
		protectionGroupSTable.clearTableData();
		bdmappedTable.clearTableData();		
		
		changeButtonStatus();
		$("query").disabled = !btnRightArr.queryBtn.right;
		$("new").disabled = !btnRightArr.createBtn.right;
		
		createTableBody(protectionGroupSTable, window.tableconf[0], constructtbXML(data), RESOURCE);    	
    	addCellEventByWrtTime();
    	
    	if(!protectionGroupSTable.element.colsArray.selectedId)
		{
	  	   protectionGroupSTable.element.colsArray.selectedId = "protectiongroupid";
	  	   protectionGroupSTable.element.colsArray.imgflag = 1;
		}
		var td=protectionGroupSTable.element.headRow.element.cols[protectionGroupSTable.element.colsArray.selectedId].element; 
		protectionGroupSTable.sortRows(td,protectionGroupSTable.element.colsArray.imgflag);
    }
    else if (protectionGroupSTable.getDataRowLength() == 0)
    {
    	adjustTableLayout(protectionGroupSTable, window.tableconf[0], 0);
    }    	
}

function constructtbXML(dinterface)
{
    for(var i = 0, m = dinterface.getDataRowLength(); i < m; i++)
	{
	    var obj = dinterface.rows[i];
	    var param = dinterface.getDataRowParam(i, "wtrTime");
	    if ("" == param || parseInt(param) < 6 || parseInt(param) > 720)
	    {
	    	obj["wtrTime"].value = MINWTRTIME; 
	    }
	    param = dinterface.getDataRowParam(i, "sdEnable");
	    if ("0" != param && "1" != param)
	    {
	    	obj["sdEnable"].value = "0";
	    }
	    param = dinterface.getDataRowParam(i, "pageStatus");
	    if ("" == param)
	    {
	    	obj["pageStatus"].value = "255";
	    }
	    param = dinterface.getDataRowParam(i, "westSwitchRequest");
	    if ("" == param)
	    {
	    	obj["westSwitchRequest"].value = "255";
	    }
	    param = dinterface.getDataRowParam(i, "eastSwitchRequest");
	    if ("" == param)
	    {
	    	obj["eastSwitchRequest"].value = "255";
	    }
	    param = dinterface.getDataRowParam(i, "westIdentifier");
	    if ("0" != param && "1" != param)
	    {
	    	obj["westIdentifier"].value = "1";
	    }
	    param = dinterface.getDataRowParam(i, "eastIdentifier");
	    if ("0" != param && "1" != param)
	    {
	    	obj["eastIdentifier"].value = "1";
	    }
	    param = dinterface.getDataRowParam(i, "mainNode");
	    if ("0" != param && "1" != param)
	    {
	    	obj["mainNode"].value = "0";
	    }
    }
    return dinterface;
}

function createQueryMappedPathXML()
{
	var rowIndex = protectionGroupSTable.getSelectedRows()[0];
	var groupId = protectionGroupSTable.getCellStoreValue(rowIndex, "protectiongroupid", "groupId");
	var proType = protectionGroupSTable.getCellShow(rowIndex, "protectiontype").element.innerText;
	
	var root = new inputxml("datainterface");      
  	var firstlevel = new tagElement("bussiness-params");
  	
	var secondlevel = new tagElement("row-params");
    var thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name", "neid");
   	thirdlevel.setAttribute("value", neid);
   	secondlevel.appendChild(thirdlevel);   	
   	
    thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name", "groupId");
   	thirdlevel.setAttribute("value", groupId);
   	secondlevel.appendChild(thirdlevel);
   	
   	thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name", "protectionType");
   	thirdlevel.setAttribute("value", proType);
   	secondlevel.appendChild(thirdlevel);
   		
	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);	
	return root.toString();
}

function queryMappedPath()
{
	var xml = createQueryMappedPathXML();
	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_QUERY_ODUSPRING_PATH+"&nmUser=" + nmUser;
	loadXMLdoc(url, "POST",false,callBackHandlerByQueryMappedPath,null,"inputdata=" + xml);
}

function callBackHandlerByQueryMappedPath(doc)
{
	bdmappedTable.clearTableData();
	var data = EncapsulateData(doc);
	
	var errArr = [];
    errArr[0] = "errObjStr";
	var oError = getOperationObj(data);
    if(data.getBErrLength() > 0)
    {
    	for (var i = data.getBErrLength() - 1; i >= 0; i--)
    	{
    		var code = data.getBErrorCode(i);
    		for (var j = i - 1; j >= 0; j--)
    		{
    			if (data.getBErrorCode(j) == code)
    			{
    				oError.rowErrors[i] = null;
    				break;
    			}
    		}
    	}
    }
    showErrorDialog(oError, errArr);
    for(var j = data.getDataRowLength() - 1;j >=0; j--)
    {
    	var sectionId = data.getDataRowParam(j,"sectionId");
    	if(sectionId == "")
    	{
    		data.rows[j]["sectionId"].value = "-";
    	}
    }
    
    createTableBody(bdmappedTable, window.tableconf[1], data, RESOURCE);
	
    
    if(!bdmappedTable.element.colsArray.selectedId)
	{
	  	   bdmappedTable.element.colsArray.selectedId = "protectionunit";
	  	   bdmappedTable.element.colsArray.imgflag = 0;
	}
	var td=bdmappedTable.element.headRow.element.cols[bdmappedTable.element.colsArray.selectedId].element; 
	bdmappedTable.sortRows(td,bdmappedTable.element.colsArray.imgflag);
    
	if (bdmappedTable.getDataRowLength() >= 2 && bdmappedTable.getDataRowLength() < 4)
	{
		$("add").disabled = !btnRightArr.addBtn.right;
	}
	else
	{
		$("add").disabled = true;
	}
}

function convertMsg(resobj,	cvtobj,cvtvalue)
{	
	if("function" == (typeof cvtobj))	
	{
		return cvtobj(cvtvalue);
	}
	else
	{
		return resobj[cvtobj[cvtvalue]];
	}
}

function convertSectionId(value)
{
	if (parseInt(value) == 0)
	{
		return RESOURCE["none"];
	}
	else
	{
		return value;
	}
}

function createSetProtocolStartOrStopXML(protocolFlag)
{
	var root = new inputxml("datainterface");      
  	var firstlevel = new tagElement("bussiness-params");
  	
	var selectedRowIndexes = protectionGroupSTable.getSelectedRows();
	for (var i = 0, m = selectedRowIndexes.length; i < m; i++)
	{
		var rowIndex = selectedRowIndexes[i];
		var groupId = protectionGroupSTable.getCellStoreValue(rowIndex, "protectiongroupid", "groupId");
		
		var secondlevel = new tagElement("row-params");
    	var thirdlevel = new tagElement("param");
  		thirdlevel.setAttribute("name", "neid");
   		thirdlevel.setAttribute("value", neid);
   		secondlevel.appendChild(thirdlevel);   	
   		
    	thirdlevel = new tagElement("param");
  		thirdlevel.setAttribute("name", "groupId");
   		thirdlevel.setAttribute("value", groupId);
   		secondlevel.appendChild(thirdlevel);
   		
   		thirdlevel = new tagElement("param");
  		thirdlevel.setAttribute("name", "protocolFlag");
   		thirdlevel.setAttribute("value", protocolFlag);
   		secondlevel.appendChild(thirdlevel);
   		
		firstlevel.appendChild(secondlevel);
	}
	root.getRoot().appendChild(firstlevel);
	
	return root.toString();
}

function setProtocolStartOrStop(protocolFlag)
{
	var isConfirm = false;
	if (0 == protocolFlag)
	{
		if (confirm(RESOURCE["confirmtip"]))
		{
			isConfirm = true;
		}
	}
	else
	{
		isConfirm = true;
	}
	if (isConfirm)
	{
		var xml = createSetProtocolStartOrStopXML(protocolFlag);
		var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_SET_ODUSPRING_PROTOCOL+"&nmUser=" + nmUser;
		loadXMLdoc(url, "POST",false,callBackHandlerBySetProtocol,null,"inputdata=" + xml);
	}
}

function callBackHandlerBySetProtocol(doc)
{
	var data = EncapsulateData(doc);
   	var errArr = [];
    errArr[0] = "errObjStr";
    showErrorDialog(getOperationObj(data), errArr); 
    if(0 == data.getSErrorCode()) 
    { 
       alert(RESOURCE["sendcmdsuccess"]); 
    } 
}

function createDeleteODUkSPRingXML()
{
	var root = new inputxml("datainterface");      
  	var firstlevel = new tagElement("bussiness-params");
  	
	var selectedRowIndexes = protectionGroupSTable.getSelectedRows();
	for (var i = 0, m = selectedRowIndexes.length; i < m; i++)
	{
		var rowIndex = selectedRowIndexes[i];
		var groupId = protectionGroupSTable.getCellStoreValue(rowIndex, "protectiongroupid", "groupId");
		
		var secondlevel = new tagElement("row-params");
    	var thirdlevel = new tagElement("param");
  		thirdlevel.setAttribute("name", "neid");
   		thirdlevel.setAttribute("value", neid);
   		secondlevel.appendChild(thirdlevel);   	
   		
    	thirdlevel = new tagElement("param");
  		thirdlevel.setAttribute("name", "groupId");
   		thirdlevel.setAttribute("value", groupId);
   		secondlevel.appendChild(thirdlevel);
   		
		firstlevel.appendChild(secondlevel);
	}
	root.getRoot().appendChild(firstlevel);
	
	return root.toString();
}

function deleteODUkSPRing()
{
	if (confirm(RESOURCE["confirmpg"] + RESOURCE["confirmmsg"]))
	{
		changeButtonStatus();
		var xml = createDeleteODUkSPRingXML();
		var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_DELETE_ODUSPRING+"&nmUser=" + nmUser;
		loadXMLdoc(url, "POST",false,callBackHandlerByDeleteODUkSPRing,null,"inputdata=" + xml);
	}
}

function callBackHandlerByDeleteODUkSPRing(doc)
{
	var data = EncapsulateData(doc);
	
	var errArr = [];
    errArr[0] = "errObjStr";
    showErrorDialog(getOperationObj(data), errArr); 
    
    if(0 == data.getSErrorCode())//      
    {
    	bdmappedTable.clearTableData();
    	
        var rowIndex = protectionGroupSTable.getSelectedRows();

        for(var j = 0;j < rowIndex.length;j++)
        {
            protectionGroupSTable.deleteRow(rowIndex[j]);
        }
        protectionGroupSTable.adjustDataRows();        
    }
    else if(1 == data.getSErrorCode())//    
    {
        var tempGroupID = null;//          ID
        var errObj = data.getError();//AllError          
        var rowErrorArray = errObj.rowErrors;//    RowError  

		var selectedRows = protectionGroupSTable.getSelectedRows();
		for (var k = selectedRows.length - 1; k >= 0; k--)
		{
			var flag = false;
			tempGroupID = protectionGroupSTable.getCellStoreValue(selectedRows[k],"protectiongroupid","groupId");
			for (var m = 0, len = rowErrorArray.length; m < len; m++)
			{
			  	var errorObj = rowErrorArray[m].errorObj;//    RowError       
			  	if (tempGroupID == errorObj.groupId)
			  	{
			  	  	flag = true;
			  	}
			}
			if (!flag)
			{			  	      
			  	protectionGroupSTable.deleteRow(selectedRows[k]);
			}
		}
		protectionGroupSTable.adjustDataRows();
		
		bdmappedTable.clearTableData();
		rowSelectHandler_ProtectionGroupSTable();
	}
	else
	{
		changeBtnStatusByCreateODUk();
		rowSelectHandler_BdmappedTable();
	}
	if (protectionGroupSTable.getDataRowLength() == 0)
    {
    	adjustTableLayout(protectionGroupSTable, window.tableconf[0], 0);
    }
	$("query").disabled = !btnRightArr.queryBtn.right;
    $("new").disabled = !btnRightArr.createBtn.right;  
}

function createDeletePathMappedXML()
{
	var root = new inputxml("datainterface");      
  	var firstlevel = new tagElement("bussiness-params");
	
	var selectedRowIndexes = bdmappedTable.getSelectedRows();
	for (var i = 0, m = selectedRowIndexes.length; i < m; i++)
	{
		var rowIndex = selectedRowIndexes[i];
		var groupId = bdmappedTable.getCellStoreValue(rowIndex, "protectiongroupid", "groupId");
		var proUnit = bdmappedTable.getCellStoreValue(rowIndex, "protectionunit", "protectionUnit");
		
		var secondlevel = new tagElement("row-params");
    	var thirdlevel = new tagElement("param");
  		thirdlevel.setAttribute("name", "neid");
   		thirdlevel.setAttribute("value", neid);
   		secondlevel.appendChild(thirdlevel);   	
   		
    	thirdlevel = new tagElement("param");
  		thirdlevel.setAttribute("name", "groupId");
   		thirdlevel.setAttribute("value", groupId);
   		secondlevel.appendChild(thirdlevel);
	
		thirdlevel = new tagElement("param");
  		thirdlevel.setAttribute("name", "protectionUnit");
   		thirdlevel.setAttribute("value", proUnit);
   		secondlevel.appendChild(thirdlevel);
   		
   		var pathMapped = bdmappedTable.getCellStoreValue(rowIndex, "pathmapped", "pathMapped");
   		thirdlevel = new tagElement("param");
  		thirdlevel.setAttribute("name", "pathMapped");
   		thirdlevel.setAttribute("value", pathMapped);
   		secondlevel.appendChild(thirdlevel);   	   	
   		
   		firstlevel.appendChild(secondlevel);
	}
	root.getRoot().appendChild(firstlevel);
	
	return root.toString();
}

function deletePathMapped()
{
	if (confirm(RESOURCE["confirmwu"] + RESOURCE["confirmmsg"]))
	{
		changeButtonStatus();
		var xml = createDeletePathMappedXML();
		var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_DELETE_WORKUNIT+"&nmUser=" + nmUser;	
		loadXMLdoc(url, "POST",false,callBackHandlerByDeletePathMapped,null,"inputdata=" + xml);
	}
}

function callBackHandlerByDeletePathMapped(doc)
{
	var data = EncapsulateData(doc);
	
	var errArr = [];
    errArr[0] = "errObjStr";
    showErrorDialog(getErrorObj(data), errArr);
    
    
    if (0 == data.getSErrorCode() || 1 == data.getSErrorCode())
    {
    	var selectedIndexes = bdmappedTable.getSelectedRows();
    	for (var i = 0, length = data.getBErrLength(); i < length; i++)
    	{
    		var proType = data.getBErrParam(i, "protectionUnit");
    		for (var j = selectedIndexes.length - 1; j >= 0; j--)
    		{
    			var rowIndex = selectedIndexes[j]
    			var proUnit =  bdmappedTable.getCellStoreValue(rowIndex, "protectionunit", "protectionUnit");
    			if (proUnit == proType)
    			{
    				delete(selectedIndexes[j]);
    			}
    		}
    	}
    	for (var k = selectedIndexes.length - 1; k >= 0; k--)
    	{
    		var index = selectedIndexes[k];
    		if (index != null)
    		{
    			bdmappedTable.deleteRow(index);
    		}
    	}
    	bdmappedTable.adjustDataRows();
    }
    
    $("query").disabled = !btnRightArr.queryBtn.right;
    $("new").disabled = !btnRightArr.createBtn.right;
    $("delete").disabled = !btnRightArr.deleteBtn.right;
	$("start").disabled = !btnRightArr.setProtocolBtn.right;
	$("stop").disabled = !btnRightArr.setProtocolBtn.right;
    if (bdmappedTable.getSelectedRowCount() <= 0)
    {
    	$("deletemapped").disabled = true;
    }
    else
    {
    	$("deletemapped").disabled = !btnRightArr.deletePathBtn.right;
    }
    if (bdmappedTable.getDataRowLength() >= 2 && bdmappedTable.getDataRowLength() < 4)
	{
		$("add").disabled = !btnRightArr.addBtn.right;
	}
}

function createDeleteSectionIdXML()
{
	var root = new inputxml("datainterface");      
  	var firstlevel = new tagElement("bussiness-params");
  	
	var selectedRowIndexes = bdmappedTable.getSelectedRows();
	for (var i = 0, m = selectedRowIndexes.length; i < m; i++)
	{
		var rowIndex = selectedRowIndexes[i];
		var groupId = bdmappedTable.getCellStoreValue(rowIndex, "protectiongroupid", "groupId");
		var proUnit = bdmappedTable.getCellStoreValue(rowIndex, "protectionunit", "protectionUnit");
   		var mappedName = bdmappedTable.getCellStoreValue(rowIndex, "pathmapped", "pathMapped");
   		var oldSectionId = bdmappedTable.getCellStoreValue(rowIndex, "sectionid", "sectionId");	
       	
		var secondlevel = new tagElement("row-params");
    	var thirdlevel = new tagElement("param");
  		thirdlevel.setAttribute("name", "neid");
   		thirdlevel.setAttribute("value", neid);
   		secondlevel.appendChild(thirdlevel);   	
   		
    	thirdlevel = new tagElement("param");
  		thirdlevel.setAttribute("name", "groupId");
   		thirdlevel.setAttribute("value", groupId);
   		secondlevel.appendChild(thirdlevel);
	
		if (parseInt(proUnit) == 3)
		{
			proUnit = "2";
		}
		thirdlevel = new tagElement("param");
  		thirdlevel.setAttribute("name", "protectionUnit");
   		thirdlevel.setAttribute("value", proUnit);
   		secondlevel.appendChild(thirdlevel);
   	   		
   		thirdlevel = new tagElement("param");
  		thirdlevel.setAttribute("name", "sectionId");
   		thirdlevel.setAttribute("value", "0");
   		secondlevel.appendChild(thirdlevel);
   	
   		thirdlevel = new tagElement("param");
  		thirdlevel.setAttribute("name", "pathMapped");
   		thirdlevel.setAttribute("value", mappedName);
   		secondlevel.appendChild(thirdlevel);
   		
   		thirdlevel = new tagElement("param");
  		thirdlevel.setAttribute("name", "oldSectionId");
   		thirdlevel.setAttribute("value", oldSectionId);
   		secondlevel.appendChild(thirdlevel);   
   		
   		firstlevel.appendChild(secondlevel);
   	}
	root.getRoot().appendChild(firstlevel);
	
	return root.toString();
}

function deleteSectionID()
{
	hideMenu();
	var xml = createDeleteSectionIdXML();
	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_UNBOUND_ODUSPRING_SECTIONID+"&nmUser=" + nmUser;
	loadXMLdoc(url, "POST",false,callBackHandlerByDeleteSectionID,null,"inputdata=" + xml);
}

function callBackHandlerByDeleteSectionID(doc)
{
	var data = EncapsulateData(doc);
	
    var errArr = [];
    errArr[0] = "errObjStr";
    showErrorDialog(getErrorObj(data), errArr);
    
    if (0 == data.getSErrorCode())
    {
		var rowIndex = bdmappedTable.getSelectedRows()[0];
		bdmappedTable.setCellValue(bdmappedTable.getCell(rowIndex, "sectionid"), "sectionId", "0");
		bdmappedTable.getCellShow(rowIndex, "sectionid").element.innerText = RESOURCE["none"];
		$("deletemapped").disabled = !btnRightArr.deletePathBtn.right;
	}
}

function createQuerySwitchingStatusXML()
{
	var root = new inputxml("datainterface");      
  	var firstlevel = new tagElement("bussiness-params");
  	
	var rowIndex = protectionGroupSTable.getSelectedRows()[0];
	var groupId = protectionGroupSTable.getCellStoreValue(rowIndex, "protectiongroupid", "groupId");
       	
	var secondlevel = new tagElement("row-params");
    var thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name", "neid");
   	thirdlevel.setAttribute("value", neid);
   	secondlevel.appendChild(thirdlevel);   	
   		
    thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name", "groupId");
   	thirdlevel.setAttribute("value", groupId);
   	secondlevel.appendChild(thirdlevel);
	   		
   	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);
	
	return root.toString();
}

function querySwitchingStatus()
{
	hideMenu();
	var xml = createQuerySwitchingStatusXML();
	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_QUERY_ODUSPRING_SWITCH+"&nmUser=" + nmUser;
	loadXMLdoc(url, "POST",false,callBackHandlerByQuerySwitchingStatus,null,"inputdata=" + xml);
}

function callBackHandlerByQuerySwitchingStatus(doc)
{
	var data = EncapsulateData(doc);
	var errArr = [];
    errArr[0] = "errObjStr";
    showErrorDialog(getErrorObj(data), errArr);
	showSwitchStatus(doc);
}

function showSwitchStatus(doc)
{  
	var data = EncapsulateData(doc);
    if(0 == data.getSErrorCode())
    {
        var rowIndex = protectionGroupSTable.getSelectedRows()[0];
        var cell = protectionGroupSTable.getCell(rowIndex,"pagestatus");
        var atom = protectionGroupSTable.getCellShow(rowIndex,"pagestatus");
        
        var pageStatus = data.getDataRowParam(0,"pageStatus");    	
        switch(parseInt(pageStatus))
        {
        	case currentPageStatus.PROTOCOL_NOT_START:  //     
        		protectionGroupSTable.setCellValue(cell,"pageStatus", currentPageStatus.PROTOCOL_NOT_START);
        		protectionGroupSTable.setAtomValue(atom,RESOURCE["protocolnotstart"]);
        		break;
			case currentPageStatus.PROTOCOL_STARTING:  //      
				protectionGroupSTable.setCellValue(cell,"pageStatus", currentPageStatus.PROTOCOL_STARTING);
        		protectionGroupSTable.setAtomValue(atom,RESOURCE["protocolstarting"]);
        		break;
			case currentPageStatus.IDLE:  //  
				protectionGroupSTable.setCellValue(cell,"pageStatus", currentPageStatus.IDLE);
        		protectionGroupSTable.setAtomValue(atom,RESOURCE["idle"]);
        		break;
			case currentPageStatus.EAST_SWITCH:  //    
				protectionGroupSTable.setCellValue(cell,"pageStatus", currentPageStatus.EAST_SWITCH);
        		protectionGroupSTable.setAtomValue(atom,RESOURCE["eastswitch"]);
        		break;
			case currentPageStatus.WEST_SWITCH:  //    
				protectionGroupSTable.setCellValue(cell,"pageStatus", currentPageStatus.WEST_SWITCH);
        		protectionGroupSTable.setAtomValue(atom,RESOURCE["westswitch"]);
        		break;
			case currentPageStatus.THROUGH:  //   
				protectionGroupSTable.setCellValue(cell,"pageStatus", currentPageStatus.THROUGH);
        		protectionGroupSTable.setAtomValue(atom,RESOURCE["through"]);
        		break;
			case currentPageStatus.APS_THROUGH:  //APS    
					protectionGroupSTable.setCellValue(cell,"pageStatus", currentPageStatus.APS_THROUGH);
        		protectionGroupSTable.setAtomValue(atom,RESOURCE["apsthrough"]);
        		break;
            default:
            	protectionGroupSTable.setCellValue(cell,"pageStatus", pageStatus);
        		protectionGroupSTable.setAtomValue(atom,RESOURCE["unknown"]);
            	break;
        }
        
        var westSwitchRequest = data.getDataRowParam(0, "westSwitchRequest");        	
        refreshSwitchRequest(rowIndex, westSwitchRequest, "westswitchrequest");
        
        var eastSwitchRequest = data.getDataRowParam(0, "eastSwitchRequest");
        refreshSwitchRequest(rowIndex, eastSwitchRequest, "eastswitchrequest");
        
        var westIdentifier = data.getDataRowParam(0, "westIdentifier");
        refreshIdentifier(rowIndex, westIdentifier, "westIdentifier");
        
        var eastIdentifier = data.getDataRowParam(0, "eastIdentifier");
        refreshIdentifier(rowIndex, eastIdentifier, "eastIdentifier");

        var westWorkIndex = -1;
        var westProtectionIndex = -1;
        var eastWorkIndex = -1;
        var eastProtectionIndex = -1;
        
        for (var i = 0, m = bdmappedTable.getDataRowLength(); i < m; i++)
        {
        	var proUnit = bdmappedTable.getCellStoreValue(i, "protectionunit", "protectionUnit");
        	switch(parseInt(proUnit))
        	{
        		case WEST_WORK_UNIT:
        			westWorkIndex = i;
        			break;
        		case WEST_PROTECTION_UNIT:
        			westProtectionIndex = i;
        			break;
        		case EAST_WORK_UNIT:
        			eastWorkIndex = i;
        			break;
        		case EAST_PROTECTION_UNIT:
        			eastProtectionIndex = i;
        			break;
        		default:
        			break;
        	}
        }
        
        if (westWorkIndex != -1)
        {
        	var westWorkStatus = data.getDataRowParam(0,"westWorkStatus"); 
        	refreshPathStatus(westWorkIndex, westWorkStatus);
        }
        if (westProtectionIndex != -1)
        {
        	var westProtectionStatus = data.getDataRowParam(0,"westProtectionStatus"); 
        	refreshPathStatus(westProtectionIndex, westWorkStatus);
        } 
        if (eastWorkIndex != -1)
        {
        	var eastWorkStatus = data.getDataRowParam(0,"eastWorkStatus");
        	refreshPathStatus(eastWorkIndex, eastWorkStatus);
        } 
        if (eastProtectionIndex != -1)
        {
        	var eastProtectionStatus = data.getDataRowParam(0,"eastProtectionStatus");
        	refreshPathStatus(eastProtectionIndex, eastProtectionStatus);
        }         
	}
}

function refreshPathStatus(index, status)
{
	var cell = bdmappedTable.getCell(index, "pathstatus");
    var atom = bdmappedTable.getCellShow(index, "pathstatus");
	switch(parseInt(status))
	{
		case pathState.NORMAL:
        	bdmappedTable.setCellValue(cell,"prathStatus",pathState.NORMAL);
        	bdmappedTable.setAtomValue(atom,RESOURCE["normal"]);
        	break;
        case pathState.SD:
        	bdmappedTable.setCellValue(cell,"pathStatus",pathState.SD);
        	bdmappedTable.setAtomValue(atom,RESOURCE["sd"]);
        	break;
        case pathState.SF:
            bdmappedTable.setCellValue(cell,"pathStatus",pathState.SF);
        	bdmappedTable.setAtomValue(atom,RESOURCE["sf"]);
        	break;
        case pathState.UNMONITOR:
        	bdmappedTable.setCellValue(cell,"pathStatus",pathState.UNMONITOR);
        	bdmappedTable.setAtomValue(atom,RESOURCE["unmonitor"]);
        	break;
        default:
        	bdmappedTable.setCellValue(cell,"pathStatus",status);
        	bdmappedTable.setAtomValue(atom,RESOURCE["unknown"]);
        	break;
	}
}

function refreshSwitchRequest(index, status, key)
{
	var cell = protectionGroupSTable.getCell(index, key);
    var atom = protectionGroupSTable.getCellShow(index, key);
    switch(parseInt(status))
    {
    	case switchRequest.NR:
    		protectionGroupSTable.setCellValue(cell,key, switchRequest.NR);
        	protectionGroupSTable.setAtomValue(atom,RESOURCE["nr"]);
        	break;
        case switchRequest.EXER_R:
        	protectionGroupSTable.setCellValue(cell,key, switchRequest.EXER_R);
        	protectionGroupSTable.setAtomValue(atom,RESOURCE["exer_r"]);
        	break;
        case switchRequest.WTR_R:
        	protectionGroupSTable.setCellValue(cell,key, switchRequest.WTR_R);
        	protectionGroupSTable.setAtomValue(atom,RESOURCE["wtr_r"]);
        	break;
        case switchRequest.MS_R:
        	protectionGroupSTable.setCellValue(cell,key, switchRequest.MS_R);
        	protectionGroupSTable.setAtomValue(atom,RESOURCE["ms_r"]);
        	break;
        case switchRequest.SD_W:
        	protectionGroupSTable.setCellValue(cell,key, switchRequest.SD_W);
        	protectionGroupSTable.setAtomValue(atom,RESOURCE["sd_w"]);
        	break;
        case switchRequest.SD_R:
        	protectionGroupSTable.setCellValue(cell,key, switchRequest.SD_R);
        	protectionGroupSTable.setAtomValue(atom,RESOURCE["sd_r"]);
        	break;
        case switchRequest.SD_P:
        	protectionGroupSTable.setCellValue(cell,key, switchRequest.SD_P);
        	protectionGroupSTable.setAtomValue(atom,RESOURCE["sd_p"]);
        	break;
        case switchRequest.FS_R:
        	protectionGroupSTable.setCellValue(cell,key, switchRequest.FS_R);
        	protectionGroupSTable.setAtomValue(atom,RESOURCE["fs_r"]);
        	break;
        case switchRequest.SF_W:
        	protectionGroupSTable.setCellValue(cell,key, switchRequest.SF_W);
        	protectionGroupSTable.setAtomValue(atom,RESOURCE["sf_w"]);
        	break;
        case switchRequest.SF_RW:
        	protectionGroupSTable.setCellValue(cell,key, switchRequest.SF_RW);
        	protectionGroupSTable.setAtomValue(atom,RESOURCE["sf_rw"]);
        	break;
        case switchRequest.SF_RP:
        	protectionGroupSTable.setCellValue(cell,key, switchRequest.SF_RP);
        	protectionGroupSTable.setAtomValue(atom,RESOURCE["sf_rp"]);
        	break;
        case switchRequest.SF_R:
        	protectionGroupSTable.setCellValue(cell,key, switchRequest.SF_R);
        	protectionGroupSTable.setAtomValue(atom,RESOURCE["sf_r"]);
        	break;
        case switchRequest.SF_P:
        	protectionGroupSTable.setCellValue(cell,key, switchRequest.SF_P);
        	protectionGroupSTable.setAtomValue(atom,RESOURCE["sf_p"]);
        	break;
        case switchRequest.LP:
        	protectionGroupSTable.setCellValue(cell,key, switchRequest.LP);
        	protectionGroupSTable.setAtomValue(atom,RESOURCE["lp"]);
        	break;
        default:
        	protectionGroupSTable.setCellValue(cell,key, status);
        	protectionGroupSTable.setAtomValue(atom,RESOURCE["unknown"]);
        	break;
    }
}

function refreshIdentifier(index, identifier, key)
{
	var cell = protectionGroupSTable.getCell(index, key);
    var atom = protectionGroupSTable.getCellShow(index, key);
    switch(parseInt(identifier))
    {
    	case farOrNearIdentifier.FAR:
    		protectionGroupSTable.setCellValue(cell,key, farOrNearIdentifier.FAR);
        	protectionGroupSTable.setAtomValue(atom,RESOURCE["far"]);
        	break;
        case farOrNearIdentifier.NEAR:
        	protectionGroupSTable.setCellValue(cell,key, farOrNearIdentifier.NEAR);
        	protectionGroupSTable.setAtomValue(atom,RESOURCE["near"]);
        	break;
        default:
        	protectionGroupSTable.setCellValue(cell,key, identifier);
        	protectionGroupSTable.setAtomValue(atom,RESOURCE["unknown"]);
        	break;
    }
}

function createSwitchStatusXML(args)
{
	var rowIndex = protectionGroupSTable.getSelectedRows()[0];
	var groupId = protectionGroupSTable.getCellStoreValue(rowIndex, "protectiongroupid", "groupId");
	
	var root = new inputxml("datainterface");      
  	var firstlevel = new tagElement("bussiness-params");
  	      	
	var secondlevel = new tagElement("row-params");
    var thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name", "neid");
   	thirdlevel.setAttribute("value", neid);
   	secondlevel.appendChild(thirdlevel);   	
   		
    thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name", "groupId");
   	thirdlevel.setAttribute("value", groupId);
   	secondlevel.appendChild(thirdlevel);
   	  	
   	thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name", "direction");
   	thirdlevel.setAttribute("value", args[0]);
   	secondlevel.appendChild(thirdlevel);
   	
   	thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name", "switchcmd");
   	thirdlevel.setAttribute("value", args[1]);
   	secondlevel.appendChild(thirdlevel);
	   		
   	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);
	
	return root.toString();
}

function switchSataus(args)
{
	hideMenu();
	if(args[1] == "14")
	{
		var isSwitch = confirm(RESOURCE["switchconfirm"]);
		if(!isSwitch)
		{
			return;
		}
	}
	else if(args[1] == "22")
	{
		var isSwitch = confirm(RESOURCE["lockconfirm"]);
		if(!isSwitch)
		{
			return;
		}
	}
	var xml = createSwitchStatusXML(args);
	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_SET_ODUSPRING_SWITCH+"&nmUser=" + nmUser;
	loadXMLdoc(url, "POST",false,callBackHandlerBySwitchStatus,null,"inputdata=" + xml);
}

function callBackHandlerBySwitchStatus(doc)
{
	var data = EncapsulateData(doc);
	
	var errArr = [];
    errArr[0] = "errObjStr";
    showErrorDialog(getErrorObj(data), errArr);
    
    if(0 == data.getSErrorCode())
    {
    	alert(RESOURCE["sendcmdsuccess"]);
    }
}

function doApply()
{
	var j = 0;
	for(var i = 0, len = protectionGroupSTable.getDataRowLength();i<len;i++)
	{
	  	if(protectionGroupSTable.getModify(i) == true)
		{
			dataModify[j] = new Object();
			dataModify[j].wtrTime = protectionGroupSTable.getCellShow(i,"wtrTime").element.innerText;
			dataModify[j].wtrTimeFlag = protectionGroupSTable.getCellModify(i, "wtrTime");  //     ID       
			dataModify[j].sdtriggerflag = protectionGroupSTable.getCellStoreValue(i, "sdEnable", "sdEnable");
      		dataModify[j].sdtriggerflagFlag = protectionGroupSTable.getCellModify(i, "sdEnable");  //  SD           
      		dataModify[j].mainNode = protectionGroupSTable.getCellStoreValue(i, "mainNode", "mainNode");
      		dataModify[j].mainNodeFlag = protectionGroupSTable.getCellModify(i, "mainNode");  //                
      		
			dataModify[j].groupId = protectionGroupSTable.getCellStoreValue(i, "protectiongroupid", "groupId");
			dataModify[j].groupIdFlag = protectionGroupSTable.getCellModify(i, "protectiongroupid"); 
		  	j++;
		}
	}
	
	j = 0;
	for(var k = 0, len = bdmappedTable.getDataRowLength(); k < len; k++)
	{
	  	if(bdmappedTable.getModify(k) == true)
		{
			dataModify_Unit[j] = new Object();
			
			dataModify_Unit[j].delayTime = bdmappedTable.getCellStoreValue(k, "delayTime", "delayTime");
			dataModify_Unit[j].delayTimeFlag = bdmappedTable.getCellModify(k,"delayTime");//              
			
			dataModify_Unit[j].groupId = bdmappedTable.getCellStoreValue(k, "protectiongroupid", "groupId");
			dataModify_Unit[j].groupIdFlag = bdmappedTable.getCellModify(k, "protectiongroupid");
			
			dataModify_Unit[j].proUnit = bdmappedTable.getCellStoreValue(k, "protectionunit", "protectionUnit");			
			dataModify_Unit[j].proUnitFlag = bdmappedTable.getCellModify(k, "protectionunit");
			
			dataModify_Unit[j].pathMapped = bdmappedTable.getCellStoreValue(k, "pathmapped", "pathMapped");     
   	  		j++;
    	}
	}
    if((null == dataModify && null == dataModify_Unit)||(0 == dataModify.length && 0 == dataModify_Unit.length))
	{
		alert(RESOURCE["nomodifyinfo"]);
	}
	else
	{
      	$("apply").disabled = true;
		var xmlData = createApplyXML();
		var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_MODIFY_ODUSPRING+"&nmUser=" + nmUser;
	    loadXMLdoc(url, "POST", true, callBackApply, null, "inputdata="+xmlData);
	    dataModify = [];
	    dataModify_Unit = [];
	}
}

function createApplyXML()
{
	var root = new inputxml("datainterface");
 	var business = new tagElement("bussiness-params");
 	var row;
 	var param;

 	for(var i = 0 ,len=dataModify.length; i < len; i++)
 	{
 	  	row = new tagElement("row-params");
      	
 	  	param = new tagElement("param");
 	  	param.setAttribute("name", "neid");
 	  	param.setAttribute("value", neid);
 	  	row.appendChild(param);
      	
 	  	param = new tagElement("param");
 	  	param.setAttribute("name", "groupId");
 	  	param.setAttribute("value", dataModify[i].groupId);
 	  	param.setAttribute("modifyFlag",dataModify[i].groupIdFlag);
 	  	row.appendChild(param);
 	  	
 	  	param = new tagElement("param");
 	  	param.setAttribute("name", "wtrTime");
 	  	var wtrTimeValue = dataModify[i].wtrTime;//      
 	  	wtrTimeValue = convertMMSStoS(wtrTimeValue == "-" ? "-" : wtrTimeValue);
      if(isNaN(Number(wtrTimeValue)))
      { 
        wtrTimeAtom.element.select();
        alert(RESOURCE["wrong5"] + MINWTRTIME + RESOURCE["wrong2"] + MAXWTRTIME + RESOURCE["wrong4"]);
        return null;
      }
 	  	param.setAttribute("value", wtrTimeValue);
 	  	param.setAttribute("modifyFlag",dataModify[i].wtrTimeFlag);
 	  	row.appendChild(param);
 	  	
        	
 	  	
 	  	param = new tagElement("param");
 	  	param.setAttribute("name", "sdEnable");
 	  	param.setAttribute("value", dataModify[i].sdtriggerflag);
 	  	param.setAttribute("modifyFlag",dataModify[i].sdtriggerflagFlag);
 	  	row.appendChild(param);
      	
 	  	param = new tagElement("param");
 	  	param.setAttribute("name", "mainNode");
 	  	param.setAttribute("value", dataModify[i].mainNode);
 	  	param.setAttribute("modifyFlag",dataModify[i].mainNodeFlag);
 	  	row.appendChild(param);
      	
 	  	business.appendChild(row);
  	}
  	
 	for(var j = 0 ,len=dataModify_Unit.length; j < len; j++)
 	{
 	  	row = new tagElement("row-params");
      	
 	  	param = new tagElement("param");
 	  	param.setAttribute("name", "neid");
 	  	param.setAttribute("value", neid);
 	  	row.appendChild(param);
      	
 	  	param = new tagElement("param");
 	  	param.setAttribute("name", "groupId");
 	  	param.setAttribute("value", dataModify_Unit[j].groupId);
 	  	param.setAttribute("modifyFlag",dataModify_Unit[j].groupIdFlag);
 	  	row.appendChild(param);
 	  	
 	  	param = new tagElement("param");
 	  	param.setAttribute("name", "protectionUnit");
 	  	param.setAttribute("value", dataModify_Unit[j].proUnit);
 	  	param.setAttribute("modifyFlag",dataModify_Unit[j].proUnitFlag);
 	  	row.appendChild(param);
 	  	
 	  	param = new tagElement("param");
 	  	param.setAttribute("name", "pathMapped");
 	  	param.setAttribute("value", dataModify_Unit[j].pathMapped);
 	  	row.appendChild(param);
 	  	      	
 	  	param = new tagElement("param");
 	  	param.setAttribute("name", "delayTime");
 	  	param.setAttribute("value", parseFloat(dataModify_Unit[j].delayTime) * 10);
 	  	param.setAttribute("modifyFlag",dataModify_Unit[j].delayTimeFlag);
 	  	row.appendChild(param);
      	
 	  	business.appendChild(row);
  	}

 	root.getRoot().appendChild(business);
 	return root.toString();
}

function callBackApply(doc)
{
    var data = EncapsulateData(doc);
	var errArr = [];
    errArr[0] = "errObjStr";
    showErrorDialog(getApplyObj(data), errArr);  
    
    refreshTableState(protectionGroupSTable, window.tableconf[0], data);
    refreshTableState(bdmappedTable, window.tableconf[1], data); 
    
    if (0 == data.getSErrorCode())
    {
    	$("apply").disabled = true;
	}
    else
    {
    	$("apply").disabled = !btnRightArr.applyBtn.right;
    }   
}

function getErrorObj(dinterface)
{
    var oError = dinterface.getError();
    if(dinterface.getBErrLength() > 0)
    {
        for(var i = 0; i < dinterface.getBErrLength(); i++)
        {
            var tempErrObjStr = "";
            if(null != oError.getRowKey(i, "groupId") && "" != oError.getRowKey(i, "groupId"))
            {
                tempErrObjStr += RESOURCE["protectiongroupid"] + oError.getRowKey(i, "groupId");
            }
            if(null != oError.getRowKey(i, "protectionUnit") && "" != oError.getRowKey(i, "protectionUnit"))
            {
            	var proUnit = parseInt(oError.getRowKey(i, "protectionUnit"));
            	if (proUnit == 1)
            	{
            		tempErrObjStr += "-" + RESOURCE["westwork"];
            	}
                else if (proUnit == 2 || proUnit == 3)
                {
                	tempErrObjStr += "-" + RESOURCE["eastwork"];
                }
            }
            if(null != oError.getRowKey(i, "direction") && "" != oError.getRowKey(i, "direction"))
            {
            	var proUnit = parseInt(oError.getRowKey(i, "direction"));
            	if (proUnit == 1)
            	{
            		tempErrObjStr += "-" + RESOURCE["west"];
            	}
                else if (proUnit == 2 || proUnit == 3)
                {
                	tempErrObjStr += "-" + RESOURCE["east"];
                }
            }            
            oError.rowErrors[i].errorObj["errObjStr"] = tempErrObjStr;
        }
    }
    return oError;
}

function getOperationObj(dinterface)
{
	var oError = dinterface.getError();
    if(dinterface.getBErrLength() > 0)
    {
        for(var i = 0; i < dinterface.getBErrLength(); i++)
        {
            var tempErrObjStr = "";
            if(null != oError.getRowKey(i, "groupId") && "" != oError.getRowKey(i, "groupId") && "0" != oError.getRowKey(i, "groupId"))
            {
                tempErrObjStr += RESOURCE["protectiongroupid"] + oError.getRowKey(i, "groupId");
            }
            else
            {
            	tempErrObjStr += oError.getRowKey(i, "nename");
            }
            oError.rowErrors[i].errorObj["errObjStr"] = tempErrObjStr;
        }
    }
    return oError;
}

function getApplyObj(dinterface)
{
	var oError = dinterface.getError();
    if(dinterface.getBErrLength() > 0)
    {
    	for(var i = 0; i < dinterface.getBErrLength(); i++)
        {
            var tempErrObjStr = "";
            if(null != oError.getRowKey(i, "groupId") && "" != oError.getRowKey(i, "groupId"))
            {
                tempErrObjStr += RESOURCE["protectiongroupid"] + oError.getRowKey(i, "groupId");
            }
            if(null != oError.getRowKey(i, "protectionUnit") && "" != oError.getRowKey(i, "protectionUnit"))
            {
            	var proUnit = parseInt(oError.getRowKey(i, "protectionUnit"));
            	switch(proUnit)
            	{
            		case WEST_WORK_UNIT:
            			tempErrObjStr += "-" + RESOURCE["westwork"];
            			break;
            		case WEST_PROTECTION_UNIT:
            			tempErrObjStr += "-" + RESOURCE["westprotection"];
            			break;
            		case EAST_WORK_UNIT:
            			tempErrObjStr += "-" + RESOURCE["eastwork"];
            			break;
            		case EAST_PROTECTION_UNIT:
            			tempErrObjStr += "-" + RESOURCE["eastprotection"];
            			break;
            		default:
            			break;
            	}
            }
			if(null != oError.getRowKey(i, "wtrTime") && "" != oError.getRowKey(i, "wtrTime"))
            {
            	tempErrObjStr += "-" + RESOURCE["wtrtime"];
            }
            if(null != oError.getRowKey(i, "sdEnable") && "" != oError.getRowKey(i, "sdEnable"))
            {
            	tempErrObjStr += "-" + RESOURCE["sdflag"];
            }
            if(null != oError.getRowKey(i, "delayTime") && "" != oError.getRowKey(i, "delayTime"))
            {
            	tempErrObjStr += "-" + RESOURCE["delaytime"];
            }
            if(null != oError.getRowKey(i, "mainNode") && "" != oError.getRowKey(i, "mainNode"))
            {
            	tempErrObjStr += "-" + RESOURCE["mainnode"];
            }            
			oError.rowErrors[i].errorObj["errObjStr"] = tempErrObjStr;
		}
	}
	return oError;
}

function showErrorDialog(error, errArr)
{
	openErrPage("../../../../page/", error, errArr);	  
}

/**
 *     s mm:ss  , 65(s)    01:05
 */
function convertWtrTime(wtrTime)
{
 if (isNaN(wtrTime) || wtrTime == "" || wtrTime == null || typeof(wtrTime) == "undefined" || parseInt(wtrTime) == 0)
 {
     return "-";
 }
 else
 {
 	var mm = parseInt(wtrTime/60,10);
 	var ss = wtrTime%60;
 	mm = mm.toString();
 	ss = ss.toString();
 	if(mm.length<2)
 	{
 		mm = "0" + mm;
 	}
 	if(ss.length<2)
 	{
 		ss = "0" + ss;
   }
   return mm+":"+ss;
 }
}

/**
 *     mm:ss s, 06:02    362(s)
 */
function convertMMSStoS(wrttime)
{
	if(wrttime == "-")
	{
		return 0;
	}
	var temparr = wrttime.split(":");
	var mm = parseInt(temparr[0],10);
	var ss = parseInt(temparr[1],10);
	
	return (mm * 60) + ss;
}

/**
*                  
*/
function checkWTRTime(obj, min, max)
{
    obj.onblur = function()
    {
      var textvar = this.value;
	    
			if (textvar == "" || textvar.length != 5 || textvar.indexOf(":") == -1)
			{
				alert(RESOURCE["wrong5"] + min + RESOURCE["wrong2"] + max + RESOURCE["wrong4"]);
				this.value = REVERTIVWTRTIME;
			}
			else
		  {
			  var temparr = textvar.split(":");
			  var mm = parseInt(temparr[0],10);
			  var ss = parseInt(temparr[1],10);
			
			  if(mm > 59 || ss > 59)
			  {
			  	alert(RESOURCE["wrong5"] + min + RESOURCE["wrong2"] + max + RESOURCE["wrong4"]);
			  	this.value = REVERTIVWTRTIME;
			  }
			  else
			  {
			    var timevar = (mm * 60) + ss;
				  if (timevar < MINWTRVALUE)
				  {
					  alert(RESOURCE["wrong5"] + min + RESOURCE["wrong2"] + max + RESOURCE["wrong4"]);
					  this.value = MINWTRTIME;
				  }
				  if (timevar > MAXWTRVALUE)
				  {
				  	alert(RESOURCE["wrong5"] + min + RESOURCE["wrong2"] + max + RESOURCE["wrong4"]);
					  this.value = MAXWTRTIME;
				  }
			  }
			}
		 	cellonblur(this);
    }
}
