function handlePath(path)
{
	if (path == 0)
	{
		return "";
	}
	else if (!isNaN(path) && parseInt(path) >= 1200 && parseInt(path) <= 100000)
	{
		var result = wdmSimplePath[path];
		if(typeof(result) == "undefined" || result == null)
		{
			result = path
		}
		return result;
	}
	else if (!isNaN(path) && parseInt(path) >100000 )
	{
		var result =(parseInt(path) / 1000000).toFixed(5) + "THz";

		return result;
	}
	else
	{
		return path;
	}
}

/**
 *     js                 
 *        1     OCH:1
 */
function isNewotnModelPath()
{
	return false;	
}

/**
 *     js         2               
 *   js    newotnmodel.js   js   
 */
function getnewOTNModelXMLUrl()
{
	return "../../conf/newotnmodel/";
}

var otnNewPathShow = [];
function otnPathNewMode(newpath)
{
	if (otnNewPathShow.length == 0)
	{
		var xmlurl = getnewOTNModelXMLUrl() + "wdm_newmodel_showpath.xml";
		loadXMLdoc(xmlurl,"GET", false,loadXMLParse,"");  		
	}
	return getPathShowValue(newpath);	 	 
}

/*
 *     xml              IE        js        
 */
function loadXMLParse(xmldoc)
{
	var nodeList = xmldoc.getElementsByTagName("otn_model_desc");
	for (var i = 0; i < nodeList.length; i++)
    {
        var node = nodeList[i];
        var pathRange = node.getAttribute("pathrange");
        var option = node.getElementsByTagName("item");
        var otnModelDataArr = [];
        for(var j = 0; j < option.length; j++)
        {
        	 var levelName = option[j].getAttribute("level");
	         var incrementValue = option[j].getAttribute("increment");
	         var data = new LevelData();
	         data.levelValue = levelName;
	         if (incrementValue != null && incrementValue != "")
	         {
	         	data.incrementValue = incrementValue;
	         }
	         otnModelDataArr[j] = data;
        }
        var otnData = new OTNModelData();
        otnData.pathRange = pathRange;
        otnData.levelData = otnModelDataArr;
        otnNewPathShow[i] = otnData;
    }  
}
/**
 *      OCH:1-ODU2:1-ODU0:2   
 */
function getPathShowValue(newpath)
{
	var showValuearr = [];
	for (var i= 0,len = otnNewPathShow.length;i<len;i++)
	{
		var otndata = otnNewPathShow[i];
		if (otndata.isContainPath(newpath))
		{
			var pathArr = otndata.pathRange.split("-");
	        var basenum = newpath - pathArr[0] + 1;
			var data = otndata.levelData;
			for (var size = data.length,j = size-1;j>=0;j--)
			{
				var leveldata = data[j];
				var curNum = -1;
				if(leveldata.incrementValue != 1)
				{
					curNum = basenum % leveldata.incrementValue;
					if (curNum == 0)
					{
						curNum = leveldata.incrementValue;
						basenum = parseInt(basenum / leveldata.incrementValue,10);
					}
					else
					{
						basenum = parseInt(basenum / leveldata.incrementValue,10) + 1;
					}	
				}
				else
				{
					curNum = basenum / leveldata.incrementValue;
				}
				if (j == 1)
				{
					curNum = 1;
				}
				showValuearr[j] = leveldata.levelValue + ":" + curNum;
			}
		}
	}
	var pathStr = "";
	for (var i=0,size = showValuearr.length;i<size;i++)
	{
		if (i !=showValuearr.length-1)
		{
			pathStr = pathStr + showValuearr[i] + "-";
		}
		else
		{
			pathStr = pathStr + showValuearr[i];
		}		
	}
	if (pathStr != "")
	{
		return pathStr;
	}
	return newpath;
}

function LevelData()
{
	this.levelValue = "";
	this.incrementValue = 1;
}

function OTNModelData()
{
	this.pathRange = "";
	this.levelData = [];
}

OTNModelData.prototype.isContainPath = function(path)
{
	var pathArr = this.pathRange.split("-");
	for (var i = pathArr[0];i<=pathArr[1];i++)
	{
		if (i == path)
		{
			return true;
		}
	}
	return false;
}

function oduGrade(grade)
{
	if (grade > 1000)
	{
		return "";
	}
	else
	{
		return oduGradeArr[grade];
	}
}

oduGradeArr = [];
oduGradeArr[1] = "ODU1";
oduGradeArr[2] = "ODU2";
oduGradeArr[3] = "ODU3";
oduGradeArr[4] = "ODU5G";
oduGradeArr[5] = "ODU0";
oduGradeArr[6] = "ODU4";
oduGradeArr[7] = "ODUflex";


function otuGrade(grade)
{
	if (grade > 1000)
	{
		return "";
	}
	else
	{
		return otuGradeArr[grade];
	}
}

otuGradeArr = [];
otuGradeArr[1] = "OTU1";
otuGradeArr[2] = "OTU2";
otuGradeArr[3] = "OTU3";
otuGradeArr[4] = "OTU5G";
otuGradeArr[5] = "OTU0";
otuGradeArr[6] = "OTU4";


function opuGrade(grade)
{
	if (grade > 1000)
	{
		return "";
	}
	else
	{
		return opuGradeArr[grade];
	}
}
opuGradeArr = [];
opuGradeArr[1] = "OPU1";
opuGradeArr[2] = "OPU2";
opuGradeArr[3] = "OPU3";
opuGradeArr[4] = "OPU5G";
opuGradeArr[5] = "OPU0";
opuGradeArr[6] = "OPU4";
opuGradeArr[7] = "OPUflex";
