var winobj = getNeProperty(self);
var pgTable;
var boardMapTable;

var CLEAR_SW= 16; //      0x10;
var LOCKOUT_SW= 15; //     0x0f;
var FORCE_SW = 14; //     0x0e;
var MANUAL_SW = 7; //     0x07;

var WORK =2; //     
var BACK =1; //     

var btnRightArr = new Object();  //      

var neid = winobj["neid"];
loadXMLdoc("../../../../conf/system.xml", "GET", false,EncapsulateSConf);
getResourse("../../../../res/commonres_"+ SYSTEMCONF.getLanguage() +".xml");
getResourse("../../res/mpnprotection/mpnprotection_"+SYSTEMCONF.getLanguage()+".xml");

loadXMLdoc("../../conf/mpnprotection/mpnprotectgrouptable_"+SYSTEMCONF.getLanguage()+".xml", "GET", false,EncapsulateTable);
loadXMLdoc("../../conf/mpnprotection/mpnmappingtable_"+SYSTEMCONF.getLanguage()+".xml", "GET", false,EncapsulateTable);


/**
 *      
 * @param  
 * @return  
 */
function init()
{
	initUI();
	initPGTable();
	initMappingTable();
	queryPG();
}

function initUI()
{
	$("grouplabel").innerText = RESOURCE["PGTitle"];
	$("mappinglabel").innerText = RESOURCE["boardMapTitle"];
	$("queryBtn").value = RESOURCE["queryBtn"];
	$("switchBtn").value = RESOURCE["switchBtn"];
	$("applyBtn").value = RESOURCE["applyBtn"];
    btnRightArr.queryBtn = new BtnRightObj("queryBtn", TECMDCODE_QUERY_MPN_DPS_PG);  
    btnRightArr.applyBtn = new BtnRightObj("applyBtn",  TECMDCODE_SET_MPN_DPS_WTRTIME);    
    btnRightArr.switchBtn = new BtnRightObj("switchBtn", TECMDCODE_SET_MPN_DPS_SWCMD);
    getRightInfo(winobj, btnRightArr);      
    initrightbtn(btnRightArr);
}

/**
 *           
 */
function createSwitchMenu()
{
    removejsDOMmenu();
    
    var cursorMenu = null;
    if ("en" == SYSTEMCONF.getLanguage())
    {
        cursorMenu = new jsDOMenu(160); //   160px
    }
    else
    {
        cursorMenu = new jsDOMenu(120); //   120px
    }
    
    item = new menuItem(RESOURCE["clearSW"], "",switchMPN, [CLEAR_SW], btnRightArr.switchBtn.right&&checklscs());
    item.id = "clearSwitching";
    cursorMenu.addMenuItem(item);
	
    item = new menuItem(RESOURCE["lockedSW"], "",switchMPN, [LOCKOUT_SW], btnRightArr.switchBtn.right&&checklscs());
    item.id = "switchLockout";
    cursorMenu.addMenuItem(item);
    
    item = new menuItem(RESOURCE["forceSW"], "",switchMPN, [FORCE_SW], btnRightArr.switchBtn.right&&checkfsms());
    item.id = "forcedSwitch";
    cursorMenu.addMenuItem(item);

    var item = new menuItem(RESOURCE["manualSW"], "",switchMPN, [MANUAL_SW], btnRightArr.switchBtn.right&&checkfsms());
    item.id = "manualSwitch";
    cursorMenu.addMenuItem(item);

    setPopUpMenu(cursorMenu);
}

/**
 *         
 */
function initPGTable()
{
	pgTable = new SortTable();
    pgTable.setImage("../../../../images/");
    createTableHead(pgTable, window.tableconf[0]); 
    
    pgTable.setBodyWidth(window.tableconf[0].width,window.tableconf[0].percent,0);
    
    pgTable.setOnRowSelectHandler(rowSelectHandler);  
    
    pgTable.setOnCellEditHandler(cellEditHandler);
 
    pgTable.setSingleChoiceFlg(true);  
    
    $("pgtable").appendChild(pgTable.getTable());
    adjustTableLayout(pgTable,window.tableconf[0],0);
}

/**
 *            
 */
function initMappingTable()
{
    boardMapTable = new SortTable();
    boardMapTable.setImage("../../../../images/");
    createTableHead(boardMapTable, window.tableconf[1]);    
    boardMapTable.setBodyWidth(window.tableconf[1].width,window.tableconf[1].percent,0);   
    
    $("bdmappingtable").appendChild(boardMapTable.getTable());
    $("bdmappingtable").oncontextmenu = popupMenuHandler;	    
 
    var totalHeight = getComponetHeight($("tablecomponent"),200);
    pgTable.setBodyHeight(totalHeight*0.6+"px");
    boardMapTable.setBodyHeight(totalHeight*0.38+"px"); 
}


/**
 *            
 * @param  
 * @return  
 */
function initButtonStatus()
{
    setBtnStatus(!btnRightArr.queryBtn.right,["queryBtn"]);
    setBtnStatus(!btnRightArr.switchBtn.right,["switchBtn"]);
	setBtnStatus(true,["applyBtn"]);
    for(var rowindex = 0,rowlen = pgTable.getDataRowLength();rowindex<rowlen;rowindex++)
    {
    	if(pgTable.getModify(rowindex))
    	{
    		setBtnStatus(!btnRightArr.applyBtn.right,["applyBtn"]);
    		break;
    	}
    }
}    

var selectedGroupid = -1;

/**
 *             
 * @param rows:      
 * @return  
 */
function rowSelectHandler(rows)
{
	if(rows.length == 0)
	{
	    boardMapTable.clearTableData();
	    	
	}
	else
	{	
		var groupid = 0;
		groupid = pgTable.getCellStoreValue(rows[0],"groupid","groupid")
		if(selectedGroupid != groupid)
		{
			queryBoardMapInfo(groupid);
			selectedGroupid = groupid;
		}	
	}
}

/**
 *             
 * @param  
 * @return  
 */
function cellEditHandler()
{
	$("applyBtn").disabled = !btnRightArr.applyBtn.right;
}

/**
 *   M:N   
 * @param  
 * @return  
 */
function queryPG()
{
	setBtnStatus(true);
	var url = "../../../../neExlorerServlet?sfid="+ TECMDCODE_QUERY_MPN_DPS_PG +"&nmUser="+ winobj["nmUser"];
	
    loadXMLdoc(url,"POST",true,callbackQueryPG,null,"inputdata=" + createQueryPGXMLInfo());
}

/**
 *             XML  
 * @param  
 * @return  
 */
function createQueryPGXMLInfo()
{
	var root = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

/**
 *             
 * @param doc:          
 * @return  
 */
function callbackQueryPG(doc)
{
	var data = EncapsulateData(doc);
	var errObj = null;
	if(0 == data.getSErrorCode() || 1 == data.getSErrorCode())
	{		
		pgTable.clearTableData();
		fillTableData(data);
	}
	else
	{
		errObj = [];
		errObj.push("nename");
	}
	
	initButtonStatus();
	showOperResult(data,errObj);
}

/**
 *         
 * @param data:      
 * @return  
 */
function fillTableData(data)
{
	createTableBody(pgTable,window.tableconf[0],data,RESOURCE);
	
	if(!pgTable.element.colsArray.selectedId)
	{
		pgTable.element.colsArray.selectedId = "groupid";
		pgTable.element.colsArray.imgflag = 1;
	}
	var td= pgTable.element.headRow.element.cols[pgTable.element.colsArray.selectedId].element; 
	pgTable.sortRows(td,pgTable.element.colsArray.imgflag);
	
	if(pgTable.getDataRowLength() > 0 && pgTable.getSelectedRowCount() == 0)
	{
		pgTable.setRowSelect(0);
	}
	rowSelectHandler(pgTable.getSelectedRows());
}


/**
 *             
 * @param groupid    ID
 * @return  
 */
function queryBoardMapInfo(groupid)
{
	var root = new inputxml("datainterface");      
  	var firstlevel = new tagElement("bussiness-params");
  	
	var secondlevel = new tagElement("row-params");
    var thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name", "neid");
   	thirdlevel.setAttribute("value", neid);
   	secondlevel.appendChild(thirdlevel);   	
   	
    thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name", "groupid");
   	thirdlevel.setAttribute("value", groupid);
   	secondlevel.appendChild(thirdlevel);
   	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);	
	
	var xml = root.toString();
	var url = "../../../../neExlorerServlet?sfid="+ TECMDCODE_GET_MPN_DPS_MAP+ "&nmUser=" + winobj["nmUser"];
	loadXMLdoc(url, "POST",false,callbackQueryBoardMap,null,"inputdata=" + xml);
}


function callbackQueryBoardMap(doc)
{
	boardMapTable.clearTableData();
	var data = EncapsulateData(doc);
    createTableBody(boardMapTable, window.tableconf[1], data, RESOURCE);
    if(!boardMapTable.element.colsArray.selectedId)
	{
    	boardMapTable.element.colsArray.selectedId = "protectunit";
    	boardMapTable.element.colsArray.imgflag = 1;
	}
	var td=boardMapTable.element.headRow.element.cols[boardMapTable.element.colsArray.selectedId].element; 
	boardMapTable.sortRows(td,boardMapTable.element.colsArray.imgflag);
    showOperResult(data);
    
}
	


/**
 *        
 * @param  
 * @return  
 */
function querySWStatus()
{
	if(pgTable.getSelectedRowCount() == 0)
	{
		return;
	}
	setBtnStatus(true);
	var url = "../../../../neExlorerServlet?sfid="+ TECMDCODE_GET_MPN_DPS_SWSTATE+"&nmUser="+ winobj["nmUser"];
	
    loadXMLdoc(url,"POST",true,callbackQuerySWStatus,null,"inputdata="+ createQuerySWStatusXMLInfo());
}

/**
 *             XML  
 * @param  
 * @return  
 */
function createQuerySWStatusXMLInfo()
{
    var rows = pgTable.getSelectedRows()

    var root = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
	param.setAttribute("name","neid");
	param.setAttribute("value",neid);
	row.appendChild(param);
	    	    
	param = new tagElement("param");
	param.setAttribute("name","groupid");
    param.setAttribute("value",pgTable.getCellStoreValue(rows[0],"groupid","groupid"));
	row.appendChild(param);    
    bussiness.appendChild(row); 
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

/**
 *               
 * @param doc:          
 * @return  
 */
function callbackQuerySWStatus(doc)
{
	var data = EncapsulateData(doc);
	var errorCode = data.getSErrorCode();
	var groupid = 0;
	var protectunit = 0;
	if(0 == errorCode || 1== errorCode)  
	{	
		for(var i = 0, len = data.getDataRowLength(); i < len; i++)
		{
			var groupid = data.getDataRowParam(i,"groupid");
			var protectunit = data.getDataRowParam(i,"protectunit");
			var ipustatus =  data.getDataRowParam(i,"pustatus");
			var iactivestatus = data.getDataRowParam(i,"activestatus");
			var irequesttype =  data.getDataRowParam(i,"requesttype");
			var protectedunit = data.getDataRowParam(i,"protectedunit");
			var pslotid = data.getDataRowParam(i,"pslotid");
			var pboardname = data.getDataRowParam(i,"pboardname");
			for(var index = 0, size = boardMapTable.getDataRowLength(); index < size; index++)
			{
				var curgroupid = boardMapTable.getCellStoreValue(index,"groupid","groupid");
				var curprotectunit = boardMapTable.getCellStoreValue(index,"protectunit","protectunit");
				if(curgroupid == groupid &&  curprotectunit== protectunit)
				{
					boardMapTable.setCellValue(boardMapTable.getCell(index,"pustatus"), "pustatus", ipustatus);
					boardMapTable.setAtomValue(boardMapTable.getCellShow(index,"pustatus"), pustatus[ipustatus]);
					
					boardMapTable.setCellValue(boardMapTable.getCell(index,"activestatus"), "activestatus", iactivestatus);
				    boardMapTable.setAtomValue(boardMapTable.getCellShow(index,"activestatus"), activestatus[iactivestatus]);
							
				    boardMapTable.setCellValue(boardMapTable.getCell(index,"requesttype"), "requesttype", irequesttype);
				    boardMapTable.setAtomValue(boardMapTable.getCellShow(index,"requesttype"), requesttype[irequesttype]);
							
				    
				    boardMapTable.setCellValue(boardMapTable.getCell(index,"protectedunit"), "protectedunit", protectedunit);
				    if (pslotid != "" && pboardname != "")
				    {
				    	 boardMapTable.setAtomValue(boardMapTable.getCellShow(index,"protectedunit"), pslotid + "-" + pboardname);
				    }
				    else
				    {
				    	 boardMapTable.setAtomValue(boardMapTable.getCellShow(index,"protectedunit" ), "");
				    }
					break;
				}
			}
		}
	}	
   initButtonStatus();
   showOperResult(data);
		
}


/**
 *     M:N   WTR    
 * @param  
 * @return  
 */
function modifyPGWTR()
{
	setBtnStatus(true,["applyBtn"]);
	var url = "../../../../neExlorerServlet?sfid="+ TECMDCODE_SET_MPN_DPS_WTRTIME+"&nmUser="+winobj["nmUser"];	
	
	var xmlData = createSetWTRXMLInfo();
	if(null == xmlData)
	{
	   return;
	}
	
    loadXMLdoc(url,"POST",true,callbackSetWTR,null,"inputdata="+xmlData);
}

/**
 *       WTR   XML  
 * @param  
 * @return  
 */
function createSetWTRXMLInfo()
{
	 var root = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;
    var isModify = false;
    for(var rowindex = 0,rowlen = pgTable.getDataRowLength();rowindex<rowlen;rowindex++)
    {
    	if(!pgTable.getModify(rowindex))
    	{
    		continue;
    	}
    	isModify = true;
        rowData = pgTable.getRow();
    	row = new tagElement("row-params");

    	param = new tagElement("param");
		param.setAttribute("name","neid");
		param.setAttribute("value",neid); 
		row.appendChild(param);	
		
    	param = new tagElement("param");
		param.setAttribute("name","groupid");
		param.setAttribute("value",pgTable.getCellStoreValue(rowindex,"groupid","groupid")); 
		row.appendChild(param);	

        param = new tagElement("param");		
    	param.setAttribute("name","wtrtime");
        param.setAttribute("value",pgTable.getCellStoreValue(rowindex,"wtrtime","wtrtime"));   
        param.setAttribute("modifyFlag",true); 
        row.appendChild(param);	
        
        param = new tagElement("param");		
    	param.setAttribute("name","opDesc");
    	var opDesc = RESOURCE["revertiveTime"]+ ":" + pgTable.getCellStoreValue(rowindex,"wtrtime","wtrtime");
        param.setAttribute("value",opDesc);   
        row.appendChild(param);	
     
    	bussiness.appendChild(row);
    }    
    if(!isModify)
    {
    	return null;
    }
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

/**
 *   M:N   WTR         
 * @param doc:          
 * @return  
 */
function callbackSetWTR(doc)
{
	var data = EncapsulateData(doc);	
	refreshTableState(pgTable,window.tableconf[0],data);
	if(0 != data.getSErrorCode())
	{
		setBtnStatus(false,["applyBtn"]);
	}
	showOperResult(data);	
}

/**
 *         
 * @param  
 * @return  
 */
function switchMPN(switchtype)
{
	removejsDOMmenu();

	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_SET_MPN_DPS_SWCMD+"&nmUser="+ winobj["nmUser"];	
    loadXMLdoc(url,"POST",true,callbackSwitchMPN,switchtype,"inputdata="+ createSwitchXMLInfo(switchtype));
}

/**
 *          XML  
 * @param  
 * @return  
 */
function createSwitchXMLInfo(switchtype)
{
	var root = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;
    
    var selectedRows = boardMapTable.getSelectedRows();
    
    if (switchtype== FORCE_SW || switchtype== MANUAL_SW)
    {
    	row = new tagElement("row-params");
    	param = new tagElement("param");
    	param.setAttribute("name","neid");
    	param.setAttribute("value",neid);
    	row.appendChild(param);
    
    	param = new tagElement("param");
    	param.setAttribute("name","groupid");
    	param.setAttribute("value",boardMapTable.getCellStoreValue(selectedRows[0],"groupid","groupid"));
    	row.appendChild(param);    
   
    	var  srcslotid = 0;
    	var  dstslotid = 0;
    	if (boardMapTable.getCellStoreValue(selectedRows[0],"putype","putype") ==  WORK) //            
    	{
    		srcslotid = boardMapTable.getCellStoreValue(selectedRows[0],"protectunit","protectunit"); //                 

    		dstslotid = boardMapTable.getCellStoreValue(selectedRows[1],"protectunit","protectunit"); //                  
    	}
    	else if (boardMapTable.getCellStoreValue(selectedRows[0],"putype","putype") ==  BACK) //            
        { 
    		srcslotid = boardMapTable.getCellStoreValue(selectedRows[1],"protectunit","protectunit"); //                 
    		
    		dstslotid = boardMapTable.getCellStoreValue(selectedRows[0],"protectunit","protectunit");  //                  
        }
    	param = new tagElement("param");
        param.setAttribute("name","srcslotid");
        param.setAttribute("value",srcslotid);
        row.appendChild(param);  
    
        param = new tagElement("param");
        param.setAttribute("name","dstslotid");
        param.setAttribute("value",dstslotid);
        row.appendChild(param);  
        
        param = new tagElement("param");
        param.setAttribute("name","switchtype");
        param.setAttribute("value",switchtype);
        row.appendChild(param); 
        
        param = new tagElement("param");		
    	param.setAttribute("name","opDesc");
    	
    	var opDesc = RESOURCE["switchcmd"]+ ":" + switchType[switchtype] + ";" 
    	+ RESOURCE["srcBoard"]+ ":" + srcslotid + ";" 
    	+ RESOURCE["dstBoard"]+ ":" + dstslotid ; 
        param.setAttribute("value",opDesc);   
        row.appendChild(param);	
        
        bussiness.appendChild(row);
    }
    else
    {  
    	for (var i=0; i<selectedRows.length; i++)
        {
    		row = new tagElement("row-params");
    		param = new tagElement("param");
        	param.setAttribute("name","neid");
        	param.setAttribute("value",neid);
        	row.appendChild(param);
        
        	param = new tagElement("param");
        	param.setAttribute("name","groupid");
        	param.setAttribute("value",boardMapTable.getCellStoreValue(selectedRows[i],"groupid","groupid"));
        	row.appendChild(param);    
       
    	
        	param = new tagElement("param");
        	param.setAttribute("name","srcslotid");
        	param.setAttribute("value",boardMapTable.getCellStoreValue(selectedRows[i],"protectunit","protectunit"));
        	row.appendChild(param);  
        
        	param = new tagElement("param");
        	param.setAttribute("name","dstslotid");
        	param.setAttribute("value","0");
        	row.appendChild(param);  
        
        	param = new tagElement("param");
        	param.setAttribute("name","switchtype");
        	param.setAttribute("value",switchtype);
        	row.appendChild(param);  
        	
            param = new tagElement("param");		
        	param.setAttribute("name","opDesc");
        	var opDesc = RESOURCE["switchcmd"]+ ":" + switchType[switchtype] + ";" 
        	+ RESOURCE["slotID"]+ ":" + boardMapTable.getCellStoreValue(selectedRows[i],"protectunit","protectunit"); 
            param.setAttribute("value",opDesc); 
            row.appendChild(param);	
        	bussiness.appendChild(row);
        }
    }
    
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

/**
 *              
 * @param doc:          
 * @return  
 */
function callbackSwitchMPN(doc,switchtype)
{
	var data = EncapsulateData(doc);
	if(0 == data.getSErrorCode())
	{
		alert(RESOURCE["querySWStatus"]);
	}	
	showOperResult(data);
}

 /**
 *             
 * @param data: 
 * @return  
 */
function createQueryMenu()
{
	removejsDOMmenu();
	var menuSize = 140; 
    if(SYSTEMCONF.getLanguage() == "en")
    {
    	menuSize = 220;
    }  
    var cursorMenu1 = new jsDOMenu(menuSize); 
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["queryPG"],"",queryPG,null));      	
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["querySwitchStatus"],"",querySWStatus,null));
    setPopUpMenu(cursorMenu1);
}

 /**
 *           
 * @param data: 
 * @return  
 */
function popupMenuHandler(evt)
{
  	if(!evt)
  	{
  	  evt= window.event;	
  	}
  	 
    var elem = (evt.target) ? evt.target : evt.srcElement;   

    if(elem!= null && elem.blur)
    {
    	elem.blur();	  	
    }
   
   while(elem!=null)
	 {
	    if(elem.tagName == 'TD')
	    {
	        break;	
	    }
	    else
	    {
		    elem =elem.parentNode;	  	
	    }	
   } 
  
    if(elem == null || elem.tagName != 'TD' || null == elem.parent)
	{
	  return;
	}  
	
	var rowid= elem.parentNode.rowIndex;
	var rows = elem.parent.getSelectedRows();
	if(rows.contains(rowid))
	{
		createFuncPopupMenu(rows,evt);    	
	}    
}



 /**
 *           
 * @param data: 
 * @return  
 */
function createFuncPopupMenu(rows,evt)
{
     removejsDOMmenu(); 
     var menuSize = 150; 
     var cursorMenu1 = new jsDOMenu(menuSize); 
     cursorMenu1.addMenuItem(new menuItem(RESOURCE["clearSW"],"", switchMPN,[CLEAR_SW],btnRightArr.switchBtn.right&&checklscs()));
     cursorMenu1.addMenuItem(new menuItem(RESOURCE["lockedSW"],"",switchMPN,[LOCKOUT_SW],btnRightArr.switchBtn.right&&checklscs()));
	 cursorMenu1.addMenuItem(new menuItem(RESOURCE["forceSW"],"", switchMPN,[FORCE_SW], btnRightArr.switchBtn.right&&checkfsms()));     		
     cursorMenu1.addMenuItem(new menuItem(RESOURCE["manualSW"],"",switchMPN,[MANUAL_SW],btnRightArr.switchBtn.right&&checkfsms()));
     setPopUpMenu(cursorMenu1);
     showMenu(evt);
}


/**
 *                  
 */
function checkfsms()
{
	var selectedRows = boardMapTable.getSelectedRows();
    if (selectedRows.length !=2 )
    {
    	return false;
    }
    else 
    {
    	var puType1 = boardMapTable.getCellStoreValue(selectedRows[0], "putype", "putype");
    	var puType2 = boardMapTable.getCellStoreValue(selectedRows[1], "putype", "putype");
    	if ((puType1==WORK && puType2==WORK)||(puType1==BACK && puType2==BACK))
        {
    	   return false;
        } 
    }
    return true;
}

/**
 *                  
 */
function checklscs()
{
	var selectedRows = boardMapTable.getSelectedRows();
    if (selectedRows.length <=0 )
    {
    	return false;
    }
    return true;
}


/**
 *         
 * @param disabledState
 * @param btnIDArr
 */
function setBtnStatus(disabledState,btnIDArr)
{
	if(null == btnIDArr || btnIDArr.length == 0)
	{	
		btnIDArr = [];		
		btnIDArr.push("queryBtn");
		btnIDArr.push("switchBtn")
		btnIDArr.push("applyBtn");
	}
	for(var i = 0; i < btnIDArr.length; i++)
	{
		$(btnIDArr[i]).disabled = disabledState;			
	}	
}

/**
 *       
 * @param data:            errArr:       
 * @return  
 */
function showOperResult(data,errArr)
{
	if(null == errArr)
	{
		errArr = [];//           
		errArr[0] = "groupid";//           
	
		var temp;
		for(var i = 0, len = data.getBErrLength(); i < len; i++)
		{	
			temp = data.getError().rowErrors[i].errorObj["groupid"];
			data.getError().rowErrors[i].errorObj["groupid"] = RESOURCE["groupID"]+ ":" + temp;
		}		
	}
	openErrPage("../../../../page/",data.getError(),errArr);
}

/**
 *   common.js               
 * @param res:     obj     /   key:     
 * @return String      
 */
function convertMsg(res,obj,key)
{
	if("function" == (typeof obj))	
	{
		return obj(key);
	}
	else //       
	{
		if(null == obj)
		{
			return key;
		}
		var resValue = obj[key];
		if(null == resValue)
		{
			resValue = "/";
		}		
		return resValue;
	}
}

 /**
 *               
 * @param data: 
 * @return  
 */
window.onresize=function()
{
	 var totalHeight = getComponetHeight($("tablecomponent"),200);
	 pgTable.setBodyHeight(totalHeight*0.6+"px");
	 boardMapTable.setBodyHeight(totalHeight*0.38+"px");
}

