 //  URL  
var winobj = getNeProperty(self);

var ipaTable;

var ipaTableConf;

var MAX_IPA_ID = 16;

var MIN_IPA_ID = 1;

var availableWPGID = [];

var useredWPGID = [];

var availableAlmPort = [];

var availableCntlPort = [];

var availableRamonBoard = [];

var almPort = [];

var cntlPort = [];

var ramonBoard = [];

var assistantCheckBoard = [];

var selectedAssisBoard = [];

var allUsedAssisBoard = [];

var btnRightArr = new Object();

var modifyFlag = false;


loadXMLdoc("../../../../conf/system.xml", "GET", false,EncapsulateSConf);

getResourse("../../../../res/commonres_"+ SYSTEMCONF.getLanguage() +".xml");
getResourse("../../res/ipa/ipamgr_"+SYSTEMCONF.getLanguage()+".xml");

loadXMLdoc("../../conf/ipa/ipamgrtable_"+SYSTEMCONF.getLanguage()+".xml", "GET", false,EncapsulateTable);


/**
 *      
 * @param  
 * @return  
 */
function initPage()
{
	initTable();
	initButton();
	getAvailableWPGID();
	doQuery();
}

/**
 *      
 * @param  
 * @return  
 */
function initTable()
{
	ipaTable = new SortTable();
	
    ipaTable.setImage("../../../../images/");
    
    ipaTable.setOnRowSelectHandler(rowSelectHandler);
    
    ipaTable.setOnCellEditHandler(cellEditHandler);
    
    ipaTableConf = window.tableconf[0];   

    createTableHead(ipaTable, ipaTableConf);      
    
    document.getElementById("tablecomponent").appendChild(ipaTable.getTable());  
    
    ipaTable.setBodyHeight(getComponetHeight($("tablecomponent"),100)+"px");
    ipaTable.setBodyWidth(ipaTableConf.width,ipaTableConf.percent,0);
    
    $("tablecomponent").oncontextmenu=popupMenuHandler;	
}

/**
 *      
 * @param  
 * @return  
 */
function initButton()
{
	$("querybtn").value = RESOURCE["querybutton"];
    $("addipabtn").value = RESOURCE["addipabtn"]; 
    $("delipabtn").value = RESOURCE["delipabtn"];    
    $("applybtn").value = RESOURCE["applybutton"];
    $("restartbtn").value = RESOURCE["restartbtn"];
    $("testbtn").value = RESOURCE["testbtn"];
    $("relaytimebtn").value = RESOURCE["ID_Delay_Time"];
    $("checkbtn").value = RESOURCE["checkbtn"];
    
    if(SYSTEMCONF.getLanguage() == "en")
    {
        $("delipabtn").style.width = "80px";
        $("restartbtn").style.width = "105px";
        $("testbtn").style.width = "90px";
        $("relaytimebtn").style.width = "115px";
        $("checkbtn").style.width = "150px";
    }
    
    btnRightArr.querybtn = new BtnRightObj("querybtn",TECMDCODE_GET_APSDPAIR);    
    btnRightArr.addipabtn = new BtnRightObj("addipabtn",TECMDCODE_SET_APRCTRLPARA);    
    btnRightArr.delipabtn = new BtnRightObj("delipabtn",TECMDCODE_DEL_APSDPAIR);    
    btnRightArr.applybtn = new BtnRightObj("applybtn",TECMDCODE_SET_APSDPAIR);    
    btnRightArr.restartbtn = new BtnRightObj("restartbtn",TECMDCODE_START_APSDPAIR);
    btnRightArr.testbtn = new BtnRightObj("testbtn",TECMDCODE_TEST_APSDPAIR);    
    btnRightArr.relaytimebtn = new BtnRightObj("relaytimebtn",TECMDCODE_SET_APRALMDELAY);    
    btnRightArr.checkbtn = new BtnRightObj("checkbtn",TECMD_CODE_SET_IPAMONPARA);
    
    sendRightInfo(btnRightArr);           
}

/**
 *         
 * @param  
 * @return  
 */
function initBtnStatue()
{	
	  $("querybtn").disabled = !btnRightArr.querybtn.right;	
    $("addipabtn").disabled = !btnRightArr.addipabtn.right;	
    $("relaytimebtn").disabled = !btnRightArr.relaytimebtn.right;	
    
    $("delipabtn").disabled = true;    
    $("applybtn").disabled = true;
    $("restartbtn").disabled = true;
    $("testbtn").disabled = true;    
    $("checkbtn").disabled = true;
}

/**
 *         
 * @param  
 * @return  
 */
function addCellEvent()
{
	var cell = null;
	for(var i = 0,len = ipaTable.getDataRowLength();i<len;i++)
	{
		cell = ipaTable.getCell(i,"offTimes");
		if(null != cell)
		{
			textCheck(cell.element.editElement.element,"100","300");
		}
		
		cell = ipaTable.getCell(i,"onTimes");
		if(null != cell)
		{
			textCheck(cell.element.editElement.element,"175","4500");
		}
		
		cell = ipaTable.getCell(i,"testTimes");
		if(null != cell)
		{
			textCheck(cell.element.editElement.element,"80","100");
		}	
		
		cell = ipaTable.getCellEdit(i,"reBootType");
	    cell.element["onchange"] = function()
	    {
				setRestartBtn();
	    }	
	    
	    cell = ipaTable.getCellEdit(i,"ramanLosTH");
	    textCheck(cell.element,"-35.0","-14.0");
	    
	    cell = ipaTable.getCellEdit(i,"ramanAlarmTH");
	    textCheck(cell.element,"-60.0","0.0");	    
	    
	    if(ipaTable.getCellStoreValue(i,"raman","ramonSlotid") == 0)
	    {
	    	    var ramanLosTHCellEle = ipaTable.getCell(i,"ramanLosTH").element;
				ipaTable.setAtomValue(ramanLosTHCellEle.showElement,"-");

				ipaTable.setCellIsEdit(ramanLosTHCellEle,0);
				
	    	    var ramanAlarmTHCellEle = ipaTable.getCell(i,"ramanAlarmTH").element;
				ipaTable.setAtomValue(ramanAlarmTHCellEle.showElement,"-");
				ipaTable.setCellIsEdit(ramanAlarmTHCellEle,0);

	    	    var ramanAlarmEnCellEle = ipaTable.getCell(i,"ramanAlarmEnable").element;
				ipaTable.setAtomValue(ramanAlarmEnCellEle.showElement,"-");
				ipaTable.setCellIsEdit(ramanAlarmEnCellEle,0);
	    }
	        
	    cell = ipaTable.getCellEdit(i,"ipaEnable");
	    cell.element["onchange"] = function()
	    {
	    	setRestartBtn();
	    }		
	}    
}


function setRestartBtn()
{
    var selectedRows = ipaTable.getSelectedRows();
    var enabledFlag = false;
  	for(var j = 0; j < selectedRows.length;j++)
  	{
  		var bootype = ipaTable.getCellCurrentValue(selectedRows[j],"reBootType","reBootType"); 
  		var ipaEnable = ipaTable.getCellCurrentValue(selectedRows[j],"ipaEnable","ipaEnable");  
			if(1 == bootype && 1 == ipaEnable)
  		{
  			enabledFlag = true;
  			break;
  		}
  	}  	
		$("restartbtn").disabled = !enabledFlag
		$("testbtn").disabled = !enabledFlag;	    	
}

/**
 *           
 * @param  
 * @return  
 */
function rowSelectHandler(rows)
{
	var btnDisabledStatus = true;
	
	if(rows.length == 1)
	{
		$("checkbtn").disabled = !btnRightArr.checkbtn.right;
	}
	else
	{
		$("checkbtn").disabled = true;
	}	
    
    if(rows.length > 0)
    {
    	$("delipabtn").disabled = false; 
		setRestartBtn();
    }
    else
    {
    	$("delipabtn").disabled = true;
    	$("restartbtn").disabled = true;
    	$("testbtn").disabled = true; 
    }	
}

/**
 *             
 * @param  
 * @return  
 */
function cellEditHandler()
{
	if(btnRightArr.applybtn.right == true)
	{
	   $("applybtn").disabled = false;	
	}
	
}

/**
 *   IPA
 * @param  
 * @return  
 */
function doQuery()
{
	if(btnRightArr.querybtn.right == false)
	{
		return;
	}
	
	setButtonState(true,["querybtn"]);
	setButtonState(true,["addipabtn"]);
	setButtonState(true,["relaytimebtn"]);
	
	var xmlData = createQueryXmlInfo();
	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_GET_APSDPAIR+"&nmUser="+winobj["nmUser"];
	loadXMLdoc(url,"POST",true,callbackQuery,null,"inputdata="+xmlData);	
}

/**
 *   IPA     
 * @param doc:       
 * @return  
 */
function callbackQuery(doc)
{
	var data = EncapsulateData(doc);
	
	if(0 == data.getSErrorCode() || 1 == data.getSErrorCode())
	{		
		ipaTable.clearTableData();
		
		createTableBody(ipaTable,ipaTableConf,data,RESOURCE);
		
		getUsedRes(data);		
		
		getAvailableWPGID();

		initBtnStatue();
	}
	else //                              
	{
		setButtonState(false,["querybtn"]);
	  setButtonState(false,["addipabtn"]);
	  setButtonState(false,["relaytimebtn"]);
	}	
	
	addCellEvent();
	
	showErrorPage(data,"query");	
}

/**
 *           
 * @param  
 * @return  
 */
function getUsedRes()
{
	useredWPGID.clear();
	almPort.clear();
	cntlPort.clear();
	ramonBoard.clear();

	for(var i = 0, len = ipaTable.getDataRowLength(); i < len; i++)
	{
		useredWPGID.push(ipaTable.getCellStoreValue(i,"ipaID","ipaID"));		
		
		ipaPort = new IPAPort();
		
		ipaPort.type = "alarm";
		ipaPort.slotid = ipaTable.getCellStoreValue(i,"alarmBoard","alarmSlotid");
		ipaPort.boardname = ipaTable.getCellStoreValue(i,"alarmBoard","alarmBoardName");
		ipaPort.port = ipaTable.getCellStoreValue(i,"alarmPort","alarmPort");
		ipaPort.portname = ipaTable.getCellStoreValue(i,"alarmBoard","alarmPortName");	
		
		almPort.push(ipaPort);
		
		ipaPort = new IPAPort();
				
		ipaPort.type = "control";
		ipaPort.slotid = ipaTable.getCellStoreValue(i,"ctlBoard","ctlSlotid");
		ipaPort.boardname = ipaTable.getCellStoreValue(i,"ctlBoard","ctlBoardName");
		ipaPort.port = ipaTable.getCellStoreValue(i,"ctlPort","ctlPort");
		ipaPort.portname = ipaTable.getCellStoreValue(i,"ctlBoard","ctlPortName");
				
		cntlPort.push(ipaPort);
		
		ipaPort = new IPAPort();		
		ipaPort.type = "ramon";
		ipaPort.neid = ipaTable.getCellStoreValue(i,"ramanID","ramonNeid");
		ipaPort.nename = ipaTable.getCellStoreValue(i,"raman","ramonNeName");
		ipaPort.slotid = ipaTable.getCellStoreValue(i,"raman","ramonSlotid");
		ipaPort.boardname = ipaTable.getCellStoreValue(i,"raman","ramonBoardName");
			
		ramonBoard.push(ipaPort);		
	}
	
}

/**
 *       IPA XML  
 * @param  
 * @return  
 */
function createQueryXmlInfo()
{
	var di = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    
    param.setAttribute("name","neid");
    param.setAttribute("value",winobj["neid"]);
    row.appendChild(param);     
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *   IPA    
 * @param  
 * @return  
 */
function doAddIPA()
{
	modifyFlag = false;
	
	queryAvailabeRes();
	if(hasAvailabeRes)
	{
		xshowModalDialog("ipacreate.html","","480px","500px","../../../../images/");
	}
	else //         
	{
		alert(RESOURCE["ID_NOEMPTYBRD"]);
	}
}

/**
 *   IPA    
 * @param  
 * @return  
 */
function doDeleteIPA()
{
	hideMenu();
	if(0 == ipaTable.getSelectedRowCount())
	{
		alert(RESOURCE["ID_SELECT"]);
	}
	else
	{
		if(!confirm(RESOURCE["ID_APRDELPROMPT"]))
		{
			return;
		}
		
		setButtonState(true,["delipabtn"]);
    	
    	var xmlData = createDeleteIPAXmlInfo();    	
    	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_DEL_APSDPAIR+"&nmUser="+winobj["nmUser"];
    	loadXMLdoc(url,"POST",true,callbackDeleteIPA,null,"inputdata="+xmlData);
	}
}

/**
 *   IPA     
 * @param  
 * @return  
 */
function callbackDeleteIPA(doc)
{
	var dataInterface = EncapsulateData(doc);
	
	var faultIPAList = [];
	
	for(var i = 0,len = dataInterface.getBErrLength(); i < len; i++)
	{
		faultIPAList.push(dataInterface.getBErrParam(i,"ipaID"));
	}
	for(var i = 0, len = ipaTable.getDataRowLength(); i < len; i++)
	{
		var ipaid = ipaTable.getCellStoreValue(i,"ipaID","ipaID");
		
		if(!faultIPAList.contains(ipaid) && ipaTable.getRowSelFlag(i))
		{
			ipaTable.deleteRow(i);
			
			useredWPGID.remove(ipaid);			
		}
	}
	
	ipaTable.adjustDataRows();
	
	getAvailableWPGID();	
	
	getUsedRes();
		
	showErrorPage(dataInterface);
	
	if(faultIPAList.length > 0)
	{
		setButtonState(false,["delipabtn"]);
	}
	reSetButtonStatue();
}

/**
 *       IPA XML  
 * @param  
 * @return  
 */
function createDeleteIPAXmlInfo()
{
	var di = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;  
    
    var ipaID;
    
    var selectRows = ipaTable.getSelectedRows();
    
    for(var i = 0, selectRowCount = ipaTable.getSelectedRowCount(); i < selectRowCount; i++)
    {
    	row = new tagElement("row-params");
    	
    	param = new tagElement("param");
	    param.setAttribute("name","neid");
	    param.setAttribute("value",winobj["neid"]);    
	    row.appendChild(param);
	    
    	ipaID = ipaTable.getCellStoreValue(selectRows[i],"ipaID","ipaID");
    	param = new tagElement("param");
    	
	    param.setAttribute("name","ipaID");
	    param.setAttribute("value",ipaID);    
	    row.appendChild(param); 
	    
	    bussiness.appendChild(row);
    }  
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *        
 * @param  
 * @return  
 */
function doApply()
{
	var xmlData = createApplyXmlInfo();
	
	if(null == xmlData)
	{
		return;
	}
	
	setButtonState(true,["applybtn"]);

	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_SET_APSDPAIR+"&nmUser="+winobj["nmUser"];
	loadXMLdoc(url,"POST",true,callbackApply,null,"inputdata="+xmlData);	
}

/**
 *   IPA     
 * @param  
 * @return  
 */
function callbackApply(doc)
{
	var dataInterface = EncapsulateData(doc);
	
	if(0 != dataInterface.getSErrorCode())
	{
		$("applybtn").disabled = false;
	}	
	
	refreshTableState(ipaTable,ipaTableConf,dataInterface);	
  
	showErrorPage(dataInterface,"set");
		
	rowSelectHandler(ipaTable.getSelectedRows());
}

/**
 *        XML  
 * @param  
 * @return  
 */
function createApplyXmlInfo()
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;
    var rowData = null;
    var colid = null;
    var key = null;
    var colkeyarray = null;
    var cellModifyFlag = false;
    var ramonSlotid = 0
    
    for(var rowindex = 0,rowlen = ipaTable.getDataRowLength();rowindex<rowlen;rowindex++)
    {
    	if(!ipaTable.getModify(rowindex))
    	{
    		continue;
    	}
    	
    	ramonSlotid = ipaTable.getCellStoreValue(rowindex,"raman","ramonSlotid");
        rowData = ipaTable.getRow();
        
    	row = new tagElement("row-params");
    	
    	param = new tagElement("param");
    	
		param.setAttribute("name","neid");
		
		param.setAttribute("value",winobj["neid"]); 
		
		row.appendChild(param);	
		
    	for(var colindex = 0, collen = ipaTable.getColumnCount(); colindex < collen; colindex++)
    	{
    		colid = ipaTableConf.getColId(colindex);    		
    		
    		cellModifyFlag = ipaTable.getCellModify(rowindex,colid);
    		
    		colkeyarray = ipaTableConf.getColKeyArray(colindex);
    		
    		for(var keyindex = 0,keylen = colkeyarray.length;keyindex<keylen;keyindex++)
    		{
    			param = new tagElement("param");
    			
    			key = colkeyarray[keyindex].name;
    			
    			param.setAttribute("name",key);
    			
    			if((key == "ramanAlarmTH" || key == "ramanLosTH") && ramonSlotid != 0)
    			{
    				param.setAttribute("value",ipaTable.getCellStoreValue(rowindex,colid,key)*10); 

    			}
    			else
    			{
	    			param.setAttribute("value",ipaTable.getCellStoreValue(rowindex,colid,key)); 
    		 }
    			  
    			param.setAttribute("modifyFlag",cellModifyFlag); 
    			
    			row.appendChild(param);		
    		}    		
    	}
    	
    	bussiness.appendChild(row);
    } 
    
    if(0 == bussiness.childNodes.length)
    {
    	return null;
    }  
     di.getRoot().appendChild(bussiness);
     return di.toString();
}

/**
 *             
 * @param  
 * @return  
 */
function doManualReBoot()
{
	hideMenu();
	if(0 == ipaTable.getSelectedRowCount())
	{
		alert(RESOURCE["ID_SELECT"]);
		return;
	}
	var xmlData = createBootIPAXmlInfo();	
	
	if(null == xmlData)
	{
		return;
	}
	
	$("restartbtn").disabled = true;
	
	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_START_APSDPAIR+"&nmUser="+winobj["nmUser"];
	loadXMLdoc(url,"POST",true,callbackManualReBoot,null,"inputdata="+xmlData);
}


/**
 *          
 * @param  
 * @return  
 */
function callbackManualReBoot(doc)
{
	$("restartbtn").disabled = false;
	
	var dataInterface = EncapsulateData(doc);
	
	showErrorPage(dataInterface);
	
}

/**
 *             
 * @param  
 * @return  
 */
function doTestBoot()
{
	hideMenu();
	if(0 == ipaTable.getSelectedRowCount())
	{
		alert(RESOURCE["ID_SELECT"]);
		return;
	}
	
	var xmlData = createBootIPAXmlInfo();	
	
	if(null == xmlData)
	{
		return;
	}
	$("testbtn").disabled = true;
	
	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_TEST_APSDPAIR+"&nmUser="+winobj["nmUser"];
	loadXMLdoc(url,"POST",true,callbackTestBoot,null,"inputdata="+xmlData);
}

/**
 *          
 * @param  
 * @return  
 */
function callbackTestBoot(doc)
{
	$("testbtn").disabled = false;
	
	var dataInterface = EncapsulateData(doc);
	
	showErrorPage(dataInterface);
	
}

/**
 *       IPA(           ) XML  
 * @param  
 * @return  
 */
function createBootIPAXmlInfo()
{
	var di = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;  
    
    var ipaID;
    
    var selectRows = ipaTable.getSelectedRows();
    
    for(var i = 0, selectRowCount = ipaTable.getSelectedRowCount(); i < selectRowCount; i++)
    {
    	if(ipaTable.getModify(selectRows[i]))
    	{
    		alert(RESOURCE["ID_SAVE"]);
    		return null;
    	}
    	if(1 != ipaTable.getCellStoreValue(selectRows[i],"ipaEnable","ipaEnable") || 1 != ipaTable.getCellStoreValue(selectRows[i],"reBootType","reBootType"))
    	{
    		continue;
    	}
    	
    	row = new tagElement("row-params");   
    	 	
    	param = new tagElement("param");
	    param.setAttribute("name","neid");
	    param.setAttribute("value",winobj["neid"]);    
	    row.appendChild(param);
	    
    	ipaID = ipaTable.getCellStoreValue(selectRows[i],"ipaID","ipaID");
    	param = new tagElement("param");
    	
	    param.setAttribute("name","ipaID");
	    param.setAttribute("value",ipaID);    
	    row.appendChild(param); 
	    
	    bussiness.appendChild(row);
    } 
    
    if(0 == bussiness.childNodes.length)
    {
    	return null;
    }  
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *             
 * @param  
 * @return  
 */
function doRelayTimeBoot()
{
	var xmlData = createQueryXmlInfo();	

	$("relaytimebtn").disabled = true;
	
	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_GET_APRALMDELAY+"&nmUser="+winobj["nmUser"];
	loadXMLdoc(url,"POST",true,callbackRelayTime,null,"inputdata="+xmlData);
}

/**
 *              
 * @param  
 * @return  
 */
function callbackRelayTime(doc)
{
	$("relaytimebtn").disabled = false;
	
	var data = EncapsulateData(doc);
	
	var delayTimes = 10;

	if(0 == data.getSErrorCode())
	{
		delayTimes = data.getDataRowParam(0,"delayTimes");
	}
	
	xshowModalDialog("ipadelaytimesmgrdialog.html?neid="+winobj["neid"]+"&delayTimes="+delayTimes,"","350px","150px","../../../../images/");
}


/**
 *              
 * @param  
 * @return  
 */
function doAssistantCheck()
{
	var selectRowCount = ipaTable.getSelectedRowCount();
	
	if(0 == selectRowCount)
	{
		alert(RESOURCE["ID_SELECT"]);
		return;
	}
	
	else if(selectRowCount > 1)
	{
		alert(RESOURCE["ID_ONCEAIPA"]);
		return;
	}	
	
	queryAssisCheckBoard();
	
	xshowModalDialog("assistantcheckboardmgr.html","","600px","450px","../../../../images/");
}

/**
 *        
 * @param  
 * @return  
 */
function queryAssisCheckBoard()
{
	var xmlData = createQeryAssisCheckBoardXmlInfo();	

	var url = "../../../../neExlorerServlet?sfid="+TECMD_CODE_QUERY_IPAMONPARA+"&nmUser="+winobj["nmUser"];
	loadXMLdoc(url,"POST",false,callbackQeryAssisCheckBoard,null,"inputdata="+xmlData);
}

/**
 *             
 * @param  
 * @return  
 */
function callbackQeryAssisCheckBoard(doc)
{
	assistantCheckBoard.clear();
	selectedAssisBoard.clear();
	allUsedAssisBoard.clear();
	
	var dataInterface = EncapsulateData(doc);
	
	var ipaPort;
	for(var i = 0, len = dataInterface.getDataRowLength(); i < len; i++)
	{
		ipaPort = new IPAPort();
		
		ipaPort.type = "assistant";
		ipaPort.neid = dataInterface.getDataRowParam(i,"neid");
		ipaPort.nename = dataInterface.getDataRowParam(i,"nename");
		ipaPort.shelfname = dataInterface.getDataRowParam(i,"shelfname");
		ipaPort.slotid = dataInterface.getDataRowParam(i,"slotid");
		ipaPort.boardid = dataInterface.getDataRowParam(i,"boardid");
		ipaPort.boardname = dataInterface.getDataRowParam(i,"boardname");
		ipaPort.port = dataInterface.getDataRowParam(i,"port");
		ipaPort.portname = dataInterface.getDataRowParam(i,"portname");	
		
		if(dataInterface.getDataRowParam(i,"type") == "selected")	
		{
			selectedAssisBoard.push(ipaPort);
			if(!allUsedAssisBoard.contains(ipaPort.toString()))
			{
				allUsedAssisBoard.push(ipaPort);
			}
		}
		else
		{
			assistantCheckBoard.push(ipaPort);
		}		
	}
	if(ipaTable.getSelectedRowCount() > 0)
	{
		var rowIndex = ipaTable.getSelectedRows()[0];
		ipaTable.setAtomValue(ipaTable.getCellElement(rowIndex,"auxDectectBoard").showElement,getAssisBoardShow(selectedAssisBoard));	
	}
}

function getAssisBoardShow(board)
{
	var str = "";
	var code = "";
	for(var i = 0,m = board.length;i < m;i++)
	{
		str += code + board[i].toShowString();
		code = ",";
	}
	return str;
}

/**
 *             XML  
 * @param  
 * @return  
 */
function createQeryAssisCheckBoardXmlInfo()
{
	var di = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;  
    
    var ipaID;
    
    var selectRows = ipaTable.getSelectedRows();
    
    for(var i = 0, selectRowCount = ipaTable.getSelectedRowCount(); i < selectRowCount; i++)
    {
    	ipaID = ipaTable.getCellStoreValue(selectRows[i],"ipaID","ipaID");
	    
	    bussiness.appendChild(createDectectBoardParamRow(ipaID));
    } 
    if(bussiness.childNodes.length == 0)
    {
	    bussiness.appendChild(createDectectBoardParamRow("0"));
    }

    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *              
 */
function createDectectBoardParamRow(ipaID)
{
	var row = new tagElement("row-params");   
    	 	
	param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",winobj["neid"]);    
    row.appendChild(param);
    
	param = new tagElement("param");
    param.setAttribute("name","ipaID");
    param.setAttribute("value",ipaID);    
    row.appendChild(param);
    
    return row;
}


/**
 *     IPA     
 * @param  
 * @return  
 */
function queryAvailabeRes()
{
	var xmlData = createQueryAvailabeResXML();	
	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_GET_APSD_SELECTABLEPORT+"&nmUser="+winobj["nmUser"];
	loadXMLdoc(url,"POST",false,callbackQueryAvailabeRes,null,"inputdata="+xmlData);
}

/**
 *     IPA          
 * @param  
 * @return  
 */
function callbackQueryAvailabeRes(doc)
{
	availableAlmPort.clear();
	availableCntlPort.clear();
	availableRamonBoard.clear();
	assistantCheckBoard.clear();
	
	var dataInterface = EncapsulateData(doc);

	var ipaPort;
	for(var i = 0, len = dataInterface.getDataRowLength(); i < len; i++)
	{
		ipaPort = new IPAPort();
		
		ipaPort.type = dataInterface.getDataRowParam(i,"type");
		ipaPort.neid = dataInterface.getDataRowParam(i,"neid");
		ipaPort.nename = dataInterface.getDataRowParam(i,"nename");
		ipaPort.shelfname = dataInterface.getDataRowParam(i,"shelfname");
		ipaPort.slotid = dataInterface.getDataRowParam(i,"slotid");
		ipaPort.boardid = dataInterface.getDataRowParam(i,"boardid");
		ipaPort.boardname = dataInterface.getDataRowParam(i,"boardname");
		ipaPort.port = dataInterface.getDataRowParam(i,"port");
		ipaPort.portname = dataInterface.getDataRowParam(i,"portname");		
		
		if(ipaPort.type == "alarm")
		{
			var flag = true;
			for(var j = 0; j < almPort.length; j ++)
			{
				if(almPort[j].toString() == ipaPort.toString())
				{
					flag = false;
					break;
				}
			}	
			if(flag)
			{		
				availableAlmPort.push(ipaPort);
            }		
		}
		else if(ipaPort.type == "control") //   
		{
			var flag = true;
			for(var j = 0; j < cntlPort.length; j ++)
			{
				if(cntlPort[j].toString() == ipaPort.toString())
				{
					flag = false;
					break;
				}
			}	
			if(flag)
			{		
				availableCntlPort.push(ipaPort);
			}
		} 
		else if(ipaPort.type == "assistant") //     
		{			
			assistantCheckBoard.push(ipaPort);
		}
		else  //Ramon 
		{
			var flag = true;
			for(var j = 0; j < ramonBoard.length; j ++)
			{
				if(ramonBoard[j].toString() == ipaPort.toString())
				{
					flag = false;
					break;
				}
			}	
			if(flag)
			{		
				availableRamonBoard.push(ipaPort);
			}
		}
	}
	
	if(0 != availableCntlPort.length)
	{
		hasAvailabeRes = true;
	}
	else
	{
		hasAvailabeRes = false;
	}
}

/**
 *     IPA      XML  
 * @param  
 * @return  
 */
function createQueryAvailabeResXML()
{
	var di = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;  
    
    row = new tagElement("row-params");
    	
	param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",winobj["neid"]);    
    row.appendChild(param); 
     
	bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *    IPA  ID
 * @param 
 * @return Array    IPA  ID
 */
function getAvailableWPGID()
{
	var availableWPGIDLen = MAX_IPA_ID - ipaTable.getDataRowLength();
	
	availableWPGID = getRangeNumber(useredWPGID,MIN_IPA_ID,MAX_IPA_ID,availableWPGIDLen);
}

/**
 *         
 * @param doc        
 * @return  
 */
function showErrorPage(data,flag)
{
	var tmp="";
	if(flag)
	{
		tmp = RESOURCE[flag];
	}
	
	var ipaIDstr = getAttrName(ipaTableConf,"ipaID");
	
	for(var i = 0, len = data.getBErrLength(); i < len; i++)
	{	
		data.getError().rowErrors[i].errorObj["ipaID"] = ipaIDstr + ":"+ data.getError().rowErrors[i].errorObj["ipaID"];
		
		if(flag)
		{
			data.getError().rowErrors[i].errorObj["attrId"] = tmp + getAttrName(ipaTableConf,data.getError().getRowKey(i,"attrId"));
		}
	}
	
	var errArr = [];

	errArr.push("ipaID");
	if(flag)
	{
		errArr.push("attrId");
	}
	openErrPage("../../../../page/",data.getError(),errArr);
}

/**
 *       
 * @param disabledState      btnIDArr:         ID  
 * @return  
 */
function setButtonState(disabledState,btnIDArr)
{
	if(null == btnIDArr || btnIDArr.length == 0)
	{
		btnIDArr = [];
		btnIDArr.push("querybtn");
		btnIDArr.push("addipabtn");
		btnIDArr.push("delipabtn");
		btnIDArr.push("applybtn");
		btnIDArr.push("restartbtn");
		btnIDArr.push("relaytimebtn");
		btnIDArr.push("checkbtn");
		btnIDArr.push("testbtn");
	}
	
	for(var i = 0; i < btnIDArr.length; i++)
	{
		if(btnRightArr[btnIDArr[i]].right == true)
		{
			$(btnIDArr[i]).disabled = disabledState;			
		}
		
	}	
}

/*
 *   IPA        
 */
function reSetButtonStatue()
{
	if(ipaTable.getSelectedRowCount() > 0)
	{
		$("delipabtn").disabled = false;		
		$("restartbtn").disabled = false;
		$("testbtn").disabled = false;
		if(ipaTable.getSelectedRowCount > 1)
		{
			$("checkbtn").disabled = true;
		}
		else
		{
			$("checkbtn").disabled = false;
		}
	}
	else
	{
		$("delipabtn").disabled = true;		
		$("restartbtn").disabled = true;
		$("testbtn").disabled = true;		
		$("checkbtn").disabled = true;
	}
	
	$("applybtn").disabled = true;
	
	for(var i = 0; i < ipaTable.getDataRowLength(); i++)
	{
		if(ipaTable.getModify(i))
		{
			$("applybtn").disabled = false;
			break;
		}
	}
	
}

/**
 *   common.js               
 * @param res:     obj     /   key:     
 * @return String      
 */
function convertMsg(res,obj,key)
{
	if("function" == (typeof obj))	
	{
		return obj(key);
	}
	else //       
	{
		if(null == obj)
		{
			return key;
		}
		var resValue = obj[key];
		if(null == resValue)
		{
			resValue = key;
		}		
		return resValue;
	}
}

/**
 * IPA    
 * @param  
 * @return  
 */
function IPAPort()
{
	this.type = "";
	this.neid = -1;
	this.nename = "";
	this.shelfname = "";
	this.slotid = 0;
	this.boardid = 0;
	this.boardname = "";
	this.port = 0;
	this.portname = "";
}

/**
 * IPA       
 * @param  
 * @return  
 */
IPAPort.prototype.equals = function(obj)
{
	return (obj.type == this.type && obj.neid == this.neid && obj.slotid == this.slotid && obj.port == this.port)
}

/**
 * IPA     toString  
 * @param  
 * @return String :IPA     String  
 */
IPAPort.prototype.toShowString = function()
{   
	var slotstr = (this.shelfname == null || this.shelfname == "")?this.slotid:this.shelfname + "-" + getSlotIDFromSlot(this.slotid);
	
	if(this.type == "ramon")
	{
		return this.nename + "-" + slotstr + "-" + this.boardname;		
	}
	else
	{
		return slotstr + "-" + this.boardname + "-" + this.portname;
	}
}
IPAPort.prototype.toString = function()
{
	if(this.type == "ramon")
	{
		return this.neid + "-" + this.slotid + "-" + this.boardname;		
	}
	else
	{
		return this.slotid + "-" + this.boardname + "-" + this.portname;
	}
}

/**
 *       
 * @param  
 * @return  
 */ 
function sendRightInfo()
{
	var url = "../../../../securityServlet?neID="+winobj["neid"]+"&nmUser="+winobj["nmUser"];
	loadXMLdoc(url,"POST",false,rightHandleBack,null,"inputdata=" + createRightXML());
}

/**
 *           
 * @param  
 * @return  
 */ 
function rightHandleBack(doc)
{
	var data = EncapsulateData(doc);
    
	for(var i = 0; i < data.getDataRowLength(); i++)  //       
    {
    	var right = data.getDataRowParam(i,"right");
    	
    	if(0 == right)
    	{
    		btnRightArr[data.getDataRowParam(i,"btnID")].right = false;
    	} 
    	else
    	{
    		btnRightArr[data.getDataRowParam(i,"btnID")].right = true;
    	}        
    }
    initBtnStatue();     
}
 
/**
 *           XML
 * @param  
 * @return  
 */ 
function createRightXML()
{
	var root = new inputxml("datainterface");//Create the root of a xml file
	var firstlevel = new tagElement("bussiness-params");
	
	var secondlevel=null;;
	var thirdlevel=null;
	
    for(var btnrightobj in btnRightArr)
	{
		secondlevel = new tagElement("row-params"); //bean         	
		
		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name","btnID");
		thirdlevel.setAttribute("value",btnRightArr[btnrightobj].btnId);
		secondlevel.appendChild(thirdlevel);
		
		thirdlevel = new tagElement("param");	
		thirdlevel.setAttribute("name","sfid");
		thirdlevel.setAttribute("value",btnRightArr[btnrightobj].sfid);
		secondlevel.appendChild(thirdlevel);
		
		firstlevel.appendChild(secondlevel);
	}
	root.getRoot().appendChild(firstlevel);
	return root.toString();
}

/**
 *        
 * @param btnId       ID  sfid             ID
 * @return  
 */ 
function BtnRightObj(btnId,sfid)
{
	if(null != btnId)
	{
		this.btnId = btnId;
	}
	else
	{
		this.btnId = "";
	}
	
	if(isNaN(parseInt(sfid)))
	{
		this.sfid = -1;
	}
	else
	{
		this.sfid = sfid;
	}
	this.right = true;
}

/**
 * BtnRightObj   toString  
 * @param  
 * @return String :IPA     String  
 */
BtnRightObj.prototype.toString = function()
{	
	var str = "The button's Id = " + this.btnId + " sfid = " + this.sfid + " right = " + this.right;
	return str;
}

window.onresize=function()
{
	ipaTable.setBodyHeight(getComponetHeight($("tablecomponent"),100)+"px");
}


function popupMenuHandler(evt)
{
  	if(!evt)
  	{
  	  evt= window.event;	
  	}
  	 
    var elem = (evt.target) ? evt.target : evt.srcElement;   

    if(elem!= null&&elem.blur)
    {
    	elem.blur();	  	
    }
   
   while(elem!=null)
	 {
	    if(elem.tagName == 'TD')
	    {
	        break;	
	    }
	    else
	    {
		    elem =elem.parentNode;	  	
	    }	
   } 
  
	if(elem == null || elem.tagName != 'TD' || null == elem.parent)
	{
		  return;
	}  
	
	  var rowid= elem.parentNode.rowIndex;
    var rows =elem.parent.getSelectedRows();
    var colid = elem.colid;
    if(rows.contains(rowid))
    {
    	if(null != elem.editElement && elem.isEdit == 1)
    	{
    			 createTablePopupMenu(elem,evt);
    			 return;
    	}
    	
    	for(var i = 0; i < rows.length; i++)
    	{
    		var tmpElem = elem.parent.getCellElement(rows[i],colid);
    		if(null != tmpElem.editElement && tmpElem.isEdit == 1)
    		{
    			 createTablePopupMenu(tmpElem,evt);
    			 return;
    		}
    	}
    	createFuncPopupMenu(rows,evt);    	
    }    
}

function createFuncPopupMenu(rows,evt)
{
     removejsDOMmenu();
     var isBootFlag = false; //       
     for(var i = 0; i < rows.length; i++)
	{
    	if(1 == ipaTable.getCellStoreValue(rows[i],"ipaEnable","ipaEnable") && 1 == ipaTable.getCellStoreValue(rows[i],"reBootType","reBootType"))
    	{
    		isBootFlag = true;
			break;
    	}
	}   	
     var cursorMenu1 = new jsDOMenu(150); 
     cursorMenu1.addMenuItem(new menuItem(RESOURCE["restartbtn"],"",doManualReBoot,null,isBootFlag));      	
     cursorMenu1.addMenuItem(new menuItem(RESOURCE["testbtn"],"",doTestBoot,null,isBootFlag));
     cursorMenu1.addMenuItem(new menuItem('-'));
     cursorMenu1.addMenuItem(new menuItem(RESOURCE["delipabtn"],"",doDeleteIPA));
     setPopUpMenu(cursorMenu1);
     showMenu(evt); 
	
}
