var win = getParentWindow();

var newIPATable;

var newIPAObj;

var isApply;

loadXMLdoc("../../../../conf/system.xml", "GET", false,EncapsulateSConf);
getResourse("../../../../res/commonres_"+ SYSTEMCONF.getLanguage() +".xml");
getResourse("../../res/ipa/ipamgr_"+SYSTEMCONF.getLanguage()+".xml");

var ipaEnableFlag = false;

var ipasecurityFlag = false;

if(win.modifyFlag)
{
	document.write("<title>" + RESOURCE["ID_MODIFYAPR"] + "</title>");
}
else
{
	document.write("<title>" + RESOURCE["ID_NEWAPR"] + "</title>");	
}

var assistantCheckBoard = [];

var selectedAssisBoard = [];

var modifySelectedAssisBoard = [];

var allUsedAssisBoard = [];


/**
 *      
 * @param  
 * @return  
 */
function initPage()
{
	initTable();
	initTableData();
	initButton();
	initAssisCheckBoard();
	if(win.modifyFlag)
	{
		initModifyTableState();
	}
}

function selectIPABoard(objSelect,svalue)
{
	var slotids = [];
	var slotid = "0";
	if(typeof(svalue) != "undefined" && svalue != null)
	{
		slotids = svalue.split("-");
	}
	if(slotids.length >= 2)
	{
		slotid = slotids[slotids.length - 2];
	}
	var boards = null;
	for(var i = 0,m = objSelect.options.length;i < m;i++)
	{
		boards = objSelect.options[i].value.split("-");
		if(boards[boards.length-2] == slotid)
		{
			objSelect.selectedIndex = i;
			break;
		}
	}
}

/**
 *         
 *          ,           
 */
function initModifyTableState()
{
	var index = win.ipaTable.getSelectedRows()[0];
	
	var ipaID = win.ipaTable.getCellShow(index,"ipaID").getValue();
	var band = win.ipaTable.getCellShow(index,"band").getValue();
	
	var alarmBoard = win.ipaTable.getCellShow(index,"alarmBoard").getValue();
	var alarmBoardValue = win.ipaTable.getCellStoreValue(index,"alarmBoard","alarmBoard");
	var ctlBoard = win.ipaTable.getCellShow(index,"ctlBoard").getValue();
	var ctlBoardValue = win.ipaTable.getCellStoreValue(index,"ctlBoard","ctlBoard");
	var raman = win.ipaTable.getCellShow(index,"raman").getValue();
	var ramanValue = win.ipaTable.getCellStoreValue(index,"raman","raman");
	
	var ipaEnable = win.ipaTable.getCellStoreValue(index,"ipaEnable","ipaEnable");
	var reBootType = win.ipaTable.getCellStoreValue(index,"reBootType","reBootType");
	
	var offTimes = win.ipaTable.getCellShow(index,"offTimes").getValue();
	var onTimes = win.ipaTable.getCellShow(index,"onTimes").getValue();
	var testTimes = win.ipaTable.getCellShow(index,"testTimes").getValue();
	
	var securityEnable = win.ipaTable.getCellStoreValue(index,"securityEnable","securityEnable");
	var ramanAlarmEnable = win.ipaTable.getCellStoreValue(index,"ramanAlarmEnable","ramanAlarmEnable");
	
	var ipaStatus = win.ipaTable.getCellShow(index,"ipaStatus").getValue();
	var ramanLosTH = win.ipaTable.getCellShow(index,"ramanLosTH").getValue();
	var ramanAlarmTH = win.ipaTable.getCellShow(index,"ramanAlarmTH").getValue();
	var auxRamanBoard = win.ipaTable.getCellShow(index,"auxRamanBoard").getValue();
	var pumpBoard = win.ipaTable.getCellShow(index,"pumpBoard").getValue();
	
	newIPATable.getAtom("ipaID").clearOptions();
	newIPATable.getAtom("ipaID").addOption(ipaID,ipaID);
	newIPATable.getAtom("ipaID").element.disabled = true;
	
	newIPATable.getAtom("band").value = band;
	newIPATable.getAtom("band").element.disabled = true;
	
	newIPATable.getAtom("alarmPort").clearOptions();
	newIPATable.getAtom("alarmPort").addOption(alarmBoard,alarmBoardValue);
	newIPATable.getAtom("alarmPort").element.disabled = true;
	
	newIPATable.getAtom("ctlPort").clearOptions();
	newIPATable.getAtom("ctlPort").addOption(ctlBoard,ctlBoardValue);
	newIPATable.getAtom("ctlPort").element.disabled = true;
	
	newIPATable.getAtom("ramonBoard").clearOptions();
	newIPATable.getAtom("ramonBoard").addOption(raman,raman);
	newIPATable.getAtom("ramonBoard").element.disabled = true;
	
	initAuxRamanBoard();
	
	newIPATable.getAtom("ipaEnable").element.value = ipaEnable;	
	newIPATable.getAtom("reBootType").element.value = reBootType;	
	newIPATable.getAtom("securityEnable").element.value = securityEnable;
	
	newIPATable.getAtom("offTimes").element.value = offTimes;	
	newIPATable.getAtom("testTimes").element.value = testTimes;	
	
	newIPATable.getAtom("onTimes").element.value = onTimes;
	var ramans = raman.split("-");
	if(ramans.length <= 1)
	{
		newIPATable.getAtom("auxRamanBoard").clearOptions();
		newIPATable.getAtom("auxRamanBoard").addOption("-", "-");
		newIPATable.getAtom("auxRamanBoard").element.disabled = true;
		
		newIPATable.getAtom("pumpBoard").clearOptions();
		newIPATable.getAtom("pumpBoard").addOption("-", "-");
		newIPATable.getAtom("pumpBoard").element.disabled = true;
	
		newIPATable.getAtom("ramanAlarmEnable").clearOptions();
		newIPATable.getAtom("ramanAlarmEnable").addOption("-", "-");
		newIPATable.getAtom("ramanAlarmEnable").element.disabled = true;
	    
		newIPATable.getAtom("ramanLosTH").element.value = "-";
		newIPATable.getAtom("ramanLosTH").element.disabled = true;
		newIPATable.getAtom("ramanAlarmTH").element.value = "-";
		newIPATable.getAtom("ramanAlarmTH").element.disabled = true;
		
	}
	else
	{
		selectIPABoard(newIPATable.getAtom("auxRamanBoard").element,auxRamanBoard);
		selectIPABoard(newIPATable.getAtom("pumpBoard").element,pumpBoard);		
		newIPATable.getAtom("ramanAlarmEnable").element.value = ramanAlarmEnable;	
		newIPATable.getAtom("ramanLosTH").element.value = ramanLosTH;
		newIPATable.getAtom("ramanAlarmTH").element.value = ramanAlarmTH;
	}
}

/**
 *      
 * @param  
 * @return  
 */
function initTable()
{
	newIPATable = new  CTable();
	
    newIPATable.addHead(RESOURCE["ID_Attribute"], RESOURCE["ID_Value"]);
    
    var atom = new Atom("select");
   
    newIPATable.addAttrRow("ipaID",RESOURCE["ID_PROTECTGROUP"],atom)

    atom=new Atom("select");
    newIPATable.addAttrRow("band",RESOURCE["ID_Band"],atom)
    
    atom=new Atom("select");
    newIPATable.addAttrRow("alarmPort",RESOURCE["ID_Detection_Board"],atom)    
    
    atom=new Atom("select");
    newIPATable.addAttrRow("ctlPort",RESOURCE["ID_Control_Board"],atom)
    
    atom=new Atom("select");
    atom.element.onchange = changeRamonBoard;
    newIPATable.addAttrRow("ramonBoard",RESOURCE["ID_Ramon_Amplifier"],atom)
    
    atom=new Atom("select");
    atom.element.onchange = function(){ipaEnableFlag = true;};
    newIPATable.addAttrRow("ipaEnable",RESOURCE["ID_Enable_Flag"],atom)
    
    atom=new Atom("select");
    newIPATable.addAttrRow("reBootType",RESOURCE["ID_Restart_Mode"],atom)
    
    atom=new Atom("text");

    textCheck(atom.element,"100","300");
    
    newIPATable.addAttrRow("offTimes",RESOURCE["ID_Off_Period"],atom)
    
    atom=new Atom("text");
    
    textCheck(atom.element,"175","4500");
    
    newIPATable.addAttrRow("onTimes",RESOURCE["ID_On_Period"],atom)
    
    atom=new Atom("text");

    textCheck(atom.element,"80","100");
    
    newIPATable.addAttrRow("testTimes",RESOURCE["ID_Testing_Period"],atom)
    
    atom=new Atom("select");
    atom.element.onchange = function(){ipasecurityFlag = true;};
    newIPATable.addAttrRow("securityEnable",RESOURCE["ID_Security_Switch"],atom)

    atom=new Atom("text");
    checkText(atom.element,"-35.0","-14.0");
    newIPATable.addAttrRow("ramanLosTH",RESOURCE["ID_Raman_LOS_TH"],atom);

    atom=new Atom("text");
    checkText(atom.element,"-60.0","0.0");
    newIPATable.addAttrRow("ramanAlarmTH",RESOURCE["ID_Raman_Alarm_TH"],atom);
    
    atom=new Atom("select");
    newIPATable.addAttrRow("ramanAlarmEnable",RESOURCE["ID_Raman_Alarm_Enable"],atom);
    atom.element.value = "10";
    
    atom=new Atom("text");
    atom.element.readOnly = "readonly";
	atom.element.style.width="85%";
    newIPATable.addAttrRow("auxDectectBoard",RESOURCE["checkbtn"],atom);
    var btn = document.createElement("input");
	btn.setAttribute("type", "button");
	btn.value = "...";
	btn.className = "selectbuttonstyle";
	btn.onclick = auxDectectBoard_onclick;
	newIPATable.getAtom("auxDectectBoard").element.parentNode.appendChild(btn);
    
    document.body.insertBefore(newIPATable.getTable(),document.body.firstChild);   
}

function auxDectectBoard_onclick()
{
	
	xshowModalDialog("../ipa/assistantcheckboardmgr.html","","600px","450px","../../../../images/");
}


/**
 *      
 * @param  
 * @return  
 */
function initTableData()
{
    var atom = newIPATable.getAtom("ipaID");
    
    atom.clearOptions();
    if (win.availableWPGID.length > 0)
    {
    	for(var i = 0, len = win.availableWPGID.length; i < len; i++)
    	{
    		atom.addOption(win.availableWPGID[i],win.availableWPGID[i])
    	}
    }
    else
    {
    	$("okbtn").disabled = true;
    	$("applybtn").disabled = true;
    }

    atom = newIPATable.getAtom("band");
    atom.clearOptions();
    atom.addOption(bandType["1"], "1");
    
    atom = newIPATable.getAtom("alarmPort");
    atom.clearOptions()
    for(var i = 0, len = win.availableAlmPort.length; i < len; i++)
    {
    	atom.addOption(win.availableAlmPort[i].toShowString(), win.availableAlmPort[i].toString());
    }
 
    atom.addOption(RESOURCE["ID_BLANK_ITEM"], "0-0-0()");
    
    atom = newIPATable.getAtom("ctlPort");
    atom.clearOptions();
    for(var i = 0, len = win.availableCntlPort.length; i < len; i++)
    {
    	atom.addOption(win.availableCntlPort[i].toShowString(), win.availableCntlPort[i].toString());
    }
    
    atom = newIPATable.getAtom("ramonBoard");
    atom.clearOptions();
	for(var i = 0, len = win.availableRamonBoard.length; i < len; i++)
    {
    	atom.addOption(win.availableRamonBoard[i].toShowString(),win.availableRamonBoard[i].toString());
    }
    
    atom.addOption(RESOURCE["ID_BLANK_ITEM"], "0-0-0");
    
    atom = newIPATable.getAtom("ipaEnable");
    atom.clearOptions();
    atom.addOption(enableFlag[0], "0");
    atom.addOption(enableFlag[1], "1");
    
    atom = newIPATable.getAtom("reBootType");
    atom.clearOptions();
    atom.addOption(ipaReStartType[0], "0");
    atom.addOption(ipaReStartType[1], "1");
    
    atom = newIPATable.getAtom("offTimes");
    
    atom.element.value = "100";    
    
    atom = newIPATable.getAtom("onTimes");
    
    atom.element.value = "300";
    
    atom = newIPATable.getAtom("testTimes");
    
    atom.element.value = "80";
    
    atom = newIPATable.getAtom("securityEnable");
    atom.clearOptions();
    atom.addOption(controlSwitch[0], "0");
    atom.addOption(controlSwitch[1], "1");
    
    changeRamonBoard();
     
    document.body.insertBefore(newIPATable.getTable(),document.body.firstChild);   
}

/**
 *           
 */
function initAssisCheckBoard()
{
	win.queryAssisCheckBoard();
	assistantCheckBoard = win.assistantCheckBoard;
	allUsedAssisBoard = win.allUsedAssisBoard;
	if(win.modifyFlag)
	{
		selectedAssisBoard = win.selectedAssisBoard;
		
		modifySelectedAssisBoard.clear();
		var text = "";
	
		for(var i = 0;i < selectedAssisBoard.length;i++)
		{
			modifySelectedAssisBoard.append(new DetectBoard(selectedAssisBoard[i].toShowString(),selectedAssisBoard[i].toString()));
			text += selectedAssisBoard[i].toShowString() + ",";
		}
		newIPATable.getAtom("auxDectectBoard").setValue(text);
		newIPATable.getAtom("auxDectectBoard").element.setAttribute("title",text);
	}
	
}



function changeRamonBoard()
{
    var ramanLosTHEle = newIPATable.getAtom("ramanLosTH").element;
    var ramanAlarmTHEle = newIPATable.getAtom("ramanAlarmTH").element;
    var ramanAlarmEnableAtom = newIPATable.getAtom("ramanAlarmEnable");
    
    if(newIPATable.getAttrValue("ramonBoard") == "0-0-0")	
    {
  		ramanLosTHEle.value = "-";
  		ramanLosTHEle.disabled = true;
  		ramanAlarmTHEle.value = "-";
  		ramanAlarmTHEle.disabled = true;

	    ramanAlarmEnableAtom.clearOptions();
	    ramanAlarmEnableAtom.addOption(enableFlag[0], "0");
	    ramanAlarmEnableAtom.addOption(enableFlag[1], "1");
	    
    }
    else
  	{
  		ramanLosTHEle.disabled = false;
  		ramanAlarmTHEle.disabled = false;
  		ramanAlarmEnableAtom.element.disabled = false;
    	ramanLosTHEle.value = "-15.0";
    	ramanAlarmTHEle.value = "0.0";
	    ramanAlarmEnableAtom.clearOptions();
	    ramanAlarmEnableAtom.addOption(enableFlag[0], "0");
	    ramanAlarmEnableAtom.addOption(enableFlag[1], "1");
  	}
}


/**
 *      
 * @param  
 * @return  
 */
function initButton()
{
	$("okbtn").value = RESOURCE["okbutton"];
    $("applybtn").value = RESOURCE["applybutton"];
    $("canclebtn").value = RESOURCE["cancelbutton"]; 
}

/**
 *     IPA
 * @param  
 * @return  
 */
function performAddIPA(isApplyFlag)
{	
	isApply = isApplyFlag;
    
    if(win.modifyFlag)
    {
    	var xmlData = createAddModifyXMLInfo();
		if(null == xmlData)
		{
		    return;
		}
			
        $('okbtn').disabled = true;
        $('applybtn').disabled = true;

    	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_SET_APRCTRLPARA+"&nmUser="+win.winobj["nmUser"];
		loadXMLdoc(url,"POST",true,callbackModifyIPA,null,"inputdata="+xmlData);
    }
    else
    {
	    if(checkData())
	    {    			        
			var xmlData = createAddIPAXMLInfo();
			if(null == xmlData)
			{
			    return;
			}
			
			$("okbtn").disabled = true;
		    $("applybtn").disabled = true;
		    $("canclebtn").diabled = true; 
	    	
			var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_SET_APRCTRLPARA+"&nmUser="+win.winobj["nmUser"];
			loadXMLdoc(url,"POST",true,callbackAddIPA,null,"inputdata="+xmlData);
	    }	
    }
    
}

function callbackModifyIPA(doc)
{
	var data = EncapsulateData(doc);
	var errCode = data.getSErrorCode();
	var index = win.ipaTable.getSelectedRows()[0];
	if(0 == errCode)
	{
		var ipaEnable = newIPATable.getAttrValue("ipaEnable");
		win.ipaTable.setCellValue(win.ipaTable.getCell(index,"ipaEnable"),"ipaEnable",ipaEnable);
		win.ipaTable.getCellShow(index,"ipaEnable").setValue(enableFlag[ipaEnable]);
		
		var reBootType = newIPATable.getAttrValue("reBootType");
		win.ipaTable.setCellValue(win.ipaTable.getCell(index,"reBootType"),"reBootType",reBootType);
		win.ipaTable.getCellShow(index,"reBootType").setValue(ipaReStartType[reBootType]);
		
		var offTimes = newIPATable.getAttrValue("offTimes");
		win.ipaTable.setCellValue(win.ipaTable.getCell(index,"offTimes"),"offTimes",offTimes);
		win.ipaTable.getCellShow(index,"offTimes").setValue(offTimes);
		
		var testTimes = newIPATable.getAttrValue("testTimes");
		win.ipaTable.setCellValue(win.ipaTable.getCell(index,"testTimes"),"testTimes",testTimes);
		win.ipaTable.getCellShow(index,"testTimes").setValue(testTimes);
		
		var onTimes = newIPATable.getAttrValue("onTimes");
		win.ipaTable.setCellValue(win.ipaTable.getCell(index,"onTimes"),"onTimes",onTimes);
		win.ipaTable.getCellShow(index,"onTimes").setValue(onTimes);
		
		var securityEnable = newIPATable.getAttrValue("securityEnable");
		win.ipaTable.setCellValue(win.ipaTable.getCell(index,"securityEnable"),"securityEnable",securityEnable);
		win.ipaTable.getCellShow(index,"securityEnable").setValue(controlSwitch[securityEnable]);
		
		var ramans = newIPATable.getAttrValue("ramonBoard").split("-");
		if(ramans.length > 1)
		{
			var atomElement = newIPATable.getAtom("auxRamanBoard").element;
			var auxRamanboard = atomElement.options[atomElement.selectedIndex].text.split("-");
			
			if(auxRamanboard[auxRamanboard.length - 2] == 0)
			{
				win.ipaTable.getCellShow(index,"auxRamanBoard").setValue("");
			}
			else
			{
				win.ipaTable.getCellShow(index,"auxRamanBoard").setValue(auxRamanboard.join("-"));	
			}
			atomElement = newIPATable.getAtom("pumpBoard").element;
			var pumpBoard = atomElement.options[atomElement.selectedIndex].text.split("-");
			
			if(pumpBoard[pumpBoard.length - 2] == 0)
			{
				win.ipaTable.getCellShow(index,"pumpBoard").setValue("");
			}
			else
			{
				win.ipaTable.getCellShow(index,"pumpBoard").setValue(pumpBoard.join("-"));	
			}
			var ramanAlarmEnable = newIPATable.getAttrValue("ramanAlarmEnable");
			win.ipaTable.setCellValue(win.ipaTable.getCell(index,"ramanAlarmEnable"),"ramanAlarmEnable",ramanAlarmEnable);
			win.ipaTable.getCellShow(index,"ramanAlarmEnable").setValue(enableFlag[ramanAlarmEnable]);
			
			var ramanLosTH = newIPATable.getAttrValue("ramanLosTH");
			win.ipaTable.setCellValue(win.ipaTable.getCell(index,"ramanLosTH"),"ramanLosTH",ramanLosTH);
			win.ipaTable.getCellShow(index,"ramanLosTH").setValue(ramanLosTH);
			
			var ramanAlarmTH = newIPATable.getAttrValue("ramanAlarmTH");
			win.ipaTable.setCellValue(win.ipaTable.getCell(index,"ramanAlarmTH"),"ramanAlarmTH",ramanAlarmTH);
			win.ipaTable.getCellShow(index,"ramanAlarmTH").setValue(ramanAlarmTH);
		}
	}
	else
	{
		win.showErrorPage(data);
	}
	initAssisCheckBoard();
	if(!isApply && (0 == errCode || 1 == errCode))
	{
		win.modifyFlag = false;
		self.close();
		return;
	}
	$('okbtn').disabled = false;
    $('applybtn').disabled = false;
}

function createAddModifyXMLInfo()
{
	var di = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = null;
    
    param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",win.winobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","ipaID");
    param.setAttribute("value",newIPATable.getAttrValue("ipaID"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","modifyFlag");
    param.setAttribute("value",win.modifyFlag);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","ipaEnable");
    param.setAttribute("value",newIPATable.getAttrValue("ipaEnable"));
    row.appendChild(param); 
    if(ipaEnableFlag && newIPATable.getAttrValue("ipaEnable") == 0)
    {
        if(!confirm(RESOURCE["IPA_ENABLE_FLAG_DISABLE"]))
        {
            return null;
        }
    }
    
    param = new tagElement("param");
    param.setAttribute("name","reBootType");
    param.setAttribute("value",newIPATable.getAttrValue("reBootType"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","offTimes");
    param.setAttribute("value",newIPATable.getAttrValue("offTimes"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","onTimes");
    param.setAttribute("value",newIPATable.getAttrValue("onTimes"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","testTimes");
    param.setAttribute("value",newIPATable.getAttrValue("testTimes"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","testTimes");
    param.setAttribute("value",newIPATable.getAttrValue("testTimes"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","reBootEnable");
    param.setAttribute("value","1");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","securityEnable");
    param.setAttribute("value",newIPATable.getAttrValue("securityEnable"));
    row.appendChild(param);
    if(ipasecurityFlag && newIPATable.getAttrValue("securityEnable") == 0)
    {
        if(!confirm(RESOURCE["SECURITY_CONTROL_DISABLE"]))
        {
            return null;
        }
    }

		var ramonBoard = newIPATable.getAttrValue("ramonBoard").split("-");

    if(ramonBoard.length > 1)
    {
    	param = new tagElement("param");
	    param.setAttribute("name","ramonSlotid");
	    param.setAttribute("value",ramonBoard[ramonBoard.length - 2]);
	    row.appendChild(param);
    	
	    param = new tagElement("param");
	    param.setAttribute("name","ramanLosTH");
	    param.setAttribute("value",newIPATable.getAttrValue("ramanLosTH")*10);
	    row.appendChild(param);
	       
	    param = new tagElement("param");
	    param.setAttribute("name","ramanAlarmTH");
	    param.setAttribute("value",newIPATable.getAttrValue("ramanAlarmTH")*10);
	    row.appendChild(param);
	
	    param = new tagElement("param");
	    param.setAttribute("name","ramanAlarmEnable");
	    param.setAttribute("value",newIPATable.getAttrValue("ramanAlarmEnable"));
	    row.appendChild(param);
    }
    param = new tagElement("param");
    param.setAttribute("name","addDetectBoard");
    param.setAttribute("value",getAddDetectBoardString());
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","addDetectBoardStr");
    param.setAttribute("value",getAddDetectBoardShowString());
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","delDetectBoard");
    param.setAttribute("value",getDelDetectBoardString());
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","delDetectBoardStr");
    param.setAttribute("value",getDelDetectBoardShowString());
    row.appendChild(param);

    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *     IPA      
 * @param  
 * @return  
 */
function callbackAddIPA(doc)
{
	var data = EncapsulateData(doc);
	
	var errCode = data.getSErrorCode();
	
	if(0 == errCode || 1 == errCode)
	{
		
		
		win.doQuery();	
	}	
	
	win.showErrorPage(data);
	
	$("okbtn").disabled = false;
	$("applybtn").disabled = false;
	
	var alarmPort;
	
	var ctlPort;
	
	var ramonBoard;

	if(0 == errCode || 1 == errCode)
	{
		alarmPort = newIPATable.getAttrValue("alarmPort");
		
		ctlPort = newIPATable.getAttrValue("ctlPort");
		
		ramonBoard = newIPATable.getAttrValue("ramonBoard");
		
		win.availableWPGID.remove(newIPATable.getAttrValue("ipaID"));
		
		if(0 != newIPATable.getAttrValue("alarmPort"))
		{
			for(var i = 0, len = win.availableAlmPort.length; i < len; i++)
			{
				if(win.availableAlmPort[i].toString() == alarmPort)
				{
					win.availableAlmPort.removeAt(i);
					break;
				}
			}
			if(0 != alarmPort.slotid)
			{
				win.almPort.push(alarmPort);	
			}		
		}

		for(var i = 0, len = win.availableCntlPort.length; i < len; i++)
		{			
			if(win.availableCntlPort[i].toString() == ctlPort)
			{
				win.availableCntlPort.removeAt(i);
				break;
			}			
		}
		win.cntlPort.push(ctlPort);		
		
		if(0 != newIPATable.getAttrValue("ramonBoard"))
		{
			for(var i = 0, len = win.availableRamonBoard.length; i < len; i++)
			{
				if(win.availableRamonBoard[i].toString() == ramonBoard)
				{
					win.availableRamonBoard.removeAt(i);
					break;
				}				
			}
			if(0 != ramonBoard.neid)
			{
				win.ramonBoard.push(ramonBoard);	
			}	
		}	
	    if(isApply)
	    {
	    	initTableData();
	    }
	}

	if(!isApply && (0 == errCode || 1 == errCode))
	{
		self.close();
		return;
	}				
}

/**
 *     IPA   XML  
 * @param  
 * @return  
 */
function createAddIPAXMLInfo()
{
	newIPAObj = new IPAObject();

	var di = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = null;
    
    param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",win.winobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","ipaID");
    param.setAttribute("value",newIPATable.getAttrValue("ipaID"));
    row.appendChild(param);
    
    newIPAObj.ipaID = newIPATable.getAttrValue("ipaID");
    
    param = new tagElement("param");
    param.setAttribute("name","band");
    param.setAttribute("value",newIPATable.getAttrValue("band"));
    row.appendChild(param);    
    newIPAObj.band = newIPATable.getAttrValue("band");
    
    var almBoard = newIPATable.getAttrValue("alarmPort").split("-");
    
    param = new tagElement("param");
    param.setAttribute("name","alarmSlotid");
    param.setAttribute("value",almBoard[0]);
    row.appendChild(param);    
    newIPAObj.alarmPort.shelfname = getShelfName(win.availableAlmPort, win.winobj["neid"], almBoard[0]);
    newIPAObj.alarmPort.slotid = almBoard[0];
    
    if(0 == almBoard[0])
    {
    	newIPAObj.alarmPort.boardname = "";
    }
    else
    {
    	newIPAObj.alarmPort.boardname = almBoard[1];
    }
    
    param = new tagElement("param");
    param.setAttribute("name","alarmPort");
    param.setAttribute("value",almBoard[2].substring(0,almBoard[2].indexOf("(")));
    row.appendChild(param);
    
    newIPAObj.alarmPort.port = almBoard[2].substring(0,almBoard[2].indexOf("("));
    if(0 == newIPAObj.alarmPort.port)
    {
    	newIPAObj.alarmPort.portname = "";
    }
    else
    {
    	newIPAObj.alarmPort.portname = almBoard[2];
    }
    
    var ctlBoard = newIPATable.getAttrValue("ctlPort").split("-");
    param = new tagElement("param");
    param.setAttribute("name","ctlSlotid");
    param.setAttribute("value",ctlBoard[0]);
    row.appendChild(param);
    
	newIPAObj.ctlPort.shelfname = getShelfName(win.availableCntlPort, win.winobj["neid"], ctlBoard[0]);
    newIPAObj.ctlPort.slotid = ctlBoard[0];
    newIPAObj.ctlPort.boardname = ctlBoard[1];
    
    param = new tagElement("param");
    param.setAttribute("name","ctlPort");
    param.setAttribute("value",ctlBoard[2].substring(0,ctlBoard[2].indexOf("(")));
    row.appendChild(param);
    
    newIPAObj.ctlPort.port = ctlBoard[2].substring(0,ctlBoard[2].indexOf("("));
    newIPAObj.ctlPort.portname = ctlBoard[2];
    
    var ramonBoard = newIPATable.getAttrValue("ramonBoard").split("-");
    
    param = new tagElement("param");
    param.setAttribute("name","ramonNeid");
    param.setAttribute("value",ramonBoard[0]);
    row.appendChild(param);
    
    newIPAObj.ramonBoard.neid = ramonBoard[0];
    newIPAObj.ramonBoard.nename = getNEName(win.availableRamonBoard, newIPAObj.ramonBoard.neid);
    
    param = new tagElement("param");
    param.setAttribute("name","ramonSlotid");
    param.setAttribute("value",ramonBoard[ramonBoard.length - 2]); 
    row.appendChild(param);
    
    newIPAObj.ramonBoard.slotid = ramonBoard[ramonBoard.length - 2];
	newIPAObj.ramonBoard.shelfname = getShelfName(win.availableRamonBoard, newIPAObj.ramonBoard.neid, newIPAObj.ramonBoard.slotid);
    if(0 == newIPAObj.ramonBoard.slotid)
    {
     	newIPAObj.ramonBoard.boardname = "";
    }
    else
    {
    	newIPAObj.ramonBoard.boardname = ramonBoard[ramonBoard.length - 1];
    }
    
    param = new tagElement("param");
    param.setAttribute("name","ipaEnable");
    param.setAttribute("value",newIPATable.getAttrValue("ipaEnable"));
    row.appendChild(param); 
    newIPAObj.ipaEnable = newIPATable.getAttrValue("ipaEnable");
    if(newIPAObj.ipaEnable == 0)
    {
        if(!confirm(RESOURCE["IPA_ENABLE_FLAG_DISABLE"]))
        {
            return null;
        }
    }
    
    param = new tagElement("param");
    param.setAttribute("name","reBootType");
    param.setAttribute("value",newIPATable.getAttrValue("reBootType"));
    row.appendChild(param);
    newIPAObj.reBootType = newIPATable.getAttrValue("reBootType");
    
    param = new tagElement("param");
    param.setAttribute("name","offTimes");
    param.setAttribute("value",newIPATable.getAttrValue("offTimes"));
    row.appendChild(param);
    newIPAObj.offTimes = newIPATable.getAttrValue("offTimes");
    
    param = new tagElement("param");
    param.setAttribute("name","onTimes");
    param.setAttribute("value",newIPATable.getAttrValue("onTimes"));
    row.appendChild(param);
    newIPAObj.onTimes = newIPATable.getAttrValue("onTimes");
    
    param = new tagElement("param");
    param.setAttribute("name","testTimes");
    param.setAttribute("value",newIPATable.getAttrValue("testTimes"));
    row.appendChild(param);
    newIPAObj.testTimes = newIPATable.getAttrValue("testTimes");
    
    param = new tagElement("param");
    param.setAttribute("name","testTimes");
    param.setAttribute("value",newIPATable.getAttrValue("testTimes"));
    row.appendChild(param);
    newIPAObj.testTimes = newIPATable.getAttrValue("testTimes");
    
    param = new tagElement("param");
    param.setAttribute("name","reBootEnable");
    param.setAttribute("value","1");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","securityEnable");
    param.setAttribute("value",newIPATable.getAttrValue("securityEnable"));
    row.appendChild(param);
    newIPAObj.securityEnable = newIPATable.getAttrValue("securityEnable");
    if(newIPAObj.securityEnable == 0)
    {
        if(!confirm(RESOURCE["SECURITY_CONTROL_DISABLE"]))
        {
            return null;
        }
    }

    if(0 != newIPAObj.ramonBoard.slotid)
    {
	    param = new tagElement("param");
	    param.setAttribute("name","ramanLosTH");
	    param.setAttribute("value",newIPATable.getAttrValue("ramanLosTH")*10);
	    row.appendChild(param);
	    newIPAObj.ramanLosTH = newIPATable.getAttrValue("ramanLosTH");
	       
	    param = new tagElement("param");
	    param.setAttribute("name","ramanAlarmTH");
	    param.setAttribute("value",newIPATable.getAttrValue("ramanAlarmTH")*10);
	    row.appendChild(param);
	    newIPAObj.ramanAlarmTH = newIPATable.getAttrValue("ramanAlarmTH");
	
	    param = new tagElement("param");
	    param.setAttribute("name","ramanAlarmEnable");
	    param.setAttribute("value",newIPATable.getAttrValue("ramanAlarmEnable"));
	    row.appendChild(param);
	    newIPAObj.ramanAlarmEnable = newIPATable.getAttrValue("ramanAlarmEnable");
    }
    param = new tagElement("param");
    param.setAttribute("name","addDetectBoard");
    param.setAttribute("value",getAddDetectBoardString());
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","addDetectBoardStr");
    param.setAttribute("value",getAddDetectBoardShowString());
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","delDetectBoard");
    param.setAttribute("value",getDelDetectBoardString());
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","delDetectBoardStr");
    param.setAttribute("value",getDelDetectBoardShowString());
    row.appendChild(param);

    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function getNEName(arr, neid)
{
	for (var i = 0, m = arr.length; i < m; i++)
	{
		if (arr[i].neid == neid)
		{
			return arr[i].nename;
		}
	}
	return "";
}

function getShelfName(arr, neid, slotId)
{
	for (var i = 0, m = arr.length; i < m; i++)
	{
		if (arr[i].neid == neid && arr[i].slotid == slotId)
		{
			return arr[i].shelfname;
		}
	}
	return "";
}

/**
 *       IPA      
 * @param  
 * @return  
 */
function checkData()
{
	if("" == newIPATable.getAttrValue("ctlPort"))
	{
		alert(RESOURCE["ID_NOEMPTYBRD"]);
		return false;
	}
	
	var alarmBoard = newIPATable.getAttrValue("alarmPort").split("-")[0];
	
	var ctlBoard = newIPATable.getAttrValue("ctlPort").split("-")[0];
	
	if(alarmBoard == ctlBoard)
	{
		alert(RESOURCE["ID_ALMBORDDIFFCNTRLBORD"]);
		return false;
	}
	return true;
}

/**
 *   common.js               
 * @param res:     obj     /   key:     
 * @return String      
 */
function convertMsg(res,obj,key)
{
	if("function" == (typeof obj))	
	{
		return obj(key);
	}
	else //       
	{
		if(null == obj)
		{
			return key;
		}
		var resValue = obj[key];
		if(null == resValue)
		{
			resValue = key;
		}		
		return resValue;
	}
}

/**
 * IPA  
 * @param  
 * @return  
 */
function IPAObject()
{
	this.ipaID = 0;
	this.band = 1;
	this.alarmPort = new Object();
	this.ctlPort = new Object();
	this.ramonBoard = new Object();
	this.ipaEnable = 0;
	this.reBootType = 0;
	this.offTimes = 0;
	this.onTimes = 0;
	this.testTimes = 0;
	this.securityEnable = 0;
	this.ramanLosTH = "-";
	this.ramanAlarmTH = "-";
	this.ramanAlarmEnable = "-";
}

/**
 * IPA     toString  
 * @param  
 * @return String :IPA     String  
 */
IPAObject.prototype.convertToDatainteface = function()
{
	var data = new DataInterface();
	var row = new Object();

	var ptag = new ParamTag();
	ptag.value = this.ipaID;
	row["ipaID"] = ptag;
	
	ptag = new ParamTag();
	ptag.value = this.band;
	row["band"] = ptag;
		
	ptag = new ParamTag();
	ptag.value = this.alarmPort.shelfname;
	row["alarmShelfName"] = ptag;
	
	ptag = new ParamTag();
	ptag.value = this.alarmPort.slotid;
	row["alarmSlotid"] = ptag;
	
	ptag = new ParamTag();
	ptag.value = this.alarmPort.boardname;
	row["alarmBoardName"] = ptag;
	
	ptag = new ParamTag();
	ptag.value = this.alarmPort.port;
	row["alarmPort"] = ptag;
	
	ptag = new ParamTag();
	ptag.value = this.alarmPort.portname;
	row["alarmPortName"] = ptag;
	
	ptag = new ParamTag();
	ptag.value = this.ctlPort.shelfname;
	row["ctlShelfName"] = ptag;
	
	ptag = new ParamTag();
	ptag.value = this.ctlPort.slotid;
	row["ctlSlotid"] = ptag;
	
	ptag = new ParamTag();
	ptag.value = this.ctlPort.boardname;
	row["ctlBoardName"] = ptag;
	
	ptag = new ParamTag();
	ptag.value = this.ctlPort.port;
	row["ctlPort"] = ptag;
	
	ptag = new ParamTag();
	ptag.value = this.ctlPort.portname;
	row["ctlPortName"] = ptag;
	
	ptag = new ParamTag();
	ptag.value = this.ramonBoard.neid;
	row["ramonNeid"] = ptag;
	
	ptag = new ParamTag();
	ptag.value = this.ramonBoard.nename;
	row["ramonNeName"] = ptag;
	
	ptag = new ParamTag();
	ptag.value = this.ramonBoard.shelfname;
	row["ramonShelfName"] = ptag;
	
	ptag = new ParamTag();
	ptag.value = this.ramonBoard.slotid;
	row["ramonSlotid"] = ptag;
	
	ptag = new ParamTag();
	ptag.value = this.ramonBoard.boardname;
	row["ramonBoardName"] = ptag;
	
	ptag = new ParamTag();
	ptag.value = this.ipaEnable;
	row["ipaEnable"] = ptag;
	
	ptag = new ParamTag();
	ptag.value = this.reBootType;
	row["reBootType"] = ptag;
	
	ptag = new ParamTag();
	ptag.value = this.offTimes;
	row["offTimes"] = ptag;
	
	ptag = new ParamTag();
	ptag.value = this.onTimes;
	row["onTimes"] = ptag;
	
	ptag = new ParamTag();
	ptag.value = this.testTimes;
	row["testTimes"] = ptag;
	
	ptag = new ParamTag();
	ptag.value = this.securityEnable;
	row["securityEnable"] = ptag;
	
	ptag = new ParamTag();
	ptag.value = 1;
	row["reBootEnable"] = ptag;
	
	ptag = new ParamTag();
	ptag.value = "-1";
	row["ipaStatus"] = ptag;
	
	ptag = new ParamTag();
	ptag.value = this.ramanLosTH;
	row["ramanLosTH"] = ptag;

	ptag = new ParamTag();
	ptag.value = this.ramanAlarmTH;
	row["ramanAlarmTH"] = ptag;

	ptag = new ParamTag();
	ptag.value = this.ramanAlarmEnable;
	row["ramanAlarmEnable"] = ptag;
	
	data.rows[data.rows.length] = row;
	return data;
}

function setDetectboardHandler(selectedBoardText,selectedBoard)
{
	var text = selectedBoardText.join(",");
	var value = selectedBoard.join(",");
	newIPATable.getAtom("auxDectectBoard").setValue(text);
	newIPATable.getAtom("auxDectectBoard").element.setAttribute("title",text);
	selectedAssisBoard.clear();

	for(var i = 0;i < selectedBoard.length;i++)
	{
		selectedAssisBoard.append(new DetectBoard(selectedBoardText[i],selectedBoard[i]));
	}
	selectedBoardText = null;
	selectedBoard = null;
}

function DetectBoard(text,value)
{
	this.text = text;
	this.value = value;
}
DetectBoard.prototype.toString = function()
{
	return this.value;
}
DetectBoard.prototype.toShowString = function()
{
	return this.text;
}

function getDelDetectBoardString()
{
	var result = "";
    for (var i = 0, len = modifySelectedAssisBoard.length; i < len; i++) 
    {
        if (!selectedAssisBoard.contains(modifySelectedAssisBoard[i])) 
        {
        	result += modifySelectedAssisBoard[i].toString() + ",";
        }
    }
    return result;
}

function getDelDetectBoardShowString()
{
	var result = "";
    for (var i = 0, len = modifySelectedAssisBoard.length; i < len; i++) 
    {
        if (!selectedAssisBoard.contains(modifySelectedAssisBoard[i])) 
        {
        	result += modifySelectedAssisBoard[i].toShowString() + ",";
        }
    }
    return result;
}

function getAddDetectBoardString()
{
	var result = "";
    for (var i = 0, len = selectedAssisBoard.length; i < len; i++) 
    {
        if (!modifySelectedAssisBoard.contains(selectedAssisBoard[i])) 
        {
            result += selectedAssisBoard[i].toString() + ",";
        }
    }
    return result;
}

function getAddDetectBoardShowString()
{
	var result = "";
    for (var i = 0, len = selectedAssisBoard.length; i < len; i++) 
    {
        if (!modifySelectedAssisBoard.contains(selectedAssisBoard[i])) 
        {
            result += selectedAssisBoard[i].toShowString() + ",";
        }
    }
    return result;
}
