var atable = new CTable();


var win = getParentWindow();
var neID = win.neID;
var nmUser = win.nmUser;
var nePro = getNeProperty(win.top);


var neName = win.neName;
var OPRSUCC = 0;
var PARTOPRSUCC = 1;

var SERVICE_TYPE_CUSTOM = "33791";
var SERVICE_TYPE_PACKET = "33777";

var SERVERRATE = [];
SERVERRATE[1] = 1249245570;
SERVERRATE[2] = 2498491139;
SERVERRATE[3] = 3747736709;
SERVERRATE[4] = 4996982278;
SERVERRATE[5] = 6246227848;
SERVERRATE[6] = 7495473418;
SERVERRATE[7] = 8744718987;
SERVERRATE[8] = 9993964557;

var SERVERTIMESLOT = [];
SERVERTIMESLOT["33791"] = 8; //custom
SERVERTIMESLOT["33777"] = 1; //packet
SERVERTIMESLOT["33553"] = 4; //fc400
SERVERTIMESLOT["33623"] = 7; //fc800
SERVERTIMESLOT["35003"] = 3;//3gsdi
SERVERTIMESLOT["35005"] = 3;//3gsdirbr
SERVERTIMESLOT["33729"] = 3; //InfiniBand 2.5G
SERVERTIMESLOT["33730"] = 5; //InfiniBand 5G
SERVERTIMESLOT["33564"] = 4; //FICON4G
SERVERTIMESLOT["33636"] = 7; //FICON8G

var sevTypeODURate = [];
sevTypeODURate[33791] = 9993964557; //custom
sevTypeODURate[33777] = 1249245570; //packet
sevTypeODURate[33553] = 4267857143; //fc400
sevTypeODURate[33623] = 8535714286; //fc800
sevTypeODURate[35003] = 2982478992;//3gsdi
sevTypeODURate[35005] = 2979499525;//3gsdirbr
sevTypeODURate[33729] = 2510504202; //InfiniBand 2.5G
sevTypeODURate[33730] = 5021008403; //InfiniBand 5G
sevTypeODURate[33564] = 4267857143; //FICON4G
sevTypeODURate[33564] = 8535714286; //FICON8G



function initOduFlexSevType(serviceTypeAtom)
{
		serviceTypeAtom.clearOptions();
		serviceTypeAtom.addOption("Custom", "33791");
		serviceTypeAtom.addOption("PACKET", "33777");
    serviceTypeAtom.addOption("FC400", "33553");
    serviceTypeAtom.addOption("FC800", "33623");
    serviceTypeAtom.addOption("3GSDI", "35003");
    serviceTypeAtom.addOption("3GSDIRBR", "35005");
    serviceTypeAtom.addOption("InfiniBand 2.5G", "33729");
    serviceTypeAtom.addOption("InfiniBand 5G", "33730");
    serviceTypeAtom.addOption("FICON4G", "33564");
    serviceTypeAtom.addOption("FICON8G", "33636");
}

function initAttrTable()
{
    var selectedRows = win.st.getSelectedRows();
    var rowindex = selectedRows[0];
    var src = win.st.getCellShow(rowindex,"srcPort").getValue();
    var snk = win.st.getCellShow(rowindex,"snkPort").getValue();
    var direction = win.st.getCellStoreValue(0, "direction", "direction");
    
    atable.addHead(RESOURCE["attri"], RESOURCE["value"]);
   
    
    atom = new Atom("select");
    initOduFlexSevType(atom);
    atom.element.style.width="100%";
    atom.element["onchange"] = function()
    {
	    changeType(this);
    }
    atable.addAttrRow("serviceType",RESOURCE["wdmServiceType"], atom);
    
    
    
    atom = new Atom("text");
    atom.element.style.width="100%";
    atable.addAttrRow("oduFlexTimeSlots",RESOURCE["oduFlexTimeSlots"], atom);
    atom.element["onchange"] = function()
    {
	    changeTimeslot();
    }
    
    atom = new Atom("text");
    atom.element.style.width="100%";
    atable.addAttrRow("oduflexRateSlot",RESOURCE["oduflexRateSlot"], atom);
  
    


    $("attrTableContainer").appendChild(atable.getTable());
    
    changeType(atable.getAtom("serviceType").element);
}


function initAttrValue()
{
			var st = win.st;
			var selectedRows = st.getSelectedRows();
			var rowindex = selectedRows[0];
			var serviceType = st.getCellStoreValue(rowindex, "serviceType", "serviceType");
    	var oduFlexTimeSlots = st.getCellStoreValue(rowindex, "oduFlexTimeSlots", "oduFlexTimeSlots");
    	var oduflexRateSlot = st.getCellStoreValue(rowindex, "oduflexRateSlot", "oduflexRateSlot");

    	if(serviceType != null)
    	{
    		atable.getAtom("serviceType").element.value = serviceType;
    	}
    	else
    	{
    		atable.setAttrValue("oduFlexTimeSlots",SERVERTIMESLOT[SERVICE_TYPE_CUSTOM]);
    	}

    	if(oduFlexTimeSlots != null)
    	{
    		atable.getAtom("oduFlexTimeSlots").element.value = oduFlexTimeSlots;
    	}

    	
}


function init()
{
	initAttrTable();
	
	
	initAttrValue();


}


    
function okBtnClicked(element)
{
	  var serviceType = atable.getAtom("serviceType").element.value;
	  var oduFlexTimeSlots = atable.getAtom("oduFlexTimeSlots").element.value;
	  var oduflexRateSlot = atable.getAtom("oduflexRateSlot").element.value;


	 var st = win.st;
	 var selectedRows = st.getSelectedRows();

   	for(var i = 0;i < selectedRows.length;i++)
    	{
    		var rowindex = selectedRows[i];
    		
    		st.setCellValue(st.getCell(rowindex,"serviceType"),"serviceType",serviceType);
    		st.setCellValue(st.getCell(rowindex,"oduFlexTimeSlots"),"oduFlexTimeSlots",oduFlexTimeSlots);
    		st.setCellValue(st.getCell(rowindex,"oduflexRateSlot"),"oduflexRateSlot",oduflexRateSlot);
    	}	
    	xcloseDialog();	

}
    
  
function cancelBtnClicked()
{
	  xcloseDialog();
}



function changeTimeslot()
{
	var ts = atable.getAtom("oduFlexTimeSlots").element.value;
	atable.setAttrValue("oduflexRateSlot",SERVERRATE[ts]);
}



/**
 *      
 */
function changeType(seleValue)
{
	  var seleLevel = seleValue.value;
	

	  if ( SERVERTIMESLOT[seleLevel])
		{
				atable.setAttrValue("oduFlexTimeSlots",SERVERTIMESLOT[seleLevel]);

		    changeTimeslot();

		    if(seleLevel != SERVICE_TYPE_CUSTOM)
		    {
		    	if (seleLevel == SERVICE_TYPE_PACKET)
		    	{
		    		atable.getAtom("oduFlexTimeSlots").element.disabled = false;
		    	}
		    	else
		    	{
		    		atable.getAtom("oduFlexTimeSlots").element.disabled = true;
		    	}
		    	atable.getAtom("oduflexRateSlot").element.disabled = true;
		    }
		    else
		    {
		    	atable.getAtom("oduFlexTimeSlots").element.disabled = false;
		    	atable.getAtom("oduflexRateSlot").element.disabled = false;
		    }

		    atable.getAtom("oduflexRateSlot").element.value = sevTypeODURate[atable.getAtom("serviceType").element.value];
		}		

}









