function main()
{
	
	
	st = new SortTable();
	st.setImage("../../../../images/");
	st.isUsedForSelectList = true;
	st.setOnRowSelectHandler(rowSelectHandler);
	createTableHead(st, window.tableconf[0]);
	document.getElementById("xctable").appendChild(st.getTable());
	
	var rowData = getDefaultData();	
	createXCTableBody(st, window.tableconf[0], rowData, RESOURCE);
	addTableLister();
	st.clearTableData();	
	st.setBodyHeight("100px");
	
	initBtn();

	if(!btnRightArr.querybtn.right)
	{
		return;
	}
	
	graph= new Graph();
	graph.init();
	initResouces();
	graph.drawInnerCircle();
	graph.drawDirections();
	graph.drawArrow();
			
	
	

}

function queryXC(portshape)
{
	var xml = createQueryXCXML(portshape);
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_WDM_GET_GRAPHEXC;
        loadXMLdoc(url, "POST", false, queryXCCallBack, portshape, "inputdata=" + xml);
}

function createQueryXCXML(portshape)
{
    var root = new inputxml("datainterface");
    var firstlevel = new tagElement("bussiness-params");
    var secondlevel = new tagElement("row-params");
    
    addTagElement(secondlevel, "neid", winurlobj["neid"]);
    addTagElement(secondlevel, "slotid", portshape.slotId);
    addTagElement(secondlevel, "portid", portshape.portId);
    
    
    firstlevel.appendChild(secondlevel);    
    root.getRoot().appendChild(firstlevel);
    return root.toString();
}

function queryXCCallBack(doc,portshape)
{
    var data = EncapsulateData(doc);

    if (data.getSErrorCode() == 0 ) 
    {
    	portshape.xcList=[];
    	portshape.workxcList=[];
    	portshape.protectxcList=[];
    	portshape.clearAllOccupyStatus();
    	for ( var i=0, iLength = data.getDataRowLength(); i<iLength; i++)
    	{
    		var srcSlot = data.getDataRowParam(i, "srcSlot");
    		var showSrcSlot = data.getDataRowParam(i, "showSrcSlot");
    		var srcBoardName = data.getDataRowParam(i, "srcBoardName");
    		var srcPort = data.getDataRowParam(i, "srcPort");
    		var showSrcPort = data.getDataRowParam(i, "showSrcPort");
    		var srcPath = data.getDataRowParam(i, "srcPath");
    		var snkSlot = data.getDataRowParam(i, "snkSlot");
    		var snkBoardName = data.getDataRowParam(i, "snkBoardName");
    		var showSnkSlot = data.getDataRowParam(i, "showSnkSlot");
    		var snkPort = data.getDataRowParam(i, "snkPort");
    		var showSnkPort = data.getDataRowParam(i, "showSnkPort");
    		var snkPath = data.getDataRowParam(i, "snkPath");
    		
    		var svcType = data.getDataRowParam(i, "svcType");
    		var activeState = data.getDataRowParam(i, "activeState");
    		var otnLevel = data.getDataRowParam(i, "otnLevel");
    		var serviceLevel = data.getDataRowParam(i, "serviceLevel");
    		var xcid = data.getDataRowParam(i, "xcid");
    		var xcType = data.getDataRowParam(i, "xcType");
    		var pgid = data.getDataRowParam(i, "pgid");
    		var sncpType = data.getDataRowParam(i, "sncpType");
    		var revertiveMode = data.getDataRowParam(i, "revertiveMode");
    		var wtrTime = data.getDataRowParam(i, "wtrTime");
    		var sdTriggerFlag = data.getDataRowParam(i, "sdTriggerFlag");
    		var delayTime = data.getDataRowParam(i, "delayTime");
    		var protectType = data.getDataRowParam(i, "protectType");
    		
    		var oduFlexTimeSlots = data.getDataRowParam(i, "oduFlexTimeSlots");
    		var oduflexRateSlot = data.getDataRowParam(i, "oduflexRateSlot");
    		

    		var xc = new SingleXC(xcid,srcSlot,srcPort,srcPath,snkSlot,snkPort,snkPath);
    		xc.showSrcSlot = showSrcSlot;
    		xc.showSrcPort = showSrcPort;
    		xc.showSnkSlot = showSnkSlot;
    		xc.showSnkPort = showSnkPort;
    		xc.activeState = activeState;
    		xc.otnLevel = otnLevel;
    		xc.serviceLevel = serviceLevel;
    		xc.svcType = svcType;
    		xc.srcBoardName = srcBoardName;
    		xc.snkBoardName = snkBoardName;
    		xc.xcType = xcType;
    		xc.pgid = pgid;
    		xc.sncpType = sncpType;
    		xc.revertiveMode = revertiveMode;
				xc.wtrTime = wtrTime;
				xc.sdTriggerFlag = sdTriggerFlag;
				xc.delayTime = delayTime;
				xc.protectType = protectType;
				xc.oduFlexTimeSlots = oduFlexTimeSlots;
				xc.oduflexRateSlot = oduflexRateSlot;
		
		if(xcType == XC_TYPE_WORK)
		{
    			portshape.workxcList.push(xc);
    		}
    		else if(xcType == XC_TYPE_PROTECT)
		{
    			portshape.protectxcList.push(xc);
    		}
    		else
		{
    			portshape.xcList.push(xc);
    		}
    		
    		if(portshape.portId == 0)//    
    		{
    			setBranchTsUsed(portshape);
    		}
    		else
    		{
    			var srcTs = data.getDataRowParam(i, "srcTs");
    			var snkTs = data.getDataRowParam(i, "snkTs");
    			xc.srcTs = srcTs;
    			xc.snkTs = snkTs;
    			if(portshape.tsmode == TSMODE_CONSECUTIVE)
    			{
    				setConsecutiveTsUsed(portshape,xc);    				
    			}	
    		}
    		
    	}
    	
    	if(portshape.portId != 0 && portshape.tsmode == TSMODE_RANDOM)
    	{
    		setRandomTsUsed(portshape);
    	}
    }
    	

}




function initResouces()
{
	var xml = createQueryResXML();
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_WDM_QUERY_GRAPHEXC;
        loadXMLdoc(url, "POST", false, initResoucesCallBack, null, "inputdata=" + xml);
}





function setRandomProtectTsUsed(portShape,xcList)
{
	for(var i=0,iLength=xcList.length;i<iLength;i++)
	{
		var xc = xcList[i];		
		
		if(portShape.slotId != xc.srcSlot ||  portShape.portId != xc.srcPort)
		{
			continue;
		}
		
		if(SERVICE_ODUFLEX != xc.serviceLevel)
		{
			var oduList = portShape.getOduListByLevel(xc.serviceLevel);
			
			for(var j = 0,jLength = oduList.length;j<jLength;j++)	
			{
				var oduTs = oduList[j];
				if(oduTs.path == xc.srcPath)
				{
					oduTs.occupy =1;
					oduTs.srcOccupyPath = oduTs.path;
					
					var odu0Count = 0;
					
					for(var k = 0,kLength = portShape.selectTs.length;k<kLength&&odu0Count < EQU_OBJ[xc.serviceLevel];k++)
					{
						var odu0Ts = portShape.selectTs[k];
						if((odu0Ts.snkOccupyPath == 0 && odu0Ts.srcOccupyPath == 0 ) || (odu0Ts.snkOccupyPath == xc.srcPath))
						{
							odu0Ts.occupy =1;
							odu0Count++;
							odu0Ts.srcOccupyPath = xc.srcPath;
							
						}
					}	
					
					if(odu0Count == EQU_OBJ[xc.serviceLevel])	
					{
						continue;
					}			
					
					for(var k = 0,kLength = portShape.timeSlotList.length;k<kLength&&odu0Count < EQU_OBJ[xc.serviceLevel];k++)
					{
						var odu0Ts = portShape.timeSlotList[k];
						if((odu0Ts.snkOccupyPath == 0 && odu0Ts.srcOccupyPath == 0 ) || (odu0Ts.snkOccupyPath == xc.srcPath))
						{
							odu0Ts.occupy =1;
							odu0Count++;
							odu0Ts.srcOccupyPath = xc.srcPath;
							
						}
					}								
					
				}
			}
		}
		
	
		if(SERVICE_ODUFLEX == xc.serviceLevel)
		{
			
			for(var j = 0,jLength = portShape.oduflexList.length;j<jLength;j++)	
			{
				var oduflexTs = portShape.oduflexList[j];
				if(oduflexTs.tsName == xc.srcTs)
				{
					oduflexTs.occupy =1;
					oduflexTs.srcOccupyPath = oduflexTs.path;	
					var odu0Count = 0;
					
					for(var k = 0,kLength = portShape.selectTs.length;k<kLength&&odu0Count < xc.oduFlexTimeSlots;k++)
					{
						var odu0Ts = portShape.selectTs[k];
						if(odu0Ts.snkOccupyPath == 0 && odu0Ts.srcOccupyPath == 0)
						{
							odu0Ts.occupy =1;
							odu0Count++;
							odu0Ts.srcOccupyPath = xc.srcPath;
							
						}
					}

					for(var k = 0,kLength = portShape.timeSlotList.length;k<kLength&&odu0Count < xc.oduFlexTimeSlots;k++)
					{
													
						var odu0Ts = portShape.timeSlotList[k];
						if(odu0Ts.snkOccupyPath == 0 && odu0Ts.srcOccupyPath == 0)
						{
							odu0Ts.occupy =1;
							odu0Ts.srcOccupyPath = xc.srcPath;
							odu0Count++;
						}
						
					}								
					
				}
			}
		}
		
	}
}


function setRandomSnkTsUsed(portShape,xcList)
{
	for(var i=0,iLength=xcList.length;i<iLength;i++)
	{
		var xc = xcList[i];		
		
		if(portShape.slotId != xc.snkSlot ||  portShape.portId != xc.snkPort)
		{
			continue;
		}
		
		if(SERVICE_ODUFLEX != xc.serviceLevel)
		{
			var oduList = portShape.getOduListByLevel(xc.serviceLevel);
			
			for(var j = 0,jLength = oduList.length;j<jLength;j++)	
			{
				var oduTs = oduList[j];
				if(oduTs.tsName == xc.snkTs)
				{
					oduTs.occupy =1;
					oduTs.snkOccupyPath = oduTs.path;

					
					var odu0Count = 0;
					for(var k = 0,kLength = portShape.selectTs.length;k<kLength&&odu0Count < EQU_OBJ[xc.serviceLevel];k++)
					{
						var odu0Ts = portShape.selectTs[k];
						if(odu0Ts.snkOccupyPath == 0 && odu0Ts.srcOccupyPath == 0)
						{
							odu0Ts.occupy =1;
							odu0Count++;
							odu0Ts.snkOccupyPath = xc.snkPath;
							
						}
					}
					
					if(odu0Count == EQU_OBJ[xc.serviceLevel])
					{
						continue;
					}
					
					for(var k = 0,kLength = portShape.timeSlotList.length;k<kLength&&odu0Count < EQU_OBJ[xc.serviceLevel];k++)
					{
						var odu0Ts = portShape.timeSlotList[k];
						if(odu0Ts.snkOccupyPath == 0 && odu0Ts.srcOccupyPath == 0)
						{
							odu0Ts.occupy =1;
							odu0Count++;
							odu0Ts.snkOccupyPath = xc.snkPath;
							
						}
					}
				}
			}								
					
				
			
		}
		
		
		if(SERVICE_ODUFLEX == xc.serviceLevel)
		{
			
			for(var j = 0,jLength = portShape.oduflexList.length;j<jLength;j++)	
			{
				var oduflexTs = portShape.oduflexList[j];
				if(oduflexTs.tsName == xc.snkTs)
				{
					oduflexTs.occupy =1;
					oduflexTs.snkOccupyPath = oduflexTs.path;	
					
					var odu0Count = 0;
					
					for(var k = 0,kLength = portShape.selectTs.length;k<kLength&&odu0Count < xc.oduFlexTimeSlots;k++)
					{
						var odu0Ts = portShape.selectTs[k];
						if(odu0Ts.snkOccupyPath == 0 && odu0Ts.srcOccupyPath == 0)
						{
							odu0Ts.occupy =1;
							odu0Count++;
							odu0Ts.snkOccupyPath = xc.snkPath;
							
						}
					}

					for(var k = 0,kLength = portShape.timeSlotList.length;k<kLength&&odu0Count < xc.oduFlexTimeSlots;k++)
					{
						var odu0Ts = portShape.timeSlotList[k];
						if(odu0Ts.snkOccupyPath == 0 && odu0Ts.srcOccupyPath == 0)
						{
							odu0Ts.occupy =1;
							odu0Ts.snkOccupyPath = xc.snkPath;
							odu0Count++;
						}
					}								
					
				}
			}
		}
		
	}
}



function setRandomSrcTsUsed(portShape,xcList)
{
	
	for(var i=0,iLength=xcList.length;i<iLength;i++)
	{
		var xc = xcList[i];
		
		
		if(portShape.slotId != xc.srcSlot ||  portShape.portId != xc.srcPort)
		{
			continue;
		}
		
	
		var isContinue = false;
		for(var k = 0,kLength = portShape.timeSlotList.length;k<kLength;k++)
		{
			var odu0Ts = portShape.timeSlotList[k];
			if(odu0Ts.snkOccupyPath == xc.srcPath || odu0Ts.srcOccupyPath == xc.srcPath)
			{
				isContinue = true;
				break;
			}
		}		
		if(isContinue)
		{
			continue;
		}												
		
		if(SERVICE_ODUFLEX != xc.serviceLevel)
		{				
			var odu0Count = 0;
			for(var k = 0,kLength = portShape.selectTs.length;k<kLength&&odu0Count < EQU_OBJ[xc.serviceLevel];k++)
			{
				var odu0Ts = portShape.selectTs[k];
				if(odu0Ts.snkOccupyPath == 0 && odu0Ts.srcOccupyPath == 0)
				{
					odu0Ts.occupy =1;
					odu0Count++;
					odu0Ts.srcOccupyPath = xc.srcPath;
							
				}
			}
			
			if(odu0Count == EQU_OBJ[xc.serviceLevel])
			{
				continue;
			}
			
			
			for(var k = 0,kLength = portShape.timeSlotList.length;k<kLength&&odu0Count < EQU_OBJ[xc.serviceLevel];k++)
			{
				var odu0Ts = portShape.timeSlotList[k];
				if(odu0Ts.snkOccupyPath == 0 && odu0Ts.srcOccupyPath == 0)
				{
					odu0Ts.occupy =1;
					odu0Count++;
					odu0Ts.srcOccupyPath = xc.srcPath;
							
				}
			}
			
		}
		

		
		if(SERVICE_ODUFLEX == xc.serviceLevel)
		{
			
			for(var j = 0,jLength = portShape.oduflexList.length;j<jLength;j++)	
			{
				var oduflexTs = portShape.oduflexList[j];
				if(oduflexTs.tsName == xc.srcTs)
				{			
					var odu0Count = 0;				

					for(var k = 0,kLength = portShape.timeSlotList.length;k<kLength&&odu0Count < xc.oduFlexTimeSlots;k++)
					{
						var odu0Ts = portShape.timeSlotList[k];
						if( odu0Ts.srcOccupyPath == 0)
						{
							odu0Ts.occupy =1;
							odu0Ts.srcOccupyPath = xc.srcPath;
							odu0Count++;
						}
					}								
					
				}
			}
		}			

	}
		

}


function setRandomTsUsed(portShape)
{
	setRandomSnkTsUsed(portShape,portShape.xcList);
	setRandomSnkTsUsed(portShape,portShape.workxcList);
	
	
	setRandomSrcTsUsed(portShape,portShape.xcList);
	setRandomSrcTsUsed(portShape,portShape.workxcList);
	
	
		
	setRandomProtectTsUsed(portShape,portShape.protectxcList);	
	
}


function setConsecutiveTsUsed(portShape,xc)
{
	var isSnkTs = !(portShape.slotId == xc.srcSlot &&  portShape.portId == xc.srcPort);
	var selectTS = isSnkTs? xc.snkTs:xc.srcTs;
	
	for(var i = 0,iLength = portShape.timeSlotList.length;i<iLength;i++)
	{
		var ts = portShape.timeSlotList[i];
		if(ts.tsName == selectTS)
		{
			portShape.timeSlotList[i].occupy =1;
			
			if(isSnkTs)
			{
				portShape.timeSlotList[i].snkOccupyPath = 1;
			}
		}
	}
	
	for(var i = 0,iLength = portShape.odu1List.length;i<iLength;i++)
	{
		var ts = portShape.odu1List[i];
		if(ts.tsName == selectTS)
		{
			portShape.timeSlotList[i*2].occupy =1;
			portShape.timeSlotList[i*2+1].occupy =1;
			
			if(isSnkTs)
			{
				portShape.timeSlotList[i*2].snkOccupyPath =1;
				portShape.timeSlotList[i*2+1].snkOccupyPath =1;
			}
		}
	}
	
	for(var i = 0,iLength = portShape.odu2List.length;i<iLength;i++)
	{
		var ts = portShape.odu2List[i];
		if(ts.tsName == selectTS)
		{
			for(var j =0;j<8;j++)
			{
				portShape.timeSlotList[i*ODU2_EQU+j].occupy =1;
				
				if(isSnkTs)
				{
					portShape.timeSlotList[i*8+j].snkOccupyPath =1;
				}
			}
			
		}
	}
	
	for(var i = 0,iLength = portShape.odu3List.length;i<iLength;i++)
	{
		var ts = portShape.odu3List[i];
		if(ts.tsName == selectTS)
		{
			for(var j =0;j<32;j++)
			{
				portShape.timeSlotList[i*32+j].occupy =1;
				
				if(isSnkTs)
				{
					portShape.timeSlotList[i*32+j].snkOccupyPath =1;
				}
			}
		}
	}
	
	for(var i = 0,iLength = portShape.odu4List.length;i<iLength;i++)
	{
		var ts = portShape.odu4List[i];
		if(ts.tsName == selectTS)
		{
			for(var j =0;j<40;j++)
			{
				portShape.timeSlotList[i*40+j].occupy =1;
				
				if(isSnkTs)
				{
					portShape.timeSlotList[i*40+j].snkOccupyPath =1;
				}
			}
		}
	}
}




/**
 *           ,         ODU0  
 */
function addLineBoardTs(portShape,accTs,accPath,signalList)
{
	var tss = accTs.split(",");
	var paths = accPath.split(",")
	var signals = signalList.split(",");
	
	for(var i = 0,iLength = tss.length;i<iLength-1;i++)
	{
		var ts = new TimeSlotShape(tsCount++,OBJECT_TYPE[3],0,0,TIMESLOT_INNERRADIUS,TIMESLOT_OUTERRADIUS);
		ts.parent = portShape;
		ts.name = portShape.timeSlotList.length +1;
		ts.tsName = tss[i];
		ts.title = "ODU0";
		ts.path = paths[i];
		

		
		if(signals[i] == "ODU0")
		{
			portShape.timeSlotList[portShape.timeSlotList.length] = ts;
			ts = new TimeSlotShape(tsCount-1,OBJECT_TYPE[3],0,0,TIMESLOT_INNERRADIUS,TIMESLOT_OUTERRADIUS);
			ts.parent = portShape;
			ts.name = portShape.timeSlotList.length +1;
			ts.tsName = tss[i];
			ts.title = "ODU0";
			ts.path = paths[i];			
			
			portShape.odu0List[portShape.odu0List.length] = ts;
		}
		else if(signals[i] == "ODU1")
		{
			portShape.odu1List[portShape.odu1List.length] = ts;
		}
		else if(signals[i] == "ODU2")
		{
			portShape.odu2List[portShape.odu2List.length] = ts;
		}
		else if(signals[i] == "ODU3")
		{
			portShape.odu3List[portShape.odu3List.length] = ts;
		}
		else if(signals[i] == "ODU4")
		{
			portShape.odu4List[portShape.odu4List.length] = ts;
		}
		else if(signals[i] == "ODUFlex")
		{
			portShape.oduflexList[portShape.oduflexList.length] = ts;
		}
	}
	
}


/**
 *           
 */
function addBranchTs(portShape,portId,showPortId,portName,signalList)
{
	var ts = new TimeSlotShape(tsCount++,OBJECT_TYPE[3],0,0,TIMESLOT_INNERRADIUS,TIMESLOT_OUTERRADIUS);
	ts.parent = portShape;
	portShape.timeSlotList[portShape.timeSlotList.length] = ts;
	ts.name = showPortId;
	ts.title = portName;
	ts.portid = portId;
	ts.showPortId = showPortId;
	ts.isMulti = 0;
	ts.signalList = signalList;
}

function  setBranchTsUsed(portShape)
{
	for(var i = 0,iLength = portShape.timeSlotList.length;i<iLength;i++)
	{
		var tsShape = portShape.timeSlotList[i];
		for(var j=0,jLength = portShape.xcList.length;j<jLength;j++)
		{
			var xc = portShape.xcList[j];
			if((xc.snkSlot == portShape.slotId && xc.snkPort == tsShape.portid)
			||(xc.srcSlot == portShape.slotId && xc.srcPort == tsShape.portid))
			{
				tsShape.occupy = 1;
				break;
			}			
			
		}
		
		for(var j=0,jLength = portShape.workxcList.length;j<jLength;j++)
		{
			var xc = portShape.workxcList[j];
			if((xc.snkSlot == portShape.slotId && xc.snkPort == tsShape.portid)
			||(xc.srcSlot == portShape.slotId && xc.srcPort == tsShape.portid))
			{
				tsShape.occupy = 1;
				break;
			}			
			
		}
		
		for(var j=0,jLength = portShape.protectxcList.length;j<jLength;j++)
		{
			var xc = portShape.protectxcList[j];
			if(xc.srcSlot == portShape.slotId && xc.srcPort == tsShape.portid)
			{
				tsShape.occupy = 1;
				break;
			}			
			
		}
		
		
	}
}

function initResoucesCallBack(doc)
{
    var data = EncapsulateData(doc);
    var errArr = [];
    errArr[0] = "nename";
    openErrPage(err_page, data.getError(), errArr,true);
    var blockList  = [];
    var branchBoard = new Object();
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
    	for ( var i=0, iLength = data.getDataRowLength(); i<iLength; i++)
    	{
    		var type = data.getDataRowParam(i, "type");
    		var id = data.getDataRowParam(i, "id");
    		
    		if(type == SHAPE_TYPE_DIRECTION)
    		{
    			var nodetype = data.getDataRowParam(i, "nodetype");
    			var startAngle = parseInt(data.getDataRowParam(i, "startAngle"));
    			var endAngle = parseInt(data.getDataRowParam(i, "endAngle"));
    			var name = data.getDataRowParam(i, "name");
    			var blockObj = new DirectionShape(id,OBJECT_TYPE[1],startAngle,endAngle,DIRECTION_INNERRADIUS,DIRECTION_OUTERRADIUS);
    			if(name == "Local")
    			{
    				blockObj.name = RESOURCE[name];
    				blockObj.title = RESOURCE[name];
    			}
    			else
    			{
    				blockObj.name = name;
    				blockObj.title = name;
    			}
    			
    			
    			blockObj.nodetype=nodetype;
    			blockList.push(blockObj);
    		}
    		else 
    		{
    			var slotId = data.getDataRowParam(i, "slotId");
    			var showSlotId = data.getDataRowParam(i, "ss");
    			var showportId = data.getDataRowParam(i, "portId");
    			var portId = data.getDataRowParam(i, "p");
    			var portName = data.getDataRowParam(i, "pn");
    			var parentId = data.getDataRowParam(i, "pID");
    			var boardName = data.getDataRowParam(i, "bN");
    			var levelList = data.getDataRowParam(i, "ll");
    			var tsmode = data.getDataRowParam(i, "tm");
    			var accTs = data.getDataRowParam(i, "acc");
    			var accPath = data.getDataRowParam(i, "ap");
    			var signalList = data.getDataRowParam(i, "sg");
    			graph.portDirMap[slotId+"-"+portId] = parentId;
    			
    			
    			if(null!=levelList)
    			{
    				var portShape = new PortShape(id,OBJECT_TYPE[2],0,0,PORT_INNERRADIUS,PORT_OUTERRADIUS);
    				portShape.parent = blockList[parentId];
    				portShape.name = showSlotId + "-"+ boardName + "-" + showportId;
    				portShape.slotId = slotId;
    				portShape.showSlotId = showSlotId;
    				portShape.slotName= boardName;
    				portShape.portId = portId;
    				portShape.title = portShape.name;
    				portShape.tsmode = tsmode;
    				var portShapeList =blockList[parentId].portShapeList;
    				portShapeList[portShapeList.length++] = portShape;
    				addLineBoardTs(portShape,accTs,accPath,signalList);
    			}
    			else if(""!=accTs)//   
    			{
    				
    				if(branchBoard[slotId]==1)
    				{
    					addBranchTs(portShape,portId,showportId,portName,signalList);
    				}
    				else
    				{
    					var portShape = new PortShape(id,OBJECT_TYPE[2],0,0,PORT_INNERRADIUS,PORT_OUTERRADIUS);
    					portShape.parent = blockList[parentId];
    					portShape.slotId = slotId;
    					portShape.showSlotId = showSlotId;
    					portShape.slotName = boardName;
    					portShape.name = showSlotId + "-"+ boardName;
    					portShape.title = portShape.name;
    					var portShapeList =blockList[parentId].portShapeList;
    					portShapeList[portShapeList.length++] = portShape;
    					addBranchTs(portShape,portId,showportId,portName,signalList);
    					
    					branchBoard[slotId] = 1;//         
    				}
		
    			}    						
    			
    		}
    			
    	}
    	
    	graph.directionShapeList = blockList;
    }
    
}



function createQueryResXML()
{
    var root = new inputxml("datainterface");
    var firstlevel = new tagElement("bussiness-params");
    var secondlevel = new tagElement("row-params");
    
    var thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","neid");
    thirdlevel.setAttribute("value",winurlobj["neid"]); 
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","shelfID");
    thirdlevel.setAttribute("value",winurlobj["shelfID"]);  
    secondlevel.appendChild(thirdlevel);
    firstlevel.appendChild(secondlevel);    
    root.getRoot().appendChild(firstlevel);
    return root.toString();
}

function applyCallback(doc)
{
	var data = EncapsulateData(doc);
    	var errArr = [];
    	errArr[0] = "nename";
    	openErrPage(err_page, data.getError(), errArr,true);
    	
	$("clearbtn").disabled = false;
	
    	
    	if (data.getSErrorCode() == 0 ) 
    	{
    		if (graph.editMode == GRAPH_MODE_CREATE)
    		{
    			var xcID = data.getDataRowParam(0, "xcID");
    			if (xcID != null && xcID != "undefined")
    			{
    				var xcidCell = st.getCell(0,"xcid");
   		            st.setCellValue(xcidCell,"xcid",xcID);  
    			}  		 
    			
    		}
    		if (graph.editMode == GRAPH_MODE_CREATE || graph.editMode == GRAPH_MODE_EDIT)
    		{   			
    			var pgID = data.getDataRowParam(0, "pgID");
    			if (pgID != null && pgID != "undefined")
    			{
    				var pgIDCell = st.getCell(0,"pgid");
   		            st.setCellValue(pgIDCell,"pgid",pgID);  
    			}  	
    		}
    		graph.editMode = GRAPH_MODE_VIEW;
    		$("createbtn").disabled = !btnRightArr.createbtn.right;
   		   
    		setTableEditStyle();
    		graph.clear();
    		
    		showOperSuccessPage();
    		
    		$("expandbtn").disabled = !btnRightArr.querybtn.right;
    	}
    	else
    	{
    		$("applybtn").disabled = !btnRightArr.createbtn.right;;
    	}
}


function apply()
{	
	var rowIndex = 0;
	var selectedRows = st.getSelectedRows();
        if(selectedRows.length > 0)
	{
		rowIndex = selectedRows[0];
	}
	
	if(!isApplyDataValid(rowIndex))
	{
		return;
	} 
	
	$("applybtn").disabled = true;
	$("clearbtn").disabled = true;
	
	
	
	var xml = createApplyXML(rowIndex);
	var sfid = "";
	
	if(graph.editMode == GRAPH_MODE_CREATE)
	{
		if(st.getCellStoreValue(rowIndex, "protectionSetting", "protectionSetting") == PORTECTION_OPEN)
		{
			sfid = TECMDCODE_WDM_CREATE_GRAPHSNCP;
		}
		else
		{
			sfid = TECMDCODE_WDM_CREATE_GRAPHEXC;
		}
	}
	else if(graph.editMode == GRAPH_MODE_EDIT)
	{
		if(st.getCellStoreValue(rowIndex, "protectionSetting", "protectionSetting") == PORTECTION_OPEN)
		{
			sfid = TECMDCODE_WDM_CONVERT_NOR_TO_SNCP;
		}
		else
		{
			if(st.getCellShow(rowIndex,"protectionPort").getValue() == " ")
			{
				alert(RESOURCE["noModify"]);
				$("applybtn").disabled = !btnRightArr.createbtn.right;;
				$("clearbtn").disabled = false;
				return ;
			}
			sfid = TECMDCODE_WDM_CONVERT_SNCP_TO_NOR;
		}
	}
	
	
	var url = "../../../../neExlorerServlet?sfid=" + sfid;

	
	
	
  loadXMLdoc(url, "POST", false, applyCallback, null, "inputdata=" + xml);
}


function isApplyDataValid(rowindex)
{
	var serviceLevel = st.getCellStoreValue(rowindex, "serviceLevel", "serviceLevel");
    	var srcSlotID = st.getCellCurrentValue(rowindex, "srcSlotID", "srcSlotID");
    	var srcPortID = st.getCellStoreValue(rowindex, "srcPortID", "srcPortID");
   	var srcPath = st.getCellStoreValue(rowindex, "srcPath", "srcPath");
    	var snkSlotID = st.getCellStoreValue(rowindex, "snkSlotID", "snkSlotID");
    	var snkPortID = st.getCellStoreValue(rowindex, "snkPortID", "snkPortID");
    	var snkPath = st.getCellStoreValue(rowindex, "snkPath", "snkPath");
    	var protectionSlotID = st.getCellStoreValue(rowindex, "protectionSlotID", "protectionSlotID");
    	var protectionPortID = st.getCellStoreValue(rowindex, "protectionPortID", "protectionPortID");
    	var protectionPath = st.getCellStoreValue(rowindex, "protectionPath", "protectionPath");
    	var protectionSetting = st.getCellStoreValue(rowindex, "protectionSetting", "protectionSetting");
    	
    	if(isEmpty(srcSlotID) || isEmpty(srcPortID))
    	{
    		alert(RESOURCE["soPortBlank"]);
    		return false;
    	}
    	
    	if(isEmpty(snkSlotID) || isEmpty(snkPortID))
    	{
    		alert(RESOURCE["skoPortBlank"]);
    		return false;
    	}
    	
    	if(isEmpty(srcPath))
    	{
    		alert(RESOURCE["soPathBlank"]);
    		return false;
    	}
    	
    	if(isEmpty(snkPath))
    	{
    		alert(RESOURCE["skoPathBlank"]);
    		return false;
    	}
    	
    	if(PORTECTION_OPEN == protectionSetting)
    	{
    		if(isEmpty(protectionSlotID) || isEmpty(protectionPortID))
    		{
    			alert(RESOURCE["protectPortBlank"]);
    			return false;
    		}
    		
    		if(isEmpty(protectionPath))
    		{
    			alert(RESOURCE["protectPathBlank"]);
    			return false;
    		}
    	}
    	
    	
    	
    	
    	
    	return true;
}

function createApplyXML(rowindex)
{
    var root = new inputxml("datainterface");
    var firstlevel = new tagElement("bussiness-params");
    var secondlevel = new tagElement("row-params");

    var xcid = st.getCellStoreValue(rowindex, "xcid", "xcid");
    var serviceLevel = st.getCellStoreValue(rowindex, "serviceLevel", "serviceLevel");
    var srcSlotID = st.getCellCurrentValue(rowindex, "srcSlotID", "srcSlotID");
    var srcPortID = st.getCellStoreValue(rowindex, "srcPortID", "srcPortID");
    var srcPath = st.getCellStoreValue(rowindex, "srcPath", "srcPath");
    var snkSlotID = st.getCellStoreValue(rowindex, "snkSlotID", "snkSlotID");
    var snkPortID = st.getCellStoreValue(rowindex, "snkPortID", "snkPortID");
    var snkPath = st.getCellStoreValue(rowindex, "snkPath", "snkPath");
    var direction = st.getCellStoreValue(rowindex, "direction", "direction");
    var activeState = st.getCellStoreValue(rowindex, "activeStatus", "activeStatus");
    var protectionSetting = st.getCellStoreValue(rowindex, "protectionSetting", "protectionSetting");
    var pgid = st.getCellStoreValue(rowindex, "pgid", "pgid");
    var serviceType = st.getCellStoreValue(rowindex, "serviceType", "serviceType");
    var oduFlexTimeSlots = st.getCellStoreValue(rowindex, "oduFlexTimeSlots", "oduFlexTimeSlots");
    var oduflexRateSlot = st.getCellStoreValue(rowindex, "oduflexRateSlot", "oduflexRateSlot");
    
    addTagElement(secondlevel, "subrackID", winurlobj["shelfID"]);
    addTagElement(secondlevel, "xcID", xcid);
    addTagElement(secondlevel, "neid", winurlobj["neid"]);
    addTagElement(secondlevel, "serviceLevel", serviceLevel);
    addTagElement(secondlevel, "srcSlotID", srcSlotID);
    addTagElement(secondlevel, "srcPortID", srcPortID);
    addTagElement(secondlevel, "srcPath", srcPath);
    addTagElement(secondlevel, "snkSlotID", snkSlotID);
    addTagElement(secondlevel, "snkPortID", snkPortID);
    addTagElement(secondlevel, "snkPath", snkPath);
    addTagElement(secondlevel, "direction", direction);
    addTagElement(secondlevel, "activeState", activeState)
    
    
    if(SERVICE_ODUFLEX != serviceLevel)
    {
    	addTagElement(secondlevel, "serviceType", "-");
    	addTagElement(secondlevel, "timeslot", "-");
    	addTagElement(secondlevel, "svcRate", "-"); 
    }
    else
    {
    	addTagElement(secondlevel, "serviceType", serviceType);
    	addTagElement(secondlevel, "timeslot", oduFlexTimeSlots);
    	addTagElement(secondlevel, "svcRate", oduflexRateSlot);
    }
    
    if(!isEmpty(pgid))
    {
    	addTagElement(secondlevel, "pgid", pgid); 
    }
    
    if((PORTECTION_OPEN == protectionSetting) || graph.editMode == GRAPH_MODE_EDIT)
    {
    	var protectSlotID = st.getCellCurrentValue(rowindex, "protectionSlotID", "protectionSlotID");
    	var protectPortID = st.getCellStoreValue(rowindex, "protectionPortID", "protectionPortID");
    	var protectPath = st.getCellStoreValue(rowindex, "protectionPath", "protectionPath");
    	var sncpType = st.getCellStoreValue(rowindex, "sncpType", "sncpType");
    	var revertiveMode = st.getCellStoreValue(rowindex, "revertiveMode", "revertiveMode");
    	var wtrTime = st.getCellStoreValue(rowindex, "wtrTime", "wtrTime");
    	var delayTime = st.getCellStoreValue(rowindex, "delayTime", "delayTime");
    	var protectDelayTime = st.getCellStoreValue(rowindex, "protectDelayTime", "protectDelayTime");
    	var sdTriggerFlag = st.getCellStoreValue(rowindex, "sdTriggerFlag", "sdTriggerFlag");
    	var otnLevel = st.getCellStoreValue(rowindex, "otnLevel", "otnLevel");
    	
    	
    	
    	addTagElement(secondlevel, "protectSlotID", protectSlotID);
    	addTagElement(secondlevel, "protectPortID", protectPortID);
    	addTagElement(secondlevel, "protectPath", protectPath);
    	
    	addTagElement(secondlevel, "sncpType", sncpType);
    	addTagElement(secondlevel, "revertiveMode", revertiveMode);
    	addTagElement(secondlevel, "wtrTime", wtrTime);
    	addTagElement(secondlevel, "delayTime", delayTime);
    	addTagElement(secondlevel, "protectDelayTime", protectDelayTime);
    	addTagElement(secondlevel, "sdTriggerFlag", sdTriggerFlag);
    	addTagElement(secondlevel, "otnLevel", otnLevel);
    }
    
         
    
   
    firstlevel.appendChild(secondlevel);    
    root.getRoot().appendChild(firstlevel);
    return root.toString();
}

function initBtn()
{
	$("createbtn").value=RESOURCE["createBtn"];
	$("deletebtn").value=RESOURCE["deleteBtn"];
	$("activebtn").value=RESOURCE["activate"];
	$("inactivebtn").value=RESOURCE["deactive"];
	$("clearbtn").value=RESOURCE["clearButton"];
	$("applybtn").value=RESOURCE["applybutton"];
	$("expandbtn").value=RESOURCE["expand"];
	
	btnRightArr.createbtn = new BtnRightObj("createbtn",TECMDCODE_WDM_CREATE_GRAPHEXC);
	btnRightArr.deletebtn = new BtnRightObj("applybtn",TECMDCODE_WDM_DELETE_GRAPHEXC);
	btnRightArr.activebtn = new BtnRightObj("activebtn",TECMDCODE_WDM_ACTIVATE_GRAPHEXC);
	btnRightArr.applybtn = new BtnRightObj("applybtn",TECMDCODE_WDM_CREATE_GRAPHSNCP);
	btnRightArr.querybtn = new BtnRightObj("querybtn",TECMDCODE_WDM_QUERY_GRAPHEXC);
	
	getRightInfo(winurlobj,btnRightArr);
	
	$("createbtn").disabled = !btnRightArr.createbtn.right;
	$("deletebtn").disabled = true;
	$("activebtn").disabled = true;
	$("inactivebtn").disabled = true;
	$("applybtn").disabled = true;
	$("expandbtn").disabled = true;
	$("clearbtn").disabled = !btnRightArr.querybtn.right;
}






function addTableLister()
{
	for(var i = 0, len = st.getDataRowLength(); i < len; i++)
	{
		
		var celledit = st.getCellEdit(i, "protectionSetting");
		celledit.element.onchange = protectionChanged;
		
		celledit = st.getCellEdit(i, "srcPort");
		celledit.element.onkeypress = function()
		{
			return  false;
		}
		celledit.element.onfocus = function()
		{
			graph.currentEditDir = NODE_TYPE_SRC;
		}
		
		celledit = st.getCellEdit(i, "srcPath");
		limitPathInput(celledit.element, 0, 9999);
		
		celledit = st.getCellEdit(i, "snkPort");
		celledit.element.onkeypress = function()
		{
			return  false;
		}
		celledit.element.onfocus = function()
		{
			graph.currentEditDir = NODE_TYPE_SNK;
		}
		
		celledit = st.getCellEdit(i, "snkPath");
		limitPathInput(celledit.element, 0, 9999);
		
		celledit = st.getCellEdit(i, "protectionPort");
		celledit.element.onkeypress = function()
		{
			return  false;
		}
		celledit.element.ondblclick = function()
		{
			graph.currentEditDir = NODE_TYPE_PROTECTION;
		}
		
		celledit = st.getCellEdit(i, "protectionPath");
		limitPathInput(celledit.element, 0, 9999);
		
		
		var celledit = st.getCellEdit(i, "serviceLevel");
		celledit.element.onchange = serviceLevelChanged;
	}
}


function serviceLevelChanged()
{
	if(this.value == SERVICE_ODUFLEX)
	{
		createwindow("oduflexConfig.html", "", 480,180, true, "../../../../images/");
	}
}

function protectionChanged()
{
	var rowindex = 0;
	var selectedRows = st.getSelectedRows();
        if(selectedRows.length > 0)
	{
		rowindex = selectedRows[0];
	}
	
	if(this.value == PORTECTION_OPEN)//                                
	{		
				var srcSlotID = st.getCellCurrentValue(rowindex, "srcSlotID", "srcSlotID");
    		var srcPortID = st.getCellStoreValue(rowindex, "srcPortID", "srcPortID");
    		var srcPath = st.getCellStoreValue(rowindex, "srcPath", "srcPath");
    		var snkSlotID = st.getCellStoreValue(rowindex, "snkSlotID", "snkSlotID");
    		var snkPortID = st.getCellStoreValue(rowindex, "snkPortID", "snkPortID");
    		var snkPath = st.getCellStoreValue(rowindex, "snkPath", "snkPath");
    		
    		if(isEmpty(srcSlotID) || isEmpty(srcPortID))
    		{
    			alert(RESOURCE["soPortBlank"]);
    			setProtectionSetting(rowindex,true);   			
    			return false;
    		}
    	
    		if(isEmpty(snkSlotID) || isEmpty(snkPortID))
    		{
    			alert(RESOURCE["skoPortBlank"]);
    			setProtectionSetting(rowindex,true); 
    			return false;
    		}
    	
    		if(isEmpty(srcPath))
    		{
    			alert(RESOURCE["soPathBlank"]);
    			setProtectionSetting(rowindex,true); 
    			return false;
    		}
    	
    		if(isEmpty(snkPath))
    		{
    			alert(RESOURCE["skoPathBlank"]);
    			setProtectionSetting(rowindex,true); 
    			return false;
    		}
		
		
		graph.currentEditDir = NODE_TYPE_PROTECTION;
		var protectionPort = st.getCell(rowindex,"protectionPort");
		st.setCellIsEdit(protectionPort, 1);
		protectionPort.element.style.backgroundColor = "#d0f946";
			

		createwindow("protectionSetting.html", RESOURCE["protectionSetting"], 480,300, true, "../../../../images/");
			
		if(graph.editMode == GRAPH_MODE_VIEW)
		{
			graph.editMode = GRAPH_MODE_EDIT;
		}
						
	}
	else
	{
		
		
		if(graph.editMode == GRAPH_MODE_VIEW)
		{
			if(!confirm(RESOURCE["isSncpToNormal"]))
			{
				setProtectionSetting(rowindex,false);
				return;
			}
			
			setProtectionSetting(rowindex,true); 
			graph.editMode = GRAPH_MODE_EDIT;
			
			apply();
		}
		
		var protectionPort = st.getCell(rowindex,"protectionPort");
		st.setCellIsEdit(protectionPort, 0);
		protectionPort.element.style.backgroundColor = "";
		graph.clearProtect();
		st.getCellShow(rowindex,"protectionPort").setValue(" ");
		st.getCellShow(rowindex,"protectionPath").setValue(" ");
	}
}






function rowSelectHandler()
{
	if(graph.editMode == GRAPH_MODE_VIEW )
	{
		$("deletebtn").disabled = !btnRightArr.createbtn.right;
		$("activebtn").disabled = !btnRightArr.activebtn.right;
		$("inactivebtn").disabled = !btnRightArr.activebtn.right;
	}
}



function deleteXC()
{
	if(!confirm(RESOURCE["confirmDelete"]))
	{
		return;
	}
	
	var xml = createDeleteXML();
	
	if(null ==xml)
	{
		alert(RESOURCE["onlyinactive"]);
		return;
	}
	
	$("deletebtn").disabled = true;
	$("inactivebtn").disabled = true;
   	$("activebtn").disabled = true;
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_WDM_DELETE_GRAPHEXC;
        loadXMLdoc(url, "POST", false, deleteCallBack, null, "inputdata=" + xml);
}

function createDeleteXML()
{
    var root = new inputxml("datainterface");
    var firstlevel = new tagElement("bussiness-params");
    
    var inactiveCount = 0;
    var selectedRows = st.getSelectedRows();

   for(var i = 0;i < selectedRows.length;i++)
    {
    var rowindex = selectedRows[i];
    
    var secondlevel = new tagElement("row-params");
    var serviceLevel = st.getCellStoreValue(rowindex, "serviceLevel", "serviceLevel");
    var srcSlotID = st.getCellCurrentValue(rowindex, "srcSlotID", "srcSlotID");
    var srcPortID = st.getCellStoreValue(rowindex, "srcPortID", "srcPortID");
    var srcPath = st.getCellStoreValue(rowindex, "srcPath", "srcPath");
    var snkSlotID = st.getCellStoreValue(rowindex, "snkSlotID", "snkSlotID");
    var snkPortID = st.getCellStoreValue(rowindex, "snkPortID", "snkPortID");
    var snkPath = st.getCellStoreValue(rowindex, "snkPath", "snkPath");
    var direction = st.getCellStoreValue(rowindex, "direction", "direction");
    var activeState = st.getCellStoreValue(rowindex, "activeStatus", "activeStatus");
    var xcID = st.getCellStoreValue(rowindex, "xcid", "xcid");
    var biXCID = st.getCellStoreValue(rowindex, "biXCID", "biXCID");
    var protectionSetting = st.getCellStoreValue(rowindex, "protectionSetting", "protectionSetting");
    
    if(activeState == 1)//"active"    
    {
    	continue;
    }
    
    addTagElement(secondlevel, "neid", winurlobj["neid"]);
    addTagElement(secondlevel, "serviceLevel", serviceLevel);
    addTagElement(secondlevel, "srcSlotID", srcSlotID);
    addTagElement(secondlevel, "srcPortID", srcPortID);
    addTagElement(secondlevel, "srcPath", srcPath);
    addTagElement(secondlevel, "snkSlotID", snkSlotID);
    addTagElement(secondlevel, "snkPortID", snkPortID);
    addTagElement(secondlevel, "snkPath", snkPath);
    addTagElement(secondlevel, "direction", direction);
    addTagElement(secondlevel, "activeState", activeState);
    addTagElement(secondlevel, "xcID", xcID);
    

    if(serviceLevel == SERVICE_ODUFLEX)
    {
    	addTagElement(secondlevel, "serviceType", st.getCellCurrentValue(rowindex, "serviceType", "serviceType"));
    	addTagElement(secondlevel, "timeslot", st.getCellCurrentValue(rowindex, "oduFlexTimeSlots", "oduFlexTimeSlots"));
    	addTagElement(secondlevel, "svcRate", st.getCellCurrentValue(rowindex, "oduflexRateSlot", "oduflexRateSlot"));
    }
    else
    {
    	addTagElement(secondlevel, "serviceType", "-");
    	addTagElement(secondlevel, "timeslot", "-");
    	addTagElement(secondlevel, "svcRate", "-");
    }
    
    if(biXCID != null)
    {
    	addTagElement(secondlevel, "biXCID", biXCID);
    }
    
    
    if(PORTECTION_OPEN == protectionSetting)
    {
    	var protectSlotID = st.getCellCurrentValue(rowindex, "protectionSlotID", "protectionSlotID");
    	var protectPortID = st.getCellStoreValue(rowindex, "protectionPortID", "protectionPortID");
    	var protectPath = st.getCellStoreValue(rowindex, "protectionPath", "protectionPath");
    	var sncpType = st.getCellStoreValue(rowindex, "sncpType", "sncpType");
    	var revertiveMode = st.getCellStoreValue(rowindex, "revertiveMode", "revertiveMode");
    	var wtrTime = st.getCellStoreValue(rowindex, "wtrTime", "wtrTime");
    	var delayTime = st.getCellStoreValue(rowindex, "delayTime", "delayTime");
    	var protectDelayTime = st.getCellStoreValue(rowindex, "protectDelayTime", "protectDelayTime");
    	var sdTriggerFlag = st.getCellStoreValue(rowindex, "sdTriggerFlag", "sdTriggerFlag");
    	var pgid = st.getCellStoreValue(rowindex, "pgid", "pgid");
    	var protectXCID = st.getCellStoreValue(rowindex, "protectXCID", "protectXCID");
    	var workXCID = st.getCellStoreValue(rowindex, "workXCID", "workXCID");
    	
    	
    	
    	addTagElement(secondlevel, "protectSlotID", protectSlotID);
    	addTagElement(secondlevel, "protectPortID", protectPortID);
    	addTagElement(secondlevel, "protectPath", protectPath);
    	
    	addTagElement(secondlevel, "sncpType", sncpType);
    	addTagElement(secondlevel, "revertiveMode", revertiveMode);
    	addTagElement(secondlevel, "wtrTime", wtrTime);
    	addTagElement(secondlevel, "delayTime", delayTime);
    	addTagElement(secondlevel, "protectDelayTime", protectDelayTime);
    	addTagElement(secondlevel, "sdTriggerFlag", sdTriggerFlag);
    	addTagElement(secondlevel, "sncpType", sncpType);
    	addTagElement(secondlevel, "pgid", pgid);
    	addTagElement(secondlevel, "protectXCID", protectXCID);
    	addTagElement(secondlevel, "workXCID", workXCID);
    	
    }
    
    inactiveCount++;
    firstlevel.appendChild(secondlevel); 
    }
    
    
    if(inactiveCount == 0)
    {
    	return null;
    }

       
    root.getRoot().appendChild(firstlevel);
   
    return root.toString();
}

function deleteCallBack(doc)
{
    var data = EncapsulateData(doc);

    if (data.getSErrorCode() == 0 ) 
    {
    	st.clearTableData();
    	clearGraph();
    	
    	showOperSuccessPage();
    }
    
    
    var errArr = [];
    errArr[0] = "nename";
    openErrPage(err_page, data.getError(), errArr,true);	

}



function getSrcLinePath(srcPort)
{
	var serviceLevel = st.getCellStoreValue(0, "serviceLevel", "serviceLevel");
	var direction = st.getCellStoreValue(0, "direction", "direction");
	var oduFlexTimeSlots = st.getCellStoreValue(0, "oduFlexTimeSlots", "oduFlexTimeSlots");
	
	if(serviceLevel == SERVICE_ODU0 && direction ==  UNI_DIRECTION)
	{
		if(srcPort.selectTs < 1)
		{
			return "";
		}
		
		return srcPort.selectTs[0].path;
	}
	
	
	if(serviceLevel == SERVICE_ODU0 && direction ==  BID_DIRECTION)
	{
		if(srcPort.selectTs < 1)
		{
			return "";
		}
		
		for(var j = 0,jLength=srcPort.odu0List.length;j<jLength;j++)
	 	{
	 		if(srcPort.odu0List[j].snkOccupyPath == 0)
	 		{
	 			return srcPort.odu0List[j].path;
	 		}
	 	}
		
		return "";
	}
	
	
	if(serviceLevel == SERVICE_ODU1 && direction ==  UNI_DIRECTION)
	{
		if(srcPort.selectTs < ODU1_EQU)
		{
			return "";
		}
		
		return srcPort.odu1List[0].path;
	}
	
	
	if(serviceLevel == SERVICE_ODU1 && direction ==  BID_DIRECTION && srcPort.tsmode == TSMODE_RANDOM)
	{		
		var freeOdu0Count = 0;
		for(var j = 0,jLength=srcPort.selectTs.length;j<jLength;j++)
	 	{
	 		if(srcPort.selectTs[j].snkOccupyPath == 0)
	 		{
	 			freeOdu0Count++;
	 		}
	 	}
	 	
	 	
	 	if(freeOdu0Count < ODU1_EQU)
	 	{
	 		return "";
	 	}
	 	
	 	for(var j = 0,jLength = srcPort.odu1List.length;j<jLength;j++)	
		{
			var odu1Ts = srcPort.odu1List[j];
			if(odu1Ts.snkOccupyPath == 0)
			{
				return odu1Ts.path;
			}
		}
				
	 	
	 	
		
		return "";
	}
	
	
	if(serviceLevel == SERVICE_ODU2 && direction ==  UNI_DIRECTION)
	{
		if(srcPort.selectTs < ODU2_EQU)
		{
			return "";
		}
		
		return srcPort.odu2List[0].path;
	}
	
	
	if(serviceLevel == SERVICE_ODU2 && direction ==  BID_DIRECTION && srcPort.tsmode == TSMODE_RANDOM)
	{		
		var freeOdu0Count = 0;
		for(var j = 0,jLength=srcPort.selectTs.length;j<jLength;j++)
	 	{
	 		if(srcPort.selectTs[j].snkOccupyPath == 0)
	 		{
	 			freeOdu0Count++;
	 		}
	 	}
	 	
	 	
	 	if(freeOdu0Count < ODU2_EQU)
	 	{
	 		return "";
	 	}
	 	
	 	for(var j = 0,jLength = srcPort.odu2List.length;j<jLength;j++)	
		{
			var odu2Ts = srcPort.odu2List[j];
			if(odu2Ts.snkOccupyPath == 0)
			{
				return odu2Ts.path;
			}
		}
				
	 	
	 	
		
		return "";
	}
	
	
	if(serviceLevel == SERVICE_ODU3 && direction ==  UNI_DIRECTION)
	{
		if(srcPort.selectTs < ODU3_EQU)
		{
			return "";
		}
		
		return srcPort.odu3List[0].path;
	}
	
	
	if(serviceLevel == SERVICE_ODU3 && direction ==  BID_DIRECTION && srcPort.tsmode == TSMODE_RANDOM)
	{		
		var freeOdu0Count = 0;
		for(var j = 0,jLength=srcPort.selectTs.length;j<jLength;j++)
	 	{
	 		if(srcPort.selectTs[j].snkOccupyPath == 0)
	 		{
	 			freeOdu0Count++;
	 		}
	 	}
	 	
	 	
	 	if(freeOdu0Count < ODU3_EQU)
	 	{
	 		return "";
	 	}
	 	
	 	for(var j = 0,jLength = srcPort.odu3List.length;j<jLength;j++)	
		{
			var odu3Ts = srcPort.odu3List[j];
			if(odu3Ts.snkOccupyPath == 0)
			{
				return odu3Ts.path;
			}
		}
				
	 	
	 	
		
		return "";
	}
	
	
	if(serviceLevel == SERVICE_ODU4 && direction ==  UNI_DIRECTION)
	{
		if(srcPort.selectTs < ODU4_EQU)
		{
			return "";
		}
		
		return srcPort.odu4List[0].path;
	}
	
	
	if(serviceLevel == SERVICE_ODU4 && direction ==  BID_DIRECTION && srcPort.tsmode == TSMODE_RANDOM)
	{		
		var freeOdu0Count = 0;
		for(var j = 0,jLength=srcPort.selectTs.length;j<jLength;j++)
	 	{
	 		if(srcPort.selectTs[j].snkOccupyPath == 0)
	 		{
	 			freeOdu0Count++;
	 		}
	 	}
	 	
	 	
	 	if(freeOdu0Count < ODU4_EQU)
	 	{
	 		return "";
	 	}
	 	
	 	for(var j = 0,jLength = srcPort.odu4List.length;j<jLength;j++)	
		{
			var odu4Ts = srcPort.odu4List[j];
			if(odu4Ts.snkOccupyPath == 0)
			{
				return odu4Ts.path;
			}
		}	
		
		return "";
	}
	
	if(serviceLevel == SERVICE_ODUFLEX && direction ==  UNI_DIRECTION)
	{
		if(srcPort.selectTs < oduFlexTimeSlots)
		{
			return "";
		}	
		return srcPort.oduflexList[0].path;
	}
	
	
	if(serviceLevel == SERVICE_ODUFLEX && direction ==  BID_DIRECTION && srcPort.tsmode == TSMODE_RANDOM)
	{		
		var freeOdu0Count = 0;
		for(var j = 0,jLength=srcPort.selectTs.length;j<jLength;j++)
	 	{
	 		if(srcPort.selectTs[j].snkOccupyPath == 0)
	 		{
	 			freeOdu0Count++;
	 		}
	 	}
	 	
	 	
	 	if(freeOdu0Count < oduFlexTimeSlots)
	 	{
	 		return "";
	 	}
	 	
	 	for(var j = 0,jLength = srcPort.oduflexList.length;j<jLength;j++)	
		{
			var oduflexTs = srcPort.oduflexList[j];
			if(oduflexTs.snkOccupyPath == 0)
			{
				return oduflexTs.path;
			}
		}	
		
		return "";
	}
	
	
	
}


function getSnkLinePath(snkPort)
{
	var serviceLevel = st.getCellStoreValue(0, "serviceLevel", "serviceLevel");
	var direction = st.getCellStoreValue(0, "direction", "direction");
	var oduFlexTimeSlots = st.getCellStoreValue(0, "oduFlexTimeSlots", "oduFlexTimeSlots");
	
	if(serviceLevel == SERVICE_ODU0)
	{
		if(snkPort.selectTs < 1)
		{
			return "";
		}
		
		for(var j = 0,jLength=snkPort.odu0List.length;j<jLength;j++)
	 	{
	 		if(snkPort.odu0List[j].snkOccupyPath == 0)
	 		{
	 			return snkPort.odu0List[j].path;
	 		}
	 	}
		
		return "";
	}
	
	
	if(serviceLevel == SERVICE_ODU1  && snkPort.tsmode == TSMODE_RANDOM)
	{		
		var freeOdu0Count = 0;
		for(var j = 0,jLength=snkPort.selectTs.length;j<jLength;j++)
	 	{
	 		if(snkPort.selectTs[j].snkOccupyPath == 0)
	 		{
	 			freeOdu0Count++;
	 		}
	 	}
	 	
	 	
	 	if(freeOdu0Count < ODU1_EQU)
	 	{
	 		return "";
	 	}
	 	
	 	for(var j = 0,jLength = snkPort.odu1List.length;j<jLength;j++)	
		{
			var odu1Ts = snkPort.odu1List[j];
			if(odu1Ts.snkOccupyPath == 0)
			{
				return odu1Ts.path;
			}
		}
				
	 	
	 	
		
		return "";
	}
	
	
	if(serviceLevel == SERVICE_ODU2 && snkPort.tsmode == TSMODE_RANDOM)
	{		
		var freeOdu0Count = 0;
		for(var j = 0,jLength=snkPort.selectTs.length;j<jLength;j++)
	 	{
	 		if(snkPort.selectTs[j].snkOccupyPath == 0)
	 		{
	 			freeOdu0Count++;
	 		}
	 	}
	 	
	 	
	 	if(freeOdu0Count < ODU2_EQU)
	 	{
	 		return "";
	 	}
	 	
	 	for(var j = 0,jLength = snkPort.odu1List.length;j<jLength;j++)	
		{
			var odu2Ts = snkPort.odu2List[j];
			if(odu2Ts.snkOccupyPath == 0)
			{
				return odu2Ts.path;
			}
		}
				
	 	
	 	
		
		return "";
	}
	
	
	if(serviceLevel == SERVICE_ODU3  && snkPort.tsmode == TSMODE_RANDOM)
	{		
		var freeOdu0Count = 0;
		for(var j = 0,jLength=snkPort.selectTs.length;j<jLength;j++)
	 	{
	 		if(snkPort.selectTs[j].snkOccupyPath == 0)
	 		{
	 			freeOdu0Count++;
	 		}
	 	}
	 	
	 	
	 	if(freeOdu0Count < ODU3_EQU)
	 	{
	 		return "";
	 	}
	 	
	 	for(var j = 0,jLength = snkPort.odu3List.length;j<jLength;j++)	
		{
			var odu3Ts = snkPort.odu3List[j];
			if(odu3Ts.snkOccupyPath == 0)
			{
				return odu3Ts.path;
			}
		}
				
	 	
	 	
		
		return "";
	}
	
	
	if(serviceLevel == SERVICE_ODU4  && snkPort.tsmode == TSMODE_RANDOM)
	{		
		var freeOdu0Count = 0;
		for(var j = 0,jLength=snkPort.selectTs.length;j<jLength;j++)
	 	{
	 		if(snkPort.selectTs[j].snkOccupyPath == 0)
	 		{
	 			freeOdu0Count++;
	 		}
	 	}
	 	
	 	
	 	if(freeOdu0Count < ODU4_EQU)
	 	{
	 		return "";
	 	}
	 	
	 	for(var j = 0,jLength = snkPort.odu4List.length;j<jLength;j++)	
		{
			var odu4Ts = snkPort.odu4List[j];
			if(odu4Ts.snkOccupyPath == 0)
			{
				return odu4Ts.path;
			}
		}
		return "";
	}
	
	if(serviceLevel == SERVICE_ODUFLEX  && snkPort.tsmode == TSMODE_RANDOM)
	{		
		var freeOdu0Count = 0;
		for(var j = 0,jLength=snkPort.selectTs.length;j<jLength;j++)
	 	{
	 		if(snkPort.selectTs[j].snkOccupyPath == 0)
	 		{
	 			freeOdu0Count++;
	 		}
	 	}
	 	
	 	
	 	if(freeOdu0Count < oduFlexTimeSlots)
	 	{
	 		return "";
	 	}
	 	
	 	for(var j = 0,jLength = snkPort.oduflexList.length;j<jLength;j++)	
		{
			var oduflexTs = snkPort.oduflexList[j];
			if(oduflexTs.snkOccupyPath == 0)
			{
				return oduflexTs.path;
			}
		}
		return "";
	}
	
	
	
}


function showEditXCTable()
{
	var protectPort  = null;
	
	var dinterface = getDefaultData();
	var row = dinterface.rows[0];
	var rowIndex = 0;
	
	var selectedRows = st.getSelectedRows();
	if(selectedRows.length > 0)
	{
		rowIndex = selectedRows[0];
	}
	
	var serviceLevel = st.getCellStoreValue(rowIndex, "serviceLevel", "serviceLevel");
	row["serviceLevel"].value = serviceLevel;
	row["direction"].value = st.getCellStoreValue(rowIndex, "direction", "direction");
	row["activeStatus"].value = st.getCellStoreValue(rowIndex, "activeStatus", "activeStatus");
	row["protectionSetting"].value = st.getCellStoreValue(rowIndex, "protectionSetting", "protectionSetting");
	row["xcid"].value = st.getCellStoreValue(rowIndex, "xcid", "xcid");
	
	row["protectType"].value = st.getCellStoreValue(rowIndex, "protectType", "protectType");
	row["sncpType"].value = st.getCellStoreValue(rowIndex, "sncpType", "sncpType");
	row["otnLevel"].value = st.getCellStoreValue(rowIndex, "otnLevel", "otnLevel");
	row["revertiveMode"].value = st.getCellStoreValue(rowIndex, "revertiveMode", "revertiveMode");
	row["wtrTime"].value = st.getCellStoreValue(rowIndex, "wtrTime", "wtrTime");
	row["delayTime"].value = st.getCellStoreValue(rowIndex, "delayTime", "delayTime");
	row["protectDelayTime"].value = st.getCellStoreValue(rowIndex, "protectDelayTime", "protectDelayTime");
	row["sdTriggerFlag"].value = st.getCellStoreValue(rowIndex, "sdTriggerFlag", "sdTriggerFlag");
	
	row["srcSlotID"].value = st.getCellStoreValue(rowIndex, "srcSlotID", "srcSlotID");
	row["srcBoardName"].value = st.getCellStoreValue(rowIndex, "srcPort", "srcBoardName");
	row["srcPortID"].value = st.getCellStoreValue(rowIndex, "srcPortID", "srcPortID");
	row["srcShowPortID"].value = st.getCellStoreValue(rowIndex, "srcPort", "srcShowPortID");
	row["srcPath"].value = st.getCellStoreValue(rowIndex, "srcPath", "srcPath");
	row["snkSlotID"].value = st.getCellStoreValue(rowIndex, "snkSlotID", "snkSlotID");
	row["snkBoardName"].value = st.getCellStoreValue(rowIndex, "snkPort", "snkBoardName");
	row["snkPortID"].value = st.getCellStoreValue(rowIndex, "snkPortID", "snkPortID");
	row["snkShowPortID"].value = st.getCellStoreValue(rowIndex, "snkPort", "snkShowPortID");
	row["snkPath"].value = st.getCellStoreValue(rowIndex, "snkPath", "snkPath");
	
	
	if(graph.protectPort != null)
	{
		protectPort = graph.protectPort;
		addParamTag(row, "protectionSlotID", protectPort.slotId);
		addParamTag(row, "protectionShowSlotID", protectPort.showSlotId);
		addParamTag(row, "protectionBoardName", protectPort.slotName);
		
		if(0 != protectPort.portId )
		{
			row["protectionPortID"].value = protectPort.portId;
			row["protectionShowPortID"].value = getPortRelativeID(protectPort.portId);
			row["protectionPath"].value = getSnkLinePath(protectPort);

		}
		else//   
		{
			row["protectionPortID"].value = protectPort.selectTs[0].portid;
			row["protectionShowPortID"].value = getPortRelativeID(row["protectionPortID"].value);
			row["protectionPath"].value = 1;
		}
	}
	
	st.clearTableData();
	createXCTableBody(st, window.tableconf[0], dinterface, RESOURCE);
	setTableEditStyle();
	$("applybtn").disabled = !btnRightArr.createbtn.right;
}

function showCreateXCTable()
{
	var srcPort = null;
	var snkPort = null;
	var protectPort  = null;
	
	var dinterface = getDefaultData();
	var row = dinterface.rows[0];
	var rowIndex = 0;
	
	var selectedRows = st.getSelectedRows();
	if(selectedRows.length > 0)
	{
		rowIndex = selectedRows[0];
	}
	
	var serviceLevel = st.getCellStoreValue(rowIndex, "serviceLevel", "serviceLevel");
	row["serviceLevel"].value = serviceLevel;
	row["direction"].value = st.getCellStoreValue(rowIndex, "direction", "direction");
	row["activeStatus"].value = st.getCellStoreValue(rowIndex, "activeStatus", "activeStatus");
	row["protectionSetting"].value = st.getCellStoreValue(rowIndex, "protectionSetting", "protectionSetting");
	
	row["protectType"].value = st.getCellStoreValue(rowIndex, "protectType", "protectType");
	row["sncpType"].value = st.getCellStoreValue(rowIndex, "sncpType", "sncpType");
	row["otnLevel"].value = st.getCellStoreValue(rowIndex, "otnLevel", "otnLevel");
	row["revertiveMode"].value = st.getCellStoreValue(rowIndex, "revertiveMode", "revertiveMode");
	row["wtrTime"].value = st.getCellStoreValue(rowIndex, "wtrTime", "wtrTime");
	row["delayTime"].value = st.getCellStoreValue(rowIndex, "delayTime", "delayTime");
	row["protectDelayTime"].value = st.getCellStoreValue(rowIndex, "protectDelayTime", "protectDelayTime");
	row["sdTriggerFlag"].value = st.getCellStoreValue(rowIndex, "sdTriggerFlag", "sdTriggerFlag");
	
	row["serviceType"].value = st.getCellStoreValue(rowIndex, "serviceType", "serviceType");
	row["oduFlexTimeSlots"].value = st.getCellStoreValue(rowIndex, "oduFlexTimeSlots", "oduFlexTimeSlots");
	row["oduflexRateSlot"].value = st.getCellStoreValue(rowIndex, "oduflexRateSlot", "oduflexRateSlot");

	if(graph.srcPort != null)
	{
		srcPort = graph.srcPort;
		row["srcSlotID"].value = srcPort.slotId;
		row["showSrcSlot"].value = srcPort.showSlotId;
		
		row["srcBoardName"].value = srcPort.slotName;
		
		if(0 != srcPort.portId )
		{
			row["srcPortID"].value = srcPort.portId;
			row["srcShowPortID"].value = getPortRelativeID(srcPort.portId);
			row["srcPath"].value = getSrcLinePath(srcPort);
			
		}
		else//   
		{
			row["srcPortID"].value = srcPort.selectTs[0].portid;
			row["srcShowPortID"].value = getPortRelativeID(row["srcPortID"].value);
			row["srcPath"].value = 1;
		}

	}

	if(graph.snkPort != null)
	{
		snkPort = graph.snkPort;
		addParamTag(row, "snkSlotID", snkPort.slotId);
		addParamTag(row, "showSnkSlot", snkPort.showSlotId);
		addParamTag(row, "snkBoardName", snkPort.slotName);
		
		if(0 != snkPort.portId )
		{
			row["snkPortID"].value = snkPort.portId;
			row["snkShowPortID"].value = getPortRelativeID(snkPort.portId);
			row["snkPath"].value = getSnkLinePath(snkPort);

		}
		else//   
		{
			row["snkPortID"].value = snkPort.selectTs[0].portid;
			row["snkShowPortID"].value = getPortRelativeID(row["snkPortID"].value);
			row["snkPath"].value = 1;
		}
	}
	
	
	if(graph.protectPort != null)
	{
		protectPort = graph.protectPort;
		addParamTag(row, "protectionSlotID", protectPort.slotId);
		addParamTag(row, "protectionShowSlotID", protectPort.showSlotId);
		addParamTag(row, "protectionBoardName", protectPort.slotName);
		
		if(0 != protectPort.portId )
		{
			row["protectionPortID"].value = protectPort.portId;
			row["protectionShowPortID"].value = getPortRelativeID(protectPort.portId);
			row["protectionPath"].value = getSnkLinePath(protectPort);

		}
		else//   
		{
			row["protectionPortID"].value = protectPort.selectTs[0].portid;
			row["protectionShowPortID"].value = getPortRelativeID(row["protectionPortID"].value);
			row["protectionPath"].value = 1;
		}
	}
	
	
	st.clearTableData();
	createXCTableBody(st, window.tableconf[0], dinterface, RESOURCE);
	setTableEditStyle();

	
}


function showOdu0WorkXCInTable(dinterface,srcPort)
{
		var biIndexMap = new Object();
		var xcList = [];
		
		for(var i=0,iLength=srcPort.workxcList.length;i<iLength;i++)
		{
			xcList[xcList.length] = srcPort.workxcList[i];
		}				
		for(var i=0,iLength=srcPort.xcList.length;i<iLength;i++)
		{
			xcList[xcList.length] = srcPort.xcList[i];
		}
		
		
		
		for(var i=0,iLength=xcList.length;i<iLength;i++)
		{
			var xc = xcList[i];	

			if(SERVICE_ODU0 != xc.serviceLevel )
			{
				continue;
			}		
			
			var biIndex = getBidirectionalIdx(xcList,xc);
			var row = getRowFromXC(xc);
						
			
			if(biIndexMap[i] != null && viewXCType == XC_JOIN)
			{
				continue;
			}
			
			
			if(biIndex == -1)//              
	  		{
	 			addParamTag(row, "direction", UNI_DIRECTION);
	 			addParamTag(row, "biXCID","-1");
	 		}
	 		else if(viewXCType == XC_JOIN)//              JOIN               ID   biXCID
	 		{
	 			biIndexMap[biIndex] = biIndex;//       
	 			addParamTag(row, "direction",BID_DIRECTION);
	 			addParamTag(row, "biXCID",xcList[biIndex].xcid);//       ID		
	 		}
	 		else//           EXPAND
	 		{
	 			addParamTag(row, "direction", UNI_DIRECTION);
	 			addParamTag(row, "biXCID","-1");
	 		}
	 		
	 		
	 		if(xcList[i].pgid != 0)
	  		{
	  			addParamTag(row, "pgid", xcList[i].pgid);
	  			addParamTag(row, "workXCID", xcList[i].xcid);  				
	  		}
	 		
	 		
	 		if( 0 == srcPort.portId)
	 		{
	 			var isShowFlag = false;
	 			
	 			if(srcPort.selectTs[0].parent.slotId == xc.srcSlot && srcPort.selectTs[0].portid == xc.srcPort)
	 			{
	 				isShowFlag = true;
	 			}
	 			
	 			if(srcPort.selectTs[0].parent.slotId == xc.snkSlot && srcPort.selectTs[0].portid == xc.snkPort)
	 			{
	 				isShowFlag = true;
	 			}
	 			
	 			if(!isShowFlag)
	 			{
	 				continue;
	 			}
	 		}
	 		
			var xcPath = (srcPort.slotId == xc.srcSlot && srcPort.portId == xc.srcPort)?xc.srcPath:xc.snkPath;
	 		if(0 != srcPort.portId )
	 		{
	 			if(srcPort.selectTs.length == srcPort.timeSlotList.length)
	 			{
	 				if(row != null)
					{
						dinterface.rows[dinterface.rows.length] = row;
						continue;
					}
	 			}
	 			else
	 			{

	 				var isFilter = true;
	 				for(var j = 0,jLength=srcPort.selectTs.length;j<jLength;j++)
	 				{
	 					if(srcPort.selectTs[j].snkOccupyPath == xcPath || srcPort.selectTs[j].srcOccupyPath == xcPath)
	 					{
	 						isFilter = false;
	 					}
	 				}
	 				
	 				if(isFilter)
	 				{
	 					continue;
	 				}
	 			}	
	 			
	 		}
	 		
	 		
			if(row != null)
			{
				dinterface.rows[dinterface.rows.length] = row;
			}
		
			
		}
}


function showHighLevelWorkXCInTable(dinterface,srcPort)
{
		var biIndexMap = new Object();//        
		var xcList = [];
	
		for(var i=0,iLength=srcPort.workxcList.length;i<iLength;i++)
		{
			xcList[xcList.length] = srcPort.workxcList[i];
		}
		
		for(var i=0,iLength=srcPort.xcList.length;i<iLength;i++)
		{
			xcList[xcList.length] = srcPort.xcList[i];
		}
		
		
			
		for(var i=0,iLength=xcList.length;i<iLength;i++)
	 	{
	 		var xc = xcList[i];
			
			if(SERVICE_ODU0 == xc.serviceLevel)
			{
				continue;
			}
			
			var isShowFlag = false;
			var xcPath = (srcPort.slotId  == xc.srcSlot && srcPort.portId  == xc.srcPort)? xc.srcPath:xc.snkPath;	
			
			if(0 != srcPort.portId)
			{
			for(var j = 0,jLength=srcPort.selectTs.length;j<jLength;j++)
	 		{
	 			if(srcPort.selectTs[j].srcOccupyPath == xcPath || srcPort.selectTs[j].snkOccupyPath == xcPath)
	 			{
	 				isShowFlag = true;
	 				break;
	 			}
	 		}
	 		}
	 		
	 		if(0 == srcPort.portId)
	 		{
	 			
	 			if(srcPort.selectTs[0].parent.slotId == xc.srcSlot && srcPort.selectTs[0].portid == xc.srcPort)
	 			{
	 				isShowFlag = true;
	 			}
	 			
	 			if(srcPort.selectTs[0].parent.slotId == xc.snkSlot && srcPort.selectTs[0].portid == xc.snkPort)
	 			{
	 				isShowFlag = true;
	 			}
	 			
	 		}
	 				
			
			if(!isShowFlag)
			{
				continue;
			}
				
			var biIndex = getBidirectionalIdx(xcList,xc);
			var row = getRowFromXC(xc);
						
			
			if(biIndexMap[i] != null && viewXCType == XC_JOIN)
			{
				continue;
			}
			
			
			if(biIndex == -1)//  
	  		{
	 			addParamTag(row, "direction", UNI_DIRECTION);
	 			addParamTag(row, "biXCID","-1");
	 		}
	 		else if(viewXCType == XC_JOIN)//              JOIN               ID   biXCID
	 		{
	 			biIndexMap[biIndex] = biIndex;//       
	 			addParamTag(row, "direction",BID_DIRECTION);
	 			addParamTag(row, "biXCID",xcList[biIndex].xcid);//       ID		
	 		}
	 		else//           EXPAND
	 		{
	 			addParamTag(row, "direction", UNI_DIRECTION);
	 			addParamTag(row, "biXCID","-1");
	 		}
	 		
	 		if(xcList[i].pgid != 0)
	  		{
	  			addParamTag(row, "pgid", xcList[i].pgid);
	  			addParamTag(row, "workXCID", xcList[i].xcid);  	
	  		}	 		
	 			
	 			
	 		if(row != null)
			{
				dinterface.rows[dinterface.rows.length] = row;
			}
		}
}


function showProtectXCInTable(dinterface,srcPort)
{
	for(var i=0,iLength=srcPort.protectxcList.length;i<iLength;i++)
	{
	 	var xc = srcPort.protectxcList[i];
	 	var isPgidExsit = false;
	 	for(var j = 0,jLength = dinterface.rows.length;j<jLength;j++)
	 	{
	 		var row = dinterface.rows[j];
	 		
	 		if(row["pgid"]!= null &&row["pgid"].value == xc.pgid)
	 		{
	 			addParamTag(row, "protectXCID", xc.xcid);
	 			addParamTag(row, "sncpType",xc.sncpType);
	 			row["protectionSlotID"].value = xc.srcSlot;
	 			row["protectionShowSlotID"].value = xc.showSrcSlot;
	 			row["protectionBoardName"].value = xc.srcBoardName;
	 			row["protectionShowPortID"].value = xc.showSrcPort;
	 			row["protectionPortID"].value = xc.srcPort;
	 			row["protectionPath"].value = xc.srcPath;
	 			row["protectDelayTime"].value = xc.delayTime;
	 			row["revertiveMode"].value = xc.revertiveMode;
	 			row["wtrTime"].value = xc.wtrTime;
	 			row["sdTriggerFlag"].value = xc.sdTriggerFlag;
	 			row["protectType"].value = xc.protectType;
	 			row["protectionSetting"].value = PORTECTION_OPEN;
	 			isPgidExsit = true;
	 			break;
	 		}
	 	}
	 	
	 	if(!isPgidExsit)
	 	{	 		
	 		var isAdd = false;			
			for(var j = 0,jLength=srcPort.selectTs.length;j<jLength;j++)
	 		{
	 			if(srcPort.portId != 0&& srcPort.selectTs[j].srcOccupyPath == xc.srcPath 
	 			 && srcPort.slotId == xc.srcSlot && srcPort.portId == xc.srcPort)
	 			{
	 				isAdd = true;
	 				break;
	 			}
	 			
	 			if(srcPort.portId == 0&& srcPort.selectTs[j].portid == xc.srcPort
	 			 && srcPort.slotId == xc.srcSlot)
	 			{
	 				isAdd = true;
	 				break;
	 			}
	 		}					
			if(!isAdd)
			{
				continue;
			}
			
	 		
	 		for(var j=0,jLength=srcPort.workxcList.length;j<jLength;j++)
	 		{
	 			var workxc = srcPort.workxcList[j];
	 			if(workxc.pgid == xc.pgid)
	 			{
	 				var row = getRowFromXC(workxc);
	 				addParamTag(row, "direction", UNI_DIRECTION);
	 				addParamTag(row, "workXCID", workxc.xcid);  
	 				addParamTag(row, "protectXCID", xc.xcid);
	 				addParamTag(row, "sncpType",xc.sncpType);	
	 				row["protectionSlotID"].value = xc.srcSlot;
	 				row["protectionShowSlotID"].value = xc.showSrcSlot;
	 				row["protectionBoardName"].value = xc.srcBoardName;
	 				row["protectionShowPortID"].value = xc.showSrcPort;
	 				row["protectionPortID"].value = xc.srcPort;
	 				row["protectionPath"].value = xc.srcPath;
	 				row["protectDelayTime"].value = xc.delayTime;
	 				row["revertiveMode"].value = xc.revertiveMode;
	 				row["wtrTime"].value = xc.wtrTime;
	 				row["sdTriggerFlag"].value = xc.sdTriggerFlag;
	 				row["protectType"].value = xc.protectType
	 				row["protectionSetting"].value = PORTECTION_OPEN;
	 				dinterface.rows[dinterface.rows.length] = row;
	 				break;
	 			}
	 			
	 		}
	 		
	 	}
	}
}

function showXCInTable()
{
	var srcPort = null;
	var dinterface = new DataInterface();
	
	if(graph.srcPort != null)
	{
		srcPort = graph.srcPort;

	}

	if(srcPort !=null )
	{		
		showOdu0WorkXCInTable(dinterface,srcPort);		
		/*
		if(0 != srcPort.portId && srcPort.tsmode == TSMODE_RANDOM)
		{	 		
	 		showHighLevelWorkXCInTable(dinterface,srcPort);
		}*/
		
		showHighLevelWorkXCInTable(dinterface,srcPort);
		showProtectXCInTable(dinterface,srcPort);
		
	}
	

	
	st.clearTableData();
	createXCTableBody(st, window.tableconf[0], dinterface, RESOURCE);
	setTableEditStyle();
	if(st.getDataRowLength() > 0)
	{
		$("expandbtn").disabled = !btnRightArr.querybtn.right;
	}
	else
	{
		$("expandbtn").disabled = true;
	}
}


function filterConsecutiveTsInTable()
{
	for(var i=0,iLength=srcPort.xcList.length;i<iLength;i++)
	 		{
	 			var xc = srcPort.xcList[i];
			
				if(SERVICE_ODU0 == xc.serviceLevel)
				{
					continue;
				}	
				
				var isShowFlag = false;
				var xcTS = (srcPort.slotId  == xc.srcSlot && srcPort.portId  == xc.srcPort)? xc.srcTs:xc.snkTs;	
				var gradeArgs = xcTS.split("/");
				var args = gradeArgs[gradeArgs.length-1].split(":");
				
				if(args[0] == "ODU1")
				{
					var index = ODU1_EQU*(parseInt(args[1])-1);
					isShowFlag = srcPort.timeSlotList[index].nodetype == NODE_TYPE_SRC 
						|| srcPort.timeSlotList[index+1].nodetype == NODE_TYPE_SRC;
					
				}
				
				
				if(args[0] == "ODU2")
				{
					var index = ODU2_EQU*(parseInt(args[1])-1);
					isShowFlag = srcPort.timeSlotList[index].nodetype == NODE_TYPE_SRC 
						|| srcPort.timeSlotList[index+1].nodetype == NODE_TYPE_SRC
						|| srcPort.timeSlotList[index+2].nodetype == NODE_TYPE_SRC
						|| srcPort.timeSlotList[index+3].nodetype == NODE_TYPE_SRC
						|| srcPort.timeSlotList[index+4].nodetype == NODE_TYPE_SRC
						|| srcPort.timeSlotList[index+5].nodetype == NODE_TYPE_SRC
						|| srcPort.timeSlotList[index+6].nodetype == NODE_TYPE_SRC
						|| srcPort.timeSlotList[index+7].nodetype == NODE_TYPE_SRC;
					
				}
				
				if(args[0] == "ODU3")
				{
					isShowFlag = srcPort.selectTs.length == ODU3_EQU;
				}
			
				
				if(!isShowFlag)
				{
					continue;
				}
				
				var biIndex = getBidirectionalIdx(srcPort.xcList,xc);
				var row = getRowFromXC(xc);
						
			
				if(biIndexMap[i] == 1)
				{
					continue;
				}
			
			
				if(biIndex == -1)//  
	  			{
	 				addParamTag(row, "direction", UNI_DIRECTION);
	 				addParamTag(row, "biXCID","-1");
	 			}
	 			else
	 			{
	 				biIndexMap[biIndex] = 1;//       
	 				addParamTag(row, "direction",BID_DIRECTION);
	 				addParamTag(row, "biXCID",srcPort.xcList[i].xcid);//       ID
	 				if(xcList[i].pgid != 0)
	  				{	  				
	  					addParamTag(row, "pgid", xcList[i].pgid);
	  				}
	 			}	 		
	 			
	 			
	 			if(row != null)
				{
					dinterface.rows[dinterface.rows.length] = row;
				}
	 			
	 		}
}



function setBranchProtectTsSelected(tsShape,rows)
{
	for(var i = 0,iLength = rows.length;i<iLength;i++)
	{
		var row = rows[i];
		var protectPort = row["protectionPortID"].value;
			
		
							
			if(tsShape.portid == protectPort)
			{
				tsShape.nodetype = NODE_TYPE_PROTECTION;
				tsShape.setSelected(true);
				var bgTsShape = getSVGElement("bg_"+tsShape.shapeid);
				if(bgTsShape != null)
				{
					bgTsShape.setAttribute("class", "bg_selected_"+tsShape.getStyle());
				}	
			}

	}
}



function setBranchSnkTsSelected(tsShape,rows)
{
	for(var i = 0,iLength = rows.length;i<iLength;i++)
	{
		var row = rows[i];
		var snkPort;
			
		
		if(row["direction"].value == UNI_DIRECTION)
		{
			if( row["snkSlotID"].value == tsShape.parent.slotId)
			{
				snkPort = row["snkPortID"].value;
			}
			else
			{
				continue;
			}
		}
		
		if(row["direction"].value == BID_DIRECTION)
		{
			if( row["snkSlotID"].value == tsShape.parent.slotId )
			{
				snkPort = row["snkPortID"].value;
			}
			else
			{
				snkPort = row["srcPortID"].value;
			}
		}
		
							
			if(tsShape.portid == snkPort)
			{
				tsShape.nodetype = NODE_TYPE_SNK;
				tsShape.setSelected(true);
				var bgTsShape = getSVGElement("bg_"+tsShape.shapeid);
				if(bgTsShape != null)
				{
					bgTsShape.setAttribute("class", "bg_selected_"+tsShape.getStyle());
				}	
			}

	}
}

function setRandomSnkTsSelected(portShape,rows)
{
	for(var i = 0,iLength = rows.length;i<iLength;i++)
	{
		var row = rows[i];
		var snkPath;
		
		if(row["direction"].value == UNI_DIRECTION)
		{
			if( row["snkSlotID"].value == portShape.slotId && row["snkPortID"].value == portShape.portId)
			{
				snkPath = row["snkPath"].value;
			}
			else
			{
				continue;
			}
		}
		
		if(row["direction"].value == BID_DIRECTION)
		{
			if( row["snkSlotID"].value == portShape.slotId && row["snkPortID"].value == portShape.portId)
			{
				snkPath = row["snkPath"].value;
			}
			else
			{
				snkPath = row["srcPath"].value;
			}
		}
		
		for(var j = 0, jlen = portShape.timeSlotList.length; j < jlen; j++)
		{
			var tsShape = portShape.timeSlotList[j];
								
			if(tsShape.snkOccupyPath == snkPath)
			{
				tsShape.nodetype = NODE_TYPE_SNK;
				tsShape.setSelected(true);
				var bgTsShape = getSVGElement("bg_"+tsShape.shapeid);
				if(bgTsShape != null)
				{
					bgTsShape.setAttribute("class", "bg_selected_"+tsShape.getStyle());
				}	
			}
		}
	}
}



function setProtectSnkTsSelected(portShape,rows)
{
	for(var i = 0,iLength = rows.length;i<iLength;i++)
	{
		var row = rows[i];
		var protectPath = row["protectionPath"].value;
			
		for(var j = 0, jlen = portShape.timeSlotList.length; j < jlen; j++)
		{
			var tsShape = portShape.timeSlotList[j];
								
			if(tsShape.srcOccupyPath == protectPath)
			{
				tsShape.nodetype = NODE_TYPE_PROTECTION;
				tsShape.setSelected(true);
				var bgTsShape = getSVGElement("bg_"+tsShape.shapeid);
				if(bgTsShape != null)
				{
					bgTsShape.setAttribute("class", "bg_selected_"+tsShape.getStyle());
				}	
			}
		}
	}
}


function showSnkPortInGraph(key,snkDir,rows)
{
	for(var i = 0,ilen = snkDir.portShapeList.length; i < ilen; i++)
			{
				var portShape = snkDir.portShapeList[i];
				
				
				if(key == (portShape.slotId + "-" +portShape.portId))
				{
					graph.snkPort = portShape;
					portShape.nodetype = NODE_TYPE_SNK;
					portShape.drawTimeslots();					
					getSVGElement("bg_"+portShape.shapeid).setAttribute("class", "bg_"+portShape.getStyle());
					queryXC(portShape);
					graph.snkPort = portShape;	
						
					for(var j = 0, jlen = portShape.timeSlotList.length; j < jlen; j++)
					{
						var tsShape = portShape.timeSlotList[j];
						var bgTsShape = getSVGElement("bg_"+tsShape.shapeid);
						if(bgTsShape != null)
						{
							bgTsShape.setAttribute("class", "bg_"+tsShape.getStyle());	
						}
											
			
					}
					
					setRandomSnkTsSelected(portShape,rows);
				}				
				
				if(portShape.portId == 0)
				{
					var args =key.split("-");
					
					if(args[0] == portShape.slotId)
					{
						graph.snkPort = portShape;
						portShape.nodetype = NODE_TYPE_SNK;
						portShape.drawTimeslots();
						getSVGElement("bg_"+portShape.shapeid).setAttribute("class", "bg_"+portShape.getStyle());
					
						queryXC(portShape);	
						graph.snkPort = portShape;
						
						for(var j = 0, jlen = portShape.timeSlotList.length; j < jlen; j++)
						{
							var tsShape = portShape.timeSlotList[j];
							var bgTsShape = getSVGElement("bg_"+tsShape.shapeid);
							if(bgTsShape != null)
							{
								bgTsShape.setAttribute("class", "bg_"+tsShape.getStyle());	
							}
							
							setBranchSnkTsSelected(tsShape,rows);						
			
						}
					}
					
					
				}
			}
			
			graph.snkDirection = snkDir;

}





function showProtectPortInGraph(key,protectDir,rows)
{
	if(protectDir == null)
	{
		return;
	}
	
	for(var i = 0,ilen = protectDir.portShapeList.length; i < ilen; i++)
	{
				var portShape = protectDir.portShapeList[i];
				
				if(key == (portShape.slotId + "-" +portShape.portId))
				{
					portShape.nodetype = NODE_TYPE_PROTECTION;
					portShape.drawTimeslots();					
					getSVGElement("bg_"+portShape.shapeid).setAttribute("class", "bg_"+portShape.getStyle());
					queryXC(portShape);
					graph.protectPort = portShape;	
						
					for(var j = 0, jlen = portShape.timeSlotList.length; j < jlen; j++)
					{
						var tsShape = portShape.timeSlotList[j];
						var bgTsShape = getSVGElement("bg_"+tsShape.shapeid);
						if(bgTsShape != null)
						{
							bgTsShape.setAttribute("class", "bg_"+tsShape.getStyle());	
						}
											
			
					}
					
					setProtectSnkTsSelected(portShape,rows);
				}				
				
				if(portShape.portId == 0)
				{
					var args =key.split("-");
					
					if(args[0] == portShape.slotId)
					{
					
						portShape.nodetype = NODE_TYPE_PROTECTION;
						portShape.drawTimeslots();
						getSVGElement("bg_"+portShape.shapeid).setAttribute("class", "bg_"+portShape.getStyle());
					
						queryXC(portShape);
						graph.protectPort = portShape;	
						
						
						for(var j = 0, jlen = portShape.timeSlotList.length; j < jlen; j++)
						{
							var tsShape = portShape.timeSlotList[j];
							var bgTsShape = getSVGElement("bg_"+tsShape.shapeid);
							if(bgTsShape != null)
							{
								bgTsShape.setAttribute("class", "bg_"+tsShape.getStyle());	
							}
							
							setBranchProtectTsSelected(tsShape,rows);						
			
						}
					}
					
					
				}
			}
			
			graph.protectDirection = protectDir;

}

/**
 *                       
 */
function showSnkDirInGraph(srcPort,rows)
{
	var snkPortMap= new Object();
	var snkPortCount = 0;
	for(var i = 0,iLength = rows.length;i<iLength;i++)
	{
		var row = rows[i];
		
		if(row["direction"].value == UNI_DIRECTION && srcPort.portId!=0)
		{
			if(srcPort.slotId != row["srcSlotID"].value || srcPort.portId != row["srcPortID"].value)
			{
				continue;
			}
			
			var key = row["snkSlotID"].value+"-"+ row["snkPortID"].value;
			var value = 1;
			if(row["protectionSetting"].value == PORTECTION_OPEN)	
			{
				value = row["protectionSlotID"].value+"-"+ row["protectionPortID"].value;
			}			
			if( key != srcPort.slotId + "-" + srcPort.portId)//        
			{
				if(snkPortMap[key] == null)//  MAP          
				{
					snkPortCount ++;
					snkPortMap[key] = value;
				}			
			}
			
		}
		
		
		if(row["direction"].value == UNI_DIRECTION && srcPort.portId==0)
		{
			if(srcPort.slotId != row["srcSlotID"].value )
			{
				continue;
			}
			
			var key = row["snkSlotID"].value+"-"+ row["snkPortID"].value;
			var value = 1;
			if(row["protectionSetting"].value == PORTECTION_OPEN)	
			{
				value = row["protectionSlotID"].value+"-"+ row["protectionPortID"].value;
			}			

			if(key != srcPort.slotId + "-" + srcPort.selectTs[0].portid)//   
			{
				if(snkPortMap[key] == null)//  MAP          
				{
					snkPortCount ++;
					snkPortMap[key] = value;
				}
			}
		}
		
		if(row["direction"].value == BID_DIRECTION)
		{
			var key = row["snkSlotID"].value+"-"+ row["snkPortID"].value;
			var value = 1;
			if(row["protectionSetting"].value == PORTECTION_OPEN)	
			{
				value = row["protectionSlotID"].value+"-"+ row["protectionPortID"].value;
			}				
			
			if(srcPort.portId!=0 && key != srcPort.slotId + "-" + srcPort.portId)
			{
				if(snkPortMap[key] == null)//  MAP          
				{
					snkPortCount ++;
					snkPortMap[key] = value;
				}			
			}
			else if(srcPort.portId ==0 && key != srcPort.slotId + "-" + srcPort.selectTs[0].portid)//   
			{
				if(snkPortMap[key] == null)//  MAP          
				{
					snkPortCount ++;
					snkPortMap[key] = value;
				}			
			}
			else
			{
				key = row["srcSlotID"].value+"-"+ row["srcPortID"].value;
				if(snkPortMap[key] == null)//  MAP          
				{
					snkPortCount ++;
					snkPortMap[key] = value;
				}
			}
		}

		
		
		
	}
	

	
	if(snkPortCount == 1)
	{
		for ( var key in snkPortMap)
		{
			var value  = snkPortMap[key];
			var snkDirID = graph.portDirMap[key];
			var protectDirID = graph.portDirMap[value];
			if(snkDirID == null)
			{
				continue;
			}
			
			var snkDir = graph.getDirectionByID(snkDirID);
			snkDir.nodetype = NODE_TYPE_SNK;
			getSVGElement("bg_"+snkDir.shapeid).setAttribute("class", "bg_"+snkDir.getStyle());
			graph.snkDirection = snkDir;
			/*
			var protectDir = null;
			if(protectDirID != null)
			{
				protectDir = graph.getDirectionByID(protectDirID);
				protectDir.nodetype = NODE_TYPE_PROTECTION;
				protectDir.drawPorts();
				getSVGElement("bg_"+protectDir.shapeid).setAttribute("class", "bg_"+protectDir.getStyle());
			}
			
			showSnkPortInGraph(key,snkDir,rows);
			showProtectPortInGraph(value,protectDir,rows);*/
		}
			
			
			
	}
	else if(snkPortCount > 1)
	{
		var showFlag = true;//           
		for ( var key in snkPortMap)
		{	
			var dirID = graph.portDirMap[key];
			if(dirID == null)
			{
				continue;
			}
			var dir = graph.getDirectionByID(dirID);
			dir.drawStar();
			
			if(showFlag)
			{
				dir.nodetype = NODE_TYPE_SNK;
				
				getSVGElement("bg_"+dir.shapeid).setAttribute("class", "bg_"+dir.getStyle());
				
			
				graph.snkDirection = dir;
				showFlag = false;
			}
		}
	}
}





function create()
{
	$("createbtn").disabled = true;
	$("deletebtn").disabled = true;
	$("activebtn").disabled = true;
	$("inactivebtn").disabled = true;
	$("applybtn").disabled = !btnRightArr.createbtn.right;
	$("expandbtn").disabled = true;
	
	graph.editMode = GRAPH_MODE_CREATE;
	graph.clear();
	st.clearTableData();
	var rowData = getDefaultData();	
	createXCTableBody(st, window.tableconf[0], rowData, RESOURCE);
	setTableEditStyle();
	
	
}


/**
 *                               
 */
function autoRandomTs(curPort)
{
		  var rowindex = 0;
		  var serviceLevel = st.getCellStoreValue(rowindex, "serviceLevel", "serviceLevel");
    	var direction = st.getCellStoreValue(rowindex, "direction", "direction");
    	var oduFlexTimeSlots = st.getCellStoreValue(rowindex, "oduFlexTimeSlots", "oduFlexTimeSlots");
    	var odu0Count = 0;
    	
    
    	
if(serviceLevel != SERVICE_ODUFLEX)
    	{
    		if( direction == UNI_DIRECTION && curPort.nodetype == NODE_TYPE_SRC)
    		{
    			for(var i= 0,iLength = curPort.timeSlotList.length;i<iLength&& odu0Count < EQU_OBJ[serviceLevel];i++)
    			{
    				curPort.timeSlotList[i].nodetype = curPort.nodetype;
    				curPort.timeSlotList[i].setSelected(true);
    				odu0Count ++;
    			}	
    		}
    		else
    		{
    			for(var i= 0,iLength = curPort.timeSlotList.length;i<iLength&& odu0Count < EQU_OBJ[serviceLevel];i++)
    			{
    				if(curPort.timeSlotList[i].snkOccupyPath == 0)
    				{
    					curPort.timeSlotList[i].nodetype = curPort.nodetype;
    					curPort.timeSlotList[i].setSelected(true);
    					odu0Count ++;
    				}
    			}	
    			
    			if(odu0Count < EQU_OBJ[serviceLevel] && direction == BID_DIRECTION)
    			{
    				alert(RESOURCE["notenoughres"]);
    			}
    		
    		}
    	}
    	
    	if(serviceLevel == SERVICE_ODUFLEX)
    	{
    		if( direction == UNI_DIRECTION && curPort.nodetype == NODE_TYPE_SRC)
    		{
    			for(var i= 0,iLength = curPort.timeSlotList.length;i<iLength&& odu0Count < oduFlexTimeSlots;i++)
    			{
    				curPort.timeSlotList[i].nodetype = curPort.nodetype;
    				curPort.timeSlotList[i].setSelected(true);
    				odu0Count ++;
    			}	
    		}
    		else
    		{
    			for(var i= 0,iLength = curPort.timeSlotList.length;i<iLength&& odu0Count < oduFlexTimeSlots;i++)
    			{
    				if(curPort.timeSlotList[i].snkOccupyPath == 0)
    				{
    					curPort.timeSlotList[i].nodetype = curPort.nodetype;
    					curPort.timeSlotList[i].setSelected(true);
    					odu0Count ++;
    				}
    			}	
    			
    			if(odu0Count < oduFlexTimeSlots && direction == BID_DIRECTION)
    			{
    				alert(RESOURCE["notenoughres"]);
    			}
    		
    		}
    	}
}


function autoMoreConsecutiveTs(tsShape)
{
	
}



function clearGraph()
{
	graph.clear();	
	graph.editMode = GRAPH_MODE_VIEW;
	st.clearTableData();
	
	$("applybtn").disabled = true;
	$("deletebtn").disabled = true;
	$("activebtn").disabled = true;
	$("inactivebtn").disabled = true;
	$("createbtn").disabled = !btnRightArr.createbtn.right;
	
	$("expandbtn").disabled = true;
	$("expandbtn").value=RESOURCE["expand"];
	viewXCType = XC_JOIN;
}



function activeXC(isActive)
{
	if(isActive && !confirm(RESOURCE["confirmActive"]))
	{
		return;
	}
	
	if(!isActive && !confirm(RESOURCE["confirmInactive"]))
	{
		return;
	}
	
	var xml = createActiveXML(isActive);
	
	if(null ==xml)
	{
		if(isActive)
		{
			alert(RESOURCE["allactive"]);
		}
		else
		{
			alert(RESOURCE["allinactive"]);
		}
		return;	
	}

	$("activebtn").disabled = true;
	$("inactivebtn").disabled = true;
	$("deletebtn").disabled = true;
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_WDM_ACTIVATE_GRAPHEXC;
  loadXMLdoc(url, "POST", false, activeXCCallBack, isActive, "inputdata=" + xml);
}


function createActiveXML(isActive)
{
    var root = new inputxml("datainterface");
    var firstlevel = new tagElement("bussiness-params");
    
    var inactiveCount = 0;
    var activeCount = 0;
    var selectedRows = st.getSelectedRows();

   for(var i = 0;i < selectedRows.length;i++)
    {
    var rowindex = selectedRows[i];
    
    var secondlevel = new tagElement("row-params");
    var serviceLevel = st.getCellStoreValue(rowindex, "serviceLevel", "serviceLevel");
    var srcSlotID = st.getCellCurrentValue(rowindex, "srcSlotID", "srcSlotID");
    var srcPortID = st.getCellStoreValue(rowindex, "srcPortID", "srcPortID");
    var srcPath = st.getCellStoreValue(rowindex, "srcPath", "srcPath");
    var snkSlotID = st.getCellStoreValue(rowindex, "snkSlotID", "snkSlotID");
    var snkPortID = st.getCellStoreValue(rowindex, "snkPortID", "snkPortID");
    var snkPath = st.getCellStoreValue(rowindex, "snkPath", "snkPath");
    var direction = st.getCellStoreValue(rowindex, "direction", "direction");
    var activeState = st.getCellStoreValue(rowindex, "activeStatus", "activeStatus");
    var xcID = st.getCellStoreValue(rowindex, "xcid", "xcid");
    var biXCID = st.getCellStoreValue(rowindex, "biXCID", "biXCID");
    var protectionSetting = st.getCellStoreValue(rowindex, "protectionSetting", "protectionSetting");
    var serviceType = st.getCellStoreValue(rowindex, "serviceType", "serviceType");
    var oduFlexTimeSlots = st.getCellStoreValue(rowindex, "oduFlexTimeSlots", "oduFlexTimeSlots");
    var oduflexRateSlot = st.getCellStoreValue(rowindex, "oduflexRateSlot", "oduflexRateSlot");
    
    if(isActive && activeState == 1)
    {
    	continue;
    }
    
    if(!isActive && activeState == 0)
    {
    	continue;
    }
    
    addTagElement(secondlevel, "neid", winurlobj["neid"]);
    addTagElement(secondlevel, "serviceLevel", serviceLevel);
    addTagElement(secondlevel, "srcSlotID", srcSlotID);
    addTagElement(secondlevel, "srcPortID", srcPortID);
    addTagElement(secondlevel, "srcPath", srcPath);
    addTagElement(secondlevel, "snkSlotID", snkSlotID);
    addTagElement(secondlevel, "snkPortID", snkPortID);
    addTagElement(secondlevel, "snkPath", snkPath);
    addTagElement(secondlevel, "direction", direction);
    addTagElement(secondlevel, "activeState", activeState);
    addTagElement(secondlevel, "xcID", xcID);
    

    
     if(SERVICE_ODUFLEX != serviceLevel)
    {
    	addTagElement(secondlevel, "serviceType", "-");
    	addTagElement(secondlevel, "timeslot", "-");
    	addTagElement(secondlevel, "svcRate", "-"); 
    }
    else
    {
    	addTagElement(secondlevel, "serviceType", serviceType);
    	addTagElement(secondlevel, "timeslot", oduFlexTimeSlots);
    	addTagElement(secondlevel, "svcRate", oduflexRateSlot);
    }
    
    if(biXCID != null)
    {
    	addTagElement(secondlevel, "biXCID", biXCID);
    }
    
    
    if(PORTECTION_OPEN == protectionSetting)
    {
    	var protectSlotID = st.getCellCurrentValue(rowindex, "protectionSlotID", "protectionSlotID");
    	var protectPortID = st.getCellStoreValue(rowindex, "protectionPortID", "protectionPortID");
    	var protectPath = st.getCellStoreValue(rowindex, "protectionPath", "protectionPath");
    	var sncpType = st.getCellStoreValue(rowindex, "sncpType", "sncpType");
    	var revertiveMode = st.getCellStoreValue(rowindex, "revertiveMode", "revertiveMode");
    	var wtrTime = st.getCellStoreValue(rowindex, "wtrTime", "wtrTime");
    	var delayTime = st.getCellStoreValue(rowindex, "delayTime", "delayTime");
    	var protectDelayTime = st.getCellStoreValue(rowindex, "protectDelayTime", "protectDelayTime");
    	var sdTriggerFlag = st.getCellStoreValue(rowindex, "sdTriggerFlag", "sdTriggerFlag");
    	var pgid = st.getCellStoreValue(rowindex, "pgid", "pgid");
    	var protectXCID = st.getCellStoreValue(rowindex, "protectXCID", "protectXCID");
    	var workXCID = st.getCellStoreValue(rowindex, "workXCID", "workXCID");
    	var otnLevel = st.getCellStoreValue(rowindex, "otnLevel", "otnLevel");
    	
    	
    	
    	addTagElement(secondlevel, "protectSlotID", protectSlotID);
    	addTagElement(secondlevel, "protectPortID", protectPortID);
    	addTagElement(secondlevel, "protectPath", protectPath);
    	
    	addTagElement(secondlevel, "sncpType", sncpType);
    	addTagElement(secondlevel, "revertiveMode", revertiveMode);
    	addTagElement(secondlevel, "wtrTime", wtrTime);
    	addTagElement(secondlevel, "delayTime", delayTime);
    	addTagElement(secondlevel, "protectDelayTime", protectDelayTime);
    	addTagElement(secondlevel, "sdTriggerFlag", sdTriggerFlag);
    	addTagElement(secondlevel, "sncpType", sncpType);
    	addTagElement(secondlevel, "pgid", pgid);
    	addTagElement(secondlevel, "protectXCID", protectXCID);
    	addTagElement(secondlevel, "workXCID", workXCID);
    	addTagElement(secondlevel, "otnLevel", otnLevel);
    	
    }
    
    if(isActive)
    {
    	inactiveCount++;
    }
    else
    {
    	activeCount++;
    }
    
    
    firstlevel.appendChild(secondlevel); 
    }
    
    
    if(isActive && inactiveCount == 0)
    {
    	return null;
    }
    
    if(!isActive && activeState == 0)
    {
    	return null;
    }

       
    root.getRoot().appendChild(firstlevel);
    return root.toString();
}



function activeXCCallBack(doc,isActive)
{
    $("activebtn").disabled = !btnRightArr.createbtn.right;
    $("inactivebtn").disabled = !btnRightArr.createbtn.right;
    $("deletebtn").disabled = !btnRightArr.createbtn.right;
    
    var data = EncapsulateData(doc);

    if (data.getSErrorCode() == 0 ) 
    {
    	 var selectedRows = st.getSelectedRows();
    	 for(var i = 0;i < selectedRows.length;i++)
    	{
   		 var rowindex = selectedRows[i];
    		if(isActive)
    		{
    			st.getCellShow(rowindex,"activeStatus").setValue(RESOURCE["active"]);
    			st.setCellValue(st.getCell(rowindex,"activeStatus"),"activeStatus","1");
    		}
    		else
    		{
    			st.getCellShow(rowindex,"activeStatus").setValue(RESOURCE["inactive"]);
    			st.setCellValue(st.getCell(rowindex,"activeStatus"),"activeStatus","0");
    		}
    	}
    	
    	showOperSuccessPage();
    	
    }
    
    
    var errArr = [];
    errArr[0] = "srcSlotID";
    showErrorDialog(data);

}










