var svgDoc = null;
var graph = null;

var st;
var winurlobj = getNeProperty(self);

var tsCount = 0;


var viewXCType = XC_JOIN;

var Graph = function()
{
	this.directionShapeList = new Array();
	this.rootElement = null;
	this.currentShape = null;//        
	this.lastMoveShape = null;
	this.lastMousedownTimeslot = null;
	this.srcDirection = null;
	this.snkDirection = null;
	this.protectDirection = null;
	this.srcPort = null;
	this.snkPort = null;
	this.protectPort = null;
	this.cursor = 0;
	this.editMode = GRAPH_MODE_VIEW;//    ,     
	this.portDirMap = new Object();//          
	this.currentEditDir = null;//                  NODE_TYPE_SRC = 1; NODE_TYPE_SNK = 2; NODE_TYPE_PROTECTION = 3;

	if(isIE9)
	{
		this.svgDoc = bussinessgraph.object.getSVGDocument();
		this.rootElement = svgDoc.rootElement;
	}
	else
	{
		this.rootElement = svgDoc.documentElement;
		svgDoc.oncontextmenu = function()
		{
			return false;
		}
	}

}

Graph.prototype.init = function() 
{
	this.rootElement.addEventListener("mousedown",this.doMousedown,false);
	this.rootElement.addEventListener("mouseover",this.doMouseover,false);
	this.rootElement.addEventListener("mouseup",this.doMouseup,false);
	this.rootElement.addEventListener("mouseout",this.doMouseout,false);
	
	getSVGElement("srctext").textContent = RESOURCE["source"];
	getSVGElement("snktext").textContent = RESOURCE["sink"];
	getSVGElement("protectiontext").textContent = RESOURCE["protection"];
	getSVGElement("freetext").textContent = RESOURCE["Idle"];
	getSVGElement("occupytext").textContent = RESOURCE["Occupied"];
	
}

Graph.prototype.getCurDirection = function() 
{
	if(this.currentEditDir == NODE_TYPE_SRC)
	{
		return this.srcDirection;
	}
	else if(this.currentEditDir == NODE_TYPE_SNK)
	{
		return this.snkDirection;
	}
    else if(this.currentEditDir == NODE_TYPE_PROTECTION)
    {
    	return this.protectDirection;
    }
    return this.srcDirection;
}

Graph.prototype.unSelect = function() 
{
	if(this.currentShape != null)
	{
		this.currentShape.setSelected(false);
		this.currentShape.ruleShape.removeShape();
		this.currentShape = null;	
	}
}

Graph.prototype.setSelected = function(shape) 
{
	this.currentShape = shape;
	this.currentShape.setSelected(true);
	this.rootElement.appendChild(this.currentShape.ruleShape.drawShape());		
}

Graph.prototype.flash = function() 
{
	if(this.currentShape != null)
	{
		var graphShape = getSVGElement(this.currentShape.shapeid);
		if(graphShape.className.baseVal.indexOf("selected")<0)
		{
			graphShape.setAttribute("class", "selected_"+this.currentShape.getStyle());		     
		}
		else
		{
			graphShape.setAttribute("class", this.currentShape.getStyle());
		}
	}
	window.setTimeout("graph.flash()", 1000);
		
}

Graph.prototype.drawInnerCircle = function() 
{
	var g = createElement("g");
	attr(g,{id:"g_innercircle"});
	var circle_1 = createElement("circle");
	attr(circle_1, {cx:CIRCLE_CX, cy:CIRCLE_CY, r:15});
	circle_1.setAttribute("class", "innercircle1");
	g.appendChild(circle_1);	
	
	this.rootElement.appendChild(g);
}


Graph.prototype.drawDirections = function() 
{
	var g = createElement("g");
	g.setAttribute("id", "svgGraph");
	for(var i = 0, len = this.directionShapeList.length; i < len; i++)
	{
		if(this.directionShapeList[i].startAngle != this.directionShapeList[i].endAngle)
		{
			var direction = this.directionShapeList[i].drawShape();
			g.appendChild(this.directionShapeList[i].drawBackground());	
			g.appendChild(this.directionShapeList[i].createTextElement());
			g.appendChild(direction);
		}
		
	}
	this.rootElement.appendChild(g);
}

Graph.prototype.removeDirections = function() 
{
	this.rootElement.removeChild(getSVGElement("svgGraph"));
	
	this.rootElement.removeChild(getSVGElement("dirTextPath"));
	var g = createElement("g");
	g.setAttribute("id", "dirTextPath");
	this.rootElement.appendChild(g);
}




Graph.prototype.getDirectionByID = function(id) 
{
	for(var i = 0, len = this.directionShapeList.length; i < len; i++)
	{
		
		var direction = this.directionShapeList[i];
		if(direction.id == id)
		{
			return direction;
		}
	}
	
	alert("direction not found!");
	return null;

}

Graph.prototype.getPortshapeByID = function(id) 
{
	for(var i = 0, len = this.directionShapeList.length; i < len; i++)
	{
		
		var direction = this.directionShapeList[i];
		for(var j = 0, jlen = direction.portShapeList.length; j < jlen; j++)
		{
			var portShape = direction.portShapeList[j];
			if( portShape.id == id)
			{
				return portShape;
			}
		}
	}
	
	alert("portShape not found!");
	return null;

}

Graph.prototype.getTimeslotShapeByID = function(portShapeID,slotShapeID) 
{
	var portShape = this.getPortshapeByID(portShapeID);
	
	for(var j = 0, jlen = portShape.timeSlotList.length; j < jlen; j++)
	{
		var timeslot = portShape.timeSlotList[j];
		if( timeslot.id == slotShapeID)
		{
			return timeslot;
		}
	}
	 
	alert("timeslot not found!");
	return null;

}

Graph.prototype.getShapeType = function(targetElementID)
{
	var targetType = "unknown";
	
	if(targetElementID.indexOf(OBJECT_TYPE[1])==0)
	{
		targetType = OBJECT_TYPE[1];
	}
	else if(targetElementID.indexOf(OBJECT_TYPE[2])==0)
	{
		targetType = OBJECT_TYPE[2];
	}
	else if(targetElementID.indexOf(OBJECT_TYPE[3])==0)
	{
		targetType = OBJECT_TYPE[3];
	}
	else if(targetElementID.indexOf(OBJECT_TYPE[5])>=0)
	{
		targetType = OBJECT_TYPE[5];
	}
	else if(targetElementID.indexOf(OBJECT_TYPE[6])>=0)
	{
		targetType = OBJECT_TYPE[6];
	}
	
	return targetType;
}

Graph.prototype.doMousedown = function(event) 
{
	var targetElement = event.target;
	var targetType = graph.getShapeType(targetElement.id);	
	
	if(targetType == OBJECT_TYPE[3])
	{
		var timeslotShapeID = targetElement.id.substring(OBJECT_TYPE[3].length,targetElement.id.length);
		var portShapeID = targetElement.parentNode.id.substring("g_timeslots_".length,targetElement.parentNode.id.length);
		var timeslotShape = graph.getTimeslotShapeByID(portShapeID,timeslotShapeID);		
		
		graph.lastMousedownTimeslot = timeslotShape;
		if(timeslotShape.isSelected)//unselect if it already selected
		{
			timeslotShape.nodetype = NODE_TYPE_FREE;
			timeslotShape.setSelected(false);
		}
		else
		{
			if(graph.currentShape == null)
			{
			}
			else
			{
				if(timeslotShape.isMulti == 0)
				{
					var tsList = timeslotShape.parent.timeSlotList;
					for(var i = 0,iLength =tsList.length;i<iLength;i++)
					{
						if(tsList[i].isSelected)
						{
							tsList[i].isSelected = false;
							var sector = getSVGElement("bg_"+tsList[i].shapeid);
							sector.setAttribute("class", "bg_"+tsList[i].getStyle());
						}
					}
				}
				
				if(graph.editMode != GRAPH_MODE_VIEW && timeslotShape.portid == 0)
				{
					var serviceLevel = st.getCellStoreValue(0, "serviceLevel", "serviceLevel");
					var direction = st.getCellStoreValue(0, "direction", "direction");
					var oduFlexTimeSlots = st.getCellStoreValue(0, "oduFlexTimeSlots", "oduFlexTimeSlots");
					
					if(timeslotShape.snkOccupyPath != 0 && direction == BID_DIRECTION)
					{
						alert(RESOURCE["resOccupied"]);
						return;
					}
					
					
					if(serviceLevel == SERVICE_ODU0 && timeslotShape.parent.selectTs.length >=1)
					{
						return;
					}
					
					if(serviceLevel == SERVICE_ODU1 && timeslotShape.parent.selectTs.length >=ODU1_EQU)
					{
						return;
					}
					
					if(serviceLevel == SERVICE_ODU2 && timeslotShape.parent.selectTs.length >=ODU2_EQU)
					{
						return;
					}
					
					if(serviceLevel == SERVICE_ODU3 && timeslotShape.parent.selectTs.length >=ODU3_EQU)
					{
						return;
					}
					
					if(serviceLevel == SERVICE_ODUFLEX && timeslotShape.parent.selectTs.length >=oduFlexTimeSlots)
					{
						return;
					}
					
					if(serviceLevel != SERVICE_ODU0 &&  timeslotShape.parent.selectTs.length == 0)
					{
						autoRandomTs(timeslotShape.parent);
						return;
					}
					
					
				}
	
				timeslotShape.nodetype = timeslotShape.parent.nodetype;
				timeslotShape.setSelected(true);
				if(timeslotShape.parent.parent != graph.currentShape)
				{
					graph.unSelect();
					graph.setSelected(timeslotShape.parent.parent);
				}
			}
		}
	}
	
}


Graph.prototype.doMouseover = function(event) 
{
	if( null == graph)
	{
		return;
	}
	var targetElement = event.target;
	var targetID = 	targetElement.id;
	
	if(targetID == "direction-1")//ID -1              
	{	
		return ;
	}
	
	if(targetID.indexOf("portPath")>=0 || targetID.indexOf("directionPath")>=0)
	{
		return;
	}
	
	var targetType = graph.getShapeType(targetID);
	if(targetType == OBJECT_TYPE[2] || targetType == OBJECT_TYPE[3] ||targetType == OBJECT_TYPE[1])
	{
		svgTip.ShowTooltip(event);
		svgTip.tipBox.setAttribute("fill", "white");			
	
	}
	

	if(targetType == OBJECT_TYPE[2] || targetType == OBJECT_TYPE[3]|| targetType == OBJECT_TYPE[1])
	{
		var portShapeID;
		var direction;
		if(targetType == OBJECT_TYPE[2])
		{
			portShapeID = targetID.substring(OBJECT_TYPE[2].length,targetID.length);
			direction = graph.getDirectionByID(graph.getPortshapeByID(portShapeID).parent.id);
		}
		else if(targetType == OBJECT_TYPE[3])
		{
			var timeslotShapeID = targetID.substring(OBJECT_TYPE[3].length,targetID.length);
			portShapeID = targetElement.parentNode.id.substring("g_timeslots_".length,targetElement.parentNode.id.length);
			direction = graph.getDirectionByID(graph.getPortshapeByID(portShapeID).parent.id)
		}
		else
		{
			portShapeID = targetID.substring(OBJECT_TYPE[1].length,targetID.length);
			direction = graph.getDirectionByID(portShapeID);
		}

		if(direction.nodetype == NODE_TYPE_SRC)
		{
			svgTip.tipBox.setAttribute("fill", "#A51C18");
			svgTip.tipBox.setAttribute("opacity", "0.7");
		}
		else if(direction.nodetype == NODE_TYPE_SNK)
		{
			svgTip.tipBox.setAttribute("fill", "#DE8ED6");
			svgTip.tipBox.setAttribute("opacity", "0.7");
		}
		else if(direction.nodetype == NODE_TYPE_PROTECTION)
		{
			svgTip.tipBox.setAttribute("fill", "#A582D6");
			svgTip.tipBox.setAttribute("opacity", "0.7");
		}	
	}
	
}

Graph.prototype.doMouseout = function(event) 
{
	var targetElement = event.target;
	var targetType = graph.getShapeType(targetElement.id);
	svgTip.RemoveTooltip(event);
}


Graph.prototype.doMouseup = function(event) 
{
	if(graph!=null && graph.lastMousedownTimeslot != null)
	{
		graph.lastMousedownTimeslot =null;
	}
}


Graph.prototype.drawArrow  = function()
{
	if(this.directionShapeList.length <= MAX_DIRECTION_LENGTH)
	{
		MAX_PORT_LENGTH = maxportlength[this.directionShapeList.length];
		return;	
	}
	MAX_PORT_LENGTH = maxportlength[MAX_DIRECTION_LENGTH];
	
	var blockObj = new DirectionShape(-1,OBJECT_TYPE[1],DIRECTION_MORE_START_ANGLE,DIRECTION_MORE_END_ANGLE,DIRECTION_INNERRADIUS,DIRECTION_OUTERRADIUS);
	blockObj.name = "...";
	blockObj.nodetype=NODE_TYPE_FREE;
	
	getSVGElement("svgGraph").appendChild(blockObj.drawBackground());
	getSVGElement("svgGraph").appendChild(blockObj.createTextElement());
	getSVGElement("svgGraph").appendChild(blockObj.drawShape());	

}


Graph.prototype.clearSnk = function()
{
	if(this.snkPort != null)
	{
		this.snkPort.removeShowTimeslots();
		this.snkPort.clearAllTimeslotsStatus();
		this.snkPort.clearAllOccupyStatus();
	}
	
	if(this.snkDirection != null)
	{
		this.snkDirection.ruleShape.removeShape();
		this.snkDirection.removeShowPorts();
		this.snkDirection.clearAllPortsStatus();
		this.snkDirection.nodetype = NODE_TYPE_FREE;
		this.snkDirection.setSelected(false);
		
	}
	
	this.snkDirection = null;
	this.snkPort = null;
}

Graph.prototype.clearProtect = function()
{
	if(this.protectPort != null)
	{
		this.protectPort.removeShowTimeslots();
		this.protectPort.clearAllTimeslotsStatus();
		this.protectPort.clearAllOccupyStatus();
	}
	
	if(this.protectDirection != null)
	{
		this.protectDirection.ruleShape.removeShape();
		this.protectDirection.removeShowPorts();
		this.protectDirection.clearAllPortsStatus();
		this.protectDirection.nodetype = NODE_TYPE_FREE;
		this.protectDirection.setSelected(false);
		
	}
	
	this.protectDirection = null;
	this.protectPort = null;
}


Graph.prototype.clear = function()
{
	for(var i = 0, len = this.directionShapeList.length; i < len; i++)
	{

		var direction = this.directionShapeList[i];
		direction.clearStar();
		
	}
	
	
	if(this.srcPort != null)
	{
		this.srcPort.selectTs = [];
		this.srcPort.removeShowTimeslots();
		this.srcPort.clearAllTimeslotsStatus();
		this.srcPort.clearAllOccupyStatus();
	}
	
	if(this.snkPort != null)
	{
		this.snkPort.selectTs = [];
		this.snkPort.removeShowTimeslots();
		this.snkPort.clearAllTimeslotsStatus();
		this.snkPort.clearAllOccupyStatus();
	}
	
	if(this.srcDirection != null)
	{
		this.srcDirection.ruleShape.removeShape();
		this.srcDirection.clearAllPortsStatus();
		this.srcDirection.removeShowPorts();	
		this.srcDirection.nodetype = NODE_TYPE_FREE;
		this.srcDirection.setSelected(false);
	}
	
	if(this.snkDirection != null)
	{
		this.snkDirection.ruleShape.removeShape();
		this.snkDirection.removeShowPorts();
		this.snkDirection.clearAllPortsStatus();
		this.snkDirection.nodetype = NODE_TYPE_FREE;
		this.snkDirection.setSelected(false);
		
	}
	
	if(this.protectDirection != null)
	{
		this.protectDirection.ruleShape.removeShape();
		this.protectDirection.removeShowPorts();
		this.protectDirection.clearAllPortsStatus();
		this.protectDirection.nodetype = NODE_TYPE_FREE;
		this.protectDirection.setSelected(false);
		
	}
	
	this.rootElement.removeChild(getSVGElement("svgGraph"));
	
	this.currentShape = null;
	this.lastMoveShape = null;
	this.lastMousedownTimeslot = null;
	this.srcDirection = null;
	this.snkDirection = null;
	this.protectDirection = null;
	this.srcPort = null;
	this.snkPort = null;
	this.protectPort = null;
	this.cursor = 0;	
	this.currentEditDir = null;
	
	this.drawInnerCircle();
	this.drawDirections();
	this.drawArrow();
	viewXCType = XC_JOIN;
}

Graph.prototype.moveDirections  = function()
{
	this.removeDirections();
	
	this.calculateAngle();
	
	this.drawDirections();
	
	this.drawArrow();
}


Graph.prototype.showAllDirections = function()
{
	xshowModalDialog("directionChooser.html", RESOURCE["selecttitle"], 480, 300,
			"../../../../images/",null,null,true);
}

Graph.prototype.calculateAngle = function()
{
	var temp = [];
	
	for(var i = 0,ilen = this.directionShapeList.length; i<ilen;i++)
	{
		var direction = this.directionShapeList[i];
		if(direction.nodetype == NODE_TYPE_FREE)
		{
			temp[temp.length] = direction;
		}
	}
	
	var ilen = temp.length;
	
	
	
	var tempStart = temp[ilen-1].startAngle;
	var tempEnd = temp[ilen-1].endAngle;
	var tempid = temp[ilen-1].ruleShape;
	
	
	for(var i = ilen-1; i>0;i--)
	{

		temp[i].startAngle =  temp[i-1].startAngle ;
		temp[i].endAngle =  temp[i-1].endAngle;
		temp[i].ruleShape = new RuleShape( temp[i].id,OBJECT_TYPE[4],temp[i-1].startAngle,temp[i-1].endAngle,0,temp[i-1].innerRadius)
			
	}
	
	temp[0].startAngle =  tempStart ;
	temp[0].endAngle =  tempEnd;	
	temp[0].ruleShape = new RuleShape(0,OBJECT_TYPE[4],tempStart,tempEnd,0,temp[0].innerRadius);

}





/**
 *     
 * int id   ID
 * byte type     
 * string name     
 * boolean isSelected     
 */
var Shape = function (id,type)
{
	this.id = id;
	this.type = type;
	this.name = null;
	this.title = null;
	this.isSelected = false;
	this.shapeid = this.type + this.id; 	
}




/**
 *     
 * int id   ID
 * byte type     
 * string name     
 * boolean isSelected     
 * int startAngle     
 * int endAngle     
 * int innerRadius    
 * int outerRaidus    
 */
var SectorShape = function (id,type,startAngle,endAngle,innerRadius,outerRadius)
{
	SectorShape.superclass.constructor.call(this, id,type);
	this.startAngle = startAngle;	
	this.endAngle = endAngle;
	this.innerRadius = innerRadius;
	this.outerRadius = outerRadius;
	this.cursor = 0;
}
extend(SectorShape,Shape);


SectorShape.prototype.drawShape = function() 
{
	var path = createElement("path");
	path.setAttribute("id", this.shapeid);
	path.setAttribute("d", this.getShapeData());
	path.setAttribute("class", this.getStyle());
	path.addEventListener("click",this.doClick,false);
	path.addEventListener("dblclick",this.doDblClick,false);
	
	var title = createElement("titleValue");
	var textValue=document.createTextNode(this.title);
	title.appendChild(textValue); 
	path.appendChild(title);
	
	return path;
}



SectorShape.prototype.drawBackground = function() 
{
	var path = createElement("path");
	path.setAttribute("id", "bg_"+this.shapeid);
	path.setAttribute("d", this.getShapeData());
	
	if(this.isSelected)
	{
		path.setAttribute("class", "bg_selected_"+this.getStyle());		     
	}
	else
	{
		path.setAttribute("class", "bg_"+this.getStyle());
	}

	return path;
}

SectorShape.prototype.setSelected = function(isSelected)
{
	this.isSelected = isSelected;
	var sector = getSVGElement("bg_"+this.shapeid);
	if(sector == null)
	{
		return;
	}
	
	if(isSelected)
	{
		sector.setAttribute("class", "bg_selected_"+this.getStyle());		     
	}
	else
	{
		sector.setAttribute("class", "bg_"+this.getStyle());
	}
}

SectorShape.prototype.getStyle = function()
{
	return this.type + "_" + this.nodetype;
}

SectorShape.prototype.doClick = function()
{
	
}

SectorShape.prototype.doDblClick = function()
{
	
}


/**
 *           
 * @param startAngle     
 * @param endAngle      
 * @param innerRadius     
 * @param outerRadius     
 * @returns {String}
 */
SectorShape.prototype.getShapeData = function()
{
	var x0 = Math.round(CIRCLE_CX + this.innerRadius * Math.cos(this.startAngle * 2* PI / 360));
	var y0 = Math.round(CIRCLE_CY - this.innerRadius * Math.sin(this.startAngle * 2 * PI / 360));
	var x1 = Math.round(CIRCLE_CX + this.innerRadius * Math.cos(this.endAngle * 2* PI / 360));
	var y1 = Math.round(CIRCLE_CY - this.innerRadius * Math.sin(this.endAngle * 2* PI / 360));
	var x2 = Math.round(CIRCLE_CX + this.outerRadius * Math.cos(this.endAngle * 2* PI / 360));
	var y2 = Math.round(CIRCLE_CY - this.outerRadius * Math.sin(this.endAngle * 2 * PI / 360));
	var x3 = Math.round(CIRCLE_CX + this.outerRadius * Math.cos(this.startAngle * 2* PI / 360));
	var y3 = Math.round(CIRCLE_CY - this.outerRadius * Math.sin(this.startAngle * 2 * PI / 360));
	
	var d = "M" + x0 + "," + y0 + " A" + this.innerRadius + "," + this.innerRadius 
	        + " 0 0,0 " + x1 + "," + y1 +" L" + x2 + "," + y2 + " A" + this.outerRadius + "," + this.outerRadius
	        + " 0 0,1 " + x3 + "," + y3 + "Z";
	
	return d;
}

SectorShape.prototype.getShowNameData = function()
{
	return "";
}


/**
 *       
 * @param name
 * @param defId
 * @returns
 */
SectorShape.prototype.createTextElement = function()
{	
	return "";
}


/**
 *             
 */
var RuleShape = function (id,type,startAngle,endAngle,innerRadius,outerRadius)
{
	RuleShape.superclass.constructor.call(this, id,type);
	this.startAngle = startAngle;	
	this.endAngle = endAngle;
	this.innerRadius = innerRadius;
	this.outerRadius = outerRadius;
}
extend(RuleShape,SectorShape);

RuleShape.prototype.getStyle = function()
{
	return this.type;
}

RuleShape.prototype.drawShape = function() 
{
	var path = createElement("path");
	path.setAttribute("id", this.shapeid);
	path.setAttribute("d", this.getShapeData());
	path.setAttribute("class", "ruler");
	return path;
}

RuleShape.prototype.removeShape = function() 
{
	var path = getSVGElement(this.shapeid);
	if(path != null)
	{
		graph.rootElement.removeChild(path);
	}
}


/**
 * 
 */
var ArrowShape = function(id,type,startAngle,endAngle,innerRadius,outerRadius)
{
	ArrowShape.superclass.constructor.call(this, id,type,startAngle,endAngle,innerRadius,outerRadius);
}
extend(ArrowShape,SectorShape);

ArrowShape.prototype.doClick = function(event)
{
	var targetElement = event.target;
	var parentNode = targetElement.parentNode.parentNode;
	
	if(parentNode.id.indexOf('g_timeslots_')>=0)
	{
		var portShapeID = parentNode.id.substring("g_timeslots_".length,targetElement.parentNode.id.length);
		var portShape = graph.getPortshapeByID(portShapeID);
		if(targetElement.parentNode.id.indexOf('start')>0)
		{			
			portShape.moveTimeslot(MAX_TIMESLOT_LENGTH);
		}
		else
		{
			portShape.moveTimeslot(-MAX_TIMESLOT_LENGTH);
		}
	}
	
	if(parentNode.id.indexOf('g_ports_')>=0)
	{
		
		if(targetElement.parentNode.id.indexOf('start')>0)
		{
			var shapeID = this.id.substring(p_start_arrow_pre.length,this.id.length);
			var direction = graph.getDirectionByID(shapeID);
		 	direction.movePorts(MAX_PORT_LENGTH);
		}
		else
		{
			var shapeID = this.id.substring(p_end_arrow_pre.length,this.id.length);
			var direction = graph.getDirectionByID(shapeID);
			direction.movePorts(-MAX_PORT_LENGTH);
		}
	}			
}

ArrowShape.prototype.drawShape = function() 
{
    var g = this.getArrowElement();
	g.setAttribute("id", this.shapeid);
	g.addEventListener("click",this.doClick,false);
	
	return g;
}

ArrowShape.prototype.drawBackground = function() 
{
	var g = this.getArrowElement();
	g.setAttribute("id", "bg_"+this.shapeid);
	g.addEventListener("click",this.doClick,false);
	
	return g;
}

/**
*/
ArrowShape.prototype.getArrowElement = function()
{
	var sAngle = this.startAngle;
	var eAngle = sAngle;
	var r1 = this.outerRadius + 10;
	var r2 = r1 + 10;
	var deltaAngle = 0;
	var tAngle = 0;
    if(this.id.indexOf("_start_") > -1)
    {
    	deltaAngle = -6;
    	tAngle = -3;
    }
    else if(this.id.indexOf("_end_") > -1)
    {
    	deltaAngle = 6;
    	tAngle = 3;
    }
    eAngle += deltaAngle;
    var tx0 = Math.round(CIRCLE_CX + (r1 + r2) / 2 * Math.cos((eAngle + tAngle) * 2 * PI / 360));
    var ty0 = Math.round(CIRCLE_CY - (r1 + r2) / 2 * Math.sin((eAngle + tAngle) * 2 * PI / 360));
    var tx1 = Math.round(CIRCLE_CX + (r1 - 5) * Math.cos(eAngle * 2 * PI / 360));
    var ty1 = Math.round(CIRCLE_CY - (r1 - 5) * Math.sin(eAngle * 2 * PI / 360));
    var tx2 = Math.round(CIRCLE_CX + (r2 + 5) * Math.cos(eAngle * 2 * PI / 360));
    var ty2 = Math.round(CIRCLE_CY - (r2 + 5) * Math.sin(eAngle * 2 * PI / 360));
    
    var pd = "M" + tx0 + "," + ty0 + " L" + tx1 + "," + ty1 + " " + tx2 + "," + ty2 + "Z";
	var g = createElement("g");
	var path1 = createElement("path");
	path1.setAttribute("d", pd);
	path1.setAttribute("cursor", "pointer");
	path1.setAttribute("fill", "#BDCFBD");
	path1.setAttribute("opacity", "0.7");
	g.appendChild(path1);
	
	tx0 = Math.round(CIRCLE_CX + r1 * Math.cos(eAngle * 2 * PI / 360));
    ty0 = Math.round(CIRCLE_CY - r1 * Math.sin(eAngle * 2 * PI / 360));
    tx1 = Math.round(CIRCLE_CX + r1 * Math.cos(sAngle * 2 * PI / 360));
    ty1 = Math.round(CIRCLE_CY - r1 * Math.sin(sAngle * 2 * PI / 360));
    tx2 = Math.round(CIRCLE_CX + r2 * Math.cos(sAngle * 2 * PI / 360));
    ty2 = Math.round(CIRCLE_CY - r2 * Math.sin(sAngle * 2 * PI / 360));
    var tx3 = Math.round(CIRCLE_CX + r2 * Math.cos(eAngle * 2 * PI / 360));
    var ty3 = Math.round(CIRCLE_CY - r2 * Math.sin(eAngle * 2 * PI / 360));
    
    if(this.id.indexOf("_start_") > -1)
    {
    	 pd = "M" + tx0 + "," + ty0 + " A" + r1 + "," + r1 
	        + " 0 0,0 " + tx1 + "," + ty1 +" L" + tx2 + "," + ty2 + " A" + r2 + "," + r2
	        + " 0 0,1 " + tx3 + "," + ty3;
    }
    else if(this.id.indexOf("_end_") > -1)
    {
    	 pd = "M" + tx0 + "," + ty0 + " A" + r1 + "," + r1 
	        + " 0 0,1 " + tx1 + "," + ty1 +" L" + tx2 + "," + ty2 + " A" + r2 + "," + r2
	        + " 0 0,0 " + tx3 + "," + ty3;
    }
    
	var path2 = createElement("path");
	path2.setAttribute("d", pd);
	path2.setAttribute("cursor", "pointer");
	path2.setAttribute("fill", "#BDCFBD");
	path2.setAttribute("opacity", "0.7");
	g.appendChild(path2);
	
	return g;
}

ArrowShape.prototype.createTextElement = function()
{	
	var path1 = createElement("path");
	path1.setAttribute("id", "portPath"+this.id);
	path1.setAttribute("d", this.getShowNameData());
	path1.setAttribute("visibility", "hidden");
	this.parent.g.appendChild(path1)
	
	var textPath = createElement("textPath");	
	var textValue=document.createTextNode("...");
	textPath.appendChild(textValue);
	textPath.href.baseVal = "#portPath"+this.id;
	
	var text = createElement("text");	
	text.setAttribute("font-size", "12");
	text.appendChild(textPath);
	
	return text;
}

ArrowShape.prototype.getShowNameData = function()
{

	var offset = 0;
	if(this.type == OBJECT_TYPE[5])
	{
		offset = 25;
	}
	
	var angle = ((this.endAngle+360 - this.startAngle)%360)/2;
	
	var d = "";
	
	var radius = this.innerRadius +offset;
	var x0 = Math.round(CIRCLE_CX + radius * Math.cos((this.startAngle+angle) * 2* PI / 360));
	var y0 = Math.round(CIRCLE_CY - radius * Math.sin((this.startAngle+angle) * 2 * PI / 360));

	var x2 = Math.round(CIRCLE_CX + this.outerRadius * Math.cos((this.startAngle+angle) * 2* PI / 360));
	var y2 = Math.round(CIRCLE_CY - this.outerRadius * Math.sin((this.startAngle+angle) * 2 * PI / 360));	
	d = "M" + x0 + "," + y0 +" L" + x2 + "," + y2 + "Z";
	
	
	return d;

}


var DirectionShape = function(id,type,startAngle,endAngle,innerRadius,outerRadius)
{
	DirectionShape.superclass.constructor.call(this, id,type,startAngle,endAngle,innerRadius,outerRadius);
	this.portShapeList = new Array();
	this.shapeid=type+id;
	this.ruleShape = new RuleShape(id,OBJECT_TYPE[4],startAngle,endAngle,0,innerRadius);//             
	this.g = null;

}
extend(DirectionShape,SectorShape);

DirectionShape.prototype.doDblClick = function(event)
{
	createwindow("statistics.html", RESOURCE["ResStat"], 560,380, true, "../../../../images/");
}


DirectionShape.prototype.doClick = function(event)
{
	if (graph.editMode == GRAPH_MODE_VIEW)
	{
		st.clearTableData();
	}
	
	var targetElement = event.target;
	
	if(this.id == "direction-1")//ID -1              
	{
		graph.showAllDirections();
		return ;
	}
	
	var directionID = this.id.substring(OBJECT_TYPE[1].length,this.id.length);	
	var currentDirection = graph.getDirectionByID(directionID);
	
	if(graph.editMode == GRAPH_MODE_VIEW )
	{
			if(graph.currentShape!=null)
			{
				graph.currentShape.nodetype = NODE_TYPE_FREE;
				graph.currentShape.cursor = 0;
				graph.currentShape.clearAllPortsStatus();
				graph.currentShape.removeShowPorts();
				graph.unSelect();
			}
					
					currentDirection.nodetype = NODE_TYPE_SRC;
					graph.srcDirection = currentDirection;
					graph.setSelected(currentDirection);
					currentDirection.drawPorts();
	}
	else 
	{
			if(graph.currentShape!=null)
			{
				if(graph.currentShape.nodetype == graph.currentEditDir)
				{
					graph.currentShape.nodetype = NODE_TYPE_FREE;
				}
				graph.currentShape.cursor = 0;
				graph.currentShape.clearAllPortsStatus();
				graph.currentShape.removeShowPorts();
				graph.unSelect();
			}
			
			if(graph.currentEditDir != null)
			{

			if(graph.currentEditDir == NODE_TYPE_SRC)
			{
				if(graph.srcDirection != null)
				{
					graph.srcDirection.nodetype = NODE_TYPE_FREE;
					graph.srcDirection.setSelected(false);
					graph.srcDirection.removeShowPorts();
					graph.srcDirection = null;
				}
				graph.srcDirection = currentDirection;
				currentDirection.nodetype = graph.currentEditDir;		
				graph.setSelected(currentDirection);		
				currentDirection.drawPorts();

			}
			else if(graph.currentEditDir == NODE_TYPE_SNK)
			{
				if(graph.snkDirection != null )
				{
					graph.snkDirection.nodetype = NODE_TYPE_FREE;
					graph.snkDirection.setSelected(false);
					graph.snkDirection.removeShowPorts();
					graph.snkDirection = null;
				}
				graph.snkDirection = currentDirection;
				currentDirection.nodetype = graph.currentEditDir;		
			  graph.setSelected(currentDirection);		
			  currentDirection.drawPorts();
			}
			else if(graph.currentEditDir == NODE_TYPE_PROTECTION)
			{
				if(graph.protectDirection != null)
				{
					graph.protectDirection.nodetype = NODE_TYPE_FREE;
					graph.protectDirection.setSelected(false);
					graph.protectDirection.removeShowPorts();
					graph.protectDirection = null;
				}
				graph.protectDirection = currentDirection;
				currentDirection.nodetype = graph.currentEditDir;		
				graph.setSelected(currentDirection);		
				currentDirection.drawPorts();
			}
			}
			else
			{
					alert(RESOURCE["specifyDirectionFirst"]);
			}
			
			
				
	}
	
}




DirectionShape.prototype.clearAllPortsStatus = function()
{
	this.calculateAngle();
	
	for(var i = 0, len = this.portShapeList.length; i < len; i++)
	{
		
		var portShape = this.portShapeList[i];
		if(portShape.nodetype != NODE_TYPE_FREE)
		{
			portShape.isSelected = false;
			portShape.nodetype = NODE_TYPE_FREE;
			
			var gport = getSVGElement("bg_"+portShape.shapeid);
			if(gport != null)
			{
				gport.setAttribute("class", "bg_"+portShape.getStyle());
			}
			
			portShape.clearAllTimeslotsStatus();
			portShape.removeShowTimeslots();
		}
	}
}

DirectionShape.prototype.removeShowPorts = function()
{
	if(this.g != null)
	{
		graph.rootElement.removeChild(this.g);
		this.g = null;
	}
}

DirectionShape.prototype.calculateAngle = function()
{
	var startAngle = this.startAngle;
	for(var i = this.cursor,ilen = this.portShapeList.length; i < ilen; i++)
	{
		this.portShapeList[i].startAngle =  startAngle +(i-this.cursor)*6;
		this.portShapeList[i].endAngle =  startAngle+5 +(i-this.cursor)*6;	
	}
	
}


DirectionShape.prototype.drawPorts = function() 
{	
	if(this.g == null)
	{
		this.g = createElement("g");
		this.g.setAttribute("id", "g_ports_"+this.id);
		
		this.calculateAngle();
		
		var len = this.portShapeList.length > MAX_PORT_LENGTH ? MAX_PORT_LENGTH : this.portShapeList.length;
		for(var i = 0; i < len; i++)
		{
			this.g.appendChild(this.portShapeList[i].drawBackground());
			this.g.appendChild(this.portShapeList[i].createTextElement());	
			this.g.appendChild(this.portShapeList[i].drawShape());		
		}
		
		
			
		if(len >0)
		{
			this.drawArrow();
		}
		
				
		graph.rootElement.appendChild(this.g);
	}
	
}

DirectionShape.prototype.drawArrow  = function()
{
	var g = this.g;
	if(MAX_PORT_LENGTH < this.portShapeList.length)
	{
		var startport = this.portShapeList[Math.abs(this.cursor)];
		var startArrow =  new ArrowShape("_start_"+this.id,OBJECT_TYPE[5],startport.startAngle,startport.endAngle,startport.innerRadius,startport.outerRadius)
		startArrow.parent = this;
		g.appendChild(startArrow.drawBackground());
		g.appendChild(startArrow.drawShape());
		
		var index = ((Math.abs(this.cursor) + MAX_PORT_LENGTH) > this.portShapeList.length) ? this.portShapeList.length : (Math.abs(this.cursor) + MAX_PORT_LENGTH);
		var endport = this.portShapeList[index - 1];
		var endArrow = new ArrowShape("_end_"+this.id,OBJECT_TYPE[5],startport.startAngle,startport.startAngle,endport.innerRadius,endport.outerRadius);
		endArrow.parent = this;
		g.appendChild(endArrow.drawShape());		
	}
}

DirectionShape.prototype.movePorts = function(d) 
{	
	this.removeShowPorts();
	this.g = createElement("g");
	this.g.setAttribute("id", "g_ports_"+this.id);
		
	this.calculateAngle();
	
	var deltaAngle = 360 / MAX_PORT_LENGTH;
	
	var index = 0;
	var len = 0;
	if((this.cursor > 0) && (this.cursor + d < 0))
	{
		len = this.cursor;
		this.cursor = 0;
	}
	else
	{
	 	this.cursor += d;
	 	if(this.cursor > this.portShapeList.length)
		{
			this.cursor = 0;
		}
		this.cursor = (this.cursor + this.portShapeList.length) % this.portShapeList.length;
		index = Math.abs(this.cursor);
		len = (MAX_PORT_LENGTH + index) > this.portShapeList.length?this.portShapeList.length:MAX_PORT_LENGTH + index;
	}
	
	for(var i = index; i < len; i++)
	{
		this.g.appendChild(this.portShapeList[i].drawBackground());
		this.g.appendChild(this.portShapeList[i].createTextElement());
		this.g.appendChild(this.portShapeList[i].drawShape());			
	}
	
	this.drawArrow();
	
	graph.rootElement.appendChild(this.g);
}

DirectionShape.prototype.getShowNameData = function()
{
	var space = (((this.endAngle+360 - this.startAngle)%360)/DIRECTION_CHAR_ANGLE - this.name.length)/2;
	
	var start = this.startAngle;
	var end = this.endAngle;
	
	if(space > 0)
	{
		start = this.startAngle + space*DIRECTION_CHAR_ANGLE;
		end = this.endAngle - space*DIRECTION_CHAR_ANGLE;
	}
	
	var radiusSpace = 10;
	
	if(start > 180)
	{
		radiusSpace = 18;
	}
	
	var x0 = Math.round(CIRCLE_CX + (this.innerRadius+radiusSpace)* Math.cos(start * 2* PI / 360));
	var y0 = Math.round(CIRCLE_CY - (this.innerRadius+radiusSpace) * Math.sin(start * 2 * PI / 360));
	var x1 = Math.round(CIRCLE_CX + (this.innerRadius+radiusSpace) * Math.cos(end * 2* PI / 360));
	var y1 = Math.round(CIRCLE_CY - (this.innerRadius+radiusSpace) * Math.sin(end * 2* PI / 360));
	var x2 = Math.round(CIRCLE_CX + this.outerRadius * Math.cos(end * 2* PI / 360));
	var y2 = Math.round(CIRCLE_CY - this.outerRadius * Math.sin(end * 2 * PI / 360));
	var x3 = Math.round(CIRCLE_CX + this.outerRadius * Math.cos(start * 2* PI / 360));
	var y3 = Math.round(CIRCLE_CY - this.outerRadius * Math.sin(start * 2 * PI / 360));
	
	
	var d = "M"+x1+","+y1+ " A"+ this.innerRadius + "," + this.innerRadius+ " 0 0,1" + x0 + "," + y0;
	
	if(start > 180)
	{
		d = "M"+x0+","+y0+ " A"+ this.innerRadius + "," + this.innerRadius+ " 0 0,0" + x1 + "," + y1;
	}
	
	
	return d;

}


DirectionShape.prototype.createTextElement = function()
{	
	var angle = this.startAngle+((this.endAngle+360 - this.startAngle)%360)/2;
	
	var radius = 0;
	
	if(angle>=90 && angle <=270)
	{
		radius = this.outerRadius;
	}
	else
	{
		radius = this.innerRadius;
	}
	
	var x = Math.round(CIRCLE_CX + radius * Math.cos(angle * 2* PI / 360));
	var y = Math.round(CIRCLE_CY - radius * Math.sin(angle * 2 * PI / 360));
	
	var showText = createElement("text");
	showText.setAttribute("id", "directionPath"+this.id);
	showText.setAttribute("x", x);
	showText.setAttribute("y", y);
	showText.setAttribute("font-size", 12);
	if(this.name.length > ROW_CHAR_LENGTH)
	{
		showText.appendChild(document.createTextNode(this.name.substring(0,ROW_CHAR_LENGTH)+"..."));
	}
	else
	{
		showText.appendChild(document.createTextNode(this.name));
	}
	return showText;
}


DirectionShape.prototype.drawStar  = function()
{
	var x = Math.round(CIRCLE_CX + this.outerRadius * Math.cos(this.endAngle * 2* PI / 360));
	var y = Math.round(CIRCLE_CY - this.outerRadius * Math.sin(this.endAngle * 2 * PI / 360));
	
	var starText = createElement("text");
	starText.setAttribute("id", "starText"+this.id);
	starText.setAttribute("font-size", "12")
	starText.setAttribute("x", x);
	starText.setAttribute("y", y);
	starText.textContent = "*";
	starText.setAttribute("fill", "#DE8ED6");
	starText.setAttribute("font-weight", "bold");
	graph.rootElement.appendChild(starText);
}


DirectionShape.prototype.clearStar  = function()
{
	var g = getSVGElement("starText"+this.id);
	if(g!=null)
	{
		graph.rootElement.removeChild(g);
	}
}


var PortShape = function(id,type,startAngle,endAngle,innerRadius,outerRadius)
{
	PortShape.superclass.constructor.call(this, id,type,startAngle,endAngle,innerRadius,outerRadius);
	this.slotId = null;
	this.showSlotId = null;
	this.portId = 0;
	this.slotName = null;
	this.portName = null;
	this.timeSlotList = [];//ODU0
	this.odu0List = [];
	this.odu1List = [];
	this.odu2List = [];
	this.odu3List = [];
	this.odu4List = [];
	this.oduflexList = [];
	this.prentDirection = null;
	this.grade = null;
	this.shapeid="port"+id;
	this.nodetype=NODE_TYPE_FREE;
	this.xcList = [];
	this.workxcList = [];
	this.protectxcList = [];
	this.tsmode = TSMODE_RANDOM;
	this.selectTs = [];
	
}
extend(PortShape,SectorShape);



PortShape.prototype.doClick = function(event)
{
	if (graph.editMode == GRAPH_MODE_VIEW)
	{
		st.clearTableData();
	}	
	var targetElement = event.target;
	var portShapeID = this.id.substring(OBJECT_TYPE[2].length,this.id.length);
	
	var portShape = graph.getPortshapeByID(portShapeID);
	portShape.selectTs = [];
	queryXC(portShape);//         
	portShape.parent.clearAllPortsStatus();
	
	
	if(portShape.parent.nodetype == NODE_TYPE_SRC )
	{
		graph.srcPort = portShape;
	}
	else if(portShape.parent.nodetype == NODE_TYPE_SNK )
	{
		graph.snkPort = portShape;
	}
	else if(portShape.parent.nodetype == NODE_TYPE_PROTECTION )
	{
		graph.protectPort = portShape;
	}
	
	
	if(portShape.isSelected)//unselect if it has selected
	{
		portShape.nodetype = NODE_TYPE_FREE;
	}
	else
	{
		if(graph.currentShape == null)
		{
		}
		else
		{

				portShape.nodetype = portShape.parent.nodetype;
				portShape.setSelected(true);
				if(portShape.portId == 0 && graph.editMode != GRAPH_MODE_VIEW)
				{
					var serviceLevel = st.getCellStoreValue(0, "serviceLevel", "serviceLevel")
					
					portShape.drawTimeslots(Service[serviceLevel]);
				}
				else
				{
					portShape.drawTimeslots();
				}
				if(portShape.parent != graph.currentShape)
				{
					graph.unSelect();
					graph.setSelected(portShape.parent);
				}

		}
	}	
}

PortShape.prototype.setSelected = function(isSelected) 
{		
	PortShape.superclass.setSelected.call(this,isSelected);	
}


PortShape.prototype.clearAllOccupyStatus = function()
{
	for(var i = 0, len = this.timeSlotList.length; i < len; i++)
	{
		
		var timeSlot = this.timeSlotList[i];
		timeSlot.occupy = 0;
		timeSlot.snkOccupyPath = 0;
		timeSlot.srcOccupyPath = 0;
	}
	
	for(var i = 0, len = this.odu0List.length; i < len; i++)
	{
		
		var timeSlot = this.odu0List[i];
		timeSlot.occupy = 0;
		timeSlot.snkOccupyPath = 0;
		timeSlot.srcOccupyPath = 0;
	}
	
	
	for(var i = 0, len = this.odu1List.length; i < len; i++)
	{
		
		var timeSlot = this.odu1List[i];
		timeSlot.occupy = 0;
		timeSlot.snkOccupyPath = 0;
		timeSlot.srcOccupyPath = 0;
	}
	
	for(var i = 0, len = this.odu2List.length; i < len; i++)
	{
		
		var timeSlot = this.odu2List[i];
		timeSlot.occupy = 0;
		timeSlot.snkOccupyPath = 0;
		timeSlot.srcOccupyPath = 0;
	}
	
	for(var i = 0, len = this.odu3List.length; i < len; i++)
	{
		
		var timeSlot = this.odu3List[i];
		timeSlot.occupy = 0;
		timeSlot.snkOccupyPath = 0;
		timeSlot.srcOccupyPath = 0;
	}
	
	for(var i = 0, len = this.odu4List.length; i < len; i++)
	{
		
		var timeSlot = this.odu4List[i];
		timeSlot.occupy = 0;
		timeSlot.snkOccupyPath = 0;
		timeSlot.srcOccupyPath = 0;
	}
	
	for(var i = 0, len = this.oduflexList.length; i < len; i++)
	{
		
		var timeSlot = this.oduflexList[i];
		timeSlot.occupy = 0;
		timeSlot.snkOccupyPath = 0;
		timeSlot.srcOccupyPath = 0;
	}
}

PortShape.prototype.clearAllSelectStatus = function()
{
	for(var i = 0, len = this.timeSlotList.length; i < len; i++)
	{
		
		var timeSlot = this.timeSlotList[i];
		timeSlot.isSelected = false;
		
	}
}




PortShape.prototype.clearAllTimeslotsStatus = function()
{
	this.cursor = 0;
	this.calculateAngle();	
	
	for(var i = 0, len = this.timeSlotList.length; i < len; i++)
	{
		
		var timeSlot = this.timeSlotList[i];
		if(timeSlot.nodetype != NODE_TYPE_FREE)
		{
			timeSlot.isSelected = false;
			timeSlot.nodetype = NODE_TYPE_FREE;
			if(getSVGElement(timeSlot.shapeid) != null)
			{
				getSVGElement(timeSlot.shapeid).setAttribute("class", timeSlot.getStyle());
			}
		}
	}
}

PortShape.prototype.removeShowTimeslots = function()
{
	var g = getSVGElement("g_timeslots_"+this.id);
	if(g!=null)
	{
		graph.rootElement.removeChild(g);
	}
}

PortShape.prototype.calculateAngle = function()
{
	var startAngle = this.startAngle;
	for(var i = 0,ilen = this.timeSlotList.length; i < ilen; i++)
	{
		this.timeSlotList[i].startAngle =  startAngle +i*4.5;
		this.timeSlotList[i].endAngle =  startAngle+4 +i*4.5;	
	}	
}



PortShape.prototype.drawTimeslots = function(serviceLevel) 
{	
	if(getSVGElement("g_timeslots_"+this.id) == null)
	{
		this.g = createElement("g");
		this.g.setAttribute("id", "g_timeslots_"+this.id);
		
		this.calculateAngle();
		
		var len = this.timeSlotList.length > MAX_TIMESLOT_LENGTH ? MAX_TIMESLOT_LENGTH : this.timeSlotList.length;
		
		if(serviceLevel == null)
		{
			for(var i = 0; i < len; i++)
			{
				this.g.appendChild(this.timeSlotList[i].drawBackground());
				this.g.appendChild(this.timeSlotList[i].createTextElement());
				this.g.appendChild(this.timeSlotList[i].drawShape());
			
			}
		}
		else
		{
			var startAngle = this.timeSlotList[0].startAngle;
			var endAngle = this.timeSlotList[0].endAngle;
			var d = 0;
			
			for(var i = 0; i < len; i++)
			{
				
				if(this.timeSlotList[i].signalList.toLowerCase().indexOf(serviceLevel.toLowerCase()) >=0)
				{
					this.timeSlotList[i].startAngle = startAngle + 4.5*d;
					this.timeSlotList[i].endAngle = endAngle + 4.5*d;
					
					this.g.appendChild(this.timeSlotList[i].drawBackground());
					this.g.appendChild(this.timeSlotList[i].createTextElement());
					this.g.appendChild(this.timeSlotList[i].drawShape());
					
					d++;
				}
			
			}
		}
		
		if(len >0)
		{
			this.drawArrow();
		}
		graph.rootElement.appendChild(this.g);
		
	}
	
}


PortShape.prototype.getShowNameData = function()
{
	var angle = ((this.endAngle+360 - this.startAngle)%360)/2;
	
	

	var d = "";
	
	if(this.startAngle >= 90 && this.startAngle <=270)
	{
		var r = 250;
		
		var x0 = Math.round(CIRCLE_CX + this.innerRadius * Math.cos((this.startAngle+angle) * 2* PI / 360));
		var y0 = Math.round(CIRCLE_CY - this.innerRadius * Math.sin((this.startAngle+angle) * 2 * PI / 360));

		var x2 = Math.round(CIRCLE_CX + r * Math.cos((this.startAngle+angle) * 2* PI / 360));
		var y2 = Math.round(CIRCLE_CY - r * Math.sin((this.startAngle+angle) * 2 * PI / 360));
		d = "M" + x2 + "," + y2 +" L" + x0 + "," + y0 + "Z";
	}
	else
	{
		var x0 = Math.round(CIRCLE_CX + this.innerRadius * Math.cos((this.startAngle+angle) * 2* PI / 360));
		var y0 = Math.round(CIRCLE_CY - this.innerRadius * Math.sin((this.startAngle+angle) * 2 * PI / 360));

		var x2 = Math.round(CIRCLE_CX + this.outerRadius * Math.cos((this.startAngle+angle) * 2* PI / 360));
		var y2 = Math.round(CIRCLE_CY - this.outerRadius * Math.sin((this.startAngle+angle) * 2 * PI / 360));	
		d = "M" + x0 + "," + y0 +" L" + x2 + "," + y2 + "Z";
	}
	

	
	return d;
}


PortShape.prototype.createTextElement = function()
{	

	var angle = this.startAngle+((this.endAngle+360 - this.startAngle)%360)/2;
	
	var x = Math.round(CIRCLE_CX + (this.outerRadius) * Math.cos(angle * 2* PI / 360));
	var y = Math.round(CIRCLE_CY - (this.outerRadius) * Math.sin(angle * 2 * PI / 360));
	
	
	if(angle < 275 && angle > 265)
	{
		y = y +5;
	}
	
	if(angle < 95 && angle > 85)
	{
		y = y -5;
	}
	
	var showText = createElement("text");
	showText.setAttribute("id", "portPath"+this.id);
	showText.setAttribute("x", x);
	showText.setAttribute("y", y);
	showText.setAttribute("font-size", 10);
	showText.appendChild(document.createTextNode(this.name));
	return showText;

}

PortShape.prototype.drawArrow  = function()
{
	var g = this.g;
	if(MAX_TIMESLOT_LENGTH < this.timeSlotList.length)
	{
		var startTimeslot = this.timeSlotList[Math.abs(this.cursor)];
		var startArrow = new ArrowShape("_start_"+this.id,OBJECT_TYPE[6],startTimeslot.startAngle,startTimeslot.endAngle,startTimeslot.innerRadius,startTimeslot.outerRadius)
		
		startArrow.parent = this;
		g.appendChild(startArrow.drawShape());
		
		var index = ((Math.abs(this.cursor) + MAX_TIMESLOT_LENGTH) > this.timeSlotList.length) ? this.timeSlotList.length : (Math.abs(this.cursor) + MAX_TIMESLOT_LENGTH);
		var endTimeslot = this.timeSlotList[index - 1];
		var endArrow = new ArrowShape("_end_"+this.id,OBJECT_TYPE[6],startTimeslot.startAngle,startTimeslot.startAngle,endTimeslot.innerRadius,endTimeslot.outerRadius)
		
		endArrow.parent = this;
		g.appendChild(endArrow.drawShape());
	
	}
}

PortShape.prototype.moveTimeslot = function(d) 
{	
	
	
	this.removeShowTimeslots();
	this.g = createElement("g");
	this.g.setAttribute("id", "g_timeslots_"+this.id);
	var deltaAngle = 360 / MAX_TIMESLOT_LENGTH;
	var index = 0;
	var len = 0;
	if((this.cursor > 0) && (this.cursor + d < 0))
	{
		len = this.cursor;
		this.cursor = 0;
	}
	else
	{
	 	this.cursor += d;
	 	if(this.cursor > this.timeSlotList.length)
		{
			this.cursor = 0;
		}
		this.cursor = (this.cursor + this.timeSlotList.length) % this.timeSlotList.length;
		index = Math.abs(this.cursor);
		len = (MAX_TIMESLOT_LENGTH + index) > this.timeSlotList.length?this.timeSlotList.length:MAX_TIMESLOT_LENGTH + index;
	}
	if(this.portId == 0 && graph.editMode != GRAPH_MODE_VIEW)
	{
		var serviceLevel = st.getCellStoreValue(0, "serviceLevel", "serviceLevel");
		var startAngle = this.startAngle;
		var endAngle = this.endAngle;
		var count = 0;
			
			for(var i = this.cursor; i < len; i++)
			{
				if(this.timeSlotList[i].signalList.indexOf(serviceLevel) >= 0)
				{
					this.timeSlotList[i].startAngle = startAngle - 6*count*d;
					this.timeSlotList[i].endAngle = endAngle  - 6*count*d;
					
					this.g.appendChild(this.timeSlotList[i].drawBackground());
					this.g.appendChild(this.timeSlotList[i].createTextElement());
					this.g.appendChild(this.timeSlotList[i].drawShape());
					
					count++;
				}
			}
			
			for(var i = this.cursor; i < len; i++)
			{
				if(this.timeSlotList[i].signalList.indexOf(Service[serviceLevel]) >=0)
				{
				this.g.appendChild(this.timeSlotList[i].drawBackground());	
				this.g.appendChild(this.timeSlotList[i].createTextElement());
				this.g.appendChild(this.timeSlotList[i].drawShape());
				}
			}
	
	}
	else
	{	
		for(var i = 0,iLength = this.timeSlotList.length; i < iLength; i++)
		{
		this.timeSlotList[i].startAngle = this.timeSlotList[i].startAngle - deltaAngle*d;
		this.timeSlotList[i].endAngle = this.timeSlotList[i].endAngle - deltaAngle*d;
		}	
	
		for(var i = index; i < len; i++)
		{
			this.g.appendChild(this.timeSlotList[i].drawBackground());	
			this.g.appendChild(this.timeSlotList[i].createTextElement());
			this.g.appendChild(this.timeSlotList[i].drawShape());
		}
	}
	
	this.drawArrow();
	
	
	graph.rootElement.appendChild(this.g);
}


PortShape.prototype.getOduListByLevel = function(serviceLevel)
{
	if(SERVICE_ODU0 == serviceLevel)
	{
		return this.odu0List;
	}
	else if(SERVICE_ODU1 == serviceLevel)
	{
		return this.odu1List;
	}
	else if(SERVICE_ODU2 == serviceLevel)
	{
		return this.odu2List;
	}
	else if(SERVICE_ODU3 == serviceLevel)
	{
		return this.odu3List;
	}
	else if(SERVICE_ODU4 == serviceLevel)
	{
		return this.odu4List;
	}
}




var TimeSlotShape = function (id,type,startAngle,endAngle,innerRadius,outerRadius)
{
	SectorShape.superclass.constructor.call(this, id,type);
	this.shapeid = type + id;
	this.startAngle = startAngle;	
	this.endAngle = endAngle;
	this.innerRadius = innerRadius;
	this.outerRadius = outerRadius;
	this.occupy = 0;//       
	this.snkOccupyPath = 0;//                  
	this.srcOccupyPath = 0;//                  
	this.nodetype=NODE_TYPE_FREE;
	this.path = 1;
	this.portid = 0;
	this.showPortId = 0;
	this.isMulti = 1;//        ,  1    
	this.tsName = "";
	this.signalList = "";
}
extend(TimeSlotShape,SectorShape);


TimeSlotShape.prototype.setSelected = function(isSelected) 
{		
	
	TimeSlotShape.superclass.setSelected.call(this,isSelected);
	var timeslotList = this.parent.timeSlotList;
	var parentPort = this.parent;
	var timeslotArray = [];
	
	for(var i = 0,iLength =timeslotList.length;i<iLength;i++)
	{
		if(timeslotList[i].isSelected)
		{
			timeslotArray.push(timeslotList[i]);
		}
	}
	if (isSelected == false && timeslotArray.length == 0 && graph.editMode == GRAPH_MODE_VIEW)
	{
		st.clearTableData();
	}
	this.parent.selectTs = timeslotArray;
	
	if(graph.editMode == GRAPH_MODE_VIEW)
	{
		if(this.nodetype == NODE_TYPE_SRC )
		{
			st.clearTableData();
			graph.clearSnk();
			graph.clearProtect();
			showXCInTable();	
		}
	}

	
	if(graph.editMode == GRAPH_MODE_CREATE )
	{	
		showCreateXCTable();
	}
	
	if(graph.editMode == GRAPH_MODE_EDIT )
	{	
		showEditXCTable();
	}
}




TimeSlotShape.prototype.createTextElement = function()
{	
		var angle = this.startAngle+((this.endAngle+360 - this.startAngle)%360)/2;
	
	var radius =280;
	

	
	var x = Math.round(CIRCLE_CX + (radius) * Math.cos(angle * 2* PI / 360));
	var y = Math.round(CIRCLE_CY - (radius) * Math.sin(angle * 2 * PI / 360));
	
	var showText = createElement("text");
	showText.setAttribute("id", "timeslotPath"+this.id);
	showText.setAttribute("x", x);
	showText.setAttribute("y", y);
	showText.setAttribute("font-size", 10);
	showText.appendChild(document.createTextNode(this.name));
	return showText;
	
	return text;
}

TimeSlotShape.prototype.getShowNameData = function()
{
	var angle = ((this.endAngle+360 - this.startAngle)%360)/2;
	
	var x0 = Math.round(CIRCLE_CX + this.innerRadius * Math.cos((this.startAngle+angle) * 2* PI / 360));
	var y0 = Math.round(CIRCLE_CY - this.innerRadius * Math.sin((this.startAngle+angle) * 2 * PI / 360));

	var x2 = Math.round(CIRCLE_CX + this.outerRadius * Math.cos((this.startAngle+angle) * 2* PI / 360));
	var y2 = Math.round(CIRCLE_CY - this.outerRadius * Math.sin((this.startAngle+angle) * 2 * PI / 360));

	var d = "";
	
	if(this.startAngle >= 90 && this.startAngle <=270)
	{
		d = "M" + x2 + "," + y2 +" L" + x0 + "," + y0 + "Z";
	}
	else
	{
		d = "M" + x0 + "," + y0 +" L" + x2 + "," + y2 + "Z";
	}
	

	
	return d;
}

TimeSlotShape.prototype.doClick = function(event)
{
	
}

TimeSlotShape.prototype.getStyle = function()
{
	if(this.isSelected)
	{
		return this.type + "_" + this.nodetype;
	}
	else
	{
		return this.type + "_" + this.occupy;
	}
}






