
var winurlobj = getNeProperty(self);

var referencest = null;
var st = null;

var Level = new Object();
Level[1] = "wdmlevel";

var Direction = new Object();
Direction[1] = "singledirection";
/**
 *      
 */
function init()
{
    initRes();
    initTable();
    queryReferFiber();
}

/**
 *          
 */
function initRes()
{
    $("referenceFildset").appendChild(document.createTextNode(RESOURCE["referencefiber"]));
    $("neFildset").appendChild(document.createTextNode(RESOURCE["nefiber"]));
    $("querybtn").value = RESOURCE["querybutton"];
    $("createbtn").value = RESOURCE["newbutton"];
    $("deletebtn").value = RESOURCE["deletebutton"];
    $("createbtn").disabled = true;
    $("deletebtn").disabled = true;
}

/**
 *        
 */
function initTable()
{
    referencest = new SortTable();
    referencest.setImage("../../../../images/");
    referencest.isUsedForSelectList = true;
    referencest.setOnRowSelectHandler(selectReferTablehandler);
    createTableHead(referencest, window.tableconf[0]);
    $("referencefibertable").appendChild(referencest.getTable());
	var height = getComponetHeight($("tableContainer"),150);
	referencest.setBodyHeight(height/2 + "px");
	
    st = new SortTable();
    st.setImage("../../../../images/");
    st.isUsedForSelectList = true;
    st.setOnRowSelectHandler(selectNETablehandler);
    createTableHead(st, window.tableconf[1]);
    $("nefibertable").appendChild(st.getTable());
	st.setBodyHeight(height/2 + "px");
	
	EventUtil.addEventHandler(window,"resize",adjustTableHeight);
}

/**
 *             
 *             
 */
function selectReferTablehandler()
{
    if (referencest.getSelectedRowCount() > 0) 
    {
        $("createbtn").disabled = false;
    }
    else 
    {
        $("createbtn").disabled = true;
    }
}

/**
 *             
 *             
 */
function selectNETablehandler()
{
    if (st.getSelectedRowCount() > 0) 
    {
        $("deletebtn").disabled = false;
    }
    else 
    {
        $("deletebtn").disabled = true;
    }
}

/**
 *       
 */
function queryReferFiber(/*boolean*/bShowError)
{
    $("querybtn").disabled = true;
	$("createbtn").disabled = true;
    $("deletebtn").disabled = true;
    var xml = createQueryReferFiberXML();
    loadXMLdoc("../../../../neExlorerServlet?sfid=" +
    TECMD_NGWDM_QUERY_REFER_FIBER, "POST", true, queryReferFiberCallback, bShowError, "inputdata=" + xml);
}

/**
 *          XML
 *  U2000    (daipeili lijunrui  ) 
 * 1           0
 * 2             
 * @return XML
 */
function createQueryReferFiberXML()
{
    var root = new inputxml("datainterface");
    var firstlevel = new tagElement("bussiness-params");
    var secondlevel = new tagElement("row-params");
    var thirdlevel = new tagElement("param", "neid", winurlobj.neid);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param", "slotid", winurlobj.slotid);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param", "srcNE", "0");
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param", "srcSlot", "0");
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param", "snkNE", winurlobj.neid);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param", "snkSlot", winurlobj.slotid);
    secondlevel.appendChild(thirdlevel);
    
    firstlevel.appendChild(secondlevel);
    root.getRoot().appendChild(firstlevel);
    
    return root.toString();
}

/**
 *           
 *                  
 * @param {Object} doc
 */
function queryReferFiberCallback(/*XMLDOM*/doc,/*boolean*/bShowError)
{
    var data = EncapsulateData(doc);
	var selectedObj = [];
	for(var i = 0,len = referencest.getDataRowLength();i < len;i++)
	{
		if(referencest.getRowSelFlag(i))
		{
			selectedObj[selectedObj.length] = getTableRowKey(referencest,i);
		}
	}
    referencest.clearTableData();
    createTableBody(referencest, window.tableconf[0], data, RESOURCE);
	
	for (var i = 0, len = referencest.getDataRowLength(); i < len; i++) 
	{
		if(selectedObj.contains(getTableRowKey(referencest,i)))
		{
			referencest.setRowSelect(i);
		}
	}
	selectReferTablehandler();
    queryNEFiber(true,data);
}

/**
 *            
 * @param {Object} rowindex
 */
function getTableRowKey(/*SortTable*/table,/*int*/rowindex)
{
	if(!table.getRow(rowindex))
	{
		return "";
	}
    return table.getCellStoreValue(rowindex, "srcNE", "srcNE") + 
	"-" +
    table.getCellStoreValue(rowindex, "srcPort", "srcSlot") +
    "-" +
    table.getCellStoreValue(rowindex, "srcPort", "srcPort") +
    "-" +
    table.getCellStoreValue(rowindex, "snkNE", "snkNE") +
    "-" +
    table.getCellStoreValue(rowindex, "snkPort", "snkSlot") +
    "-" +
    table.getCellStoreValue(rowindex, "snkPort", "snkPort");
}

/**
 *                               
 *         
 * @param {boolean} bShowError         
 * @param (Object) data         
 */
function queryNEFiber(/*boolean*/bShowError,/*Object*/data)
{
    var xml = createQueryNEFiberXML();
    loadXMLdoc("../../../../neExlorerServlet?sfid=" +
    TECMDCODE_NF_FILTERFIBER, "POST", true, queryNEFiberCallback, [bShowError,data], "inputdata=" + xml);
}

/**
 *           XML
 * @return XML
 */
function createQueryNEFiberXML()
{
    var root = new inputxml("datainterface");
    var firstlevel = new tagElement("bussiness-params");
    var secondlevel = new tagElement("row-params");
    var thirdlevel = new tagElement("param", "neid", winurlobj.neid);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param", "slotid", winurlobj.slotid);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param", "srcNE", "0");
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param", "srcSolt", "0");
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param", "snkNE", winurlobj.neid);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param", "snkSolt", winurlobj.slotid);
    secondlevel.appendChild(thirdlevel);
    
    firstlevel.appendChild(secondlevel);
    root.getRoot().appendChild(firstlevel);
    
    return root.toString();
}

/**
 *            
 * @param {XMLDOM} doc
 * @param {Array} params
 */
function queryNEFiberCallback(/*XMLDOM*/doc,/*Array*/params)
{
    $("querybtn").disabled = false;
    var data = EncapsulateData(doc);
	var selectedObj = [];
	for(var i = 0,len = st.getDataRowLength();i < len;i++)
	{
		if(st.getRowSelFlag(i))
		{
			selectedObj[selectedObj.length] = getTableRowKey(st,i);
		}
	}
    st.clearTableData();
    createTableBody(st, window.tableconf[1], data, RESOURCE);
	for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
	{
		if(selectedObj.contains(getTableRowKey(st,i)))
		{
			st.setRowSelect(i);
		}
	}
	selectNETablehandler();
    if (params[0])
    {
		if(params[1].getSErrorCode() > data.getSErrorCode())
		{
			data.setSErrorCode(params[1].getSErrorCode());
			data.setSErrorInfo(params[1].getSErrorInfo());
		}
		if(params[1].getError())
		{
			data.getError().rowErrors = data.getError().rowErrors.concat(params[1].getError().rowErrors);
		}
        showErrorMessage(data);
    }
}

/**
 *       
 * @param {Object} data
 */
function showErrorMessage(/* Object */data)
{
    var errArr = [];
    errArr[0] = "errObjStr";
    var oError = data.getError();
    var errObjStr = "";
    if (data.getBErrLength() > 0) 
    {
        for (var i = 0; i < data.getBErrLength(); i++) 
        {
            tempErrObjStr = "";
            nename = "";
            if (null != oError.getRowKey(i, "nename") && "" != oError.getRowKey(i, "nename")) 
            {
                nename = oError.getRowKey(i, "nename");
            }
            if (null != oError.getRowKey(i, "source") && "" != oError.getRowKey(i, "source")) 
            {
                tempErrObjStr += RESOURCE["source"] + ":" + nename + "-" + oError.getRowKey(i, "source");
            }
            if (null != oError.getRowKey(i, "sink") && "" != oError.getRowKey(i, "sink")) 
            {
                tempErrObjStr += "," + RESOURCE["sink"] + ":" + nename + "-" + oError.getRowKey(i, "sink");
            }
			if(tempErrObjStr == "")
			{
				tempErrObjStr = winurlobj.subrackname + "-" + getSlotIDFromSlot(winurlobj.slotid) + "-" + winurlobj.boardname;
			}
            oError.rowErrors[i].errorObj["errObjStr"] = tempErrObjStr;
        }
    }
    openErrPage("../../../../page/", oError, errArr);
    errArr = null;
}

/**
 *         
 */
function deleteNEFiber()
{
    hideMenu();
    if (!confirm(RESOURCE["confirmdelete"])) 
    {
        return;
    }

    var xml = createDeleteNEFiberXML();
    if (xml == null) 
    {
        return;
    }

	$("deletebtn").disabled = true;
    loadXMLdoc("../../../../neExlorerServlet?sfid=" + TECMDCODE_NF_DELETEFIBER, "POST", true, deleteNEFiberCallback, null, "inputdata=" + xml);
}

/**
 *           XML
 *             
 * @return XML
 */
function createDeleteNEFiberXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var selectedRows = st.getSelectedRows();
    for (var i = 0, len = selectedRows.length; i < len; i++) 
    {
        var rowindex = selectedRows[i];
        var srcPort = st.getCellShow(rowindex, "srcPort").getValue();
        var srcNEID = st.getCellStoreValue(rowindex, "srcNE", "srcNE");
        var srcSoltID = st.getCellStoreValue(rowindex, "srcPort", "srcSlot");
        var srcPortID = st.getCellStoreValue(rowindex, "srcPort", "srcPort");
        
        var snkPort = st.getCellShow(rowindex, "snkPort").getValue();
        var snkNEID = st.getCellStoreValue(rowindex, "snkNE", "snkNE");
        var snkSoltID = st.getCellStoreValue(rowindex, "snkPort", "snkSlot");
        var snkPortID = st.getCellStoreValue(rowindex, "snkPort", "snkPort");
        
        var row = new tagElement("row-params");
        var param = new tagElement("param", "neid", winurlobj.neid);
        row.appendChild(param);
        param = new tagElement("param", "source", srcPort);
        row.appendChild(param);
        param = new tagElement("param", "srcneid", srcNEID);
        row.appendChild(param);
        param = new tagElement("param", "srcsoltid", srcSoltID);
        row.appendChild(param);
        param = new tagElement("param", "srcportid", srcPortID);
        row.appendChild(param);
        param = new tagElement("param", "snkneid", snkNEID);
        row.appendChild(param);
        param = new tagElement("param", "snksoltid", snkSoltID);
        row.appendChild(param);
        param = new tagElement("param", "sink", snkPort);
        row.appendChild(param);
        param = new tagElement("param", "snkportid", snkPortID);
        row.appendChild(param);
        bussiness.appendChild(row);
    }
    if (bussiness.childNodes.length <= 0) 
    {
        return null;
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *           
 * @param {Object} doc
 */
function deleteNEFiberCallback(/*XMLDOM*/doc)
{
    var data = EncapsulateData(doc);
    if (data.getSErrorCode() == OPERATION_SUCCESS 
		|| data.getSErrorCode() == OPERATION_PART_SUCCESS) 
    {
        queryNEFiber(false);
        $("deletebtn").disabled = true;
    }
    else
	{
		$("deletebtn").disabled = false;
	}
    showErrorMessage(data);
}

/**
 *        
 *              
 */
function createNEFiber()
{
    hideMenu();
	
	var xml = createCreateNEFiberXML();
    if (xml == null) 
    {
        return;
    }
	$("createbtn").disabled = true;
	var URL = "../../../../neExlorerServlet?sfid=" + TECMDCODE_NF_CREATEFIBER;
    loadXMLdoc(URL, "POST", true, createNEFiberCallback, null, "inputdata=" + xml);
}

/**
 *        
 *                 ,           
 */
function createCreateNEFiberXML()
{
    var root = new inputxml("datainterface");
    var firstlevel = new tagElement("bussiness-params");
    var selectedRows = referencest.getSelectedRows();
    for (var i = 0, len = selectedRows.length; i < len; i++) 
    {
        var rowindex = selectedRows[i];
		var secondlevel = new tagElement("row-params");
        var thirdlevel = new tagElement("param", "neid", winurlobj.neid);
        secondlevel.appendChild(thirdlevel);
        
        thirdlevel = new tagElement("param", "srcneid", referencest.getCellStoreValue(rowindex, "srcNE", "srcNE"));
        secondlevel.appendChild(thirdlevel);
        thirdlevel = new tagElement("param", "srcsoltid", referencest.getCellStoreValue(rowindex, "srcPort", "srcSlot"));
        secondlevel.appendChild(thirdlevel);
        thirdlevel = new tagElement("param", "srcportid", referencest.getCellStoreValue(rowindex, "srcPort", "srcPort"));
        secondlevel.appendChild(thirdlevel);
        thirdlevel = new tagElement("param", "source", referencest.getCellShow(rowindex, "srcPort").getValue());
        secondlevel.appendChild(thirdlevel);
        
        thirdlevel = new tagElement("param","snkneid",referencest.getCellStoreValue(rowindex, "snkNE", "snkNE"));
        secondlevel.appendChild(thirdlevel);
        thirdlevel = new tagElement("param","snksoltid",referencest.getCellStoreValue(rowindex, "snkPort", "snkSlot"));
        secondlevel.appendChild(thirdlevel);
        thirdlevel = new tagElement("param","snkportid",referencest.getCellStoreValue(rowindex, "snkPort", "snkPort"));
        secondlevel.appendChild(thirdlevel);
        thirdlevel = new tagElement("param","sink",referencest.getCellShow(rowindex, "snkPort").getValue());
        secondlevel.appendChild(thirdlevel);
		firstlevel.appendChild(secondlevel);
    }
    if (secondlevel.childNodes.length <= 0) 
    {
        return null;
    }
	root.getRoot().appendChild(firstlevel);
	
    return root.toString();
}
/**
 *           
 * @param {Object} doc
 */
function createNEFiberCallback(/*XMLDOM*/doc)
{
	var data = EncapsulateData(doc);
    if (data.getSErrorCode() == OPERATION_SUCCESS 
		|| data.getSErrorCode() == OPERATION_PART_SUCCESS) 
    {
        queryNEFiber(false);
        $("createbtn").disabled = true;
    }
	else
	{
		$("createbtn").disabled = false;
	}
	showErrorMessage(data);
}

/**
 *       
 */
function adjustTableHeight()
{
	var height = getComponetHeight($("tableContainer"),150);
	referencest.setBodyHeight(height/2 + "px");
	st.setBodyHeight(height/2 + "px");
	
}
