var infomation = getNeProperty(parent);
var PORTID_3 = 3;
var PORTID_7 = 7;

var btnRightArr = new Object();

function modeSet(button)
{
	queryPortServiceType(button);
}

/**
 * Get port's service type
 * 
 * @param button
 * @return
 */
function queryPortServiceType(button)
{
	var xmlstr = createGetServiceTypeXML(button);
	if (null == xmlstr)
	{
		return;
	}
	loadXMLdoc("../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_FC_SERVICETYPE, "POST",
			true, doAnalyseServiceType, null, "inputdata=" + xmlstr);
}

function createGetServiceTypeXML(button)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	addParam(row, newParam("neid", infomation["neid"]));
	addParam(row, newParam("slotid", infomation["slotid"]));
	if (button.id == "apply_port3")
	{
		addParam(row, newParam("port", 201));
		addParam(row, newParam("path", 1));
	}
	else
	{
		addParam(row, newParam("port", 201));
		addParam(row, newParam("path", 5));
	}
	addParam(row, newParam("path", 1));
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function addParam(row, param)
{
	row.appendChild(param);
}

function newParam(name, value)
{
	var param = new tagElement("param");
	param.setAttribute("name", name);
	param.setAttribute("value", value);
	return param;
}

function initButton()
{
	$("apply_port3").value = RESOURCE["apply"];
	$("apply_port7").value = RESOURCE["apply"];
	btnRightArr.query = new BtnRightObj("query", TECMDCODE_OTN_GET_PORTMODE);
	btnRightArr.apply_port3 = new BtnRightObj("apply_port3", TECMDCODE_OTN_SET_PORTMODE);    
  btnRightArr.apply_port7 = new BtnRightObj("apply_port7", TECMDCODE_OTN_SET_PORTMODE);
  getRightInfo(infomation,btnRightArr);

  $("apply_port3").disabled = !btnRightArr.apply_port3.right;
	$("apply_port7").disabled = !btnRightArr.apply_port7.right;
}

/**
 * Get FC mode,testing mode or service mode
 * 
 * @return
 */
function getFCMode()
{
	if(!btnRightArr.query.right)
	{
		return;
	}
	var xmlstr = createGetFCModeyXML();
	if (null == xmlstr)
	{
		return;
	}
	loadXMLdoc("../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_FC_TESTFLAG, "POST",
			true, doAnalyseFCMode, null, "inputdata=" + xmlstr);
}

function createGetFCModeyXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	addParam(row, newParam("neid", infomation["neid"]));
	addParam(row, newParam("slotId", infomation["slotid"]));
	addParam(row, newParam("portNum", PORTID_3));
	bussiness.appendChild(row);

	row = new tagElement("row-params");
	addParam(row, newParam("neid", infomation["neid"]));
	addParam(row, newParam("slotId", infomation["slotid"]));
	addParam(row, newParam("portNum", PORTID_7));
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

/**
 * Parse the result and refresh the radio button's checked state
 * 
 * @param doc
 * @return
 */
function doAnalyseFCMode(doc)
{
	var data = EncapsulateData(doc);
	showErrorDialog(data);
	if (data.getSErrorCode() != 0)
	{
		return;
	}
	for ( var i = 0; i < data.getDataRowLength(); i++)
	{
		var obj = data.rows[i];
		fcmode = obj["state"].value;
		portid = obj["portNum"].value;
		if (portid == PORTID_3)
		{
			if (fcmode == 0)
			{
				businessmode_port3.checked = true;
			}
			else
			{
				testmode_port3.checked = true;
			}
		}
		else
		{
			if (fcmode == 0)
			{
				businessmode_port7.checked = true;
			}
			else
			{
				testmode_port7.checked = true;
			}
		}
	}
}

/**
 * Parse the result
 * 
 * @param doc
 * @return
 */
function doAnalyseServiceType(doc)
{
	var data = EncapsulateData(doc);
	showErrorDialog(data);
	var state;
	var path;
	if (data.getSErrorCode() != 0)
	{
		return;
	}
	type = data.getDataRowParam(0, "W32PORT_ATTR_ST_SERVICETYPE");
	path = data.getDataRowParam(0, "path");
	var typeflag = false;
	if (path == 1)
	{
		if ($("businessmode_port3").checked == false)
		{
			typeflag = true;
		}
		else
		{	
			clearInterval(parent.frames[1].port3TestHandle);
		}
	}
	else
	{
		if ($("businessmode_port7").checked == false)
		{
			typeflag = true;
		}
		else
		{
			clearInterval(parent.frames[1].port7TestHandle);
		}
	}
	if (type != 0 && typeflag)
	{
		alert(RESOURCE["serviceTypeNotAllow"]);
		if(path == 1)
		{
			$("businessmode_port3").checked = true;
		}
		else
		{
			$("businessmode_port7").checked = true;
		}
		return;
	}

	var xmlstr = createSetTestModeXML(path);
	if (null == xmlstr)
	{
		return;
	}
	loadXMLdoc("../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_FC_TESTFLAG, "POST",
			true, analysePortMode, null, "inputdata=" + xmlstr);
}

function createSetTestModeXML(port)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	addParam(row, newParam("neid", infomation["neid"]));
	addParam(row, newParam("slotId", infomation["slotid"]));
	if (port == 1)
	{
		addParam(row, newParam("portNum", PORTID_3));
		var modevalue = 0;
		if ($("businessmode_port3").checked == false)
		{
			modevalue = 1;
		}
		addParam(row, newParam("state", modevalue));
	}
	else
	{
		addParam(row, newParam("portNum", PORTID_7));
		modevalue = 0;
		if ($("businessmode_port7").checked == false)
		{
			modevalue = 1;
		}
		addParam(row, newParam("state", modevalue));
	}
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function analysePortMode(doc)
{
	var data = EncapsulateData(doc);
	showErrorDialog(data);
	if (data.getSErrorCode() == 0)
	{
		alert(RESOURCE["succeed"]);
	}
}

function showErrorDialog(data, isSetFlag)
{
	var errArr = [];
	errArr[0] = "nename";
	errArr[1] = "slotId";
	errArr[2] = "boardname";
	errArr[3] = "portNum";
	openErrPage("../../../../page/", data.getError(), errArr);
}
