var win = getParentWindow();
var winurlobj = getNeProperty(self);
var resList = win.resourceList;

document.title = RESOURCE["createDLAG"];

/**
 *      
 */
function initPage()
{	
	$("aggregationNO").value = win.getMinAvailableID();
	checkText($("aggregationNO"), "1", "64");//    ID  1~64
	checkTextData($("aggregationName"), 31);//      31   
	
	$("revertiveMode").options[0] = new Option(RESOURCE["revertive"],1);
	$("revertiveMode").options[1] = new Option(RESOURCE["noRevertive"],0);

	for(var key in resList)
	{
		if(!resList[key])
		{
			continue;
		}

		if(resList[key].isFromboard == null || resList[key].isFromboard.value == "false")
		{
		   var slotid = getSlotIDFromSlot(resList[key].slotid.value)
		   var tempBoardInfo = slotid + "-" + resList[key].boardName.value;
		   if(resList[key].subrack != null)
		   {
			   tempBoardInfo = resList[key].subrack.value + "-" + tempBoardInfo;
		   }   
		   addOptionToSelect($("mainBoard"),new Option(tempBoardInfo, resList[key].slotid.value));
		}
	}
	
	if(null != $("mainBoard").options[0])
	{
	    mainBoardOnchange($("mainBoard").options[0].value);
	}
	
	$("mainBoard").onchange = function()
	{
		mainBoardOnchange(this.value);
	}
	
	if(null != $("slaveBoard").options[0])
	{
	    slaveBoardOnchange($("slaveBoard").options[0].value);
	}
	
	$("slaveBoard").onchange = function()
	{
		slaveBoardOnchange(this.value);
	}
	
	$("okbtn").value=RESOURCE["okbutton"];
	$("cancelbtn").value=RESOURCE["cancelbutton"];
	$("applybtn").value=RESOURCE["applybutton"];
}


/**
 *         
 */
function mainBoardOnchange(slotid)
{
	var mainBoard = resList[slotid];
	var macPortList = mainBoard.getMacPort();
	$("mainPort").options.length = 0;//        
	for(var i = 0,size = macPortList.length; i < size; i++)
	{
		addOptionToSelect($("mainPort"),new Option(macPortList[i], macPortList[i].portid));
	}
	
	$("slaveBoard").options.length = 0;
	for(var key in resList)
	{
		if(!resList[key])
		{
			continue;
		}		
		if((mainBoard.slotid.value != resList[key].slotid.value)
				&& (mainBoard.boardType.value == resList[key].boardType.value)
				&& resList[key].hasService.value == "false")
		{
			var slotid = getSlotIDFromSlot(resList[key].slotid.value);
			var tempBoardInfo = slotid + "-" + resList[key].boardName.value;
			if (resList[key].subrack != null)
			{
				tempBoardInfo = resList[key].subrack.value + "-" + tempBoardInfo;
			}			
			
			addOptionToSelect($("slaveBoard"),new Option(tempBoardInfo, resList[key].slotid.value));
		}
	}
	if($("slaveBoard").options.length > 0)
	{
		slaveBoardOnchange($("slaveBoard").options[0].value);
	}
	else
	{
		$("slavePort").options.length = 0;
	}
}

/**
 *           
 */
function slaveBoardOnchange(slotid)
{
	$("slavePort").options.length = 0;
	var macPortList = resList[slotid].getMacPort();
	for(var i=0,size=macPortList.length;i<size;i++)
	{
		addOptionToSelect($("slavePort"),new Option(macPortList[i], macPortList[i].portid));
	}
}


/**
 * 
 */
function getResIndexFromSlotid(slotid)
{
	for(var i=0,size=resList.length;i<size;i++)
	{
		if(resList[i].slotid == slotid)
		{
			return i;
		}
	}
	return -1;
}

function checkResource()
{
	var mainBoard = $("mainBoard").value;
	var mainPort = $("mainPort").value;
	var slaveBoard = $("slaveBoard").value;
	var slavePort = $("slavePort").value;
	return ((mainBoard == "") || (mainPort == "") || (slaveBoard == "") || (slavePort == ""))
}


/**
 *       
 */
function sendCreateInfo(elem)
{
	if($("aggregationNO").value == "")
  {
      alert(RESOURCE["LAG_INPUT_LAGID"]);	
      return;
  }
  
  if ($("aggregationName").value.trim() == "")
  {
  	  alert(RESOURCE["LAG_INPUT_LAGNAME"]);
  	  return;
  }
    
  if(checkResource())
  {
  	alert(RESOURCE["DLAG_CREATE_NOSOURCE"]);
  	return;
  }
    
  var isRepeat = false;
  for(var j = 0, m = win.st.getDataRowLength(); j < m; j++)
	{
		var mainPort = win.st.getCellStoreValue(j, "dlagID", "dlagID");
		if(mainPort == $("aggregationNO").value)
		{
			isRepeat = true;
			break;
		}		
	}
	
	if(isRepeat)
	{
		alert(RESOURCE["id_is_exist"]);	
    return;
	}
     
  if(!confirm(RESOURCE["DANGER"]))
  {
  	return;
  }
	$("okbtn").disabled = true;
	$("applybtn").disabled = true;  
  var okOrApply = "";
  if(elem.id == "okbtn")
  {
  	okOrApply = "ok"
  }
  else
  {
  	okOrApply = "apply";
  }
  
  var xml = createXML();
  var URL = "../../../../neExlorerServlet?sfid="+TECMDCODE_CREATE_DLAG+"&nmUser="+winurlobj["nmUser"];
  loadXMLdoc(URL,"POST",true,createCallBack,okOrApply,"inputdata="+xml);
}

/**
 *    xml
 */
function createXML()
{
    var di =new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    var neid = winurlobj["neid"];
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","dlagID");
    param.setAttribute("value",$("aggregationNO").value);
    row.appendChild(param);
    
		param = new tagElement("param");
		param.setAttribute("name","aggregationName");
		param.setAttribute("value",$("aggregationName").value);
		row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","revertiveMode");
    param.setAttribute("value",$("revertiveMode").value);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","revertiveModeName");
    param.setAttribute("value",$("revertiveMode").options[$("revertiveMode").options.selectedIndex].innerHTML);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","mainBoard");
    param.setAttribute("value",$("mainBoard").value);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","mainBoardName");
    param.setAttribute("value",$("mainBoard").options[$("mainBoard").options.selectedIndex].innerHTML);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","mainPort");
    param.setAttribute("value",$("mainPort").value);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","mainPortName");
    param.setAttribute("value",$("mainPort").options[$("mainPort").options.selectedIndex].innerHTML);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","slaveBoard");
    param.setAttribute("value",$("slaveBoard").value);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","slaveBoardName");
    param.setAttribute("value",$("slaveBoard").options[$("slaveBoard").options.selectedIndex].innerHTML);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","slavePort");
    param.setAttribute("value",$("slavePort").value);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","slavePortName");
    param.setAttribute("value",$("slavePort").options[$("slavePort").options.selectedIndex].innerHTML);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *          
 */
function createCallBack(doc, okOrApply)
{
	$("okbtn").disabled = false;
	$("applybtn").disabled = false;
	
  var data = EncapsulateData(doc);
  if(data.getSErrorCode() != 0)
  {
  	showErrorDialog(data);
  	return;
  }
  
  win.sendQueryInfo();
	if(okOrApply == "ok")//           
  {
  	if (isIE)
	{
	    xcloseDialog();
	} else {
	    getParentWindow().closeSpecifyDialog("createdlag.html");
	}
	
	return;
  }
  
  var isMainBoardChange = false;
  $("aggregationNO").value = win.getMinAvailableID();
  var mainPortIndex = $("mainPort").options.selectedIndex;
  var mainPort = resList[$("mainBoard").value].getMacPort();
  $("mainPort").remove(mainPortIndex);
  mainPort.removeAt(mainPortIndex);
  if(mainPort.length==0)
  {
  	resList[$("mainBoard").value] = null;
  	$("mainBoard").remove($("mainBoard").options.selectedIndex);
  	if($("mainBoard").options.length > 0)
  	{
  		$("mainBoard").selectedIndex = 0;
  		isMainBoardChange = true;
  	}
  }
  else
  {
  	$("mainPort").selectedIndex = 0;
  }
  
  var slavePortIndex = $("slavePort").options.selectedIndex;
  var slavePort = resList[$("slaveBoard").value].getMacPort();
  $("slavePort").remove(slavePortIndex);
  slavePort.removeAt(slavePortIndex);
  if(slavePort.length==0)
  {
  	resList[$("slaveBoard").value] = null;
  	for(var i = 0, len = $("mainBoard").options.length; i < len; i++)
  	{
  		if($("mainBoard").options[i].value == $("slaveBoard").value)
  		{
  			$("mainBoard").remove(i);//                  
  			if($("mainBoard").options.length > 0)
  			{
  				$("mainBoard").selectedIndex = 0;
  			}  
  			break;	
  		}
  	}
  	isMainBoardChange = true;
  }
  else
  {
  	$("slavePort").selectedIndex = 0;
  }
  
  if(isMainBoardChange == true)
  {
  	mainBoardOnchange($("mainBoard").value);
  }
}


function showErrorDialog(data)
{
		var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "dlagID";
    
    for(var i = 0; i < data.getBErrLength(); i++)
    {
    	errorObj = data.getError().rowErrors[i].errorObj;
    	
    	errorObj["dlagID"] = RESOURCE["aggregationNO"] + ":" + errorObj["dlagID"];
    }    
    openErrPage("../../../../page/", data.getError(), errArr); 
}

