var st0 = null; //     
var st1 = null; //  VLAN  
var btnRightArr = new Object(); //            
var protocol = new Object(); //    
protocol[0] = "Disable";
protocol[1] = "ARP";
protocol[2] = "VRRP";
protocol[3] = "ALL";

var workstatus = new Object(); //     
workstatus[0] = RESOURCE["init"];
workstatus[1] = RESOURCE["master"];
workstatus[2] = RESOURCE["slave"];

var position = null; //     
var rightFlag = false; //        
var resources = null;

var obj = getNeProperty(self);
var neid = obj["neid"];
var nmUser = obj["nmUser"];

/*
 *      
 */
function init()
{
    $("dbpslabel").innerText = RESOURCE["dbpslabel"];
    $("vlanlabel").innerText = RESOURCE["vlanlabel"];
    
    initTable();
    initButton();
    
    if (btnRightArr["querybtn"].right) 
    {
        dbpsQuery();
    }
}

/*
 *      
 */
function initTable()
{
    st0 = new SortTable();
    st0.setImage("../../../../images/");
    createTableHead(st0, window.tableconf[0]);
    $("dbpsTable").appendChild(st0.getTable());
    st0.setOnRowSelectHandler(rowSelectHandler0);
    st0.setOnCellEditHandler(cellEditHandler);
    $("dbpsTable").oncontextmenu = rightClickEvent;
    adjustTableLayout(st0, window.tableconf[0], 0);
    
    st1 = new SortTable();
    st1.setImage("../../../../images/");
    createTableHead(st1, window.tableconf[1]);
    $("vlanTable").appendChild(st1.getTable());
    st1.setOnRowSelectHandler(rowSelectHandler1);
    
    var tableHeight = getComponetHeight($("ttbody"), 170) * 0.4;
    tableHeight = tableHeight < 100 ? 100 : tableHeight;
    st0.setBodyHeight(tableHeight + "px");
    st1.setBodyHeight(tableHeight + "px");
    $("dbpsTable").style.height = (tableHeight + 46) + "px";
    $("vlanTable").style.height = (tableHeight + 46) + "px";
}

/*
 *              
 */
function initButton()
{
    $("query").value = RESOURCE["querybutton"];
    $("new").value = RESOURCE["newbutton"];
    $("delete").value = RESOURCE["deletebutton"];
    $("apply").value = RESOURCE["applybutton"];
    $("addvlan").value = RESOURCE["addvlanbutton"];
    $("deletevlan").value = RESOURCE["deletevlanbutton"];
    
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_QUERY_DBPS);
    btnRightArr.newbtn = new BtnRightObj("newbtn", TECMDCODE_NEW_DBPS);
    btnRightArr.deletebtn = new BtnRightObj("deletebtn", TECMDCODE_DELETE_DBPS);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_MODIFY_DBPS);
    btnRightArr.addvlanbtn = new BtnRightObj("addvlanbtn", TECMDCODE_ADD_DBPS_VLAN);
    btnRightArr.delvlanbtn = new BtnRightObj("delvlanbtn", TECMDCODE_DEL_VLAN_DBPS);
    
    getRightInfo(obj, btnRightArr);
    
    $("query").disabled = !btnRightArr["querybtn"].right;
    $("new").disabled = !btnRightArr["newbtn"].right;
}

/*
 *            
 */
function rowSelectHandler0(param)
{
    if (param.length == 0) 
    {
        st1.clearTableData(); //        
        $("delete").disabled = true;
        $("addvlan").disabled = true;
    }
    else if (param.length == 1) 
    {
        $("delete").disabled = !btnRightArr["deletebtn"].right;
        $("addvlan").disabled = !btnRightArr["addvlanbtn"].right;
        var dbpsId = st0.getCellStoreValue(param[0], "groupId", "groupId"); //                ID 
        vlanQuery(dbpsId); //   DBPS      VLAN
    }
    else 
    {
        st1.clearTableData(); //        
        $("delete").disabled = !btnRightArr["deletebtn"].right;
        $("addvlan").disabled = true;
    }
    $("deletevlan").disabled = true;
}

/*
 *   VLAN          
 */
function rowSelectHandler1(param)
{
    if (param.length == 0) 
    {
        $("deletevlan").disabled = true;
        return;
    }
    $("deletevlan").disabled = !btnRightArr["delvlanbtn"].right;
}

/*
 *          
 */
function rightClickEvent(evt)
{
    if (!evt) 
    {
        evt = window.event;
    }
    
    var elem = (evt.target) ? evt.target : evt.srcElement;
    
    if (elem != null && elem.blur) 
    {
        elem.blur();
    }
    
    while (elem != null) 
    {
        if (elem.tagName == 'TD') 
        {
            break;
        }
        else 
        {
            elem = elem.parentNode;
        }
    }
    
    if (elem == null || elem.tagName != 'TD' || null == elem.parent) 
    {
        return;
    }
    
    var rowid = elem.parentNode.rowIndex;
    var rows = elem.parent.getSelectedRows();
    if (rows.length > 1) 
        return;
    var colid = elem.colid;
    if (rows.contains(rowid)) 
    {
        if (colid == "protocol") 
        {
            for (var i = 0, m = rows.length; i < m; i++) 
            {
                var tmpElem = elem.parent.getCellElement(rows[i], colid);
                if (null != tmpElem.editElement && tmpElem.isEdit == 1) 
                {
                    createTablePopupMenu(tmpElem, evt);
                    return;
                }
            }
        }
        else if (colid == "wbras" || colid == "pbras" || colid == "wcomm" || colid == "pcomm") 
        {
            if (elem.isEdit == 0) 
                return;
            hideMenu();
            createFuncDOMenu(elem);
            showMenu(evt);
            return;
        }
        else if (colid == "portlist") 
        {
            hideMenu();
            xshowModalDialog("../dbps_v2r7c02/portconfig.html", RESOURCE["portconfig"], 440, 360, "../../../../images/");
        }
        else if (colid == "wserport") 
        {
            hideMenu();
            xshowModalDialog("serportconfig.html?stype=0", RESOURCE["serportconfig"], 440, 360, "../../../../images/");
        }
        else if (colid == "pserport") 
        {
            hideMenu();
            xshowModalDialog("serportconfig.html?stype=1", RESOURCE["serportconfig"], 440, 360, "../../../../images/");
        }
    }
}

/*
 *       
 */
function createFuncDOMenu(param)
{
    addCellEvent(param, true);
}

/*
 *           
 */
function cellEditHandler(param)
{
    $("apply").disabled = !btnRightArr.applybtn.right;
    if (param.colid != "wbras" && param.colid != "pbras" && param.colid != "wcomm" && param.colid != "pcomm") 
    {
        return;
    }
    
    if (param.stage == TABLE_CONSTANT.BEFOREEDIT) 
    {
        addCellEvent(param, false);
    }
}

function addCellListener()
{
    var cell = null;
    for (var i = 0, m = st0.getDataRowLength(); i < m; i++) 
    {
        var pSlotId = st0.getCellStoreValue(i, "pslotid", "pslotid");
        if (pSlotId == 0) 
        {
            st0.getCellShow(i, "pslot").element.innerText = "---";
            cell = st0.getCell(i, "pbras");
            setCellNoEdit(cell);
            
            cell = st0.getCell(i, "pcomm");
            setCellNoEdit(cell);
            
            cell = st0.getCell(i, "pserport");
            setCellNoEdit(cell);
        }
        else 
        {
            cell = st0.getCell(i, "pserport");
            cell.element.ondblclick = function()
            {
                xshowModalDialog("serportconfig.html?stype=1", RESOURCE["serportconfig"], 440, 360, "../../../../images/");
            }
        }
        
        cell = st0.getCell(i, "wserport");
        cell.element.ondblclick = function()
        {
            xshowModalDialog("serportconfig.html?stype=0", RESOURCE["serportconfig"], 440, 360, "../../../../images/");
        }
        
        cell = st0.getCell(i, "portlist");
        cell.element.ondblclick = function()
        {
            xshowModalDialog("../dbps_v2r7c02/portconfig.html", RESOURCE["portconfig"], 440, 360, "../../../../images/");
        }
    }
}

function setCellNoEdit(cell)
{
    st0.setCellIsEdit(cell, "0");
    cell.element.ondblclick = null;
}

/*
 *         
 */
function addCellEvent(param, rFlag)
{
    position = param;
    rightFlag = rFlag;
    var colid = param.colid;
    var slotId = null;
    var portType = "ALL";
    var index = st0.getSelectedRows()[0];
    var wboardname = st0.getCellStoreValue(index, "wboardname", "wboardname");//   
    if (param.colid == "wbras" || param.colid == "wcomm") 
    {
        slotId = st0.getCellStoreValue(index, "wslotid", "wslotid");
    }
    else 
    {
        slotId = st0.getCellStoreValue(index, "pslotid", "pslotid");
    }
    if (param.colid == "wbras" || param.colid == "pbras") 
    {
    	if (wboardname != "TBE") //TBE      
    	{
    		portType = "IP";
    	}
    }
    getAvailPort(neid, slotId, portType);
}

/* 100     
 * portId: "327686-TBE-1-5-subrack5-6"
 */
function getDBClickPortName(portId)
{
    var str = "";
    var arr = portId.split("-");
    if (arr[3] < "0") 
    {
        str = arr[0] + "-" + arr[1] + "-" + getPortName(arr[2]);
    }
    else 
    {
        str = arr[4] + "-" + arr[5] + "-" + arr[1] + "-" + getPortName(arr[2]);
    }
    return str;
}

/*
 *             
 */
function callbackGetPort(doc)
{
    var data = EncapsulateData(doc);
    if (data.getDataRowLength() > 0) 
    {
        if (!rightFlag) 
        {
            var editElement = st0.getCell(st0.getSelectedRows()[0], position.colid).element.editElement;
            editElement.clearOptions();
            var rOptions = data.getDataRowOptions(0, "portid");
            for (var i = 0, m = rOptions.length; i < m; i++) 
            {
                var portId = rOptions[i];
                var option = new Option(getDBClickPortName(portId), portId);
                editElement.addOptionObj(option);
            }
        }
        else 
        {
            removejsDOMmenu();
            var cursorMenu = new jsDOMenu(250);
            var rOptions = data.getDataRowOptions(0, "portid");
            for (var i = 0, m = rOptions.length; i < m; i++) 
            {
                var portId = rOptions[i];
                var portStr = getDBClickPortName(portId);
                cursorMenu.addMenuItem(new menuItem(portStr, "", setOptionValue, [portStr, portId, position]));
            }
            setPopUpMenu(cursorMenu);
        }
    }
}

/*
 *     DBPS     
 */
function dbpsQuery()
{
    $("query").disabled = true;
    $("new").disabled = true;
    $("delete").disabled = true;
    $("apply").disabled = true;
    $("addvlan").disabled = true;
    $("deletevlan").disabled = true;
    
    var xmldata = createQueryXml(); //       
    var urlstr = "../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_DBPS + "&nmUser=" + nmUser; //     url  
    loadXMLdoc(urlstr, "POST", false, callbackQuery, null, "inputdata=" + xmldata);
}

/*
 *     DBPS    XML
 */
function createQueryXml()
{
    var root = new inputxml("datainterface");
    
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = null;
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "groupId");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);
    
    return root.toString();
}

/*
 *   DBPS        
 */
function callbackQuery(doc)
{
    $("query").disabled = !btnRightArr["querybtn"].right;
    $("new").disabled = !btnRightArr["newbtn"].right;
    
    var data = EncapsulateData(doc); //          
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        st0.clearTableData(); //   DBPS          
        createTableBody(st0, window.tableconf[0], data, RESOURCE);
        addCellListener();
        if (st0.getDataRowLength() > 0) 
        {
            st0.setRowSelect(0); //       
            rowSelectHandler0(st0.getSelectedRows()); //        
        }
    }
    
    var errArr = []; //         
    errArr[0] = "nename"; //              
    openErrPage("../../../../page/", data.getError(), errArr); //        
    errArr = null; //    
}

/*
 *           
 */
function dbpsCreate()
{
    getAvailRes();
}

/*
 *        XML
 */
function createGetResXML()
{
    var root = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", obj.neid);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);
    
    return root.toString();
}

/*
 *             
 */
function getAvailRes()
{
    var xmldata = createGetResXML();
    var urlstr = "../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_DBPS_RES + "&nmUser=" + obj.nmUser; //     url  
    loadXMLdoc(urlstr, "POST", true, callbackGetRes, null, "inputdata=" + xmldata);
}

/*
 *              
 */
function callbackGetRes(doc)
{
    resources = EncapsulateData(doc);
    if (resources.getDataRowLength() > 0) 
    {
        xshowModalDialog("../dbps_v2r7c02/dbpscreate.html", RESOURCE["newdbps"], 400, 200, "../../../../images/");
    }
    else 
    {
        alert(RESOURCE["noneresource"]);
    }
}

/*
 *          
 */
function dbpsDelete()
{
    if (st0.getSelectedRowCount() <= 0) 
    {
        alert(RESOURCE["noselect"]);
        return;
    }
    
    $("query").disabled = true;
    $("new").disabled = true;
    $("delete").disabled = true;
    $("apply").disabled = true;
    $("addvlan").disabled = true;
    $("deletevlan").disabled = true;
    
    var xmldata = createDeleteXml(); //       
    var urlstr = "../../../../neExlorerServlet?sfid=" + TECMDCODE_DELETE_DBPS + "&nmUser=" + nmUser; //     url  
    loadXMLdoc(urlstr, "POST", true, callbackDelete, null, "inputdata=" + xmldata);
}

/*
 *           XML
 */
function createDeleteXml()
{
    var root = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;
    
    var selRows = st0.getSelectedRows();
    for (var i = 0, m = selRows.length; i < m; i++) 
    {
        row = new tagElement("row-params");
        
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        row.appendChild(param);
        
        var groupId = st0.getCellStoreValue(selRows[i], "groupId", "groupId");
        param = new tagElement("param");
        param.setAttribute("name", "groupId");
        param.setAttribute("value", groupId);
        row.appendChild(param);
        
        bussiness.appendChild(row);
    }
    
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

/*
 *         XML
 */
function callbackDelete(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    if (0 == data.getSErrorCode())//      
    {
        st1.clearTableData();
        
        var rowIndex = st0.getSelectedRows();
        
        for (var j = 0; j < rowIndex.length; j++) 
        {
            st0.deleteRow(rowIndex[j]);
        }
        st0.adjustDataRows();
    }
    else if (1 == data.getSErrorCode())//    
    {
        var tempGroupID = null;//          ID
        var errObj = data.getError();//AllError          
        var rowErrorArray = errObj.rowErrors;//    RowError  
        var selectedRows = st0.getSelectedRows();
        for (var k = selectedRows.length - 1; k >= 0; k--) 
        {
            var flag = false;
            tempGroupID = st0.getCellStoreValue(selectedRows[k], "groupId", "groupId");
            for (var m = 0, len = rowErrorArray.length; m < len; m++) 
            {
                var errorObj = rowErrorArray[m].errorObj;//    RowError       
                if (tempGroupID == errorObj.groupId) 
                {
                    flag = true;
                }
            }
            if (!flag) 
            {
                st0.deleteRow(selectedRows[k]);
            }
        }
        st0.adjustDataRows();
        
        st1.clearTableData();
        rowSelectHandler0(st0.getSelectedRows());
    }
    else 
    {
        rowSelectHandler0(st0.getSelectedRows());
    }
    if (st0.getDataRowLength() == 0) 
    {
        adjustTableLayout(st0, window.tableconf[0], 0);
    }
    $("query").disabled = !btnRightArr.querybtn.right;
    $("new").disabled = !btnRightArr.newbtn.right;
}

/*
 *              
 */
function dbpsModify()
{
    $("query").disabled = true;
    $("new").disabled = true;
    $("delete").disabled = true;
    $("apply").disabled = true;
    $("addvlan").disabled = true;
    $("deletevlan").disabled = true;
    
    var xmldata = createModifyXml();
    var urlstr = "../../../../neExlorerServlet?sfid=" + TECMDCODE_MODIFY_DBPS + "&nmUser=" + nmUser; //     url  
    loadXMLdoc(urlstr, "POST", true, callbackModify, null, "inputdata=" + xmldata);
}

/*
 *            XML
 */
function createModifyXml()
{
    var root = new inputxml("datainterface"); //     datainterface    
    var firstlevel = new tagElement("bussiness-params"); //          
    for (var i = 0, m = st0.getDataRowLength(); i < m; i++) 
    {
        if (!st0.getModify(i)) 
        {
            continue;
        }
        var groupId = st0.getCellStoreValue(i, "groupId", "groupId");
        if (st0.getCellModify(i, "protocol")) 
        {
            var secondlevel = new tagElement("row-params");
            
            var thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name", "neid");
            thirdlevel.setAttribute("value", neid);
            secondlevel.appendChild(thirdlevel);
            
            thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name", "groupId");
            thirdlevel.setAttribute("value", groupId);
            secondlevel.appendChild(thirdlevel);
            
            thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name", "protocol");
            thirdlevel.setAttribute("value", st0.getCellStoreValue(i, "protocol", "protocol"));
            secondlevel.appendChild(thirdlevel);
            
            firstlevel.appendChild(secondlevel);
        }
        
        if (st0.getCellModify(i, "wbras")) 
        {
            firstlevel.appendChild(createSubXML(i, groupId, true, "wbras"));
        }
        
        if (st0.getCellModify(i, "pbras")) 
        {
            firstlevel.appendChild(createSubXML(i, groupId, true, "pbras"));
        }
        
        if (st0.getCellModify(i, "wcomm")) 
        {
            firstlevel.appendChild(createSubXML(i, groupId, false, "wcomm"));
        }
        
        if (st0.getCellModify(i, "pcomm")) 
        {
            firstlevel.appendChild(createSubXML(i, groupId, false, "pcomm"));
        }
        
        if (st0.getCellModify(i, "portlist")) 
        {
            var secondlevel = new tagElement("row-params");
            
            var thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name", "neid");
            thirdlevel.setAttribute("value", neid);
            secondlevel.appendChild(thirdlevel);
            
            thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name", "groupId");
            thirdlevel.setAttribute("value", groupId);
            secondlevel.appendChild(thirdlevel);
            
            thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name", "slotid");
            thirdlevel.setAttribute("value", st0.getCellStoreValue(i, "wslotid", "wslotid"));
            secondlevel.appendChild(thirdlevel);
            
            thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name", "portstr");
            thirdlevel.setAttribute("value", st0.getCellShow(i, "portlist").element.innerText);
            secondlevel.appendChild(thirdlevel);
            
            var arr = st0.getCellStoreValue(i, "portlist", "portlist").split(",");
            thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name", "num");
            thirdlevel.setAttribute("value", arr.length);
            secondlevel.appendChild(thirdlevel);
            
            thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name", "portlist");
            thirdlevel.setAttribute("value", getProtoTypeData(arr));
            secondlevel.appendChild(thirdlevel);
            
            firstlevel.appendChild(secondlevel);
        }
        
        if (st0.getCellModify(i, "wserport")) 
        {
            var slotid = st0.getCellStoreValue(i, "wslotid", "wslotid");
            var text = st0.getCellShow(i, "wserport").element.innerText;
            var portlist = st0.getCellStoreValue(i, "wserport", "wserport").split(",");
            firstlevel.appendChild(createSerPortXML(groupId, slotid, "wserport", text, portlist));
        }
        
        if (st0.getCellModify(i, "pserport")) 
        {
            var slotid = st0.getCellStoreValue(i, "pslotid", "pslotid");
            var text = st0.getCellShow(i, "pserport").element.innerText;
            var portlist = st0.getCellStoreValue(i, "pserport", "pserport").split(",");
            firstlevel.appendChild(createSerPortXML(groupId, slotid, "pserport", text, portlist));
        }
    }
    root.getRoot().appendChild(firstlevel);
    return root.toString();
}

function getProtoTypeData(array)
{
    var bytes = "";
    for (var i = 0, m = array.length; i < m; i++) 
    {
        var hex = tenToHex(array[i]);
        for (var j = 0, n = hex.length; j < 4 - n; j++) 
        {
            hex = "0" + hex;
        }
        bytes += hex;
    }
    return bytes;
}

/*
 *      
 */
function createSubXML(i, groupId, flag, bras)
{
    var secondlevel = new tagElement("row-params");
    
    var thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "neid");
    thirdlevel.setAttribute("value", neid);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "groupId");
    thirdlevel.setAttribute("value", groupId);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", bras);
    thirdlevel.setAttribute("value", st0.getCellShow(i, bras).element.innerText);
    secondlevel.appendChild(thirdlevel);
    
    var arr = st0.getCellStoreValue(i, bras, bras).split("-");
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "slotid");
    thirdlevel.setAttribute("value", arr[0]);
    secondlevel.appendChild(thirdlevel);
    
    if (flag) 
    {
        thirdlevel = new tagElement("param");
        thirdlevel.setAttribute("name", "num");
        thirdlevel.setAttribute("value", "1");
        secondlevel.appendChild(thirdlevel);
        
        thirdlevel = new tagElement("param");
        thirdlevel.setAttribute("name", "bras");
        var hex = tenToHex(arr[2]);
        for (var k = 0, mn = hex.length; k < 4 - mn; k++) 
        {
            hex = "0" + hex;
        }
        thirdlevel.setAttribute("value", hex);
        secondlevel.appendChild(thirdlevel);
    }
    else 
    {
        thirdlevel = new tagElement("param");
        thirdlevel.setAttribute("name", "comm");
        thirdlevel.setAttribute("value", arr[2]);
        secondlevel.appendChild(thirdlevel);
    }
    
    return secondlevel;
}

function createSerPortXML(groupid, slotid, serport, text, portlist)
{
    var secondlevel = new tagElement("row-params");
    
    var thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "neid");
    thirdlevel.setAttribute("value", neid);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "groupId");
    thirdlevel.setAttribute("value", groupid);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "slotid");
    thirdlevel.setAttribute("value", slotid);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", serport);
    thirdlevel.setAttribute("value", text);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "serportnum");
    thirdlevel.setAttribute("value", portlist.length);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "serport");
    thirdlevel.setAttribute("value", getProtoTypeData(portlist));
    secondlevel.appendChild(thirdlevel);
    
    return secondlevel;
}

/*
 *              
 */
function callbackModify(doc)
{
    $("query").disabled = !btnRightArr["querybtn"].right;
    $("new").disabled = !btnRightArr["newbtn"].right;
    
    var data = EncapsulateData(doc);
    if (data.getSErrorCode() == 0) 
    {
        $("apply").disabled = true;
    }
    else 
    {
        $("apply").disabled = !btnRightArr["applybtn"].right;
    }
    refreshTableState(st0, window.tableconf[0], construct(data));
    rowSelectHandler0(st0.getSelectedRows());
    showErrorDialog(data);
}

function construct(data)
{
    if (0 != data.getSErrorCode() && 1 != data.getSErrorCode()) 
    {
        return data;
    }
    var allError = data.getError();
    for (var i = 0, m = allError.getRowErrLength(); i < m; i++) 
    {
        var rowErr = allError.rowErrors[i].errorObj;
        var groupId = rowErr.groupId;
        if (typeof(rowErr.slotid) != "undefined") 
        {
            var v = rowErr.slotid + "-" + rowErr.boardname + "-";
            if (typeof(rowErr.bras) != "undefined") 
            {
                v += hexToTen(rowErr.bras);
                for (var j = 0, n = st0.getDataRowLength(); j < n; j++) 
                {
                    if (st0.getCellStoreValue(j, "groupId", "groupId") == groupId) 
                    {
                        if (st0.getCellStoreValue(j, "wbras", "wbras") == v) 
                        {
                            rowErr.wbras = v;
                        }
                        else 
                        {
                            rowErr.pbras = v;
                        }
                        break;
                    }
                }
            }
            else if (typeof(rowErr.comm) != "undefined") 
            {
                v += rowErr.comm;
                for (var j = 0, n = st0.getDataRowLength(); j < n; j++) 
                {
                    if (st0.getCellStoreValue(j, "groupId", "groupId") == groupId) 
                    {
                        if (st0.getCellStoreValue(j, "wcomm", "wcomm") == v) 
                        {
                            rowErr.wcomm = v;
                        }
                        else 
                        {
                            rowErr.pcomm = v;
                        }
                        break;
                    }
                }
            }
        }
        else if (typeof(rowErr.portlist) != "undefined") 
        {
            var portlist = rowErr.portlist;
            var list = "";
            for (var k = 0, mn = portlist.length; k < mn; k += 4) 
            {
                list += hexToTen(portlist.substring(k, k + 4)) + ",";
            }
            rowErr.portlist = list.substring(0, list.length - 1);
        }
    }
    return data;
}

/*
 *          VLAN
 */
function vlanQuery(dbpsId)
{
    var xmldata = createGetVlanXml(dbpsId);
    var urlstr = "../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_VLAN_DBPS + "&nmUser=" + nmUser;
    loadXMLdoc(urlstr, "POST", true, callbackGetVlan, null, "inputdata=" + xmldata);
}

/*
 *          VLAN XML
 */
function createGetVlanXml(dbpsId)
{
    var root = new inputxml("datainterface");
    
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = null;
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "groupId");
    param.setAttribute("value", dbpsId);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

/*
 *        VLAN     
 */
function callbackGetVlan(doc)
{
    var data = EncapsulateData(doc); //          
    st1.clearTableData(); //   DBPS     VLAN       
    if (data.getSErrorCode() == 0) 
    {
        createTableBody(st1, window.tableconf[1], data, RESOURCE);
        for (var i = 0, len = st1.getDataRowLength(); i < len; i++) 
        {
            var vlan = parseInt(st1.getCellStoreValue(i, "startvlan", "startvlan"));
            if (vlan == 65535) 
            {
                st1.getCellShow(i, "startvlan").element.innerHTML = RESOURCE["arbitrarytxt"];
                st1.getCellShow(i, "endvlan").element.innerHTML = RESOURCE["arbitrarytxt"];
                if (!$("addvlan").disabled) 
                {
                    $("addvlan").disabled = true;
                }
            }
        }
    }
    showErrorDialog(data);
}

/*
 *          VLAN    
 */
function vlanAdd()
{
    var selRows = st0.getSelectedRows();
    var groupId = st0.getCellStoreValue(selRows[0], "groupId", "groupId");
    xshowModalDialog("../dbps_v2r7c02/addvlan.html?neid=" + neid + "&groupId=" + groupId, RESOURCE["newdbps"], 400, 200, "../../../../images/");
}

/*
 *          VLAN   
 */
function vlanDelete()
{
    if (st1.getSelectedRowCount() <= 0) 
    {
        alert(RESOURCE["noselect"]);
        return;
    }
    
    var selIndex = st0.getSelectedRows()[0];
    var dbpsId = st0.getCellStoreValue(selIndex, "groupId", "groupId");
    var xmldata = createDelVlanXml(dbpsId);
    
    var urlstr = "../../../../neExlorerServlet?sfid=" + TECMDCODE_DEL_VLAN_DBPS + "&nmUser=" + nmUser;
    loadXMLdoc(urlstr, "POST", true, callbackDelVlan, null, "inputdata=" + xmldata);
}

/*
 *          VLAN XML
 */
function createDelVlanXml(dbpsId)
{
    var root = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;
    
    var selRows = st1.getSelectedRows();
    for (var i = 0, m = selRows.length; i < m; i++) 
    {
        row = new tagElement("row-params");
        
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "groupId");
        param.setAttribute("value", dbpsId);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "startvlan");
        param.setAttribute("value", st1.getCellStoreValue(selRows[i], "startvlan", "startvlan"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "startvlanstr");
        param.setAttribute("value", st1.getCellShow(selRows[i], "startvlan").element.innerHTML);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "endvlan");
        param.setAttribute("value", st1.getCellStoreValue(selRows[i], "endvlan", "endvlan"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "endvlanstr");
        param.setAttribute("value", st1.getCellShow(selRows[i], "endvlan").element.innerHTML);
        row.appendChild(param);
        
        bussiness.appendChild(row);
    }
    
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

/*
 *        VLAN     
 */
function callbackDelVlan(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    if (0 == data.getSErrorCode() || 1 == data.getSErrorCode()) 
    {
        var selectedIndexes = st1.getSelectedRows();
        for (var i = 0, length = data.getBErrLength(); i < length; i++) 
        {
            var startVlan = data.getBErrParam(i, "startVlan");
            for (var j = selectedIndexes.length - 1; j >= 0; j--) 
            {
                var rowIndex = selectedIndexes[j]
                var staVlan = st1.getCellStoreValue(rowIndex, "startVlan", "startVlan");
                if (staVlan == startVlan) 
                {
                    delete (selectedIndexes[j]);
                }
            }
        }
        for (var k = selectedIndexes.length - 1; k >= 0; k--) 
        {
            var index = selectedIndexes[k];
            if (index != null) 
            {
                st1.deleteRow(index);
            }
        }
        st1.adjustDataRows();
    }
    
    $("query").disabled = !btnRightArr.querybtn.right;
    $("new").disabled = !btnRightArr.newbtn.right;
    $("delete").disabled = !btnRightArr.deletebtn.right;
    $("addvlan").disabled = !btnRightArr.addvlanbtn.right;
    
    if (st1.getSelectedRowCount() <= 0) 
    {
        $("deletevlan").disabled = true;
    }
    else 
    {
        $("deletevlan").disabled = !btnRightArr.delvlanbtn.right;
    }
}
