 var obj = getParentWindow(); //     
var ct = null; //CTable  
var flag = false; //         

var boardList = null;//         
var BPS_ID_MIN = 1;//   ID   
var BPS_ID_MAX = 65535;//   ID   

function DbpsBoard()
{
	this.subrackid = null;
	this.subrackname = null;
	this.showslotid = null;
	this.slotid = null;
	this.boardtype = null;
	this.boardname = null;
}

/*
 *      
 */
function init()      
{      
	initTable();
	initButton();
	initAvailRes();//      
}

/*
 * CTable   
 */
function initTable()
{
	ct = new CTable(); 
	ct.addHead(RESOURCE["ATTRIBUTE_res"],RESOURCE["VALUE_res"]);
	$("newdbpstableDiv").appendChild(ct.getTable());
	
	var dbpsIDAtom = new Atom("text");
	dbpsIDAtom.setValue(1);
	if (obj.obj["neType"] == 67)
	{
		validateNum(dbpsIDAtom.element,BPS_ID_MIN,8,1,1);
	}
	else
	{
		validateNum(dbpsIDAtom.element,BPS_ID_MIN,BPS_ID_MAX,5,1);
	}
	
	if(SpecialAttrMgr.isNESupport(obj.neid, "TE_FUNC_CFG_OSN_DBPS", "OTN_ATTR_SUPPORT_DBPS_IDRANGE"))
	{
	    var arr = SpecialAttrMgr.getNEAttrListValue(obj.neid, "TE_FUNC_CFG_OSN_DBPS", "OTN_ATTR_SUPPORT_DBPS_IDRANGE");
	    
	    validateNum(dbpsIDAtom.element, parseInt(arr[0]), parseInt(arr[1]), arr[1].length, 1);
	}
	
	ct.addAttrRow("pgid",RESOURCE["dbpsID"],dbpsIDAtom);
	dbpsIDAtom.element["onchange"] = function()
	{
		$("applybtn").disabled = false;
	}
	
	var wAtom = new Atom("select");
	ct.addAttrRow("wboard",RESOURCE["workBoard"],wAtom);
	wAtom.element.onchange = workBoardChangeHandler;
	
	var pAtom = new Atom("select");
	ct.addAttrRow("pboard",RESOURCE["protectedBoard"],pAtom);	
	pAtom.element["onchange"] = function()
	{
		$("applybtn").disabled = false;
	}
}

function workBoardChangeHandler()
{
	$("applybtn").disabled = false;
	workBoardMatch();
}

/*
 *        
 */
function initButton()
{
	$("okbtn").value = RESOURCE["okbutton"];
	$("cancelbtn").value = RESOURCE["cancelbutton"];
	$("applybtn").value = RESOURCE["applybutton"];
}

/*
 *             
 */
function getAvailRes()
{
	var xmldata = obj.createGetResXML();
	var urlstr = "../../../../neExlorerServlet?sfid="+TECMDCODE_QUERY_DBPS_RES+"&nmUser="+obj.nmUser; //     url  
	loadXMLdoc(urlstr, "POST", true, callbackGetRes, null, "inputdata="+xmldata);
}

/**********************************
 *  object value    
************************************/
function compareIntegers(vNum1,vNum2)
{
	var iNum1 = parseInt(vNum1.slotid.value);
	var iNum2 = parseInt(vNum2.slotid.value);
	if(iNum1 < iNum2)
	{
		return -1;
	}
	else if(iNum1 > iNum2)
	{
		return 1;
	}
	else
	{
		return 0;
	}
}

function initAvailRes()
{	
	var data = obj.resources;
	setAvailRes(data);
}

function callbackGetRes(doc)
{
	setAvailRes(EncapsulateData(doc));
}

/*
 *         
 */
function setAvailRes(data)
{
	data.rows.sort(compareIntegers);
	ct.getAtom("wboard").element.options.length = 0;
	if (data.getDataRowLength() > 0)
	{
		boardList = []
		for (var i = 0, m = data.getDataRowLength(); i < m; i++)
		{
			var slotId = data.getDataRowParam(i, "slotid");
			var boardType = data.getDataRowParam(i, "boardtype");
			var boardName = data.getDataRowParam(i, "boardname");
			var subrackid = data.getDataRowParam(i, "subrackid");
			var subrackname = data.getDataRowParam(i, "subrackname");
			var showslotid = data.getDataRowParam(i, "showslotid");
			
			var dbpsBoard = new DbpsBoard();
			dbpsBoard.subrackid = subrackid;
			dbpsBoard.subrackname = subrackname;
			dbpsBoard.showslotid = showslotid;
			dbpsBoard.slotid = slotId;
			dbpsBoard.boardtype = boardType;
			dbpsBoard.boardname = boardName;
			
			var option = new Option(getShowName(dbpsBoard), slotId + "-" + boardType);
			addOptionToSelect(ct.getAtom("wboard").element, option);
			boardList.append(dbpsBoard);			
		}
		workBoardMatch();
	}
	else
	{
		ct.getAtom("pboard").element.options.length = 0;
		var option = new Option("---", "0");
		addOptionToSelect(ct.getAtom("pboard").element, option);
	}
}

function getShowName(param)
{
	var subrackid = param.subrackid;
	var subrackname = param.subrackname;
	var showslotid = param.showslotid;
	var slotid = param.slotid;
	var boardname = param.boardname;
	
	var showname = "";
	
	if (subrackid < "0")
	{
		showname = slotid + "-" + boardname;
	}
	else
	{
		showname = subrackname + "-" + showslotid + "-" + boardname;
	}
	return showname;
}

/*
 *    change                
 */
function workBoardMatch()
{
	var wbd = ct.getAtom("wboard").getValue();
	var wSlotId = wbd.split("-")[0];
	var wType = wbd.split("-")[1];
	
	ct.getAtom("pboard").element.options.length = 0;
	var option = new Option("---", "0");
	addOptionToSelect(ct.getAtom("pboard").element, option);
	
	for (var i = 0, m = boardList.length; i < m; i++)
	{
		var bd = boardList[i];
		if (bd.slotid != wSlotId && bd.boardtype == wType)
		{
			option = new Option(getShowName(bd), bd.slotid + "-" + bd.boardtype);
			addOptionToSelect(ct.getAtom("pboard").element, option);
		}
	}
}

/*
 *     DBPS  
 */
function newDbps(flag)
{
	if(flag && $("applybtn").disabled == true)
	{
		xcloseDialog();
		return;
	}
	if (ct.getAtom("wboard").getValue() == null || ct.getAtom("wboard").getValue() == "")
	{
		alert(RESOURCE["notnull"]);
		return;
	}
	$("okbtn").disabled = true;
	$("applybtn").disabled = true;
	this.flag = flag;	
	var xmldata = createNewXml();

	var urlstr = "../../../../neExlorerServlet?sfid="+TECMDCODE_NEW_DBPS+"&nmUser="+obj.nmUser;
	loadXMLdoc(urlstr, "POST", false, callbackNew, null, "inputdata="+xmldata);
}

/*
 *       DBPS   XML
 */
function createNewXml()
{
		var root = new inputxml("datainterface");	
    var bussiness = new tagElement("bussiness-params");
    
    var row = new tagElement("row-params");    
    var param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",obj.neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","groupId");
    param.setAttribute("value",ct.getAtom("pgid").getValue());
    row.appendChild(param);
    
    var wOptions = ct.getAtom("wboard").element.options;
    var wslot = wOptions[wOptions.selectedIndex];
    param = new tagElement("param");
    param.setAttribute("name","wslotid");
    param.setAttribute("value",wslot.value.split("-")[0]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","wboardname");
    param.setAttribute("value",wslot.innerText);
    row.appendChild(param);
    
    var pOptions = ct.getAtom("pboard").element.options;
    var pbd = pOptions[pOptions.selectedIndex];
    param = new tagElement("param");
    param.setAttribute("name","pslotid");
    param.setAttribute("value",pbd.value.split("-")[0]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","pboardname");
    param.setAttribute("value",pbd.innerText);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);

    return root.toString();
}

/*
 *   DBPS     
 */
function callbackNew(doc)
{
	var data = EncapsulateData(doc);
	showErrorDialog(data);
	if (data.getSErrorCode() == 0)
	{
		$("okbtn").disabled = false;
		
		if (flag)
		{
			xcloseDialog(); //            
		}
		else
		{
			this.flag = false;
			getAvailRes();			
		}
		
		obj.dbpsQuery();
	}
	else
	{
		$("okbtn").disabled = false;
		$("applybtn").disabled = false;
	}
}
