var VLAN_ID_MIN = 1; //VLAN ID   
var VLAN_ID_MAX = 4095; //VLAN ID   
var VLAN_ID_MAX_L4G = 4094;
var BOARD_TBE = "TBE";
var BOARD_LEM24 = "11LEM24";
var BOARD_LEX4 = "11LEX4";
var BOARD_LEM18 = "LEM18";
var BOARD_LEG16 = "LEG16";

var obj = getParentWindow(); //     location  
var groupId = getNeProperty(self).groupId; //   ID
var ct = null; //  VLAN  
var flag = false; //          

/*
 *      
 */
function init()      
{   
	if (obj.st1.getDataRowLength() > 0)
	{
		$("arbitrary").disabled = true;
	}   
	initTable();
	initButton();
}

/*
 * CTable     
 */
function initTable()
{
    ct = new CTable(); 
    ct.addHead(RESOURCE["ATTRIBUTE_res"],RESOURCE["VALUE_res"]);
    $("addvlandiv").appendChild(ct.getTable());
    
    var startAtom = new Atom("text");
    var selectIndex = obj.st0.getSelectedRows();
    
    var wSlotid = obj.st0.getCellStoreValue(selectIndex[0],"wslotid","wslotid");
    var idRange = SpecialAttrMgr.getCPAttrListValue(obj.neid, wSlotid, "TE_FUNC_CFG_OSN_DBPS", "OTN_ATTR_SUPPORT_DBPS_VLANIDRANGE");
    
    if(obj.st0.getCellStoreValue(selectIndex[0],"wslot","wboardname") == BOARD_TBE ||
    obj.st0.getCellStoreValue(selectIndex[0],"wslot","wboardname") == BOARD_LEM24 ||
    obj.st0.getCellStoreValue(selectIndex[0],"wslot","wboardname") == BOARD_LEX4 ||
    obj.st0.getCellStoreValue(selectIndex[0],"wslot","wboardname") == BOARD_LEM18 ||
    obj.st0.getCellStoreValue(selectIndex[0],"wslot","wboardname") == BOARD_LEG16 
    )
    {
        validateNum(startAtom.element,VLAN_ID_MIN,VLAN_ID_MAX,4,1);
    }
    else
    {
        if(idRange && idRange.length == 2)
        {
	    validateNum(startAtom.element, parseInt(idRange[0]), parseInt(idRange[1]), idRange[1].length, 1);
        } else {
  	    validateNum(startAtom.element,VLAN_ID_MIN,VLAN_ID_MAX_L4G,4,1);
  	}
    }

    startAtom.setValue(1);
    ct.addAttrRow("startVlan",RESOURCE["startvlan"],startAtom);
	
    var endAtom = new Atom("text");
    if(obj.st0.getCellStoreValue(selectIndex[0],"wslot","wboardname") == BOARD_TBE ||
	obj.st0.getCellStoreValue(selectIndex[0],"wslot","wboardname") == BOARD_LEM24 ||
	obj.st0.getCellStoreValue(selectIndex[0],"wslot","wboardname") == BOARD_LEX4 ||
	obj.st0.getCellStoreValue(selectIndex[0],"wslot","wboardname") == BOARD_LEM18 ||
	obj.st0.getCellStoreValue(selectIndex[0],"wslot","wboardname") == BOARD_LEG16 
    )
    {
        validateNum(endAtom.element,VLAN_ID_MIN,VLAN_ID_MAX,4,1);
    }
    else
    {
        if(idRange && idRange.length == 2)
        {
	    validateNum(endAtom.element, parseInt(arr[0]), parseInt(arr[1]), arr[1].length, 1);
        } else {
  	    validateNum(endAtom.element,VLAN_ID_MIN,VLAN_ID_MAX_L4G,4,1);
  	}
    }
    
	
    endAtom.setValue(1);
    ct.addAttrRow("endVlan",RESOURCE["endvlan"],endAtom);
	
    if (obj.st0.getCellStoreValue(selectIndex[0],"wslot","wboardname") == BOARD_LEM18 
    	|| obj.st0.getCellStoreValue(selectIndex[0],"wslot","wboardname") == BOARD_LEG16
        || SpecialAttrMgr.isCPSupport(obj.neid, wSlotid, "TE_FUNC_CFG_OSN_DBPS", "OTN_ATTR_SUPPORT_DBPS_LIKELEM18") )
    {
    	$("arbitrary").style.display = "NONE";
    	$("arbitrarytxt").style.display = "NONE";		
    }
}

/*
 *        
 */
function initButton()
{
	$("arbitrarytxt").innerHTML = RESOURCE["arbitrarytxt"];
	$("okbtn").value = RESOURCE["okbutton"];
	$("cancelbtn").value = RESOURCE["cancelbutton"];
	$("applybtn").value = RESOURCE["applybutton"];
}

function changeHandler()
{
	if ($("arbitrary").checked)
	{
		ct.getAtom("startVlan").element.value = "-";
		ct.getAtom("startVlan").element.disabled = true;
		ct.getAtom("endVlan").element.value = "-";
		ct.getAtom("endVlan").element.disabled = true;
	}
	else
	{
		ct.getAtom("startVlan").element.value = "1";
		ct.getAtom("startVlan").element.disabled = false;
		ct.getAtom("endVlan").element.value = "1";
		ct.getAtom("endVlan").element.disabled = false;
	}
}

/*
 *     VLAN      VLAN
 */
function check()
{
	if ($("arbitrary").checked)
	{
		return true;
	}
	var startVlan = parseInt(ct.getAtom("startVlan").getValue());
	var endVlan = parseInt(ct.getAtom("endVlan").getValue());
	if (startVlan > endVlan)
	{
		alert(RESOURCE["vlancheck"]);
		return false;
	}
	return true;
}

/*
 *       VLAN  
 */
function addVlan(param)
{
	if ($("arbitrary").disabled && $("arbitrary").checked)
	{
		xcloseDialog();
	}
	if (!check())
	{
		return;
	}
	
	flag = param;
	$("okbtn").disabled = true;
	$("cancelbtn").disabled = true;
	$("applybtn").disabled = true;
	
	var xmldata = createAddVlanXml();
	var url = "../../../../neExlorerServlet?sfid="+TECMDCODE_ADD_DBPS_VLAN+"&nmUser="+obj.nmUser;
	loadXMLdoc(url, "POST", false, callbackAddVlan, null, "inputdata=" + xmldata);
}

/*
 *       VLAN XML
 */
function createAddVlanXml()
{
	var root = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = null;
    
    param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",obj.neid);
    row.appendChild(param);
      
    param = new tagElement("param");
    param.setAttribute("name","groupId");
    param.setAttribute("value",groupId);
    row.appendChild(param);
    
    var startvlanstr = RESOURCE["arbitrarytxt"];
    var startvlan = 65535;
    var endvlanstr = RESOURCE["arbitrarytxt"];
    var endvlan = 65535;
    if (!$("arbitrary").checked)
    {
    	startvlan = ct.getAtom("startVlan").getValue();
    	startvlanstr = startvlan;
    	endvlan = ct.getAtom("endVlan").getValue();
    	endvlanstr = endvlan;
    }
    
    param = new tagElement("param");
    param.setAttribute("name","startvlan");
    param.setAttribute("value",startvlan);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","startvlanstr");
    param.setAttribute("value",startvlanstr);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","endvlan");
    param.setAttribute("value",endvlan);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","endvlanstr");
    param.setAttribute("value",endvlanstr);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);

    return root.toString();
}

/*
 *     VLAN    
 */
function callbackAddVlan(doc)
{
	$("okbtn").disabled = false;
	$("cancelbtn").disabled = false;
	$("applybtn").disabled = false;
	
	var data = EncapsulateData(doc);
	showErrorDialog(data);
	if (data.getSErrorCode() == 0)
	{
		obj.vlanQuery(groupId); 
	    if (flag)
		{
			xcloseDialog(); //      
		}
		else
		{
			flag = false;
			$("arbitrary").disabled = true;
		}
	}
}

