
loadXMLdoc("../../../../conf/system.xml", "GET", false, EncapsulateSConf);
loadXMLdoc("../../../help/"+SYSTEMCONF.getLanguage()+"/helpidresource.xml", "GET", false,EncapsulateHelpConfig);
getResourse("../../res/clock/clockres_"+ SYSTEMCONF.getLanguage() +".xml");
loadXMLdoc("../../conf/clock/clock2mprioritytable_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable, null);

var st;
var CLOCK_SLOT_ID = 65535;//NGWDM          0xffff
var clockslotno = -1;
var clock2mFlag = 1;
var btnRightArr = new Object();
var neobject = getNeProperty(parent);
var netype = neobject.neType;

var clockstate =new Object();
clockstate[0] = "noability";
clockstate[1] = "ability";
clockstate[2] = "empty";

var lockstate =new Object();
lockstate[0] = "lock";
lockstate[1] = "nolock";
lockstate[2] = "empty";

var s1quality = new Object();
s1quality[0] = "s1quality0";
s1quality[2] = "s1quality2";
s1quality[4] = "s1quality4";
s1quality[8] = "s1quality8";
s1quality[11] = "s1quality11";
s1quality[15] = "losaction0";
s1quality[16] = "noinfo";

var clockPriorityList = [];

var INNER_CLOCK_ID = "15794177";

var OUTER_SOURCE = 2;

function tabSelectHandler()
{
	if (st == null)
    {
	  	init();
    }
}

function init()
{
    $("querybtn").value=RESOURCE["query"];    
    $("applybtn").value=RESOURCE["apply"];
    $("newbtn").value=RESOURCE["new"];
    $("delbtn").value=RESOURCE["del"];    
    $("srctext").innerHTML = RESOURCE["switchsrc"];
    $("statetext").innerHTML = RESOURCE["switchstate"];    
    $("cursrctext").innerHTML = RESOURCE["cursrctext"];
    $("s1bytetext").innerHTML = RESOURCE["s1bytetext"];
    
    st = new SortTable();
    st.setImage("../../../../images/");  
    createTableHead(st, window.tableconf[0]);
    
    $("autoacross").appendChild(st.getTable());
    st.setBodyHeight(270);
     
    st.setOnRowSelectHandler(stSelectFun); 
        
    btnRightArr.querybtn = new BtnRightObj("querybtn",TECMDCODE_GET_2M_PRI_TBL);    
    btnRightArr.newbtn = new BtnRightObj("newbtn",TECMDCODE_SET_2M_PRI_TBL); 
    btnRightArr.delbtn = new BtnRightObj("delbtn",TECMDCODE_SET_2M_PRI_TBL); 
    btnRightArr.applybtn = new BtnRightObj("applybtn",TECMDCODE_SET_2M_PRI_TBL);
    
    getRightInfo(neobject,btnRightArr);    
    initrightbtn(btnRightArr);
    
    $("newbtn").disabled = true;
    $("delbtn").disabled = true;
    $("applybtn").disabled = true;
    
    if (btnRightArr.applybtn.right)
    {
    	$("autoacross").oncontextmenu = rightlist;//popupMenuHandler1; 
    }
    else
    {
		$("down").disabled = true;
		$("up").disabled = true;
		$("newbtn").disabled = true;				
    }
    
    if(btnRightArr.querybtn.right)
    {
      query();
    }    
}

function query()
{
    $("querybtn").disabled = true;
   
    var xmlstr = createQueryXML();
    var urlreq ="../../../../neExlorerServlet?sfid="+TECMDCODE_GET_2M_PRI_TBL+"&timeStamp="+new Date().getTime()+"&nmUser="+neobject["nmUser"];
    
    loadXMLdoc(urlreq, "POST",true,updatePG,null,"inputdata="+xmlstr);
}

function createQueryXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    var neidvalue =neobject.neid;
    param.setAttribute("name","neid");
    param.setAttribute("value",neidvalue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","clock2mFlag");
    param.setAttribute("value",clock2mFlag);
    row.appendChild(param);
    
    var logstr; 
    if (clock2mFlag == 2) // 2 2M      
    {
    	logstr = RESOURCE["clockpriority2m2"];
    }
    else  // 1 2M      
    {
    	logstr = RESOURCE["clockpriority2m1"];
    }
    param = new tagElement("param");
    param.setAttribute("name", "opDesc");
    param.setAttribute("value", logstr);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
 
    return di.toString();
}

var bltooTip = true;

function updatePG(doc)
{
    if(btnRightArr.newbtn.right)
    {
        $("newbtn").disabled = false;
    }
     
	if(null==doc)
	{
		return;
	}

	var data = EncapsulateData(doc);
	bltooTip = true;
    if(0 != data.getSErrorCode() && 1 != data.getSErrorCode())
	{
		$("querybtn").disabled = false;

		if (st.getDataRowLength() == 0)
		{
			$("delbtn").disabled = true;
			$("applybtn").disabled = true;
			$("newbtn").disabled = true;
		}

		for(var i = 0;i < data.getBErrLength();i++)
        {
  	        var errInfo = data.getError().rowErrors[i].error;
  		    if(null != errInfo)
  		    {
  		        if(errInfo.code == 38823)
  		        {
  		            $("newbtn").disabled = true;
  		            break;
  		        }
  		        else if(errInfo.code == 38669)
  		        {
  		        	bltooTip = false;
  		        	break;
  		        }
  		    }
        }

		showErrorDialog(data);
		if(1 != data.getSErrorCode())
		{
			return;
		}
	}
	updataTableData(data);
	refreshClockPriorityList();
    if(st.getDataRowLength() > 0)
	{
		querySwitch();
	}

    $("querybtn").disabled = false;
}

function updataTable(doc)
{
	var data = EncapsulateData(doc);

	if(0 != data.getSErrorCode())
	{
		$("querybtn").disabled = false;

		if (st.getDataRowLength() == 0)
		{
			$("delbtn").disabled = true;
			$("applybtn").disabled = true;
		}

		showErrorDialog(data);
		if(1 != data.getSErrorCode())
		{
			return;
		}
	}

	updataTableData(data)
}


function updataTableData(data)
{
    st.clearTableData();
	
	createTableBody(st, window.tableconf[0], data, RESOURCE);
	for(var j = 0; j < st.getDataRowLength(); j++)
    {
		var clockname = st.getCellCurrentValue(j, "clockname", "clockname");
		if((clockname=="1")||(clockname=="2"))
		{
			if(neobject.neType == 79 || SpecialAttrMgr.isNENotSupport(neobject.neid, "TE_FUNC_CFG_STG_SUBNET", "OTN_ATTR_NOTSUPPORT_SHELFTYPE"))
			{
				st.setAtomValue(st.getCell(j,"clockname").element.showElement, RESOURCE["outersource"] + clockname);
			}
			else
			{
				st.setAtomValue(st.getCell(j,"clockname").element.showElement,st.getCellCurrentValue(j,"subrackname","subrackname") + "-" + RESOURCE["outersource"] + clockname);
			}
		}
		else if(clockname=="0")
		{
			st.setAtomValue(st.getCell(j,"clockname").element.showElement,RESOURCE["innersource"]);
		}
	}
		
	if (st.getDataRowLength() == 0)
	{
		$("newbtn").disabled = true;
		$("applybtn").disabled = true;
	}
}

function createQuerySwitchXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    var neidvalue =neobject.neid;
    param.setAttribute("name","neid");
    param.setAttribute("value",neidvalue);
    row.appendChild(param);
    
	param = new tagElement("param");
    param.setAttribute("name","clockslotno");
    param.setAttribute("value",CLOCK_SLOT_ID);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name","clock2mindex");
    param.setAttribute("value",clock2mFlag);
    row.appendChild(param);
   
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
 
    return di.toString();
}
function querySwitch()
{
	var xmlstr = createQuerySwitchXML();
    var urlreq ="../../../../neExlorerServlet?sfid="+TECMDCODE_GET2MPLL+"&timeStamp="+new Date().getTime()+"&nmUser="+neobject["nmUser"];
    
    loadXMLdoc(urlreq, "POST",true,refreshWorkBoard,null,"inputdata="+xmlstr);
}

function refreshWorkBoard(doc)
{
	refreshSwitchInfo(doc);
}

function refreshSwitchInfo(doc)
{
	var newdata = EncapsulateData(doc);
    
    if(0 != newdata.getSErrorCode())
    { 
    	if(bltooTip)
    	{
       showErrorDialog(newdata);
      }
       return ;
    }
	
    var switchsrc = newdata.rows[0]["switchsrc"].value;  
	if((switchsrc=="1")||(switchsrc=="2"))
	{
		switchsrc = RESOURCE["outersource"] + switchsrc;
	}
	else if(switchsrc=="0")
	{
		switchsrc = RESOURCE["innersource"];
	} else if(switchsrc=="-2")
	{
		switchsrc = RESOURCE["noinfo"];
	}  
    $("switchsrc").value = switchsrc;
    
    var switchstate = newdata.rows[0]["switchstate"].value;    
    $("switchstate").value = switchstate;
    
    var cursrc = newdata.rows[0]["cursrc"].value;  
    
    if((cursrc=="1")||(cursrc=="2"))
    {
	cursrc = RESOURCE["outersource"] + cursrc;
    }
    else if(cursrc=="0")
    {
    	cursrc = RESOURCE["innersource"];
    } else if(cursrc=="-2")
    {
    	cursrc = RESOURCE["noinfo"];
    }  
      
    $("cursrc").value = cursrc;
    
    var s1byte = newdata.rows[0]["s1quality"].value;    
    $("s1byte").value = s1byte;
}

function lock(lockstate)
{
	var xmlstr = createLockXML(lockstate);
	if (xmlstr == null)
	{
		return ;
	}
    var urlreq ="../../../../neExlorerServlet?sfid="+TECMDCODE_SET_2M_LOCK_STATE+"&timeStamp="+new Date().getTime()+"&nmUser="+neobject["nmUser"];
    loadXMLdoc(urlreq, "POST",true,refreshTable,null,"inputdata="+xmlstr);
}

function refreshTable(doc)
{
    var data = EncapsulateData(doc);
   
    if(0 != data.getSErrorCode())
    { 
      showErrorDialog(data);
      return ;
    }
    var xmlstr = createQueryXML();
    var urlreq ="../../../../neExlorerServlet?sfid="+TECMDCODE_GET_2M_PRI_TBL+"&timeStamp="+new Date().getTime()+"&nmUser="+neobject["nmUser"];
    
    loadXMLdoc(urlreq, "POST",true,updataTable,null,"inputdata="+xmlstr);
}

/**
 * 0       1     
 */
function createLockXML(lockstate)
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
        
    for(var i = 0; i < st.getDataRowLength(); i++)
    {
	  	if(st.getRowSelFlag(i))
	  	{
			var clockid = st.getCellCurrentValue(i, "clockid", "clockid");
			if (clockid == INNER_CLOCK_ID)
			{
				continue;
			}

		  	var row = new tagElement("row-params");
	        var param = new tagElement("param");
	        var neidvalue = neobject.neid;
	        param.setAttribute("name","neid");
	        param.setAttribute("value",neidvalue);
	        row.appendChild(param);	      
	        
	        param = new tagElement("param");
	        param.setAttribute("name","clockslotno");
	        param.setAttribute("value",CLOCK_SLOT_ID);
	        row.appendChild(param);
	        	        
	        param = new tagElement("param");
	        var clockidhex = st.getCellCurrentValue(i, "clockid", "clockidhex");
	        param.setAttribute("name","clockid");
	        param.setAttribute("value",clockidhex);
	        row.appendChild(param);
	       
	        param = new tagElement("param");
	        param.setAttribute("name","lockstate");
	        param.setAttribute("value",lockstate);
	        row.appendChild(param);
	        
					param = new tagElement("param");//     
	        var clockname = st.getCellShow(i, "clockname").getValue();
	        param.setAttribute("name","clockname");
	        param.setAttribute("value",clockname);
	        row.appendChild(param);

	        bussiness.appendChild(row);
	  	}
	}
    
    if (bussiness.childNodes.length <=0 )
    {
    	return null;
    }
    
    di.getRoot().appendChild(bussiness);    
    return di.toString();
}

function createSwitchXML(switchstate)
{
	if(st.getSelectedRowCount()<1)
	{
		return null;
	}

	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var row = new tagElement("row-params");

	var param = new tagElement("param");
	var neidvalue = neobject.neid;
	param.setAttribute("name","neid");
	param.setAttribute("value",neidvalue);
	row.appendChild(param);
			
	param = new tagElement("param");
	param.setAttribute("name","clockslotno");
	param.setAttribute("value",clockslotno);
	row.appendChild(param);

    var sel = st.getSelectedRows();
	clockidhex = st.getCellCurrentValue(sel[0], "clockid", "clockidhex");
	param = new tagElement("param");
	param.setAttribute("name","clockid");
	param.setAttribute("value",clockidhex);
	row.appendChild(param);
				   
	param = new tagElement("param");
	param.setAttribute("name","switchstate");
	param.setAttribute("value",switchstate);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name","clock2mindex");
	param.setAttribute("value",clock2mFlag);
	row.appendChild(param);
	
	bussiness.appendChild(row); 

    di.getRoot().appendChild(bussiness);

    return di.toString();
}
function switchclock(switchstate)
{
	var xmlstr = createSwitchXML(switchstate);
	if(null == xmlstr)
	{
		return;
	}
    var urlreq ="../../../../neExlorerServlet?sfid="+TECMDCODE_SET_2M_SWITCH_STATE+"&timeStamp="+new Date().getTime()+"&nmUser="+neobject["nmUser"];
    loadXMLdoc(urlreq, "POST",true,refreshSwitch,null,"inputdata="+xmlstr);
}

function refreshSwitch(doc)
{
    var data = EncapsulateData(doc);
   
    if(0 != data.getSErrorCode())
    { 
      showErrorDialog(data);
      return ;
    }
   
    var xmlstr = createSwitchQueryXML();
    var urlreq ="../../../../neExlorerServlet?sfid="+TECMDCODE_GET2MPLL+"&timeStamp="+new Date().getTime()+"&nmUser="+neobject["nmUser"];
    
    loadXMLdoc(urlreq, "POST",true,refreshSwitchInfo,null,"inputdata="+xmlstr);
}

function createSwitchQueryXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    var neidvalue =neobject.neid;
    param.setAttribute("name","neid");
    param.setAttribute("value",neidvalue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","clockslotno");
    param.setAttribute("value",CLOCK_SLOT_ID);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","clock2mindex");
    param.setAttribute("value",clock2mFlag);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
 
    return di.toString();
}

function rightlist()
{
    removejsDOMmenu();
    var count = st.getSelectedRowCount();
    var length = st.getDataRowLength();
    
    var cursorMenu1 = new jsDOMenu(120);
    var menulength = 0;
    
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["clearswitch"], "", switchclock, "0"));
    cursorMenu1.addMenuItem(new menuItem('-'));
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["lock"], "", lock, "0"));
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["clearlock"], "", lock, "1"));
    
    cursorMenu1.addMenuItem(new menuItem('-'));
    
    if (count == 1) 
    {
        var sel = st.getSelectedRows();
        
        var state = st.getCellCurrentValue(sel[0], "lockstate", "lockstate");
        if (state == 1) 
        {
            cursorMenu1.addMenuItem(new menuItem(RESOURCE["forceswitch"], "", switchclock, "2"));
            cursorMenu1.addMenuItem(new menuItem(RESOURCE["manualswitch"], "", switchclock, "1"));
        }
        else 
        {
            cursorMenu1.addMenuItem(new menuItem(RESOURCE["forceswitch"], "", switchclock, "2", false));
            cursorMenu1.addMenuItem(new menuItem(RESOURCE["manualswitch"], "", switchclock, "1", false));
        }
    }
    else 
    {
        cursorMenu1.addMenuItem(new menuItem(RESOURCE["forceswitch"], "", switchclock, "2", false));
        cursorMenu1.addMenuItem(new menuItem(RESOURCE["manualswitch"], "", switchclock, "1", false));
        
        menulength = menulength + 3;
    }
    
    setPopUpMenu(cursorMenu1);
    rightClickHandler();
}

/**
 *                 
 */
function stSelectFun()
{	
		if (btnRightArr.applybtn.right)
		{
				var selcount = st.getSelectedRowCount();
				
				if(selcount > 1)
				{					
						$("up").disabled = true;
						$("down").disabled = true;
				}
				else
				{				    
				    $("up").disabled = false;
						$("down").disabled = false;	
				}
		
				var rowsize = st.getDataRowLength();
	
	    	if ( selcount <= 0)
	    	{
				   	$("delbtn").disabled = true;
				   	return ;
	    	}
	    
		    if ( rowsize == 1)
		    {
		       	var s = st.getCellCurrentValue(0,"clockid", "clockid");
		       	if (s == 15794177)
		       	{
		       	 		$("delbtn").disabled = true;
			     			return ;
		       	}	
		    }	
		    $("delbtn").disabled = false;
		}
}

function testdata()
{
	var rowsize = st.getDataRowLength();
	for ( var j = 0 ; j < st.getDataRowLength(); j++)
	{
		if(st.getRowSelFlag(j))
		{
		   var s = st.getCellCurrentValue(j,"outclockmode", "outclockmode");
		   alert ("outclockmode"+s );
		   s = st.getCellCurrentValue(j,"s1byte", "s1byte");
		   alert ("s1byte"+s );
		   s = st.getCellCurrentValue(j,"clockid", "clockid");
		   alert ("clockid"+s );
		}
	}
	
}

function setClockPriority()
{
   $("applybtn").disabled = true;

   var xmlstr = createSetXML();
   var urlreq ="../../../../neExlorerServlet?sfid="+TECMDCODE_SET_2M_PRI_TBL+"&timeStamp="+new Date().getTime()+"&nmUser="+neobject["nmUser"];
   loadXMLdoc(urlreq, "POST", true, refreshtable, null, "inputdata="+xmlstr);
}

function refreshtable(doc)
{
    var data = EncapsulateData(doc);
    
    if(0 != data.getSErrorCode()) 
    {
        $("applybtn").disabled = false;
        showErrorDialog(data);
        return ;
    }
    refreshClockPriorityList();
    refreshTableState(st,window.tableconf[0],data);
}

function createSetXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");

	
	var row = new tagElement("row-params");

	var param = new tagElement("param");
	var neidvalue = getNeProperty(top)["neid"];
	param.setAttribute("name","neid");
	param.setAttribute("value",neidvalue);
	row.appendChild(param);
		  
	param = new tagElement("param");
	param.setAttribute("name","clockslotno");
	param.setAttribute("value",CLOCK_SLOT_ID);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name","clock2mFlag");
	param.setAttribute("value",clock2mFlag);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name","oldclocknum");
	param.setAttribute("value",clockPriorityList.length);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name","oldclockindex");
	param.setAttribute("value",getClockPriorityString());
	row.appendChild(param);

	bussiness.appendChild(row);

	if(st.getDataRowLength() == 0)
    {
	  	row = new tagElement("row-params");

		param = new tagElement("param");
        param.setAttribute("name","clockidhex");
        param.setAttribute("value","00f10001");
        row.appendChild(param);
  	    
  	    bussiness.appendChild(row);       
    }
    
    for(var i = 0; i < st.getDataRowLength(); i++)
    {
	  	row = new tagElement("row-params");
		
        var clockidhex = st.getCellCurrentValue(i, "clockid", "clockidhex");
		if(i>0 && clockidhex == "00f10001")
		{
			continue;
		}
		
		param = new tagElement("param");
        param.setAttribute("name","clockidhex");
        param.setAttribute("value",clockidhex);
        row.appendChild(param);
  	    
  	    var opDesc = RESOURCE["clockname"]+":"+st.getCellShow(i,"clockname").getValue();
	    	param = new tagElement("param");
	    	param.setAttribute("name","opDesc");
	    	param.setAttribute("value",opDesc);
	    	 row.appendChild(param);
	    	
	    	
  	    bussiness.appendChild(row);       
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function showErrorDialog(data)
{
    for(var i = 0;i < data.getBErrLength();i++)
	  {
	  	  var tempObj = data.getError().rowErrors[i].errorObj;
    		tempObj["operateObj"] = RESOURCE["clocksourcepriority"] ;
	  }	
    var errArr = [];
    errArr[0] = "operateObj";   
    openErrPage("../../../../page/", data.getError(), errArr); 
}

function newClock()
{
   	hideMenu();
   	xshowModalDialog("newclockdiglog.html", RESOURCE["addclock"], 700, 400, "../../../../images/");
}

/*
 *      
 */
function upchangerow()
{
		var rowsize = st.getDataRowLength();
		
		if ( rowsize == 1)
		{
		 		return ;
		}
		
		for(var i = 0; i < rowsize; i++)
		{
				if(st.getRowSelFlag(i))
				{
						if (i == 0 || st.getCellStoreValue(i,"clockid","clockid") == INNER_CLOCK_ID)
						{
						  	return ;
						}
						else
						{
							  $("applybtn").disabled = false;
							  swapTableRow(i,i-1);
							  break;             
						}
				}
		}
}

/*
 *      
 */
function downchangerow()
{
   	var rowsize = st.getDataRowLength();
   
   	if (rowsize == 1)
   	{
     		return ;
   	}
   	for(var i = 0; i < rowsize; i++)
   	{
        if(st.getRowSelFlag(i))
        {
           	if (i == (rowsize-1) || st.getCellStoreValue(i+1,"clockid","clockid") == INNER_CLOCK_ID)
           	{
              	return;
           	}
           	else
           	{
              	$("applybtn").disabled = false;
              	swapTableRow(i+1, i);
              	i= i+ rowsize;
           	}
        }
    }
}

/**
 *      
 */
function swapTableRow(src, des)
{
    var srcrow =  st.getRow(src);             
    var drow = st.getRow(des);
             
    st.element.datarows[des] =  srcrow;
    st.element.datarows[src] =  drow;
             
    srcrow.element.swapNode(drow.element);
}

/**
 *      
 */
function delclock()
{	
	var rowsize = st.getDataRowLength();
	for ( var j = 0 ; j < st.getDataRowLength(); j++)
	{		
		if(st.getRowSelFlag(j))
		{
			var clockid = st.getCellCurrentValue(j, "clockid", "clockid");
			if (clockid == INNER_CLOCK_ID)
			{
				continue;
			}
	   
			st.deleteRow(j);
		}
	}
	
	st.adjustDataRows();
	$("delbtn").disabled = true;

	setClockPriority("del");

	var size = st.getDataRowLength();
	if(size == 0)
	{
		$("newbtn").disabled = true;
		setTimeout(query,5000);
	}
}

/**
 *         
 *  2M                   
 */
function addclock(data)
{
	var newClockid = data.rows[0]["clockid"].value;
	if(newClockid == INNER_CLOCK_ID)
	{//         
		st.clearTableData();
	}
	else if(innerSourceExist())
	{//               	   
		st.clearTableData();		
	}

	var index = st.getDataRowLength();
	var indexRow = index;
	if(index == 0)
	{
        createTableBody(st, window.tableconf[0], data, RESOURCE);
	}
    else
	{
		insertTableRowAt(st, window.tableconf[0], data, RESOURCE); 
	}
	var clockSourceType = st.getCellStoreValue(indexRow,"clockid","clockSourceType");
	if (clockSourceType == OUTER_SOURCE)
	{
	    var clockname = st.getCellCurrentValue(indexRow,"clockname","clockname");
	   
	    if (netype == 79 || SpecialAttrMgr.isNENotSupport(neobject.neid, "TE_FUNC_CFG_STG_SUBNET", "OTN_ATTR_NOTSUPPORT_SHELFTYPE"))
	    {
	    	st.setAtomValue(st.getCell(indexRow,"clockname").element.showElement,RESOURCE["outersource"] + clockname );
	    }
	    else
	    {
	    	st.setAtomValue(st.getCell(indexRow,"clockname").element.showElement, st.getCellCurrentValue(indexRow,"subrackname","subrackname") + "-" + RESOURCE["outersource"] + clockname);
	    }
	}
    $("applybtn").disabled = false;	
}

function innerSourceExist()
{
    var clockid;
	for(var i = st.getDataRowLength()-1; i >= 0; i--)
	{
		clockid = st.getCellStoreValue(i, "clockid","clockid");
		if(clockid == INNER_CLOCK_ID)
		{
			return true;
		}
	}

	return false;
}


function refreshClockPriorityList()
{
	clockPriorityList = [];
	for(var j = 0; j < st.getDataRowLength(); j++)
    {
    	var clockindex = st.getCellCurrentValue(j, "clockid", "clockidhex");
		clockPriorityList[clockPriorityList.length] = clockindex;
    }
}

function getClockPriorityString()
{
	var clockString = "";
	for(var i = 0;i < clockPriorityList.length;i++)
	{
		clockString += clockPriorityList[i];
	}
	return clockString;
}
