var parentWin = window.parent;
var neid = parentWin.winurlobj["neid"];
var nmUser = parentWin.winurlobj["nmUser"];
var btnRightArr = new Object();
var st0;//        
var st1;//         
var OPRSUCC = 0;
var PARTSUCC = 1;

var OC = "1";
var BC = "2";
var TC = "3";
var TCOC = "4";
var TCBC = "5";
var portworkmode = new Object();
portworkmode["1"] = "OC";
portworkmode["2"] = "BC";
portworkmode["3"] = "TC";
portworkmode["4"] = "TCOC";
portworkmode["5"] = "TCBC";

var portstatus = new Object();
portstatus["1"] = "FAULTY";
portstatus["3"] = "LISTENING";
portstatus["4"] = "PRE_MASTER";
portstatus["5"] = "MASTER";
portstatus["6"] = "PASSIVE";
portstatus["8"] = "SLAVE";
portstatus["-1"] = "/";

var msgformat = new Object();
msgformat["1"] = "PTP ETH";
msgformat["2"] = "PTP IP";

var enable = new Object();
enable["0"] = "disabled";
enable["1"] = "enabled";

var encapsulationFormat = new Object();
encapsulationFormat["1"] = "ETH1588";
encapsulationFormat["2"] = "IP1588";

var protocolType = new Object();
protocolType["1"] = "DCLS";
protocolType["2"] = "PPSRS232";
protocolType["3"] = "J.211"; 

var sdMode = new Object();
sdMode['0'] = RESOURCE['singleMode'];
sdMode['1'] = RESOURCE['doubleMode'];

var syncMode = new Object();
syncMode['0'] = RESOURCE['async'];
syncMode['1'] = RESOURCE['sync'];

var selectedRowID = 0;

var workmode;
var TC = "3";
var TCOC = "4";
var TCBC = "5";

var INVALID_VLAN = "65535";

var portData;
var ISFROMNE = "0";

var INVALID_SUB_SLOTID = "255";
var timeformatfilePath = "../../../../../conf/timeformat.xml";

var vlanSupportedBorads = [];
vlanSupportedBorads[0] = "1557";//EGSH
vlanSupportedBorads[1] = "1572";//52TOG
vlanSupportedBorads[2] = "2279";//54THA
vlanSupportedBorads[3] = "2280";//54TOA
vlanSupportedBorads[4] = "2315";//55TQX
vlanSupportedBorads[5] = "2297";//53TDX
vlanSupportedBorads[6] = "2320";//54TOG
vlanSupportedBorads[7] = "2481";//54TOAN
vlanSupportedBorads[8] = "2482";//54THAN
vlanSupportedBorads[9] = "2508";//57TOA
vlanSupportedBorads[10] = "2505";//57TQX
vlanSupportedBorads[11] = "2506";//57TDX
vlanSupportedBorads[12] = "2480";//BDTYPE_TN53TDXN
vlanSupportedBorads[13] = "2479";//BDTYPE_TN55TQXN
vlanSupportedBorads[14] = "2589";//BDTYPE_TNF8COA
vlanSupportedBorads[15] = "2587";//BDTYPE_TNF8CQX
vlanSupportedBorads[16] = "2588";//BDTYPE_TNF8CDX
vlanSupportedBorads[17] = "2595";//BDTYPE_TNF8CHA
vlanSupportedBorads[18] = "2602";//BDTYPE_TNF8COG
vlanSupportedBorads[19] = "2591";//BDTYPE_TNF8COX
vlanSupportedBorads[20] = "2331";//BDTYPE_TN55TOX
vlanSupportedBorads[21] = "2596";//BDTYPE_TNF8LOA
vlanSupportedBorads[22] = "2296";//BDTYPE_TN11LOA
vlanSupportedBorads[23] = "3026";//BDTYPE_TN55TOX


var msgformatNotEditBoards = [];
msgformatNotEditBoards[0] = "2279";//54THA
msgformatNotEditBoards[1] = "2280";//54TOA
msgformatNotEditBoards[2] = "2315";//55TQX
msgformatNotEditBoards[3] = "2297";//53TDX
msgformatNotEditBoards[4] = "2320";//54TOG
msgformatNotEditBoards[5] = "2481";//54TOAN
msgformatNotEditBoards[6] = "2482";//54THAN
msgformatNotEditBoards[7] = "2508";//57TOA
msgformatNotEditBoards[8] = "2505";//57TQX
msgformatNotEditBoards[9] = "2506";//57TDX
msgformatNotEditBoards[10] = "2480";//BDTYPE_TN53TDXN
msgformatNotEditBoards[11] = "2479";//BDTYPE_TN55TQXN
msgformatNotEditBoards[12] = "2589";//BDTYPE_TNF8COA
msgformatNotEditBoards[13] = "2587";//BDTYPE_TNF8CQX
msgformatNotEditBoards[14] = "2588";//BDTYPE_TNF8CDX
msgformatNotEditBoards[15] = "2595";//BDTYPE_TNF8CHA
msgformatNotEditBoards[16] = "2602";//BDTYPE_TNF8COG
msgformatNotEditBoards[17] = "2591";//BDTYPE_TNF8COX
msgformatNotEditBoards[18] = "2331";//BDTYPE_TN55TOX
msgformatNotEditBoards[19] = "3026";//BDTYPE_TN55TOX



function init()
{
	st0 = new SortTable();	
    st0.setImage("../../../../../images/");    
    tc = window.tableconf[0];   
    createTableHead(st0, tc);
	st0.setOnRowSelectHandler(rowSelected);
    st0.setOnCellEditHandler(cellEditHandler);
    var tabheigth = getComponetHeight($("tablecomponent"),60);
	st0.setBodyHeight(tabheigth);
	$("tablecomponent").popupMenuExcludeCells = ['defaultvlanid'];
    $("tablecomponent").appendChild(st0.getTable());
    $("tablecomponent").oncontextmenu = popupMenuHandler;
    
    $("querybtn").value=RESOURCE["querybutton"];
    $("createbtn").value=RESOURCE["newbutton"]; 
    $("deletebtn").value=RESOURCE["deletebutton"]; 
    $("applybtn").value=RESOURCE["applybutton"]; 	
    btnRightArr.querybtn = new BtnRightObj("querybtn",TECMDCODE_QUERY_PTP_PORTSTATUS);
    btnRightArr.createbtn = new BtnRightObj("createbtn",TECMDCODE_SET_PTP_PORTSTATUS);  
    btnRightArr.deletebtn = new BtnRightObj("deletebtn",TECMDCODE_SET_PTP_PORTSTATUS);
    btnRightArr.applybtn = new BtnRightObj("applybtn",TECMDCODE_SET_PTP_PORTSTATUS);   
    
    getRightInfo(parentWin.winurlobj,btnRightArr);
    
    $("createbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("applybtn").disabled = true;
    $("querybtn").disabled = true;
    
    parentWin.query();
}

function cellEditHandler(param)
{
	if (param.stage == TABLE_CONSTANT.AFTEREDIT)
	{
		$("applybtn").disabled = !btnRightArr.applybtn.right; 
	}

    
    var colid = param.colid;
	var rowindex = param.rowindex;
	if(colid == "sdMode")
	{
		var workmodeValue = st0.getCellCurrentValue(rowindex,"portworkmode","portworkmode");
		var sdModeCellEdit = st0.getCellEdit(rowindex, "sdMode");
	   
		if (workmodeValue == TC || workmodeValue == TCOC)
		{
			sdModeCellEdit.clearOptions();
			sdModeCellEdit.addOption(RESOURCE['singleMode'], "0");
		}
		else
		{
			sdModeCellEdit.clearOptions();
			sdModeCellEdit.addOption(RESOURCE['singleMode'], "0");
			sdModeCellEdit.addOption(RESOURCE['doubleMode'], "1");

		}
	}
	
	else if(colid == "msgformat")
	{
		var boardType = st0.getCellStoreValue(rowindex, "port", "boardtype");
		var msgformatCellEdit = st0.getCellEdit(rowindex, "msgformat");
		if (SpecialAttrMgr.isCPNotSupportByType(neid, boardType,
				"TE_FUNC_CFG_PTPCLOCK_SYN_ATTRIBUTE", "OTN_ATTR_NOTSUPPORT_PTPCLOCK_MSGFORMAT_IP"))

		{
			msgformatCellEdit.clearOptions();
			msgformatCellEdit.addOption(RESOURCE['PTPETH'], "1");
		}
		else
		{
			msgformatCellEdit.clearOptions();
			msgformatCellEdit.addOption(RESOURCE['PTPETH'], "1");
			msgformatCellEdit.addOption(RESOURCE['PTPIP'], "2");

		}
	}
}

function query(workMode, isFromNE)
{
    parentWin.query();
    /**workmode = workMode;
    ISFROMNE = isFromNE;
    
    $("querybtn").disabled = true;
    $("createbtn").disabled = true;  
    $("deletebtn").disabled = true;
    $("applybtn").disabled = true;  
	
    var xmlstr = createQueryXML(workMode);   
    urlreq ="../../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_PTP_PORTSTATUS + "&nmUser="+parentWin.winurlobj["nmUser"];      
    loadXMLdoc(urlreq, "POST",true,handleBackQuery,null,"inputdata="+xmlstr);**/
}

function queryPort(workMode, isFromNE)
{
    workmode = workMode;
    ISFROMNE = isFromNE;
    
    $("querybtn").disabled = true;
    $("createbtn").disabled = true;  
    $("deletebtn").disabled = true;
    $("applybtn").disabled = true;  
	
    var xmlstr = createQueryXML(workMode);   
    urlreq ="../../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_PTP_PORTSTATUS + "&nmUser="+parentWin.winurlobj["nmUser"];      
    loadXMLdoc(urlreq, "POST",true,handleBackQuery,null,"inputdata="+xmlstr);
}

function createQueryXML(workMode)
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);
    
    var param = new tagElement("param");    
    param.setAttribute("name","isFromNE");
    param.setAttribute("value",ISFROMNE);
    row.appendChild(param);
    
    var param = new tagElement("param");    
    param.setAttribute("name","workmode");
    param.setAttribute("value",workMode);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackQuery(doc)
{
	$("querybtn").disabled = false;

	var data = EncapsulateData(doc); 
	if ("0" == ISFROMNE)
	{
		portData = data;
	}
    for(var i = 0, len = data.getBErrLength();i < len;i++)
	{
		var tempObj = data.getError().rowErrors[i].errorObj;
		var str = ""
		if(tempObj["nename"])
		{
			str = str + tempObj["nename"] + "-";
		}
		if(tempObj["slotid"])
		{
			str = str + getSlotIDFromSlot(tempObj["slotid"]) + "-";
		}
		if(tempObj["boardname"])
		{
			str = str + tempObj["boardname"] + "-";
		}
		if(tempObj["portname"])
		{
			str = str + tempObj["portname"] + "-";
		}
		
    	tempObj["operateObj"] = str + RESOURCE["queryPortStatus"];
	}
	


	if(parentWin.dataError != null)
	{
		for(var i = 0, len = parentWin.dataError.getRowErrLength();i < len;i++)
		{
			data.getError().rowErrors[data.getError().rowErrors.length] = parentWin.dataError.rowErrors[i]; 
		}
		
		if(parentWin.dataError.s_error.code != 0)
		{
			data.errObj.s_error.code = parentWin.dataError.s_error.code;
			data.errObj.s_error.info = parentWin.dataError.s_error.info;
		}
		
		parentWin.dataError = null;
	}	
	  
	var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../../page/", data.getError(), errArr);    
	    
    if (OPRSUCC == data.getSErrorCode() || PARTSUCC == data.getSErrorCode()) 
    {            
        if ("1" == ISFROMNE)
        {
            for(var i = 0, len = data.getDataRowLength();i < len;i++)
            {
                var row = data.rows[i];
                var slotid = row["slotid"].value;
                var port = row["port"].value;
                
                for(var j = 0, lenPortData = portData.getDataRowLength();j < lenPortData;j++)
                {
                    var rowPortData = portData.rows[j];
                    if (slotid == rowPortData["slotid"].value && port == rowPortData["port"].value)
                    {
                        data.rows[i] = rowPortData;
                        break;
                    }
                }
            }
        }
        else
        {
		    for(var i = 0, len = data.getDataRowLength();i < len;i++)
            {
				var diobj = data.rows[i];
	          	var ptag = null;
            
	          	ptag = new ParamTag();//     CLOCK ID     ID
    	        var clockidhigh = data.getDataRowParam(i,"clockidhigh");
    	        var clockidlow = data.getDataRowParam(i,"clockidlow");
    	        var interfaceid = data.getDataRowParam(i,"interfaceid");
                var defaultvlanid = data.getDataRowParam(i,"defaultvlanid");
    	        ptag.value = getCompanyCode(clockidhigh, clockidlow, interfaceid);
    	        diobj["sourceID"]=ptag;
                
    	        if (diobj["defaultvlanid"].value == INVALID_VLAN)
    	        {
    	            diobj["defaultvlanid"].value = "/";
    	        }
            }
        }
        
	    st0.clearTableData();
        createTableBody(st0, window.tableconf[0], data, RESOURCE);

		setPortWorkmodeOptions();
		addListerner(st0, "sourceID");//                        
		addCellEvent();// PTP  VLAN             
		addListerner(st0, "defaultvlanid");//                        
    }
    
    $("createbtn").disabled = !btnRightArr.createbtn.right;
}



function isVLANSupported(boardType)
{
    for(var i = 0,len = vlanSupportedBorads.length;i<len;i++)
    {
        if(("" + boardType) == ("" + vlanSupportedBorads[i]))
        {
            return true;
        }
    }
    
    if(SpecialAttrMgr.isCPSupportByType(neid, boardType, "TE_FUNC_CFG_PTPCLOCK_SYN_ATTRIBUTE", "OTN_ATTR_SUPPORT_PTPCLOCKSYN_VLAN"))
    {
        return true;
    }
    
    return false;
}


function isMsgformatNotEdit(boardType)
{
    for(var i = 0,len = msgformatNotEditBoards.length;i<len;i++)
    {
        if(("" + boardType) == ("" + msgformatNotEditBoards[i]))
        {
            return true;
    }
    }
    
    if(SpecialAttrMgr.isCPNotSupportByType(neid, boardType, "TE_FUNC_CFG_PTPCLOCK_SYN_ATTRIBUTE", "OTN_ATTR_NOTSUPPORT_PTPCLOCK_MSGFORMAT"))
    {
        return true;
    }
    return false;
}
/*
 *             flag true    
 */
function setPortStatusEnable(flag)
{
	 for(var i = 0,len = st0.getDataRowLength();i<len;i++)
	 {	
	 	var cell = st0.getCell(i,"portstatus");
	 	var portmode = st0.getCellStoreValue(i,"portworkmode","portworkmode")
	 	if (flag == true)
	 	{
	 		if (portmode != TC)
	 		{
			  	st0.setCellIsEdit(cell, "1");
			  	st0.setCellValue(cell,"portstatus","3");
			    st0.getCellShow(i,"portstatus").setValue("LISTENING");
				cell.element.modify = true;
				cell.element.parentNode.modify = true;
				cell.element.style.backgroundColor = "#d0f946";
	 		}
	 		else
	 		{
	 			st0.setCellIsEdit(cell, "0");
				st0.getCellShow(i, "portstatus").setValue("-");
				cell.element.modify = false;
				cell.element.parentNode.modify = false;
	 		}
	 	}
	 	else
	 	{
	 		st0.setCellIsEdit(cell, "0");
			st0.getCellShow(i, "portstatus").setValue("-");
			cell.element.modify = false;
			cell.element.parentNode.modify = false;
	 	}
	 }
}

function addCellEvent()
{
    var cell = null;
    var msgformatcell = null;
    for (var i = 0, len = st0.getDataRowLength(); i < len; i++) 
    {   	
        if (null == st0.getCellStoreValue(i, "portstatus", "portstatus")) 
        {
            st0.setCellIsEdit(st0.getCell(i, "portstatus"), "0");
            st0.getCellShow(i, "portstatus").setValue("-");
        }
        var boardType = st0.getCellStoreValue(i, "port", "boardtype");
        cell = st0.getCellElement(i, "portworkmode");

        if (TCOC == st0.getCellStoreValue(i, "portworkmode", "portworkmode")) 
        {
            if (isVLANSupported(boardType)&&
            typeof(st0.getCellStoreValue(i, "defaultvlanid", "defaultvlanid")) != "undefined") 
            {
                st0.setCellIsEdit(st0.getCell(i, "defaultvlanid"), "1");
            }
            else 
            {
                st0.setCellIsEdit(st0.getCell(i, "defaultvlanid"), "0");
                st0.getCellShow(i, "defaultvlanid").setValue("-");
            }
            if (isMsgformatNotEdit(boardType)) 
            {
                st0.setCellIsEdit(st0.getCell(i, "msgformat"), "0");
            }  
        }
        else if (TC == st0.getCellStoreValue(i, "portworkmode", "portworkmode")) 
        {       	
            
            var portstatustCell = st0.getCell(i, "portstatus");
            st0.setCellIsEdit(portstatustCell, "0");
            st0.getCellShow(i,"portstatus").setValue("-");
            st0.setCellModify(i, "portstatus", false);
            
            if (isVLANSupported(boardType) &&
            typeof(st0.getCellStoreValue(i, "defaultvlanid", "defaultvlanid")) != "undefined") 
            {
                st0.setCellIsEdit(st0.getCell(i, "defaultvlanid"), "1");

                if (boardType == 1572 || SpecialAttrMgr.isCPSupportByType(neid, boardType, "TE_FUNC_CFG_PTPCLOCK_SYN_ATTRIBUTE", "OTN_ATTR_SUPPORT_PTPCLOCK_MSGFORMAT")) 
                {
                    st0.setCellIsEdit(st0.getCell(i, "msgformat"), "1");
                }
                else 
                {
                    st0.setCellIsEdit(st0.getCell(i, "msgformat"), "0");
                }
                
            }
            else 
            {
                st0.setCellIsEdit(st0.getCell(i, "defaultvlanid"), "0");
                st0.getCellShow(i, "defaultvlanid").setValue("-");
                st0.setCellIsEdit(st0.getCell(i, "msgformat"), "0");
                
                if (!isMsgformatNotEdit(boardType)) 
                {
                    st0.getCellShow(i, "msgformat").setValue("-");
                }
                
            }
           
        }
        else 
        {
            if (isMsgformatNotEdit(boardType)) 
            {
                st0.setCellIsEdit(st0.getCell(i, "msgformat"), "0");
            }
            if(st0.getCell(i, "domainID") != null)
            {
            	st0.setCellIsEdit(st0.getCell(i, "domainID"), "0");
            	st0.getCellShow(i, "domainID").setValue("-");
            } 
        }
        if(st0.getCellStoreValue(i, "msgformat", "msgformat") == "-")
        {
        	 st0.setCellIsEdit(st0.getCell(i, "msgformat"), "0");
        }
        
        if(st0.getCell(i, "domainID")!= null && st0.getCellStoreValue(i, "domainID", "domainID") == "-")
        {
        	 st0.setCellIsEdit(st0.getCell(i, "domainID"), "0");
        }
        
        cell.editElement.element.onchange = function()
        {
            var currentStatus = this.value;
            var rowindex = this.parentNode.parentNode.rowIndex;
            var sourceCell = st0.getCell(rowindex, "sourceID");
            var sourceIDElement = sourceCell.element;
            
            var defaultCell = st0.getCell(rowindex, "defaultvlanid");
            var msgformatCell = st0.getCell(rowindex, "msgformat");
            var sdShowValue = st0.getCellShow(rowindex,"sdMode"); 
		    var sdModeCell = st0.getCell(rowindex, "sdMode");
            if (TCOC == currentStatus) 
            {
                st0.setCellIsEdit(st0.getCell(rowindex, "portstatus"), "1");
                st0.getCellShow(rowindex, "portstatus").setValue("LISTENING");
                
                if (boardType == 1572 || SpecialAttrMgr.isCPSupportByType(neid, boardType, "TE_FUNC_CFG_PTPCLOCK_SYN_ATTRIBUTE", "OTN_ATTR_SUPPORT_PTPCLOCKSYN_VLAN") ) 
                {
                    if (st0.getCellIsEdit(defaultCell) == "0") 
                    {
                        st0.setCellIsEdit(defaultCell, "1");
                        st0.getCellShow(rowindex, "defaultvlanid").setValue("1");
                    }
                }
                else 
                {
                   st0.setCellIsEdit(defaultCell, "0");
                   st0.getCellShow(rowindex, "defaultvlanid").setValue("-");
                }
                if (st0.getCellIsEdit(msgformatCell) != "1" && st0.getCellStoreValue(rowindex, "msgformat", "msgformat")!="-") 
                {
                    st0.setCellIsEdit(msgformatCell, "1");
                    st0.setCellValue(msgformatCell, "msgformat", "1");
                    st0.getCellShow(rowindex, "msgformat").setValue("PTP ETH");
                    st0.setCellModify(rowindex, "msgformat", true);
                    msgformatCell.element.style.backgroundColor = "#d0f946";
                }
                 if (st0.getCellIsEdit(sdModeCell) == "1")
                 {
                 	 st0.setCellModify(rowindex, "sdMode", true);
			         sdShowValue.setValue(RESOURCE['singleMode']);
			         st0.setCellValue(sdModeCell,"sdMode",0);               
                 }
                 if(st0.getCell(rowindex, "domainID") != null && st0.getCellStoreValue(rowindex, "domainID", "domainID") != "-")
     			 {
                	st0.setCellIsEdit(st0.getCell(rowindex, "domainID"), "1");
     				st0.getCellShow(rowindex, "domainID").setValue("1");
     				st0.setCellValue(st0.getCell(rowindex, "domainID"), "domainID", "1");
     				st0.getCell(rowindex, "domainID").element.style.backgroundColor = "#d0f946";
     				st0.setCellModify(rowindex, "domainID", true);
     			 } 
               
            }
            else if (TC == currentStatus) 
            {
                st0.setCellIsEdit(st0.getCell(rowindex, "portstatus"), "0");
                st0.setCellModify(rowindex, "portstatus", false);
                st0.getCellShow(rowindex, "portstatus").setValue("-");
                if (boardType == 1572 || SpecialAttrMgr.isCPSupportByType(neid, boardType, "TE_FUNC_CFG_PTPCLOCK_SYN_ATTRIBUTE", "OTN_ATTR_SUPPORT_PTPCLOCKSYN_VLAN") ) 
                {
                	if (st0.getCellIsEdit(defaultCell) == "0") 
                    {
                       st0.setCellIsEdit(defaultCell, "1");
                    }
                    st0.setCellIsEdit(sourceCell, "1");
                    st0.setCellIsEdit(sourceIDElement, "1");
                    sourceIDElement.showElement.setValue("FFFFFFFFFFFFFFFFFFFF");
                    st0.setCellValue(sourceCell, "sourceID", "FFFFFFFFFFFFFFFFFFFF");
                    addListerner(st0, "sourceID");
                    sourceIDElement.modify = true;
                }
                else 
                {
                    if (!isMsgformatNotEdit(boardType)) 
                    {
                        st0.setCellIsEdit(defaultCell, "0");
                        st0.getCellShow(rowindex, "defaultvlanid").setValue("-");
                        st0.setCellModify(rowindex, "defaultvlanid", false);
                        st0.setCellIsEdit(msgformatCell, "0");
                        st0.getCellShow(rowindex, "msgformat").setValue("-");
                        st0.setCellModify(rowindex, "msgformat", false);
                    }
                }
                if (st0.getCellIsEdit(sdModeCell) == "1")
                {
                	  st0.setCellModify(rowindex, "sdMode", true);
			          sdShowValue.setValue(RESOURCE['singleMode']);
			          st0.setCellValue(sdModeCell,"sdMode",0);
                }
                if(st0.getCell(rowindex, "domainID") != null && st0.getCellStoreValue(rowindex, "domainID", "domainID") != "-")
    			{
    				st0.setCellIsEdit(st0.getCell(rowindex, "domainID"), "1");
    				st0.getCellShow(rowindex, "domainID").setValue("1");
    				st0.setCellValue(st0.getCell(rowindex, "domainID"), "domainID", "1");
    				st0.getCell(rowindex, "domainID").element.style.backgroundColor = "#d0f946";
    				st0.setCellModify(rowindex, "domainID", true);
    			} 
            }
            else 
            {
                var bmcEnable = parentWin.st.getCellStoreValue(rowindex, "staticBMC", "staticBMC");
                if (bmcEnable == 1) 
                {
                    st0.setCellIsEdit(st0.getCell(rowindex, "portstatus"), "1");
                    st0.setCellModify(rowindex, "portstatus", true);
                    st0.getCellShow(rowindex, "portstatus").setValue("LISTENING");
                    st0.getCell(rowindex, "portstatus").element.style.backgroundColor = "#d0f946";
                }
                
                if (!isVLANSupported(boardType) 
                || typeof(st0.getCellStoreValue(rowindex, "defaultvlanid", "defaultvlanid")) == "undefined") 
                {
                    st0.setCellIsEdit(defaultCell, "0");
                    st0.setCellModify(rowindex, "defaultvlanid", false);
                    st0.setCellValue(st0.getCell(rowindex, "defaultvlanid"), "defaultvlanid", "-");
                    st0.setAtomValue(st0.getCellShow(rowindex, "defaultvlanid"), "-");
                    
                    st0.setCellIsEdit(msgformatCell, "0");
                    st0.setCellModify(rowindex, "msgformat", false);
                    st0.setCellValue(st0.getCell(rowindex, "msgformat"), "msgformat", "-");
                    st0.setAtomValue(st0.getCellShow(rowindex, "msgformat"), "-");
                }
                else 
                {
                    if (st0.getCellIsEdit(defaultCell) != "1") 
                    {
                        if (!isMsgformatNotEdit(boardType)) 
                        {
                            st0.setCellIsEdit(defaultCell, "1");
                            st0.setCellValue(defaultCell, "defaultvlanid", "1");
                            st0.getCellShow(rowindex, "defaultvlanid").setValue("1");
                            st0.setCellModify(rowindex, "defaultvlanid", true);
                            defaultCell.element.style.backgroundColor = "#d0f946";
                        }
                    }
                    if (st0.getCellIsEdit(msgformatCell) != "1" && st0.getCellStoreValue(rowindex, "msgformat", "msgformat")!="-") 
                    {
                        if (!isMsgformatNotEdit(boardType)) 
                        {
                            st0.setCellIsEdit(msgformatCell, "1");
                            st0.setCellValue(msgformatCell, "msgformat", "1");
                            st0.getCellShow(rowindex, "msgformat").setValue("PTP ETH");
                            st0.setCellModify(rowindex, "msgformat", true);
                            msgformatCell.element.style.backgroundColor = "#d0f946";
                        }
                    }
                }
                if (st0.getCellIsEdit(sourceCell) == "0") 
                {
                    st0.setCellIsEdit(sourceIDElement, "1");
                    sourceIDElement.showElement.setValue("FFFFFFFFFFFFFFFFFFFF");
                    st0.setCellValue(sourceCell, "sourceID", "FFFFFFFFFFFFFFFFFFFF");
                    addListerner(st0, "sourceID");
                    sourceIDElement.modify = true;
                }
                if(st0.getCell(rowindex, "domainID") != null)
    			{
    				st0.setCellIsEdit(st0.getCell(rowindex, "domainID"), "0");
    				st0.getCellShow(rowindex, "domainID").setValue("-");
    			} 
            }
        }
        cell = st0.getCell(i, "sdMode");
        var sdMode = st0.getCellStoreValue(i, "sdMode", "sdMode");
        if (sdMode != '0' && sdMode != '1') 
        {
            st0.setCellIsEdit(cell, '0');
            st0.setAtomValue(st0.getCellShow(i, "sdMode"), "-");
        }
        
        cell = st0.getCell(i, "defaultvlanid");
        msgformatcell = st0.getCell(i, "msgformat");
        var boardType = st0.getCellStoreValue(i, "port", "boardtype");
        
        if (!isVLANSupported(boardType) 
        || typeof(st0.getCellStoreValue(i, "defaultvlanid", "defaultvlanid")) == "undefined") 
        {//   12ND2   VLAN
            st0.setCellIsEdit(cell, "0");
            cell.modify = false;
            st0.setCellValue(st0.getCell(i, "defaultvlanid"), "defaultvlanid", "-");
            st0.setAtomValue(st0.getCellShow(i, "defaultvlanid"), "-");
            
            st0.setCellIsEdit(msgformatcell, "0");
            msgformatcell.modify = false;
            st0.setCellValue(st0.getCell(i, "msgformat"), "msgformat", "-");
            st0.setAtomValue(st0.getCellShow(i, "msgformat"), "-");
            continue;
        }
        
        if (cell.element.isEdit == "0") 
        {
            continue;
        }
        
        cell.element["ondblclick"] = function()
        {
            this.modify = true;
            this.parentNode.modify = true;
            
            showMgrDialogVlan(st0, this, "defaultvlanid");
        }
        cell.element.oncontextmenu = function()
        {
            this.modify = true;
            this.parentNode.modify = true;
            
            showMgrDialogVlan(st0, this, "defaultvlanid");
        };
    }
}
function showMgrDialogVlan(st, cellElement, key)
{
	var i;
	var evt = EventUtil.getEvent();
    var elem = evt.target;
    if(elem.parent||elem.parentNode.parent)
    {
       var rowid;
       var rows;
       if(elem.parent)
       {
       	   rowid = elem.parentNode.rowIndex;
       	   rows = elem.parent.getSelectedRows();
       }
       else
       {
       	   rowid = elem.parentNode.parentNode.rowIndex;
       	   rows = elem.parentNode.parent.getSelectedRows();
       }

       if(!rows.contains(rowid))
       {
          return;
       }
       
        if(rows.length == 1)
	    {
	    	i = rows[0];
	    }
	    else
	    {
	    	i = rowid;
	    }
    }

	if(null == i)
	{
		return;
	}

    var value = st.getCellStoreValue(i, key, key);
		
	xshowModalDialog("../../clock/ptp/maxvlannum.html?value="+value+"&key="+key+"&index="+i,RESOURCE["VLANID"], 320, 170, "../../../../../images/");
}

function create()
{
    xshowModalDialog("../../clock/ptp/createport.html?neid=" + neid + "&nmUser="+parentWin.winurlobj["nmUser"],RESOURCE["createClockPort"],610,400,"../../../../../images/");
}

function rowSelected(rows)
{
	  var len = rows.length;
	  
	  if (0 == len)
	  {
		  $("deletebtn").disabled = true;
	  }
	  else
	  {
		  $("deletebtn").disabled = !btnRightArr.deletebtn.right;
	  }
}

function deletePort()
{
	if (!confirm(RESOURCE["Delete_Hint"]))
    {
        return;
    }
            
	  $("querybtn").disabled = true;
	  $("createbtn").disabled = true;
	  $("deletebtn").disabled = true;
	  $("applybtn").disabled = true;   
	
    var xmlstr = createDeleteXML();
    urlreq ="../../../../../neExlorerServlet?sfid=" + TECMDCODE_CONFIG_PTP_CLOCKPORT +"&nmUser="+parentWin.winurlobj["nmUser"];        
    loadXMLdoc(urlreq, "POST",false,handleBackDelete,null,"inputdata="+xmlstr);
}

function createDeleteXML()
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);
                                         
    bussiness.appendChild(row); 
    
    for(var rowindex = 0, length = st0.getDataRowLength(); rowindex < length; rowindex++)
	  {
	  	if (!st0.getRowSelFlag(rowindex))
	  	{	  	  	
            continue;
        }
        row = new tagElement("row-params");

        param = new tagElement("param");    
        param.setAttribute("name","slotid");
        param.setAttribute("value",st0.getCellHiddenValue(rowindex,"portName","slotid"));
        row.appendChild(param);
        
        param = new tagElement("param");    
        param.setAttribute("name","subslotid");
        var subslotid = st0.getCellStoreValue(rowindex,"portName","subslotid");
        if (null == subslotid)
        {
        	  subslotid = INVALID_SUB_SLOTID;
        }
        param.setAttribute("value",subslotid);
        row.appendChild(param);
        
        param = new tagElement("param");    
        param.setAttribute("name","port");
        param.setAttribute("value",st0.getCellStoreValue(rowindex,"port","port"));
        row.appendChild(param);
		
		    param = new tagElement("param"); 
        param.setAttribute("name","ptpEnable");
        param.setAttribute("value","0");
        row.appendChild(param);
            
        bussiness.appendChild(row);  
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackDelete(doc)
{
	  $("querybtn").disabled = false;
    $("createbtn").disabled = !btnRightArr.createbtn.right;
    
	  var data = EncapsulateData(doc);
    for(var i = 0, len = data.getBErrLength();i < len;i++)
	  {
	  	  var tempObj = data.getError().rowErrors[i].errorObj;
    		tempObj["operateObj"] = RESOURCE["deletePort"];
	  }	
	  
	  var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../../page/", data.getError(), errArr);    	 
    
    if (OPRSUCC == data.getError().getGlobleECode() || PARTSUCC == data.getError().getGlobleECode())   
    {	          
	      for(var i=0, len = st0.getDataRowLength(); i<len; i++)
	      {
	          if (st0.getRowSelFlag(i))
	          {
	          	  var slotid = st0.getCellHiddenValue(i,"portName","slotid");
	          	  var port = st0.getCellStoreValue(i,"port","port");
	          		for(var lenPortData = portData.getDataRowLength();lenPortData > 0;lenPortData--)
				        {
				            var rowPortData = portData.rows[lenPortData-1];
				            if (slotid == rowPortData["slotid"].value && port == rowPortData["port"].value)
				            {
				                portData.removeDataRowAt(lenPortData-1);
				            }
				        }
	              st0.deleteRow(i);
	          }	          
	      }
	      
	      
        
	      st0.adjustDataRows();
    }
    else
    {
    	  $("deletebtn").disabled = false;
    }
}

function apply()
{
    var xmlstr = createApplyXML();
    if (null == xmlstr)
    {
    	  return;
    }
    
    $("querybtn").disabled = true;
	  $("createbtn").disabled = true;
	  $("deletebtn").disabled = true;
	  $("applybtn").disabled = true;
	  
    urlreq ="../../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_PTP_PORTSTATUS +"&nmUser="+parentWin.winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST",true,handleBackApply,null,"inputdata="+xmlstr);
}

function createApplyXML()
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    st1 = parentWin.st;
	if (parentWin.timeChange)
	{
		var row = new tagElement("row-params");
        
	    var param = new tagElement("param");    
        param.setAttribute("name","neid");
        param.setAttribute("value",neid);
        row.appendChild(param);

        var sysDateTime = getTimeFromString(parentWin.$("ptpSysTimeTxt").value,STANDARD_FORMAT).split(" ");

        var sysDate = sysDateTime[0].split("-");
        var sysTime = sysDateTime[1].split(":");
        
	    var param = new tagElement("param");    
        param.setAttribute("name","year");
        param.setAttribute("value",sysDate[0]);
        parentWin.ptpTime.setYear(sysDate[0]) ;
        row.appendChild(param);
        
	    var param = new tagElement("param");    
        param.setAttribute("name","month");
        param.setAttribute("value",sysDate[1]);
        parentWin.ptpTime.setMonth(parseInt(sysDate[1])-1) ;
        row.appendChild(param);
        
	    var param = new tagElement("param");    
        param.setAttribute("name","day");
        param.setAttribute("value",sysDate[2]);
        parentWin.ptpTime.setDate(sysDate[2]) ;
        row.appendChild(param);
        
	    var param = new tagElement("param");    
        param.setAttribute("name","hour");
        param.setAttribute("value",sysTime[0]);
        row.appendChild(param);
        
	    var param = new tagElement("param");    
        param.setAttribute("name","minute");
        param.setAttribute("value",sysTime[1]);
        row.appendChild(param);
        
	    var param = new tagElement("param");    
        param.setAttribute("name","second");
        param.setAttribute("value",sysTime[2]);
        row.appendChild(param);
        parentWin.ptpTime.setHours(sysTime[0],sysTime[1],sysTime[2]);
		
		bussiness.appendChild(row);
	}
    for(var rowindex = 0,rowlen = st1.getDataRowLength();rowindex<rowlen;rowindex++)
    {
        if(!st1.getModify(rowindex))
        {
        	continue;
        }
        	  
    	var row = new tagElement("row-params");
        
	    var param = new tagElement("param");    
        param.setAttribute("name","neid");
        param.setAttribute("value",neid);
        row.appendChild(param);
    	
        if (st1.getCellModify(rowindex, "workmode"))
        {
        	param = new tagElement("param");    
      	    param.setAttribute("name","workmode");
      	    param.setAttribute("value",st1.getCellStoreValue(rowindex,"workmode","workmode"));
      	    row.appendChild(param);
        }
    	
        if (st1.getCellModify(rowindex, "slaveonlymode"))
        {
        	  param = new tagElement("param");    
      	    param.setAttribute("name","slaveonlymode");
      	    param.setAttribute("value",st1.getCellStoreValue(rowindex,"slaveonlymode","slaveonlymode"));
      	    row.appendChild(param);
        }
    	/*
        if (st1.getCellModify(rowindex, "multicastmode"))
        {
        	  param = new tagElement("param");    
      	    param.setAttribute("name","multicastmode");
      	    param.setAttribute("value",st1.getCellStoreValue(rowindex,"multicastmode","multicastmode"));
      	    row.appendChild(param);
        }
		*/
		if (st1.getCellModify(rowindex, "timeadjust"))
        {
        	  param = new tagElement("param");    
      	    param.setAttribute("name","timeadjust");
      	    param.setAttribute("value",st1.getCellStoreValue(rowindex,"timeadjust","timeadjust"));
      	    row.appendChild(param);
        }
        
         if (st1.getCellModify(rowindex, "protocolFormat")) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "protocolFormat");
            param.setAttribute("value", st1.getCellStoreValue(rowindex, "protocolFormat", "protocolFormat"));
            row.appendChild(param);
        }
        
    	bussiness.appendChild(row);
    }
    
    for(var rowindex = 0, length = st0.getDataRowLength(); rowindex < length; rowindex++)
    {
		  if(!st0.getModify(rowindex))
		  {
			  continue;
		  }
		  
		    var row = new tagElement("row-params");
        
	        var param = new tagElement("param");    
            param.setAttribute("name","neid");
            param.setAttribute("value",neid);
            row.appendChild(param);

        	  param = new tagElement("param");    
          	param.setAttribute("name","slotid");
          	param.setAttribute("value",st0.getCellHiddenValue(rowindex,"portName","slotid"));
          	row.appendChild(param);
        	  
        	  param = new tagElement("param");    
          	param.setAttribute("name","subslotid");
          	var subslotid = st0.getCellStoreValue(rowindex,"portName","subslotid");
          	if (null == subslotid)
          	{
          		  subslotid = INVALID_SUB_SLOTID;
          	}
          	param.setAttribute("value",subslotid);
          	row.appendChild(param);
        	  
        	  param = new tagElement("param");    
          	param.setAttribute("name","port");
          	param.setAttribute("value",st0.getCellStoreValue(rowindex,"port","port"));
          	row.appendChild(param);

			if (st0.getCellModify(rowindex, "portworkmode"))
			{
				param = new tagElement("param");    
				param.setAttribute("name","portworkmode");
				param.setAttribute("value",st0.getCellStoreValue(rowindex,"portworkmode","portworkmode"));
				row.appendChild(param);
			}

            
            if (st0.getCellModify(rowindex, "sdMode")) 
            {
                param = new tagElement("param");
                param.setAttribute("name", "sdMode");
                param.setAttribute("value", st0.getCellStoreValue(rowindex, "sdMode", "sdMode"));
                row.appendChild(param);
            }	
            if (st0.getCellModify(rowindex, "defaultvlanid"))
            {
                defaultvlanid = st0.getCellStoreValue(rowindex,"defaultvlanid","defaultvlanid");
                if ("/" == defaultvlanid)
                {
                    defaultvlanid = INVALID_VLAN;
                }
            	  param = new tagElement("param");    
          	    param.setAttribute("name","defaultvlanid");
          	    param.setAttribute("value",defaultvlanid);
          	    row.appendChild(param);
          	}
        
            if (st0.getCellModify(rowindex, "msgformat"))
            {
            	  param = new tagElement("param");    
          	    param.setAttribute("name","msgformat");
          	    param.setAttribute("value",st0.getCellStoreValue(rowindex,"msgformat","msgformat"));
          	    if ("/" != st0.getCellStoreValue(rowindex,"msgformat","msgformat"))
          	    {
          	    row.appendChild(param);
          	    }
          	}
        	
            /*
            if (st0.getCellModify(rowindex, "portstatus"))
            {
            	  param = new tagElement("param");    
          	    param.setAttribute("name","portstatus");
          	    param.setAttribute("value",st0.getCellStoreValue(rowindex,"portstatus","portstatus"));
          	    if ("/" != st0.getCellStoreValue(rowindex,"portstatus","portstatus"))
          	    {
          	    row.appendChild(param);
          	    }
          	}
			*/
			if (st0.getCellModify(rowindex, "sourceID"))
			{
				var sourceID = st0.getCellStoreValue(rowindex,"sourceID","sourceID");
			
                param = new tagElement("param");    
          	    param.setAttribute("name","clockidhigh");
          	    param.setAttribute("value",getSourceIDHigh(sourceID));
          	    row.appendChild(param);
        	
                param = new tagElement("param");    
          	    param.setAttribute("name","clockidlow");
          	    param.setAttribute("value",getSourceIDLow(sourceID));
          	    row.appendChild(param);

                param = new tagElement("param");    
          	    param.setAttribute("name","interfaceid");
          	    param.setAttribute("value",getInterfaceID(sourceID));
          	    row.appendChild(param);
			}
            
        bussiness.appendChild(row);
     }    	  
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackApply(doc)
{
    $("querybtn").disabled = false;
    $("createbtn").disabled = !btnRightArr.createbtn.right;
    
	  var data = EncapsulateData(doc); 
    
    if (OPRSUCC != data.getError().getGlobleECode())
    {
    	  for(var i = 0, size = data.getBErrLength();i < size;i++)
	      {
		    	var tempObj = data.getError().rowErrors[i].errorObj;
  	    		tempObj["operateObj"] = RESOURCE["setSyncPara"];
		  }	
	    var errArr = [];
        errArr[0] = "operateObj";
        openErrPage("../../../../../page/", data.getError(), errArr);
        
    }

    if (OPRSUCC == data.getError().getGlobleECode() || PARTSUCC == data.getError().getGlobleECode()) 
    {
	      refreshTableState(parentWin.st,parentWin.window.tableconf[0],data);
	      refreshTableState(st0,tc,data);
	      
	      if (!(parentWin.st.getCellModify(0, "workmode")))
        {
            parentWin.neStatus = parentWin.st.getCellStoreValue(0,"workmode","workmode");
        }	
        for(var lenPortData = portData.getDataRowLength();lenPortData > 0;lenPortData--)
        {          
            portData.removeDataRowAt(lenPortData-1);           
        }    
    }
    
    if (parentWin.timeChange)
    {
    	parentWin.setTimeInterval();
    }
    
    /*
    if(parentWin.$("ptpSysTimeTxt").value != "-1--1--1 -1:-1:-1" && parentWin.$("ptpSysTimeTxt").value != "")
    {
    clearInterval(intervalID);
    intervalID = setInterval("setPTPTime()",1000);
   }*/
}

/*
function setPTPTime()
{
	   
	   parentWin.ptpTime.setTime(parentWin.ptpTime.getTime()+1000);
	   parentWin.$("ptpSysTimeTxt").value = parentWin.createTime(Number(parentWin.ptpTime.getTime()));
      
}*/

function createTable(currentWorkMode)
{
    st0.clearTableData();
    createTableBody(st0, window.tableconf[0], portData, RESOURCE);
	setPortWorkmodeOptions(currentWorkMode);
	
    addListerner(st0, "sourceID");//                        
    addCellEvent();// PTP  VLAN             
    addListerner(st0, "defaultvlanid");//                        
	
}

function getNEPortWorkMode()
{
	var neworkmode = parentWin.neStatus;
	if(neworkmode == OC)
	{
		return "OC";
	}
	else if(neworkmode == BC)
	{
		return "BC";
	}
	else if(neworkmode == TC)
	{
		return "TC";
	}
	else if(neworkmode == TCOC)
	{
		return "TCOC";
	}
	else if(neworkmode == TCBC)
	{
		return "TCBC";	
	}
	return neworkmode;
}

function  setPortWorkmodeOptions(currentWorkMode)
{
	if(parentWin.st.getDataRowLength() > 0)
	{
		/**
		 *            
		 *                                 
		 *     BC   OC    BC       OC
		 */
		var neworkmode;
		if (currentWorkMode != undefined)
		{
			neworkmode = currentWorkMode;
		}
		else
		{
			neworkmode = parentWin.st.getCellCurrentValue(0,"workmode","workmode");
		}
		for(var rowindex = 0, len = st0.getDataRowLength(); rowindex < len; rowindex++)
		{
			cell = st0.getCell(rowindex,"portworkmode");
			var cellEdit = st0.getCellEdit(rowindex,"portworkmode");
			var theBoardType = st0.getCellStoreValue(rowindex,"port","boardtype");
			if (null != cellEdit)
			{
				cellEdit.clearOptions();
				if(neworkmode == OC)
				{
					cellEdit.addOption(RESOURCE["OC"], "1");	
				}
				else if(neworkmode == BC)
				{
					cellEdit.addOption(RESOURCE["BC"], "2");
				}
				else if(neworkmode == TC)
				{
					cellEdit.addOption(RESOURCE["TC"], "3");
				}
				else if(neworkmode == TCOC)
				{
					cellEdit.addOption(RESOURCE["TCOC"], "4");
					cellEdit.addOption(RESOURCE["TC"], "3");	
				}
				else if(neworkmode == TCBC)
				{//TCBC
					cellEdit.addOption(RESOURCE["BC"], "2");
					cellEdit.addOption(RESOURCE["TC"], "3");
				}
			}
		}
	}
}

/*
Add table popupmenu handler
*/
function popupMenuHandler(evt)
{
  	if(!evt){
  	  evt= window.event;	
  	}
  	 
    var elem = (evt.target) ? evt.target : evt.srcElement;   

    if(elem!= null&&elem.blur)
    {
    	elem.blur();	  	
    }
   
   while(elem!=null)
	 {
	    if(elem.tagName == 'TD')
	    {
	        break;	
	    }
	    else
	    {
		    elem =elem.parentNode;	  	
	    }	
   } 
  
	if(elem == null || elem.tagName != 'TD' || null == elem.parent || elem.editElement == null)
	{
		  return;
	}  
	
	var rowid= elem.parentNode.rowIndex;
    var rows =elem.parent.getSelectedRows();
    var colid = elem.colid;
    if(rows.contains(rowid))
    {
        var boardType = st0.getCellStoreValue(rowid,"port","boardtype");
        if (colid == "defaultvlanid" || colid == "sourceID")
        {
        	return;
        }
        if(((colid == "defaultvlanid") || (colid == "msgformat")) && !isVLANSupported(boardType))
        {//      defaultvlanid   
            return;
        }      
		if(colid == "sdMode")
		{
			var workmodeValue = st0.getCellCurrentValue(rowid,"portworkmode","portworkmode");
			var sdModeCellEdit = st0.getCellEdit(rowid, "sdMode");
			if (workmodeValue == TC || workmodeValue == TCOC)
			{
				sdModeCellEdit.clearOptions();
				sdModeCellEdit.addOption(RESOURCE['singleMode'], "0");
			}
			else
			{
				sdModeCellEdit.clearOptions();
				sdModeCellEdit.addOption(RESOURCE['singleMode'], "0");
				sdModeCellEdit.addOption(RESOURCE['doubleMode'], "1");
			}
		}
	  
		  
    	if(null != elem.editElement && elem.isEdit == 1)
    	{
    	    createTablePopupMenu(elem,evt);
    	    return;
    	}
    	
    	for(var i = 0; i < rows.length; i++)
    	{
    		var tmpElem = elem.parent.getCellElement(rows[i],colid);
    		if(null != tmpElem.editElement && tmpElem.isEdit == 1)
    		{
    			 createTablePopupMenu(tmpElem,evt);
    			 return;
    		}
    	}
    	
    }    
}
