var clocktype = new Object();
clocktype["1"] = "ATOMIC_CLOCK";
clocktype["2"] = "GPS";
clocktype["3"] = "TERRESTRIAL_RADIO";
clocktype["4"] = "PTP";
clocktype["5"] = "NTP";
clocktype["6"] = "HAND_SET";
clocktype["7"] = "OTHER";
clocktype["8"] = "INTERNAL_OSCILLATOR";

var timelevelArr = [[6,7],[13,14],[52,52],[58,58],[68,122],[133,170],[216,232],[187,187],[193,193],[248,248],[255,255]];
var MIN_TIMELEVEL = "0";
var MAX_TIMELEVEL = "255";
var DEF_TIMELEVEL = "187";

var MIN_TIMEPRE = "32";
var MAX_TIMEPRE = "49";
var DEF_TIMEPRE = "49";

var MIN_TIMEPRI = "0";
var MAX_TIMEPRI = "255";
var DEF_TIMEPRI = "0";

var MIN_OFFSET = "0";
var MAX_OFFSET = "65535";
var DEF_OFFSET = "32768";

var timelevelTextCheckFlag = false;
function addCellEvent()
{
    var cell = null;
    for(var i = 0,len = st.getDataRowLength();i<len;i++)
    {            
        cell = st.getCellElement(i,"timelevel");
		textCheck(cell.editElement.element,MIN_TIMELEVEL,MAX_TIMELEVEL,false);//timelevelTextCheck(cell.editElement.element);
        
        cell = st.getCellElement(i,"timeprecision");
        textCheck(cell.editElement.element,MIN_TIMEPRE,MAX_TIMEPRE,false);
        
        cell = st.getCellElement(i,"clockpri1");
        textCheck(cell.editElement.element,MIN_TIMEPRI,MAX_TIMEPRI,false);
      
        cell = st.getCellElement(i,"clockpri2");
        textCheck(cell.editElement.element,MIN_TIMEPRI,MAX_TIMEPRI,false);

		cell = st.getCellElement(i,"clockoffset");
		textCheck(cell.editElement.element,MIN_OFFSET,MAX_OFFSET,false);
    }
}
/**
 *     ,           1          
 */
function checkText(obj,min,max,decimalCount,flag)
{	
	min += "";
	max += "";
	
	obj.style.imeMode = "disabled";
	
	obj.onpaste = function()
	{
		timelevelTextCheckFlag = flag;
		return false;
	}
	
    obj.onblur = function()
	{
		timelevelTextCheckFlag = flag;
		blurValidate(obj,min,max,decimalCount);
    }
    
    obj.onkeypress = function()
    {
		timelevelTextCheckFlag = flag;
        return digitalCheck(obj, min, max,decimalCount);    	
    }
}

function alertDialog(min,max)
{
	if(timelevelTextCheckFlag)
	{//                   
		return true;
	}

	var alertStr;
	if(min.indexOf(".") == -1&&max.indexOf(".") == -1)
	{
	    alertStr = RESOURCE["wrong1"] + min + RESOURCE["wrong2"] + max;
		  alertStr += RESOURCE["wrong3"];
	}
	else
	{
	   alertStr = RESOURCE["wrong5"] + min + RESOURCE["wrong2"] + max;
	   alertStr += RESOURCE["wrong4"];
	}
	
	alert(alertStr);
    return false;
}

var alertFlag = true;
function timelevelTextCheck(obj)
{	
	obj.style.imeMode = "disabled";
	
	obj.onpaste = function()
	{
		return false;
	}
	
	obj.onblur = function()
	{
	    var value = obj.value;
	    var item;
	    var flag = false;
        for(var i = 0,len = timelevelArr.length;i<len;i++)
	    {
	        item = timelevelArr[i];
	        if(item[0] <= value && value <= item[1])
	        {
	            flag = true;
	            break;
	        }
	    }  	
	    if(!flag)
	    {
	        var alertStr = RESOURCE["wrong1"] + "6-7,13-14,52,58,68-122,133-170,216-232,187,193,248,255 " + RESOURCE["wrong3"];	
	        /*if(alertFlag)
	        {
	            alertFlag = false;
	            alert(alertStr);
	        }
	        else
	        {
	            alertFlag = true;
	        }*/   
	        alert(alertStr);
	        obj.value = 187;
	        obj.focus();
	    }
    }

}
