var winurlobj = window.parent;
var neid = winurlobj.winurlobj["neid"];
var bdType = winurlobj.winurlobj["boardType"];
var btnRightArr = new Object();
var st,st1;
var OPRSUCC = 0;
var PARTSUCC = 1;
var BDTYPE_TNF1ELQM = 2446;

var pemode = new Object();
pemode["0"] = "cancelbtn";
pemode["1"] = "P2P";
pemode["2"] = "E2E";

var P2P = "1";
var E2E = "2";

var cycleArr = new Object();
cycleArr["-10"] = "1/1024";
cycleArr["-9"] = "2/1024";
cycleArr["-8"] = "4/1024";
cycleArr["-7"] = "8/1024";
cycleArr["-6"] = "16/1024";
cycleArr["-5"] = "32/1024";
cycleArr["-4"] = "64/1024";
cycleArr["-3"] = "128/1024";
cycleArr["-2"] = "256/1024";
cycleArr["-1"] = "512/1024";
cycleArr["0"] = "1";
cycleArr["1"] = "2";
cycleArr["2"] = "4";
cycleArr["3"] = "8";
cycleArr["4"] = "16";
cycleArr["5"] = "32";
cycleArr["6"] = "64";
cycleArr["7"] = "128";
cycleArr["8"] = "256";
cycleArr["9"] = "512";
cycleArr["10"] = "1024";

var minCycle = -10;
var maxCycle = 10;

var rangeDoc = null;

var INVALID_SUB_SLOTID = "255";

var rowSelectIndex = 0;

var v1r6NeVersion = "5.51.07.35";

var supportE2EBoard = new Object();

function cycle(paramData)
{
	return cycleArr[paramData];
}

var MIN_VLAN1588 = "1";
var MAX_VLAN1588 = "4094";

var MIN_TIMEOUTMULT = "3";
var MAX_TIMEOUTMULT = "10";

var TC = "3";
var TCBC = "5";

window.onresize=function()
{
    st.setBodyHeight(getComponetHeight($("tablecomponent"),60)+"px");
}	      

function init()
{
	var xmlFile = "";
    if (adapterVersion(v1r6NeVersion))
    {
    	xmlFile = "../../../conf/clock_ptp/ptpclock_paramrange_v1r5c00.xml";
    }
    else
    {
	    xmlFile = "../../../conf/clock_ptp/ptpclock_paramrange.xml";
    }
    loadXMLdoc(xmlFile,"GET",true,queryRangeCallback);
    var ptpPortXMLFile = "../../../conf/clock_ptp/ptp_port_res.xml";
    loadXMLdoc(ptpPortXMLFile,"GET",true,queryPEModelCallback);
	st = new SortTable();	
    st.setImage("../../../../../images/");    
    tc = window.tableconf[0];   
    createTableHead(st, tc); 
    var hc = st.getHeadCell("portName");
	st.setHCAttribute(hc, 1, 2, compareSlotPort);
    st.setOnCellEditHandler(cellEditHandler);
    st.setOnRowSelectHandler(rowSelectHandler);
	st.setBodyHeight(getComponetHeight($("tablecomponent"),60)+"px");
    $("tablecomponent").appendChild(st.getTable());
    $("tablecomponent").oncontextmenu = popupMenuHandler;

    $("querybtn").value=RESOURCE["querybutton"];
    $("applybtn").value=RESOURCE["applybutton"]; 	
    btnRightArr.querybtn = new BtnRightObj("querybtn",TECMDCODE_QUERY_PTP_PORTMSG);
    btnRightArr.applybtn = new BtnRightObj("applybtn",TECMDCODE_SET_PTP_PORTMSG);   
       
    getRightInfo(winurlobj.winurlobj,btnRightArr); 
    $("applybtn").disabled = true;
}

function queryPEModelCallback(doc)
{	
	var itemArray = doc.getElementsByTagName("item");
	
	for( var i = 0; i < itemArray.length; i++ )
	{
		var tmpItem = itemArray[i];
		var tmpBoardType = tmpItem.getAttribute("cp_type_id");
		var tmppeMode = tmpItem.getAttribute("peMode");
		supportE2EBoard[tmpBoardType]= tmppeMode;
	}
}

function cellEditHandler(param)
{
	if (param.stage == TABLE_CONSTANT.AFTEREDIT)
	{
		$("applybtn").disabled = !btnRightArr.applybtn.right; 
	}
    

    var row = param.rowindex;
    var colid = param.colid;
    
    var portid = st.getCellStoreValue(row, "port", "port");
    var boardType = st.getCellStoreValue(row,"boardname","boardtype");
    if (colid == 'pemode')
    {
    	var pemodeCellEdit = st.getCellEdit(row, colid);
	    pemodeCellEdit.clearOptions();
    	if (bdType == BDTYPE_TNF1ELQM || SpecialAttrMgr.isCPSupportByType(neid, boardType, "TE_FUNC_CFG_PTPCLOCK_SYN_ATTRIBUTE", "OTN_ATTR_SUPPORT_SPECIALOPER_ASELQM"))
    	{	    	
	    	if (portid == 1 || portid == 2)
	    	{
	    		pemodeCellEdit.addOption("E2E", "2");
	    	}
	    	else
	    	{
	    		pemodeCellEdit.addOption("P2P", "1");
	    		pemodeCellEdit.addOption("E2E", "2");
	    	}
    	}
    	else
    	{
    		var tempPEMode = supportE2EBoard[boardType];
    		if (tempPEMode == "E2E")
    		{
    			pemodeCellEdit.addOption("E2E", "2");
    		}
    		else if (tempPEMode == "P2P")
    		{
    			pemodeCellEdit.addOption("P2P", "1");
    		}
    		else
    		{
    			pemodeCellEdit.addOption("P2P", "1");
	    		pemodeCellEdit.addOption("E2E", "2");
    		}   	  	
    	}
    }
       
    if( !(colid == 'syncycle' || colid == 'delaycycle' || colid == 'pdelaycycle' || colid == 'anncycle') )
    {
        return;
    }
    rangeCheck(row, colid);
}

function tabSelectHandler()
{
    query();
}

function query()
{
	$("querybtn").disabled = true;
    $("applybtn").disabled = true;  
	
    var xmlstr = createQueryXML();    
    urlreq ="../../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_PTP_PORTMSG +"&nmUser="+winurlobj.winurlobj["nmUser"];        
    loadXMLdoc(urlreq, "POST",false,handleBackQuery,null,"inputdata="+xmlstr);
}

function createQueryXML()
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);
    
    var param = new tagElement("param");    
    param.setAttribute("name","workmode");
    param.setAttribute("value",winurlobj.neStatus);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackQuery(doc)
{
	$("querybtn").disabled = false;
	var data = EncapsulateData(doc); 
	  
	for(var i = 0, len = data.getBErrLength();i < len;i++)
	{
      var tempObj = data.getError().rowErrors[i].errorObj;
      tempObj["operateObj"] = RESOURCE["queryPortMsg"];
	}	
	  
	var errArr = [];
    errArr[0] = "operateObj";
    openErrPage("../../../../../page/", data.getError(), errArr);    
	    
  if (OPRSUCC == data.getSErrorCode() || PARTSUCC == data.getSErrorCode()) 
  {
		st.clearTableData();
		createTableBody(st, window.tableconf[0], data, RESOURCE);

		for(var i = 0, len = data.getDataRowLength();i < len;i++)
		{
			var pemode = st.getCellStoreValue(i,"pemode","pemode");
			if (P2P == pemode)
			{
				var delaycycle = st.getCell(i,"delaycycle").element;
				setCellUnedit(delaycycle);
			}
			else if(E2E == pemode)
			{               
				var pdelaycycle = st.getCell(i,"pdelaycycle").element;
				setCellUnedit(pdelaycycle);
			}
			else if(-1 == pemode)//      
			{               
				setCellUnedit(st.getCell(i,"pemode").element);

				setCellUnedit(st.getCell(i,"delaycycle").element);
	                        setCellUnedit(st.getCell(i,"pdelaycycle").element);
			}
			else
			{//0      TC  
				var delaycycle = st.getCell(i,"delaycycle").element;
                setCellUnedit(delaycycle);

				var pdelaycycle = st.getCell(i,"pdelaycycle").element;
                setCellUnedit(pdelaycycle);
			}
			if(typeof(st.getCellStoreValue(i,"syncycle","syncycle")) == "undefined" 
					|| st.getCellStoreValue(i,"syncycle","syncycle") == "")
			{
				setCellUnedit(st.getCell(i,"syncycle").element);
			}
			if(typeof(st.getCellStoreValue(i,"anncycle","anncycle")) == "undefined" 
					|| st.getCellStoreValue(i,"anncycle","anncycle") == "")
			{
				setCellUnedit(st.getCell(i,"anncycle").element);
			}
			
			if(typeof(st.getCellStoreValue(i,"anntimeout","anntimeout")) == "undefined" 
					|| st.getCellStoreValue(i,"anntimeout","anntimeout") == "")
			{
				setCellUnedit(st.getCell(i,"anntimeout").element);
			}
			if(typeof(st.getCellStoreValue(i,"delaycycle","delaycycle")) == "undefined" 
					|| st.getCellStoreValue(i,"delaycycle","delaycycle") == "")
			{
				setCellUnedit(st.getCell(i,"delaycycle").element);
			}
		}
		addCellEvent();
	}
}

function addCellEvent()
{
    var cell = null;
    for(var i = 0,len = st.getDataRowLength();i<len;i++)
    {			  
        cell = st.getCellElement(i,"anntimeout");
    	textCheck(cell.editElement.element,MIN_TIMEOUTMULT,MAX_TIMEOUTMULT);
    
        cell = st.getCellElement(i,"pemode");
    	cell.editElement.element.onchange = function()
    	{
    	    var pemode = this.value;
    	    var rowindex = this.parentNode.parentNode.rowIndex;
    	    var delaycycle = st.getCell(rowindex,"delaycycle");
    	    var pdelaycycle = st.getCell(rowindex,"pdelaycycle");
    	      
    	    if (P2P == pemode)
            {                                             
    	    	setCellUnedit(delaycycle.element);  	          
    	    	delaycycle.element.modify = false;
    	    	setCellEdit(pdelaycycle.element);                
    	    	st.setCellValue(pdelaycycle, "pdelaycycle", "0");
                pdelaycycle.element.showElement.setValue(cycleArr["0"]);
                pdelaycycle.element.modify = true;
            }
            else if(E2E == pemode)
            {
            	var neworkmode = winurlobj.st.getCellCurrentValue(0,"workmode","workmode");
          
                setCellEdit(delaycycle.element);
                st.setCellValue(delaycycle, "delaycycle", "0");
                delaycycle.element.showElement.setValue(cycleArr["0"]);
                delaycycle.element.modify = true;
       
    	        setCellUnedit(pdelaycycle.element);
                pdelaycycle.element.modify = false;
            }
    	    else
    	    {
    	        setCellUnedit(delaycycle.element);  	          
                setCellUnedit(pdelaycycle.element); 
		
                delaycycle.element.modify = false;
                pdelaycycle.element.modify = false;
	    }
        }
    }
}


function apply()
{	
    var xmlstr = createApplyXML();
    if (null == xmlstr)
    {
    	  return;
    }
    
    $("querybtn").disabled = true;
	  $("applybtn").disabled = true;
	  
    urlreq ="../../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_PTP_PORTMSG + "&nmUser="+winurlobj.winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST",true,handleBackApply,null,"inputdata="+xmlstr);
    
}

function createApplyXML()
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var length = st.getDataRowLength();
    if (0 < length)
    {    	  
    	  for(var rowindex = 0; rowindex < length; rowindex++)
        {            
            if(!st.getModify(rowindex))
        	  {
        	  	  continue;
        	  }
        	  
        	  var row = new tagElement("row-params");
        
	          var param = new tagElement("param");    
            param.setAttribute("name","neid");
            param.setAttribute("value",neid);
            row.appendChild(param);
        	  
        	param = new tagElement("param");    
          	param.setAttribute("name","slotid");
          	param.setAttribute("value",st.getCellStoreValue(rowindex,"port","slotid"));
          	row.appendChild(param);
        	  
        	param = new tagElement("param");    
          	param.setAttribute("name","subslotid");
          	var subslotid = st.getCellStoreValue(rowindex,"portName","subslotid");
          	if (null == subslotid)
          	{
          		  subslotid = INVALID_SUB_SLOTID;
          	}
          	param.setAttribute("value",subslotid);
          	row.appendChild(param);
        	  
        	param = new tagElement("param");    
          	param.setAttribute("name","port");
          	param.setAttribute("value",st.getCellStoreValue(rowindex,"port","port"));
          	row.appendChild(param);
        	
            if (st.getCellModify(rowindex, "pemode"))
            {
            	  param = new tagElement("param");    
          	    param.setAttribute("name","pemode");
          	    param.setAttribute("value",st.getCellStoreValue(rowindex,"pemode","pemode"));
          	    row.appendChild(param);
          	}
        	
            if (st.getCellModify(rowindex, "delaycycle"))
            {
            	  param = new tagElement("param");    
          	    param.setAttribute("name","delaycycle");
          	    param.setAttribute("value",st.getCellStoreValue(rowindex,"delaycycle","delaycycle"));
          	    row.appendChild(param);
          	} 
			
			if (st.getCellModify(rowindex, "pdelaycycle"))
            {
            	  param = new tagElement("param");    
          	    param.setAttribute("name","pdelaycycle");
          	    param.setAttribute("value",st.getCellStoreValue(rowindex,"pdelaycycle","pdelaycycle"));
          	    row.appendChild(param);
          	} 
			
			if (st.getCellModify(rowindex, "anncycle"))
            {
            	  param = new tagElement("param");    
          	    param.setAttribute("name","anncycle");
          	    param.setAttribute("value",st.getCellStoreValue(rowindex,"anncycle","anncycle"));
          	    row.appendChild(param);
          	} 
			
			if (st.getCellModify(rowindex, "syncycle"))
            {
            	  param = new tagElement("param");    
          	    param.setAttribute("name","syncycle");
          	    param.setAttribute("value",st.getCellStoreValue(rowindex,"syncycle","syncycle"));
          	    row.appendChild(param);
          	} 
			
			if (st.getCellModify(rowindex, "anntimeout"))
            {
            	  param = new tagElement("param");    
          	    param.setAttribute("name","anntimeout");
          	    param.setAttribute("value",st.getCellStoreValue(rowindex,"anntimeout","anntimeout"));
          	    row.appendChild(param);
          	} 
			
        	bussiness.appendChild(row);
        }    	  
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackApply(doc)
{     
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    
	  var data = EncapsulateData(doc); 
    
    if (OPRSUCC != data.getError().getGlobleECode())
    {
    	  for(var i = 0, size = data.getBErrLength();i < size;i++)
	      {
		    	  var tempObj = data.getError().rowErrors[i].errorObj;
  	    		  tempObj["operateObj"] = RESOURCE["setPortMsg"];
		    }	
	      var errArr = [];
        errArr[0] = "operateObj";
        openErrPage("../../../../../page/", data.getError(), errArr);
        
        $("applybtn").disabled = false;
    }

    if (OPRSUCC == data.getError().getGlobleECode() || PARTSUCC == data.getError().getGlobleECode()) 
    {
	      refreshTableState(st,tc,data);
    }     
}


function filterOptions(editdom,colid)
{
	  var boardname = st.getCellStoreValue(rowSelectIndex,"boardname","boardname");
	  if("anncycle" == colid)
	  {
	  	var editdomclone = new Object();
			for(var member in editdom) {
				editdomclone[member] = editdom[member];
			}
			editdomclone.element = editdom.element.cloneNode(true);
			if (isIE)
			{
				editdomclone.removeAtOption(0);
			}
			editdomclone.element.onblur=cellonblur;
			
			if(boardname == "N1EGSH")
	  	{
	  		editdom.removeAtOption(0);
	  		editdom.removeAtOption(1);
	  		editdom.removeAtOption(2);
	  		editdom.removeAtOption(3);
	  		editdom.removeAtOption(4);
	  	}
	  	else if(boardname == "N4SLQ64"||boardname == "N3SLH41"||boardname == "N4SLD64"||boardname == "N4SLO16"
	  		||boardname == "N4SL64"||boardname == "N4SLQ16"||boardname == "N4SFD64"||boardname == "N4SF64"
	  		)
	  	{
	  		 editdom.removeAtOption(0);
	  		 editdom.removeAtOption(1);
	  		 editdom.removeAtOption(2);
	  		 editdom.removeAtOption(3);
	  		 editdom.removeAtOption(4);
	  		 editdom.removeAtOption(5);
	  	}
	  	
	  	
	  	return editdom;
	  }
	  else if("delaycycle" == colid)
	 	{
	 		var editdomclone = new Object();
			for(var member in editdom) {
				editdomclone[member] = editdom[member];
			}
			editdomclone.element = editdom.element.cloneNode(true);
			if (isIE)
			{
				editdomclone.removeAtOption(0);
			}
			editdomclone.element.onblur=cellonblur;
			
		 if(boardname == "N4SLQ64"||boardname == "N3SLH41"||boardname == "N4SLD64"||boardname == "N4SLO16"
	  		||boardname == "N4SL64"||boardname == "N4SLQ16"||boardname == "N4SFD64"||boardname == "N4SF64"
	  		)
	  	{
	  		 editdom.removeAtOption(0);
	  		 editdom.removeAtOption(1);
	  		 editdom.removeAtOption(2);
	  		 editdom.removeAtOption(3);
	  		 editdom.removeAtOption(4);
	  		 editdom.removeAtOption(5);
	  		 editdom.removeAtOption(6);
	  		 editdom.removeAtOption(7);
	  	}
	  	
	  	return editdom;
	 	}
	  else
		{
			return null;
		}
	
}


function rowSelectHandler (rows)
{
  if(rows.length == 1)
	{	
			rowSelectIndex = rows[0];
			return;
	}
}


function queryRangeCallback(doc)
{
	rangeDoc = doc;	
}

function rangeCheck(row, colid)
{
	if( rangeDoc == null )
	{
		return;
	}
	
	var boardType = st.getCellStoreValue(row,"boardname","boardtype");
	
	var itemArray = rangeDoc.getElementsByTagName("item");
	
	var specialOprFlg = false;
	
	for( var i = 0; i < itemArray.length; i++ )
	{
		var tmpItem = itemArray[i];
		var tmpBoardType = tmpItem.getAttribute("cp_type_id");
		
		if( !isDataValid(tmpBoardType) || tmpBoardType != boardType )
		{
			continue;
		}
		
		if( itemArray[i].hasChildNodes() <= 0 )
		{
			continue;
		}

		for( var j = 0; j < tmpItem.childNodes.length; j++ )
		{
			var tmpChildNode = tmpItem.childNodes[j];
			var minValue = tmpChildNode.getAttribute("min_"+colid);
			var maxValue = tmpChildNode.getAttribute("max_"+colid);

			var minCycle = isDataValid(minValue) ? minValue : minCycle;
			var maxCycle = isDataValid(maxValue) ? maxValue : maxCycle;
			
			var cellEdit = st.getCellEdit(row, colid, colid);
			cellEdit.clearOptions();
			
			var sycleRange = getSycleRange(boardType, colid);
			
			if(sycleRange.length == 2)
			{
			    minCycle = sycleRange[0];
			    maxCycle = sycleRange[1];
			}
			
			var index = 0;
			for( index = minCycle ; index <= maxCycle ; index++ )
			{
				cellEdit.addOption(cycleArr[index], index);
				specialOprFlg = true;
			}
		}
	}
	
	if(!specialOprFlg)
	{
	    var cellEdit = st.getCellEdit(row, colid, colid);
	    cellEdit.clearOptions();
	    var minvalue = -10;
	    var maxvalue = 10;
	    if (adapterVersion(v1r6NeVersion))
	    {
	    	if (colid == "syncycle")
		    {
		        minvalue = -8;
		        maxvalue = 1;
		    }
		    else
		    {
		       minvalue = -4;
		       maxvalue = 4;
		    }
	    }
		var cycleRange = getSycleRange(null,colid);
		if(cycleRange.length == 2)
		{
		    minvalue = cycleRange[0];
		    maxvalue = cycleRange[1];
		}
	    
	    for( index = minvalue ; index <= maxvalue ; index++ )
	    {
	        cellEdit.addOption(cycleArr[index], index);
	    }
	}
}


function popupMenuHandler(evt)
{	
	if (!evt)
	{
		evt = window.event;
	}

	var elem = (evt.target) ? evt.target : evt.srcElement;

	if (elem != null && elem.blur)
	{
		elem.blur();
	}

	while (elem != null)
	{
		if (elem.tagName == 'TD')
		{
			break;
		}
		else
		{
			elem = elem.parentNode;
		}
	}

	if (elem == null || elem.tagName != 'TD' || null == elem.parent
			|| elem.editElement == null)
	{
		return;
	}

	var rowid = elem.parentNode.rowIndex;
	var rows = elem.parent.getSelectedRows();
	var colid = elem.colid;
	var isColNotShowMenu = ((null != this.popupMenuExcludeCells) && (this.popupMenuExcludeCells.contains(colid)));

	if (rows.contains(rowid))
	{
		 if (colid == 'pemode')
	     {
	     	var boardType = st.getCellStoreValue(rowid,"boardname","boardtype");
	    	var pemodeCellEdit = st.getCellEdit(rowid, colid);
		    pemodeCellEdit.clearOptions();
	    	if (bdType == BDTYPE_TNF1ELQM || SpecialAttrMgr.isCPSupportByType(neid, boardType, "TE_FUNC_CFG_PTPCLOCK_SYN_ATTRIBUTE", "OTN_ATTR_SUPPORT_SPECIALOPER_ASELQM"))
	    	{	    	
		    	if (portid == 1 || portid == 2)
		    	{
		    		pemodeCellEdit.addOption("E2E", "2");
		    	}
		    	else
		    	{
		    		pemodeCellEdit.addOption("P2P", "1");
		    		pemodeCellEdit.addOption("E2E", "2");
		    	}
	    	}
	    	else
	    	{
	    		var tempPEMode = supportE2EBoard[boardType];
	    		if (tempPEMode == "E2E")
	    		{
	    			pemodeCellEdit.addOption("E2E", "2");
	    		}
	    		else if (tempPEMode == "P2P")
	    		{
	    			pemodeCellEdit.addOption("P2P", "1");
	    		}
	    		else
	    		{
	    			pemodeCellEdit.addOption("P2P", "1");
		    		pemodeCellEdit.addOption("E2E", "2");
	    		}   	  	
	    	}
	    }
	    
		if (colid == 'syncycle' || colid == 'delaycycle' || colid == 'pdelaycycle' || colid == 'anncycle')
		{
			if (rows.length == 1)
			{
				rangeCheck(rows[0], colid);
			}
			else
			{
				var cellEdit = st.getCellEdit(rows[0], colid, colid);
				cellEdit.clearOptions();
				
				for(var index = -10; index <= 10; index++)
				{
					cellEdit.addOption(cycleArr[index], index);
				}
			}
		}
		if (null != elem.editElement && 
			 	elem.isEdit == 1 && !isColNotShowMenu)
		{
			createTablePopupMenu(elem, evt);
			return;
		}

		for ( var i = 0; i < rows.length; i++)
		{
			var tmpElem = elem.parent.getCellElement(rows[i], colid);
			if (null != tmpElem.editElement && tmpElem.isEdit == 1 && !isColNotShowMenu)
			{
				createTablePopupMenu(tmpElem, evt);
				return;
			}
		}
	}
}

function adapterVersion(version)
{
	return compare(winurlobj.winurlobj["neversion"],version) >= 0;
}

function isDataValid(param)
{
	if( param == null || param == "" )
	{
		return false;
	}
	else
	{
		return true;
	}
}

function getSycleRange(bdType, colid)
{
    var range = [];
    var attr;
    switch(colid)
    {
        case 'syncycle':
            attr = 'OTN_ATTR_SUPPORT_SYNCIRCLE_RANGE';
            break;
        case 'delaycycle':
            attr = 'OTN_ATTR_SUPPORT_DELAYCYCLE_VALUES';
            break;
        case 'pdelaycycle':
            attr = 'OTN_ATTR_SUPPORT_PDELAYCYCLE_VALUES';
            break;
        case 'anncycle':
            attr = 'OTN_ATTR_SUPPORT_ANNCYCLE_VALUES';
            break;
        default:
            break;
    }

    if(attr)
    {
    	
       var cycleRange = null;
       if (bdType == null)
       {
    	   cycleRange = SpecialAttrMgr.getNEAttrListValue(neid, "TE_FUNC_CFG_PTPCLOCK_SYN_ATTRIBUTE", attr);
       }
       else
       {
    	   cycleRange = SpecialAttrMgr.getCpAttrListValueByType(neid, bdType, "TE_FUNC_CFG_PTPCLOCK_SYN_ATTRIBUTE", attr);
       }
	   if(cycleRange && cycleRange.length == 2)
	   {
	      range[0] = parseInt(cycleRange[0]);
	      range[1] = parseInt(cycleRange[1]);
	   }
    }
    return range;
}
