  var COLUMS_NUM_2 = 2;
 var COLUMS_NUM_3 = 3;
 var COLUMS_NUM_5 = 5; 
 
 var SERVICE_TYPE_TITLE = "Service Configuration";
 var PORT_TYPE_TITLE = "Port Type";
 var CROSS_CONFIG_TITLE = "Cross-Connection Configuration";
 
 var SERVICE_TYPE_TABHEAD = "BoardServiceTypeTable";
 var PORT_TYPE_TABHEAD = "PortTypeTable";
 var CROSS_CONFIG_TABHEAD = "CrossConfigTable";
 
/**
*         
*/
function loadPackagesXMLParse(xmldoc,packageMap)
{  
    var packages = xmldoc.getElementsByTagName("package");
    for(var i = 0; i < packages.length; i++)
    {    	
    	var pack = new Object();
    	
    	var tmpPackage = packages[i];
        var packID = tmpPackage.getAttribute("id");
        var packName = tmpPackage.getAttribute("name");
        
          
        pack.ID = packID;
        pack.Name = packName;
        
        var workModeArray = tmpPackage.getElementsByTagName("workMode");
       	if( workModeArray.length > 0 )
		{
		  pack.WorkMode = workModeParse(workModeArray[0]);
		}
                
        var tabpageArray = tmpPackage.getElementsByTagName("tabpage"); 
        for(var j = 0; j < tabpageArray.length; j++)        
        {
        	var tabpageNode = tabpageArray[j];
        	if(tabpageNode.getAttribute("tableHeader") == SERVICE_TYPE_TABHEAD)
        	{
        		 pack.ServiceType = serviceTypeParse(tabpageNode);
        	}
        	else if(tabpageNode.getAttribute("tableHeader") == PORT_TYPE_TABHEAD)        		
        	{
        		pack.PortType = portTypeParse(tabpageNode);
        	}
        	else if(tabpageNode.getAttribute("tableHeader") == CROSS_CONFIG_TABHEAD)        		
        	{
        		 pack.CrossConfig = crossConfigParse(tabpageNode);
        	}
        }        
        packageMap[packID] = pack;
    }
    return packageMap;
}

/**
*   WorkMode  
*/
function workModeParse(workModeNode)
{  	
	if(!workModeNode.hasChildNodes())
	{
	   return null;
	}
	var workMode = new Object();
	var modeArray = [];  
    var rowDataArray = workModeNode.getElementsByTagName("rowData");
    for(var i = 0; i < rowDataArray.length; i++)
    {
    	var rowDateNode = rowDataArray[i];    
	   	if( rowDateNode.childNodes.length != COLUMS_NUM_2 )
		{
		  continue;
	 	}   
	 	var modeObj = new Object();     
        modeObj.Port = rowDateNode.childNodes[0].getAttribute("value");
        modeObj.WorkMode = rowDateNode.childNodes[1].getAttribute("value");        
        modeArray.push(modeObj);        
    } 
    
   	workMode.BoardMode = workModeNode.getAttribute("boardMode");  
    workMode.RowData = modeArray;    	
    return workMode;
}

/**
*   ServiceType  
*/
function serviceTypeParse(serviceTypeNode)
{  
	if(!serviceTypeNode.hasChildNodes())
	{
	   return null;
	}
	var serviceType = new Object();
	var itemArray = [];   
    var rowDataArray = serviceTypeNode.getElementsByTagName("rowData");
    for(var i = 0; i < rowDataArray.length; i++)
    {
    	var rowDateNode = rowDataArray[i];    
	   	if( rowDateNode.childNodes.length < COLUMS_NUM_2 )
		{
		  continue;
	 	}   
	 	var serviceTypeObj = new Object();     
        serviceTypeObj.Port = rowDateNode.childNodes[0].getAttribute("value");
        serviceTypeObj.ServiceType = rowDateNode.childNodes[1].getAttribute("value");  
        serviceTypeObj.TimeSlotMode = (serviceTypeNode.getAttribute("hideCol") == null ? rowDateNode.childNodes[2].getAttribute("value") : "-");      
        itemArray.push(serviceTypeObj);        
    }  
    serviceType.HideCol = serviceTypeNode.getAttribute("hideCol");  
    serviceType.RowData = itemArray;    	
    return serviceType;
}

/**
*   portType  
*/
function portTypeParse(portTypeNode)
{  	if(!portTypeNode.hasChildNodes())
	{
	   return null;
	}	
	var portType = new Object();
	var itemArray = [];   
    var rowDataArray = portTypeNode.getElementsByTagName("rowData");
    
    for(var i = 0; i < rowDataArray.length; i++)
    {
    	var rowDateNode = rowDataArray[i];    
	   	if( rowDateNode.childNodes.length != COLUMS_NUM_2 )
		{
		  continue;
	 	}   
	 	var portTypeObj = new Object();     
        portTypeObj.Port = rowDateNode.childNodes[0].getAttribute("value");
        portTypeObj.PortType = rowDateNode.childNodes[1].getAttribute("value");        
        itemArray.push(portTypeObj);        
    }  
    portType.RowData = itemArray;    	
    return portType;
}

/**
*   CrossConfig  
*/
function crossConfigParse(crossConfigNode)
{  
	if(!crossConfigNode.hasChildNodes())
	{
	   return null;
	}
	var crossConfig = new Object();
	var itemArray = [];   
    var rowDataArray = crossConfigNode.getElementsByTagName("rowData");
    for(var i = 0; i < rowDataArray.length; i++)
    {
    	var rowDateNode = rowDataArray[i];    
	   	if( rowDateNode.childNodes.length != COLUMS_NUM_5)
		{
		  continue;
	 	}   
	 	var crossConfigObj = new Object();     
        crossConfigObj.Level = rowDateNode.childNodes[0].getAttribute("value");
        crossConfigObj.ServiceType = rowDateNode.childNodes[1].getAttribute("value"); 
        crossConfigObj.Direction = rowDateNode.childNodes[2].getAttribute("value"); 
        crossConfigObj.SourceChannel = rowDateNode.childNodes[3].getAttribute("value");     
        crossConfigObj.SinkChannel = rowDateNode.childNodes[4].getAttribute("value");            
        itemArray.push(crossConfigObj);        
    }  
    crossConfig.RowData = itemArray;    	
    return crossConfig;
}
