/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.wdminterface.specialprocess;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.jni.dbservice.TEGeneralValue;
import com.huawei.nglct.db.jni.dbservice.TEGnlValueElement;
import com.huawei.nglct.gencfg.frame.TEGnlAttrMgr;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.TEWDMInfUtil;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.objtypeid.TEPartSource;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.specialprocess.TEActUpDownWaveHandler;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.specialprocess.TECfgUpDownWaveHandler;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.specialprocess.TECfgUpDownWdmTypeHandler;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.specialprocess.TECfgWaveLenTypeHandler;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.specialprocess.TECfgWdmTypeHandler;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.specialprocess.TEOtnOhTransHandler;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.specialprocess.TEServiceTypeHandler;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class TEAttrHandler {
    private static Logger logger = TELogFactory.getNormalLogger();
    private static Map<String, TEAttrHandler> handlerMap = new HashMap<String, TEAttrHandler>();
    private static TEAttrHandler instance = null;

    protected TEAttrHandler() {
    }

    public static synchronized TEAttrHandler getInstance() {
        if (null == instance) {
            instance = new TEAttrHandler();
            TEAttrHandler.initHandler();
        }
        return instance;
    }

    private static void initHandler() {
        handlerMap.put("W32BRD_ATTR_CFGWDMTYPE", new TECfgWdmTypeHandler());
        handlerMap.put("W32BRD_ATTR_WDMTYPE", new TECfgWdmTypeHandler());
        handlerMap.put("W32PORT_ATTR_CFGWAVELENTYPE", new TECfgWaveLenTypeHandler());
        handlerMap.put("W32PORT_ATTR_WAVELENTYPE", new TECfgWaveLenTypeHandler());
        handlerMap.put("W32BRD_ATTR_CFGUPDOWNWDMTYPE", new TECfgUpDownWdmTypeHandler());
        handlerMap.put("W32BRD_ATTR_CFGUPDOWNWAVE", new TECfgUpDownWaveHandler());
        handlerMap.put("W32BRD_ATTR_UPDOWNWAVE", new TEActUpDownWaveHandler());
        handlerMap.put("W32PORT_ATTR_ST_SERVICETYPE", new TEServiceTypeHandler());
        handlerMap.put("W32PORT_ATTR_ST_SERVICETYPE_2", new TEServiceTypeHandler());
        handlerMap.put("W32PORT_ATTR_OTN_OHTRANS", new TEOtnOhTransHandler());
        handlerMap.put("W32PORT_ATTR_RECWAVELEN", new TECfgUpDownWaveHandler());
    }

    private TEAttrHandler getHandler(String attrName) {
        TEAttrHandler handler = handlerMap.get(attrName);
        if (null == handler) {
            handler = this;
            logger.info("Get Handler fail! Use default handler. attrName->" + attrName);
        }
        return handler;
    }

    public void setAttrPartValue(TEGnlValueElement ele, String attrValue, String attrName, Output output, Part part) {
        TEAttrHandler handler = this.getHandler(attrName);
        handler.setPartValueImpl(ele, attrValue, attrName, output, part);
    }

    protected void setPartValueImpl(TEGnlValueElement ele, String attrValue, String attrName, Output output, Part part) {
        part.setValue(attrValue);
    }

    public void setElementValue(int neID, TEPartSource partSource, String attrName, TEGeneralValue value) {
        TEAttrHandler handler = this.getHandler(attrName);
        handler.setElementValueImpl(neID, partSource, attrName, value);
    }

    protected void setElementValueImpl(int neID, TEPartSource partSource, String attrName, TEGeneralValue value) {
        int valueType = TEGnlAttrMgr.getInstance().getAttrValueType(((Integer)TEGnlAttrMgr.getInstance().getM_attrListForSaveDB().get(attrName)).intValue());
        if (null == partSource.getPart(TEWDMInfUtil.convertActAttrName(neID, attrName, partSource.isNeedConvertAttrName()))) {
            logger.info("Output's part is null. the attribute is " + attrName);
            return;
        }
        if (0 == valueType && null != partSource.getPart(TEWDMInfUtil.convertActAttrName(neID, attrName, partSource.isNeedConvertAttrName())).getValue()) {
            int iValue = new BigInteger(partSource.getPart(TEWDMInfUtil.convertActAttrName(neID, attrName, partSource.isNeedConvertAttrName())).getValue()).intValue();
            value.setiValue(iValue);
        } else {
            String sValue = partSource.getPart(attrName).getValue();
            value.setsValue(sValue);
        }
    }
}

