/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.wdminterface.script;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.script.TEScriptCmd;
import com.huawei.nglct.cbb.script.TEScriptHandler;
import com.huawei.nglct.cbb.script.TEScriptOperationMgr;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.db.jni.dbservice.TEGeneralKeyValue;
import com.huawei.nglct.db.jni.dbservice.TEGeneralValue;
import com.huawei.nglct.db.jni.dbservice.TEGnlValueElement;
import com.huawei.nglct.gencfg.TEGenCfgFunCmd;
import com.huawei.nglct.gencfg.frame.TEGnlAttrMgr;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nelist.model.TEQueryPortForDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenAttrObjectValue;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenObjectID;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenValue;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.TEWDMInfStaticData;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.TEWDMInfUtil;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.objtypeid.TEObjTypeIDCreator;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.objtypeid.TEPartSource;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.planningdata.TEPlanninDataHander;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.planningdata.TEPlanningDataJniMethod;
import com.huawei.nglct.ngwdm_pub.TEOTNModelDataMgr;
import com.huawei.nglct.ngwdm_pub.TEOTNModelShowPathMgr;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.slf4j.Logger;

public abstract class TEWDMInfScriptHandler
implements TEScriptHandler {
    protected static final int INVALID_VALUE = -1;
    protected static final Logger logger = TELogFactory.getNormalLogger();
    protected static final String PARAM_BOARD = "board";
    protected static final String PARAM_PORT = "port";
    protected static final String PARAM_PATH = "path";
    protected static final String PARAM_PATH_STR = "pathstr";
    protected static final String PARAM_VALUE = "value";
    protected static final int DATA_CONFLICT = 1090615320;
    protected static final ArrayList<Integer> needOperItemID = new ArrayList();

    public int doImport(int neID, int item, List<TEScriptCmd> contents) {
        StringBuffer tipBuffer = new StringBuffer();
        tipBuffer.append("Import script for wdm interface begin. neID->").append(neID).append("item->").append(item);
        logger.info(tipBuffer.toString());
        int retCode = 0;
        if (null == contents || contents.isEmpty()) {
            return retCode;
        }
        if (!TENEListMgr.getInstance().isAddedNE(neID)) {
            logger.info("Not managed ne. neID->" + neID);
            return 0;
        }
        int attrID = this.getAttrID();
        String attrName = this.getAttrName();
        retCode = this.importGnlAttrbute(neID, attrID, attrName, contents, item);
        logger.info("Import script for wdm interface end.");
        return retCode;
    }

    protected abstract int getAttrID();

    protected abstract String getAttrName();

    protected abstract String getObjTypeStr();

    protected abstract int getObjTypeID();

    private int importGnlAttrbute(int neID, int attrID, String attrName, List<TEScriptCmd> contents, int itemID) {
        int returnCode = 0;
        ArrayList<TEGnlValueElement> elementList = new ArrayList<TEGnlValueElement>();
        TEGnlValueElement element = null;
        boolean bDataConflict = false;
        for (TEScriptCmd cmd : contents) {
            boolean bOld;
            if (needOperItemID.contains(itemID) && (bOld = this.isOldData(neID, attrID, attrName, cmd))) {
                logger.info("attrID = " + attrID + "do not need Import. cmd ->" + cmd.toString());
                if (this.isConsistentWithNM(neID, attrID, attrName, cmd)) continue;
                logger.info(attrID + ">> cmd = " + cmd.toString() + " is not Consistent.");
                bDataConflict = true;
                continue;
            }
            element = this.parseElementFromCmd(neID, attrID, attrName, cmd);
            elementList.add(element);
        }
        TEDaoOperationResult result = TEWDMInfUtil.saveAttrInfoToDB(elementList, false);
        returnCode = result.getResult();
        if (bDataConflict) {
            return 1090615320;
        }
        return returnCode;
    }

    protected boolean isConsistentWithNM(int neID, int attrID, String attrName, TEScriptCmd cmd) {
        List list;
        TEGenAttrObjectValue value = this.getGenAttrValue(neID, attrName, cmd);
        if (value == null) {
            return false;
        }
        ArrayList paraValueList = new ArrayList();
        cmd.getPara(PARAM_VALUE, paraValueList, false);
        String valueStr = "";
        if (paraValueList.size() >= 1) {
            valueStr = (String)paraValueList.get(0);
        }
        if ((list = value.getAttrIDList()).size() >= 1) {
            TEGenValue genvalue = (TEGenValue)list.get(0);
            return genvalue.getValue().equals(valueStr);
        }
        return false;
    }

    protected TEGenAttrObjectValue getGenAttrValue(int neID, String attrName, TEScriptCmd cmd) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null == ne) {
            return null;
        }
        TEGenCfgFunCmd funCmd = TEPlanninDataHander.getFunCmd(ne);
        if (funCmd == null) {
            return null;
        }
        TEGenObjectID genObjID = this.getGenObjIDFromCmd(neID, cmd);
        int slotId = genObjID.getSlotIDInInt();
        int portId = genObjID.getPortIDInInt();
        int pathId = this.getPath(genObjID);
        TEGenCfgPortAttribute portAttr = new TEGenCfgPortAttribute();
        portAttr.setPort(portId);
        portAttr.setPath(pathId);
        TEGenAttrObjectValue value = TEWDMInfScriptHandler.constructAttrValue(neID, slotId, funCmd, attrName, portAttr);
        return value;
    }

    protected int getPath(TEGenObjectID genObjID) {
        return genObjID.getPathIDInInt();
    }

    protected boolean isOldData(int neID, int attrID, String attrName, TEScriptCmd cmd) {
        String objTypeStr = TEWDMInfStaticData.getAttrNameObjTypeNameMap().get(attrName);
        String newAttrName = TEWDMInfStaticData.getOmnipotentAttr(objTypeStr);
        TEGenAttrObjectValue value = this.getGenAttrValue(neID, newAttrName, cmd);
        List list = value.getAttrIDList();
        if (list.size() >= 1) {
            TEGenValue genvalue = (TEGenValue)list.get(0);
            return genvalue.getValue().equals("1");
        }
        return false;
    }

    private TEGenObjectID getGenObjIDFromCmd(int neID, TEScriptCmd cmd) {
        int[] tmpID = this.parseObjTypeID(neID, cmd);
        TEGenObjectID objID = new TEGenObjectID(tmpID);
        return objID;
    }

    protected TEGnlValueElement parseElementFromCmd(int neID, int attrID, String attrName, TEScriptCmd cmd) {
        TEGnlValueElement element = new TEGnlValueElement();
        TEGeneralKeyValue key = this.constructElementKey(neID, attrID, cmd);
        TEGeneralValue value = this.constructElementValue(attrID, cmd);
        element.setGnlKeyValue(key);
        element.setGnlValue(value);
        return element;
    }

    private TEGeneralKeyValue constructElementKey(int neID, int attrID, TEScriptCmd cmd) {
        TEGeneralKeyValue key = new TEGeneralKeyValue();
        key.setAttrID(attrID);
        key.setTEOBJECTID(this.parseObjTypeID(neID, cmd));
        return key;
    }

    private TEGeneralValue constructElementValue(int attrID, TEScriptCmd cmd) {
        TEGeneralValue value = new TEGeneralValue();
        int valueType = TEGnlAttrMgr.getInstance().getAttrValueType(attrID);
        ArrayList paraValueList = new ArrayList();
        cmd.getPara(PARAM_VALUE, paraValueList, false);
        String valueStr = "-1";
        if (paraValueList.size() >= 1) {
            valueStr = (String)paraValueList.get(0);
        }
        if (0 == valueType) {
            value.setiValue(Integer.parseInt(valueStr));
        } else {
            value.setsValue(valueStr);
        }
        return value;
    }

    protected int[] parseObjTypeID(int neID, TEScriptCmd cmd) {
        int slotID = -1;
        int portID = -1;
        int pathID = -1;
        ArrayList paraValueList = new ArrayList();
        paraValueList.clear();
        boolean isParamExist = cmd.getPara(PARAM_BOARD, paraValueList, false);
        if (isParamExist) {
            String board = (String)paraValueList.get(0);
            slotID = Integer.parseInt(board.split("-")[0]);
        }
        paraValueList.clear();
        isParamExist = cmd.getPara(PARAM_PORT, paraValueList, false);
        if (isParamExist) {
            portID = Integer.parseInt((String)paraValueList.get(0));
        }
        paraValueList.clear();
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID);
        if (TEOTNModelDataMgr.getInstance().isSupportSimpleModePort(boardType, portID)) {
            isParamExist = cmd.getPara(PARAM_PATH_STR, paraValueList, false);
            if (isParamExist) {
                String showPath = (String)paraValueList.get(0);
                int nmpath = TEOTNModelShowPathMgr.getInstance().getPathFromOTNModelShowPath(showPath);
                if (nmpath == -1) {
                    logger.info(cmd.toString() + " Can not convert simple OTN Mode pathstr to path!");
                }
                pathID = TEPlanninDataHander.getNePath(neID, slotID, nmpath);
            }
        } else {
            isParamExist = cmd.getPara(PARAM_PATH, paraValueList, false);
            if (isParamExist) {
                pathID = Integer.parseInt((String)paraValueList.get(0));
            }
        }
        TIntArrayList objIDList = new TIntArrayList();
        objIDList.add(this.getObjTypeID());
        objIDList.add(neID);
        if (-1 != slotID) {
            objIDList.add(slotID);
        }
        if (-1 != portID) {
            portID = TEQueryPortForDataMgr.getAbstractPortID((int)neID, (int)portID);
            objIDList.add(portID);
        }
        if (-1 != pathID) {
            objIDList.add(pathID);
        }
        int[] tEOBJECTID = objIDList.toNativeArray();
        return tEOBJECTID;
    }

    public int doExport(int neID, int item) {
        logger.info("TEWDMInfScriptHandler export script begin.");
        if (!TENEListMgr.getInstance().isAddedNE(neID)) {
            return 0;
        }
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null == ne) {
            return 1090596385;
        }
        logger.debug("TEWDMInfScriptHandler export script after getNE.");
        int slotID = -1;
        int boardType = -1;
        TEGenAttrObjectValue attrValue = null;
        TIntObjectHashMap portAttrMap = null;
        Vector boardList = TEPlanningDataJniMethod.getBoardList(neID);
        logger.debug("TEWDMInfScriptHandler export script after getBoardList.");
        TEGenCfgFunCmd funCmd = TEPlanninDataHander.getFunCmd(ne);
        logger.debug("TEWDMInfScriptHandler export script after getFunCmd.");
        if (funCmd == null) {
            return 0;
        }
        List<TEGenCfgPortAttribute> attributeList = null;
        ArrayList<TEGenAttrObjectValue> attrValueList = new ArrayList<TEGenAttrObjectValue>();
        for (TEBoard board : boardList) {
            slotID = board.getSlotID();
            boardType = board.getBoardType();
            String attrName = this.getAttrName();
            portAttrMap = TEGenCfgDataMgr.getPortAttrMap((int)neID, (String)attrName, (int)boardType);
            logger.debug("TEWDMInfScriptHandler export script after getPortAttrMap(" + neID + "," + attrName + "," + boardType + ")");
            attributeList = TEPlanninDataHander.constructAttributeList((TIntObjectHashMap<List<TEGenCfgPortAttribute>>)portAttrMap);
            Set<Integer> logicPortIDSet = TEWDMInfScriptHandler.getLogicPortIDList(neID, slotID, boardType);
            logger.debug("TEWDMInfScriptHandler export script after getLogicPortIDList(" + neID + "," + slotID + "," + boardType + ")");
            for (TEGenCfgPortAttribute attribute : attributeList) {
                if (!logicPortIDSet.contains(attribute.getPort())) continue;
                attrValue = TEWDMInfScriptHandler.constructAttrValue(neID, slotID, funCmd, attrName, attribute);
                attrValueList.add(attrValue);
            }
            logger.debug("TEWDMInfScriptHandler export script after attributeList loop");
        }
        int result = this.writeExportDataToScript(attrValueList, neID, item);
        logger.info("Set planning data to ne end.");
        return result;
    }

    public static Set<Integer> getLogicPortIDList(int neID, int slotID, int boardType) {
        List logicPortList = TEConfigurationDataMgr.getInstance().getPortListOnInter(neID, slotID, boardType);
        HashSet<Integer> logicPortIDSet = new HashSet<Integer>(logicPortList.size());
        for (TEPort port : logicPortList) {
            logicPortIDSet.add(port.getPortNo());
        }
        return logicPortIDSet;
    }

    protected int writeComment(int neID, int item) {
        return TEScriptOperationMgr.getInstance().writeComment(neID, item, "// WDM Interface Attribute");
    }

    private int writeExportDataToScript(List<TEGenAttrObjectValue> attrValueList, int neID, int item) {
        int result = 0;
        TEScriptCmd cmd = null;
        int index = 0;
        for (TEGenAttrObjectValue attrObjectValue : attrValueList) {
            cmd = this.constractScriptCmd(item, attrObjectValue);
            if (null == cmd) continue;
            cmd.setCmdCode(item);
            if (index++ == 0) {
                result = this.writeComment(neID, item);
            }
            if (0 == (result = TEScriptOperationMgr.getInstance().writeCommand(neID, item, cmd))) continue;
            break;
        }
        return result;
    }

    protected abstract TEScriptCmd constractScriptCmd(int var1, TEGenAttrObjectValue var2);

    public static TEGenAttrObjectValue constructAttrValue(int neID, int slotID, TEGenCfgFunCmd funCmd, String attrName, TEGenCfgPortAttribute attribute) {
        int portID = attribute.getPort();
        int pathID = attribute.getPath();
        pathID = TEPlanninDataHander.getNmPath(neID, slotID, portID, pathID, funCmd, attrName);
        String objTypeStr = TEWDMInfUtil.getObjTypeByAttr(funCmd, attrName);
        TEPartSource partSource = TEPlanninDataHander.constructPartSource(slotID, portID, pathID);
        int intObjectID = TEWDMInfStaticData.getObjTypeNameIDMap().get(objTypeStr);
        TEGenObjectID objectID = new TEGenObjectID(TEObjTypeIDCreator.getInstance().createObjectID(neID, intObjectID, partSource));
        TEGenAttrObjectValue attrValue = new TEGenAttrObjectValue();
        attrValue.setObjectID(objectID);
        int attrID = TEWDMInfUtil.getAttrID(attrName, neID);
        partSource = TEPlanninDataHander.constructPartSource(slotID, portID, attribute.getPath());
        String value = TEWDMInfScriptHandler.getAttrValueFromDB(neID, attrName, objTypeStr, partSource, attrID);
        TEGenValue genValue = new TEGenValue();
        genValue.setAttrID(attrID);
        genValue.setAttrName(attrName);
        genValue.setValue(value);
        ArrayList<TEGenValue> attrIDList = new ArrayList<TEGenValue>();
        attrIDList.add(genValue);
        attrValue.setAttrIDList(attrIDList);
        attrValue.setMitLockType((byte)0);
        return attrValue;
    }

    private static String getAttrValueFromDB(int neID, String attrName, String objTypeStr, TEPartSource partSource, int attrID) {
        TEGeneralKeyValue key = new TEGeneralKeyValue();
        key.setAttrID(attrID);
        int intObjectID = TEObjTypeIDCreator.getInstance().getObjTypeID(neID, attrName, objTypeStr, partSource);
        key.setTEOBJECTID(TEObjTypeIDCreator.getInstance().createObjectID(neID, intObjectID, partSource));
        String value = TEWDMInfUtil.getAttrValueFromDB_NoLock(key);
        return value;
    }

    static {
        needOperItemID.add(720927);
        needOperItemID.add(720940);
        needOperItemID.add(720926);
    }
}

