/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.wdminterface.script;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.script.TEScriptCmd;
import com.huawei.nglct.cbb.script.TEScriptHandler;
import com.huawei.nglct.cbb.script.TEScriptOperationMgr;
import com.huawei.nglct.db.jni.dbservice.TEGeneralKeyValue;
import com.huawei.nglct.gencfg.TEGenCfgFunCmd;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenAttrObjectValue;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenObjectID;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenValue;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.TEWDMInfStaticData;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.TEWDMInfUtil;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.objtypeid.TEObjTypeIDCreator;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.objtypeid.TEPartSource;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.planningdata.TEPlanninDataHander;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.planningdata.TEPlanningDataJniMethod;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.script.TEWDMInfScriptHandler;
import com.huawei.nglct.ngwdm_pub.TEOTNModelDataMgr;
import com.huawei.nglct.ngwdm_pub.TEOTNModelShowPathMgr;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.slf4j.Logger;

public class TEWDMInfMultiAttrScriptHandler
implements TEScriptHandler {
    protected static final Logger logger = TELogFactory.getNormalLogger();
    protected HashMap<String, String> exportKey = null;
    protected ArrayList convertAttrList = null;
    protected ArrayList<String> filterCode = null;
    protected ArrayList<String> needQuoteAttrs = null;
    protected int neid = -1;

    protected void initExportKey() {
        this.exportKey = new HashMap();
    }

    protected void initFilterCode() {
        this.filterCode = new ArrayList();
    }

    protected void initNeedQuoteAttr() {
        this.needQuoteAttrs = new ArrayList();
    }

    protected void initConvertAttr() {
        this.convertAttrList = new ArrayList();
    }

    public int doImport(int neID, int item, List<TEScriptCmd> contents) {
        this.neid = neID;
        return 0;
    }

    protected List<String> getAttrName() {
        ArrayList<String> attrNameList = new ArrayList<String>();
        return attrNameList;
    }

    public int doExport(int neID, int item) {
        logger.info("Marine export cable to script begin.");
        this.neid = neID;
        this.initExportKey();
        this.initFilterCode();
        this.initConvertAttr();
        this.initNeedQuoteAttr();
        if (!TENEListMgr.getInstance().isAddedNE(neID)) {
            return 0;
        }
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null == ne) {
            return 1090596385;
        }
        int slotID = -1;
        int boardType = -1;
        TEGenAttrObjectValue attrValue = null;
        TIntObjectHashMap portAttrMap = null;
        Vector boardList = TEPlanningDataJniMethod.getBoardList(neID);
        TEGenCfgFunCmd funCmd = TEPlanninDataHander.getFunCmd(ne);
        if (funCmd == null) {
            return 0;
        }
        List<TEGenCfgPortAttribute> attributeList = null;
        ArrayList<TEGenAttrObjectValue> attrValueList = null;
        HashMap<String, List<TEGenAttrObjectValue>> attrValueMap = new HashMap<String, List<TEGenAttrObjectValue>>();
        for (TEBoard board : boardList) {
            slotID = board.getSlotID();
            boardType = board.getBoardType();
            List<String> attrNameList = this.getAttrName();
            for (String attrName : attrNameList) {
                if (!this.isSupportExport(board, attrName)) continue;
                portAttrMap = TEGenCfgDataMgr.getPortAttrMap((int)neID, (String)attrName, (int)boardType);
                attributeList = TEPlanninDataHander.constructAttributeList((TIntObjectHashMap<List<TEGenCfgPortAttribute>>)portAttrMap);
                Set<Integer> logicPortIDSet = TEWDMInfScriptHandler.getLogicPortIDList(neID, slotID, boardType);
                for (TEGenCfgPortAttribute attribute : attributeList) {
                    if (!logicPortIDSet.contains(attribute.getPort())) continue;
                    attrValue = TEWDMInfMultiAttrScriptHandler.constructAttrValue(neID, slotID, funCmd, attrName, attribute);
                    int portID = attribute.getPort();
                    int pathID = attribute.getPath();
                    StringBuffer keyValueSB = new StringBuffer();
                    keyValueSB.append(neID).append("-");
                    keyValueSB.append(slotID).append("-");
                    keyValueSB.append(portID).append("-");
                    keyValueSB.append(pathID);
                    String keyValue = keyValueSB.toString();
                    List<TEGenAttrObjectValue> tmpKeyList = attrValueMap.get(keyValue);
                    if (null != tmpKeyList) {
                        tmpKeyList.add(attrValue);
                        continue;
                    }
                    attrValueList = new ArrayList<TEGenAttrObjectValue>();
                    attrValueList.add(attrValue);
                    attrValueMap.put(keyValue, attrValueList);
                }
            }
        }
        this.addDataToMap(neID, item, attrValueMap);
        int result = this.writeExportDataToScript(attrValueMap, neID, item);
        logger.info("Set planning data to ne end.");
        return result;
    }

    protected boolean isSupportExport(TEBoard board, String attrName) {
        return true;
    }

    protected void addDataToMap(int neID, int item, HashMap<String, List<TEGenAttrObjectValue>> attrMap) {
    }

    protected int writeExportDataToScript(HashMap<String, List<TEGenAttrObjectValue>> attrValueMap, int neID, int item) {
        int result = 0;
        TEScriptCmd cmd = null;
        Iterator<Map.Entry<String, List<TEGenAttrObjectValue>>> it = attrValueMap.entrySet().iterator();
        while (it.hasNext()) {
            cmd = new TEScriptCmd();
            cmd.setCmdCode(item);
            List<TEGenAttrObjectValue> attrValueList = it.next().getValue();
            if (attrValueList.isEmpty()) continue;
            this.constractScriptCmd(cmd, attrValueList);
            if (cmd.getSize() == 0 || 0 == (result = TEScriptOperationMgr.getInstance().writeCommand(neID, item, cmd))) continue;
            break;
        }
        return result;
    }

    protected void addSubborad(TEScriptCmd cmd) {
    }

    protected ArrayList<String> getFilterCode(int boardType) {
        return this.filterCode;
    }

    protected void constractScriptCmd(TEScriptCmd cmd, List<TEGenAttrObjectValue> attrValueList) {
        String attrName;
        TEGenValue genValue;
        TEGenObjectID objID = attrValueList.get(0).getObjectID();
        int slotID = objID.getSlotIDInInt();
        int portID = objID.getPortIDInInt();
        int pathID = objID.getPathIDInInt();
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotID);
        int nullCount = 0;
        for (TEGenAttrObjectValue attrValue : attrValueList) {
            genValue = (TEGenValue)attrValue.getAttrIDList().get(0);
            attrName = genValue.getAttrName();
            String valueStr = genValue.getValue();
            if (null != valueStr && !valueStr.isEmpty() && !this.getFilterCode(boardType).contains(attrName + "-" + valueStr)) continue;
            ++nullCount;
        }
        if (attrValueList.size() == nullCount) {
            return;
        }
        cmd.addPara("board", slotID, false, false);
        this.addSubborad(cmd);
        cmd.addPara("port", portID, false, false);
        if (this.isPrintPath()) {
            if (TEOTNModelDataMgr.getInstance().isSupportSimpleModePort(boardType, portID)) {
                String pathstr = TEOTNModelShowPathMgr.getInstance().getOTNModelShowPath(pathID);
                cmd.addPara("pathstr", pathstr, true, true);
            } else {
                cmd.addPara("path", pathID, false, false);
            }
        }
        for (TEGenAttrObjectValue attrValue : attrValueList) {
            genValue = (TEGenValue)attrValue.getAttrIDList().get(0);
            attrName = genValue.getAttrName();
            String value = genValue.getValue();
            if (this.getFilterCode(boardType).contains(attrName + "-" + value)) continue;
            if (this.isNeedConvertAttr(attrName)) {
                value = this.convertAttrValue(attrName, value);
            }
            boolean needQuote = false;
            if (this.needQuoteAttrs.contains(attrName)) {
                needQuote = true;
            }
            cmd.addPara(this.exportKey.get(attrName), value, needQuote, false);
        }
    }

    protected boolean isPrintPath() {
        return true;
    }

    protected String convertAttrValue(String attrName, String attrValue) {
        return attrValue;
    }

    protected boolean isNeedConvertAttr(String attrName) {
        boolean flag = false;
        if (this.convertAttrList.contains(attrName)) {
            flag = true;
        }
        return flag;
    }

    public static TEGenAttrObjectValue constructAttrValue(int neID, int slotID, TEGenCfgFunCmd funCmd, String attrName, TEGenCfgPortAttribute attribute) {
        int portID = attribute.getPort();
        int pathID = attribute.getPath();
        pathID = TEPlanninDataHander.getNmPath(neID, slotID, portID, pathID, funCmd, attrName);
        String objTypeStr = TEWDMInfUtil.getObjTypeByAttr(funCmd, attrName);
        TEPartSource partSource = TEPlanninDataHander.constructPartSource(slotID, portID, pathID);
        int intObjectID = TEWDMInfStaticData.getObjTypeNameIDMap().get(objTypeStr);
        TEGenObjectID objectID = new TEGenObjectID(TEObjTypeIDCreator.getInstance().createObjectID(neID, intObjectID, partSource));
        TEGenAttrObjectValue attrValue = new TEGenAttrObjectValue();
        attrValue.setObjectID(objectID);
        int attrID = TEWDMInfUtil.getAttrID(attrName, neID);
        partSource = TEPlanninDataHander.constructPartSource(slotID, portID, attribute.getPath());
        String value = TEWDMInfMultiAttrScriptHandler.getAttrValueFromDB(neID, attrName, objTypeStr, partSource, attrID);
        TEGenValue teGgenValue = new TEGenValue();
        teGgenValue.setAttrID(attrID);
        teGgenValue.setAttrName(attrName);
        teGgenValue.setValue(value);
        ArrayList<TEGenValue> attrIDList = new ArrayList<TEGenValue>();
        attrIDList.add(teGgenValue);
        attrValue.setAttrIDList(attrIDList);
        attrValue.setMitLockType((byte)0);
        return attrValue;
    }

    protected static String getAttrValueFromDB(int neID, String attrName, String objTypeStr, TEPartSource partSrc, int attrID) {
        TEGeneralKeyValue genKkey = new TEGeneralKeyValue();
        genKkey.setAttrID(attrID);
        int intObjectID = TEObjTypeIDCreator.getInstance().getObjTypeID(neID, attrName, objTypeStr, partSrc);
        genKkey.setTEOBJECTID(TEObjTypeIDCreator.getInstance().createObjectID(neID, intObjectID, partSrc));
        String value = TEWDMInfUtil.getAttrValueFromDB_NoLock(genKkey);
        return value;
    }
}

