/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.wdminterface.script;

import com.huawei.nglct.cbb.script.TEScriptCmd;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenAttrObjectValue;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenObjectID;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenValue;
import com.huawei.nglct.nemgr.ngwdm.tdc.db.TETDCDbMgr;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.planningdata.TEPlanninDataHander;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.script.TEWDMInfMultiAttrScriptHandler;
import com.huawei.nglct.ngwdm_pub.TEOTNModelDataMgr;
import com.huawei.nglct.po.embeddednemgrmo.otn.TETDCMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TETDCScriptHandler
extends TEWDMInfMultiAttrScriptHandler {
    private String[] isAble = new String[]{"disable", "enable"};
    private String[] bandArr = new String[]{"c+lband", "cband", "lband", "cband(320G)", "cband(raman)", "lband(raman)", "cwdmband", "smcband", "cband(96a)", "cband(plus)", "cband(192)"};

    @Override
    protected void initExportKey() {
        this.exportKey = new HashMap();
        this.exportKey.put("isable", "adjustenable");
        this.exportKey.put("cdvalue", "tdcvalue");
        this.exportKey.put("W32PORT_ATTR_RECWAVETYPE", "recband");
        this.exportKey.put("W32PORT_ATTR_RECWAVELEN", "recwave");
    }

    @Override
    protected void initFilterCode() {
        this.filterCode = new ArrayList();
        this.filterCode.add("isable--1");
        this.filterCode.add("cdvalue-2147483647");
        this.filterCode.add("W32PORT_ATTR_RECWAVETYPE-255");
        this.filterCode.add("W32PORT_ATTR_RECWAVELEN-65536");
    }

    @Override
    protected void initConvertAttr() {
        this.convertAttrList = new ArrayList();
        this.convertAttrList.add("isable");
        this.convertAttrList.add("W32PORT_ATTR_RECWAVETYPE");
        this.convertAttrList.add("W32PORT_ATTR_RECWAVELEN");
    }

    @Override
    protected void initNeedQuoteAttr() {
        this.needQuoteAttrs = new ArrayList();
        this.needQuoteAttrs.add("W32PORT_ATTR_RECWAVETYPE");
    }

    @Override
    protected List<String> getAttrName() {
        ArrayList<String> attrNameList = new ArrayList<String>();
        attrNameList.add("W32PORT_ATTR_RECWAVETYPE");
        attrNameList.add("W32PORT_ATTR_RECWAVELEN");
        return attrNameList;
    }

    @Override
    protected void addDataToMap(int neID, int item, HashMap<String, List<TEGenAttrObjectValue>> attrMap) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        List<TETDCMOPO> tdcMOList = TETDCDbMgr.getTDCMOFromDB(neID, errRet);
        for (TETDCMOPO tdcmo : tdcMOList) {
            StringBuffer keyValueSB = new StringBuffer();
            keyValueSB.append(neID).append("-");
            keyValueSB.append(tdcmo.getSlotID()).append("-");
            keyValueSB.append(tdcmo.getPortID()).append("-");
            keyValueSB.append(tdcmo.getPathID());
            String keyValue = keyValueSB.toString();
            TEGenAttrObjectValue adjustenableValue = new TEGenAttrObjectValue();
            ArrayList<TEGenValue> attrIDList = new ArrayList<TEGenValue>();
            TEGenValue teGgenValue = new TEGenValue();
            teGgenValue.setAttrName("isable");
            teGgenValue.setValue(tdcmo.getAdjustenable() + "");
            attrIDList.add(teGgenValue);
            adjustenableValue.setAttrIDList(attrIDList);
            TEGenAttrObjectValue tdcvalueValue = new TEGenAttrObjectValue();
            attrIDList = new ArrayList();
            teGgenValue = new TEGenValue();
            teGgenValue.setAttrName("cdvalue");
            teGgenValue.setValue(tdcmo.getTdcvalue() + "");
            attrIDList.add(teGgenValue);
            tdcvalueValue.setAttrIDList(attrIDList);
            TEGenObjectID objid = new TEGenObjectID(neID, tdcmo.getSlotID(), tdcmo.getPortID(), tdcmo.getPathID());
            adjustenableValue.setObjectID(objid);
            tdcvalueValue.setObjectID(objid);
            List<TEGenAttrObjectValue> tmpKeyList = attrMap.get(keyValue);
            if (null != tmpKeyList) {
                tmpKeyList.add(0, tdcvalueValue);
                tmpKeyList.add(0, adjustenableValue);
                continue;
            }
            tmpKeyList = new ArrayList<TEGenAttrObjectValue>();
            tmpKeyList.add(adjustenableValue);
            tmpKeyList.add(tdcvalueValue);
            attrMap.put(keyValue, tmpKeyList);
        }
    }

    @Override
    protected void constractScriptCmd(TEScriptCmd cmd, List<TEGenAttrObjectValue> attrValueList) {
        String attrName;
        TEGenObjectID objID = attrValueList.get(0).getObjectID();
        int neID = objID.getNEID();
        int slotID = objID.getSlotIDInInt();
        int portID = objID.getPortIDInInt();
        int pathID = objID.getPathIDInInt();
        int nullCount = 0;
        for (TEGenAttrObjectValue attrValue : attrValueList) {
            TEGenValue genValue = (TEGenValue)attrValue.getAttrIDList().get(0);
            attrName = genValue.getAttrName();
            String valueStr = genValue.getValue();
            if (null != valueStr && !valueStr.isEmpty() && !this.filterCode.contains(attrName + "-" + valueStr)) continue;
            ++nullCount;
        }
        if (attrValueList.size() == nullCount) {
            return;
        }
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null == ne) {
            return;
        }
        TEBoard board = ne.getBoard(slotID);
        if (null == board) {
            return;
        }
        cmd.addPara("board", slotID, false, false);
        this.addSubborad(cmd);
        cmd.addPara("port", portID, false, false);
        int nePathID = pathID;
        if (TEPlanninDataHander.isNewOtnModeBoard(neID, slotID)) {
            attrName = ((TEGenValue)attrValueList.get(0).getAttrIDList().get(0)).getAttrName();
            nePathID = TEOTNModelDataMgr.getInstance().getAttrNePath(portID, pathID, board.getBoardType(), attrName);
        }
        if (nePathID == -1) {
            cmd.addPara("path", 1, false, false);
        } else {
            cmd.addPara("path", nePathID, false, false);
        }
        for (TEGenAttrObjectValue attrValue : attrValueList) {
            TEGenValue genValue = (TEGenValue)attrValue.getAttrIDList().get(0);
            String attrName2 = genValue.getAttrName();
            String value = genValue.getValue();
            if (this.filterCode.contains(attrName2 + "-" + value)) continue;
            if (this.isNeedConvertAttr(attrName2)) {
                value = this.convertAttrValue(attrName2, value);
            }
            boolean needQuote = false;
            if (this.needQuoteAttrs.contains(attrName2)) {
                needQuote = true;
            }
            cmd.addPara((String)this.exportKey.get(attrName2), value, needQuote, false);
        }
    }

    private String convertWave(int maxWaveNum) {
        int i = maxWaveNum % 65536;
        return String.valueOf(i);
    }

    @Override
    protected String convertAttrValue(String attrName, String attrValue) {
        int tmpvar = Integer.parseInt(attrValue);
        String tmpValue = attrValue;
        if (attrName.equals("isable")) {
            tmpValue = this.isAble[tmpvar];
        } else if (attrName.equals("W32PORT_ATTR_RECWAVETYPE")) {
            tmpValue = this.convertBandValue(tmpvar);
        } else if (attrName.equals("W32PORT_ATTR_RECWAVELEN")) {
            tmpValue = this.convertWave(tmpvar);
        }
        return tmpValue;
    }

    private String convertBandValue(int band) {
        String tmpBand = "";
        tmpBand = this.bandArr[band];
        return tmpBand;
    }
}

