/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.wdminterface.script;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.script.TEScriptCmd;
import com.huawei.nglct.cbb.script.TEScriptHandler;
import com.huawei.nglct.cbb.script.TEScriptOperationMgr;
import com.huawei.nglct.db.jni.dbservice.TEGeneralKeyValue;
import com.huawei.nglct.gencfg.TEGenCfgFunCmd;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEQueryPortForDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenAttrObjectValue;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenValue;
import com.huawei.nglct.nemgr.ngwdm.exc.TETsPathDBMgr;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.TEWDMInfUtil;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.planningdata.TEPlanninDataHander;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.planningdata.TEPlanningDataJniMethod;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.script.TEPayloadBean;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.script.TEWDMInfScriptHandler;
import com.huawei.nglct.po.embeddednemgrmo.otn.TETsPathMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.nglct.util.string.TEStringUtils;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class TEPayloadScriptHandler
implements TEScriptHandler {
    public static final int W32BRD_ATTR_PORTMAPPING = 10001011;
    public static final int DIRECTION_ALL = 0;
    public static final int DIRECTION_UP = 1;
    public static final int DIRECTION_DOWN = 2;
    String[] TSMODE = new String[]{"", "auto", "manual"};
    String[] DIRECTION = new String[]{"all", "up", "down"};

    public int doImport(int neID, int item, List<TEScriptCmd> contents) {
        return 0;
    }

    private String getPostionStr(List<Integer> list) {
        StringBuilder sb = new StringBuilder();
        for (int i : list) {
            sb.append(i).append("&");
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    public int doExport(int neID, int item) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        int result = 0;
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (ne == null) {
            String tips = "TEPayloadScriptHandler NE is Not Exist!";
            tips = tips + String.format("[neID:%d]", neID);
            TELogFactory.getE2ELogger().info(tips);
            return result;
        }
        TEGenCfgFunCmd funCmd = TEPlanninDataHander.getFunCmd(ne);
        if (funCmd == null) {
            return 0;
        }
        Set<TEPayloadBean> payLoadSet = this.getPayloadSet(neID, errRet);
        this.addPortroute(neID, funCmd, payLoadSet);
        for (TEPayloadBean payload : payLoadSet) {
            ArrayList<Integer> upList = new ArrayList<Integer>();
            ArrayList<Integer> downList = new ArrayList<Integer>();
            if (payload.getPosition1() != null && !payload.getPosition1().isEmpty()) {
                TEStringUtils.str2Vec((String)payload.getPosition1(), upList);
            }
            if (payload.getPosition2() != null && !payload.getPosition2().isEmpty()) {
                TEStringUtils.str2Vec((String)payload.getPosition2(), downList);
            }
            boolean isLogged = false;
            if (payload.getTsmode() == 2) {
                TEScriptCmd cmd1 = new TEScriptCmd();
                cmd1.setCmdCode(item);
                cmd1.addPara("board", String.valueOf(payload.getSlotID()), false, false);
                cmd1.addPara("subbd", "255", false, false);
                cmd1.addPara("port", String.valueOf(payload.getPortID()), false, false);
                cmd1.addPara("pathid", String.valueOf(payload.getPathID()), false, false);
                cmd1.addPara("tsmode", this.TSMODE[payload.getTsmode()], false, false);
                if (payload.getPortroute() != -1) {
                    cmd1.addPara("portroute", String.valueOf(payload.getPortroute()), false, false);
                }
                cmd1.addPara("direction", this.DIRECTION[1], false, false);
                if (!upList.isEmpty()) {
                    cmd1.addPara("number", upList.size(), false, false);
                    cmd1.addPara("position", this.getPostionStr(upList), false, false);
                } else {
                    cmd1.addPara("number", "0", false, false);
                    cmd1.addPara("position", "0", false, false);
                }
                result = TEScriptOperationMgr.getInstance().writeCommand(neID, item, cmd1);
                isLogged = true;
                if (0 != result) break;
            }
            if (payload.getTsmode() == 2) {
                TEScriptCmd cmd2 = new TEScriptCmd();
                cmd2.setCmdCode(item);
                cmd2.addPara("board", String.valueOf(payload.getSlotID()), false, false);
                cmd2.addPara("subbd", "255", false, false);
                cmd2.addPara("port", String.valueOf(payload.getPortID()), false, false);
                cmd2.addPara("pathid", String.valueOf(payload.getPathID()), false, false);
                cmd2.addPara("tsmode", this.TSMODE[payload.getTsmode()], false, false);
                if (payload.getPortroute() != -1) {
                    cmd2.addPara("portroute", String.valueOf(payload.getPortroute()), false, false);
                }
                cmd2.addPara("direction", this.DIRECTION[2], false, false);
                if (!downList.isEmpty()) {
                    cmd2.addPara("number", downList.size(), false, false);
                    cmd2.addPara("position", this.getPostionStr(downList), false, false);
                } else {
                    cmd2.addPara("number", "0", false, false);
                    cmd2.addPara("position", "0", false, false);
                }
                result = TEScriptOperationMgr.getInstance().writeCommand(neID, item, cmd2);
                isLogged = true;
                if (0 != result) break;
            }
            if (isLogged || payload.getPortroute() == -1) continue;
            TEScriptCmd cmd3 = new TEScriptCmd();
            cmd3.setCmdCode(item);
            cmd3.addPara("board", String.valueOf(payload.getSlotID()), false, false);
            cmd3.addPara("subbd", "255", false, false);
            cmd3.addPara("port", String.valueOf(payload.getPortID()), false, false);
            cmd3.addPara("pathid", String.valueOf(payload.getPathID()), false, false);
            cmd3.addPara("portroute", String.valueOf(payload.getPortroute()), false, false);
            result = TEScriptOperationMgr.getInstance().writeCommand(neID, item, cmd3);
            if (0 == result) continue;
            break;
        }
        return 0;
    }

    private Set<TEPayloadBean> getPayloadSet(int neID, TEErrInfoReturn errRet) {
        HashSet<TEPayloadBean> payloadSet = new HashSet<TEPayloadBean>();
        List<TETsPathMOPO> tsPathList = TETsPathDBMgr.getTsPathFromDB(neID, errRet);
        for (TETsPathMOPO tsPath : tsPathList) {
            TEPayloadBean payload = new TEPayloadBean();
            payload.setSlotID(tsPath.getSlotID());
            payload.setSubCardID(tsPath.getSubCardID());
            payload.setPortID(tsPath.getPortID());
            payload.setPathID(tsPath.getPathID());
            payload.setTsmode(tsPath.getTsmode());
            payload.setPosition1(tsPath.getPosition1());
            payload.setPosition2(tsPath.getPosition2());
            payloadSet.add(payload);
        }
        return payloadSet;
    }

    private int getServiceType(int neid, TEGenCfgFunCmd funCmd, TEPayloadBean payload) {
        int servType = -1;
        TEGeneralKeyValue key = new TEGeneralKeyValue();
        key.setAttrID(271534);
        int portid = TEQueryPortForDataMgr.getAbstractPortID((int)neid, (int)payload.getPortID());
        int[] tEOBJECTID = new int[]{61509, neid, payload.getSlotID(), portid, 1};
        key.setTEOBJECTID(tEOBJECTID);
        String attrValue = TEWDMInfUtil.getAttrValueFromDB_NoLock(key);
        if (attrValue != null && !attrValue.isEmpty()) {
            servType = Integer.parseInt(attrValue);
        }
        return servType;
    }

    private void addPortroute(int neID, TEGenCfgFunCmd funCmd, Set<TEPayloadBean> payLoadSet) {
        String portmapping = "W32BRD_ATTR_PORTMAPPING";
        Vector bdList = TEPlanningDataJniMethod.getBoardList(neID);
        for (TEBoard board : bdList) {
            int slotid = board.getSlotID();
            int boardType = board.getBoardType();
            TEGenCfgModel genCfgModel = TEGenCfgDataMgr.getGenCfgMode((int)boardType);
            if (genCfgModel == null || genCfgModel.getAttrFromId(portmapping) == null) continue;
            TIntObjectHashMap portAttrMap = TEGenCfgDataMgr.getPortAttrMap((int)neID, (String)portmapping, (int)boardType);
            List<TEGenCfgPortAttribute> attributeList = TEPlanninDataHander.constructAttributeList((TIntObjectHashMap<List<TEGenCfgPortAttribute>>)portAttrMap);
            Set<Integer> logicPortIDSet = TEWDMInfScriptHandler.getLogicPortIDList(neID, slotid, boardType);
            for (TEGenCfgPortAttribute attribute : attributeList) {
                if (!logicPortIDSet.contains(attribute.getPort())) continue;
                TEGenAttrObjectValue attrValue = TEWDMInfScriptHandler.constructAttrValue(neID, slotid, funCmd, portmapping, attribute);
                TEPayloadBean tempKey = new TEPayloadBean();
                tempKey.setSlotID(attrValue.getObjectID().getSlotIDInInt());
                tempKey.setPortID(attrValue.getObjectID().getPortIDInInt());
                tempKey.setPathID(1);
                int servType = this.getServiceType(neID, funCmd, tempKey);
                int portRoute = Integer.parseInt(((TEGenValue)attrValue.getAttrIDList().get(0)).getValue());
                if (servType != 258 || portRoute == 0) continue;
                boolean isFound = false;
                for (TEPayloadBean payload : payLoadSet) {
                    if (!payload.equals((Object)tempKey)) continue;
                    payload.setPortroute(portRoute);
                    isFound = true;
                }
                if (isFound) continue;
                tempKey.setPortroute(portRoute);
                payLoadSet.add(tempKey);
            }
        }
    }
}

