/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.wdminterface.script;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.script.TEScriptCmd;
import com.huawei.nglct.cbb.script.TEScriptOperationMgr;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.db.jni.dbservice.TEGeneralKeyValue;
import com.huawei.nglct.db.jni.dbservice.TEGeneralValue;
import com.huawei.nglct.db.jni.dbservice.TEGnlValueElement;
import com.huawei.nglct.gencfg.TEGenCfgFunCmd;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPortBufferKey;
import com.huawei.nglct.nelist.model.TEQueryPortForDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenAttrObjectValue;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenObjectID;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenValue;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.TEWDMInfUtil;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.planningdata.TEPlanninDataHander;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.planningdata.TEPlanningDataJniMethod;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.script.TEWDMInfScriptHandler;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class TEDcmScriptHandler
extends TEWDMInfScriptHandler {
    public static String PARANAME_BOARD = "board";
    public static String PARANAME_SUBBOARD = "subbd";
    public static String PARANAME_PORT = "port";
    public static String PARANAME_DIRECTION = "dir";
    public static String PARANAME_DCMTYPE1 = "Dcmtype1";
    public static String PARANAME_DCMTYPE2 = "Dcmtype2";
    public static String PARANAME_DCMTYPE3 = "Dcmtype3";
    public static String PARANAME_DCMTYPE4 = "Dcmtype4";
    public static String DIRECTION_IN = "In";
    public static String DIRECTION_OUT = "Out";
    public static final int INVALID_VALUE = -1;
    public static final int UNKOWN_VALUE = 255;
    String[] dcmAttrs = new String[]{"W32PORT_ATTR_DCMVALUE_SND1", "W32PORT_ATTR_DCMVALUE_SND2", "W32PORT_ATTR_DCMVALUE_SND3", "W32PORT_ATTR_DCMVALUE_SND4", "W32PORT_ATTR_DCMVALUE_RCV1", "W32PORT_ATTR_DCMVALUE_RCV2", "W32PORT_ATTR_DCMVALUE_RCV3", "W32PORT_ATTR_DCMVALUE_RCV4"};
    int[] intdcmAttrs = new int[]{272488, 272489, 272490, 272491, 272492, 272493, 272494, 272495};
    public static Map<Integer, String> atrrsPara = new HashMap<Integer, String>();
    public static Map<String, String> dcmConverMap;

    @Override
    public int doImport(int neID, int item, List<TEScriptCmd> contents) {
        int result = 0;
        if (!TENEListMgr.getInstance().isAddedNE(neID)) {
            String tipStr = "TEDcmScriptHandler NE is Not Exist!";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            TELogFactory.getE2ELogger().info(tipStr);
            return result;
        }
        ArrayList<TEGnlValueElement> elementList = new ArrayList<TEGnlValueElement>();
        TEGnlValueElement element = null;
        ArrayList paraValueList = new ArrayList();
        boolean bDataConflict = false;
        boolean bOld = false;
        for (TEScriptCmd cmd : contents) {
            paraValueList.clear();
            if (!cmd.getPara(PARANAME_DIRECTION, paraValueList, false)) continue;
            int start = 0;
            int end = 4;
            if (((String)paraValueList.get(0)).equalsIgnoreCase(DIRECTION_IN)) {
                start = 0;
                end = 3;
            } else {
                start = 4;
                end = 7;
            }
            bOld = this.isOldData(neID, this.intdcmAttrs[start], this.dcmAttrs[start], cmd);
            if (bOld) {
                logger.info("attrID = " + this.intdcmAttrs[start] + "do not need Import. cmd ->" + cmd.toString());
            }
            for (int i = start; i <= end; ++i) {
                int attrID = this.intdcmAttrs[i];
                String attrName = this.dcmAttrs[i];
                if (bOld) {
                    if (this.isConsistentWithNM(neID, attrID, attrName, cmd)) continue;
                    logger.info(attrID + ">> cmd = " + cmd.toString() + " is not Consistent.");
                    bDataConflict = true;
                    continue;
                }
                element = this.parseElementFromCmd(neID, attrID, attrName, cmd);
                elementList.add(element);
            }
        }
        TEDaoOperationResult operResult = TEWDMInfUtil.saveAttrInfoToDB(elementList, false);
        result = operResult.getResult();
        if (bDataConflict) {
            return 1090615320;
        }
        return result;
    }

    @Override
    protected boolean isConsistentWithNM(int neID, int attrID, String attrName, TEScriptCmd cmd) {
        List list;
        TEGenAttrObjectValue value = this.getGenAttrValue(neID, attrName, cmd);
        if (value == null) {
            return false;
        }
        ArrayList paraValueList = new ArrayList();
        cmd.getPara(atrrsPara.get(attrID), paraValueList, false);
        String valueStr = "";
        if (paraValueList.size() >= 1) {
            valueStr = this.getDcmAttrValue((String)paraValueList.get(0));
        }
        if ((list = value.getAttrIDList()).size() >= 1) {
            TEGenValue genvalue = (TEGenValue)list.get(0);
            return genvalue.getValue().equals(valueStr);
        }
        return false;
    }

    @Override
    protected int getPath(TEGenObjectID genObjID) {
        return 1;
    }

    @Override
    public int doExport(int neID, int item) {
        int result = 0;
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (ne == null) {
            String tipStr = "TEDcmScriptHandler NE is Not Exist!";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            TELogFactory.getE2ELogger().info(tipStr);
            return result;
        }
        Vector bdList = TEPlanningDataJniMethod.getBoardList(neID);
        HashMap<TEPortBufferKey, List<String>> dcmMap = new HashMap<TEPortBufferKey, List<String>>();
        for (TEBoard board : bdList) {
            int slotid = board.getSlotID();
            int boardType = board.getBoardType();
            TEGenCfgModel genCfgModel = TEGenCfgDataMgr.getGenCfgMode((int)boardType);
            if (genCfgModel == null) continue;
            TEGenCfgFunCmd funCmd = TEPlanninDataHander.getFunCmd(ne);
            int iLength = this.dcmAttrs.length;
            for (int i = 0; i < iLength; ++i) {
                if (genCfgModel.getAttrFromId(this.dcmAttrs[i]) == null) continue;
                TIntObjectHashMap portAttrMap = TEGenCfgDataMgr.getPortAttrMap((int)neID, (String)this.dcmAttrs[i], (int)boardType);
                List<TEGenCfgPortAttribute> attributeList = TEPlanninDataHander.constructAttributeList((TIntObjectHashMap<List<TEGenCfgPortAttribute>>)portAttrMap);
                Set<Integer> logicPortIDSet = TEWDMInfScriptHandler.getLogicPortIDList(neID, slotid, boardType);
                for (TEGenCfgPortAttribute attribute : attributeList) {
                    if (!logicPortIDSet.contains(attribute.getPort())) continue;
                    TEGenAttrObjectValue genObj = TEWDMInfScriptHandler.constructAttrValue(neID, slotid, funCmd, this.dcmAttrs[i], attribute);
                    TEGeneralKeyValue key = new TEGeneralKeyValue();
                    key.setAttrID(this.intdcmAttrs[i]);
                    int portid = TEQueryPortForDataMgr.getAbstractPortID((int)neID, (int)genObj.getObjectID().getPortIDInInt());
                    int[] tEOBJECTID = new int[]{61509, neID, slotid, portid, genObj.getObjectID().getPathIDInInt()};
                    key.setTEOBJECTID(tEOBJECTID);
                    String attrValue = TEWDMInfUtil.getAttrValueFromDB_NoLock(key);
                    TEPortBufferKey portKey = new TEPortBufferKey(neID, slotid, portid);
                    ArrayList<String> dcmList = (ArrayList<String>)dcmMap.get(portKey);
                    if (dcmList == null) {
                        dcmList = new ArrayList<String>();
                        dcmMap.put(portKey, dcmList);
                    }
                    dcmList.add(i, attrValue);
                }
            }
        }
        this.writeCmd(dcmMap, item);
        return 0;
    }

    private void writeCmd(Map<TEPortBufferKey, List<String>> dcmMap, int item) {
        for (Map.Entry<TEPortBufferKey, List<String>> entry : dcmMap.entrySet()) {
            TEPortBufferKey key = entry.getKey();
            List<String> dcmValues = entry.getValue();
            TEScriptCmd cmd = new TEScriptCmd();
            cmd.setCmdCode(item);
            cmd.addPara(PARANAME_BOARD, String.valueOf(key.getSlotid()), false, false);
            cmd.addPara(PARANAME_SUBBOARD, 255, false, false);
            cmd.addPara(PARANAME_PORT, String.valueOf(TEConfigurationDataMgr.getPortRelativeID((int)key.getPortid())), false, false);
            cmd.addPara(PARANAME_DIRECTION, DIRECTION_IN, false, true);
            cmd.addPara(PARANAME_DCMTYPE1, dcmConverMap.get(dcmValues.get(0)), false, true);
            cmd.addPara(PARANAME_DCMTYPE2, dcmConverMap.get(dcmValues.get(1)), false, true);
            cmd.addPara(PARANAME_DCMTYPE3, dcmConverMap.get(dcmValues.get(2)), false, true);
            cmd.addPara(PARANAME_DCMTYPE4, dcmConverMap.get(dcmValues.get(3)), false, true);
            int result = TEScriptOperationMgr.getInstance().writeCommand(key.getNeid(), item, cmd);
            if (result != 0) {
                return;
            }
            cmd = new TEScriptCmd();
            cmd.setCmdCode(item);
            cmd.addPara(PARANAME_BOARD, String.valueOf(key.getSlotid()), false, false);
            cmd.addPara(PARANAME_SUBBOARD, 255, false, false);
            cmd.addPara(PARANAME_PORT, String.valueOf(TEConfigurationDataMgr.getPortRelativeID((int)key.getPortid())), false, false);
            cmd.addPara(PARANAME_DIRECTION, DIRECTION_OUT, false, true);
            cmd.addPara(PARANAME_DCMTYPE1, dcmConverMap.get(dcmValues.get(4)), false, true);
            cmd.addPara(PARANAME_DCMTYPE2, dcmConverMap.get(dcmValues.get(5)), false, true);
            cmd.addPara(PARANAME_DCMTYPE3, dcmConverMap.get(dcmValues.get(6)), false, true);
            cmd.addPara(PARANAME_DCMTYPE4, dcmConverMap.get(dcmValues.get(7)), false, true);
            TEScriptOperationMgr.getInstance().writeCommand(key.getNeid(), item, cmd);
            if (result == 0) continue;
            return;
        }
    }

    @Override
    protected TEGnlValueElement parseElementFromCmd(int neID, int attrID, String attrName, TEScriptCmd cmd) {
        TEGnlValueElement element = new TEGnlValueElement();
        TEGeneralKeyValue key = this.constructElementKey(neID, attrID, cmd);
        TEGeneralValue value = this.constructElementValue(attrID, cmd);
        element.setGnlKeyValue(key);
        element.setGnlValue(value);
        return element;
    }

    private TEGeneralKeyValue constructElementKey(int neID, int attrID, TEScriptCmd cmd) {
        TEGeneralKeyValue key = new TEGeneralKeyValue();
        key.setAttrID(attrID);
        int slotID = -1;
        int portID = -1;
        ArrayList paraValueList = new ArrayList();
        paraValueList.clear();
        boolean isParamExist = cmd.getPara(PARANAME_BOARD, paraValueList, false);
        if (isParamExist) {
            slotID = Integer.parseInt((String)paraValueList.get(0));
        }
        paraValueList.clear();
        isParamExist = cmd.getPara(PARANAME_PORT, paraValueList, false);
        if (isParamExist) {
            portID = Integer.parseInt((String)paraValueList.get(0));
        }
        TIntArrayList objIDList = new TIntArrayList();
        objIDList.add(61509);
        objIDList.add(neID);
        if (-1 != slotID) {
            objIDList.add(slotID);
        }
        if (-1 != portID) {
            portID = TEQueryPortForDataMgr.getAbstractPortID((int)neID, (int)portID);
            objIDList.add(portID);
        }
        objIDList.add(1);
        key.setTEOBJECTID(objIDList.toNativeArray());
        return key;
    }

    private TEGeneralValue constructElementValue(int attrID, TEScriptCmd cmd) {
        TEGeneralValue value = new TEGeneralValue();
        ArrayList paraValueList = new ArrayList();
        cmd.getPara(atrrsPara.get(attrID), paraValueList, false);
        String dcmKey = null;
        for (Map.Entry<String, String> entry : dcmConverMap.entrySet()) {
            if (!((String)paraValueList.get(0)).equalsIgnoreCase(entry.getValue())) continue;
            dcmKey = entry.getKey();
            break;
        }
        if (null != dcmKey) {
            value.setiValue(Integer.parseInt(dcmKey));
        }
        return value;
    }

    private String getDcmAttrValue(String attrName) {
        for (Map.Entry<String, String> entry : dcmConverMap.entrySet()) {
            if (!attrName.equalsIgnoreCase(entry.getValue())) continue;
            return entry.getKey();
        }
        return "";
    }

    @Override
    protected TEScriptCmd constractScriptCmd(int item, TEGenAttrObjectValue attrObjectValue) {
        return null;
    }

    @Override
    protected int getAttrID() {
        return 0;
    }

    @Override
    protected String getAttrName() {
        return null;
    }

    @Override
    protected int getObjTypeID() {
        return 0;
    }

    @Override
    protected String getObjTypeStr() {
        return null;
    }

    static {
        atrrsPara.put(272488, PARANAME_DCMTYPE1);
        atrrsPara.put(272489, PARANAME_DCMTYPE2);
        atrrsPara.put(272490, PARANAME_DCMTYPE3);
        atrrsPara.put(272491, PARANAME_DCMTYPE4);
        atrrsPara.put(272492, PARANAME_DCMTYPE1);
        atrrsPara.put(272493, PARANAME_DCMTYPE2);
        atrrsPara.put(272494, PARANAME_DCMTYPE3);
        atrrsPara.put(272495, PARANAME_DCMTYPE4);
        dcmConverMap = new HashMap<String, String>();
        dcmConverMap.put("0", "None");
        dcmConverMap.put("769", "DCM_S_G652");
        dcmConverMap.put("770", "DCM_T_G652");
        dcmConverMap.put("772", "DCM_A_G652");
        dcmConverMap.put("773", "DCM_B_G652");
        dcmConverMap.put("774", "DCM_C_G652");
        dcmConverMap.put("775", "DCM_D_G652");
        dcmConverMap.put("776", "DCM_E_G652");
        dcmConverMap.put("777", "DCM_F_G652");
        dcmConverMap.put("1028", "DCM_A_G655");
        dcmConverMap.put("1029", "DCM_B_G655");
        dcmConverMap.put("1030", "DCM_C_G655");
        dcmConverMap.put("1031", "DCM_D_G655");
        dcmConverMap.put("1032", "DCM_E_G655");
        dcmConverMap.put("1033", "DCM_F_G655");
        dcmConverMap.put("1281", "DCM_S_G653");
        dcmConverMap.put("1282", "DCM_T_G653");
        dcmConverMap.put("1283", "DCM_M_G653");
        dcmConverMap.put("1284", "DCM_A_G653");
        dcmConverMap.put("1543", "FBG_D_G652");
        dcmConverMap.put("1544", "FBG_E_G652");
        dcmConverMap.put("1545", "FBG_F_G652");
        dcmConverMap.put("1546", "FBG_G_G652");
        dcmConverMap.put("1547", "FBG_H_G652");
        dcmConverMap.put("1548", "FBG_I_G652");
        dcmConverMap.put("1549", "FBG_J_G652");
        dcmConverMap.put("1550", "FBG_L_G652");
        dcmConverMap.put("1801", "FBG_F_G655");
        dcmConverMap.put("1803", "FBG_H_G655");
        dcmConverMap.put("1805", "FBG_J_G655");
        dcmConverMap.put("1806", "FBG_L_G655");
        dcmConverMap.put("2052", "DCM_A_TWRS");
        dcmConverMap.put("2053", "DCM_B_TWRS");
        dcmConverMap.put("2054", "DCM_C_TWRS");
        dcmConverMap.put("2055", "DCM_D_TWRS");
        dcmConverMap.put("2056", "DCM_E_TWRS");
        dcmConverMap.put("2057", "DCM_F_TWRS");
    }
}

