/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.wdminterface.script;

import com.huawei.nglct.cbb.script.TEScriptCmd;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenAttrObjectValue;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenObjectID;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenValue;
import com.huawei.nglct.nemgr.ngwdm.inversemultifexing.db.TEBoundPathDbMgr;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.script.TEWDMInfMultiAttrScriptHandler;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEBoundPathMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEStringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class TEBoundPathScriptHandler
extends TEWDMInfMultiAttrScriptHandler {
    private static final int VOID_VALUE = 0;
    private static final int DIRECTION_DOUBLE = 0;
    private static final int DIRECTION_UP = 1;
    private static final int DIRECTION_DOWN = 2;
    private String[] bandArr = new String[]{"c+lband", "cband", "lband", "cband(320G)", "cband(raman)", "lband(raman)", "cwdmband", "smcband", "cband(96a)", "cband(plus)", "cband(192)"};
    private String[] isAble = new String[]{"disable", "enable"};
    private String[] fiberTypeConvert = new String[]{"255", "g652", "g653", "leaf", "tw_rs", "tw_c", "twplus", "smf_ls", "g654b", "g656", "g654a", "tera_light"};

    @Override
    protected void initExportKey() {
        this.exportKey = new HashMap();
        this.exportKey.put("W32BRD_ATTR_CFGUPDOWNWDMTYPE", "band");
        this.exportKey.put("W32BRD_ATTR_CFGUPDOWNWAVE", "wave");
        this.exportKey.put("W32BRD_ATTR_OSC_FECTH", "oscfecth");
        this.exportKey.put("W32PORT_ATTR_ALS_DELAY", "alsclosedelay");
        this.exportKey.put("W32PORT_ATTR_ALS_OPEN_DELAY", "alsopendelay");
        this.exportKey.put("W32PORT_ATTR_PORTBLOCKSTATE", "portblk");
        this.exportKey.put("W32PORT_ATTR_MAINBACKINIT", "mainbackinit");
        this.exportKey.put("W32PORT_ATTR_MAINBACKTH", "mainbackth");
        this.exportKey.put("W32PORT_ATTR_MACPORTEN", "mcaporten");
        this.exportKey.put("W32WAVE_ATTR_MONWAVELEN", "monwave");
        this.exportKey.put("W32PORT_ATTR_MUTLOSSIN", "losth");
        this.exportKey.put("W32PORT_ATTR_RATEDPOWER", "ratepow");
        this.exportKey.put("W32PORT_ATTR_PMDCOEF", "pmdcoef");
        this.exportKey.put("W32PORT_ATTR_DISPCOEF_EX", "dispcoef");
        this.exportKey.put("W32PORT_ATTR_FIBERTYPE", "fibertype");
        this.exportKey.put("W32PORT_ATTR_AUTOSHUT", "als");
        this.exportKey.put("W32PORT_ATTR_MAXWAVENUM", "maxwavenum");
        this.exportKey.put("W32PORT_ATTR_ALSCONDITION", "walscond");
        this.exportKey.put("W32BRD_ATTR_LPTENABLE", "lpt");
        this.exportKey.put("W32BRD_ATTR_OSC_DEGTH", "degth");
        this.exportKey.put("W32BRD_ATTR_OSC_MONTIME", "degtime");
        this.exportKey.put("W32PORT_ATTR_LSTATE", "laserstatus");
        this.exportKey.put("direction", "tsdirection");
        this.exportKey.put("boundpathnum", "tsnumber");
        this.exportKey.put("boundpath", "tsposition");
        this.exportKey.put("W32PORT_ATTR_FIBERLENGTH", "fiberlength");
    }

    @Override
    protected List<String> getAttrName() {
        ArrayList<String> attrNameList = new ArrayList<String>();
        attrNameList.add("W32BRD_ATTR_CFGUPDOWNWDMTYPE");
        attrNameList.add("W32BRD_ATTR_CFGUPDOWNWAVE");
        attrNameList.add("W32BRD_ATTR_OSC_FECTH");
        attrNameList.add("W32PORT_ATTR_ALS_DELAY");
        attrNameList.add("W32PORT_ATTR_ALS_OPEN_DELAY");
        attrNameList.add("W32PORT_ATTR_PORTBLOCKSTATE");
        attrNameList.add("W32PORT_ATTR_MAINBACKINIT");
        attrNameList.add("W32PORT_ATTR_MAINBACKTH");
        attrNameList.add("W32PORT_ATTR_MACPORTEN");
        attrNameList.add("W32WAVE_ATTR_MONWAVELEN");
        attrNameList.add("W32PORT_ATTR_MUTLOSSIN");
        attrNameList.add("W32PORT_ATTR_RATEDPOWER");
        attrNameList.add("W32PORT_ATTR_PMDCOEF");
        attrNameList.add("W32PORT_ATTR_DISPCOEF_EX");
        attrNameList.add("W32PORT_ATTR_FIBERTYPE");
        attrNameList.add("W32PORT_ATTR_AUTOSHUT");
        attrNameList.add("W32PORT_ATTR_MAXWAVENUM");
        attrNameList.add("W32PORT_ATTR_ALSCONDITION");
        attrNameList.add("W32BRD_ATTR_LPTENABLE");
        attrNameList.add("W32BRD_ATTR_OSC_DEGTH");
        attrNameList.add("W32BRD_ATTR_OSC_MONTIME");
        attrNameList.add("W32PORT_ATTR_LSTATE");
        attrNameList.add("W32PORT_ATTR_FIBERLENGTH");
        return attrNameList;
    }

    @Override
    protected void initConvertAttr() {
        this.convertAttrList = new ArrayList();
        this.convertAttrList.add("W32BRD_ATTR_CFGUPDOWNWDMTYPE");
        this.convertAttrList.add("W32BRD_ATTR_LPTENABLE");
        this.convertAttrList.add("W32PORT_ATTR_PORTBLOCKSTATE");
        this.convertAttrList.add("W32PORT_ATTR_MACPORTEN");
        this.convertAttrList.add("W32PORT_ATTR_MAXWAVENUM");
        this.convertAttrList.add("W32PORT_ATTR_FIBERTYPE");
        this.convertAttrList.add("W32BRD_ATTR_CFGUPDOWNWAVE");
        this.convertAttrList.add("W32PORT_ATTR_FIBERLENGTH");
    }

    @Override
    protected void initFilterCode() {
        this.filterCode = new ArrayList();
        this.filterCode.add("wave-2147483647");
        this.filterCode.add("W32PORT_ATTR_FIBERTYPE-255");
        this.filterCode.add("W32PORT_ATTR_MUTLOSSIN-2147483647");
        this.filterCode.add("W32PORT_ATTR_RATEDPOWER-2147483647");
        this.filterCode.add("W32BRD_ATTR_CFGUPDOWNWDMTYPE-2147483647");
        this.filterCode.add("W32BRD_ATTR_CFGUPDOWNWAVE-2147483647");
    }

    @Override
    protected void initNeedQuoteAttr() {
        this.needQuoteAttrs = new ArrayList();
        this.needQuoteAttrs.add("W32BRD_ATTR_CFGUPDOWNWDMTYPE");
    }

    @Override
    protected String convertAttrValue(String attrName, String attrValue) {
        int tmpvar = Integer.parseInt(attrValue);
        if (attrName.equals("W32BRD_ATTR_CFGUPDOWNWDMTYPE")) {
            attrValue = this.convertBandValue(tmpvar);
        } else if (attrName.equals("W32BRD_ATTR_LPTENABLE")) {
            attrValue = this.isAble[tmpvar];
        } else if (attrName.equals("W32PORT_ATTR_PORTBLOCKSTATE")) {
            attrValue = this.isAble[tmpvar];
        } else if (attrName.equals("W32PORT_ATTR_MACPORTEN")) {
            attrValue = this.isAble[tmpvar];
        } else if (attrName.equals("W32PORT_ATTR_MAXWAVENUM")) {
            attrValue = this.convertMaxWaveNum(tmpvar);
        } else if (attrName.equals("W32BRD_ATTR_CFGUPDOWNWAVE")) {
            attrValue = this.convertWave(tmpvar);
        } else if (attrName.equals("W32PORT_ATTR_FIBERTYPE")) {
            attrValue = this.fiberTypeConvert[tmpvar];
        } else if (attrName.equals("W32PORT_ATTR_FIBERLENGTH") && TEStringUtils.isNumeric((String)attrValue) && Long.parseLong(attrValue) < 0L) {
            long value = Long.parseLong(attrValue) + 0x100000000L;
            return String.valueOf(value);
        }
        return attrValue;
    }

    private String convertWave(int maxWaveNum) {
        int i = maxWaveNum % 65536;
        return String.valueOf(i);
    }

    private String convertMaxWaveNum(int maxWaveNum) {
        String tmpNum = "";
        if (maxWaveNum == 1) {
            tmpNum = "c40";
        } else if (maxWaveNum == 2) {
            tmpNum = "c80";
        } else if (maxWaveNum == 3) {
            tmpNum = "cwdm";
        }
        return tmpNum;
    }

    private String convertBandValue(int band) {
        String tmpBand = "";
        tmpBand = this.bandArr[band];
        return tmpBand;
    }

    @Override
    protected void addDataToMap(int neID, int item, HashMap<String, List<TEGenAttrObjectValue>> attrMap) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        List<TEBoundPathMOPO> tdcMOList = TEBoundPathDbMgr.getBoundPathMOFromDB(neID, errRet);
        for (TEBoundPathMOPO bpathmo : tdcMOList) {
            StringBuffer keyValueSB = new StringBuffer();
            keyValueSB.append(neID).append("-");
            keyValueSB.append(bpathmo.getSlotID()).append("-");
            keyValueSB.append(bpathmo.getPortID()).append("-");
            keyValueSB.append(bpathmo.getPathID()).append("-");
            keyValueSB.append(bpathmo.getTsdirection());
            String keyValue = keyValueSB.toString();
            TEGenObjectID objid = new TEGenObjectID(neID, bpathmo.getSlotID(), bpathmo.getPortID(), bpathmo.getPathID());
            TEGenAttrObjectValue directionValue = new TEGenAttrObjectValue();
            ArrayList<TEGenValue> attrIDList = new ArrayList<TEGenValue>();
            TEGenValue teGgenValue = new TEGenValue();
            teGgenValue.setAttrName("direction");
            teGgenValue.setValue(this.convertBoundDirection(bpathmo.getTsdirection()));
            attrIDList.add(teGgenValue);
            directionValue.setAttrIDList(attrIDList);
            directionValue.setObjectID(objid);
            TEGenAttrObjectValue boundpathnumValue = new TEGenAttrObjectValue();
            attrIDList = new ArrayList();
            teGgenValue = new TEGenValue();
            teGgenValue.setAttrName("boundpathnum");
            teGgenValue.setValue(bpathmo.getTsnumber() + "");
            attrIDList.add(teGgenValue);
            boundpathnumValue.setAttrIDList(attrIDList);
            boundpathnumValue.setObjectID(objid);
            TEGenAttrObjectValue boundpathValue = new TEGenAttrObjectValue();
            attrIDList = new ArrayList();
            teGgenValue = new TEGenValue();
            teGgenValue.setAttrName("boundpath");
            teGgenValue.setValue(this.convertBoundPath(bpathmo.getTsposition()));
            attrIDList.add(teGgenValue);
            boundpathValue.setAttrIDList(attrIDList);
            boundpathValue.setObjectID(objid);
            ArrayList<TEGenAttrObjectValue> tmpKeyList = new ArrayList<TEGenAttrObjectValue>();
            tmpKeyList.add(directionValue);
            tmpKeyList.add(boundpathnumValue);
            tmpKeyList.add(boundpathValue);
            attrMap.put(keyValue, tmpKeyList);
        }
    }

    private String convertBoundDirection(int direction) {
        String tmpDirection = "";
        if (0 == direction) {
            tmpDirection = "double";
        } else if (1 == direction) {
            tmpDirection = "up";
        } else if (2 == direction) {
            tmpDirection = "down";
        }
        return tmpDirection;
    }

    private String convertBoundPath(String boundPath) {
        ArrayList<Integer> tmpList = new ArrayList<Integer>();
        byte[] bValue = boundPath.getBytes();
        int nCount = 2;
        int nPos = 0;
        int nParaSize = bValue.length;
        while (nPos + nCount <= nParaSize) {
            byte[] bTmp = new byte[2];
            System.arraycopy(bValue, nPos + 0, bTmp, 0, 2);
            int pathId = IOStreamConvertor.readPositiveShort((byte[])bTmp, (int)0);
            if (0 != pathId) {
                tmpList.add(pathId);
            }
            nPos += nCount;
        }
        Collections.sort(tmpList);
        StringBuffer sb = new StringBuffer();
        int len = tmpList.size();
        for (int l = 0; l < len - 1; ++l) {
            sb.append(tmpList.get(l)).append("&");
        }
        sb.append(tmpList.get(tmpList.size() - 1));
        return sb.toString();
    }

    @Override
    protected boolean isPrintPath() {
        return false;
    }

    @Override
    protected void addSubborad(TEScriptCmd cmd) {
        cmd.addPara("subbd", 255, false, false);
    }

    @Override
    protected boolean isSupportExport(TEBoard board, String attrName) {
        if ("W32PORT_ATTR_MUTLOSSIN".equals(attrName)) {
            return board.getBoardType() == 2337 || board.getBoardType() == 1207 || board.getBoardType() == 944 || board.getBoardType() == 943 || board.getBoardType() == 1206;
        }
        return true;
    }
}

